// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_SHADER_H
#define _CLUTTERMM_SHADER_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <clutter/clutter.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterShader ClutterShader;
typedef struct _ClutterShaderClass ClutterShaderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Shader_Class; } // namespace Clutter
namespace Clutter
{


class Shader : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Shader CppObjectType;
  typedef Shader_Class CppClassType;
  typedef ClutterShader BaseObjectType;
  typedef ClutterShaderClass BaseClassType;

private:  friend class Shader_Class;
  static CppClassType shader_class_;

private:
  // noncopyable
  Shader(const Shader&);
  Shader& operator=(const Shader&);

protected:
  explicit Shader(const Glib::ConstructParams& construct_params);
  explicit Shader(ClutterShader* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Shader();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterShader*       gobj()       { return reinterpret_cast<ClutterShader*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterShader* gobj() const { return reinterpret_cast<ClutterShader*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterShader* gobj_copy();

private:


protected:
  Shader();

public:
  
  static Glib::RefPtr<Shader> create();


  /** Sets the GLSL source code to be used by a Shader for the vertex program.
   * @param source_code The GLSL source code.
   */
  void set_vertex_source(const std::string& source_code);
  

  /** Query the current GLSL vertex source set on @a shader.
   * @return The source of the vertex shader for this
   * ClutterShader object or <tt>0</tt>. The returned string is owned by the
   * shader object and should never be modified or freed
   * 
   * Since: 0.6.
   */
  std::string get_vertex_source() const;

    //TODO: Documentation:
  /** Sets the GLSL source code to be used by a Shader for the fragment
   * program.
   * @param source_code The GLSL source code.
   */
  void set_fragment_source(const std::string& source_code);
  

  /** Query the current GLSL fragment source set on @a shader.
   * @return The source of the fragment shader for this
   * ClutterShader object or <tt>0</tt>. The returned string is owned by the
   * shader object and should never be modified or freed
   * 
   * Since: 0.6.
   */
  std::string get_fragment_source() const;

  
  /** Compiles and links GLSL sources set for vertex and fragment shaders for
   * a Clutter::Shader. If the compilation fails and a Error return location is
   * provided the error will contain the errors from the compiler, if any.
   * @return Returns <tt>true</tt> if the shader was succesfully compiled.
   * 
   * Since: 0.8.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool compile();
#else
  bool compile(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Checks whether @a shader is is currently compiled, linked and bound
   * to the GL context.
   * @return <tt>true</tt> if the shader is compiled, linked and ready for use.
   * 
   * Since: 0.8.
   */
  bool is_compiled() const;
  
  /** Frees up any GL context resources held by the shader.
   * 
   * Since: 0.6
   */
  void release();
  
  /** Enables a shader. This function will attempt to compile and link
   * the shader, if it isn't already.
   * 
   * When @a enabled is <tt>false</tt> the default state of the GL pipeline will be
   * used instead.
   * 
   * Since: 0.6
   * @param enabled The new state of the shader.
   */
  void set_is_enabled(bool enabled = true);
  
  /** Checks whether @a shader is enabled.
   * @return <tt>true</tt> if the shader is enabled.
   * 
   * Since: 0.6.
   */
  bool get_is_enabled() const;
  
  /** Sets a user configurable variable in the GLSL shader programs attached to
   * a Clutter::Shader.
   * 
   * Since: 1.0
   * @param name Name of uniform in GLSL shader program to set.
   * @param value A Clutter::ShaderFloat, Clutter::ShaderInt or Clutter::ShaderMatrix
   * Value.
   */
  void set_uniform(const Glib::ustring& name, const Glib::ValueBase& value);
  
  /** Retrieves the underlying Cogl::Handle for the shader program.
   * @return A Cogl::Handle for the shader program, or <tt>0</tt>
   * 
   * Since: 1.0.
   */
  CoglHandle get_cogl_program() const;
  
  /** Retrieves the underlying Cogl::Handle for the vertex shader.
   * @return A Cogl::Handle for the vertex shader, or <tt>0</tt>
   * 
   * Since: 1.0.
   */
  CoglHandle get_cogl_vertex_shader() const;
  
  /** Retrieves the underlying Cogl::Handle for the fragment shader.
   * @return A Cogl::Handle for the fragment shader, or <tt>0</tt>
   * 
   * Since: 1.0.
   */
  CoglHandle get_cogl_fragment_shader() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the shader is compiled and linked.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_compiled() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the shader is enabled.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_enabled() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the shader is enabled.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_enabled() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Source of fragment shader.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<std::string> property_fragment_source() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Source of fragment shader.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<std::string> property_fragment_source() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Source of vertex shader.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<std::string> property_vertex_source() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Source of vertex shader.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<std::string> property_vertex_source() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter
// vim:ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Shader
   */
  Glib::RefPtr<Clutter::Shader> wrap(ClutterShader* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_SHADER_H */

