// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_STAGE_H
#define _CLUTTERMM_STAGE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/group.h>
#include <cluttermm/color.h>
#include <clutter/clutter.h> // For ClutterPerspective
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterStage ClutterStage;
typedef struct _ClutterStageClass ClutterStageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Stage_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums Enums and Flags */

/**
 * @ingroup cluttermmEnums
 */
enum PickMode
{
  PICK_NONE,
  PICK_REACTIVE,
  PICK_ALL
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::PickMode> : public Glib::Value_Enum<Clutter::PickMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


typedef ClutterFog Fog;

class Perspective
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Perspective CppObjectType;
  typedef ClutterPerspective BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Perspective();

  explicit Perspective(const ClutterPerspective* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterPerspective*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterPerspective* gobj() const { return &gobject_; }

protected:
  ClutterPerspective gobject_;

private:
  
public:
  Perspective(Cogl::Fixed fovy, Cogl::Fixed aspect, Cogl::Fixed z_near, Cogl::Fixed z_far);

   Cogl::Fixed get_fovy() const;
    void set_fovy(const Cogl::Fixed& value);
    Cogl::Fixed get_aspect() const;
    void set_aspect(const Cogl::Fixed& value);
    Cogl::Fixed get_z_near() const;
    void set_z_near(const Cogl::Fixed& value);
    Cogl::Fixed get_z_far() const;
    void set_z_far(const Cogl::Fixed& value);
 

};


class Stage :
  public Group
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Stage CppObjectType;
  typedef Stage_Class CppClassType;
  typedef ClutterStage BaseObjectType;
  typedef ClutterStageClass BaseClassType;

private:  friend class Stage_Class;
  static CppClassType stage_class_;

private:
  // noncopyable
  Stage(const Stage&);
  Stage& operator=(const Stage&);

protected:
  explicit Stage(const Glib::ConstructParams& construct_params);
  explicit Stage(ClutterStage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Stage();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterStage*       gobj()       { return reinterpret_cast<ClutterStage*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterStage* gobj() const { return reinterpret_cast<ClutterStage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterStage* gobj_copy();

private:


protected:
  Stage();

public:
 

  /** Return value: (transfer none): the main Clutter::Stage.  You should never
   * @return (transfer none): the main Clutter::Stage.  You should never
   * destroy or unref the returned actor.
   */
  static Glib::RefPtr<Stage> get_default();
  
  /** Sets the stage color.
   * @param color A Clutter::Color.
   */
  void set_color(const Color& color);
  
  /** Retrieves the stage color.
   * @param color Return location for a Clutter::Color.
   */

  Color get_color() const;

 
  /** Sets the stage perspective.
   * @param perspective A Clutter::Perspective.
   */
  void set_perspective(const Perspective& prespective);
  
  /** Retrieves the stage perspective.
   * @param perspective Return location for a Clutter::Perspective.
   */
  void get_perspective(Perspective& prespective);
  //gtkmmproc error: clutter_stage_fullscreen : method defs lookup failed (1)
  //gtkmmproc error: clutter_stage_unfullscreen : method defs lookup failed (1)
  
  /** Shows the cursor on the stage window
   */
  void show_cursor();
  
  /** Makes the cursor invisible on the stage window
   * 
   * @newin{0,4}
   */
  void hide_cursor();
  
  /** Gets the stage title.
   * @return Pointer to the title string for the stage. The
   * returned string is owned by the actor and should not
   * be modified or freed.
   * 
   * @newin{0,4}.
   */
  Glib::ustring get_title() const;
  
  /** Sets the stage title.
   * 
   * @newin{0,4}
   * @param title A utf8 string for the stage windows title.
   */
  void set_title(const Glib::ustring& title);
  
  /** Sets if the stage is resizable by user interaction (e.g.\ via
   * window manager controls)
   * 
   * @newin{0,4}
   * @param resizable Whether the stage should be user resizable.
   */
  void set_user_resizable(bool value);
  
  /** Retrieves the value set with set_user_resizable().
   * @return <tt>true</tt> if the stage is resizable by the user.
   * 
   * @newin{0,4}.
   */
  bool get_user_resizable() const;

  
  /** Checks the scene at the coordinates @a x and @a y and returns a pointer
   * to the Clutter::Actor at those coordinates.
   * 
   * By using @a pick_mode it is possible to control which actors will be
   * painted and thus available.
   * @param pick_mode How the scene graph should be painted.
   * @param x X coordinate to check.
   * @param y Y coordinate to check.
   * @return (transfer none): the actor at the specified coordinates,
   * if any.
   */
  Glib::RefPtr<Actor> get_actor_at_pos(PickMode pick_mode, int x, int y);
  
  /** Checks the scene at the coordinates @a x and @a y and returns a pointer
   * to the Clutter::Actor at those coordinates.
   * 
   * By using @a pick_mode it is possible to control which actors will be
   * painted and thus available.
   * @param pick_mode How the scene graph should be painted.
   * @param x X coordinate to check.
   * @param y Y coordinate to check.
   * @return (transfer none): the actor at the specified coordinates,
   * if any.
   */
  Glib::RefPtr<const Actor> get_actor_at_pos(PickMode pick_mode, int x, int y) const;

  
  /** Retrieves the actor that is currently under key focus.
   * @return (transfer none): the actor with key focus, or the stage
   * 
   * @newin{0,6}.
   */
  Glib::RefPtr<Actor> get_key_focus();
  
  /** Retrieves the actor that is currently under key focus.
   * @return (transfer none): the actor with key focus, or the stage
   * 
   * @newin{0,6}.
   */
  Glib::RefPtr<const Actor> get_key_focus() const;

  
  /** Sets the key focus on @a actor. An actor with key focus will receive
   * all the key events. If @a actor is <tt>0</tt>, the stage will receive
   * focus.
   * 
   * @newin{0,6}
   * @param actor The actor to set key focus to, or <tt>0</tt>.
   */
  void set_key_focus(const Glib::RefPtr<Actor>& actor);
  void set_key_focus();

  // TODO: Should we rather wrap this as std::string, or
  // as std::vector<unsigned char>, or Glib::ArrayHandle<guchar>?
  
  /** Makes a screenshot of the stage in RGBA 8bit data, returns a
   * linear buffer with @a width * 4 as rowstride.
   * 
   * The alpha data contained in the returned buffer is driver-dependent,
   * and not guaranteed to hold any sensible value.
   * @param x X coordinate of the first pixel that is read from stage.
   * @param y Y coordinate of the first pixel that is read from stage.
   * @param width Width dimention of pixels to be read, or -1 for the
   * entire stage width.
   * @param height Height dimention of pixels to be read, or -1 for the
   * entire stage height.
   * @return A pointer to newly allocated memory with the buffer
   * or <tt>0</tt> if the read failed. Use Glib::free() on the returned data
   * to release the resources it has allocated.
   */
  guchar* read_pixels(int x, int y, int width, int height) const;
  
  /** Gets whether the depth cueing effect is enabled on @a stage.
   * @return <tt>true</tt> if the the depth cueing effect is enabled
   * 
   * @newin{0,6}.
   */
  bool get_use_fog() const;
  
  /** Sets whether the depth cueing effect on the stage should be enabled
   * or not.
   * 
   * Depth cueing is a 3D effect that makes actors farther away from the
   * viewing point less opaque, by fading them with the stage color.
   * 
   * The parameters of the GL fog used can be changed using the
   * set_fog() function.
   * 
   * @newin{0,6}
   * @param fog <tt>true</tt> for enabling the depth cueing effect.
   */
  void set_use_fog(bool fog = true);
 

  /** Sets the fog (also known as "depth cueing") settings for the @a stage.
   * 
   * A Clutter::Stage will only use a linear fog progression, which
   * depends solely on the distance from the viewer. The cogl_set_fog()
   * function in COGL exposes more of the underlying implementation,
   * and allows changing the for progression function. It can be directly
   * used by disabling the Clutter::Stage:use-fog property and connecting
   * a signal handler to the Clutter::Actor::paint signal on the @a stage.
   * 
   * @note The fogging functions only work correctly when the visible actors use
   * unmultiplied alpha colors. By default Cogl will premultiply textures
   * and cogl_set_source_color will premultiply colors, so unless you
   * explicitly load your textures requesting an unmultiplied
   * internal_format and use cogl_material_set_color you can only use
   * fogging with fully opaque actors.
   * 
   * We can look to improve this in the future when we can depend on
   * fragment shaders.
   * 
   * @newin{0,6}
   * @param fog A Clutter::Fog structure.
   */
  void set_fog(const Fog& fog);
  
  /** Retrieves the current depth cueing settings from the stage.
   * 
   * @newin{0,6}
   * @param fog Return location for a Clutter::Fog structure.
   */
  void get_fog(Fog& fog) const;
  
  
  /** This function is used to emit an event on the main stage.
   * 
   * You should rarely need to use this function, except for
   * synthetised events.
   * @param event A Clutter::Event.
   * @return The return value from the signal emission
   * 
   * @newin{0,4}.
   */
  void stage_event(Event* event);
  
  /** Checks if @a stage is the default stage, or an instance created using
   * new() but internally using the same implementation.
   * @return <tt>true</tt> if the passed stage is the default one
   * 
   * @newin{0,8}.
   */
  bool is_default() const;
  
  /** This function essentially makes sure the right GL context is
   * current for the passed stage. It is not intended to
   * be used by applications.
   * 
   * @newin{0,8}
   */
  void ensure_current();
  
  /** Ensures that the GL viewport is updated with the current
   * stage window size.
   * 
   * This function will queue a redraw of @a stage.
   * 
   * This function should not be called by applications; it is used
   * when embedding a Clutter::Stage into a toolkit with another
   * windowing system, like GTK+.
   * 
   * @newin{1,0}
   */
  void ensure_viewport();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%fullscreen()</tt>
   */

  Glib::SignalProxy0< void > signal_fullscreen();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%unfullscreen()</tt>
   */

  Glib::SignalProxy0< void > signal_unfullscreen();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%deactivate()</tt>
   */

  Glib::SignalProxy0< void > signal_deactivate();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The color of the stage.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Color> property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The color of the stage.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Color> property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the mouse pointer is visible on the main stage .
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_cursor_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the mouse pointer is visible on the main stage .
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_cursor_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage is fullscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_fullscreen() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage is fullscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_fullscreen() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage is renderer offscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_offscreen() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage is renderer offscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_offscreen() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Stage Title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Stage Title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable depth cueing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_fog() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable depth cueing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_fog() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage is able to be resized via user interaction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_user_resizable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage is able to be resized via user interaction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_user_resizable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  // From the Clutter Docs:
  // Applications should call clutter_actor_queue_redraw and not this function.
  //_WRAP_METHOD(void queue_redraw(), clutter_stage_queue_redraw)
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_fullscreen();
  virtual void on_unfullscreen();
  virtual void on_activate();
  virtual void on_deactivate();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter

//vim: ts=2,sw=2


namespace Glib
{

/** @relates Clutter::Perspective
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Perspective& wrap(ClutterPerspective* object);

/** @relates Clutter::Perspective
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Perspective& wrap(const ClutterPerspective* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Perspective> : public Glib::Value_Boxed<Clutter::Perspective>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Stage
   */
  Glib::RefPtr<Clutter::Stage> wrap(ClutterStage* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_STAGE_H */

