// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TEXT_H
#define _CLUTTERMM_TEXT_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <cluttermm/actor.h>
#include <cluttermm/color.h>
#include <pangomm.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterText ClutterText;
typedef struct _ClutterTextClass ClutterTextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Text_Class; } // namespace Clutter
namespace Clutter
{


class Text : public Actor
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Text CppObjectType;
  typedef Text_Class CppClassType;
  typedef ClutterText BaseObjectType;
  typedef ClutterTextClass BaseClassType;

private:  friend class Text_Class;
  static CppClassType text_class_;

private:
  // noncopyable
  Text(const Text&);
  Text& operator=(const Text&);

protected:
  explicit Text(const Glib::ConstructParams& construct_params);
  explicit Text(ClutterText* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Text();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterText*       gobj()       { return reinterpret_cast<ClutterText*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterText* gobj() const { return reinterpret_cast<ClutterText*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterText* gobj_copy();

private:


protected:
  Text();
  explicit Text(const Glib::ustring& font_name, const Glib::ustring& text);
  explicit Text(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color);

public:
  
  static Glib::RefPtr<Text> create();

  
  static Glib::RefPtr<Text> create(const Glib::ustring& font_name, const Glib::ustring& text);

  
  static Glib::RefPtr<Text> create(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color);


  /** Sets the contents of a Clutter::Text actor.
   * 
   * @newin{1,0}
   * @param text The text to set. Passing <tt>0</tt> is the same as passing "" (the
   * empty string).
   */
  void set_text(const Glib::ustring& text);
  
  /** Sets @a markup as the contents of a Clutter::Text.
   * 
   * This is a convenience function for setting a string containing
   * Pango markup, and it is logically equivalent to:
   * 
   * |[
   * clutter_text_set_use_markup (CLUTTER_TEXT (actor), <tt>true</tt>);
   * clutter_text_set_text (CLUTTER_TEXT (actor), markup);
   * ]|
   * 
   * @newin{1,0}
   * @param markup A string containing Pango markup. Passing <tt>0</tt> is the same
   * as passing "" (the empty string).
   */
  void set_markup(const Glib::ustring& markup);
  
  /** Retrieves a pointer to the current contents of a Clutter::Text
   * actor.
   * 
   * If you need a copy of the contents for manipulating, either
   * use Glib::strdup() on the returned string, or use:
   * 
   * |[
   * copy = clutter_text_get_chars (text, 0, -1);
   * ]|
   * 
   * Which will return a newly allocated string.
   * @return The contents of the actor. The returned string
   * is owned by the Clutter::Text actor and should never be
   * modified or freed
   * 
   * @newin{1,0}.
   */
  Glib::ustring get_text() const;

  
  /** Sets whether a Clutter::Text actor should be activatable.
   * 
   * An activatable Clutter::Text actor will emit the Clutter::Text::activate
   * signal whenever the 'Enter' (or 'Return') key is pressed; if it is not
   * activatable, a new line will be appended to the current content.
   * 
   * An activatable Clutter::Text must also be set as editable using
   * set_editable().
   * 
   * @newin{1,0}
   * @param activatable Whether the Clutter::Text actor should be activatable.
   */
  void set_activatable(bool activatable=true);
  
  /** Retrieves whether a Clutter::Text is activatable or not.
   * @return <tt>true</tt> if the actor is activatable
   * 
   * @newin{1,0}.
   */
  bool get_activatable() const;

  
  /** Sets the attributes list that are going to be applied to the
   * Clutter::Text contents.
   * 
   * The Clutter::Text actor will take a reference on the Pango::AttrList
   * passed to this function.
   * 
   * @newin{1,0}
   * @param attrs A Pango::AttrList or <tt>0</tt> to unset the attributes.
   */
  void set_attributes(Pango::AttrList& attrs);
  
  /** Gets the attribute list that was set on the Clutter::Text actor
   * set_attributes(), if any.
   * @return (transfer none): the attribute list, or <tt>0</tt> if none was set. The
   * returned value is owned by the Clutter::Text and should not be unreferenced.
   * 
   * @newin{1,0}.
   */
  Pango::AttrList get_attributes();

  
  /** Sets the color of the contents of a Clutter::Text actor.
   * 
   * The overall opacity of the Clutter::Text actor will be the
   * result of the alpha value of @a color and the composited
   * opacity of the actor itself on the scenegraph, as returned
   * by Clutter::Actor::get_paint_opacity().
   * 
   * @newin{1,0}
   * @param color A Clutter::Color.
   */
  void set_color(const Color& color);
  
  /** Retrieves the text color as set by get_color().
   * 
   * @newin{1,0}
   * @param color Return location for a Clutter::Color.
   */

  Color get_color() const;
  

  /** Sets the mode used to ellipsize (add an ellipsis: "...") to the
   * text if there is not enough space to render the entire contents
   * of a Clutter::Text actor
   * 
   * @newin{1,0}
   * @param mode A Pango::EllipsizeMode.
   */
  void set_ellipsize(Pango::EllipsizeMode mode);
  
  /** Return value: Pango::EllipsizeMode
   * @return Pango::EllipsizeMode
   * 
   * @newin{1,0}.
   */
  Pango::EllipsizeMode get_ellipsize();

  
  /** Sets the font used by a Clutter::Text. The @a font_name string
   * must either be <tt>0</tt>, which means that the font name from the
   * default Clutter::Backend will be used; or be something that can
   * be parsed by the pango_font_description_from_string() function,
   * like:
   * 
   * |[
   * clutter_text_set_font_name (text, "Sans 10pt");
   * clutter_text_set_font_name (text, "Serif 16px");
   * clutter_text_set_font_name (text, "Helvetica 10");
   * ]|
   * 
   * @newin{1,0}
   * @param font_name A font name, or <tt>0</tt> to set the default font name.
   */
  void set_font_name(const Glib::ustring& font_name);
  
  /** Retrieves the font name as set by set_font_name().
   * @return A string containing the font name. The returned
   * string is owned by the Clutter::Text actor and should not be
   * modified or freed
   * 
   * @newin{1,0}.
   */
  Glib::ustring get_font_name() const;

  
  /** Sets the character to use in place of the actual text in a
   * password text actor.
   * 
   * If @a wc is 0 the text will be displayed as it is entered in the
   * Clutter::Text actor.
   * 
   * @newin{1,0}
   * @param wc A Unicode character, or 0 to unset the password character.
   */
  void set_password_char(gunichar wc);
  
  /** Retrieves the character to use in place of the actual text
   * as set by set_password_char().
   * @return A Unicode character or 0 if the password
   * character is not set
   * 
   * @newin{1,0}.
   */
  gunichar get_password_char() const;

  
  /** Sets whether the text of the Clutter::Text actor should be justified
   * on both margins. This setting is ignored if Clutter is compiled
   * against Pango < 1.18.
   * 
   * @newin{1,0}
   * @param justify Whether the text should be justified.
   */
  void set_justify(bool justify=true);
  
  /** Retrieves whether the Clutter::Text actor should justify its contents
   * on both margins.
   * @return <tt>true</tt> if the text should be justified
   * 
   * @newin{0,6}.
   */
  bool get_justify() const;

  
  /** Retrieves the current Pango::Layout used by a Clutter::Text actor.
   * @return (transfer none): a Pango::Layout. The returned object is owned by
   * the Clutter::Text actor and should not be modified or freed
   * 
   * @newin{1,0}.
   */
  Glib::RefPtr<Pango::Layout> get_layout();
  
  /** Retrieves the current Pango::Layout used by a Clutter::Text actor.
   * @return (transfer none): a Pango::Layout. The returned object is owned by
   * the Clutter::Text actor and should not be modified or freed
   * 
   * @newin{1,0}.
   */
  Glib::RefPtr<const Pango::Layout> get_layout() const;

  
  /** Sets the way that the lines of a wrapped label are aligned with
   * respect to each other. This does not affect the overall alignment
   * of the label within its allocated or specified width.
   * 
   * To align a Clutter::Text actor you should add it to a container
   * that supports alignment, or use the anchor point.
   * 
   * @newin{1,0}
   * @param alignment A Pango::Alignment.
   */
  void set_line_alignment(Pango::Alignment alignment);
  
  /** Retrieves the alignment of a Clutter::Text, as set by
   * set_line_alignment().
   * @return A Pango::Alignment
   * 
   * Since 1.0.
   */
  Pango::Alignment get_line_alignment() const;

  
  /** Sets whether the contents of a Clutter::Text actor should wrap,
   * if they don't fit the size assigned to the actor.
   * 
   * @newin{1,0}
   * @param line_wrap Whether the contents should wrap.
   */
  void set_line_wrap(bool line_wrap=true);
  
  /** Retrieves the value set using set_line_wrap().
   * @return <tt>true</tt> if the Clutter::Text actor should wrap
   * its contents
   * 
   * @newin{1,0}.
   */
  bool get_line_wrap() const;

  
  /** Retrieves the line wrap mode used by the Clutter::Text actor.
   * 
   * See set_line_wrap_mode().
   * @return The wrap mode used by the Clutter::Text
   * 
   * @newin{1,0}.
   */
  Pango::WrapMode get_line_wrap_mode() const;
  
  /** If line wrapping is enabled (see set_line_wrap()) this
   * function controls how the line wrapping is performed. The default is
   * Pango::WRAP_WORD which means wrap on word boundaries.
   * 
   * @newin{1,0}
   * @param wrap_mode The line wrapping mode.
   */
  void set_line_wrap_mode(Pango::WrapMode wrap_mode);

  
  /** Gets the maximum length of text that can be set into a text actor.
   * 
   * See set_max_length().
   * @return The maximum number of characters.
   * 
   * @newin{1,0}.
   */
  int get_max_length() const;
  
  /** Sets the maximum allowed length of the contents of the actor. If the
   * current contents are longer than the given length, then they will be
   * truncated to fit.
   * 
   * @newin{1,0}
   * @param max The maximum number of characters allowed in the text actor; 0
   * to disable or -1 to set the length of the current string.
   */
  void set_max_length(int max_length);

  
  /** Sets whether a Clutter::Text actor should be selectable.
   * 
   * A selectable Clutter::Text will allow selecting its contents using
   * the pointer or the keyboard.
   * 
   * @newin{1,0}
   * @param selectable Whether the Clutter::Text actor should be selectable.
   */
  void set_selectable(bool selectable=true);
  
  /** Retrieves whether a Clutter::Text is selectable or not.
   * @return <tt>true</tt> if the actor is selectable
   * 
   * @newin{1,0}.
   */
  bool get_selectable() const;

  
  /** Selects the region of text between @a start_pos and @a end_pos.
   * 
   * This function changes the position of the cursor to match
   *  @a start_pos and the selection bound to match @a end_pos.
   * 
   * @newin{1,0}
   * @param start_pos Start of the selection, in characters.
   * @param end_pos End of the selection, in characters.
   */
  void set_selection(gssize start_pos, gssize end_pos);
  
  /** Retrieves the currently selected text.
   * @return A newly allocated string containing the currently
   * selected text, or <tt>0</tt>. Use Glib::free() to free the returned
   * string.
   * 
   * @newin{1,0}.
   */
  Glib::ustring get_selection() const;

  
  /** Sets the other end of the selection, starting from the current
   * cursor position.
   * 
   * If @a selection_bound is -1, the selection unset.
   * 
   * @newin{1,0}
   * @param selection_bound The position of the end of the selection, in characters.
   */
  void set_selection_bound(int selection_bound);
  
  /** Retrieves the other end of the selection of a Clutter::Text actor,
   * in characters from the current cursor position.
   * @return The position of the other end of the selection
   * 
   * @newin{1,0}.
   */
  int get_selection_bound() const;

  
  /** Sets the color of the selection of a Clutter::Text actor.
   * 
   * If @a color is <tt>0</tt>, the selection color will be the same as the
   * cursor color, or if no cursor color is set either then it will be
   * the same as the text color.
   * 
   * @newin{1,0}
   * @param color The color of the selection, or <tt>0</tt> to unset it.
   */
  void set_selection_color(const Color& color);
  
  /** Retrieves the color of the selection of a Clutter::Text actor.
   * 
   * @newin{1,0}
   * @param color Return location for a Clutter::Color.
   */

  Color get_selection_color() const;
  

  /** Sets whether a Clutter::Text actor should be in single line mode
   * or not.
   * 
   * A text actor in single line mode will not wrap text and will clip
   * the the visible area to the predefined size. The contents of the
   * text actor will scroll to display the end of the text if its length
   * is bigger than the allocated width.
   * 
   * When setting the single line mode the Clutter::Text:activatable
   * property is also set as a side effect. Instead of entering a new
   * line character, the text actor will emit the Clutter::Text::activate
   * signal.
   * 
   * @newin{1,0}
   * @param single_line Whether to enable single line mode.
   */
  void set_single_line_mode(bool single_line=true);
  
  /** Retrieves whether the Clutter::Text actor is in single line mode.
   * @return <tt>true</tt> if the Clutter::Text actor is in single line mode
   * 
   * @newin{1,0}.
   */
  bool get_single_line_mode() const;

  
  /** Sets whether the contents of the Clutter::Text actor contains markup
   * in <link linkend="PangoMarkupFormat">Pango's text markup language</link>.
   * 
   * Setting Clutter::Text:use-markup on an editable Clutter::Text will
   * make the actor discard any markup.
   * 
   * @newin{1,0}
   * @param setting <tt>true</tt> if the text should be parsed for markup.
   */
  void set_use_markup(bool setting=true);
  
  /** Retrieves whether the contents of the Clutter::Text actor should be
   * parsed for the Pango text markup.
   * @return <tt>true</tt> if the contents will be parsed for markup
   * 
   * @newin{1,0}.
   */
  bool get_use_markup() const;

  
  /** Sets whether the Clutter::Text actor should be editable.
   * 
   * An editable Clutter::Text with key focus set using
   * Clutter::Actor::grab_key_focus() or clutter_stage_take_key_focus()
   * will receive key events and will update its contents accordingly.
   * 
   * @newin{1,0}
   * @param editable Whether the Clutter::Text should be editable.
   */
  void set_editable(bool editable=true);
  
  /** Retrieves whether a Clutter::Text is editable or not.
   * @return <tt>true</tt> if the actor is editable
   * 
   * @newin{1,0}.
   */
  bool get_editable() const;

  
  /** Inserts @a wc at the current cursor position of a
   * Clutter::Text actor.
   * 
   * @newin{1,0}
   * @param wc A Unicode character.
   */
  void insert(gunichar wc);
  
  /** Inserts @a text into a Clutter::Actor at the given position.
   * 
   * If @a position is a negative number, the text will be appended
   * at the end of the current contents of the Clutter::Text.
   * 
   * The position is expressed in characters, not in bytes.
   * 
   * @newin{1,0}
   * @param text The text to be inserted.
   * @param position The position of the insertion, or -1.
   */
  void insert(const Glib::ustring& text, gssize position);

  
  /** Deletes @a n_chars inside a Clutter::Text actor, starting from the
   * current cursor position.
   * 
   * @newin{1,0}
   * @param n_chars The number of characters to delete.
   */
  void delete_chars(guint len);
  
  /** Deletes the text inside a Clutter::Text actor between @a start_pos
   * and @a end_pos.
   * 
   * The starting and ending positions are expressed in characters,
   * not in bytes.
   * 
   * @newin{1,0}
   * @param start_pos Starting position.
   * @param end_pos Ending position.
   */
  void delete_text(gssize start_pos, gssize end_pos);
  
  /** Deletes the currently selected text
   * 
   * This function is only useful in subclasses of Clutter::Text
   * @return <tt>true</tt> if text was deleted or if the text actor
   * is empty, and <tt>false</tt> otherwise
   * 
   * @newin{1,0}.
   */
  bool delete_selection();

  
  /** Retrieves the contents of the Clutter::Text actor between
   *  @a start_pos and @a end_pos.
   * 
   * The positions are specified in characters, not in bytes.
   * @param start_pos Start of text, in characters.
   * @param end_pos End of text, in characters.
   * @return A newly allocated string with the contents of
   * the text actor between the specified positions. Use Glib::free()
   * to free the resources when done
   * 
   * @newin{1,0}.
   */
  Glib::ustring get_chars(gssize start_pos, gssize end_pos) const;

  
  /** Sets the color of the cursor of a Clutter::Text actor.
   * 
   * If @a color is <tt>0</tt>, the cursor color will be the same as the
   * text color.
   * 
   * @newin{1,0}
   * @param color The color of the cursor, or <tt>0</tt> to unset it.
   */
  void set_cursor_color(const Color& color);
  
  /** Retrieves the color of the cursor of a Clutter::Text actor.
   * 
   * @newin{1,0}
   * @param color Return location for a Clutter::Color.
   */
  void get_cursor_color(Color& color) const;

  
  /** Sets the cursor of a Clutter::Text actor at @a position.
   * 
   * The position is expressed in characters, not in bytes.
   * 
   * @newin{1,0}
   * @param position The new cursor position, in characters.
   */
  void set_cursor_position(int position);
  
  /** Retrieves the cursor position.
   * @return The cursor position, in characters
   * 
   * @newin{1,0}.
   */
  int get_cursor_position() const;

  
  /** Sets whether the cursor of a Clutter::Text actor should be
   * visible or not.
   * 
   * The color of the cursor will be the same as the text color
   * unless set_cursor_color() has been called.
   * 
   * The size of the cursor can be set using set_cursor_size().
   * 
   * The position of the cursor can be changed programmatically using
   * set_cursor_position().
   * 
   * @newin{1,0}
   * @param cursor_visible Whether the cursor should be visible.
   */
  void set_cursor_visible(bool visible);
  
  /** Retrieves whether the cursor of a Clutter::Text actor is visible.
   * @return <tt>true</tt> if the cursor is visible
   * 
   * @newin{1,0}.
   */
  bool get_cursor_visible() const;

  
  /** Sets the size of the cursor of a Clutter::Text. The cursor
   * will only be visible if the Clutter::Text:cursor-visible property
   * is set to <tt>true</tt>.
   * 
   * @newin{1,0}
   * @param size The size of the cursor, in pixels, or -1 to use the
   * default value.
   */
  void set_cursor_size(int size);
  
  /** Retrieves the size of the cursor of a Clutter::Text actor.
   * @return The size of the cursor, in pixels
   * 
   * @newin{1,0}.
   */
  unsigned int get_cursor_size() const;

  
  /** Emits the Clutter::Text::activate signal, if @a self has been set
   * as activatable using set_activatable().
   * 
   * This function can be used to emit the ::activate signal inside
   * a Clutter::Actor::captured-event or Clutter::Actor::key-press-event
   * signal handlers before the default signal handler for the
   * Clutter::Text is invoked.
   * @return <tt>true</tt> if the ::activate signal has been emitted,
   * and <tt>false</tt> otherwise
   * 
   * @newin{1,0}.
   */
  bool activate();

  
  /** Retrieves the coordinates of the given @a position.
   * @param position Position in characters.
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   * @param line_height Return location for the line height, or <tt>0</tt>.
   * @return <tt>true</tt> if the conversion was successful
   * 
   * @newin{1,0}.
   */
  bool position_to_coords(int position, float &x, float &y, float &line_height);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%text_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_text_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%cursor_event(const Geometry& geometry)</tt>
   */

  Glib::SignalProxy1< void,const Geometry& > signal_cursor_event();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether pressing return causes the activate signal to be emitted.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_activatable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether pressing return causes the activate signal to be emitted.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_activatable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A list of style attributes to apply to the contents of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Pango::AttrList> property_attributes() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A list of style attributes to apply to the contents of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Pango::AttrList> property_attributes() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Color of the font used by the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Color> property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Color of the font used by the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Color> property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Cursor Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Color> property_cursor_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Cursor Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Color> property_cursor_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the cursor color has been set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_cursor_color_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The width of the cursor
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_cursor_size() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The width of the cursor
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_cursor_size() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the input cursor is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_cursor_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the input cursor is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_cursor_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is editable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_editable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is editable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_editable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred place to ellipsize the string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Pango::EllipsizeMode> property_ellipsize() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred place to ellipsize the string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Pango::EllipsizeMode> property_ellipsize() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The font to be used by the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_font_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The font to be used by the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_font_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text should be justified.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_justify() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text should be justified.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_justify() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred alignment for the string
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Pango::Alignment> property_line_alignment() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred alignment for the string
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Pango::Alignment> property_line_alignment() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Control how line-wrapping is done.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Pango::WrapMode> property_line_wrap_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Control how line-wrapping is done.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Pango::WrapMode> property_line_wrap_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If set
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_line_wrap() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If set
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_line_wrap() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum length of the text inside the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_length() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum length of the text inside the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If non-zero
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<gunichar> property_password_char() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If non-zero
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gunichar> property_password_char() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is selectable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_selectable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is selectable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_selectable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position of the other end of the selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_selection_bound() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position of the other end of the selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_selection_bound() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Selection Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Color> property_selection_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Selection Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Color> property_selection_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the selection color has been set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_selection_color_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text should be a single line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_single_line_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text should be a single line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_single_line_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The text to render.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The text to render.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not the text includes Pango markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_markup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not the text includes Pango markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_markup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_activate();
  virtual void on_text_changed();
  virtual void on_cursor_event(const Geometry& geometry);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Text
   */
  Glib::RefPtr<Clutter::Text> wrap(ClutterText* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_TEXT_H */

