// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ACTOR_H
#define _CLUTTERMM_ACTOR_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <pangomm/context.h>
#include <pangomm/layout.h>
#include <cluttermm/animation.h>
#include <cluttermm/color.h>
#include <cluttermm/scriptable.h>
#include <cluttermm/shader.h>
#include <cluttermm/types.h> // For Event*
#include <clutter/clutter.h> // For ClutterActorBox
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterActor ClutterActor;
typedef struct _ClutterActorClass ClutterActorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Actor_Class; } // namespace Clutter
namespace Clutter
{

class Animation;

class ActorBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ActorBox CppObjectType;
  typedef ClutterActorBox BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  ActorBox();

  explicit ActorBox(const ClutterActorBox* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterActorBox*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterActorBox* gobj() const { return &gobject_; }

protected:
  ClutterActorBox gobject_;

private:
  
public:
  ActorBox(float x1, float y1, float x2, float y2);

   float get_x1() const;
    void set_x1(const float& value);
    float get_y1() const;
    void set_y1(const float& value);
    float get_x2() const;
    void set_x2(const float& value);
    float get_y2() const;
    void set_y2(const float& value);
 

};

/** @addtogroup cluttermmEnums Enums and Flags */

/**
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%ActorFlags operator|(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator&(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator^(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator~(ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator|=(ActorFlags&, ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator&=(ActorFlags&, ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator^=(ActorFlags&, ActorFlags)</tt><br>
 */
enum ActorFlags
{
  ACTOR_MAPPED = 1 << 1,
  ACTOR_REALIZED = 1 << 2,
  ACTOR_REACTIVE = 1 << 3,
  ACTOR_VISIBLE = 1 << 4,
  ACTOR_NO_LAYOUT = 1 << 5
};

/** @ingroup cluttermmEnums */
inline ActorFlags operator|(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator&(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator^(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator~(ActorFlags flags)
  { return static_cast<ActorFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator|=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator&=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator^=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ActorFlags> : public Glib::Value_Flags<Clutter::ActorFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/**
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%AllocationFlags operator|(AllocationFlags, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags operator&(AllocationFlags, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags operator^(AllocationFlags, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags operator~(AllocationFlags)</tt><br>
 * <tt>%AllocationFlags& operator|=(AllocationFlags&, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags& operator&=(AllocationFlags&, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags& operator^=(AllocationFlags&, AllocationFlags)</tt><br>
 */
enum AllocationFlags
{
  ALLOCATION_NONE = 0x0,
  ABSOLUTE_ORIGIN_CHANGED = 1 << 1
};

/** @ingroup cluttermmEnums */
inline AllocationFlags operator|(AllocationFlags lhs, AllocationFlags rhs)
  { return static_cast<AllocationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline AllocationFlags operator&(AllocationFlags lhs, AllocationFlags rhs)
  { return static_cast<AllocationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline AllocationFlags operator^(AllocationFlags lhs, AllocationFlags rhs)
  { return static_cast<AllocationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline AllocationFlags operator~(AllocationFlags flags)
  { return static_cast<AllocationFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline AllocationFlags& operator|=(AllocationFlags& lhs, AllocationFlags rhs)
  { return (lhs = static_cast<AllocationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline AllocationFlags& operator&=(AllocationFlags& lhs, AllocationFlags rhs)
  { return (lhs = static_cast<AllocationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline AllocationFlags& operator^=(AllocationFlags& lhs, AllocationFlags rhs)
  { return (lhs = static_cast<AllocationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::AllocationFlags> : public Glib::Value_Flags<Clutter::AllocationFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


//TODO: Write a version of the large description from here: http://clutter-project.org/docs/clutter/stable/ClutterActor.html#ClutterActor.description

class Actor : public Glib::Object, public Scriptable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Actor CppObjectType;
  typedef Actor_Class CppClassType;
  typedef ClutterActor BaseObjectType;
  typedef ClutterActorClass BaseClassType;

private:  friend class Actor_Class;
  static CppClassType actor_class_;

private:
  // noncopyable
  Actor(const Actor&);
  Actor& operator=(const Actor&);

protected:
  explicit Actor(const Glib::ConstructParams& construct_params);
  explicit Actor(ClutterActor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Actor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterActor*       gobj()       { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterActor* gobj() const { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterActor* gobj_copy();

private:

  
protected:
  Actor();

public:
  //There is no create() because this is an abstract base class.
  //_WRAP_CREATE()

  
  /** Sets @a flags on @a self
   * 
   * This function will emit notifications for the changed properties
   * 
   * @newin{1,0}
   * @param flags The flags to set.
   */
  void set_flags(ActorFlags flags);
  
  /** Unsets @a flags on @a self
   * 
   * This function will emit notifications for the changed properties
   * 
   * @newin{1,0}
   * @param flags The flags to unset.
   */
  void unset_flags(ActorFlags flags);
  
  /** Retrieves the flags set on @a self
   * 
   * @newin{1,0}
   * @return A bitwise or of Clutter::ActorFlags or 0.
   */
  ActorFlags get_flags() const;

  //TODO: Remove these now that there are properties instead?
  bool is_mapped() const;
  bool is_realized() const;
  bool is_visible() const;
  bool is_reactive() const;

  
  /** Flags an actor to be displayed. An actor that isn't shown will not
   * be rendered on the stage.
   * 
   * Actors are visible by default.
   * 
   * If this function is called on an actor without a parent, the
   * Clutter::Actor:show-on-set-parent will be set to <tt>true</tt> as a side
   * effect.
   */
  void show();
  
  /** Calls show() on all children of an actor (if any).
   * 
   * @newin{0,2}
   */
  void show_all();
  
  /** Flags an actor to be hidden. A hidden actor will not be
   * rendered on the stage.
   * 
   * Actors are visible by default.
   * 
   * If this function is called on an actor without a parent, the
   * Clutter::Actor:show-on-set-parent property will be set to <tt>false</tt>
   * as a side-effect.
   */
  void hide();
  
  /** Calls hide() on all child actors (if any).
   * 
   * @newin{0,2}
   */
  void hide_all();
  
  /** Creates any underlying graphics resources needed by the actor to be
   * displayed.
   * 
   * Realization means the actor is now tied to a specific rendering context
   * (that is, a specific toplevel stage).
   * 
   * This function does nothing if the actor is already realized.
   * 
   * Because a realized actor must have realized parent actors, calling
   * realize() will also realize all parents of the actor.
   * 
   * This function does not realize child actors, except in the special
   * case that realizing the stage, when the stage is visible, will
   * suddenly map (and thus realize) the children of the stage.
   */
  void realize();
  
  /** Frees up any underlying graphics resources needed by the actor to
   * be displayed.
   * 
   * Unrealization means the actor is now independent of any specific
   * rendering context (is not attached to a specific toplevel stage).
   * 
   * Because mapped actors must be realized, actors may not be
   * unrealized if they are mapped. This function hides the actor to be
   * sure it isn't mapped, an application-visible side effect that you
   * may not be expecting.
   * 
   * This function should not really be in the public API, because
   * there isn't a good reason to call it. ClutterActor will already
   * unrealize things for you when it's important to do so.
   * 
   * If you were using unrealize() in a dispose
   * implementation, then don't, just chain up to ClutterActor's
   * dispose.
   * 
   * If you were using unrealize() to implement
   * unrealizing children of your container, then don't, ClutterActor
   * will already take care of that.
   * 
   * If you were using unrealize() to re-realize to
   * create your resources in a different way, then use
   * _clutter_actor_rerealize() (inside Clutter) or just call your
   * code that recreates your resources directly (outside Clutter).
   */
  void unrealize();
  
  /** Sets the Clutter::ACTOR_MAPPED flag on the actor and possibly maps
   * and realizes its children if they are visible. Does nothing if the
   * actor is not visible.
   * 
   * Calling this is allowed in only one case: you are implementing the
   * Clutter::Actor::map virtual function in an actor and you need to map
   * the children of that actor. It is not necessary to call this
   * if you implement Clutter::Container because the default implementation
   * will automatically map children of containers.
   * 
   * When overriding map, it is mandatory to chain up to the parent
   * implementation.
   * 
   * @newin{1,0}
   */
  void map();
  
  /** Unsets the Clutter::ACTOR_MAPPED flag on the actor and possibly
   * unmaps its children if they were mapped.
   * 
   * Calling this is allowed in only one case: you are implementing the
   * Clutter::Actor::unmap virtual function in an actor and you need to
   * unmap the children of that actor. It is not necessary to call this
   * if you implement Clutter::Container because the default implementation
   * will automatically unmap children of containers.
   * 
   * When overriding unmap, it is mandatory to chain up to the parent
   * implementation.
   * 
   * @newin{1,0}
   */
  void unmap();
  
  /** Renders the actor to display.
   * 
   * This function should not be called directly by applications.
   * Call queue_redraw() to queue paints, instead.
   * 
   * This function will emit the Clutter::Actor::paint signal.
   */
  void paint();
  
  /** Queues up a redraw of an actor and any children. The redraw occurs
   * once the main loop becomes idle (after the current batch of events
   * has been processed, roughly).
   * 
   * Applications rarely need to call this, as redraws are handled
   * automatically by modification functions.
   * 
   * This function will not do anything if @a self is not visible, or
   * if the actor is inside an invisible part of the scenegraph.
   * 
   * Also be aware that painting is a NOP for actors with an opacity of
   * 0
   */
  void queue_redraw();
  
  /** Indicates that the actor's size request or other layout-affecting
   * properties may have changed. This function is used inside Clutter::Actor
   * subclass implementations, not by applications directly.
   * 
   * Queueing a new layout automatically queues a redraw as well.
   * 
   * @newin{0,8}
   */
  void queue_relayout();

   
  //TODO: Check that we don't want to wrap this: _WRAP_METHOD(void destroy(), clutter_actor_destroy)
  //__IGNORE(clutter_actor_destroy)

  
  /** Retrieves the Pango::Context for @a self. The actor's Pango::Context
   * is already configured using the appropriate font map, resolution
   * and font options.
   * 
   * Unlike create_pango_context(), this context is owend
   * by the Clutter::Actor and it will be updated each time the options
   * stored by the Clutter::Backend change.
   * 
   * You can use the returned Pango::Context to create a Pango::Layout
   * and render text using cogl_pango_render_layout() to reuse the
   * glyphs cache also used by Clutter.
   * 
   * @newin{1,0}
   * @return The Pango::Context for a Clutter::Actor.
   * The returned Pango::Context is owned by the actor and should not be
   * unreferenced by the application code.
   */
  Glib::RefPtr<Pango::Context> get_pango_context();
  
  /** Retrieves the Pango::Context for @a self. The actor's Pango::Context
   * is already configured using the appropriate font map, resolution
   * and font options.
   * 
   * Unlike create_pango_context(), this context is owend
   * by the Clutter::Actor and it will be updated each time the options
   * stored by the Clutter::Backend change.
   * 
   * You can use the returned Pango::Context to create a Pango::Layout
   * and render text using cogl_pango_render_layout() to reuse the
   * glyphs cache also used by Clutter.
   * 
   * @newin{1,0}
   * @return The Pango::Context for a Clutter::Actor.
   * The returned Pango::Context is owned by the actor and should not be
   * unreferenced by the application code.
   */
  Glib::RefPtr<const Pango::Context> get_pango_context() const;
  
  /** Creates a Pango::Context for the given actor. The Pango::Context
   * is already configured using the appropriate font map, resolution
   * and font options.
   * 
   * See also get_pango_context().
   * 
   * @newin{1,0}
   * @return The newly created Pango::Context. Use Glib::object_unref()
   * on the returned value to deallocate its resources.
   */
  Glib::RefPtr<Pango::Context> create_pango_context();

  
  /** Creates a new Pango::Layout from the same Pango::Context used
   * by the Clutter::Actor. The Pango::Layout is already configured
   * with the font map, resolution and font options, and the
   * given @a text.
   * 
   * If you want to keep around a Pango::Layout created by this
   * function you will have to connect to the Clutter::Backend::font-changed
   * and Clutter::Backend::resolution-changed signals, and call
   * pango_layout_context_changed() in response to them.
   * 
   * @newin{1,0}
   * @param text (allow-none) the text to set on the Pango::Layout, or <tt>0</tt>.
   * @return The newly created Pango::Layout. Use Glib::object_unref()
   * when done.
   */
  Glib::RefPtr<Pango::Layout> create_pango_layout(const Glib::ustring& text);

  //TODO: Wrap CoglMatrix
  
  /** Retrieves the transformations applied to @a self
   * 
   * @newin{1,0}
   * @param matrix The return location for a Cogl::Matrix.
   */
  void get_transformation_matrix(CoglMatrix* matrix);
  
  
  /** Checks whether @a self is being currently painted by a Clutter::Clone
   * 
   * This function is useful only inside the ::paint virtual function
   * implementations or within handlers for the Clutter::Actor::paint
   * signal
   * 
   * This function should not be used by applications
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the Clutter::Actor is currently being painted
   * by a Clutter::Clone, and <tt>false</tt> otherwise.
   */
  bool is_in_clone_paint() const;
  
  /** Checks whether an actor contains the the pointer of a
   * Clutter::InputDevice
   * 
   * @newin{1,2}
   * @return <tt>true</tt> if the actor contains the pointer, and
   * <tt>false</tt> otherwise.
   */
  bool has_pointer() const;
  
  /** Sets the Clutter::TextDirection for an actor
   * 
   * The passed text direction must not be Clutter::TEXT_DIRECTION_DEFAULT
   * 
   * If @a self implements Clutter::Container then this function will recurse
   * inside all the children of @a self (including the internal ones).
   * 
   * Composite actors not implementing Clutter::Container, or actors requiring
   * special handling when the text direction changes, should connect to
   * the Object::notify signal for the Clutter::Actor:text-direction property
   * 
   * @newin{1,2}
   * @param text_dir The text direction for @a self.
   */
  void set_text_direction(TextDirection text_dir);
  
  /** Retrieves the value set using set_text_direction()
   * 
   * If no text direction has been previously set, the default text
   * direction, as returned by clutter_get_default_text_direction(), will
   * be returned instead
   * 
   * @newin{1,2}
   * @return The Clutter::TextDirection for the actor.
   */
  TextDirection get_text_direction() const;


  /** Retrieves the Clutter::Stage where @a actor is contained.
   * 
   * @newin{0,8}
   * @return The stage containing the actor, or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_stage();
  
  /** Retrieves the Clutter::Stage where @a actor is contained.
   * 
   * @newin{0,8}
   * @return The stage containing the actor, or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_stage() const;
 

  /** Sets the actor's fixed position and forces its minimum and natural
   * size, in pixels. This means the untransformed actor will have the
   * given geometry. This is the same as calling set_position()
   * and set_size().
   * @param geometry A Clutter::Geometry.
   */
  void set_geometry(const Geometry& geometry);
  
  /** Gets the size and position of an actor relative to its parent
   * actor. This is the same as calling get_position() and
   * get_size(). It tries to "do what you mean" and get the
   * requested size and position if the actor's allocation is invalid.
   * @param geometry A location to store actors Clutter::Geometry.
   */

  Geometry get_geometry() const;
  //_WRAP_METHOD(void get_coords(float *x_1, float *y_1, float *x_2, float *y_2) const, clutter_actor_get_coords)
  
  /** Sets the actor's size request in pixels. This overrides any
   * "normal" size request the actor would have. For example
   * a text actor might normally request the size of the text;
   * this function would force a specific size instead.
   * 
   * If @a width and/or @a height are -1 the actor will use its
   * "normal" size request instead of overriding it, i.e.
   * you can "unset" the size with -1.
   * 
   * This function sets or unsets both the minimum and natural size.
   * @param width New width of actor in pixels, or -1.
   * @param height New height of actor in pixels, or -1.
   */
  void set_size(float width, float height);
  
  /** This function tries to "do what you mean" and tell you where the
   * actor is, prior to any transformations. Retrieves the fixed
   * position of an actor in pixels, if one has been set; otherwise, if
   * the allocation is valid, returns the actor's allocated position;
   * otherwise, returns 0,0.
   * 
   * The returned position is in pixels.
   * 
   * @newin{0,6}
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_position(float& x, float& y);
  
  /** Sets the actor's fixed position in pixels relative to any parent
   * actor.
   * 
   * If a layout manager is in use, this position will override the
   * layout manager and force a fixed position.
   * @param x New left position of actor in pixels.
   * @param y New top position of actor in pixels.
   */
  void set_position(float x, float y);
  //_WRAP_METHOD(void get_abs_position(float& x, float& y) const, clutter_actor_get_abs_position)
  
  /** Retrieves the width of a Clutter::Actor.
   * 
   * If the actor has a valid allocation, this function will return the
   * width of the allocated area given to the actor.
   * 
   * If the actor does not have a valid allocation, this function will
   * return the actor's natural width, that is the preferred width of
   * the actor.
   * 
   * If you care whether you get the preferred width or the width that
   * has been assigned to the actor, you should probably call a different
   * function like get_allocation_box() to retrieve the
   * allocated size or get_preferred_width() to retrieve the
   * preferred width.
   * 
   * If an actor has a fixed width, for instance a width that has been
   * assigned using set_width(), the width returned will
   * be the same value.
   * @return The width of the actor, in pixels.
   */
  float get_width() const;
  
  /** Retrieves the height of a Clutter::Actor.
   * 
   * If the actor has a valid allocation, this function will return the
   * height of the allocated area given to the actor.
   * 
   * If the actor does not have a valid allocation, this function will
   * return the actor's natural height, that is the preferred height of
   * the actor.
   * 
   * If you care whether you get the preferred height or the height that
   * has been assigned to the actor, you should probably call a different
   * function like get_allocation_box() to retrieve the
   * allocated size or get_preferred_height() to retrieve the
   * preferred height.
   * 
   * If an actor has a fixed height, for instance a height that has been
   * assigned using set_height(), the height returned will
   * be the same value.
   * @return The height of the actor, in pixels.
   */
  float get_height() const;
  
  /** Forces a width on an actor, causing the actor's preferred width
   * and height (if any) to be ignored.
   * 
   * If @a width is -1 the actor will use its preferred width request
   * instead of overriding it, i.e. you can "unset" the width with -1.
   * 
   * This function sets both the minimum and natural size of the actor.
   * 
   * since: 0.2
   * @param width Requested new width for the actor, in pixels, or -1.
   */
  void set_width(float width);
  
  /** Forces a height on an actor, causing the actor's preferred width
   * and height (if any) to be ignored.
   * 
   * If @a height is -1 the actor will use its preferred height instead of
   * overriding it, i.e. you can "unset" the height with -1.
   * 
   * This function sets both the minimum and natural size of the actor.
   * 
   * since: 0.2
   * @param height Requested new height for the actor, in pixels, or -1.
   */
  void set_height(float height);

  
  /** Sets the actor's X coordinate, relative to its parent, in pixels.
   * 
   * Overrides any layout manager and forces a fixed position for
   * the actor.
   * 
   * @newin{0,6}
   * @param x The actor's position on the X axis.
   */
  void set_x(float x);
  
  /** Retrieves the X coordinate of a Clutter::Actor.
   * 
   * This function tries to "do what you mean", by returning the
   * correct value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return
   * the X coordinate of the origin of the allocation box.
   * 
   * If the actor has any fixed coordinate set using set_x(),
   * set_position() or set_geometry(), this
   * function will return that coordinate.
   * 
   * If both the allocation and a fixed position are missing, this function
   * will return 0.
   * @return The X coordinate, in pixels, ignoring any
   * transformation (i.e. scaling, rotation).
   */
  float get_x() const;
  
  /** Sets the actor's Y coordinate, relative to its parent, in pixels.#
   * 
   * Overrides any layout manager and forces a fixed position for
   * the actor.
   * 
   * @newin{0,6}
   * @param y The actor's position on the Y axis.
   */
  void set_y(float y);
  
  /** Retrieves the Y coordinate of a Clutter::Actor.
   * 
   * This function tries to "do what you mean", by returning the
   * correct value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return
   * the Y coordinate of the origin of the allocation box.
   * 
   * If the actor has any fixed coordinate set using set_y(),
   * set_position() or set_geometry(), this
   * function will return that coordinate.
   * 
   * If both the allocation and a fixed position are missing, this function
   * will return 0.
   * @return The Y coordinate, in pixels, ignoring any
   * transformation (i.e. scaling, rotation).
   */
  float get_y() const;
  
  /** Sets @a actor as reactive. Reactive actors will receive events.
   * 
   * @newin{0,6}
   * @param reactive Whether the actor should be reactive to events.
   */
  void set_reactive(bool reactive = true);
  
  /** Checks whether @a actor is marked as reactive.
   * 
   * @newin{0,6}
   * @return <tt>true</tt> if the actor is reactive.
   */
  bool get_reactive() const;

  
  /** Sets the rotation angle of @a self around the given axis.
   * 
   * The rotation center coordinates used depend on the value of @a axis:
   * <itemizedlist>
   * <listitem><para>Clutter::X_AXIS requires @a y and @a z</para></listitem>
   * <listitem><para>Clutter::Y_AXIS requires @a x and @a z</para></listitem>
   * <listitem><para>Clutter::Z_AXIS requires @a x and @a y</para></listitem>
   * </itemizedlist>
   * 
   * The rotation coordinates are relative to the anchor point of the
   * actor, set using set_anchor_point(). If no anchor
   * point is set, the upper left corner is assumed as the origin.
   * 
   * @newin{0,8}
   * @param axis The axis of rotation.
   * @param angle The angle of rotation.
   * @param x X coordinate of the rotation center.
   * @param y Y coordinate of the rotation center.
   * @param z Z coordinate of the rotation center.
   */
  void set_rotation(RotateAxis axis, double angle, float x, float y, float z);
  
  /** Sets the rotation angle of @a self around the Z axis using the center
   * point specified as a compass point. For example to rotate such that
   * the center of the actor remains static you can use
   * Clutter::GRAVITY_CENTER. If the actor changes size the center point
   * will move accordingly.
   * 
   * @newin{1,0}
   * @param angle The angle of rotation.
   * @param gravity The center point of the rotation.
   */
  void set_z_rotation_from_gravity(double angle, Gravity gravity);
  
  /** Retrieves the angle and center of rotation on the given axis,
   * set using set_rotation().
   * 
   * @newin{0,8}
   * @param axis The axis of rotation.
   * @param x Return value for the X coordinate of the center of rotation.
   * @param y Return value for the Y coordinate of the center of rotation.
   * @param z Return value for the Z coordinate of the center of rotation.
   * @return The angle of rotation.
   */
  double get_rotation(RotateAxis axis, float& x, float& y, float& z) const;
  
  /** Retrieves the center for the rotation around the Z axis as a
   * compass direction. If the center was specified in pixels or units
   * this will return Clutter::GRAVITY_NONE.
   * 
   * @newin{1,0}
   * @return The Z rotation center.
   */
  Gravity get_z_rotation_gravity() const;
  
  /** Sets the actor's opacity, with zero being completely transparent and
   * 255 (0xff) being fully opaque.
   * @param opacity New opacity value for the actor.
   */
  void set_opacity(guint8 opacity);
  
  /** Retrieves the opacity value of an actor, as set by
   * set_opacity().
   * 
   * For retrieving the absolute opacity of the actor inside a paint
   * virtual function, see get_paint_opacity().
   * @return The opacity of the actor.
   */
  guint8 get_opacity() const;
  
  /** Sets the given name to @a self. The name can be used to identify
   * a Clutter::Actor.
   * @param name Textual tag to apply to actor.
   */
  void set_name(const gchar *name);
  
  /** Retrieves the name of @a self.
   * @return The name of the actor, or <tt>0</tt>. The returned string is
   * owned by the actor and should not be modified or freed.
   */
  Glib::ustring get_name() const;
  
  /** Retrieves the unique id for @a self.
   * 
   * @newin{0,6}
   * @return Globally unique value for this object instance.
   */
  guint32 get_gid() const;
  
  /** Sets clip area for @a self. The clip area is always computed from the
   * upper left corner of the actor, even if the anchor point is set
   * otherwise.
   * 
   * @newin{0,6}
   * @param xoff X offset of the clip rectangle.
   * @param yoff Y offset of the clip rectangle.
   * @param width Width of the clip rectangle.
   * @param height Height of the clip rectangle.
   */
  void set_clip(float xoff, float yoff, float width, float height);
  
  /** Gets the clip area for @a self, if any is set
   * 
   * @newin{0,6}
   * @param xoff Return location for the X offset of
   * the clip rectangle, or <tt>0</tt>.
   * @param yoff Return location for the Y offset of
   * the clip rectangle, or <tt>0</tt>.
   * @param width Return location for the width of
   * the clip rectangle, or <tt>0</tt>.
   * @param height Return location for the height of
   * the clip rectangle, or <tt>0</tt>.
   */
  void get_clip(float& xoff, float& yoff, float& width, float& height);
  
  /** Removes clip area from @a self.
   */
  void remove_clip();
  
  /** Determines whether the actor has a clip area set or not.
   * 
   * @newin{0,1}.1
   * @return <tt>true</tt> if the actor has a clip area set.
   */
  bool has_clip() const;
  
  /** Sets the parent of @a self to @a parent.  The opposite function is
   * unparent().
   * 
   * This function should not be used by applications, but by custom
   * container actor subclasses.
   * @param parent A new Clutter::Actor parent.
   */
  void set_parent(const Glib::RefPtr<Actor>& parent);
  
  /** Retrieves the parent of @a self.
   * @return The Clutter::Actor parent, or <tt>0</tt>
   * if no parent is set.
   */
  Glib::RefPtr<Actor> get_parent();
  
  /** Retrieves the parent of @a self.
   * @return The Clutter::Actor parent, or <tt>0</tt>
   * if no parent is set.
   */
  Glib::RefPtr<const Actor> get_parent() const;
  
  /** This function resets the parent actor of @a self.  It is
   * logically equivalent to calling unparent()
   * and set_parent(), but more efficiently
   * implemented, ensures the child is not finalized
   * when unparented, and emits the parent-set signal only
   * one time.
   * 
   * @newin{0,2}
   * @param new_parent The new Clutter::Actor parent.
   */
  void reparent(const Glib::RefPtr<Actor>& new_parent);
  
  /** Removes the parent of @a self.
   * 
   * This function should not be used in applications.  It should be called by
   * implementations of container actors, to dissociate a child from the
   * container.
   * 
   * @newin{0,1}.1
   */
  void unparent();
  
  /** Puts @a self above @a below.
   * 
   * Both actors must have the same parent, and the parent must implement
   * the Clutter::Container interface
   * 
   * This function is the equivalent of Clutter::Container::raise_child().
   * @param below A Clutter::Actor to raise above.
   */
  void raise(const Glib::RefPtr<Actor>& below);
  
  /** Puts @a self below @a above.
   * 
   * Both actors must have the same parent, and the parent must implement
   * the Clutter::Container interface.
   * 
   * This function is the equivalent of Clutter::Container::lower_child().
   * @param above A Clutter::Actor to lower below.
   */
  void lower(const Glib::RefPtr<Actor>& above);
  
  /** Raises @a self to the top.
   * 
   * This function calls raise() internally.
   */
  void raise_top ();
  
  /** Lowers @a self to the bottom.
   * 
   * This function calls lower() internally.
   */
  void lower_bottom();

  
  /** Queries the currently set Clutter::Shader on @a self.
   * 
   * @newin{0,6}
   * @return The currently set Clutter::Shader
   * or <tt>0</tt> if no shader is set.
   */
  Glib::RefPtr<Shader> get_shader();
  
  /** Queries the currently set Clutter::Shader on @a self.
   * 
   * @newin{0,6}
   * @return The currently set Clutter::Shader
   * or <tt>0</tt> if no shader is set.
   */
  Glib::RefPtr<const Shader> get_shader() const;
  
  /** Sets the Clutter::Shader to be used when rendering @a self.
   * 
   * If @a shader is <tt>0</tt> it will unset any currently set shader
   * for the actor.
   * 
   * @newin{0,6}
   * @param shader A Clutter::Shader or <tt>0</tt> to unset the shader.
   * @return <tt>true</tt> if the shader was successfully applied.
   */
  void set_shader(const Glib::RefPtr<Shader>& shader);
  
  /** Sets the value for a named parameter of the shader applied
   * to @a actor.
   * 
   * @newin{1,0}
   * @param param The name of the parameter.
   * @param value The value of the parameter.
   */

  template <class ParamType> void set_shader_param(const Glib::ustring& param, const ParamType& value);
  
  //_WRAP_METHOD_DOCS_ONLY(clutter_actor_get_paint_area)
  //ActorBox get_paint_area() const;
  
  /** Checks whether any rotation is applied to the actor.
   * 
   * @newin{0,6}
   * @return <tt>true</tt> if the actor is rotated.
   */
  bool is_rotated() const;
  
  /** Checks whether the actor is scaled in either dimension.
   * 
   * @newin{0,6}
   * @return <tt>true</tt> if the actor is scaled.
   */
  bool is_scaled() const;
  
  /** Should be called inside the implementation of the
   * Clutter::Actor::pick virtual function in order to check whether
   * the actor should paint itself in pick mode or not.
   * 
   * This function should never be called directly by applications.
   * @return <tt>true</tt> if the actor should paint its silhouette,
   * <tt>false</tt> otherwise.
   */
  bool should_pick_paint() const;
  
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * <itemizedlist>
   * <listitem><para> @a verts[0] contains (x1, y1)</para></listitem>
   * <listitem><para> @a verts[1] contains (x2, y1)</para></listitem>
   * <listitem><para> @a verts[2] contains (x1, y2)</para></listitem>
   * <listitem><para> @a verts[3] contains (x2, y2)</para></listitem>
   * </itemizedlist>
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * @newin{0,6}
   * @param ancestor A Clutter::Actor to calculate the vertices
   * against, or <tt>0</tt> to use the default Clutter::Stage.
   * @param verts Return location for an array of
   * 4 Clutter::Vertex in which to store the result.
   */

  void get_allocation_vertices(Vertex vertices[4]) const;
  
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * <itemizedlist>
   * <listitem><para> @a verts[0] contains (x1, y1)</para></listitem>
   * <listitem><para> @a verts[1] contains (x2, y1)</para></listitem>
   * <listitem><para> @a verts[2] contains (x1, y2)</para></listitem>
   * <listitem><para> @a verts[3] contains (x2, y2)</para></listitem>
   * </itemizedlist>
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * @newin{0,6}
   * @param ancestor A Clutter::Actor to calculate the vertices
   * against, or <tt>0</tt> to use the default Clutter::Stage.
   * @param verts Return location for an array of
   * 4 Clutter::Vertex in which to store the result.
   */

  void get_allocation_vertices(const Glib::RefPtr<Actor>& ancestor, Vertex vertices[4]) const;
  
  
  /** Calculates the transformed screen coordinates of the four corners of
   * the actor; the returned vertices relate to the Clutter::ActorBox
   * coordinates  as follows:
   * <itemizedlist>
   * <listitem><para>v[0] contains (x1, y1)</para></listitem>
   * <listitem><para>v[1] contains (x2, y1)</para></listitem>
   * <listitem><para>v[2] contains (x1, y2)</para></listitem>
   * <listitem><para>v[3] contains (x2, y2)</para></listitem>
   * </itemizedlist>
   * 
   * @newin{0,4}
   * @param verts Pointer to a location of an array
   * of 4 Clutter::Vertex where to store the result.
   */

  void get_abs_allocation_vertices(Vertex vertices[4]) const;
  
  
  /** Gets the layout box an actor has been assigned. The allocation can
   * only be assumed valid inside a paint() method; anywhere else, it
   * may be out-of-date.
   * 
   * An allocation does not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * <note>Do not call any of the clutter_actor_get_allocation_*() family
   * of functions inside the implementation of the get_preferred_width()
   * or get_preferred_height() virtual functions.</note>
   * 
   * @newin{0,8}
   * @param box The function fills this in with the actor's allocation.
   */

  ActorBox get_allocation_box() const;
  
 
  /** Called by the parent of an actor to assign the actor its size.
   * Should never be called by applications (except when implementing
   * a container or layout manager).
   * 
   * Actors can know from their allocation box whether they have moved
   * with respect to their parent actor. The @a flags parameter describes
   * additional information about the allocation, for instance whether
   * the parent has moved with respect to the stage, for example because
   * a grandparent's origin has moved.
   * 
   * @newin{0,8}
   * @param box New allocation of the actor, in parent-relative coordinates.
   * @param flags Flags that control the allocation.
   */
  void allocate(const ActorBox& box, AllocationFlags absolute_origin_changed = ALLOCATION_NONE);
  
  
  /** Allocates the natural size of @a self.
   * 
   * This function is a utility call for Clutter::Actor implementations
   * that allocates the actor's preferred natural size. It can be used
   * by fixed layout managers (like Clutter::Group or so called
   * 'composite actors') inside the ClutterActor::allocate
   * implementation to give each child exactly how much space it
   * requires.
   * 
   * This function is not meant to be used by applications. It is also
   * not meant to be used outside the implementation of the
   * ClutterActor::allocate virtual function.
   * 
   * @newin{0,8}
   * @param flags Flags controlling the allocation.
   */
  void allocate_preferred_size(AllocationFlags absolute_origin_changed = ALLOCATION_NONE);
    
  /** Allocates @a self taking into account the Clutter::Actor<!-- -->'s
   * preferred size, but limiting it to the maximum available width
   * and height provided.
   * 
   * This function will do the right thing when dealing with the
   * actor's request mode.
   * 
   * The implementation of this function is equivalent to:
   * 
   * |[
   * if (request_mode == CLUTTER_REQUEST_HEIGHT_FOR_WIDTH)
   * {
   * clutter_actor_get_preferred_width (self, available_height,
   * &min_width,
   * &natural_width);
   * width = CLAMP (natural_width, min_width, available_width);
   * 
   * clutter_actor_get_preferred_height (self, width,
   * &min_height,
   * &natural_height);
   * height = CLAMP (natural_height, min_height, available_height);
   * }
   * else
   * {
   * clutter_actor_get_preferred_height (self, available_width,
   * &min_height,
   * &natural_height);
   * height = CLAMP (natural_height, min_height, available_height);
   * 
   * clutter_actor_get_preferred_width (self, height,
   * &min_width,
   * &natural_width);
   * width = CLAMP (natural_width, min_width, available_width);
   * }
   * 
   * box.x1 = x; box.y1 = y;
   * box.x2 = box.x1 + available_width;
   * box.y2 = box.y1 + available_height;
   * clutter_actor_allocate (self, &box, flags);
   * ]|
   * 
   * This function can be used by fluid layout managers to allocate
   * an actor's preferred size without making it bigger than the area
   * available for the container.
   * 
   * @newin{1,0}
   * @param x The actor's X coordinate.
   * @param y The actor's Y coordinate.
   * @param available_width The maximum available width, or -1 to use the
   * actor's natural width.
   * @param available_height The maximum available height, or -1 to use the
   * actor's natural height.
   * @param flags Flags controlling the allocation.
   */
  void allocate_available_size(float x, float y, float available_width, float                 available_height, AllocationFlags flags = ALLOCATION_NONE);

 
  /** Transforms @a point in coordinates relative to the actor into
   * ancestor-relative coordinates using the relevant transform
   * stack (i.e.\ scale, rotation, etc).
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of apply_transform_to_point().
   * 
   * @newin{0,6}
   * @param ancestor A Clutter::Actor ancestor, or <tt>0</tt> to use the
   * default Clutter::Stage.
   * @param point A point as Clutter::Vertex.
   * @param vertex The translated Clutter::Vertex.
   */
  void apply_relative_transform_to_point(const Glib::RefPtr<Actor>& ancestor, const Vertex& point, Vertex& vertex) const;
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * <itemizedlist>
   * <listitem><para> @a verts[0] contains (x1, y1)</para></listitem>
   * <listitem><para> @a verts[1] contains (x2, y1)</para></listitem>
   * <listitem><para> @a verts[2] contains (x1, y2)</para></listitem>
   * <listitem><para> @a verts[3] contains (x2, y2)</para></listitem>
   * </itemizedlist>
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * @newin{0,6}
   * @param ancestor A Clutter::Actor to calculate the vertices
   * against, or <tt>0</tt> to use the default Clutter::Stage.
   * @param verts Return location for an array of
   * 4 Clutter::Vertex in which to store the result.
   */

  void apply_relative_transform_to_point(const Vertex& point, Vertex& vertex) const;

  
  /** Sets the geometry request mode of @a self.
   * 
   * The @a mode determines the order for invoking
   * get_preferred_width() and
   * get_preferred_height()
   * 
   * @newin{1,2}
   * @param mode The request mode.
   */
  void set_request_mode(RequestMode mode);
  
  /** Retrieves the geometry request mode of @a self
   * 
   * @newin{1,2}
   * @return The request mode for the actor.
   */
  RequestMode get_request_mode() const;

 
  /** Computes the preferred minimum and natural size of an actor, taking into
   * account the actor's geometry management (either height-for-width
   * or width-for-height).
   * 
   * The width and height used to compute the preferred height and preferred
   * width are the actor's natural ones.
   * 
   * If you need to control the height for the preferred width, or the width for
   * the preferred height, you should use get_preferred_width()
   * and get_preferred_height(), and check the actor's preferred
   * geometry management using the Clutter::Actor:request-mode property.
   * 
   * @newin{0,8}
   * @param min_width_p Return location for the minimum
   * width, or <tt>0</tt>.
   * @param min_height_p Return location for the minimum
   * height, or <tt>0</tt>.
   * @param natural_width_p Return location for the natural
   * width, or <tt>0</tt>.
   * @param natural_height_p Return location for the natural
   * height, or <tt>0</tt>.
   */
  void get_preferred_size(float& min_width_p, float& min_height_p, float& natural_width_p, float& natural_height_p) const;
  
  /** Computes the requested minimum and natural widths for an actor,
   * optionally depending on the specified height, or if they are
   * already computed, returns the cached values.
   * 
   * An actor may not get its request - depending on the layout
   * manager that's in effect.
   * 
   * A request should not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * @newin{0,8}
   * @param for_height Available height when computing the preferred width,
   * or a negative value to indicate that no height is defined.
   * @param min_width_p Return location for minimum width,
   * or <tt>0</tt>.
   * @param natural_width_p Return location for the natural
   * width, or <tt>0</tt>.
   */
  void get_preferred_width(float for_height, float& min_width_p, float& natural_width_p) const;
  
  /** Computes the requested minimum and natural heights for an actor,
   * or if they are already computed, returns the cached values.
   * 
   * An actor may not get its request - depending on the layout
   * manager that's in effect.
   * 
   * A request should not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * @newin{0,8}
   * @param for_width Available width to assume in computing desired height,
   * or a negative value to indicate that no width is defined.
   * @param min_height_p Return location for minimum height,
   * or <tt>0</tt>.
   * @param natural_height_p Return location for natural
   * height, or <tt>0</tt>.
   */
  void get_preferred_height(float for_width, float& min_height_p, float& natural_height_p) const;
  
  /** Retrieves the absolute opacity of the actor, as it appears on the stage.
   * 
   * This function traverses the hierarchy chain and composites the opacity of
   * the actor with that of its parents.
   * 
   * This function is intended for subclasses to use in the paint virtual
   * function, to paint themselves with the correct opacity.
   * 
   * @newin{0,8}
   * @return The actor opacity value.
   */
  guint8 get_paint_opacity() const;
  
  /** Retrieves the 'paint' visibility of an actor recursively checking for non
   * visible parents.
   * 
   * This is by definition the same as CLUTTER_ACTOR_IS_MAPPED().
   * 
   * @newin{0,8}.4
   * @return <tt>true</tt> if the actor is visibile and will be painted.
   */
  bool get_paint_visibility() const;
  
  /** Sets an anchor point on the actor based on the given gravity, adjusting the
   * actor postion so that its relative position within its parent remains
   * unchanged.
   * 
   * Since version 1.0 the anchor point will be stored as a gravity so
   * that if the actor changes size then the anchor point will move. For
   * example, if you set the anchor point to Clutter::GRAVITY_SOUTH_EAST
   * and later double the size of the actor, the anchor point will move
   * to the bottom right.
   * 
   * @newin{0,6}
   * @param gravity Clutter::Gravity.
   */
  void move_anchor_point_from_gravity(Gravity gravity);
  
  /** Sets an anchor point for the actor, and adjusts the actor postion so that
   * the relative position of the actor toward its parent remains the same.
   * 
   * @newin{0,6}
   * @param anchor_x X coordinate of the anchor point.
   * @param anchor_y Y coordinate of the anchor point.
   */
  void move_anchor_point(float anchor_x, float anchor_y);


  /** Checks whether an actor has a fixed position set (and will thus be
   * unaffected by any layout manager).
   * 
   * @newin{0,8}
   * @return <tt>true</tt> if the fixed position is set on the actor.
   */
  bool get_fixed_position_set() const;
  
  /** Sets whether an actor has a fixed position set (and will thus be
   * unaffected by any layout manager).
   * 
   * @newin{0,8}
   * @param is_set Whether to use fixed position.
   */
  void set_fixed_position_set(bool is_set);
  
  /** Gets the absolute position of an actor, in pixels relative to the stage.
   * 
   * @newin{0,8}
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_transformed_position(float& x, float& y) const;
  
  /** Gets the absolute size of an actor in pixels, taking into account the
   * scaling factors.
   * 
   * If the actor has a valid allocation, the allocated size will be used.
   * If the actor has not a valid allocation then the preferred size will
   * be transformed and returned.
   * 
   * If you want the transformed allocation, see
   * get_abs_allocation_vertices() instead.
   * 
   * <note>When the actor (or one of its ancestors) is rotated around the
   * X or Y axis, it no longer appears as on the stage as a rectangle, but
   * as a generic quadrangle; in that case this function returns the size
   * of the smallest rectangle that encapsulates the entire quad. Please
   * note that in this case no assumptions can be made about the relative
   * position of this envelope to the absolute position of the actor, as
   * returned by get_transformed_position(); if you need this
   * information, you need to use get_abs_allocation_vertices()
   * to get the coords of the actual quadrangle.</note>
   * 
   * @newin{0,8}
   * @param width Return location for the width, or <tt>0</tt>.
   * @param height Return location for the height, or <tt>0</tt>.
   */
  void get_transformed_size(float& width, float& height) const;
  
  
  /** Gets the layout box an actor has been assigned.  The allocation can
   * only be assumed valid inside a paint() method; anywhere else, it
   * may be out-of-date.
   * 
   * An allocation does not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * The returned rectangle is in pixels.
   * 
   * @newin{0,8}
   * @param geom Allocation geometry in pixels.
   */

  Geometry get_allocation_geometry() const;

  
  /** Sets the Z coordinate of @a self to @a depth.
   * 
   * The unit used by @a depth is dependant on the perspective setup. See
   * also Clutter::Stage::set_perspective().
   * @param depth Z co-ord.
   */
  void set_depth(float depth);
  
  /** Retrieves the depth of @a self.
   * @return The depth of the actor.
   */
  float get_depth() const;
  
  /** Scales an actor with the given factors. The scaling is relative to
   * the scale center and the anchor point. The scale center is
   * unchanged by this function and defaults to 0,0.
   * 
   * @newin{0,2}
   * @param scale_x Double factor to scale actor by horizontally.
   * @param scale_y Double factor to scale actor by vertically.
   */
  void set_scale(double scale_x, double scale_y);
  
  /** Scales an actor with the given factors around the given center
   * point. The center point is specified in pixels relative to the
   * anchor point (usually the top left corner of the actor).
   * 
   * @newin{1,0}
   * @param scale_x Double factor to scale actor by horizontally.
   * @param scale_y Double factor to scale actor by vertically.
   * @param center_x X coordinate of the center of the scale.
   * @param center_y Y coordinate of the center of the scale.
   */
  void set_scale_full(double scale_x, double scale_y, float center_x, float center_y);
  
  /** Scales an actor with the given factors around the given
   * center point. The center point is specified as one of the compass
   * directions in Clutter::Gravity. For example, setting it to north
   * will cause the top of the actor to remain unchanged and the rest of
   * the actor to expand left, right and downwards.
   * 
   * @newin{1,0}
   * @param scale_x Double factor to scale actor by horizontally.
   * @param scale_y Double factor to scale actor by vertically.
   * @param gravity The location of the scale center expressed as a compass
   * direction.
   */
  void set_scale_with_gravity(double scale_x, double scale_y, Gravity gravity);
  
  /** Retrieves an actors scale factors.
   * 
   * @newin{0,2}
   * @param scale_x Location to store horizonal
   * scale factor, or <tt>0</tt>.
   * @param scale_y Location to store vertical
   * scale factor, or <tt>0</tt>.
   */
  void get_scale(double& scale_x, double& scale_y) const;
  
  /** Retrieves the scale center coordinate in pixels relative to the top
   * left corner of the actor. If the scale center was specified using a
   * Clutter::Gravity this will calculate the pixel offset using the
   * current size of the actor.
   * 
   * @newin{1,0}
   * @param center_x Location to store the X position
   * of the scale center, or <tt>0</tt>.
   * @param center_y Location to store the Y position
   * of the scale center, or <tt>0</tt>.
   */
  void get_scale_center(float& center_x, float& center_y) const;
  
  /** Retrieves the scale center as a compass direction. If the scale
   * center was specified in pixels or units this will return
   * Clutter::GRAVITY_NONE.
   * 
   * @newin{1,0}
   * @return The scale gravity.
   */
  Gravity get_scale_gravity() const;

  //_WRAP_METHOD(void get_abs_size(float& width, float& height) const, clutter_actor_get_abs_size)
  
  /** This function tries to "do what you mean" and return
   * the size an actor will have. If the actor has a valid
   * allocation, the allocation will be returned; otherwise,
   * the actors natural size request will be returned.
   * 
   * If you care whether you get the request vs. the allocation, you
   * should probably call a different function like
   * get_allocation_box() or
   * get_preferred_width().
   * 
   * @newin{0,2}
   * @param width Return location for the width, or <tt>0</tt>.
   * @param height Return location for the height, or <tt>0</tt>.
   */
  void get_size(float& width, float& height) const;
  
  /** Moves an actor by the specified distance relative to its current
   * position in pixels.
   * 
   * This function modifies the fixed position of an actor and thus removes
   * it from any layout management. Another way to move an actor is with an
   * anchor point, see set_anchor_point().
   * 
   * @newin{0,2}
   * @param dx Distance to move Actor on X axis.
   * @param dy Distance to move Actor on Y axis.
   */
  void move_by(float dx, float dy);

  
  /** Transforms @a point in coordinates relative to the actor
   * into screen-relative coordinates with the current actor
   * transformation (i.e.\ scale, rotation, etc)
   * 
   * @newin{0,4}
   * @param point A point as Clutter::Vertex.
   * @param vertex The translated Clutter::Vertex.
   */
  void apply_transform_to_point(const Vertex& point, Vertex& vertex) const;
  
  /** This function translates screen coordinates ( @a x, @a y) to
   * coordinates relative to the actor. For example, it can be used to translate
   * screen events from global screen coordinates into actor-local coordinates.
   * 
   * The conversion can fail, notably if the transform stack results in the
   * actor being projected on the screen as a mere line.
   * 
   * The conversion should not be expected to be pixel-perfect due to the
   * nature of the operation. In general the error grows when the skewing
   * of the actor rectangle on screen increases.
   * 
   * @note This function is fairly computationally intensive.
   * 
   * @note This function only works when the allocation is up-to-date,
   * i.e. inside of paint()
   * 
   * @newin{0,6}
   * @param x X screen coordinate of the point to unproject.
   * @param y Y screen coordinate of the point to unproject.
   * @param x_out Return location for the unprojected x coordinance.
   * @param y_out Return location for the unprojected y coordinance.
   * @return <tt>true</tt> if conversion was successful.
   */
  void transform_stage_point(float x, float y, float& x_out, float& y_out) const;

  
  /** This function is used to emit an event on the main stage.
   * You should rarely need to use this function, except for
   * synthetising events.
   * 
   * @newin{0,6}
   * @param event A Clutter::Event.
   * @param capture <tt>true</tt> if event in in capture phase, <tt>false</tt> otherwise.
   * @return The return value from the signal emission: <tt>true</tt>
   * if the actor handled the event, or <tt>false</tt> if the event was
   * not handled.
   */
  bool event(ClutterEvent* event, bool capture);
  
  /** Retrieves the Clutter::Actor with @a id.
   * 
   * @newin{0,6}
   * @param id A Clutter::Actor ID.
   * @return The actor with the passed id or <tt>0</tt>.
   * The returned actor does not have its reference count increased.
   */
  static Glib::RefPtr<Actor> get_actor_by_gid(guint32 id);

  
  /** Sets an anchor point for @a self. The anchor point is a point in the
   * coordinate space of an actor to which the actor position within its
   * parent is relative; the default is (0, 0), i.e. the top-left corner
   * of the actor.
   * 
   * @newin{0,6}
   * @param anchor_x X coordinate of the anchor point.
   * @param anchor_y Y coordinate of the anchor point.
   */
  void set_anchor_point(float anchor_x, float anchor_y);
  
  /** Gets the current anchor point of the @a actor in pixels.
   * 
   * @newin{0,6}
   * @param anchor_x Return location for the X coordinate of the anchor point.
   * @param anchor_y Return location for the Y coordinate of the anchor point.
   */
  void get_anchor_point(float& anchor_x, float& anchor_y) const;
  
  /** Sets an anchor point on the actor, based on the given gravity (this is a
   * convenience function wrapping set_anchor_point()).
   * 
   * Since version 1.0 the anchor point will be stored as a gravity so
   * that if the actor changes size then the anchor point will move. For
   * example, if you set the anchor point to Clutter::GRAVITY_SOUTH_EAST
   * and later double the size of the actor, the anchor point will move
   * to the bottom right.
   * 
   * @newin{0,6}
   * @param gravity Clutter::Gravity.
   */
  void set_anchor_point_from_gravity(ClutterGravity gravity);
  
  /** Retrieves the anchor position expressed as a Clutter::Gravity. If
   * the anchor point was specified using pixels or units this will
   * return Clutter::GRAVITY_NONE.
   * 
   * @newin{1,0}
   * @return The Clutter::Gravity used by the anchor point.
   */
  Gravity get_anchor_point_gravity();

  
  /** Sets the key focus of the Clutter::Stage including @a self
   * to this Clutter::Actor.
   * 
   * @newin{1,0}
   */
  void grab_key_focus();

// Animation API
  // Hand coded to use std::map instead of the 3 arguments used by C API
  

  //TODO: Documentation.
  Glib::RefPtr<Animation> animate(gulong mode, unsigned int duration, const std::map<std::string, Glib::ValueBase>& properties);
  Glib::RefPtr<Animation> animate(gulong mode, const Glib::RefPtr<Timeline>& timeline, const std::map<std::string, Glib::ValueBase>& properties);
  Glib::RefPtr<Animation> animate(const Glib::RefPtr<Alpha>& alpha, const std::map<std::string, Glib::ValueBase>& properties);
  
  
  /** Retrieves the Clutter::Animation used by @a actor, if animate()
   * has been called on @a actor.
   * 
   * @newin{1,0}
   * @return A Clutter::Animation, or <tt>0</tt>.
   */
  Glib::RefPtr<Animation> get_animation();
  
  /** Retrieves the Clutter::Animation used by @a actor, if animate()
   * has been called on @a actor.
   * 
   * @newin{1,0}
   * @return A Clutter::Animation, or <tt>0</tt>.
   */
  Glib::RefPtr<const Animation> get_animation() const;

  
  /** Should be used by actors implementing the Clutter::Container and with
   * internal children added through set_parent(), for instance:
   * 
   * |[
   * static void
   * my_actor_init (MyActor *self)
   * {
   * self->priv = SELF_ACTOR_GET_PRIVATE (self);
   * 
   * clutter_actor_push_internal (CLUTTER_ACTOR (self));
   * 
   * / * calling set_parent() now will result in
   * * the internal flag being set on a child of MyActor
   * * /
   * 
   * / * internal child: a background texture * /
   * self->priv->background_tex = Clutter::Texture::new();
   * clutter_actor_set_parent (self->priv->background_tex,
   * CLUTTER_ACTOR (self));
   * 
   * / * internal child: a label * /
   * self->priv->label = Clutter::Text::new();
   * clutter_actor_set_parent (self->priv->label,
   * CLUTTER_ACTOR (self));
   * 
   * clutter_actor_pop_internal (CLUTTER_ACTOR (self));
   * 
   * / * calling set_parent() now will not result in
   * * the internal flag being set on a child of MyActor
   * * /
   * }
   * ]|
   * 
   * This function will be used by Clutter to toggle an "internal child"
   * flag whenever set_parent() is called; internal children
   * are handled differently by Clutter, specifically when destroying their
   * parent.
   * 
   * Call pop_internal() when you finished adding internal
   * children.
   * 
   * Nested calls to push_internal() are allowed, but each
   * one must by followed by a pop_internal() call.
   * 
   * @newin{1,2}
   */
  void push_internal();
  
  /** Disables the effects of pop_internal()
   * 
   * @newin{1,2}
   */
  void pop_internal();

// signals
  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_press_event(ButtonEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_release_event(ButtonEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%motion_event(MotionEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,MotionEvent* > signal_motion_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%leave_event(CrossingEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_leave_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%show()</tt>
   */

  Glib::SignalProxy0< void > signal_show();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%hide()</tt>
   */

  Glib::SignalProxy0< void > signal_hide();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%destroy()</tt>
   */

  Glib::SignalProxy0< void > signal_destroy();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_release_event(KeyEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%enter_event(CrossingEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_enter_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%event(Event* event)</tt>
   */

  Glib::SignalProxy1< bool,Event* > signal_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%key_focus_out()</tt>
   */

  Glib::SignalProxy0< void > signal_key_focus_out();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%key_focus_in()</tt>
   */

  Glib::SignalProxy0< void > signal_key_focus_in();

 
  /**
   * @par Prototype:
   * <tt>void on_my_%parent_set(const Glib::RefPtr<Actor>& old_parent)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_parent_set();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%scroll_event(ScrollEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,ScrollEvent* > signal_scroll_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_press_event(KeyEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%captured_event(Event* event)</tt>
   */

  Glib::SignalProxy1< bool,Event* > signal_captured_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%paint()</tt>
   */

  Glib::SignalProxy0< void > signal_paint();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%queue_redaw(const Glib::RefPtr<Actor>& origin)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_queue_redaw();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%queue_relayout()</tt>
   */

  Glib::SignalProxy0< void > signal_queue_relayout();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%realize()</tt>
   */

  Glib::SignalProxy0< void > signal_realize();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%unrealize()</tt>
   */

  Glib::SignalProxy0< void > signal_unrealize();


  /**
   * @par Prototype:
   * <tt>void on_my_%pick(const Color& color)</tt>
   */

  Glib::SignalProxy1< void,const Color& > signal_pick();


  /**
   * @par Prototype:
   * <tt>void on_my_%allocation_changed(const ActorBox& box, AllocationFlags flags)</tt>
   */

  Glib::SignalProxy2< void,const ActorBox&,AllocationFlags > signal_allocation_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ActorBox> property_allocation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_anchor_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_anchor_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_anchor_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_anchor_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The anchor point as a ClutterGravity.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gravity> property_anchor_gravity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The anchor point as a ClutterGravity.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gravity> property_anchor_gravity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The clip region for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Geometry> property_clip() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The clip region for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Geometry> property_clip() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Sets the clip region to track the actor's allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_clip_to_allocation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Sets the clip region to track the actor's allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_clip_to_allocation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Position on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_depth() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Position on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_depth() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use fixed positioning for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_fixed_position_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use fixed positioning for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_fixed_position_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced X position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_fixed_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced X position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_fixed_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced Y position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_fixed_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced Y position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_fixed_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor has a clip set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_clip() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor contains the pointer of an input device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_pointer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum height request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_min_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum height request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_min_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-height property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_min_height_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-height property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_min_height_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum width request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_min_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum width request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_min_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-width property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_min_width_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-width property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_min_width_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Opacity of an actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint8> property_opacity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Opacity of an actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint8> property_opacity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is reactive to events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_reactive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is reactive to events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_reactive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's request mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<RequestMode> property_request_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's request mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<RequestMode> property_request_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_rotation_angle_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_rotation_angle_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_rotation_angle_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_rotation_angle_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_rotation_angle_z() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_rotation_angle_z() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Vertex> property_rotation_center_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Vertex> property_rotation_center_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Vertex> property_rotation_center_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Vertex> property_rotation_center_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Vertex> property_rotation_center_z() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Vertex> property_rotation_center_z() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Center point for rotation around the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gravity> property_rotation_center_z_gravity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Center point for rotation around the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gravity> property_rotation_center_z_gravity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_scale_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_scale_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_scale_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_scale_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Horizontal scale center.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_scale_center_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Horizontal scale center.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_scale_center_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Vertical scale center.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_scale_center_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Vertical scale center.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_scale_center_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The center of scaling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gravity> property_scale_gravity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The center of scaling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gravity> property_scale_gravity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is shown when parented.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_on_set_parent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is shown when parented.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_on_set_parent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<TextDirection> property_text_direction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<TextDirection> property_text_direction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  
  /** Sets the value for a named parameter of the shader applied
   * to @a actor.
   * 
   * @newin{1,0}
   * @param param The name of the parameter.
   * @param value The value of the parameter.
   */
  void set_shader_param_value(const Glib::ustring& param, const Glib::ValueBase& value);

  //TODO: Add new vfuncs.
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void show_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void hide_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  // TODO: I think we need to hand-code the vfuncs if we need to handle
  // the float* being NULL.
   

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_preferred_width_vfunc(float for_height, float& min_width_p, float& natural_width_p) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_preferred_height_vfunc(float for_width, float& min_height_p, float& natural_height_p) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void allocate_vfunc(const ActorBox& box, AllocationFlags absolute_origin_changed);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_button_press_event(ButtonEvent* event);
  virtual bool on_button_release_event(ButtonEvent* event);
  virtual bool on_motion_event(MotionEvent* event);
  virtual bool on_leave_event(CrossingEvent* event);
  virtual void on_show();
  virtual void on_hide();
  virtual void on_destroy();
  virtual bool on_key_release_event(KeyEvent* event);
  virtual bool on_enter_event(CrossingEvent* event);
  virtual bool on_event(Event* event);
  virtual void on_key_focus_out();
  virtual void on_key_focus_in();
  virtual void on_parent_set(const Glib::RefPtr<Actor>& old_parent);
  virtual bool on_scroll_event(ScrollEvent* event);
  virtual bool on_key_press_event(KeyEvent* event);
  virtual bool on_captured_event(Event* event);
  virtual void on_paint();
  virtual void on_queue_redaw(const Glib::RefPtr<Actor>& origin);
  virtual void on_queue_relayout();
  virtual void on_realize();
  virtual void on_unrealize();
  virtual void on_pick(const Color& color);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <class ParamType>
void Actor::set_shader_param(const Glib::ustring& param, const ParamType& value)
{
  Glib::Value<ParamType> param_value;
  param_value.init(Glib::Value<ParamType>::value_type());

  param_value.set(value);
  this->set_shader_param_value(param, param_value);
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Clutter


namespace Glib
{

/** @relates Clutter::ActorBox
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::ActorBox& wrap(ClutterActorBox* object);

/** @relates Clutter::ActorBox
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::ActorBox& wrap(const ClutterActorBox* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::ActorBox> : public Glib::Value_Boxed<Clutter::ActorBox>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Actor
   */
  Glib::RefPtr<Clutter::Actor> wrap(ClutterActor* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ACTOR_H */

