// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_SCRIPTABLE_H
#define _CLUTTERMM_SCRIPTABLE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <glibmm/ustring.h>
#include <cluttermm/script.h>
#include <clutter/clutter.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterScriptable ClutterScriptable;
typedef struct _ClutterScriptableClass ClutterScriptableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Scriptable_Class; } // namespace Clutter
namespace Clutter
{


class Scriptable : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Scriptable CppObjectType;
  typedef Scriptable_Class CppClassType;
  typedef ClutterScriptable BaseObjectType;
  typedef ClutterScriptableIface BaseClassType;

private:
  friend class Scriptable_Class;
  static CppClassType scriptable_class_;

  // noncopyable
  Scriptable(const Scriptable&);
  Scriptable& operator=(const Scriptable&);

protected:
  Scriptable(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Scriptable(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Scriptable(ClutterScriptable* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Scriptable();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterScriptable*       gobj()       { return reinterpret_cast<ClutterScriptable*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const ClutterScriptable* gobj() const { return reinterpret_cast<ClutterScriptable*>(gobject_); }

private:


public:
  
  /** Sets @a id as the unique Clutter script it for this instance of
   * Clutter::ScriptableIface.
   * 
   * This name can be used by user interface designer applications to
   * define a unique name for an object constructable using the UI
   * definition language parsed by Clutter::Script.
   * 
   * @newin{0,6}
   * @param id The Clutter::Script id of the object.
   */
  void set_id(const std::string& id);
  
  /** Retrieves the id of @a scriptable set using set_id().
   * 
   * @newin{0,6}
   * @return The id of the object. The returned string is owned by
   * the scriptable object and should never be modified of freed.
   */
  std::string get_id() const;

  // TODO: Wrap glib-json?
  

  /** Parses the passed JSON node. The implementation must set the type
   * of the passed Value pointer using Glib::value_init().
   * 
   * @newin{0,6}
   * @param script The Clutter::Script creating the scriptable instance.
   * @param value The generic value to be set.
   * @param name The name of the node.
   * @param node The JSON node to be parsed.
   * @return <tt>true</tt> if the node was successfully parsed, <tt>false</tt> otherwise.
   */
  bool parse_custom_node(const Glib::RefPtr<Script>& script, Glib::ValueBase& value, const Glib::ustring& name, JsonNode* node);
  
  /** Overrides the common properties setting. The underlying virtual
   * function should be used when implementing custom properties.
   * 
   * @newin{0,6}
   * @param script The Clutter::Script creating the scriptable instance.
   * @param name The name of the property.
   * @param value The value of the property.
   */
  void set_custom_property(const Glib::RefPtr<Script>& script, const Glib::ustring& name, const Glib::ValueBase& value);

protected:

    virtual void set_id_vfunc(const std::string& id);


  // Note: We cannot return a std::string here since the C API expects a
  // const gchar* as return value. const gchar* however means that the returned
  // value is not supposed to be freed by the caller. If we would want to return
  // std::string here, what should we pass to the underlying C API then?
  // string.c_str() doesn't work since the string destroys the data upon
  // destruction (which means, we would effectively return an invalid pointer).
  // We also can't copy the string's content since we would leak that copy
  // otherwise.
    virtual const char* get_id_vfunc() const;


    virtual void set_custom_property_vfunc(const Glib::RefPtr<Script>& script, const Glib::ustring& name, const Glib::ValueBase& value);


  // TODO: parse_custom_node vfunc


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter
//vim: ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Scriptable
   */
  Glib::RefPtr<Clutter::Scriptable> wrap(ClutterScriptable* object, bool take_copy = false);

} // namespace Glib


#endif /* _CLUTTERMM_SCRIPTABLE_H */

