// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ANIMATABLE_H
#define _CLUTTERMM_ANIMATABLE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 207 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <glibmm/ustring.h>
#include <glibmm/value.h>
#include <cluttermm/interval.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
typedef struct _ClutterAnimatableIface ClutterAnimatableIface;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterAnimatable ClutterAnimatable;
typedef struct _ClutterAnimatableClass ClutterAnimatableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Animatable_Class; } // namespace Clutter
namespace Clutter
{

class Interval;


class Animatable : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Animatable CppObjectType;
  typedef Animatable_Class CppClassType;
  typedef ClutterAnimatable BaseObjectType;
  typedef ClutterAnimatableIface BaseClassType;

private:
  friend class Animatable_Class;
  static CppClassType animatable_class_;

  // noncopyable
  Animatable(const Animatable&);
  Animatable& operator=(const Animatable&);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  Animatable();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Animatable(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Animatable(ClutterAnimatable* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Animatable();

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterAnimatable*       gobj()       { return reinterpret_cast<ClutterAnimatable*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterAnimatable* gobj() const { return reinterpret_cast<ClutterAnimatable*>(gobject_); }

private:


public:
  //no constructor- virtual base class.

  //TODO: Maybe we shouldn't bother wrapping this? It might not be useful and we have no GParamSpec wrapper:
  
  /** Finds the ParamSpec for @a property_name
   * 
   * @newin{1,4}
   * @param property_name The name of the animatable property to find.
   * @return The ParamSpec for the given property
   * or <tt>0</tt>.
   */
  GParamSpec* find_property(const Glib::ustring& property_name);

  
  /** Retrieves the current state of @a property_name and sets @a value with it
   * 
   * @newin{1,4}
   * @param property_name The name of the animatable property to retrieve.
   * @param value A Value initialized to the type of the property to retrieve.
   */
  void get_initial_state_value(const Glib::ustring& property_name, Glib::ValueBase& value) const;
  
  /** Sets the current state of @a property_name to @a value
   * 
   * @newin{1,4}
   * @param property_name The name of the animatable property to set.
   * @param value The value of the animatable property to set.
   */
  void set_final_state_value(const Glib::ustring& property_name, const Glib::ValueBase& value);

  
  /** Asks a Clutter::Animatable implementation to interpolate a
   * a named property between the initial and final values of
   * a Clutter::Interval, using @a progress as the interpolation
   * value, and store the result inside @a value.
   * 
   * This function should be used for every property animation
   * involving Clutter::Animatable<!-- -->s.
   * 
   * This function replaces animate_property().
   * 
   * @newin{1,8}
   * @param property_name The name of the property to interpolate.
   * @param interval A Clutter::Interval with the animation range.
   * @param progress The progress to use to interpolate between the
   * initial and final values of the @a interval.
   * @param value Return location for an initialized Value
   * using the same type of the @a interval.
   * @return <tt>true</tt> if the interpolation was successful,
   * and <tt>false</tt> otherwise.
   */
  void interpolate_value_value(const Glib::ustring& property_name, const Glib::RefPtr<const Interval>& interval, double progress, Glib::ValueBase& value);

  /**
   * Gets the initial state of an animation
   *
   * @param property_name the name of the animatable property to retrieve
   * @param value the value of the property.
   */
  template <class ValueType>
  void get_initial_state(const Glib::ustring& property_name, ValueType& value) const;

  /**
   * Sets the final state for an animation.
   *
   * @param property_name the name of the animatable property to set.
   * @param value a value of the appropriate type.
   */
  template <class ValueType>
  void set_final_state(const Glib::ustring& property_name, const ValueType& value);


  //TODO: Documentation
  template <class ValueType>
  bool interpolate(const Glib::ustring& property_name,
    const Glib::RefPtr<const Interval>& interval,
    double progress,
    ValueType& value);

protected:

  //TODO: Maybe we shouldn't bother wrapping this? It might not be useful and we have no GParamSpec wrapper:
    virtual GParamSpec* find_property_vfunc(const Glib::ustring& property_name);


    virtual void get_initial_state_vfunc(const Glib::ustring& property_name, Glib::ValueBase& value);

    virtual void set_final_state_vfunc(const Glib::ustring& property_name, const Glib::ValueBase& value);


  //TODO: this function doesn't wrap.  removed from build for the present.
  //_WRAP_VFUNC(bool interpolate_value(const Glib::ustring& property_name, const Glib::RefPtr<const Interval>& interval, double progress, Glib::ValueBase& value), interpolate_value)


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};


template <class ValueType>
void Animatable::get_initial_state(const Glib::ustring& property_name, ValueType& value) const
{
  Glib::Value<ValueType> glibmm_g_value;
  glibmm_g_value.init(Glib::Value<ValueType>::value_type());

  get_initial_state(property_name, glibmm_g_value);
  value = glibmm_g_value.get();
}

template <class ValueType>
void Animatable::set_final_state(const Glib::ustring& property_name, const ValueType& value)
{
  Glib::Value<ValueType> glibmm_g_value;
  glibmm_g_value.init(Glib::Value<ValueType>::value_type());
  glibmm_g_value.set(value);

  set_final_state_value(property_name, glibmm_g_value);
}

template <class ValueType>
bool Animatable::interpolate(const Glib::ustring& property_name,
  const Glib::RefPtr<const Interval>& interval,
  double progress,
  ValueType& value)
{
  Glib::Value<ValueType> glibmm_g_value;
  glibmm_g_value.init(Glib::Value<ValueType>::value_type());
  glibmm_g_value.set(value);

  const bool out = interpolate_value_value(
    gobj(),
    property_name,
    interval,
    progress,
    glibmm_g_value);

  value = glibmm_g_value.get();
  return out;
}

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Animatable
   */
  Glib::RefPtr<Clutter::Animatable> wrap(ClutterAnimatable* object, bool take_copy = false);

} // namespace Glib


#endif /* _CLUTTERMM_ANIMATABLE_H */

