// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BACKEND_H
#define _CLUTTERMM_BACKEND_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2009-2014 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cairomm/fontoptions.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBackend ClutterBackend;
typedef struct _ClutterBackendClass ClutterBackendClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Backend_Class; } // namespace Clutter
namespace Clutter
{


class Backend :
  public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Backend CppObjectType;
  typedef Backend_Class CppClassType;
  typedef ClutterBackend BaseObjectType;
  typedef ClutterBackendClass BaseClassType;

private:  friend class Backend_Class;
  static CppClassType backend_class_;

private:
  // noncopyable
  Backend(const Backend&);
  Backend& operator=(const Backend&);

protected:
  explicit Backend(const Glib::ConstructParams& construct_params);
  explicit Backend(ClutterBackend* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Backend();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBackend*       gobj()       { return reinterpret_cast<ClutterBackend*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBackend* gobj() const { return reinterpret_cast<ClutterBackend*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBackend* gobj_copy();

private:


protected:
  Backend();

public:
  
  /** Retrieves the default Clutter::Backend used by Clutter. The
   * Clutter::Backend holds backend-specific configuration options.
   * 
   * @newin{0,4}
   * @return The default backend. You should
   * not ref or unref the returned object. Applications should rarely
   * need to use this.
   */
  static Glib::RefPtr<Backend> get_default();

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Gets the resolution for font handling on the screen.
   * 
   * The resolution is a scale factor between points specified in a
   * Pango::FontDescription and cairo units. The default value is 96.0,
   * meaning that a 10 point font will be 13 units
   * high (10 * 96. / 72. = 13.3).
   * 
   * Clutter will set the resolution using the current backend when
   * initializing; the resolution is also stored in the
   * Clutter::Settings::property_font_dpi() property.
   * 
   * @newin{0,4}
   * @deprecated Use Settings's front-dpi property instead.
   * @return The current resolution, or -1 if no resolution
   * has been set.
   */
  double get_resolution() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the resolution for font handling on the screen. This is a
   * scale factor between points specified in a Pango::FontDescription
   * and cairo units. The default value is 96, meaning that a 10 point
   * font will be 13 units high. (10 * 96. / 72. = 13.3).
   * 
   * Applications should never need to call this function.
   * 
   * @newin{0,4}
   * 
   * Deprecated: 1.4: Use Clutter::Settings::property_font_dpi() instead
   * @deprecated Use Settings's front-dpi property instead.
   * @param dpi The resolution in "dots per inch" (Physical inches aren't
   * actually involved; the terminology is conventional).
   */
  void set_resolution(double dpi);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Gets the maximum time between two button press events, as set
   * by set_double_click_time().
   * 
   * @newin{0,4}
   * 
   * Deprecated: 1.4: Use Clutter::Settings::property_double_click_time() instead
   * @deprecated Use Settings's double-click-time property instead.
   * @return A time in milliseconds.
   */
  guint get_double_click_time() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the maximum time between two button press events, used to
   * verify whether it's a double click event or not.
   * 
   * @newin{0,4}
   * 
   * Deprecated: 1.4: Use Clutter::Settings::property_double_click_time() instead
   * @deprecated Use Settings's double-click-time property instead.
   * @param msec Milliseconds between two button press events.
   */
  void set_double_click_time(guint msec);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the distance used to verify a double click event
   * 
   * @newin{0,4}
   * 
   * Deprecated: 1.4: Use Clutter::Settings::property_double_click_distance() instead
   * @deprecated Use Settings's double-click-distance property instead.
   * @return A distance, in pixels.
   */
  guint get_double_click_distance() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the maximum distance used to verify a double click event.
   * 
   * @newin{0,4}
   * 
   * Deprecated: 1.4: Use Clutter::Settings::property_double_click_distance() instead
   * @deprecated Use Settings's double-click-distance property instead.
   * @param distance A distance, in pixels.
   */
  void set_double_click_distance(guint distance);
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Retrieves the font options for @a backend.
   * 
   * @newin{0,8}
   * @return The font options of the Clutter::Backend.
   * The returned #cairo_font_options_t is owned by the backend and should
   * not be modified or freed.
   */
  ::Cairo::FontOptions get_font_options() const;
  
  /** Sets the new font options for @a backend. The Clutter::Backend will
   * copy the #cairo_font_options_t.
   * 
   * If @a options is <tt>0</tt>, the first following call to
   * get_font_options() will return the default font
   * options for @a backend.
   * 
   * This function is intended for actors creating a Pango layout
   * using the PangoCairo API.
   * 
   * @newin{0,8}
   * @param options Cairo font options for the backend, or <tt>0</tt>.
   */
  void set_font_options(const ::Cairo::FontOptions& options);

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the default font name as set by
   * set_font_name().
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.4: Use Clutter::Settings::property_font_name() instead
   * @deprecated Use Settings's font-name property instead.
   * @return The font name for the backend. The returned string is
   * owned by the Clutter::Backend and should never be modified or freed.
   */
  Glib::ustring get_font_name() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the default font to be used by Clutter. The @a font_name string
   * must either be <tt>0</tt>, which means that the font name from the
   * default Clutter::Backend will be used; or be something that can
   * be parsed by the pango_font_description_from_string() function.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.4: Use Clutter::Settings::property_font_name() instead
   * @deprecated Use Settings's font-name property instead.
   * @param font_name The name of the font.
   */
  void set_font_name(const Glib::ustring& font_name);
#endif // CLUTTERMM_DISABLE_DEPRECATED


  //Experimental API: clutter_backend_get_cogl_context

  //We use no_default_handler because the C class struct is hidden. TODO: Is this still true.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%font_changed()</tt>
   *
   * The signal_font_changed() signal is emitted each time the font options
   * have been changed through Clutter::Settings.
   * 
   * @newin{1,0}
   */

  Glib::SignalProxy0< void > signal_font_changed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%resolution_changed()</tt>
   *
   * The signal_resolution_changed() signal is emitted each time the font
   * resolutions has been changed through Clutter::Settings.
   * 
   * @newin{1,0}
   */

  Glib::SignalProxy0< void > signal_resolution_changed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%settings_changed()</tt>
   *
   * The signal_settings_changed() signal is emitted each time the Clutter::Settings
   * properties have been changed.
   * 
   * @newin{1,4}
   */

  Glib::SignalProxy0< void > signal_settings_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter

//vim: ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Backend
   */
  Glib::RefPtr<Clutter::Backend> wrap(ClutterBackend* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BACKEND_H */

