// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BIND_CONSTRAINT_H
#define _CLUTTERMM_BIND_CONSTRAINT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2013 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/constraint.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBindConstraint ClutterBindConstraint;
typedef struct _ClutterBindConstraintClass ClutterBindConstraintClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class BindConstraint_Class; } // namespace Clutter
namespace Clutter
{

class Actor;

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var BindCoordinate BIND_X
 *  Bind the X coordinate.
 * 
 *  @var BindCoordinate BIND_Y
 *  Bind the Y coordinate.
 * 
 *  @var BindCoordinate BIND_WIDTH
 *  Bind the width.
 * 
 *  @var BindCoordinate BIND_HEIGHT
 *  Bind the height.
 * 
 *  @var BindCoordinate BIND_POSITION
 *  Equivalent to to Clutter::BIND_X and Clutter::BIND_Y (added in Clutter 1.6).
 * 
 *  @var BindCoordinate BIND_SIZE
 *  Equivalent to Clutter::BIND_WIDTH and Clutter::BIND_HEIGHT (added in Clutter 1.6).
 * 
 *  @var BindCoordinate BIND_ALL
 *  Equivalent to Clutter::BIND_POSITION and Clutter::BIND_SIZE (added in Clutter 1.10).
 * 
 *  @enum BindCoordinate
 * 
 * Specifies which property should be used in a binding
 * 
 * @newin{1,4}
 * @ingroup cluttermmEnums
 */
enum BindCoordinate
{
  BIND_X,
  BIND_Y,
  BIND_WIDTH,
  BIND_HEIGHT,
  BIND_POSITION,
  BIND_SIZE,
  BIND_ALL
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::BindCoordinate> : public Glib::Value_Enum<Clutter::BindCoordinate>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


//TODO: rewrite the example code.
/**
 * BindConstraint is a Constraint that binds the position or the size of the
 * Actor to which it is applied to the the position or the size of another
 * Actor, or "source".
 *
 * An offset can be applied to the constraint, to avoid overlapping. The offset
 * can also be animated.
 */

class BindConstraint : public Constraint
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BindConstraint CppObjectType;
  typedef BindConstraint_Class CppClassType;
  typedef ClutterBindConstraint BaseObjectType;
  typedef ClutterBindConstraintClass BaseClassType;

private:  friend class BindConstraint_Class;
  static CppClassType bindconstraint_class_;

private:
  // noncopyable
  BindConstraint(const BindConstraint&);
  BindConstraint& operator=(const BindConstraint&);

protected:
  explicit BindConstraint(const Glib::ConstructParams& construct_params);
  explicit BindConstraint(ClutterBindConstraint* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BindConstraint();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBindConstraint*       gobj()       { return reinterpret_cast<ClutterBindConstraint*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBindConstraint* gobj() const { return reinterpret_cast<ClutterBindConstraint*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBindConstraint* gobj_copy();

private:

  
protected:
    explicit BindConstraint(const Glib::RefPtr<Actor>& source, BindCoordinate coordinate, float offset);


public:
  
  static Glib::RefPtr<BindConstraint> create(const Glib::RefPtr<Actor>& source, BindCoordinate coordinate, float offset);


  /** Sets the source Clutter::Actor for the constraint
   * 
   * @newin{1,4}
   * @param source A Clutter::Actor, or <tt>0</tt> to unset the source.
   */
  void set_source(const Glib::RefPtr<Actor>& source);

  
  /** Retrieves the Clutter::Actor set using set_source()
   * 
   * @newin{1,4}
   * @return A pointer to the source actor.
   */
  Glib::RefPtr<Actor> get_source();
  
  /** Retrieves the Clutter::Actor set using set_source()
   * 
   * @newin{1,4}
   * @return A pointer to the source actor.
   */
  Glib::RefPtr<const Actor> get_source() const;

  
  /** Sets the coordinate to bind in the constraint
   * 
   * @newin{1,4}
   * @param coordinate The coordinate to bind.
   */
  void set_coordinate(BindCoordinate coordinate);
  
  /** Retrieves the bound coordinate of the constraint
   * 
   * @newin{1,4}
   * @return The bound coordinate.
   */
  BindCoordinate get_coordinate() const;

  
  /** Sets the offset to be applied to the constraint
   * 
   * @newin{1,4}
   * @param offset The offset to apply, in pixels.
   */
  void set_offset(float offset);
  
  /** Retrieves the offset set using set_offset()
   * 
   * @newin{1,4}
   * @return The offset, in pixels.
   */
  float get_offset() const;

protected:
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The coordinate to bind.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< BindCoordinate > property_coordinate() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The coordinate to bind.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< BindCoordinate > property_coordinate() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The offset in pixels to apply to the binding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_offset() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The offset in pixels to apply to the binding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_offset() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The source of the binding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Actor> > property_source() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The source of the binding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Actor> > property_source() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::BindConstraint
   */
  Glib::RefPtr<Clutter::BindConstraint> wrap(ClutterBindConstraint* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BIND_CONSTRAINT_H */

