// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TEXT_H
#define _CLUTTERMM_TEXT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (c) 2009  The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <cluttermm/actor.h>
#include <glibmm/refptr.h>
#include <glibmm/ustring.h>
#include <cluttermm/types.h>

#include <pangomm.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterText ClutterText;
typedef struct _ClutterTextClass ClutterTextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Text_Class; } // namespace Clutter
namespace Clutter
{

class TextBuffer;
class Color;


class Text : public Actor
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Text CppObjectType;
  typedef Text_Class CppClassType;
  typedef ClutterText BaseObjectType;
  typedef ClutterTextClass BaseClassType;

private:  friend class Text_Class;
  static CppClassType text_class_;

private:
  // noncopyable
  Text(const Text&);
  Text& operator=(const Text&);

protected:
  explicit Text(const Glib::ConstructParams& construct_params);
  explicit Text(ClutterText* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Text();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterText*       gobj()       { return reinterpret_cast<ClutterText*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterText* gobj() const { return reinterpret_cast<ClutterText*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterText* gobj_copy();

private:


protected:
  Text();
    explicit Text(const Glib::ustring& font_name, const Glib::ustring& text);

    explicit Text(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color);

    explicit Text(const Glib::RefPtr<TextBuffer>& buffer);


public:
  
  static Glib::RefPtr<Text> create();

  
  static Glib::RefPtr<Text> create(const Glib::ustring& font_name, const Glib::ustring& text);

  
  static Glib::RefPtr<Text> create(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color);

  
  static Glib::RefPtr<Text> create(const Glib::RefPtr<TextBuffer>& buffer);


  /** Set the Clutter::TextBuffer object which holds the text for
   * this widget.
   * 
   * @newin{1,10}
   * @param buffer A Clutter::TextBuffer.
   */
  void set_buffer(const Glib::RefPtr<TextBuffer>& buffer);

  
  /** Get the Clutter::TextBuffer object which holds the text for
   * this widget.
   * 
   * @newin{1,10}
   * @return A Gtk::EntryBuffer object.
   */
  Glib::RefPtr<TextBuffer> get_buffer();
  
  /** Get the Clutter::TextBuffer object which holds the text for
   * this widget.
   * 
   * @newin{1,10}
   * @return A Gtk::EntryBuffer object.
   */
  Glib::RefPtr<const TextBuffer> get_buffer() const;

  
  /** Sets the contents of a Clutter::Text actor.
   * 
   * If the Clutter::Text::property_use_markup() property was set to <tt>true</tt> it
   * will be reset to <tt>false</tt> as a side effect. If you want to
   * maintain the Clutter::Text::property_use_markup() you should use the
   * set_markup() function instead
   * 
   * @newin{1,0}
   * @param text The text to set. Passing <tt>0</tt> is the same
   * as passing "" (the empty string).
   */
  void set_text(const Glib::ustring& text);
  
  /** Sets @a markup as the contents of a Clutter::Text.
   * 
   * This is a convenience function for setting a string containing
   * Pango markup, and it is logically equivalent to:
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{1,0}
   * @param markup A string containing Pango markup.
   * Passing <tt>0</tt> is the same as passing "" (the empty string).
   */
  void set_markup(const Glib::ustring& markup);
  
  /** Retrieves a pointer to the current contents of a Clutter::Text
   * actor.
   * 
   * If you need a copy of the contents for manipulating, either
   * use Glib::strdup() on the returned string, or use:
   * 
   * 
   * [C example ellipted]
   * 
   * Which will return a newly allocated string.
   * 
   * If the Clutter::Text actor is empty, this function will return
   * an empty string, and not <tt>0</tt>.
   * 
   * @newin{1,0}
   * @return The contents of the actor. The returned
   * string is owned by the Clutter::Text actor and should never be modified
   * or freed.
   */
  Glib::ustring get_text() const;

  
  /** Sets whether a Clutter::Text actor should be activatable.
   * 
   * An activatable Clutter::Text actor will emit the Clutter::Text::signal_activate()
   * signal whenever the 'Enter' (or 'Return') key is pressed; if it is not
   * activatable, a new line will be appended to the current content.
   * 
   * An activatable Clutter::Text must also be set as editable using
   * set_editable().
   * 
   * @newin{1,0}
   * @param activatable Whether the Clutter::Text actor should be activatable.
   */
  void set_activatable(bool activatable =  true);
  
  /** Retrieves whether a Clutter::Text is activatable or not.
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the actor is activatable.
   */
  bool get_activatable() const;

  //TODO: Should attrs be const?
  
  /** Sets the attributes list that are going to be applied to the
   * Clutter::Text contents.
   * 
   * The Clutter::Text actor will take a reference on the Pango::AttrList
   * passed to this function.
   * 
   * @newin{1,0}
   * @param attrs A Pango::AttrList or <tt>0</tt> to unset the attributes.
   */
  void set_attributes(Pango::AttrList& attrs);
  
  /** Gets the attribute list that was set on the Clutter::Text actor
   * set_attributes(), if any.
   * 
   * @newin{1,0}
   * @return The attribute list, or <tt>0</tt> if none was set. The
   * returned value is owned by the Clutter::Text and should not be unreferenced.
   */
  Pango::AttrList get_attributes() const;

  
  /** Sets the color of the contents of a Clutter::Text actor.
   * 
   * The overall opacity of the Clutter::Text actor will be the
   * result of the alpha value of @a color and the composited
   * opacity of the actor itself on the scenegraph, as returned
   * by Clutter::Actor::get_paint_opacity().
   * 
   * @newin{1,0}
   * @param color A Clutter::Color.
   */
  void set_color(const Color& color);

  
  /** Retrieves the text color as set by set_color().
   * 
   * @newin{1,0}
   * @param color Return location for a Clutter::Color.
   */

  Color get_color() const;
  

  /** Sets the mode used to ellipsize (add an ellipsis: "...") to the
   * text if there is not enough space to render the entire contents
   * of a Clutter::Text actor
   * 
   * @newin{1,0}
   * @param mode A Pango::EllipsizeMode.
   */
  void set_ellipsize(Pango::EllipsizeMode mode);
  
  /** Returns the ellipsizing position of a Clutter::Text actor, as
   * set by set_ellipsize().
   * 
   * @newin{1,0}
   * @return Pango::EllipsizeMode.
   */
  Pango::EllipsizeMode get_ellipsize() const;

  
  /** Sets the font used by a Clutter::Text. The @a font_name string
   * must either be <tt>0</tt>, which means that the font name from the
   * default Clutter::Backend will be used; or be something that can
   * be parsed by the pango_font_description_from_string() function,
   * like:
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{1,0}
   * @param font_name A font name, or <tt>0</tt> to set the default font name.
   */
  void set_font_name(const Glib::ustring& font_name);
  
  /** Retrieves the font name as set by set_font_name().
   * 
   * @newin{1,0}
   * @return A string containing the font name. The returned
   * string is owned by the Clutter::Text actor and should not be
   * modified or freed.
   */
  Glib::ustring get_font_name() const;

  
  /** Sets @a font_desc as the font description for a Clutter::Text
   * 
   * The Pango::FontDescription is copied by the Clutter::Text actor
   * so you can safely call pango_font_description_free() on it after
   * calling this function.
   * 
   * @newin{1,2}
   * @param font_desc A Pango::FontDescription.
   */
  void set_font_description(const Pango::FontDescription& font_desc);
 

  /** Retrieves the Pango::FontDescription used by @a self
   * 
   * @newin{1,2}
   * @return A Pango::FontDescription. The returned value is owned
   * by the Clutter::Text actor and it should not be modified or freed.
   */
  Pango::FontDescription get_font_description() const;

  
  /** Sets the character to use in place of the actual text in a
   * password text actor.
   * 
   * If @a wc is 0 the text will be displayed as it is entered in the
   * Clutter::Text actor.
   * 
   * @newin{1,0}
   * @param wc A Unicode character, or 0 to unset the password character.
   */
  void set_password_char(gunichar wc);
  
  /** Retrieves the character to use in place of the actual text
   * as set by set_password_char().
   * 
   * @newin{1,0}
   * @return A Unicode character or 0 if the password
   * character is not set.
   */
  gunichar get_password_char() const;

  
  /** Sets whether the text of the Clutter::Text actor should be justified
   * on both margins. This setting is ignored if Clutter is compiled
   * against Pango < 1.18.
   * 
   * @newin{1,0}
   * @param justify Whether the text should be justified.
   */
  void set_justify(bool justify =  true);
  
  /** Retrieves whether the Clutter::Text actor should justify its contents
   * on both margins.
   * 
   * @newin{0,6}
   * @return <tt>true</tt> if the text should be justified.
   */
  bool get_justify() const;

  
  /** Retrieves the current Pango::Layout used by a Clutter::Text actor.
   * 
   * @newin{1,0}
   * @return A Pango::Layout. The returned object is owned by
   * the Clutter::Text actor and should not be modified or freed.
   */
  Glib::RefPtr<Pango::Layout> get_layout();
  
  /** Retrieves the current Pango::Layout used by a Clutter::Text actor.
   * 
   * @newin{1,0}
   * @return A Pango::Layout. The returned object is owned by
   * the Clutter::Text actor and should not be modified or freed.
   */
  Glib::RefPtr<const Pango::Layout> get_layout() const;

  
  /** Sets the way that the lines of a wrapped label are aligned with
   * respect to each other. This does not affect the overall alignment
   * of the label within its allocated or specified width.
   * 
   * To align a Clutter::Text actor you should add it to a container
   * that supports alignment, or use the anchor point.
   * 
   * @newin{1,0}
   * @param alignment A Pango::Alignment.
   */
  void set_line_alignment(Pango::Alignment alignment);
  
  /** Retrieves the alignment of a Clutter::Text, as set by
   * set_line_alignment().
   * 
   * @newin{1,0}
   * @return A Pango::Alignment.
   */
  Pango::Alignment get_line_alignment() const;

  
  /** Sets whether the contents of a Clutter::Text actor should wrap,
   * if they don't fit the size assigned to the actor.
   * 
   * @newin{1,0}
   * @param line_wrap Whether the contents should wrap.
   */
  void set_line_wrap(bool line_wrap =  true);
  
  /** Retrieves the value set using set_line_wrap().
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the Clutter::Text actor should wrap
   * its contents.
   */
  bool get_line_wrap() const;

  
  /** Retrieves the line wrap mode used by the Clutter::Text actor.
   * 
   * See set_line_wrap_mode().
   * 
   * @newin{1,0}
   * @return The wrap mode used by the Clutter::Text.
   */
  Pango::WrapMode get_line_wrap_mode() const;
  
  /** If line wrapping is enabled (see set_line_wrap()) this
   * function controls how the line wrapping is performed. The default is
   * Pango::WRAP_WORD which means wrap on word boundaries.
   * 
   * @newin{1,0}
   * @param wrap_mode The line wrapping mode.
   */
  void set_line_wrap_mode(Pango::WrapMode wrap_mode);

  
  /** Gets the maximum length of text that can be set into a text actor.
   * 
   * See set_max_length().
   * 
   * @newin{1,0}
   * @return The maximum number of characters.
   */
  int get_max_length() const;
  
  /** Sets the maximum allowed length of the contents of the actor. If the
   * current contents are longer than the given length, then they will be
   * truncated to fit.
   * 
   * @newin{1,0}
   * @param max The maximum number of characters allowed in the text actor; 0
   * to disable or -1 to set the length of the current string.
   */
  void set_max_length(int max_length);

  
  /** Sets whether a Clutter::Text actor should be selectable.
   * 
   * A selectable Clutter::Text will allow selecting its contents using
   * the pointer or the keyboard.
   * 
   * @newin{1,0}
   * @param selectable Whether the Clutter::Text actor should be selectable.
   */
  void set_selectable(bool selectable =  true);
  
  /** Retrieves whether a Clutter::Text is selectable or not.
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the actor is selectable.
   */
  bool get_selectable() const;

  
  /** Selects the region of text between @a start_pos and @a end_pos.
   * 
   * This function changes the position of the cursor to match
   *  @a start_pos and the selection bound to match @a end_pos.
   * 
   * @newin{1,0}
   * @param start_pos Start of the selection, in characters.
   * @param end_pos End of the selection, in characters.
   */
  void set_selection(gssize start_pos, gssize end_pos);
  
  /** Retrieves the currently selected text.
   * 
   * @newin{1,0}
   * @return A newly allocated string containing the currently
   * selected text, or <tt>0</tt>. Use Glib::free() to free the returned
   * string.
   */
  Glib::ustring get_selection() const;

  
  /** Sets the other end of the selection, starting from the current
   * cursor position.
   * 
   * If @a selection_bound is -1, the selection unset.
   * 
   * @newin{1,0}
   * @param selection_bound The position of the end of the selection, in characters.
   */
  void set_selection_bound(int selection_bound);
  
  /** Retrieves the other end of the selection of a Clutter::Text actor,
   * in characters from the current cursor position.
   * 
   * @newin{1,0}
   * @return The position of the other end of the selection.
   */
  int get_selection_bound() const;

  
  /** Sets the color of the selection of a Clutter::Text actor.
   * 
   * If @a color is <tt>0</tt>, the selection color will be the same as the
   * cursor color, or if no cursor color is set either then it will be
   * the same as the text color.
   * 
   * @newin{1,0}
   * @param color The color of the selection, or <tt>0</tt> to unset it.
   */
  void set_selection_color(const Color& color);

  
  /** Retrieves the color of the selection of a Clutter::Text actor.
   * 
   * @newin{1,0}
   * @param color Return location for a Clutter::Color.
   */

  Color get_selection_color() const;
  

  /** Sets whether a Clutter::Text actor should be in single line mode
   * or not. Only editable Clutter::Text<!-- -->s can be in single line
   * mode.
   * 
   * A text actor in single line mode will not wrap text and will clip
   * the visible area to the predefined size. The contents of the
   * text actor will scroll to display the end of the text if its length
   * is bigger than the allocated width.
   * 
   * When setting the single line mode the Clutter::Text::property_activatable()
   * property is also set as a side effect. Instead of entering a new
   * line character, the text actor will emit the Clutter::Text::signal_activate()
   * signal.
   * 
   * @newin{1,0}
   * @param single_line Whether to enable single line mode.
   */
  void set_single_line_mode(bool single_line = true);
  
  /** Retrieves whether the Clutter::Text actor is in single line mode.
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the Clutter::Text actor is in single line mode.
   */
  bool get_single_line_mode() const;

  
  /** Retrieves the color of selected text of a Clutter::Text actor.
   * 
   * @newin{1,8}
   * @param color Return location for a Clutter::Color.
   */

  Color get_selected_text_color() const;
  

  /** Sets whether the contents of the Clutter::Text actor contains markup
   * in Pango's text markup language.
   * 
   * Setting Clutter::Text::property_use_markup() on an editable Clutter::Text will
   * not have any effect except hiding the markup.
   * 
   * See also Clutter::Text::property_use_markup().
   * 
   * @newin{1,0}
   * @param setting <tt>true</tt> if the text should be parsed for markup.
   */
  void set_use_markup(bool setting = true);
  
  /** Retrieves whether the contents of the Clutter::Text actor should be
   * parsed for the Pango text markup.
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the contents will be parsed for markup.
   */
  bool get_use_markup() const;

  
  /** Sets whether the Clutter::Text actor should be editable.
   * 
   * An editable Clutter::Text with key focus set using
   * Clutter::Actor::grab_key_focus() or Clutter::Stage::set_key_focus()
   * will receive key events and will update its contents accordingly.
   * 
   * @newin{1,0}
   * @param editable Whether the Clutter::Text should be editable.
   */
  void set_editable(bool editable = true);
  
  /** Retrieves whether a Clutter::Text is editable or not.
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the actor is editable.
   */
  bool get_editable() const;

  
  /** Inserts @a wc at the current cursor position of a
   * Clutter::Text actor.
   * 
   * @newin{1,0}
   * @param wc A Unicode character.
   */
  void insert(gunichar wc);
  
  /** Inserts @a text into a Clutter::Actor at the given position.
   * 
   * If @a position is a negative number, the text will be appended
   * at the end of the current contents of the Clutter::Text.
   * 
   * The position is expressed in characters, not in bytes.
   * 
   * @newin{1,0}
   * @param text The text to be inserted.
   * @param position The position of the insertion, or -1.
   */
  void insert(const Glib::ustring& text, gssize position);

  
  /** Deletes @a n_chars inside a Clutter::Text actor, starting from the
   * current cursor position.
   * 
   * Somewhat awkwardly, the cursor position is decremented by the same
   * number of characters you've deleted.
   * 
   * @newin{1,0}
   * @param n_chars The number of characters to delete.
   */
  void delete_chars(guint len);
  
  /** Deletes the text inside a Clutter::Text actor between @a start_pos
   * and @a end_pos.
   * 
   * The starting and ending positions are expressed in characters,
   * not in bytes.
   * 
   * @newin{1,0}
   * @param start_pos Starting position.
   * @param end_pos Ending position.
   */
  void delete_text(gssize start_pos, gssize end_pos);
  
  /** Deletes the currently selected text
   * 
   * This function is only useful in subclasses of Clutter::Text
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if text was deleted or if the text actor
   * is empty, and <tt>false</tt> otherwise.
   */
  bool delete_selection();

  
  /** Retrieves the contents of the Clutter::Text actor between
   *  @a start_pos and @a end_pos, but not including @a end_pos.
   * 
   * The positions are specified in characters, not in bytes.
   * 
   * @newin{1,0}
   * @param start_pos Start of text, in characters.
   * @param end_pos End of text, in characters.
   * @return A newly allocated string with the contents of
   * the text actor between the specified positions. Use Glib::free()
   * to free the resources when done.
   */
  Glib::ustring get_chars(gssize start_pos, gssize end_pos) const;

  
  /** Sets the color of the cursor of a Clutter::Text actor.
   * 
   * If @a color is <tt>0</tt>, the cursor color will be the same as the
   * text color.
   * 
   * @newin{1,0}
   * @param color The color of the cursor, or <tt>0</tt> to unset it.
   */
  void set_cursor_color(const Color& color);

  /** Retrieves the color.
   */
  Color get_cursor_color() const;
  

  /** Sets the cursor of a Clutter::Text actor at @a position.
   * 
   * The position is expressed in characters, not in bytes.
   * 
   * @newin{1,0}
   * @param position The new cursor position, in characters.
   */
  void set_cursor_position(int position);
  
  /** Retrieves the cursor position.
   * 
   * @newin{1,0}
   * @return The cursor position, in characters.
   */
  int get_cursor_position() const;

  
  /** Sets whether the cursor of a Clutter::Text actor should be
   * visible or not.
   * 
   * The color of the cursor will be the same as the text color
   * unless set_cursor_color() has been called.
   * 
   * The size of the cursor can be set using set_cursor_size().
   * 
   * The position of the cursor can be changed programmatically using
   * set_cursor_position().
   * 
   * @newin{1,0}
   * @param cursor_visible Whether the cursor should be visible.
   */
  void set_cursor_visible(bool visible);
  
  /** Retrieves whether the cursor of a Clutter::Text actor is visible.
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the cursor is visible.
   */
  bool get_cursor_visible() const;

  
  /** Sets the size of the cursor of a Clutter::Text. The cursor
   * will only be visible if the Clutter::Text::property_cursor_visible() property
   * is set to <tt>true</tt>.
   * 
   * @newin{1,0}
   * @param size The size of the cursor, in pixels, or -1 to use the
   * default value.
   */
  void set_cursor_size(int size);
  
  /** Retrieves the size of the cursor of a Clutter::Text actor.
   * 
   * @newin{1,0}
   * @return The size of the cursor, in pixels.
   */
  guint get_cursor_size() const;

  Rect get_cursor_rect() const;
  

  /** Emits the Clutter::Text::signal_activate() signal, if @a self has been set
   * as activatable using set_activatable().
   * 
   * This function can be used to emit the signal_activate() signal inside
   * a Clutter::Actor::signal_captured_event() or Clutter::Actor::signal_key_press_event()
   * signal handlers before the default signal handler for the
   * Clutter::Text is invoked.
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the signal_activate() signal has been emitted,
   * and <tt>false</tt> otherwise.
   */
  bool activate();
  
  /** Retrieves the position of the character at the given coordinates.
   * 
   * Return: the position of the character
   * 
   * @newin{1,10}
   * @param x The X coordinate, relative to the actor.
   * @param y The Y coordinate, relative to the actor.
   */
  int coords_to_position(float x, float y);

  
  /** Retrieves the coordinates of the given @a position.
   * 
   * @newin{1,0}
   * @param position Position in characters.
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   * @param line_height Return location for the line height, or <tt>0</tt>.
   * @return <tt>true</tt> if the conversion was successful.
   */
  bool position_to_coords(int position, float & x, float & y, float & line_height);

 
  /** Sets, or unsets, the pre-edit string. This function is useful
   * for input methods to display a string (with eventual specific
   * Pango attributes) before it is entered inside the Clutter::Text
   * buffer.
   * 
   * The preedit string and attributes are ignored if the Clutter::Text
   * actor is not editable.
   * 
   * This function should not be used by applications
   * 
   * @newin{1,2}
   * @param preedit_str The pre-edit string, or <tt>0</tt> to unset it.
   * @param preedit_attrs The pre-edit string attributes.
   * @param cursor_pos The cursor position for the pre-edit string.
   */
  void set_preedit_string(const Glib::ustring& preedit_str, const Pango::AttrList& preedit_attrs, guint ursor_pos);

  
  /** Obtains the coordinates where the Clutter::Text will draw the Pango::Layout
   * representing the text.
   * 
   * @newin{1,8}
   * @param x Location to store X offset of layout, or <tt>0</tt>.
   * @param y Location to store Y offset of layout, or <tt>0</tt>.
   */
  void get_layout_offsets(int& x, int& y);

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%activate()</tt>
   *
   * The signal_activate() signal is emitted each time the actor is 'activated'
   * by the user, normally by pressing the 'Enter' key. The signal is
   * emitted only if Clutter::Text::property_activatable() is set to <tt>true</tt>.
   * 
   * @newin{1,0}
   */

  Glib::SignalProxy0< void > signal_activate();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_changed()</tt>
   *
   * The signal_text_changed() signal is emitted after @a actor's text changes
   * 
   * @newin{1,0}
   */

  Glib::SignalProxy0< void > signal_text_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%cursor_changed()</tt>
   *
   * The signal_cursor_changed() signal is emitted whenever the cursor
   * position or size changes.
   * 
   * @newin{1,16}
   */

  Glib::SignalProxy0< void > signal_cursor_changed();

  //These are action signals, so probably shouldn't be wrapped:
  //_WRAP_SIGNAL(void insert_text(const char* new_text, int new_text_length, int position), "insert-text", no_default_handler)
  //_WRAP_SIGNAL(void delete_text(int start_pos, int end_pos), "insert-text", no_default_handler)

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether pressing return causes the activate signal to be emitted.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_activatable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether pressing return causes the activate signal to be emitted.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_activatable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A list of style attributes to apply to the contents of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::AttrList > property_attributes() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A list of style attributes to apply to the contents of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::AttrList > property_attributes() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The buffer for the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<TextBuffer> > property_buffer() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The buffer for the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TextBuffer> > property_buffer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Color of the font used by the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Color > property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Color of the font used by the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Color > property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Cursor Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Color > property_cursor_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Cursor Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Color > property_cursor_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the cursor color has been set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_cursor_color_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_cursor_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_cursor_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The width of the cursor, in pixels.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_cursor_size() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The width of the cursor, in pixels.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_cursor_size() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the input cursor is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_cursor_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the input cursor is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_cursor_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is editable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_editable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is editable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_editable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred place to ellipsize the string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::EllipsizeMode > property_ellipsize() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred place to ellipsize the string.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::EllipsizeMode > property_ellipsize() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The font description to be used.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::FontDescription > property_font_description() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The font description to be used.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::FontDescription > property_font_description() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The font to be used by the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_font_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The font to be used by the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_font_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text should be justified.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_justify() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text should be justified.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_justify() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred alignment for the string, for multi-line text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::Alignment > property_line_alignment() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred alignment for the string, for multi-line text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::Alignment > property_line_alignment() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Control how line-wrapping is done.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::WrapMode > property_line_wrap_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Control how line-wrapping is done.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::WrapMode > property_line_wrap_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If set, wrap the lines if the text becomes too wide.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_line_wrap() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If set, wrap the lines if the text becomes too wide.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_line_wrap() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum length of the text inside the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_max_length() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum length of the text inside the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_max_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If non-zero, use this character to display the actor's contents.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< gunichar > property_password_char() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If non-zero, use this character to display the actor's contents.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gunichar > property_password_char() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
 //TODO: Marked for removal in clutter.
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is selectable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_selectable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is selectable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_selectable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Selected Text Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Color > property_selected_text_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Selected Text Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Color > property_selected_text_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the selected text color has been set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_selected_text_color_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position of the other end of the selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_selection_bound() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position of the other end of the selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_selection_bound() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Selection Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Color > property_selection_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Selection Color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Color > property_selection_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the selection color has been set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_selection_color_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text should be a single line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_single_line_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text should be a single line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_single_line_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The text to render.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The text to render.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not the text includes Pango markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_markup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not the text includes Pango markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_markup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_activate().
  virtual void on_activate();
  /// This is a default handler for the signal signal_text_changed().
  virtual void on_text_changed();
  /// This is a default handler for the signal signal_cursor_changed().
  virtual void on_cursor_changed();


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Text
   */
  Glib::RefPtr<Clutter::Text> wrap(ClutterText* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_TEXT_H */

