// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TIMELINE_H
#define _CLUTTERMM_TIMELINE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/types.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterTimeline ClutterTimeline;
typedef struct _ClutterTimelineClass ClutterTimelineClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Timeline_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var TimelineDirection TIMELINE_FORWARD
 *  Forward direction for a timeline.
 * 
 *  @var TimelineDirection TIMELINE_BACKWARD
 *  Backward direction for a timeline.
 * 
 *  @enum TimelineDirection
 * 
 * The direction of a Clutter::Timeline
 * 
 * @newin{0,6}
 * @ingroup cluttermmEnums
 */
enum TimelineDirection
{
  TIMELINE_FORWARD,
  TIMELINE_BACKWARD
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::TimelineDirection> : public Glib::Value_Enum<Clutter::TimelineDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Timeline : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Timeline CppObjectType;
  typedef Timeline_Class CppClassType;
  typedef ClutterTimeline BaseObjectType;
  typedef ClutterTimelineClass BaseClassType;

private:  friend class Timeline_Class;
  static CppClassType timeline_class_;

private:
  // noncopyable
  Timeline(const Timeline&);
  Timeline& operator=(const Timeline&);

protected:
  explicit Timeline(const Glib::ConstructParams& construct_params);
  explicit Timeline(ClutterTimeline* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Timeline();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterTimeline*       gobj()       { return reinterpret_cast<ClutterTimeline*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterTimeline* gobj() const { return reinterpret_cast<ClutterTimeline*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterTimeline* gobj_copy();

private:


protected:
  
  /** Creates a new Clutter::Timeline with a duration of @a msecs.
   * 
   * @newin{0,6}
   * @param msecs Duration of the timeline in milliseconds.
   * @return The newly created Clutter::Timeline instance. Use
   * Glib::object_unref() when done using it.
   */

  explicit Timeline(guint msecs);

public:
  
  static Glib::RefPtr<Timeline> create(guint msecs);

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Create a new Clutter::Timeline instance which has property values
   * matching that of supplied timeline. The cloned timeline will not
   * be started and will not be positioned to the current position of
   * the original @a timeline: you will have to start it with start().
   * 
   * <note>The only cloned properties are:
   * - Clutter::Timeline::property_duration()
   * - Clutter::Timeline::property_loop()
   * - Clutter::Timeline::property_delay()
   * - Clutter::Timeline::property_direction()
   * </note>
   * 
   * @newin{0,4}
   * 
   * Deprecated: 1.10: Use new() or Glib::object_new()
   * instead
   * @deprecated Use create() instead.
   * @return A new Clutter::Timeline, cloned
   * from @a timeline.
   */
  Glib::RefPtr<Timeline> clone() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Sets the duration of the timeline, in milliseconds. The speed
   * of the timeline depends on the ClutterTimeline:fps setting.
   * 
   * @newin{0,6}
   * @param msecs Duration of the timeline in milliseconds.
   */
  void set_duration(guint msecs);
  
  /** Retrieves the duration of a Clutter::Timeline in milliseconds.
   * See set_duration().
   * 
   * @newin{0,6}
   * @return The duration of the timeline, in milliseconds.
   */
  guint get_duration() const;
  
  /** Starts the Clutter::Timeline playing.
   */
  void start();
  
  /** Pauses the Clutter::Timeline on current frame
   */
  void pause();
  
  /** Stops the Clutter::Timeline and moves to frame 0
   */
  void stop();

  
  /** Sets whether @a timeline should reverse the direction after the
   * emission of the Clutter::Timeline::signal_completed() signal.
   * 
   * Setting the Clutter::Timeline::property_auto_reverse() property to <tt>true</tt> is the
   * equivalent of connecting a callback to the Clutter::Timeline::signal_completed()
   * signal and changing the direction of the timeline from that callback;
   * for instance, this code:
   * 
   * 
   * [C example ellipted]
   * 
   * can be effectively replaced by:
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{1,6}
   * @param reverse <tt>true</tt> if the @a timeline should reverse the direction.
   */
  void set_auto_reverse(bool reverse =  true);
  
  /** Retrieves the value set by set_auto_reverse().
   * 
   * @newin{1,6}
   * @return <tt>true</tt> if the timeline should automatically reverse, and
   * <tt>false</tt> otherwise.
   */
  bool get_auto_reverse() const;
  
  /** Sets the number of times the @a timeline should repeat.
   * 
   * If @a count is 0, the timeline never repeats.
   * 
   * If @a count is -1, the timeline will always repeat until
   * it's stopped.
   * 
   * @newin{1,10}
   * @param count The number of times the timeline should repeat.
   */
  void set_repeat_count(int count);
  
  /** Retrieves the number set using set_repeat_count().
   * 
   * @newin{1,10}
   * @return The number of repeats.
   */
  int get_repeat_count() const;

  
  /** Rewinds Clutter::Timeline to the first frame if its direction is
   * Clutter::TIMELINE_FORWARD and the last frame if it is
   * Clutter::TIMELINE_BACKWARD.
   */
  void rewind();
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets whether @a timeline should loop.
   * 
   * This function is equivalent to calling set_repeat_count()
   * with -1 if @a loop is <tt>true</tt>, and with 0 if @a loop is <tt>false</tt>.
   * 
   * Deprecated: 1.10: Use set_repeat_count() instead.
   * @deprecated Use set_repeat_count() instead.
   * @param loop <tt>true</tt> for enable looping.
   */
  void set_loop(bool loop =  true);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Gets whether @a timeline is looping
   * 
   * Deprecated: 1.10: Use get_repeat_count() instead.
   * @deprecated Use get_repeat_count() instead.
   * @return <tt>true</tt> if the timeline is looping.
   */
  bool get_loop() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Advance timeline by the requested time in milliseconds
   * @param msecs Amount of time to skip.
   */
  void skip(guint n_frames);
  
  /** Advance timeline to the requested point. The point is given as a
   * time in milliseconds since the timeline started.
   * 
   * <note>The @a timeline will not emit the Clutter::Timeline::signal_new_frame()
   * signal for the given time. The first signal_new_frame() signal after the call to
   * advance() will be emit the skipped markers.
   * </note>
   * @param msecs Time to advance to.
   */
  void advance(guint frame_num);
  
  /** Retrieves the amount of time elapsed since the last
   * ClutterTimeline::new-frame signal.
   * 
   * This function is only useful inside handlers for the signal_new_frame()
   * signal, and its behaviour is undefined if the timeline is not
   * playing.
   * 
   * @newin{0,6}
   * @return The amount of time in milliseconds elapsed since the
   * last frame.
   */
  guint get_delta() const;
  
  /** Queries state of a Clutter::Timeline.
   * @return <tt>true</tt> if timeline is currently playing.
   */
  bool is_playing() const;
  
  /** Sets the delay, in milliseconds, before @a timeline should start.
   * 
   * @newin{0,4}
   * @param msecs Delay in milliseconds.
   */
  void set_delay(guint msecs);
  
  /** Retrieves the delay set using set_delay().
   * 
   * @newin{0,4}
   * @return The delay in milliseconds.
   */
  guint get_delay() const;
  
  /** Request the current time position of the timeline.
   * @return Current elapsed time in milliseconds.
   */
  guint get_elapsed_time() const;
  
  /** The position of the timeline in a normalized [-1, 2] interval.
   * 
   * The return value of this function is determined by the progress
   * mode set using set_progress_mode(), or by the
   * progress function set using set_progress_func().
   * 
   * @newin{0,6}
   * @return The normalized current position in the timeline.
   */
  double get_progress() const;
  
  /** Sets the direction of @a timeline, either Clutter::TIMELINE_FORWARD or
   * Clutter::TIMELINE_BACKWARD.
   * 
   * @newin{0,6}
   * @param direction The direction of the timeline.
   */
  void set_direction(TimelineDirection direction);
  
  /** Retrieves the direction of the timeline set with
   * set_direction().
   * 
   * @newin{0,6}
   * @return The direction of the timeline.
   */
  TimelineDirection get_direction() const;

  
  /** Retrieves the list of markers at time @a msecs. If @a msecs is a
   * negative integer, all the markers attached to @a timeline will be
   * returned.
   * 
   * @newin{0,8}
   * @param msecs The time to check, or -1.
   * @param n_markers The number of markers returned.
   * @return A newly allocated, <tt>0</tt> terminated string array containing the names
   * of the markers. Use Glib::strfreev() when done.
   */

  std::vector<Glib::ustring> list_markers(int frame_num) const;
  
  /** Adds a named marker that will be hit when the timeline has been
   * running for @a msecs milliseconds.
   * 
   * Markers are unique string identifiers for a given position on the
   * timeline. Once @a timeline reaches the given @a msecs, it will emit
   * a signal_marker_reached() signal for each marker attached to that position.
   * 
   * A marker can be removed with remove_marker(). The
   * timeline can be advanced to a marker using
   * advance_to_marker().
   * 
   * See also: add_marker()
   * 
   * @newin{0,8}
   * @param marker_name The unique name for this marker.
   * @param msecs Position of the marker in milliseconds.
   */
  void add_marker_at_time(const Glib::ustring& marker_name, guint msecs);
  
  /** Checks whether @a timeline has a marker set with the given name.
   * 
   * @newin{0,8}
   * @param marker_name The name of the marker.
   * @return <tt>true</tt> if the marker was found.
   */
  bool has_marker(const Glib::ustring& marker_name);
  
  /** Removes @a marker_name, if found, from @a timeline.
   * 
   * @newin{0,8}
   * @param marker_name The name of the marker to remove.
   */
  void remove_marker(const Glib::ustring& marker_name);
  
  /** Advances @a timeline to the time of the given @a marker_name.
   * 
   * <note>Like advance(), this function will not
   * emit the Clutter::Timeline::signal_new_frame() for the time where @a marker_name
   * is set, nor it will emit Clutter::Timeline::signal_marker_reached() for
   *  @a marker_name.</note>
   * 
   * @newin{0,8}
   * @param marker_name The name of the marker.
   */
  void advance_to_marker(const Glib::ustring& marker_name);

  
  /** Sets the progress function using a value from the Clutter::AnimationMode
   * enumeration. The @a mode cannot be Clutter::CUSTOM_MODE or bigger than
   * Clutter::ANIMATION_LAST.
   * 
   * @newin{1,10}
   * @param mode The progress mode, as a Clutter::AnimationMode.
   */
  void set_progress_mode(AnimationMode mode);
  
  /** Retrieves the progress mode set using set_progress_mode()
   * or set_progress_func().
   * 
   * @newin{1,10}
   * @return A Clutter::AnimationMode.
   */
  AnimationMode get_progress_mode() const;

  //clutter_timeline_do_tick() is marked as private in the header.
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Delay before start.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_delay() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Delay before start.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_delay() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of the timeline.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< TimelineDirection > property_direction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of the timeline.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< TimelineDirection > property_direction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Duration of the timeline in milliseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_duration() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Duration of the timeline in milliseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_duration() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Should the timeline automatically restart.
   * @deprecated Use the “repeat-count” property instead.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_loop() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Should the timeline automatically restart.
   * @deprecated Use the “repeat-count” property instead.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_loop() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

#endif // CLUTTERMM_DISABLE_DEPRECATED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the direction should be reversed when reaching the end.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_auto_reverse() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the direction should be reversed when reaching the end.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_auto_reverse() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** How many times the timeline should repeat.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_repeat_count() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** How many times the timeline should repeat.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_repeat_count() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** How the timeline should compute the progress.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< AnimationMode > property_progress_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** How the timeline should compute the progress.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< AnimationMode > property_progress_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%completed()</tt>
   *
   * The Clutter::Timeline::signal_completed() signal is emitted when the timeline's
   * elapsed time reaches the value of the Clutter::Timeline::property_duration()
   * property.
   * 
   * This signal will be emitted even if the Clutter::Timeline is set to be
   * repeating.
   * 
   * If you want to get notification on whether the Clutter::Timeline has
   * been stopped or has finished its run, including its eventual repeats,
   * you should use the Clutter::Timeline::signal_stopped() signal instead.
   */

  Glib::SignalProxy0< void > signal_completed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%new_frame(int fram_num)</tt>
   *
   * The signal_new_frame() signal is emitted for each timeline running
   * timeline before a new frame is drawn to give animations a chance
   * to update the scene.
   * @param msecs The elapsed time between 0 and duration.
   */

  Glib::SignalProxy1< void,int > signal_new_frame();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%paused()</tt>
   *
   * The signal_paused() signal is emitted when Clutter::Timeline::pause() is invoked.
   */

  Glib::SignalProxy0< void > signal_paused();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%started()</tt>
   *
   * The signal_started() signal is emitted when the timeline starts its run.
   * This might be as soon as Clutter::Timeline::start() is invoked or
   * after the delay set in the ClutterTimeline:delay property has
   * expired.
   */

  Glib::SignalProxy0< void > signal_started();


  // TODO: This signal is detailed, though I don't think we can wrap the
  // detail in Glibmm yet. armin.
 

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%marker_reached(const Glib::ustring& marker_name, int frame_num)</tt>
   *
   * The signal_marker_reached() signal is emitted each time a timeline
   * reaches a marker set with
   * Clutter::Timeline::add_marker_at_time(). This signal is detailed
   * with the name of the marker as well, so it is possible to connect
   * a callback to the signal_marker_reached() signal for a specific marker
   * with:
   * 
   * [C example ellipted]
   * 
   * In the example, the first callback will be invoked for both
   * the "foo" and "bar" marker, while the second and third callbacks
   * will be invoked for the "foo" or "bar" markers, respectively.
   * 
   * @newin{0,8}
   * @param marker_name The name of the marker reached.
   * @param msecs The elapsed time.
   */

  Glib::SignalProxy2< void,const Glib::ustring&,int > signal_marker_reached();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_completed().
  virtual void on_completed();
  /// This is a default handler for the signal signal_new_frame().
  virtual void on_new_frame(int fram_num);
  /// This is a default handler for the signal signal_paused().
  virtual void on_paused();
  /// This is a default handler for the signal signal_started().
  virtual void on_started();
  /// This is a default handler for the signal signal_marker_reached().
  virtual void on_marker_reached(const Glib::ustring& marker_name, int frame_num);


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Timeline
   */
  Glib::RefPtr<Clutter::Timeline> wrap(ClutterTimeline* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_TIMELINE_H */

