// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TRANSITION_H
#define _CLUTTERMM_TRANSITION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2014 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <glibmm/ustring.h>
#include <glibmm/value.h>
#include <cluttermm/types.h>
#include <cluttermm/timeline.h>
#include <cluttermm/animatable.h>
#include <cluttermm/interval.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterTransition ClutterTransition;
typedef struct _ClutterTransitionClass ClutterTransitionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Transition_Class; } // namespace Clutter
namespace Clutter
{

/** Transition is an abstract subclass of Timeline that computes the
 * interpolation between two values, stored by an Interval.
 */

class Transition
  : public Timeline,
    public Animatable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Transition CppObjectType;
  typedef Transition_Class CppClassType;
  typedef ClutterTransition BaseObjectType;
  typedef ClutterTransitionClass BaseClassType;

private:  friend class Transition_Class;
  static CppClassType transition_class_;

private:
  // noncopyable
  Transition(const Transition&);
  Transition& operator=(const Transition&);

protected:
  explicit Transition(const Glib::ConstructParams& construct_params);
  explicit Transition(ClutterTransition* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Transition();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterTransition*       gobj()       { return reinterpret_cast<ClutterTransition*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterTransition* gobj() const { return reinterpret_cast<ClutterTransition*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterTransition* gobj_copy();

private:


protected:
  Transition();

public:
  
  static Glib::RefPtr<Transition> create();


  /** Sets the initial value of the transition.
   * 
   * This is a convenience function that will either create the
   * Clutter::Interval used by @a transition, or will update it if
   * the Clutter::Transition::property_interval() is already set.
   * 
   * This function will copy the contents of @a value, so it is
   * safe to call Glib::value_unset() after it returns.
   * 
   * If @a transition already has a Clutter::Transition::property_interval() set,
   * then @a value must hold the same type, or a transformable type,
   * as the interval's Clutter::Interval::property_value_type() property.
   * 
   * This function is meant to be used by language bindings.
   * 
   * @newin{1,12}
   * @param value A Value with the initial value of the transition.
   */
  void set_from_value(const Glib::ValueBase& value);
  
  /** Sets the final value of the transition.
   * 
   * This is a convenience function that will either create the
   * Clutter::Interval used by @a transition, or will update it if
   * the Clutter::Transition::property_interval() is already set.
   * 
   * This function will copy the contents of @a value, so it is
   * safe to call Glib::value_unset() after it returns.
   * 
   * If @a transition already has a Clutter::Transition::property_interval() set,
   * then @a value must hold the same type, or a transformable type,
   * as the interval's Clutter::Interval::property_value_type() property.
   * 
   * This function is meant to be used by language bindings.
   * 
   * @newin{1,12}
   * @param value A Value with the final value of the transition.
   */
  void set_to_value(const Glib::ValueBase& value);

  /**  Set the initial value of the transition.
   *
   * This is a convenience function that doesn't require creating a
   * GValue to hold the value first.
   * @param value the value to set the initial value to.
   * @newin{1,12}
   */
  template <class ValueType>
  void set_from(const ValueType& value);

  /** Set the final value of the transition.
   *
   * This is a convenience function that doesn't require creating a
   * GValue to hold the value first.
   *
   * @param value the value to set the final value to.
   * @newin{1,12}
   */
  template <class ValueType>
  void set_to(const ValueType& value);

  
  /** Sets the Clutter::Transition::property_interval() property using @a interval.
   * 
   * The @a transition will acquire a reference on the @a interval, sinking
   * the floating flag on it if necessary.
   * 
   * @newin{1,10}
   * @param interval A Clutter::Interval, or <tt>0</tt>.
   */
  void set_interval(const Glib::RefPtr<Interval>& interval);

  
  /** Retrieves the interval set using set_interval()
   * 
   * @newin{1,10}
   * @return A Clutter::Interval, or <tt>0</tt>; the returned
   * interval is owned by the Clutter::Transition and it should not be freed
   * directly.
   */
  Glib::RefPtr<Interval> get_interval();
  
  /** Retrieves the interval set using set_interval()
   * 
   * @newin{1,10}
   * @return A Clutter::Interval, or <tt>0</tt>; the returned
   * interval is owned by the Clutter::Transition and it should not be freed
   * directly.
   */
  Glib::RefPtr<const Interval> get_interval() const;

  
  /** Sets the Clutter::Transition::property_animatable() property.
   * 
   * The @a transition will acquire a reference to the @a animatable instance,
   * and will call the Clutter::TransitionClass.attached() virtual function.
   * 
   * If an existing Clutter::Animatable is attached to @a transition, the
   * reference will be released, and the Clutter::TransitionClass.detached()
   * virtual function will be called.
   * 
   * @newin{1,10}
   * @param animatable A Clutter::Animatable, or <tt>0</tt>.
   */
  void set_animatable(const Glib::RefPtr<Animatable>& animatable);

  
  /** Retrieves the Clutter::Animatable set using set_animatable().
   * 
   * @newin{1,10}
   * @return A Clutter::Animatable, or <tt>0</tt>; the returned
   * animatable is owned by the Clutter::Transition, and it should not be freed
   * directly.
   */
  Glib::RefPtr<Animatable> get_animatable();
  
  /** Retrieves the Clutter::Animatable set using set_animatable().
   * 
   * @newin{1,10}
   * @return A Clutter::Animatable, or <tt>0</tt>; the returned
   * animatable is owned by the Clutter::Transition, and it should not be freed
   * directly.
   */
  Glib::RefPtr<const Animatable> get_animatable() const;

  
  /** Sets whether @a transition should be detached from the Clutter::Animatable
   * set using set_animatable() when the
   * Clutter::Timeline::signal_completed() signal is emitted.
   * 
   * @newin{1,10}
   * @param remove_complete Whether to detach @a transition when complete.
   */
  void set_remove_on_complete(bool remove_complete =  true);
  
  /** Retrieves the value of the Clutter::Transition::property_remove_on_complete() property.
   * 
   * @newin{1,10}
   * @return <tt>true</tt> if the @a transition should be detached when complete,
   * and <tt>false</tt> otherwise.
   */
  bool get_remove_on_complete() const;

  //Properties:
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The animatable object.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Animatable> > property_animatable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The animatable object.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Animatable> > property_animatable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The interval of values to transition.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Interval> > property_interval() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The interval of values to transition.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Interval> > property_interval() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Detach the transition when completed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_remove_on_complete() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Detach the transition when completed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_remove_on_complete() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //vfuncs:
  //gtkmmproc error: attached :  vfunc defs lookup failed
  //gtkmmproc error: detached :  vfunc defs lookup failed
  //gtkmmproc error: compute_value :  vfunc defs lookup failed


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

template <class ValueType>
void Transition::set_from(const ValueType& value)
{
  GType gtypeval = Glib::Value<ValueType>::value_type();
  Glib::Value< ValueType > set_val;
  set_val.init(gtypeval);

  clutter_transition_set_from_value(gobj(), set_val.gobj());
}


template <class ValueType>
void Transition::set_to(const ValueType& value)
{
  GType gtypeval = Glib::Value<ValueType>::value_type();
  Glib::Value< ValueType > to_val;
  to_val.init(gtypeval);

  clutter_transition_set_to_value(this->gobj(), to_val.gobj());
}

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Transition
   */
  Glib::RefPtr<Clutter::Transition> wrap(ClutterTransition* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_TRANSITION_H */

