// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BOX_LAYOUT_H
#define _CLUTTERMM_BOX_LAYOUT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/layout-manager.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBoxLayout ClutterBoxLayout;
typedef struct _ClutterBoxLayoutClass ClutterBoxLayoutClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class BoxLayout_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var BoxAlignment BOX_ALIGNMENT_START
 *  Align the child to the top or to to the left, depending on the used axis.
 * 
 *  @var BoxAlignment BOX_ALIGNMENT_CENTER
 *  Align the child to the center.
 * 
 *  @var BoxAlignment BOX_ALIGNMENT_END
 *  Align the child to the bottom or to the right, depending on the used axis.
 * 
 *  @enum BoxAlignment
 * 
 * The alignment policies available on each axis of the Clutter::BoxLayout
 * 
 * @newin{1,2}
 * @ingroup cluttermmEnums
 */
enum BoxAlignment
{
  BOX_ALIGNMENT_START,
  BOX_ALIGNMENT_END,
  BOX_ALIGNMENT_CENTER
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::BoxAlignment> : public Glib::Value_Enum<Clutter::BoxAlignment>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class BoxLayout :
    public LayoutManager
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BoxLayout CppObjectType;
  typedef BoxLayout_Class CppClassType;
  typedef ClutterBoxLayout BaseObjectType;
  typedef ClutterBoxLayoutClass BaseClassType;

private:  friend class BoxLayout_Class;
  static CppClassType boxlayout_class_;

private:
  // noncopyable
  BoxLayout(const BoxLayout&);
  BoxLayout& operator=(const BoxLayout&);

protected:
  explicit BoxLayout(const Glib::ConstructParams& construct_params);
  explicit BoxLayout(ClutterBoxLayout* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BoxLayout();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBoxLayout*       gobj()       { return reinterpret_cast<ClutterBoxLayout*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBoxLayout* gobj() const { return reinterpret_cast<ClutterBoxLayout*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBoxLayout* gobj_copy();

private:


protected:
  BoxLayout();

public:
  
  static Glib::RefPtr<BoxLayout> create();


  /** Sets the orientation of the Clutter::BoxLayout layout manager.
   * 
   * @newin{1,12}
   * @param orientation The orientation of the Clutter::BoxLayout.
   */
  void set_orientation(Orientation orientation);
  
  /** Retrieves the orientation of the @a layout.
   * 
   * @newin{1,12}
   * @return The orientation of the layout.
   */
  Orientation get_orientation() const;

  
  /** Sets whether children of @a layout should be layed out by appending
   * them or by prepending them
   * 
   * @newin{1,2}
   * @param pack_start <tt>true</tt> if the @a layout should pack children at the
   * beginning of the layout.
   */
  void set_pack_start(bool pack_start);
  
  /** Retrieves the value set using set_pack_start()
   * 
   * @newin{1,2}
   * @return <tt>true</tt> if the Clutter::BoxLayout should pack children
   * at the beginning of the layout, and <tt>false</tt> otherwise.
   */
  bool get_pack_start() const;
  
  /** Sets the spacing between children of @a layout
   * 
   * @newin{1,2}
   * @param spacing The spacing between children of the layout, in pixels.
   */
  void set_spacing(guint spacing);
  
  /** Retrieves the spacing set using set_spacing()
   * 
   * @newin{1,2}
   * @return The spacing between children of the Clutter::BoxLayout.
   */
  guint get_spacing() const;
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets whether @a layout should arrange its children vertically alongside
   * the Y axis, instead of horizontally alongside the X axis
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12: Use set_orientation() instead.
   * @deprecated Use set_orientation() instead.
   * @param vertical <tt>true</tt> if the layout should be vertical.
   */
  void set_vertical(bool vertical);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the orientation of the @a layout as set using the
   * set_vertical() function
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12: Use get_orientation() instead
   * @deprecated Use get_orientation() instead.
   * @return <tt>true</tt> if the Clutter::BoxLayout is arranging its children
   * vertically, and <tt>false</tt> otherwise.
   */
  bool get_vertical() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Sets whether the size of @a layout children should be
   * homogeneous
   * 
   * @newin{1,4}
   * @param homogeneous <tt>true</tt> if the layout should be homogeneous.
   */
  void set_homogeneous(bool homogeneous);
  
  /** Retrieves if the children sizes are allocated homogeneously.
   * 
   * @newin{1,4}
   * @return <tt>true</tt> if the Clutter::BoxLayout is arranging its children
   * homogeneously, and <tt>false</tt> otherwise.
   */
  bool get_homogeneous() const;

  
  /** Packs @a actor inside the Clutter::Container associated to @a layout
   * and sets the layout properties
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Clutter::BoxLayout honours Clutter::Actor's
   * align and expand properties. The preferred way is adding
   * the @a actor with Clutter::Actor::add_child() and setting
   * Clutter::Actor::property_x_align(), Clutter::Actor::property_y_align(),
   * Clutter::Actor::property_x_expand() and Clutter::Actor::property_y_expand()
   * @param actor A Clutter::Actor.
   * @param expand Whether the @a actor should expand.
   * @param x_fill Whether the @a actor should fill horizontally.
   * @param y_fill Whether the @a actor should fill vertically.
   * @param x_align The horizontal alignment policy for @a actor.
   * @param y_align The vertical alignment policy for @a actor.
   */
  void pack(const Glib::RefPtr<Actor>& p1, bool expand, bool x_fill, bool y_fill, BoxAlignment x_align, BoxAlignment y_align);

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the horizontal and vertical alignment policies for @a actor
   * inside @a layout
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Clutter::BoxLayout will honour Clutter::Actor's
   * Clutter::Actor::property_x_align() and Clutter::Actor::property_y_align() properies
   * @deprecated Use Actor's x-align and y-align properties instead.
   * @param actor A Clutter::Actor child of @a layout.
   * @param x_align Horizontal alignment policy for @a actor.
   * @param y_align Vertical alignment policy for @a actor.
   */
  void set_alignment(const Glib::RefPtr<Actor>& child, BoxAlignment x_align, BoxAlignment y_align);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the horizontal and vertical alignment policies for @a actor
   * as set using pack() or set_alignment()
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Clutter::BoxLayout will honour Clutter::Actor's
   * Clutter::Actor::property_x_align() and Clutter::Actor::property_y_align() properies
   * @deprecated Use Actor's x-align and y-align properties instead.
   * @param actor A Clutter::Actor child of @a layout.
   * @param x_align Return location for the horizontal alignment policy.
   * @param y_align Return location for the vertical alignment policy.
   */
  void get_alignment(const Glib::RefPtr<Actor>& child, BoxAlignment & x_align, BoxAlignment & y_align) const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets whether @a actor should expand inside @a layout
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Clutter::BoxLayout will honour Clutter::Actor's
   * Clutter::Actor::property_x_expand() and Clutter::Actor::property_y_expand() properies
   * @deprecated Use Actor's x-expand and y-expand properties instead.
   * @param actor A Clutter::Actor child of @a layout.
   * @param expand Whether @a actor should expand.
   */
  void set_expand(const Glib::RefPtr<Actor>& child, bool expand);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves whether @a actor should expand inside @a layout
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Clutter::BoxLayout will honour Clutter::Actor's
   * Clutter::Actor::property_x_expand() and Clutter::Actor::property_y_expand() properies
   * @deprecated Use Actor's x-expand and y-expand properties instead.
   * @param actor A Clutter::Actor child of @a layout.
   * @return <tt>true</tt> if the Clutter::Actor should expand, <tt>false</tt> otherwise.
   */
  bool get_expand(const Glib::RefPtr<Actor>& child) const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the horizontal and vertical fill policies for @a actor
   * inside @a layout
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Clutter::BoxLayout will honour Clutter::Actor's
   * Clutter::Actor::property_x_align() and Clutter::Actor::property_y_align() properies
   * @deprecated Use Actor's x-align and y-align properties instead.
   * @param actor A Clutter::Actor child of @a layout.
   * @param x_fill Whether @a actor should fill horizontally the allocated space.
   * @param y_fill Whether @a actor should fill vertically the allocated space.
   */
  void set_fill(const Glib::RefPtr<Actor>& child, bool x_fill, bool y_fill);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the horizontal and vertical fill policies for @a actor
   * as set using pack() or set_fill()
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Clutter::BoxLayout will honour Clutter::Actor's
   * Clutter::Actor::property_x_align() and Clutter::Actor::property_y_align() properies
   * @deprecated Use Actor's x-align and y-align properties instead.
   * @param actor A Clutter::Actor child of @a layout.
   * @param x_fill Return location for the horizontal fill policy.
   * @param y_fill Return location for the vertical fill policy.
   */
  void get_fill(const Glib::RefPtr<Actor>& child, bool & x_fill, bool & y_fill) const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets whether @a layout should animate changes in the layout properties
   * 
   * The duration of the animations is controlled by
   * set_easing_duration(); the easing mode to be used
   * by the animations is controlled by set_easing_mode().
   * 
   * Enabling animations will override the easing state of each child
   * of the actor using @a layout, and will use the Clutter::BoxLayout::property_easing_mode()
   * and Clutter::BoxLayout::property_easing_duration() properties instead.
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12: The layout manager will honour the easing state
   * of the children when allocating them.
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   * @param animate <tt>true</tt> if the @a layout should use animations.
   */
  void set_use_animations(bool animate);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves whether @a layout should animate changes in the layout properties.
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   * @return <tt>true</tt> if the animations should be used, <tt>false</tt> otherwise.
   */
  bool get_use_animations() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the duration of the animations used by @a layout when animating changes
   * in the layout properties.
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12: The layout manager will honour the easing state
   * of the children when allocating them.
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   * @param msecs The duration of the animations, in milliseconds.
   */
  void set_easing_duration(guint msecs);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the duration set using set_easing_duration()
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   * @return The duration of the animations, in milliseconds.
   */
  guint get_easing_duration() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the easing mode to be used by @a layout when animating changes in layout
   * properties.
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12: The layout manager will honour the easing state
   * of the children when allocating them.
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   * @param mode An easing mode, either from Clutter::AnimationMode or a logical id
   * from Clutter::Alpha::register_func().
   */
  void set_easing_mode(gulong mode);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the easing mode set using set_easing_mode()
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   * @return An easing mode.
   */
  gulong get_easing_mode() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The duration of the animations.
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_easing_duration() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The duration of the animations.
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_easing_duration() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

#endif // CLUTTERMM_DISABLE_DEPRECATED

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The easing mode of the animations.
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< unsigned long > property_easing_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The easing mode of the animations.
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< unsigned long > property_easing_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

#endif // CLUTTERMM_DISABLE_DEPRECATED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the layout should be homogeneous, i.e. all childs get the same size.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_homogeneous() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the layout should be homogeneous, i.e. all childs get the same size.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_homogeneous() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The orientation of the layout.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Orientation > property_orientation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The orientation of the layout.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Orientation > property_orientation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to pack items at the start of the box.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_pack_start() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to pack items at the start of the box.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_pack_start() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Spacing between children.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_spacing() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Spacing between children.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_spacing() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether layout changes should be animated.
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_animations() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether layout changes should be animated.
   * @deprecated The layout manager will honour the easing state of the children when allocating them.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_animations() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

#endif // CLUTTERMM_DISABLE_DEPRECATED

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the layout should be vertical, rather than horizontal.
   * @deprecated Use orientation instead.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_vertical() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the layout should be vertical, rather than horizontal.
   * @deprecated Use orientation instead.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_vertical() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

#endif // CLUTTERMM_DISABLE_DEPRECATED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::BoxLayout
   */
  Glib::RefPtr<Clutter::BoxLayout> wrap(ClutterBoxLayout* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BOX_LAYOUT_H */

