// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_COLOR_H
#define _CLUTTERMM_COLOR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/ustring.h>
#include <cluttermm/types.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _ClutterColor ClutterColor; }
#endif

namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var StaticColor COLOR_WHITE
 *  White color (ffffffff).
 * 
 *  @var StaticColor COLOR_BLACK
 *  Black color (000000ff).
 * 
 *  @var StaticColor COLOR_RED
 *  Red color (ff0000ff).
 * 
 *  @var StaticColor COLOR_DARK_RED
 *  Dark red color (800000ff).
 * 
 *  @var StaticColor COLOR_GREEN
 *  Green color (00ff00ff).
 * 
 *  @var StaticColor COLOR_DARK_GREEN
 *  Dark green color (008000ff).
 * 
 *  @var StaticColor COLOR_BLUE
 *  Blue color (0000ffff).
 * 
 *  @var StaticColor COLOR_DARK_BLUE
 *  Dark blue color (000080ff).
 * 
 *  @var StaticColor COLOR_CYAN
 *  Cyan color (00ffffff).
 * 
 *  @var StaticColor COLOR_DARK_CYAN
 *  Dark cyan color (008080ff).
 * 
 *  @var StaticColor COLOR_MAGENTA
 *  Magenta color (ff00ffff).
 * 
 *  @var StaticColor COLOR_DARK_MAGENTA
 *  Dark magenta color (800080ff).
 * 
 *  @var StaticColor COLOR_YELLOW
 *  Yellow color (ffff00ff).
 * 
 *  @var StaticColor COLOR_DARK_YELLOW
 *  Dark yellow color (808000ff).
 * 
 *  @var StaticColor COLOR_GRAY
 *  Gray color (a0a0a4ff).
 * 
 *  @var StaticColor COLOR_DARK_GRAY
 *  Dark Gray color (808080ff).
 * 
 *  @var StaticColor COLOR_LIGHT_GRAY
 *  Light gray color (c0c0c0ff).
 * 
 *  @var StaticColor COLOR_BUTTER
 *  Butter color (edd400ff).
 * 
 *  @var StaticColor COLOR_BUTTER_LIGHT
 *  Light butter color (fce94fff).
 * 
 *  @var StaticColor COLOR_BUTTER_DARK
 *  Dark butter color (c4a000ff).
 * 
 *  @var StaticColor COLOR_ORANGE
 *  Orange color (f57900ff).
 * 
 *  @var StaticColor COLOR_ORANGE_LIGHT
 *  Light orange color (fcaf3fff).
 * 
 *  @var StaticColor COLOR_ORANGE_DARK
 *  Dark orange color (ce5c00ff).
 * 
 *  @var StaticColor COLOR_CHOCOLATE
 *  Chocolate color (c17d11ff).
 * 
 *  @var StaticColor COLOR_CHOCOLATE_LIGHT
 *  Light chocolate color (e9b96eff).
 * 
 *  @var StaticColor COLOR_CHOCOLATE_DARK
 *  Dark chocolate color (8f5902ff).
 * 
 *  @var StaticColor COLOR_CHAMELEON
 *  Chameleon color (73d216ff).
 * 
 *  @var StaticColor COLOR_CHAMELEON_LIGHT
 *  Light chameleon color (8ae234ff).
 * 
 *  @var StaticColor COLOR_CHAMELEON_DARK
 *  Dark chameleon color (4e9a06ff).
 * 
 *  @var StaticColor COLOR_SKY_BLUE
 *  Sky color (3465a4ff).
 * 
 *  @var StaticColor COLOR_SKY_BLUE_LIGHT
 *  Light sky color (729fcfff).
 * 
 *  @var StaticColor COLOR_SKY_BLUE_DARK
 *  Dark sky color (204a87ff).
 * 
 *  @var StaticColor COLOR_PLUM
 *  Plum color (75507bff).
 * 
 *  @var StaticColor COLOR_PLUM_LIGHT
 *  Light plum color (ad7fa8ff).
 * 
 *  @var StaticColor COLOR_PLUM_DARK
 *  Dark plum color (5c3566ff).
 * 
 *  @var StaticColor COLOR_SCARLET_RED
 *  Scarlet red color (cc0000ff).
 * 
 *  @var StaticColor COLOR_SCARLET_RED_LIGHT
 *  Light scarlet red color (ef2929ff).
 * 
 *  @var StaticColor COLOR_SCARLET_RED_DARK
 *  Dark scarlet red color (a40000ff).
 * 
 *  @var StaticColor COLOR_ALUMINIUM_1
 *  Aluminium, first variant (eeeeecff).
 * 
 *  @var StaticColor COLOR_ALUMINIUM_2
 *  Aluminium, second variant (d3d7cfff).
 * 
 *  @var StaticColor COLOR_ALUMINIUM_3
 *  Aluminium, third variant (babdb6ff).
 * 
 *  @var StaticColor COLOR_ALUMINIUM_4
 *  Aluminium, fourth variant (888a85ff).
 * 
 *  @var StaticColor COLOR_ALUMINIUM_5
 *  Aluminium, fifth variant (555753ff).
 * 
 *  @var StaticColor COLOR_ALUMINIUM_6
 *  Aluminium, sixth variant (2e3436ff).
 * 
 *  @var StaticColor COLOR_TRANSPARENT
 *  Transparent color (00000000).
 * 
 *  @enum StaticColor
 * 
 * Named colors, for accessing global colors defined by Clutter
 * 
 * @newin{1,6}
 * @ingroup cluttermmEnums
 */
enum StaticColor
{
  COLOR_WHITE,
  COLOR_BLACK,
  COLOR_RED,
  COLOR_DARK_RED,
  COLOR_GREEN,
  COLOR_DARK_GREEN,
  COLOR_BLUE,
  COLOR_DARK_BLUE,
  COLOR_CYAN,
  COLOR_DARK_CYAN,
  COLOR_MAGENTA,
  COLOR_DARK_MAGENTA,
  COLOR_YELLOW,
  COLOR_DARK_YELLOW,
  COLOR_GRAY,
  COLOR_DARK_GRAY,
  COLOR_LIGHT_GRAY,
  COLOR_BUTTER,
  COLOR_BUTTER_LIGHT,
  COLOR_BUTTER_DARK,
  COLOR_ORANGE,
  COLOR_ORANGE_LIGHT,
  COLOR_ORANGE_DARK,
  COLOR_CHOCOLATE,
  COLOR_CHOCOLATE_LIGHT,
  COLOR_CHOCOLATE_DARK,
  COLOR_CHAMELEON,
  COLOR_CHAMELEON_LIGHT,
  COLOR_CHAMELEON_DARK,
  COLOR_SKY_BLUE,
  COLOR_SKY_BLUE_LIGHT,
  COLOR_SKY_BLUE_DARK,
  COLOR_PLUM,
  COLOR_PLUM_LIGHT,
  COLOR_PLUM_DARK,
  COLOR_SCARLET_RED,
  COLOR_SCARLET_RED_LIGHT,
  COLOR_SCARLET_RED_DARK,
  COLOR_ALUMINIUM_1,
  COLOR_ALUMINIUM_2,
  COLOR_ALUMINIUM_3,
  COLOR_ALUMINIUM_4,
  COLOR_ALUMINIUM_5,
  COLOR_ALUMINIUM_6,
  COLOR_TRANSPARENT
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::StaticColor> : public Glib::Value_Enum<Clutter::StaticColor>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Color
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Color CppObjectType;
  typedef ClutterColor BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit Color(ClutterColor* gobject, bool make_a_copy = true);

  Color(const Color& other);
  Color& operator=(const Color& other);

  ~Color();

  void swap(Color& other);

  ///Provides access to the underlying C instance.
  ClutterColor*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterColor* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  ClutterColor* gobj_copy() const;

protected:
  ClutterColor* gobject_;

private:

  
public:


  // TODO: it'd be nice if these constructors allowed you to specify the alpha
  // value, but the underlying set_from_*() functions don't accept an alpha
  // value so it would have to set the struct member directly.  The struct
  // member is a guint8 type, so the Fixed-point version would need conversions
  // or have an odd signature that takes a guint8 as the last parameter
  
  Color();

  /** Create a new Color object by specifying its value in RGB(A)
   */
  Color(guint8 red, guint8 green, guint8 blue, guint8 alpha=255);

  /** Create a new Color object by specifying its pixel value
   */
  explicit Color(guint32 pixel);

  // TODO: this could fail, just return a 'default' color or throw an exception?
  explicit Color(const Glib::ustring& color);

  explicit Color(StaticColor color);

  void set_from_rgb(guint8 red, guint8 blue, guint8 green);
  void set_from_string(const Glib::ustring& color);
  
  
  /** Returns a textual specification of @a color in the hexadecimal form
   * <tt>#rrggbbaa</tt>, where <tt>r</tt>,
   * <tt>g</tt>, <tt>b</tt> and <tt>a</tt> are
   * hexadecimal digits representing the red, green, blue and alpha components
   * respectively.
   * 
   * @newin{0,2}
   * @return A newly-allocated text string.
   */
  Glib::ustring to_string() const;
  
  /** Converts a color expressed in HLS (hue, luminance and saturation)
   * values into a Clutter::Color.
   * @param hue Hue value, in the 0 .. 360 range.
   * @param luminance Luminance value, in the 0 .. 1 range.
   * @param saturation Saturation value, in the 0 .. 1 range.
   */
  void set_from_hls(float hue, float luminance, float saturation);
  
  /** Converts @a color to the HLS format.
   * 
   * The @a hue value is in the 0 .. 360 range. The @a luminance and
   *  @a saturation values are in the 0 .. 1 range.
   * @param hue Return location for the hue value or <tt>0</tt>.
   * @param luminance Return location for the luminance value or <tt>0</tt>.
   * @param saturation Return location for the saturation value or <tt>0</tt>.
   */
  void to_hls(float& hue, float& luminance, float& saturation) const;
  
  /** Converts @a pixel from the packed representation of a four 8 bit channel
   * color to a Clutter::Color.
   * @param pixel A 32 bit packed integer containing a color.
   */
  void set_from_pixel(guint32 pixel);
  
  /** Converts @a color into a packed 32 bit integer, containing
   * all the four 8 bit channels used by Clutter::Color.
   * @return A packed color.
   */
  guint32 to_pixel() const;

  
  /** Adds @a a to @a b and saves the resulting color inside @a result.
   * 
   * The alpha channel of @a result is set as as the maximum value
   * between the alpha channels of @a a and @a b.
   * @param b A Clutter::Color.
   * @param result Return location for the result.
   */

  Color add(const Color& color) const;
  

  /** Subtracts @a b from @a a and saves the resulting color inside @a result.
   * 
   * This function assumes that the components of @a a are greater than the
   * components of @a b; the result is, otherwise, undefined.
   * 
   * The alpha channel of @a result is set as the minimum value
   * between the alpha channels of @a a and @a b.
   * @param b A Clutter::Color.
   * @param result Return location for the result.
   */

  Color subtract(const Color& color) const;
  

  // the 'darken', 'lighten', and 'shade' functions modify the source color and
  // store the result in the color object given by the 'dest' argument.  Usually
  // we wrap functions with a 'dest' argument to return a copy by value.
  // However, this means that we could never apply 'darken' directly to this
  // object (as we could in C by doing something like clutter_color_darken(&foo,
  // &foo)).  So I think it makes more sense in the C++ wrappers to darken
  // 'this' by default and if the user wants to darken a different color, they
  // can aways create the copy first and then call darken on it
  // (e.g. Color c2 = c1; c1.darken();).  I think this is more flexible than the
  // alternative.
  
  /** Darkens @a color by a fixed amount, and saves the changed color
   * in @a result.
   * @param result Return location for the darker color.
   */

  void darken();
  

  /** Lightens @a color by a fixed amount, and saves the changed color
   * in @a result.
   * @param result Return location for the lighter color.
   */

  void lighten();
  

  /** Shades @a color by @a factor and saves the modified color into @a result.
   * @param factor The shade factor to apply.
   * @param result Return location for the shaded color.
   */

  void shade(double shade);
  

  /** Interpolates between this initial color and a @a final color.
   * @param The interpolation progress.
   */
  Color interpolate(const Color& final, double progress) const;
  

   guint8 get_red() const;
    void set_red(const guint8& value);
    guint8 get_green() const;
    void set_green(const guint8& value);
    guint8 get_blue() const;
    void set_blue(const guint8& value);
    guint8 get_alpha() const;
    void set_alpha(const guint8& value);
 

};

/** @relates Clutter::Color
 * @return the sum of color1 and color2
 */
Color operator+(const Color& color1, const Color& color2);

/** @relates Clutter::Color
 * @return the color resulting from subtracting color2 from color1
 */
Color operator-(const Color& color1, const Color& color2);

} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::Color
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const Color& lhs, const Color& rhs);

/** @relates Clutter::Color
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const Color& lhs, const Color& rhs);


} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::Color
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Color& lhs, Color& rhs)
  { lhs.swap(rhs); }

} // namespace Clutter

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Clutter::Color
 */
Clutter::Color wrap(ClutterColor* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Color> : public Glib::Value_Boxed<Clutter::Color>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _CLUTTERMM_COLOR_H */

