// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_PATH_CONSTRAINT_H
#define _CLUTTERMM_PATH_CONSTRAINT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2014 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <glibmm/object.h>
#include <cluttermm/constraint.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterPathConstraint ClutterPathConstraint;
typedef struct _ClutterPathConstraintClass ClutterPathConstraintClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class PathConstraint_Class; } // namespace Clutter
namespace Clutter
{

class Actor;
class Path;

/** PathConstraint is a simple constraint that modifies the allocation of
 * the Actor to which it has been applied using a ClutterPath.
 *
 * By setting the “offset” property it is possible to control how far along the
 * path the Actor should be.
 *
 * @newin{1,6}
 */

class PathConstraint : public Constraint
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef PathConstraint CppObjectType;
  typedef PathConstraint_Class CppClassType;
  typedef ClutterPathConstraint BaseObjectType;
  typedef ClutterPathConstraintClass BaseClassType;

private:  friend class PathConstraint_Class;
  static CppClassType pathconstraint_class_;

private:
  // noncopyable
  PathConstraint(const PathConstraint&);
  PathConstraint& operator=(const PathConstraint&);

protected:
  explicit PathConstraint(const Glib::ConstructParams& construct_params);
  explicit PathConstraint(ClutterPathConstraint* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~PathConstraint();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterPathConstraint*       gobj()       { return reinterpret_cast<ClutterPathConstraint*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterPathConstraint* gobj() const { return reinterpret_cast<ClutterPathConstraint*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterPathConstraint* gobj_copy();

private:

  
protected:

    explicit PathConstraint(const Glib::RefPtr<Path>& path, float offset);


public:

  
  static Glib::RefPtr<PathConstraint> create(const Glib::RefPtr<Path>& path, float offset);


  /** Sets the @a path to be followed by the Clutter::PathConstraint.
   * 
   * The @a constraint will take ownership of the Clutter::Path passed to this
   * function.
   * 
   * @newin{1,6}
   * @param path A Clutter::Path.
   */
  void set_path(const Glib::RefPtr<Path>& path);

  
  /** Retrieves a pointer to the Clutter::Path used by @a constraint.
   * 
   * @newin{1,6}
   * @return The Clutter::Path used by the
   * Clutter::PathConstraint, or <tt>0</tt>. The returned Clutter::Path is owned
   * by the constraint and it should not be unreferenced.
   */
  Glib::RefPtr<Path> get_path();
  
  /** Retrieves a pointer to the Clutter::Path used by @a constraint.
   * 
   * @newin{1,6}
   * @return The Clutter::Path used by the
   * Clutter::PathConstraint, or <tt>0</tt>. The returned Clutter::Path is owned
   * by the constraint and it should not be unreferenced.
   */
  Glib::RefPtr<const Path> get_path() const;

  
  /** Sets the offset along the Clutter::Path used by @a constraint.
   * 
   * @newin{1,6}
   * @param offset The offset along the path.
   */
  void set_offset(float offset);

  
  /** Retrieves the offset along the Clutter::Path used by @a constraint.
   * 
   * @newin{1,6}
   * @return The offset.
   */
  float get_offset() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The offset along the path, between -1.0 and 2.0.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_offset() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The offset along the path, between -1.0 and 2.0.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_offset() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The path used to constrain an actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Path> > property_path() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The path used to constrain an actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Path> > property_path() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //We use NO_DEFAULT_HANDLER because the ClutterPathConstraint struct definition is hidden.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%node_reached(const Glib::RefPtr<Actor> actor, guint index)</tt>
   *
   * The signal_node_reached() signal is emitted each time a
   * Clutter::PathConstraint::property_offset() value results in the actor
   * passing a Clutter::PathNode
   * 
   * @newin{1,6}
   * @param actor The Clutter::Actor using the @a constraint.
   * @param index The index of the node that has been reached.
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Actor>,guint > signal_node_reached();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::PathConstraint
   */
  Glib::RefPtr<Clutter::PathConstraint> wrap(ClutterPathConstraint* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_PATH_CONSTRAINT_H */

