// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_SHADER_EFFECT_H
#define _CLUTTERMM_SHADER_EFFECT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/offscreen-effect.h>
#include <cluttermm/types.h>
#include <glibmm/value.h>
#include <glibmm/object.h>
#include <cogl/cogl.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterShaderEffect ClutterShaderEffect;
typedef struct _ClutterShaderEffectClass ClutterShaderEffectClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class ShaderEffect_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var ShaderType VERTEX_SHADER
 *  A vertex shader.
 * 
 *  @var ShaderType FRAGMENT_SHADER
 *  A fragment shader.
 * 
 *  @enum ShaderType
 * 
 * The type of GLSL shader program
 * 
 * @newin{1,4}
 * @ingroup cluttermmEnums
 */
enum ShaderType
{
  VERTEX_SHADER,
  FRAGMENT_SHADER
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ShaderType> : public Glib::Value_Enum<Clutter::ShaderType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class ShaderEffect :
  public Clutter::OffscreenEffect
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ShaderEffect CppObjectType;
  typedef ShaderEffect_Class CppClassType;
  typedef ClutterShaderEffect BaseObjectType;
  typedef ClutterShaderEffectClass BaseClassType;

private:  friend class ShaderEffect_Class;
  static CppClassType shadereffect_class_;

private:
  // noncopyable
  ShaderEffect(const ShaderEffect&);
  ShaderEffect& operator=(const ShaderEffect&);

protected:
  explicit ShaderEffect(const Glib::ConstructParams& construct_params);
  explicit ShaderEffect(ClutterShaderEffect* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ShaderEffect();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterShaderEffect*       gobj()       { return reinterpret_cast<ClutterShaderEffect*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterShaderEffect* gobj() const { return reinterpret_cast<ClutterShaderEffect*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterShaderEffect* gobj_copy();

private:


protected:
    explicit ShaderEffect(ShaderType shader_type);


public:
  
  static Glib::RefPtr<ShaderEffect> create(ShaderType shader_type);


  //TODO:   #m4 __CONVERSION(`const GValue*',`const Glib::Value&',`Glib::wrap($3)')
  // #m4 __CONVERSION(`const Glib::ValueBase&',`const GValue*',__CONVERT_REFPTR_TO_P)
  // _WRAP_METHOD(void set_uniform_value(const Glib::ustring& name, const Glib::ValueBase& value), clutter_shader_effect_set_uniform_value)

  
  /** Sets the source of the GLSL shader used by @a effect
   * 
   * This function should only be called by implementations of
   * the Clutter::ShaderEffect class, and not by application code.
   * 
   * This function can only be called once; subsequent calls will
   * yield no result.
   * 
   * @newin{1,4}
   * @param source The source of a GLSL shader.
   * @return <tt>true</tt> if the source was set.
   */
  bool set_shader_source(const Glib::ustring& source);

  //TODO: Should these be const?
  
  /** Retrieves a pointer to the program's handle
   * 
   * @newin{1,4}
   * @return A pointer to the program's handle,
   * or Cogl::INVALID_HANDLE.
   */
  CoglHandle get_program();
  
  /** Retrieves a pointer to the shader's handle
   * 
   * @newin{1,4}
   * @return A pointer to the shader's handle,
   * or Cogl::INVALID_HANDLE.
   */
  CoglHandle get_shader();

  // Write only and construct-only property:
  //_WRAP_PROPERTY("shader-type", ShaderType)

protected:
  //gtkmmproc error: get_static_shader_source :  vfunc defs lookup failed


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};


}//namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::ShaderEffect
   */
  Glib::RefPtr<Clutter::ShaderEffect> wrap(ClutterShaderEffect* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_SHADER_EFFECT_H */

