// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TEXT_BUFFER_H
#define _CLUTTERMM_TEXT_BUFFER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2013 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <glibmm/ustring.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterTextBuffer ClutterTextBuffer;
typedef struct _ClutterTextBufferClass ClutterTextBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class TextBuffer_Class; } // namespace Clutter
namespace Clutter
{


class TextBuffer: public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TextBuffer CppObjectType;
  typedef TextBuffer_Class CppClassType;
  typedef ClutterTextBuffer BaseObjectType;
  typedef ClutterTextBufferClass BaseClassType;

private:  friend class TextBuffer_Class;
  static CppClassType textbuffer_class_;

private:
  // noncopyable
  TextBuffer(const TextBuffer&);
  TextBuffer& operator=(const TextBuffer&);

protected:
  explicit TextBuffer(const Glib::ConstructParams& construct_params);
  explicit TextBuffer(ClutterTextBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TextBuffer();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterTextBuffer*       gobj()       { return reinterpret_cast<ClutterTextBuffer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterTextBuffer* gobj() const { return reinterpret_cast<ClutterTextBuffer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterTextBuffer* gobj_copy();

private:

  
protected:
    explicit TextBuffer();


  /** Create a new ClutterTextBuffer object with some text.
   * 
   * @newin{1,10}
   * @param text Initial buffer text.
   * @param text_len Initial buffer text length, or -1 for null-terminated.
   * @return A new ClutterTextBuffer object.
   */

  explicit TextBuffer(const Glib::ustring& text);

public:

  
  static Glib::RefPtr<TextBuffer> create();


  /**
   * sets the text in the buffer.
   * */
  void set_text(const Glib::ustring& text);
  

  /** Retrieves the contents of the buffer.
   * 
   * The memory pointer returned by this call will not change
   * unless this object emits a signal, or is finalized.
   * 
   * @newin{1,10}
   * @return A pointer to the contents of the widget as a
   * string. This string points to internally allocated
   * storage in the buffer and must not be freed, modified or
   * stored.
   */
  Glib::ustring get_text() const;
  
  /** Retrieves the length in bytes of the buffer.
   * See get_length().
   * 
   * @newin{1,10}
   * @return The byte length of the buffer.
   */
  gsize get_bytes() const;
  
  /** Retrieves the length in characters of the buffer.
   * 
   * @newin{1,10}
   * @return The number of characters in the buffer.
   */
  guint get_length() const;
  
  /** Sets the maximum allowed length of the contents of the buffer. If
   * the current contents are longer than the given length, then they
   * will be truncated to fit.
   * 
   * @newin{1,10}
   * @param max_length The maximum length of the entry buffer, or 0 for no maximum.
   * (other than the maximum length of entries.) The value passed in will
   * be clamped to the range [ 0, Clutter::TEXT_BUFFER_MAX_SIZE ].
   */
  void set_max_length(int max_length);
  
  /** Retrieves the maximum allowed length of the text in
   *  @a buffer. See set_max_length().
   * 
   * @newin{1,10}
   * @return The maximum allowed number of characters
   * in Clutter::TextBuffer, or 0 if there is no maximum.
   */
  int get_max_length() const;


  /** Inserts @a n_chars characters of @a chars into the contents of the
   * buffer, at position @a position.
   * 
   * If @a n_chars is negative, then characters from chars will be inserted
   * until a null-terminator is found. If @a position or @a n_chars are out of
   * bounds, or the maximum buffer text length is exceeded, then they are
   * coerced to sane values.
   * 
   * Note that the position and length are in characters, not in bytes.
   * 
   * @newin{1,10}
   * @param position The position at which to insert text.
   * @param chars The text to insert into the buffer.
   * @param n_chars The length of the text in characters, or -1.
   * @return The number of characters actually inserted.
   */
  guint insert_text(guint position, const Glib::ustring& chars, int n_chars);
  
  /** Deletes a sequence of characters from the buffer. @a n_chars characters are
   * deleted starting at @a position. If @a n_chars is negative, then all characters
   * until the end of the text are deleted.
   * 
   * If @a position or @a n_chars are out of bounds, then they are coerced to sane
   * values.
   * 
   * Note that the positions are specified in characters, not bytes.
   * 
   * @newin{1,10}
   * @param position Position at which to delete text.
   * @param n_chars Number of characters to delete.
   * @return The number of characters deleted.
   */
  guint delete_text(guint position, int n_chars);
  
  /** Emits the Clutter::TextBuffer::signal_inserted_text() signal on @a buffer.
   * 
   * Used when subclassing Clutter::TextBuffer
   * 
   * @newin{1,10}
   * @param position Position at which text was inserted.
   * @param chars Text that was inserted.
   * @param n_chars Number of characters inserted.
   */
  void emit_inserted_text(guint position, const Glib::ustring& chars, guint n_chars);
  
  /** Emits the Clutter::TextBuffer::signal_deleted_text() signal on @a buffer.
   * 
   * Used when subclassing Clutter::TextBuffer
   * 
   * @newin{1,10}
   * @param position Position at which text was deleted.
   * @param n_chars Number of characters deleted.
   */
  void emit_deleted_text(guint position, guint n_chars);

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%deleted_text(guint position, guint n_chars)</tt>
   *
   * This signal is emitted after text is deleted from the buffer.
   * 
   * @newin{1,10}
   * @param position The position the text was deleted at.
   * @param n_chars The number of characters that were deleted.
   */

  Glib::SignalProxy2< void,guint,guint > signal_deleted_text();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%inserted_text(guint position, const Glib::ustring& chars, guint n_chars)</tt>
   *
   * This signal is emitted after text is inserted into the buffer.
   * 
   * @newin{1,10}
   * @param position The position the text was inserted at.
   * @param chars The text that was inserted.
   * @param n_chars The number of characters that were inserted.
   */

  Glib::SignalProxy3< void,guint,const Glib::ustring&,guint > signal_inserted_text();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Length of the text currently in the buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of characters for this entry. Zero if no maximum.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_max_length() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of characters for this entry. Zero if no maximum.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_max_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The contents of the buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_deleted_text().
  virtual void on_deleted_text(guint position, guint n_chars);
  /// This is a default handler for the signal signal_inserted_text().
  virtual void on_inserted_text(guint position, const Glib::ustring& chars, guint n_chars);


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::TextBuffer
   */
  Glib::RefPtr<Clutter::TextBuffer> wrap(ClutterTextBuffer* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_TEXT_BUFFER_H */

