// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ACTOR_BOX_H
#define _CLUTTERMM_ACTOR_BOX_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/types.h> // For Event*


namespace Clutter
{

class ActorBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ActorBox CppObjectType;
  typedef ClutterActorBox BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit ActorBox(const ClutterActorBox* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterActorBox*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterActorBox* gobj() const { return &gobject_; }

protected:
  ClutterActorBox gobject_;

private:
  
  
public:
  

  //hand-coded constructor to allow default values:
  explicit ActorBox(float x1 = 0, float y1 = 0, float x2 = 0, float y2 = 0);

  // Convenience constructor that would be difficult to wrap - it's got 4
  // floats (origin x and y and the width and height) so will conflict with the
  // other constructor.
  

  /** Retrieves the X coordinate of the origin of @a box
   * 
   * @newin{1,0}
   * @return The X coordinate of the origin.
   */
  float get_x() const;
  
  /** Retrieves the Y coordinate of the origin of @a box
   * 
   * @newin{1,0}
   * @return The Y coordinate of the origin.
   */
  float get_y() const;
  
  /** Retrieves the width of the @a box
   * 
   * @newin{1,0}
   * @return The width of the box.
   */
  float get_width() const;
  
  /** Retrieves the height of the @a box
   * 
   * @newin{1,0}
   * @return The height of the box.
   */
  float get_height() const;
  
  /** Changes the origin of @a box, maintaining the size of the Clutter::ActorBox.
   * 
   * @newin{1,6}
   * @param x The X coordinate of the new origin.
   * @param y The Y coordinate of the new origin.
   */
  void set_origin(float x, float y);

   
  /** Retrieves the origin of @a box
   * 
   * @newin{1,0}
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_origin(float& x, float& y) const;
  
  /** Sets the size of @a box, maintaining the origin of the Clutter::ActorBox.
   * 
   * @newin{1,6}
   * @param width The new width.
   * @param height The new height.
   */
  void set_size(float width, float height);
  
  /** Retrieves the size of @a box
   * 
   * @newin{1,0}
   * @param width Return location for the width, or <tt>0</tt>.
   * @param height Return location for the height, or <tt>0</tt>.
   */
  void get_size(float& width, float& height) const;

  
  /** Retrieves the area of @a box
   * 
   * @newin{1,0}
   * @return The area of a Clutter::ActorBox, in pixels.
   */
  float get_area() const;
  
  /** Checks whether a point with @a x, @a y coordinates is contained
   * withing @a box
   * 
   * @newin{1,0}
   * @param x X coordinate of the point.
   * @param y Y coordinate of the point.
   * @return <tt>true</tt> if the point is contained by the Clutter::ActorBox.
   */
  bool contains(float x, float y) const;

  // wrap if need be- what would be the use case?
  
  //_WRAP_METHOD(bool from_vertices(const ClutterVertex verts[]) const, clutter_actor_box_from_vertices
  
  /** Clamps the components of @a box to the nearest integer
   * 
   * @newin{1,2}
   */
  void clamp_to_pixel();

 
  /** Interpolates between @a initial and @a final Clutter::ActorBox<!-- -->es
   * using @a progress
   * 
   * @newin{1,2}
   * @param final The final Clutter::ActorBox.
   * @param progress The interpolation progress.
   * @param result Return location for the interpolation.
   */
  void interpolate(const ActorBox& final_, double progress, ActorBox& result);

  
  /** Unions the two boxes @a a and @a b and stores the result in @a result.
   * 
   * @newin{1,4}
   * @param b The second Clutter::ActorBox.
   * @param result The Clutter::ActorBox representing a union
   * of @a a and @a b.
   */
  void unite(const ActorBox& b, ActorBox& result);


};

} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::ActorBox
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const ActorBox& lhs, const ActorBox& rhs);

/** @relates Clutter::ActorBox
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const ActorBox& lhs, const ActorBox& rhs);


} // namespace Clutter


namespace Glib
{

/** @relates Clutter::ActorBox
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::ActorBox& wrap(ClutterActorBox* object);

/** @relates Clutter::ActorBox
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::ActorBox& wrap(const ClutterActorBox* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::ActorBox> : public Glib::Value_Boxed<Clutter::ActorBox>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _CLUTTERMM_ACTOR_BOX_H */

