// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ACTOR_META_H
#define _CLUTTERMM_ACTOR_META_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2010 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterActorMeta ClutterActorMeta;
typedef struct _ClutterActorMetaClass ClutterActorMetaClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class ActorMeta_Class; } // namespace Clutter
namespace Clutter
{

class Actor;

/**
 * Clutter::ActorMeta is an abstract class providing a common API for modifiers
 *  of Clutter::Actor activity, appearance or layout.
 *
 * A Clutter::ActorMeta can only be owned by a single Clutter::Actor at any time.
 *
 * Every sub-class of Clutter::ActorMeta should check if the “enabled” property
 * is set to true before applying any kind of modification.
 *
 * Clutter::ActorMeta is available since Clutter 1.4
 */

class ActorMeta : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ActorMeta CppObjectType;
  typedef ActorMeta_Class CppClassType;
  typedef ClutterActorMeta BaseObjectType;
  typedef ClutterActorMetaClass BaseClassType;

private:  friend class ActorMeta_Class;
  static CppClassType actormeta_class_;

private:
  // noncopyable
  ActorMeta(const ActorMeta&);
  ActorMeta& operator=(const ActorMeta&);

protected:
  explicit ActorMeta(const Glib::ConstructParams& construct_params);
  explicit ActorMeta(ClutterActorMeta* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ActorMeta();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterActorMeta*       gobj()       { return reinterpret_cast<ClutterActorMeta*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterActorMeta* gobj() const { return reinterpret_cast<ClutterActorMeta*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterActorMeta* gobj_copy();

private:

  
protected:
  ActorMeta();

public:
  //There is no create() because this is an abstract base class.
  //_WRAP_CREATE()

  
  /** Sets the name of @a meta
   * 
   * The name can be used to identify the Clutter::ActorMeta instance
   * 
   * @newin{1,4}
   * @param name The name of @a meta.
   */
  void set_name(const Glib::ustring& name);
  
  /** Retrieves the name set using set_name()
   * 
   * @newin{1,4}
   * @return The name of the Clutter::ActorMeta
   * instance, or <tt>0</tt> if none was set. The returned string is owned
   * by the Clutter::ActorMeta instance and it should not be modified
   * or freed.
   */
  Glib::ustring get_name() const;
  
  /** Sets whether @a meta should be enabled or not
   * 
   * @newin{1,4}
   * @param is_enabled Whether @a meta is enabled.
   */
  void set_enabled(bool is_enabled =  true);
  
  /** Retrieves whether @a meta is enabled
   * 
   * @newin{1,4}
   * @return <tt>true</tt> if the Clutter::ActorMeta instance is enabled.
   */
  bool get_enabled() const;

  
  /** Retrieves a pointer to the Clutter::Actor that owns @a meta
   * 
   * @newin{1,4}
   * @return A pointer to a Clutter::Actor or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_actor();
  
  /** Retrieves a pointer to the Clutter::Actor that owns @a meta
   * 
   * @newin{1,4}
   * @return A pointer to a Clutter::Actor or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_actor() const;

protected:
  //vfuncs:
 

    virtual void set_actor_vfunc(const Glib::RefPtr<const Actor>& actor);


  //properties:
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor attached to the meta.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Actor> > property_actor() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the meta is enabled.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_enabled() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the meta is enabled.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_enabled() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the meta.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the meta.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::ActorMeta
   */
  Glib::RefPtr<Clutter::ActorMeta> wrap(ClutterActorMeta* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ACTOR_META_H */

