// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ALIGN_CONSTRAINT_H
#define _CLUTTERMM_ALIGN_CONSTRAINT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2014 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/constraint.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterAlignConstraint ClutterAlignConstraint;
typedef struct _ClutterAlignConstraintClass ClutterAlignConstraintClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class AlignConstraint_Class; } // namespace Clutter
namespace Clutter
{

class Actor;
/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var AlignAxis ALIGN_X_AXIS
 *  Maintain the alignment on the X axis.
 * 
 *  @var AlignAxis ALIGN_Y_AXIS
 *  Maintain the alignment on the Y axis.
 * 
 *  @var AlignAxis ALIGN_BOTH
 *  Maintain the alignment on both the X and Y axis.
 * 
 *  @enum AlignAxis
 * 
 * Specifies the axis on which Clutter::AlignConstraint should maintain
 * the alignment.
 * 
 * @newin{1,4}
 * @ingroup cluttermmEnums
 */
enum AlignAxis
{
  ALIGN_X_AXIS,
  ALIGN_Y_AXIS,
  ALIGN_BOTH
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::AlignAxis> : public Glib::Value_Enum<Clutter::AlignAxis>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


/** AlignConstraint is a Constraint that aligns the position of the Actor to
 * which it is applied to the size of another Actor using an alignment factor.
 *
 * @newin{1,4}
 */

class AlignConstraint  : public Constraint
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef AlignConstraint CppObjectType;
  typedef AlignConstraint_Class CppClassType;
  typedef ClutterAlignConstraint BaseObjectType;
  typedef ClutterAlignConstraintClass BaseClassType;

private:  friend class AlignConstraint_Class;
  static CppClassType alignconstraint_class_;

private:
  // noncopyable
  AlignConstraint(const AlignConstraint&);
  AlignConstraint& operator=(const AlignConstraint&);

protected:
  explicit AlignConstraint(const Glib::ConstructParams& construct_params);
  explicit AlignConstraint(ClutterAlignConstraint* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~AlignConstraint();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterAlignConstraint*       gobj()       { return reinterpret_cast<ClutterAlignConstraint*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterAlignConstraint* gobj() const { return reinterpret_cast<ClutterAlignConstraint*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterAlignConstraint* gobj_copy();

private:

  
protected:
    explicit AlignConstraint(const Glib::RefPtr<Actor>& source, Clutter::AlignAxis align_axis, float factor);


public:
  
  static Glib::RefPtr<AlignConstraint> create(const Glib::RefPtr<Actor>& source, AlignAxis axis, float factor);


  /** Sets the source of the alignment constraint
   * 
   * @newin{1,4}
   * @param source A Clutter::Actor, or <tt>0</tt> to unset the source.
   */
  void set_source(const Glib::RefPtr<Actor>& source);

  
  /** Retrieves the source of the alignment
   * 
   * @newin{1,4}
   * @return The Clutter::Actor used as the source
   * of the alignment.
   */
  Glib::RefPtr<Actor> get_source();
  
  /** Retrieves the source of the alignment
   * 
   * @newin{1,4}
   * @return The Clutter::Actor used as the source
   * of the alignment.
   */
  Glib::RefPtr<const Actor> get_source() const;

  
  /** Sets the axis to which the alignment refers to
   * 
   * @newin{1,4}
   * @param axis The axis to which the alignment refers to.
   */
  void set_align_axis(AlignAxis axis);
  
  /** Retrieves the value set using set_align_axis()
   * 
   * @newin{1,4}
   * @return The alignment axis.
   */
  AlignAxis get_align_axis() const;
  
  /** Sets the alignment factor of the constraint
   * 
   * The factor depends on the Clutter::AlignConstraint::property_align_axis() property
   * and it is a value between 0.0 (meaning left, when
   * Clutter::AlignConstraint::property_align_axis() is set to Clutter::ALIGN_X_AXIS; or
   * meaning top, when Clutter::AlignConstraint::property_align_axis() is set to
   * Clutter::ALIGN_Y_AXIS) and 1.0 (meaning right, when
   * Clutter::AlignConstraint::property_align_axis() is set to Clutter::ALIGN_X_AXIS; or
   * meaning bottom, when Clutter::AlignConstraint::property_align_axis() is set to
   * Clutter::ALIGN_Y_AXIS). A value of 0.5 aligns in the middle in either
   * cases
   * 
   * @newin{1,4}
   * @param factor The alignment factor, between 0.0 and 1.0.
   */
  void set_factor(float factor);
  
  /** Retrieves the factor set using set_factor()
   * 
   * @newin{1,4}
   * @return The alignment factor.
   */
  float get_factor() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The axis to align the position to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< AlignAxis > property_align_axis() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The axis to align the position to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< AlignAxis > property_align_axis() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The alignment factor, between 0.0 and 1.0.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_factor() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The alignment factor, between 0.0 and 1.0.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_factor() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The source of the alignment.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Actor > property_source() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The source of the alignment.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Actor > property_source() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::AlignConstraint
   */
  Glib::RefPtr<Clutter::AlignConstraint> wrap(ClutterAlignConstraint* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ALIGN_CONSTRAINT_H */

