// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_GRID_LAYOUT_H
#define _CLUTTERMM_GRID_LAYOUT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2014 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/layout-manager.h>
#include <cluttermm/types.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterGridLayout ClutterGridLayout;
typedef struct _ClutterGridLayoutClass ClutterGridLayoutClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class GridLayout_Class; } // namespace Clutter
namespace Clutter
{

class Actor;

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var GridPosition GRID_POSITION_LEFT
 *  Left position.
 * 
 *  @var GridPosition GRID_POSITION_RIGHT
 *  Right position.
 * 
 *  @var GridPosition GRID_POSITION_TOP
 *  Top position.
 * 
 *  @var GridPosition GRID_POSITION_BOTTOM
 *  Bottom position.
 * 
 *  @enum GridPosition
 * 
 * Grid position modes.
 * 
 * @newin{1,12}
 * @ingroup cluttermmEnums
 */
enum GridPosition
{
  GRID_POSITION_LEFT,
  GRID_POSITION_RIGHT,
  GRID_POSITION_TOP,
  GRID_POSITION_BOTTOM
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::GridPosition> : public Glib::Value_Enum<Clutter::GridPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class GridLayout :
  public LayoutManager
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef GridLayout CppObjectType;
  typedef GridLayout_Class CppClassType;
  typedef ClutterGridLayout BaseObjectType;
  typedef ClutterGridLayoutClass BaseClassType;

private:  friend class GridLayout_Class;
  static CppClassType gridlayout_class_;

private:
  // noncopyable
  GridLayout(const GridLayout&);
  GridLayout& operator=(const GridLayout&);

protected:
  explicit GridLayout(const Glib::ConstructParams& construct_params);
  explicit GridLayout(ClutterGridLayout* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~GridLayout();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterGridLayout*       gobj()       { return reinterpret_cast<ClutterGridLayout*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterGridLayout* gobj() const { return reinterpret_cast<ClutterGridLayout*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterGridLayout* gobj_copy();

private:

  
protected:
    explicit GridLayout();


public:
  
  static Glib::RefPtr<GridLayout> create();


  /** Adds a widget to the grid.
   * 
   * The position of @a child is determined by @a left and @a top. The
   * number of 'cells' that @a child will occupy is determined by
   *  @a width and @a height.
   * 
   * @newin{1,12}
   * @param child The Clutter::Actor to add.
   * @param left The column number to attach the left side of @a child to.
   * @param top The row number to attach the top side of @a child to.
   * @param width The number of columns that @a child will span.
   * @param height The number of rows that @a child will span.
   */
  void attach(const Glib::RefPtr<Actor>& child, int left, int top, int width, int height);
  
  /** Adds a actor to the grid.
   * 
   * The actor is placed next to @a sibling, on the side determined by
   *  @a side. When @a sibling is <tt>0</tt>, the actor is placed in row (for
   * left or right placement) or column 0 (for top or bottom placement),
   * at the end indicated by @a side.
   * 
   * Attaching widgets labeled [1], [2], [3] with @a sibling == <tt>0</tt> and
   *  @a side == Clutter::GRID_POSITION_LEFT yields a layout of [3][2][1].
   * 
   * @newin{1,12}
   * @param child The actor to add.
   * @param sibling The child of @a layout that @a child will be placed
   * next to, or <tt>0</tt> to place @a child at the beginning or end.
   * @param side The side of @a sibling that @a child is positioned next to.
   * @param width The number of columns that @a child will span.
   * @param height The number of rows that @a child will span.
   */
  void attach_next_to(const Glib::RefPtr<Actor>& child, const Glib::RefPtr<Actor>& sibling, GridPosition side, int width, int height);

  
  /** Gets the child of @a layout whose area covers the grid
   * cell whose upper left corner is at @a left, @a top.
   * 
   * @newin{1,12}
   * @param left The left edge of the cell.
   * @param top The top edge of the cell.
   * @return The child at the given position, or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_child_at(int left, int top);
  
  /** Gets the child of @a layout whose area covers the grid
   * cell whose upper left corner is at @a left, @a top.
   * 
   * @newin{1,12}
   * @param left The left edge of the cell.
   * @param top The top edge of the cell.
   * @return The child at the given position, or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_child_at(int left, int top) const;

  
  /** Inserts a column at the specified position.
   * 
   * Children which are attached at or to the right of this position
   * are moved one column to the right. Children which span across this
   * position are grown to span the new column.
   * 
   * @newin{1,12}
   * @param position The position to insert the column at.
   */
  void insert_column(int position);
  
  /** Inserts a row at the specified position.
   * 
   * Children which are attached at or below this position
   * are moved one row down. Children which span across this
   * position are grown to span the new row.
   * 
   * @newin{1,12}
   * @param position The position to insert the row at.
   */
  void insert_row(int position);
  
  /** Inserts a row or column at the specified position.
   * 
   * The new row or column is placed next to @a sibling, on the side
   * determined by @a side. If @a side is Clutter::GRID_POSITION_LEFT or
   * Clutter::GRID_POSITION_BOTTOM, a row is inserted. If @a side is
   * Clutter::GRID_POSITION_LEFT of Clutter::GRID_POSITION_RIGHT,
   * a column is inserted.
   * 
   * @newin{1,12}
   * @param sibling The child of @a layout that the new row or column will be
   * placed next to.
   * @param side The side of @a sibling that @a child is positioned next to.
   */
  void insert_next_to(const Glib::RefPtr<Actor>& sibling, GridPosition side);
  
  /** Sets the orientation of the @a layout
   * 
   * @newin{1,12}
   * @param orientation The orientation of the Clutter::GridLayout.
   */
  void set_orientation(Orientation orientation);
  
  /** Retrieves the orientation of the @a layout.
   * 
   * @newin{1,12}
   * @return The orientation of the layout.
   */
  Orientation get_orientation() const;
  
  /** Sets whether all columns of @a layout will have the same width.
   * 
   * @newin{1,12}
   * @param homogeneous <tt>true</tt> to make columns homogeneous.
   */
  void set_column_homogeneous(bool homogeneous =  true);
  
  /** Returns whether all columns of @a layout have the same width.
   * @return Whether all columns of @a layout have the same width.
   */
  bool get_column_homogeneous() const;
  
  /** Sets whether all rows of @a layout will have the same height.
   * 
   * @newin{1,12}
   * @param homogeneous <tt>true</tt> to make rows homogeneous.
   */
  void set_row_homogeneous(bool homogeneous =  true);
  
  /** Returns whether all rows of @a layout have the same height.
   * 
   * @newin{1,12}
   * @return Whether all rows of @a layout have the same height.
   */
  bool get_row_homogeneous() const;
  
  /** Sets the spacing between columns of @a layout
   * 
   * @newin{1,12}
   * @param spacing The spacing between columns of the layout, in pixels.
   */
  void set_column_spacing(guint spacing);
  
  /** Retrieves the spacing set using set_column_spacing()
   * 
   * @newin{1,12}
   * @return The spacing between coluns of @a layout.
   */
  guint get_column_spacing() const;
  
  /** Sets the spacing between rows of @a layout
   * 
   * @newin{1,12}
   * @param spacing The spacing between rows of the layout, in pixels.
   */
  void set_row_spacing(guint spacing);
  
  /** Retrieves the spacing set using set_row_spacing()
   * 
   * @newin{1,12}
   * @return The spacing between rows of @a layout.
   */
  guint get_row_spacing() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE, the columns are all the same width.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_column_homogeneous() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE, the columns are all the same width.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_column_homogeneous() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The amount of space between two consecutive columns.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_column_spacing() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The amount of space between two consecutive columns.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_column_spacing() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE, the rows are all the same height.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_row_homogeneous() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE, the rows are all the same height.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_row_homogeneous() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The amount of space between two consecutive rows.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_row_spacing() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The amount of space between two consecutive rows.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_row_spacing() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The orientation of the layout.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Orientation > property_orientation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The orientation of the layout.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Orientation > property_orientation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::GridLayout
   */
  Glib::RefPtr<Clutter::GridLayout> wrap(ClutterGridLayout* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_GRID_LAYOUT_H */

