// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_INPUT_DEVICE_H
#define _CLUTTERMM_INPUT_DEVICE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/types.h>


//TODO: Wrap this?
typedef struct _ClutterEventSequence            ClutterEventSequence;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterInputDevice ClutterInputDevice;
typedef struct _ClutterInputDeviceClass ClutterInputDeviceClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class InputDevice_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var InputAxis INPUT_AXIS_IGNORE
 *  Unused axis.
 * 
 *  @var InputAxis INPUT_AXIS_X
 *  The position on the X axis.
 * 
 *  @var InputAxis INPUT_AXIS_Y
 *  The position of the Y axis.
 * 
 *  @var InputAxis INPUT_AXIS_PRESSURE
 *  The pressure information.
 * 
 *  @var InputAxis INPUT_AXIS_XTILT
 *  The tilt on the X axis.
 * 
 *  @var InputAxis INPUT_AXIS_YTILT
 *  The tile on the Y axis.
 * 
 *  @var InputAxis INPUT_AXIS_WHEEL
 *  A wheel.
 * 
 *  @var InputAxis INPUT_AXIS_DISTANCE
 *  Distance (Since 1.12).
 * 
 *  @var InputAxis INPUT_AXIS_LAST
 *  Last value of the enumeration; this value is useful when iterating over the enumeration values (Since 1.12).
 * 
 *  @enum InputAxis
 * 
 * The type of axes Clutter recognizes on a Clutter::InputDevice
 * 
 * @newin{1,6}
 * @ingroup cluttermmEnums
 */
enum InputAxis
{
  INPUT_AXIS_IGNORE,
  INPUT_AXIS_X,
  INPUT_AXIS_Y,
  INPUT_AXIS_PRESSURE,
  INPUT_AXIS_XTILT,
  INPUT_AXIS_YTILT,
  INPUT_AXIS_WHEEL,
  INPUT_AXIS_DISTANCE,
  INPUT_AXIS_LAST
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::InputAxis> : public Glib::Value_Enum<Clutter::InputAxis>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var InputMode INPUT_MODE_MASTER
 *  A master, virtual device.
 * 
 *  @var InputMode INPUT_MODE_SLAVE
 *  A slave, physical device, attached to a master device.
 * 
 *  @var InputMode INPUT_MODE_FLOATING
 *  A slave, physical device, not attached to a master device.
 * 
 *  @enum InputMode
 * 
 * The mode for input devices available.
 * 
 * @newin{1,6}
 * @ingroup cluttermmEnums
 */
enum InputMode
{
  INPUT_MODE_MASTER,
  INPUT_MODE_SLAVE,
  INPUT_MODE_FLOATING
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::InputMode> : public Glib::Value_Enum<Clutter::InputMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var InputDeviceType POINTER_DEVICE
 *  A pointer device.
 * 
 *  @var InputDeviceType KEYBOARD_DEVICE
 *  A keyboard device.
 * 
 *  @var InputDeviceType EXTENSION_DEVICE
 *  A generic extension device.
 * 
 *  @var InputDeviceType JOYSTICK_DEVICE
 *  A joystick device.
 * 
 *  @var InputDeviceType TABLET_DEVICE
 *  A tablet device.
 * 
 *  @var InputDeviceType TOUCHPAD_DEVICE
 *  A touchpad device.
 * 
 *  @var InputDeviceType TOUCHSCREEN_DEVICE
 *  A touch screen device.
 * 
 *  @var InputDeviceType PEN_DEVICE
 *  A pen device.
 * 
 *  @var InputDeviceType ERASER_DEVICE
 *  An eraser device.
 * 
 *  @var InputDeviceType CURSOR_DEVICE
 *  A cursor device.
 * 
 *  @var InputDeviceType N_DEVICE_TYPES
 *  The number of device types.
 * 
 *  @enum InputDeviceType
 * 
 * The types of input devices available.
 * 
 * The Clutter::InputDeviceType enumeration can be extended at later
 * date; not every platform supports every input device type.
 * 
 * @newin{1,0}
 * @ingroup cluttermmEnums
 */
enum InputDeviceType
{
  POINTER_DEVICE,
  KEYBOARD_DEVICE,
  EXTENSION_DEVICE,
  JOYSTICK_DEVICE,
  TABLET_DEVICE,
  TOUCHPAD_DEVICE,
  TOUCHSCREEN_DEVICE,
  PEN_DEVICE,
  ERASER_DEVICE,
  CURSOR_DEVICE,
  N_DEVICE_TYPES
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::InputDeviceType> : public Glib::Value_Enum<Clutter::InputDeviceType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var ModifierType SHIFT_MASK
 *  Mask applied by the Shift key.
 * 
 *  @var ModifierType LOCK_MASK
 *  Mask applied by the Caps Lock key.
 * 
 *  @var ModifierType CONTROL_MASK
 *  Mask applied by the Control key.
 * 
 *  @var ModifierType MOD1_MASK
 *  Mask applied by the first Mod key.
 * 
 *  @var ModifierType MOD2_MASK
 *  Mask applied by the second Mod key.
 * 
 *  @var ModifierType MOD3_MASK
 *  Mask applied by the third Mod key.
 * 
 *  @var ModifierType MOD4_MASK
 *  Mask applied by the fourth Mod key.
 * 
 *  @var ModifierType MOD5_MASK
 *  Mask applied by the fifth Mod key.
 * 
 *  @var ModifierType BUTTON1_MASK
 *  Mask applied by the first pointer button.
 * 
 *  @var ModifierType BUTTON2_MASK
 *  Mask applied by the second pointer button.
 * 
 *  @var ModifierType BUTTON3_MASK
 *  Mask applied by the third pointer button.
 * 
 *  @var ModifierType BUTTON4_MASK
 *  Mask applied by the fourth pointer button.
 * 
 *  @var ModifierType BUTTON5_MASK
 *  Mask applied by the fifth pointer button.
 * 
 *  @var ModifierType SUPER_MASK
 *  Mask applied by the Super key.
 * 
 *  @var ModifierType HYPER_MASK
 *  Mask applied by the Hyper key.
 * 
 *  @var ModifierType META_MASK
 *  Mask applied by the Meta key.
 * 
 *  @var ModifierType RELEASE_MASK
 *  Mask applied during release.
 * 
 *  @var ModifierType MODIFIER_MASK
 *  A mask covering all modifier types.
 * 
 *  @enum ModifierType
 * 
 * Masks applied to a Clutter::Event by modifiers.
 * 
 * Note that Clutter may add internal values to events which include
 * reserved values such as Clutter::MODIFIER_RESERVED_13_MASK.  Your code
 * should preserve and ignore them.  You can use Clutter::MODIFIER_MASK to
 * remove all reserved values.
 * 
 * @newin{0,4}
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%ModifierType operator|(ModifierType, ModifierType)</tt><br>
 * <tt>%ModifierType operator&(ModifierType, ModifierType)</tt><br>
 * <tt>%ModifierType operator^(ModifierType, ModifierType)</tt><br>
 * <tt>%ModifierType operator~(ModifierType)</tt><br>
 * <tt>%ModifierType& operator|=(ModifierType&, ModifierType)</tt><br>
 * <tt>%ModifierType& operator&=(ModifierType&, ModifierType)</tt><br>
 * <tt>%ModifierType& operator^=(ModifierType&, ModifierType)</tt><br>
 */
enum ModifierType
{
  SHIFT_MASK = 1 << 0,
  LOCK_MASK = 1 << 1,
  CONTROL_MASK = 1 << 2,
  MOD1_MASK = 1 << 3,
  MOD2_MASK = 1 << 4,
  MOD3_MASK = 1 << 5,
  MOD4_MASK = 1 << 6,
  MOD5_MASK = 1 << 7,
  BUTTON1_MASK = 1 << 8,
  BUTTON2_MASK = 1 << 9,
  BUTTON3_MASK = 1 << 10,
  BUTTON4_MASK = 1 << 11,
  BUTTON5_MASK = 1 << 12,
  MODIFIER_RESERVED_13_MASK = 1 << 13,
  MODIFIER_RESERVED_14_MASK = 1 << 14,
  MODIFIER_RESERVED_15_MASK = 1 << 15,
  MODIFIER_RESERVED_16_MASK = 1 << 16,
  MODIFIER_RESERVED_17_MASK = 1 << 17,
  MODIFIER_RESERVED_18_MASK = 1 << 18,
  MODIFIER_RESERVED_19_MASK = 1 << 19,
  MODIFIER_RESERVED_20_MASK = 1 << 20,
  MODIFIER_RESERVED_21_MASK = 1 << 21,
  MODIFIER_RESERVED_22_MASK = 1 << 22,
  MODIFIER_RESERVED_23_MASK = 1 << 23,
  MODIFIER_RESERVED_24_MASK = 1 << 24,
  MODIFIER_RESERVED_25_MASK = 1 << 25,
  SUPER_MASK = 1 << 26,
  HYPER_MASK = 1 << 27,
  META_MASK = 1 << 28,
  MODIFIER_RESERVED_29_MASK = 1 << 29,
  RELEASE_MASK = 1 << 30,
  MODIFIER_MASK = 0x5c001fff
};

/** @ingroup cluttermmEnums */
inline ModifierType operator|(ModifierType lhs, ModifierType rhs)
  { return static_cast<ModifierType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ModifierType operator&(ModifierType lhs, ModifierType rhs)
  { return static_cast<ModifierType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ModifierType operator^(ModifierType lhs, ModifierType rhs)
  { return static_cast<ModifierType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ModifierType operator~(ModifierType flags)
  { return static_cast<ModifierType>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline ModifierType& operator|=(ModifierType& lhs, ModifierType rhs)
  { return (lhs = static_cast<ModifierType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ModifierType& operator&=(ModifierType& lhs, ModifierType rhs)
  { return (lhs = static_cast<ModifierType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ModifierType& operator^=(ModifierType& lhs, ModifierType rhs)
  { return (lhs = static_cast<ModifierType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ModifierType> : public Glib::Value_Flags<Clutter::ModifierType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Actor;
class Backend;
class Stage;
class DeviceManager;


class InputDevice : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef InputDevice CppObjectType;
  typedef InputDevice_Class CppClassType;
  typedef ClutterInputDevice BaseObjectType;
  typedef ClutterInputDeviceClass BaseClassType;

private:  friend class InputDevice_Class;
  static CppClassType inputdevice_class_;

private:
  // noncopyable
  InputDevice(const InputDevice&);
  InputDevice& operator=(const InputDevice&);

protected:
  explicit InputDevice(const Glib::ConstructParams& construct_params);
  explicit InputDevice(ClutterInputDevice* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~InputDevice();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterInputDevice*       gobj()       { return reinterpret_cast<ClutterInputDevice*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterInputDevice* gobj() const { return reinterpret_cast<ClutterInputDevice*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterInputDevice* gobj_copy();

private:

  
protected:
  InputDevice();

public:

  
  /** Retrieves the unique identifier of @a device
   * 
   * @newin{1,0}
   * @return The identifier of the device.
   */
  int get_device_id() const;

  //TODO: Wrap ClutterEventSequence? Where would the caller get it from?
  //Make the sequence const?
 

  /** Retrieves the latest coordinates of a pointer or touch point of
   *  @a device.
   * 
   * @newin{1,12}
   * @param sequence A Clutter::EventSequence, or <tt>0</tt> if
   * the device is not touch-based.
   * @param point Return location for the pointer
   * or touch point.
   * @return <tt>false</tt> if the device's sequence hasn't been found,
   * and <tt>true</tt> otherwise.
   */
  bool get_coords(ClutterEventSequence * sequence, Point& point) const;

  /// A get_coords() convenience overload.
  bool get_coords(Point& point) const;

  
  /** Retrieves the current modifiers state of the device, as seen
   * by the last event Clutter processed.
   * 
   * @newin{1,16}
   * @return The last known modifier state.
   */
  ModifierType get_modifier_state() const;
  
  /** Retrieves the type of @a device
   * 
   * @newin{1,0}
   * @return The type of the device.
   */
  InputDeviceType get_device_type() const;
  
  /** Retrieves the name of the @a device
   * 
   * @newin{1,2}
   * @return The name of the device, or <tt>0</tt>. The returned string
   * is owned by the Clutter::InputDevice and should never be modified
   * or freed.
   */
  Glib::ustring get_device_name() const;
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the latest coordinates of the pointer of @a device
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12: Use get_coords() instead.
   * @deprecated Use get_coords() instead.
   * @param x Return location for the X coordinate.
   * @param y Return location for the Y coordinate.
   */
  void get_device_coords(int & x, int & y) const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Retrieves the Clutter::InputMode of @a device.
   * 
   * @newin{1,6}
   * @return The device mode.
   */
  InputMode get_device_mode() const;
  
  /** Retrieves whether @a device has a pointer that follows the
   * device motion.
   * 
   * @newin{1,6}
   * @return <tt>true</tt> if the device has a cursor.
   */
  bool get_has_cursor() const;
  
  /** Enables or disables a Clutter::InputDevice.
   * 
   * Only devices with a Clutter::InputDevice::property_device_mode() property set
   * to Clutter::INPUT_MODE_SLAVE or Clutter::INPUT_MODE_FLOATING can
   * be disabled.
   * 
   * @newin{1,6}
   * @param enabled <tt>true</tt> to enable the @a device.
   */
  void set_enabled(bool enabled =  true);
  
  /** Retrieves whether @a device is enabled.
   * 
   * @newin{1,6}
   * @return <tt>true</tt> if the device is enabled.
   */
  bool get_enabled() const;

  
  /** Retrieves a pointer to the Clutter::InputDevice that has been
   * associated to @a device.
   * 
   * If the Clutter::InputDevice::property_device_mode() property of @a device is
   * set to Clutter::INPUT_MODE_MASTER, this function will return
   * <tt>0</tt>.
   * 
   * @newin{1,6}
   * @return A Clutter::InputDevice, or <tt>0</tt>.
   */
  Glib::RefPtr<InputDevice> get_associated_device();
  
  /** Retrieves a pointer to the Clutter::InputDevice that has been
   * associated to @a device.
   * 
   * If the Clutter::InputDevice::property_device_mode() property of @a device is
   * set to Clutter::INPUT_MODE_MASTER, this function will return
   * <tt>0</tt>.
   * 
   * @newin{1,6}
   * @return A Clutter::InputDevice, or <tt>0</tt>.
   */
  Glib::RefPtr<const InputDevice> get_associated_device() const;

  
  /** Translates a hardware keycode from a Clutter::KeyEvent to the
   * equivalent evdev keycode. Note that depending on the input backend
   * used by Clutter this function can fail if there is no obvious
   * mapping between the key codes. The hardware keycode can be taken
   * from the Clutter::KeyEvent.hardware_keycode member of Clutter::KeyEvent.
   * 
   * @newin{1,10}
   * @param hardware_keycode The hardware keycode from a Clutter::KeyEvent.
   * @param evdev_keycode The return location for the evdev keycode.
   * @return <tt>true</tt> if the conversion succeeded, <tt>false</tt> otherwise.
   */
  bool keycode_to_evdev(guint hardware_keycode, guint& evdev_keycode) const;
  
  /** Retrieves the number of keys registered for @a device.
   * 
   * @newin{1,6}
   * @return The number of registered keys.
   */
  bool get_n_keys() const;
  
  /** Sets the keyval and modifiers at the given @a index for @a device.
   * 
   * Clutter will use the keyval and modifiers set when filling out
   * an event coming from the same input device.
   * 
   * @newin{1,6}
   * @param index The index of the key.
   * @param keyval The keyval.
   * @param modifiers A bitmask of modifiers.
   */
  void set_key(guint index, guint keyval, ModifierType modifiers);

   
  /** Retrieves the key set using set_key()
   * 
   * @newin{1,6}
   * @param index The index of the key.
   * @param keyval Return location for the keyval at @a index.
   * @param modifiers Return location for the modifiers at @a index.
   * @return <tt>true</tt> if a key was set at the given index.
   */
  bool get_key(guint index, guint& keyval, ModifierType& modifiers) const;

  
  /** Retrieves the number of axes available on @a device.
   * 
   * @newin{1,6}
   * @return The number of axes on the device.
   */
  guint get_n_axes();
  
  /** Retrieves the type of axis on @a device at the given index.
   * 
   * @newin{1,6}
   * @param index The index of the axis.
   * @return The axis type.
   */
  InputAxis get_axis(guint index_);

  
  /** Retrieves the Clutter::Actor underneath the pointer of @a device
   * 
   * @newin{1,2}
   * @return A pointer to the Clutter::Actor or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_pointer_actor();
  
  /** Retrieves the Clutter::Actor underneath the pointer of @a device
   * 
   * @newin{1,2}
   * @return A pointer to the Clutter::Actor or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_pointer_actor() const;
  
  /** Retrieves the Clutter::Stage underneath the pointer of @a device
   * 
   * @newin{1,2}
   * @return A pointer to the Clutter::Stage or <tt>0</tt>.
   */
  Glib::RefPtr<Stage> get_pointer_stage();
  
  /** Retrieves the Clutter::Stage underneath the pointer of @a device
   * 
   * @newin{1,2}
   * @return A pointer to the Clutter::Stage or <tt>0</tt>.
   */
  Glib::RefPtr<const Stage> get_pointer_stage() const;

  
  /** Acquires a grab on @a actor for the given @a device.
   * 
   * Any event coming from @a device will be delivered to @a actor, bypassing
   * the usual event delivery mechanism, until the grab is released by
   * calling ungrab().
   * 
   * The grab is client-side: even if the windowing system used by the Clutter
   * backend has the concept of "device grabs", Clutter will not use them.
   * 
   * Only Clutter::InputDevice of types Clutter::POINTER_DEVICE and
   * Clutter::KEYBOARD_DEVICE can hold a grab.
   * 
   * @newin{1,10}
   * @param actor A Clutter::Actor.
   */
  void grab(const Glib::RefPtr<const Actor>& actor);
  
  /** Releases the grab on the @a device, if one is in place.
   * 
   * @newin{1,10}
   */
  void ungrab();

  //TODO: _WRAP_METHOD(void update_from_event(const Glib::RefPtr<Event>& event, bool update_stage), clutter_input_device_update_from_event)

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The backend instance.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Backend> > property_backend() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The device manager instance.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DeviceManager> > property_device_manager() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The mode of the device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputMode > property_device_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of the device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputDeviceType > property_device_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the device is enabled.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_enabled() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the device is enabled.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_enabled() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the device has a cursor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_cursor() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Unique identifier of the device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of axes on the device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_n_axes() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::InputDevice
   */
  Glib::RefPtr<Clutter::InputDevice> wrap(ClutterInputDevice* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_INPUT_DEVICE_H */

