// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <cluttermm/script.h>
#include <cluttermm/private/script_p.h>


/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>
#include <glibmm/vectorutils.h>

namespace Clutter
{

#ifdef GLIBMM_EXCEPTIONS_ENABLED
guint Script::load_from_data(const Glib::ustring& data)
#else
guint Script::load_from_data(const Glib::ustring& data, std::auto_ptr<Glib::Error>& error)
#endif
{
  GError* gerror = 0;
  guint result = clutter_script_load_from_data(gobj(), data.c_str(), data.bytes(), &gerror);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  return result;
}

void Script::add_search_paths(const std::vector<std::string>& paths)
{
  clutter_script_add_search_paths(gobj(),
    Glib::ArrayHandler<std::string>::vector_to_array(paths).data(), paths.size());
}

std::vector<Glib::RefPtr<Glib::Object> > Script::list_objects()
{
  GList* objectList = clutter_script_list_objects(gobj());

  const guint objectCount = g_list_length(objectList);
  std::vector<Glib::RefPtr<Glib::Object> > objectVec;
  objectVec.reserve(objectCount);

  for(GList* objectNode = objectList; objectNode->next; objectNode = objectList->next)
  {
    objectVec.push_back(Glib::wrap(static_cast<GObject*>(objectNode->data), true));
  }

  return objectVec;
}

std::vector<Glib::RefPtr<const Glib::Object> > Script::list_objects() const
{
  GList* objectList = clutter_script_list_objects(const_cast<ClutterScript*>(gobj()));

  const guint objectCount = g_list_length(objectList);
  std::vector<Glib::RefPtr<const Glib::Object> > objectVec;
  objectVec.reserve(objectCount);

  for(GList* objectNode = objectList; objectNode->next; objectNode = objectList->next)
  {
    objectVec.push_back(Glib::wrap(static_cast<GObject*>(objectNode->data), true));
  }

  return objectVec;
}

GObject* Script::get_cobject(const Glib::ustring& name)
{
  GObject *cobject = clutter_script_get_object (gobj(), name.c_str());
  if(!cobject)
  {
    g_critical("cluttermm: object `%s' not found in ClutterScript file.", name.c_str());
    return 0;
  }

  return cobject;
}

Glib::RefPtr<Glib::Object> Script::get_object_checked(const Glib::ustring& name, GType type)
{
  // Get the widget from the ClutterScript JSON file.
  GObject *cobject = get_cobject(name);
  Glib::RefPtr<Glib::Object> object;

  if(!cobject)
  {
    g_critical("cluttermm: Glib::Object: object `%s' was not found in the ClutterScript file, or the specified part of it.",
      name.c_str());
    return object;
  }

  // Check if it has the correct type.
  if(!g_type_is_a(G_OBJECT_TYPE(cobject), type))
  {
    g_critical("cluttermm: object `%s' (in ClutterScript file) is of type `%s' but `%s' was expected",
               name.c_str(), G_OBJECT_TYPE_NAME(cobject), g_type_name(type));
    return object;
  }

  object = Glib::wrap (cobject, true /* take ref */);
  return object;
}

#ifdef GLIBMM_VFUNCS_ENABLED
// Custom coded so that we can custom-code the vfunc in the ClutterScript class.
// This is marginally better than modifying gtkmmproc to allow this.
GType Script_Class::get_type_from_name_vfunc_callback(ClutterScript* self, const char* type_name)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*) self));

  if(obj)
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      return obj->get_type_from_name_vfunc(Glib::convert_const_gchar_ptr_to_ustring(type_name));
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
    );

    if(base && base->get_type_from_name)
      return (*base->get_type_from_name)(self, type_name);
  }

  return 0;
}
#endif // GLIBMM_VFUNCS_ENABLED

GType Script::get_type_from_name_vfunc(const Glib::ustring& type_name)
{
  // See if there is a gtkmm version of the gclass:
  Glib::ustring classname_prefixed ("gtkmm__"); // gtkmm uses a prefix
  classname_prefixed += type_name;

  GType gtype = g_type_from_name(classname_prefixed.c_str());

  if(gtype == G_TYPE_INVALID) // if it's not a registered typename
  {
    // There's no gtkmm derived type, so just use the normal one.
    gtype = g_type_from_name(type_name.c_str());
  }

  return gtype;
}

} //namespace Clutter


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Clutter::Script> wrap(ClutterScript* object, bool take_copy)
{
  return Glib::RefPtr<Clutter::Script>( dynamic_cast<Clutter::Script*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Clutter
{


/* The *_Class implementation: */

const Glib::Class& Script_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Script_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(clutter_script_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Script_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->get_type_from_name = &get_type_from_name_vfunc_callback;
  
}


Glib::ObjectBase* Script_Class::wrap_new(GObject* object)
{
  return new Script((ClutterScript*)object);
}


/* The implementation: */

ClutterScript* Script::gobj_copy()
{
  reference();
  return gobj();
}

Script::Script(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Script::Script(ClutterScript* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Script::~Script()
{}


Script::CppClassType Script::script_class_; // initialize static member

GType Script::get_type()
{
  return script_class_.init().get_type();
}


GType Script::get_base_type()
{
  return clutter_script_get_type();
}


Script::Script()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(script_class_.init()))
{
  

}

Glib::RefPtr<Script> Script::create()
{
  return Glib::RefPtr<Script>( new Script() );
}

guint Script::load_from_file(const std::string& filename)
{
  GError* gerror = 0;
  guint retvalue = clutter_script_load_from_file(gobj(), filename.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

guint Script::load_from_resource(const std::string& resource_path)
{
  GError* gerror = 0;
  guint retvalue = clutter_script_load_from_resource(gobj(), resource_path.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Glib::Object> Script::get_object(const Glib::ustring& name)
{
  Glib::RefPtr<Glib::Object> retvalue = Glib::wrap(clutter_script_get_object(gobj(), name.c_str()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Glib::Object> Script::get_object(const Glib::ustring& name) const
{
  return const_cast<Script*>(this)->get_object(name);
}

std::string Script::lookup_filename(const std::string& filename)
{
  return Glib::convert_return_gchar_ptr_to_stdstring(clutter_script_lookup_filename(gobj(), filename.c_str()));
}

void Script::unmerge_object(guint merge_id)
{
  clutter_script_unmerge_objects(gobj(), merge_id);
}

void Script::ensure_objects()
{
  clutter_script_ensure_objects(gobj());
}

void Script::set_translation_domain(const Glib::ustring& domain)
{
  clutter_script_set_translation_domain(gobj(), domain.c_str());
}

Glib::ustring Script::get_translation_domain() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(clutter_script_get_translation_domain(const_cast<ClutterScript*>(gobj())));
}

std::string Script::get_script_id(const Glib::RefPtr<const Glib::Object>& object)
{
  return Glib::convert_const_gchar_ptr_to_stdstring(clutter_get_script_id(const_cast<GObject*>(Glib::unwrap<Glib::Object>(object))));
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< std::string > Script::property_filename() const
{
  return Glib::PropertyProxy_ReadOnly< std::string >(this, "filename");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< bool > Script::property_filename_set() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "filename-set");
}
#endif //GLIBMM_PROPERTIES_ENABLED


} // namespace Clutter


