// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_SCROLL_ACTOR_H
#define _CLUTTERMM_SCROLL_ACTOR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2014 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/actor.h>
#include <cluttermm/types.h>
#include <cluttermm/container.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterScrollActor ClutterScrollActor;
typedef struct _ClutterScrollActorClass ClutterScrollActorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class ScrollActor_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var ScrollMode SCROLL_NONE
 *  Ignore scrolling.
 * 
 *  @var ScrollMode SCROLL_HORIZONTALLY
 *  Scroll only horizontally.
 * 
 *  @var ScrollMode SCROLL_VERTICALLY
 *  Scroll only vertically.
 * 
 *  @var ScrollMode SCROLL_BOTH
 *  Scroll in both directions.
 * 
 *  @enum ScrollMode
 * 
 * Scroll modes.
 * 
 * @newin{1,12}
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%ScrollMode operator|(ScrollMode, ScrollMode)</tt><br>
 * <tt>%ScrollMode operator&(ScrollMode, ScrollMode)</tt><br>
 * <tt>%ScrollMode operator^(ScrollMode, ScrollMode)</tt><br>
 * <tt>%ScrollMode operator~(ScrollMode)</tt><br>
 * <tt>%ScrollMode& operator|=(ScrollMode&, ScrollMode)</tt><br>
 * <tt>%ScrollMode& operator&=(ScrollMode&, ScrollMode)</tt><br>
 * <tt>%ScrollMode& operator^=(ScrollMode&, ScrollMode)</tt><br>
 */
enum ScrollMode
{
  SCROLL_NONE = 0x0,
  SCROLL_HORIZONTALLY = 1 << 0,
  SCROLL_VERTICALLY = 1 << 1,
  SCROLL_BOTH = 0x3
};

/** @ingroup cluttermmEnums */
inline ScrollMode operator|(ScrollMode lhs, ScrollMode rhs)
  { return static_cast<ScrollMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ScrollMode operator&(ScrollMode lhs, ScrollMode rhs)
  { return static_cast<ScrollMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ScrollMode operator^(ScrollMode lhs, ScrollMode rhs)
  { return static_cast<ScrollMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ScrollMode operator~(ScrollMode flags)
  { return static_cast<ScrollMode>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline ScrollMode& operator|=(ScrollMode& lhs, ScrollMode rhs)
  { return (lhs = static_cast<ScrollMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ScrollMode& operator&=(ScrollMode& lhs, ScrollMode rhs)
  { return (lhs = static_cast<ScrollMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ScrollMode& operator^=(ScrollMode& lhs, ScrollMode rhs)
  { return (lhs = static_cast<ScrollMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ScrollMode> : public Glib::Value_Flags<Clutter::ScrollMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class ScrollActor :
  public Actor,
  public Container
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ScrollActor CppObjectType;
  typedef ScrollActor_Class CppClassType;
  typedef ClutterScrollActor BaseObjectType;
  typedef ClutterScrollActorClass BaseClassType;

private:  friend class ScrollActor_Class;
  static CppClassType scrollactor_class_;

private:
  // noncopyable
  ScrollActor(const ScrollActor&);
  ScrollActor& operator=(const ScrollActor&);

protected:
  explicit ScrollActor(const Glib::ConstructParams& construct_params);
  explicit ScrollActor(ClutterScrollActor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ScrollActor();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterScrollActor*       gobj()       { return reinterpret_cast<ClutterScrollActor*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterScrollActor* gobj() const { return reinterpret_cast<ClutterScrollActor*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterScrollActor* gobj_copy();

private:

  
  //TODO: _IMPLEMENTS_INTERFACE(Atk::Implementor)

protected:
  ScrollActor();

public:
  
  static Glib::RefPtr<ScrollActor> create();


  /** Sets the Clutter::ScrollActor::property_scroll_mode() property.
   * 
   * @newin{1,12}
   * @param mode A Clutter::ScrollMode.
   */
  void set_scroll_mode(ScrollMode mode);
  
  /** Retrieves the Clutter::ScrollActor::property_scroll_mode() property
   * 
   * @newin{1,12}
   * @return The scrolling mode.
   */
  ScrollMode get_scroll_mode() const;
  
  /** Scrolls the contents of @a actor so that @a point is the new origin
   * of the visible area.
   * 
   * The coordinates of @a point must be relative to the @a actor.
   * 
   * This function will use the currently set easing state of the @a actor
   * to transition from the current scroll origin to the new one.
   * 
   * @newin{1,12}
   * @param point A Clutter::Point.
   */
  void scroll_to_point(const Point& point);
  
  /** Scrolls @a actor so that @a rect is in the visible portion.
   * 
   * @newin{1,12}
   * @param rect A Clutter::Rect.
   */
  void scroll_to_rect(const Rect& rect);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The scrolling direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ScrollMode > property_scroll_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The scrolling direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ScrollMode > property_scroll_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::ScrollActor
   */
  Glib::RefPtr<Clutter::ScrollActor> wrap(ClutterScrollActor* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_SCROLL_ACTOR_H */

