// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_STAGE_H
#define _CLUTTERMM_STAGE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/group.h>
#include <cluttermm/color.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterStage ClutterStage;
typedef struct _ClutterStageClass ClutterStageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Stage_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var PickMode PICK_NONE
 *  Do not paint any actor.
 * 
 *  @var PickMode PICK_REACTIVE
 *  Paint only the reactive actors.
 * 
 *  @var PickMode PICK_ALL
 *  Paint all actors.
 * 
 *  @enum PickMode
 * 
 * Controls the paint cycle of the scene graph when in pick mode
 * 
 * @newin{1,0}
 * @ingroup cluttermmEnums
 */
enum PickMode
{
  PICK_NONE,
  PICK_REACTIVE,
  PICK_ALL
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::PickMode> : public Glib::Value_Enum<Clutter::PickMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


/**
 * @deprecated Fog settings are ignored.
 */
typedef ClutterFog Fog;

class Perspective
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Perspective CppObjectType;
  typedef ClutterPerspective BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  Perspective();

  explicit Perspective(const ClutterPerspective* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterPerspective*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterPerspective* gobj() const { return &gobject_; }

protected:
  ClutterPerspective gobject_;

private:
  
public:
  Perspective(float fovy, float aspect, float z_near, float z_far);

   float get_fovy() const;
    void set_fovy(const float& value);
    float get_aspect() const;
    void set_aspect(const float& value);
    float get_z_near() const;
    void set_z_near(const float& value);
    float get_z_far() const;
    void set_z_far(const float& value);
 

};

//TODO: Wrap clutter_feature_available(), as mentioned in the class comment.
  class Actor;

/** This is a top level 'window' on which child actors are placed and manipulated.
 *
 * Clutter creates a default stage upon initialization, which can be retrieved using Stage::get_default(). Clutter always
 * provides the default stage, unless the backend is unable to create one. The stage returned by Stage::get_default() is
 * guaranteed to always be the same.
 *
 * Backends might provide support for multiple stages. The support for this feature can be checked at run-time using the
 * clutter_feature_available() function and the CLUTTER_FEATURE_STAGE_MULTIPLE flag. If the backend used supports multiple
 * stages, new Clutter::Stage instances can be created.
 *
 * Clutter::Stage is a proxy actor, wrapping the backend-specific implementation of the windowing system. It is possible
 * to subclass ClutterStage, as long as every overridden virtual function calls the implementation in the base class.
 */

class Stage :
  public Group
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Stage CppObjectType;
  typedef Stage_Class CppClassType;
  typedef ClutterStage BaseObjectType;
  typedef ClutterStageClass BaseClassType;

private:  friend class Stage_Class;
  static CppClassType stage_class_;

private:
  // noncopyable
  Stage(const Stage&);
  Stage& operator=(const Stage&);

protected:
  explicit Stage(const Glib::ConstructParams& construct_params);
  explicit Stage(ClutterStage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Stage();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterStage*       gobj()       { return reinterpret_cast<ClutterStage*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterStage* gobj() const { return reinterpret_cast<ClutterStage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterStage* gobj_copy();

private:

  // Implements Container and Scriptable via Group.

protected:

  /**
   * Creates a new stage. Every Clutter::Actor must be placed on a stage, and the
   * stage first created automatically occupies the window generated when
   *  Clutter::main() is run.
   *
   * Clutter can support more than one stage at once; however the ability to
   * support multiple stages depends on the current backend. Use
   * feature_available() and CLUTTER::FEATURE_STAGE_MULTIPLE to check at runtime
   * whether a backend supports multiple stages.
   *
   * @return a new stage.
   *
   * @newin{0.8}
   */
  Stage();

public:
  
  static Glib::RefPtr<Stage> create();

 
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves a Clutter::Stage singleton.
   * 
   * This function is not as useful as it sounds, and will most likely
   * by deprecated in the future. Application code should only create
   * a Clutter::Stage instance using new(), and manage the
   * lifetime of the stage manually.
   * 
   * The default stage singleton has a platform-specific behaviour: on
   * platforms without the Clutter::FEATURE_STAGE_MULTIPLE feature flag
   * set, the first Clutter::Stage instance will also be set to be the
   * default stage instance, and this function will always return a
   * pointer to it.
   * 
   * On platforms with the Clutter::FEATURE_STAGE_MULTIPLE feature flag
   * set, the default stage will be created by the first call to this
   * function, and every following call will return the same pointer to
   * it.
   * 
   * Deprecated: 1.10: Use new() instead.
   * @deprecated Use Stage::create() instead
   * @return The main
   * Clutter::Stage. You should never destroy or unref the returned
   * actor.
   */
  static Glib::RefPtr<Stage> get_default();
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the stage color.
   * 
   * Deprecated: 1.10: Use Clutter::Actor::set_background_color() instead.
   * @deprecated Use Actor::set_background_color() instead.
   * @param color A Clutter::Color.
   */
  void set_color(const Color& color);
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Retrieves the stage color.
   * 
   * Deprecated: 1.10: Use Clutter::Actor::get_background_color() instead.
   * @param color Return location for a Clutter::Color.
   */

  Color get_color() const;

 
  /** Sets the stage perspective. Using this function is not recommended
   * because it will disable Clutter's attempts to generate an
   * appropriate perspective based on the size of the stage.
   * @param perspective A Clutter::Perspective.
   */
  void set_perspective(const Perspective& prespective);
  
  /** Retrieves the stage perspective.
   * @param perspective Return location for a
   * Clutter::Perspective.
   */
  void get_perspective(Perspective& prespective);
  
  /** Asks to place the stage window in the fullscreen or unfullscreen
   * states.
   * 
   *  ( Note that you shouldn't assume the window is definitely full screen
   * afterward, because other entities (e.g. the user or window manager)
   * could unfullscreen it again, and not all window managers honor
   * requests to fullscreen windows.
   * 
   * If you want to receive notification of the fullscreen state you
   * should either use the Clutter::Stage::signal_fullscreen() and
   * Clutter::Stage::signal_unfullscreen() signals, or use the notify signal
   * for the Clutter::Stage::property_fullscreen_set() property
   * 
   * @newin{1,0}
   * @param fullscreen <tt>true</tt> to to set the stage fullscreen.
   */
  void set_fullscreen(bool fullscreen =  true);
  
  /** Retrieves whether the stage is full screen or not
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the stage is full screen.
   */
  bool get_fullscreen() const;
  
  /** Shows the cursor on the stage window
   */
  void show_cursor();
  
  /** Makes the cursor invisible on the stage window
   * 
   * @newin{0,4}
   */
  void hide_cursor();
  
  /** Gets the stage title.
   * 
   * @newin{0,4}
   * @return Pointer to the title string for the stage. The
   * returned string is owned by the actor and should not
   * be modified or freed.
   */
  Glib::ustring get_title() const;
  
  /** Sets the stage title.
   * 
   * @newin{0,4}
   * @param title A utf8 string for the stage windows title.
   */
  void set_title(const Glib::ustring& title);
  
  /** Sets if the stage is resizable by user interaction (e.g.\ via
   * window manager controls)
   * 
   * @newin{0,4}
   * @param resizable Whether the stage should be user resizable.
   */
  void set_user_resizable(bool value =  true);
  
  /** Retrieves the value set with set_user_resizable().
   * 
   * @newin{0,4}
   * @return <tt>true</tt> if the stage is resizable by the user.
   */
  bool get_user_resizable() const;
  
  /** Sets whether the @a stage should accept the key focus when shown.
   * 
   * This function should be called before showing @a stage using
   * Clutter::Actor::show().
   * 
   * @newin{1,6}
   * @param accept_focus <tt>true</tt> to accept focus on show.
   */
  void set_accept_focus(bool value =  true);
  
  /** Retrieves the value set with set_accept_focus().
   * 
   * @newin{1,6}
   * @return <tt>true</tt> if the Clutter::Stage should accept focus, and <tt>false</tt>
   * otherwise.
   */
  bool get_accept_focus() const;

  
  /** Checks the scene at the coordinates @a x and @a y and returns a pointer
   * to the Clutter::Actor at those coordinates.
   * 
   * By using @a pick_mode it is possible to control which actors will be
   * painted and thus available.
   * @param pick_mode How the scene graph should be painted.
   * @param x X coordinate to check.
   * @param y Y coordinate to check.
   * @return The actor at the specified coordinates,
   * if any.
   */
  Glib::RefPtr<Actor> get_actor_at_pos(PickMode pick_mode, int x, int y);
  
  /** Checks the scene at the coordinates @a x and @a y and returns a pointer
   * to the Clutter::Actor at those coordinates.
   * 
   * By using @a pick_mode it is possible to control which actors will be
   * painted and thus available.
   * @param pick_mode How the scene graph should be painted.
   * @param x X coordinate to check.
   * @param y Y coordinate to check.
   * @return The actor at the specified coordinates,
   * if any.
   */
  Glib::RefPtr<const Actor> get_actor_at_pos(PickMode pick_mode, int x, int y) const;

  
  /** Retrieves the actor that is currently under key focus.
   * 
   * @newin{0,6}
   * @return The actor with key focus, or the stage.
   */
  Glib::RefPtr<Actor> get_key_focus();
  
  /** Retrieves the actor that is currently under key focus.
   * 
   * @newin{0,6}
   * @return The actor with key focus, or the stage.
   */
  Glib::RefPtr<const Actor> get_key_focus() const;

  
  /** Sets the key focus on @a actor. An actor with key focus will receive
   * all the key events. If @a actor is <tt>0</tt>, the stage will receive
   * focus.
   * 
   * @newin{0,6}
   * @param actor The actor to set key focus to, or <tt>0</tt>.
   */
  void set_key_focus(const Glib::RefPtr<Actor>& actor);
  void set_key_focus();

  // TODO: Should we rather wrap this as std::string, or
  // as std::vector<unsigned char>, or Glib::ArrayHandle<guchar>?
  
  /** Makes a screenshot of the stage in RGBA 8bit data, returns a
   * linear buffer with @a width * 4 as rowstride.
   * 
   * The alpha data contained in the returned buffer is driver-dependent,
   * and not guaranteed to hold any sensible value.
   * @param x X coordinate of the first pixel that is read from stage.
   * @param y Y coordinate of the first pixel that is read from stage.
   * @param width Width dimention of pixels to be read, or -1 for the
   * entire stage width.
   * @param height Height dimention of pixels to be read, or -1 for the
   * entire stage height.
   * @return A pointer to newly allocated memory with the buffer
   * or <tt>0</tt> if the read failed. Use Glib::free() on the returned data
   * to release the resources it has allocated.
   */
  guchar* read_pixels(int x, int y, int width, int height) const;
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Gets whether the depth cueing effect is enabled on @a stage.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.10: This function will always return <tt>false</tt>
   * @deprecated This method will always return false.
   * @return <tt>true</tt> if the depth cueing effect is enabled.
   */
  bool get_use_fog() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets whether the depth cueing effect on the stage should be enabled
   * or not.
   * 
   * Depth cueing is a 3D effect that makes actors farther away from the
   * viewing point less opaque, by fading them with the stage color.
   * 
   * The parameters of the GL fog used can be changed using the
   * set_fog() function.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.10: Calling this function produces no visible effect
   * @deprecated This method has no visible effect.
   * @param fog <tt>true</tt> for enabling the depth cueing effect.
   */
  void set_use_fog(bool fog =  true);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the fog (also known as "depth cueing") settings for the @a stage.
   * 
   * A Clutter::Stage will only use a linear fog progression, which
   * depends solely on the distance from the viewer. The cogl_set_fog()
   * function in COGL exposes more of the underlying implementation,
   * and allows changing the for progression function. It can be directly
   * used by disabling the Clutter::Stage::property_use_fog() property and connecting
   * a signal handler to the Clutter::Actor::signal_paint() signal on the @a stage,
   * like:
   * 
   * 
   * [C example ellipted]
   * 
   * The paint signal handler will call cogl_set_fog() with the
   * desired settings:
   * 
   * 
   * [C example ellipted]
   * 
   * <note>The fogging functions only work correctly when the visible actors use
   * unmultiplied alpha colors. By default Cogl will premultiply textures and
   * cogl_set_source_color() will premultiply colors, so unless you explicitly
   * load your textures requesting an unmultiplied internal format and use
   * cogl_material_set_color() you can only use fogging with fully opaque actors.
   * Support for premultiplied colors will improve in the future when we can
   * depend on fragment shaders.</note>
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.10: Fog settings are ignored.
   * @deprecated Fog settings are ignored.
   * @param fog A Clutter::Fog structure.
   */
  void set_fog(const Fog& fog);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the current depth cueing settings from the stage.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.10: This function will always return the default
   * values of Clutter::Fog
   * @deprecated This function will always return default values.
   * @param fog Return location for a Clutter::Fog structure.
   */
  void get_fog(Fog& fog) const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** This function is used to emit an event on the main stage.
   * 
   * You should rarely need to use this function, except for
   * synthetised events.
   * 
   * @newin{0,4}
   * @param event A Clutter::Event.
   * @return The return value from the signal emission.
   */
  void stage_event(Event* event);
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Checks if @a stage is the default stage, or an instance created using
   * new() but internally using the same implementation.
   * 
   * @newin{0,8}
   * 
   * Deprecated: 1.10: Track the stage pointer inside your application
   * code, or use Clutter::Actor::get_stage() to retrieve the stage for
   * a given actor.
   * @deprecated Track the stage pointer inside your application code
   * @return <tt>true</tt> if the passed stage is the default one.
   */
  bool is_default() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** This function essentially makes sure the right GL context is
   * current for the passed stage. It is not intended to
   * be used by applications.
   * 
   * @newin{0,8}
   */
  void ensure_current();
  
  /** Ensures that the GL viewport is updated with the current
   * stage window size.
   * 
   * This function will queue a redraw of @a stage.
   * 
   * This function should not be called by applications; it is used
   * when embedding a Clutter::Stage into a toolkit with another
   * windowing system, like GTK+.
   * 
   * @newin{1,0}
   */
  void ensure_viewport();

  
  /** Ensures that @a stage is redrawn
   * 
   * This function should not be called by applications: it is
   * used when embedding a Clutter::Stage into a toolkit with
   * another windowing system, like GTK+.
   * 
   * @newin{1,0}
   */
  void ensure_redraw();

  
  /** Sets whether motion events received between redraws should
   * be throttled or not. If motion events are throttled, those
   * events received by the windowing system between redraws will
   * be compressed so that only the last event will be propagated
   * to the @a stage and its actors.
   * 
   * This function should only be used if you want to have all
   * the motion events delivered to your application code.
   * 
   * @newin{1,0}
   * @param throttle <tt>true</tt> to throttle motion events.
   */
  void set_throttle_motion_events(bool throttle =  true);
  
  /** Retrieves the value set with set_throttle_motion_events()
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the motion events are being throttled,
   * and <tt>false</tt> otherwise.
   */
  bool get_throttle_motion_events() const;

  
  /** Sets whether the @a stage should honour the Clutter::Actor::property_opacity() and
   * the alpha channel of the Clutter::Stage::property_color()
   * 
   * @newin{1,2}
   * @param use_alpha Whether the stage should honour the opacity or the
   * alpha channel of the stage color.
   */
  void set_use_alpha(bool use_alpha =  true);
  
  /** Retrieves the value set using set_use_alpha()
   * 
   * @newin{1,2}
   * @return <tt>true</tt> if the stage should honour the opacity and the
   * alpha channel of the stage color.
   */
  bool get_use_alpha() const;

  
  /** Sets the minimum size for a stage window, if the default backend
   * uses Clutter::Stage inside a window
   * 
   * This is a convenience function, and it is equivalent to setting the
   * Clutter::Actor::property_min_width() and Clutter::Actor::property_min_height() on @a stage
   * 
   * If the current size of @a stage is smaller than the minimum size, the
   *  @a stage will be resized to the new @a width and @a height
   * 
   * This function has no effect if @a stage is fullscreen
   * 
   * @newin{1,2}
   * @param width Width, in pixels.
   * @param height Height, in pixels.
   */
  void set_minimum_size(guint width, guint height);
  
  /** Retrieves the minimum size for a stage window as set using
   * set_minimum_size().
   * 
   * The returned size may not correspond to the actual minimum size and
   * it is specific to the Clutter::Stage implementation inside the
   * Clutter backend
   * 
   * @newin{1,2}
   * @param width Return location for the minimum width, in pixels,
   * or <tt>0</tt>.
   * @param height Return location for the minimum height, in pixels,
   * or <tt>0</tt>.
   */
  void get_minimum_size(guint& width, guint& height);

  /**
  * Returns the minimum size for the stage.  The Point contains the x_minimum and y minimum.
  *
  * @return a point with the minimum sizes set as its parameters.
  */
  Point get_minimum_size() const;

  
  /** Sets whether the @a stage should clear itself at the beginning
   * of each paint cycle or not.
   * 
   * Clearing the Clutter::Stage can be a costly operation, especially
   * if the stage is always covered - for instance, in a full-screen
   * video player or in a game with a background texture.
   * 
   * <note>This setting is a hint; Clutter might discard this
   * hint depending on its internal state.</note>
   * 
   * <warning>If parts of the stage are visible and you disable
   * clearing you might end up with visual artifacts while painting the
   * contents of the stage.</warning>
   * 
   * @newin{1,4}
   * @param no_clear <tt>true</tt> if the @a stage should not clear itself on every
   * repaint cycle.
   */
  void set_no_clear_hint(bool no_clear =  true);
  
  /** Retrieves the hint set with set_no_clear_hint()
   * 
   * @newin{1,4}
   * @return <tt>true</tt> if the stage should not clear itself on every paint
   * cycle, and <tt>false</tt> otherwise.
   */
  bool get_no_clear_hint() const;
  //TODO: wrap
  
  
  /** Sets whether per-actor motion events (and relative crossing
   * events) should be disabled or not.
   * 
   * The default is <tt>true</tt>.
   * 
   * If @a enable is <tt>false</tt> the following events will not be delivered
   * to the actors children of @a stage.
   * 
   * - Clutter::Actor::signal_motion_event()
   * - Clutter::Actor::signal_enter_event()
   * - Clutter::Actor::signal_leave_event()
   * 
   * The events will still be delivered to the Clutter::Stage.
   * 
   * The main side effect of this function is that disabling the motion
   * events will disable picking to detect the Clutter::Actor underneath
   * the pointer for each motion event. This is useful, for instance,
   * when dragging a Clutter::Actor across the @a stage: the actor underneath
   * the pointer is not going to change, so it's meaningless to perform
   * a pick.
   * 
   * @newin{1,8}
   * @param enabled <tt>true</tt> to enable the motion events delivery, and <tt>false</tt>
   * otherwise.
   */
  void set_motion_events_enabled(bool enabled =  true);
  
  /** Retrieves the value set using set_motion_events_enabled().
   * 
   * @newin{1,8}
   * @return <tt>true</tt> if the per-actor motion event delivery is enabled
   * and <tt>false</tt> otherwise.
   */
  bool get_motion_events_enabled() const;
  

  //signals:

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%fullscreen()</tt>
   *
   * The signal_fullscreen() signal is emitted when the stage is made fullscreen.
   * 
   * @newin{0,6}
   */

  Glib::SignalProxy0< void > signal_fullscreen();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%unfullscreen()</tt>
   *
   * The signal_unfullscreen() signal is emitted when the stage leaves a fullscreen
   * state.
   * 
   * @newin{0,6}
   */

  Glib::SignalProxy0< void > signal_unfullscreen();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%activate()</tt>
   *
   * The signal_activate() signal is emitted when the stage receives key focus
   * from the underlying window system.
   * 
   * @newin{0,6}
   */

  Glib::SignalProxy0< void > signal_activate();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%deactivate()</tt>
   *
   * The signal_activate() signal is emitted when the stage loses key focus
   * from the underlying window system.
   * 
   * @newin{0,6}
   */

  Glib::SignalProxy0< void > signal_deactivate();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%delete_event(ClutterEvent * event)</tt>
   *
   * The signal_delete_event() signal is emitted when the user closes a
   * Clutter::Stage window using the window controls.
   * 
   * Clutter by default will call clutter_main_quit() if @a stage is
   * the default stage, and Clutter::Actor::destroy() for any other
   * stage.
   * 
   * It is possible to override the default behaviour by connecting
   * a new handler and returning <tt>true</tt> there.
   * 
   * <note>This signal is emitted only on Clutter backends that
   * embed Clutter::Stage in native windows. It is not emitted for
   * backends that use a static frame buffer.</note>
   * 
   * @newin{1,2}
   * @param event A Clutter::Event of type Clutter::DELETE.
   */

  Glib::SignalProxy1< bool,ClutterEvent * > signal_delete_event();


  //There are no vfuncs.

  //properties:
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage should accept focus on show.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_accept_focus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage should accept focus on show.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_accept_focus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The color of the stage.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Color > property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The color of the stage.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Color > property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
// deprecated; use background-color.
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the mouse pointer is visible on the main stage.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_cursor_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the mouse pointer is visible on the main stage.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_cursor_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage is fullscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_fullscreen_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage should clear its contents.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_no_clear_hint() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage should clear its contents.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_no_clear_hint() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage should be rendered offscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_offscreen() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage should be rendered offscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_offscreen() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
 //deprecated, does not do anything.
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Perspective projection parameters.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Perspective > property_perspective() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Perspective projection parameters.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Perspective > property_perspective() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Stage Title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Stage Title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable depth cueing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_fog() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable depth cueing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_fog() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
 //deprecated, does not do anything.
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage is able to be resized via user interaction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_user_resizable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage is able to be resized via user interaction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_user_resizable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Settings for the depth cueing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Fog > property_fog() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Settings for the depth cueing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Fog > property_fog() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
 //deprecated, does not do anything.
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to honour the alpha component of the stage color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_alpha() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to honour the alpha component of the stage color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_alpha() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The currently key focused actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Actor> > property_key_focus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The currently key focused actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Actor> > property_key_focus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  // From the Clutter Docs:
  // Applications should call clutter_actor_queue_redraw and not this function.
  //_WRAP_METHOD(void queue_redraw(), clutter_stage_queue_redraw)
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_fullscreen().
  virtual void on_fullscreen();
  /// This is a default handler for the signal signal_unfullscreen().
  virtual void on_unfullscreen();
  /// This is a default handler for the signal signal_activate().
  virtual void on_activate();
  /// This is a default handler for the signal signal_deactivate().
  virtual void on_deactivate();
  /// This is a default handler for the signal signal_delete_event().
  virtual bool on_delete_event(ClutterEvent * event);


};

} // namespace Clutter

//vim: ts=2,sw=2


namespace Glib
{

/** @relates Clutter::Perspective
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Perspective& wrap(ClutterPerspective* object);

/** @relates Clutter::Perspective
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Perspective& wrap(const ClutterPerspective* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Perspective> : public Glib::Value_Boxed<Clutter::Perspective>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Stage
   */
  Glib::RefPtr<Clutter::Stage> wrap(ClutterStage* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_STAGE_H */

