// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <cluttermm/types.h>
#include <cluttermm/private/types_p.h>

#include <cstring> // std::memset()
#include <cstring> // std::memset()

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>

namespace Clutter
{

Knot::Knot()
{
  ClutterKnot tmp = {0, 0};
  gobject_ = clutter_knot_copy(&tmp);
}

Knot::Knot(int x, int y)
{
  ClutterKnot tmp = {x, y};
  gobject_ = clutter_knot_copy(&tmp);
}

void Knot::set_x(int x)
{
  gobject_->x = x;
}

void Knot::set_y(int y)
{
  gobject_->y = y;
}

void Knot::set_xy(int x, int y)
{
  gobject_->x = x;
  gobject_->y = y;
}

Vertex::Vertex(float x, float y, float z)
{
  gobject_.x = x;
  gobject_.y = y;
  gobject_.z = z;
}

Geometry::Geometry(int x, int y, guint width, guint height)
{
  gobject_.x = x;
  gobject_.y = y;
  gobject_.width  = width;
  gobject_.height = height;
}

void Geometry::set_x(int x)
{
  gobject_.x = x;
}

void Geometry::set_y(int y)
{
  gobject_.y = y;
}

void Geometry::set_xy(int x, int y)
{
  gobject_.x = x;
  gobject_.y = y;
}

void Geometry::set_width(guint width)
{
  gobject_.width = width;
}

void Geometry::set_height(guint height)
{
  gobject_.height = height;
}

void Geometry::set_size(guint width, guint height)
{
  gobject_.width  = width;
  gobject_.height = height;
}

Rect::Rect(float x, float y, float width, float height)
{
  gobject_ = clutter_rect_alloc();
  clutter_rect_init(gobject_, x, y, width, height);;
}

static gboolean cluttermm_rect_equals(const ClutterRect* a, const ClutterRect* b)
{
  return clutter_rect_equals(const_cast<ClutterRect*>(a), const_cast<ClutterRect*>(b));
}

Point Rect::get_centre() const
{
  ClutterPoint* p = clutter_point_alloc();
  clutter_rect_get_center(const_cast<ClutterRect*>(gobj()), p);
  const Point result = Glib::wrap(p);
  clutter_point_free(p);
  return result;
}

Rect Rect::rect_union(const Rect& b) const
{
  ClutterRect* crect = clutter_rect_alloc();
  clutter_rect_union(const_cast<ClutterRect*>(gobj()), const_cast<ClutterRect*>(b.gobj()), crect);
  const Rect result = Glib::wrap(crect);
  clutter_rect_free(crect);
  return result;
}


Point::Point(float x, float y)
{
  ClutterPoint* point = clutter_point_alloc();
  point = clutter_point_init(point, x, y);
  gobject_ = clutter_point_copy(point);
}

Point::Point(int x, int y)
{
  ClutterPoint* point = clutter_point_alloc();
  point = clutter_point_init(point, x, y);
  gobject_ = clutter_point_copy(point);
}

Point::Point(double x, double y)
{
  ClutterPoint* point = clutter_point_alloc();
  point = clutter_point_init(point, x, y);
  gobject_ = clutter_point_copy(point);
}

} // namespace Clutter

namespace
{
} // anonymous namespace


Clutter::InitError::InitError(Clutter::InitError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (CLUTTER_INIT_ERROR, error_code, error_message)
{}

Clutter::InitError::InitError(GError* gobject)
:
  Glib::Error (gobject)
{}

Clutter::InitError::Code Clutter::InitError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

void Clutter::InitError::throw_func(GError* gobject)
{
  throw Clutter::InitError(gobject);
}

// static
GType Glib::Value<Clutter::InitError::Code>::value_type()
{
  return clutter_init_error_get_type();
}

// static
GType Glib::Value<Clutter::AnimationMode>::value_type()
{
  return clutter_animation_mode_get_type();
}

// static
GType Glib::Value<Clutter::RotateDirection>::value_type()
{
  return clutter_rotate_direction_get_type();
}

// static
GType Glib::Value<Clutter::RotateAxis>::value_type()
{
  return clutter_rotate_axis_get_type();
}

// static
GType Glib::Value<Clutter::Gravity>::value_type()
{
  return clutter_gravity_get_type();
}

// static
GType Glib::Value<Clutter::RequestMode>::value_type()
{
  return clutter_request_mode_get_type();
}

// static
GType Glib::Value<Clutter::FontFlags>::value_type()
{
  return clutter_font_flags_get_type();
}

// static
GType Glib::Value<Clutter::ScalingFilter>::value_type()
{
  return clutter_scaling_filter_get_type();
}

// static
GType Glib::Value<Clutter::TextDirection>::value_type()
{
  return clutter_text_direction_get_type();
}


namespace Glib
{

Clutter::Vertex& wrap(ClutterVertex* object)
{
  return *reinterpret_cast<Clutter::Vertex*>(object);
}

const Clutter::Vertex& wrap(const ClutterVertex* object)
{
  return *reinterpret_cast<const Clutter::Vertex*>(object);
}

} // namespace Glib


namespace Clutter
{


// static
GType Vertex::get_type()
{
  return clutter_vertex_get_type();
}

Vertex::Vertex()
{
  std::memset(&gobject_, 0, sizeof(ClutterVertex));
}

Vertex::Vertex(const ClutterVertex* gobject)
{
  if(gobject)
    gobject_ = *gobject;
  else
    std::memset(&gobject_, 0, sizeof(ClutterVertex));
}


 float Vertex::get_x() const
{
  return gobj()->x;
}
 
 void Vertex::set_x(const float& value)
{
  gobj()->x = value;
}
 
 float Vertex::get_y() const
{
  return gobj()->y;
}
 
 void Vertex::set_y(const float& value)
{
  gobj()->y = value;
}
 
 float Vertex::get_z() const
{
  return gobj()->z;
}
 
 void Vertex::set_z(const float& value)
{
  gobj()->z = value;
}
 

} // namespace Clutter


namespace Glib
{

Clutter::Geometry& wrap(ClutterGeometry* object)
{
  return *reinterpret_cast<Clutter::Geometry*>(object);
}

const Clutter::Geometry& wrap(const ClutterGeometry* object)
{
  return *reinterpret_cast<const Clutter::Geometry*>(object);
}

} // namespace Glib


namespace Clutter
{


// static
GType Geometry::get_type()
{
  return clutter_geometry_get_type();
}

Geometry::Geometry()
{
  std::memset(&gobject_, 0, sizeof(ClutterGeometry));
}

Geometry::Geometry(const ClutterGeometry* gobject)
{
  if(gobject)
    gobject_ = *gobject;
  else
    std::memset(&gobject_, 0, sizeof(ClutterGeometry));
}

 int Geometry::get_x() const
{
  return gobj()->x;
}
 
 int Geometry::get_y() const
{
  return gobj()->y;
}
 
 guint Geometry::get_width() const
{
  return gobj()->width;
}
 
 guint Geometry::get_height() const
{
  return gobj()->height;
}
 

} // namespace Clutter


namespace Glib
{

Clutter::Point wrap(ClutterPoint* object, bool take_copy)
{
  return Clutter::Point(object, take_copy);
}

} // namespace Glib


namespace Clutter
{


// static
GType Point::get_type()
{
  return clutter_point_get_type();
}


Point::Point(const Point& other)
:
  gobject_ ((other.gobject_) ? clutter_point_copy(other.gobject_) : 0)
{}

Point::Point(ClutterPoint* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? clutter_point_copy(gobject) : gobject)
{}

Point& Point::operator=(const Point& other)
{
  Point temp (other);
  swap(temp);
  return *this;
}

Point::~Point()
{
  if(gobject_)
    clutter_point_free(gobject_);
}

void Point::swap(Point& other)
{
  ClutterPoint *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

ClutterPoint* Point::gobj_copy() const
{
  return clutter_point_copy(gobject_);
}


bool operator==(const Point& lhs, const Point& rhs)
{
  return (clutter_point_equals(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const Point& lhs, const Point& rhs)
{
  return (clutter_point_equals(lhs.gobj(), rhs.gobj()) == 0);
}


float Point::distance(const Point& b, float& x_distance, float& y_distance) const
{
  return clutter_point_distance(const_cast<ClutterPoint*>(gobj()), (b).gobj(), &(x_distance), &(y_distance));
}

 float Point::get_x() const
{
  return gobj()->x;
}
 
 float Point::get_y() const
{
  return gobj()->y;
}
 
 void Point::set_x(const float& value)
{
  gobj()->x = value;
}
 
 void Point::set_y(const float& value)
{
  gobj()->y = value;
}
 

} // namespace Clutter


namespace Glib
{

Clutter::Rect wrap(ClutterRect* object, bool take_copy)
{
  return Clutter::Rect(object, take_copy);
}

} // namespace Glib


namespace Clutter
{


// static
GType Rect::get_type()
{
  return clutter_rect_get_type();
}


Rect::Rect(const Rect& other)
:
  gobject_ ((other.gobject_) ? clutter_rect_copy(other.gobject_) : 0)
{}

Rect::Rect(ClutterRect* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? clutter_rect_copy(gobject) : gobject)
{}

Rect& Rect::operator=(const Rect& other)
{
  Rect temp (other);
  swap(temp);
  return *this;
}

Rect::~Rect()
{
  if(gobject_)
    clutter_rect_free(gobject_);
}

void Rect::swap(Rect& other)
{
  ClutterRect *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

ClutterRect* Rect::gobj_copy() const
{
  return clutter_rect_copy(gobject_);
}


bool operator==(const Rect& lhs, const Rect& rhs)
{
  return (cluttermm_rect_equals(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const Rect& lhs, const Rect& rhs)
{
  return (cluttermm_rect_equals(lhs.gobj(), rhs.gobj()) == 0);
}


Rect Rect::normalise()
{
  return Glib::wrap(clutter_rect_normalize(gobj()));
}

bool Rect::contains_point(const Point& point) const
{
  return clutter_rect_contains_point(const_cast<ClutterRect*>(gobj()), const_cast<ClutterPoint*>((point).gobj()));
}

bool Rect::contains_rect(const Rect& b) const
{
  return clutter_rect_contains_rect(const_cast<ClutterRect*>(gobj()), const_cast<ClutterRect*>((b).gobj()));
}

bool Rect::intersection(const Rect& b, Rect& res) const
{
  ClutterRect g_res = ClutterRect();
  bool retvalue = clutter_rect_intersection(const_cast<ClutterRect*>(gobj()), const_cast<ClutterRect*>((b).gobj()), &g_res);
res = Glib::wrap(&(g_res));
  return retvalue;
}

void Rect::offset(float d_x, float d_y)
{
  clutter_rect_offset(gobj(), d_x, d_y);
}

void Rect::inset(float d_x, float d_y)
{
  clutter_rect_inset(gobj(), d_x, d_y);
}

void Rect::clamp_to_pixel()
{
  clutter_rect_clamp_to_pixel(gobj());
}

float Rect::get_x() const
{
  return clutter_rect_get_x(const_cast<ClutterRect*>(gobj()));
}

float Rect::get_y() const
{
  return clutter_rect_get_y(const_cast<ClutterRect*>(gobj()));
}

float Rect::get_width() const
{
  return clutter_rect_get_width(const_cast<ClutterRect*>(gobj()));
}

float Rect::get_height() const
{
  return clutter_rect_get_height(const_cast<ClutterRect*>(gobj()));
}


} // namespace Clutter


namespace Glib
{

Clutter::Knot wrap(ClutterKnot* object, bool take_copy)
{
  return Clutter::Knot(object, take_copy);
}

} // namespace Glib


namespace Clutter
{


// static
GType Knot::get_type()
{
  return clutter_knot_get_type();
}


Knot::Knot(const Knot& other)
:
  gobject_ ((other.gobject_) ? clutter_knot_copy(other.gobject_) : 0)
{}

Knot::Knot(ClutterKnot* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? clutter_knot_copy(gobject) : gobject)
{}

Knot& Knot::operator=(const Knot& other)
{
  Knot temp (other);
  swap(temp);
  return *this;
}

Knot::~Knot()
{
  if(gobject_)
    clutter_knot_free(gobject_);
}

void Knot::swap(Knot& other)
{
  ClutterKnot *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

ClutterKnot* Knot::gobj_copy() const
{
  return clutter_knot_copy(gobject_);
}

 int Knot::get_x() const
{
  return gobj()->x;
}
 
 int Knot::get_y() const
{
  return gobj()->y;
}
 

bool operator==(const Knot& lhs, const Knot& rhs)
{
  return (clutter_knot_equal(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const Knot& lhs, const Knot& rhs)
{
  return (clutter_knot_equal(lhs.gobj(), rhs.gobj()) == 0);
}


} // namespace Clutter


