// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TYPES_H
#define _CLUTTERMM_TYPES_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>
#include <cogl/cogl.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _ClutterPoint ClutterPoint; }
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _ClutterRect ClutterRect; }
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _ClutterKnot ClutterKnot; }
#endif

namespace Cogl
{
typedef CoglAngle Angle;
typedef CoglFixed Fixed;
} // namespace Cogl

namespace Clutter
{

typedef ClutterEvent Event;
typedef ClutterButtonEvent ButtonEvent;
typedef ClutterKeyEvent KeyEvent;
typedef ClutterMotionEvent MotionEvent;
typedef ClutterScrollEvent ScrollEvent;
typedef ClutterCrossingEvent CrossingEvent;

//TODO: Maybe redefine these, to avoid including a C header in our C++ header:

class InitError : public Glib::Error
{
public:
  enum Code
  {
    INIT_SUCCESS = 1,
    UNKNOWN = 0,
    THREADS = -1,
    BACKEND = -2,
    INTERNAL = -3
  };

  InitError(Code error_code, const Glib::ustring& error_message);
  explicit InitError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Clutter

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::InitError::Code> : public Glib::Value_Enum<Clutter::InitError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var AnimationMode CUSTOM_MODE
 *  Custom progress function.
 * 
 *  @var AnimationMode LINEAR
 *  Linear tweening.
 * 
 *  @var AnimationMode EASE_IN_QUAD
 *  Quadratic tweening.
 * 
 *  @var AnimationMode EASE_OUT_QUAD
 *  Quadratic tweening, inverse of Clutter::EASE_IN_QUAD.
 * 
 *  @var AnimationMode EASE_IN_OUT_QUAD
 *  Quadratic tweening, combininig Clutter::EASE_IN_QUAD and Clutter::EASE_OUT_QUAD.
 * 
 *  @var AnimationMode EASE_IN_CUBIC
 *  Cubic tweening.
 * 
 *  @var AnimationMode EASE_OUT_CUBIC
 *  Cubic tweening, invers of Clutter::EASE_IN_CUBIC.
 * 
 *  @var AnimationMode EASE_IN_OUT_CUBIC
 *  Cubic tweening, combining Clutter::EASE_IN_CUBIC and Clutter::EASE_OUT_CUBIC.
 * 
 *  @var AnimationMode EASE_IN_QUART
 *  Quartic tweening.
 * 
 *  @var AnimationMode EASE_OUT_QUART
 *  Quartic tweening, inverse of Clutter::EASE_IN_QUART.
 * 
 *  @var AnimationMode EASE_IN_OUT_QUART
 *  Quartic tweening, combining Clutter::EASE_IN_QUART and Clutter::EASE_OUT_QUART.
 * 
 *  @var AnimationMode EASE_IN_QUINT
 *  Quintic tweening.
 * 
 *  @var AnimationMode EASE_OUT_QUINT
 *  Quintic tweening, inverse of Clutter::EASE_IN_QUINT.
 * 
 *  @var AnimationMode EASE_IN_OUT_QUINT
 *  Fifth power tweening, combining Clutter::EASE_IN_QUINT and Clutter::EASE_OUT_QUINT.
 * 
 *  @var AnimationMode EASE_IN_SINE
 *  Sinusoidal tweening.
 * 
 *  @var AnimationMode EASE_OUT_SINE
 *  Sinusoidal tweening, inverse of Clutter::EASE_IN_SINE.
 * 
 *  @var AnimationMode EASE_IN_OUT_SINE
 *  Sine wave tweening, combining Clutter::EASE_IN_SINE and Clutter::EASE_OUT_SINE.
 * 
 *  @var AnimationMode EASE_IN_EXPO
 *  Exponential tweening.
 * 
 *  @var AnimationMode EASE_OUT_EXPO
 *  Exponential tweening, inverse of Clutter::EASE_IN_EXPO.
 * 
 *  @var AnimationMode EASE_IN_OUT_EXPO
 *  Exponential tweening, combining Clutter::EASE_IN_EXPO and Clutter::EASE_OUT_EXPO.
 * 
 *  @var AnimationMode EASE_IN_CIRC
 *  Circular tweening.
 * 
 *  @var AnimationMode EASE_OUT_CIRC
 *  Circular tweening, inverse of Clutter::EASE_IN_CIRC.
 * 
 *  @var AnimationMode EASE_IN_OUT_CIRC
 *  Circular tweening, combining Clutter::EASE_IN_CIRC and Clutter::EASE_OUT_CIRC.
 * 
 *  @var AnimationMode EASE_IN_ELASTIC
 *  Elastic tweening, with offshoot on start.
 * 
 *  @var AnimationMode EASE_OUT_ELASTIC
 *  Elastic tweening, with offshoot on end.
 * 
 *  @var AnimationMode EASE_IN_OUT_ELASTIC
 *  Elastic tweening with offshoot on both ends.
 * 
 *  @var AnimationMode EASE_IN_BACK
 *  Overshooting cubic tweening, with backtracking on start.
 * 
 *  @var AnimationMode EASE_OUT_BACK
 *  Overshooting cubic tweening, with backtracking on end.
 * 
 *  @var AnimationMode EASE_IN_OUT_BACK
 *  Overshooting cubic tweening, with backtracking on both ends.
 * 
 *  @var AnimationMode EASE_IN_BOUNCE
 *  Exponentially decaying parabolic (bounce) tweening, with bounce on start.
 * 
 *  @var AnimationMode EASE_OUT_BOUNCE
 *  Exponentially decaying parabolic (bounce) tweening, with bounce on end.
 * 
 *  @var AnimationMode EASE_IN_OUT_BOUNCE
 *  Exponentially decaying parabolic (bounce) tweening, with bounce on both ends.
 * 
 *  @var AnimationMode STEPS
 *  Parametrized step function; see Clutter::Timeline::set_step_progress() for further details. (Since 1.12).
 * 
 *  @var AnimationMode STEP_START
 *  Equivalent to Clutter::STEPS with a number of steps equal to 1, and a step mode of Clutter::STEP_MODE_START. (Since 1.12).
 * 
 *  @var AnimationMode STEP_END
 *  Equivalent to Clutter::STEPS with a number of steps equal to 1, and a step mode of Clutter::STEP_MODE_END. (Since 1.12).
 * 
 *  @var AnimationMode CUBIC_BEZIER
 *  Cubic bezier between (0, 0) and (1, 1) with two control points; see Clutter::Timeline::set_cubic_bezier_progress(). (Since 1.12).
 * 
 *  @var AnimationMode EASE
 *  Equivalent to Clutter::CUBIC_BEZIER with control points in (0.25, 0.1) and (0.25, 1.0). (Since 1.12).
 * 
 *  @var AnimationMode EASE_IN
 *  Equivalent to Clutter::CUBIC_BEZIER with control points in (0.42, 0) and (1.0, 1.0). (Since 1.12).
 * 
 *  @var AnimationMode EASE_OUT
 *  Equivalent to Clutter::CUBIC_BEZIER with control points in (0, 0) and (0.58, 1.0). (Since 1.12).
 * 
 *  @var AnimationMode EASE_IN_OUT
 *  Equivalent to Clutter::CUBIC_BEZIER with control points in (0.42, 0) and (0.58, 1.0). (Since 1.12).
 * 
 *  @var AnimationMode ANIMATION_LAST
 *  Last animation mode, used as a guard for registered global alpha functions.
 * 
 *  @enum AnimationMode
 * 
 * The animation modes used by Clutter::Alpha and Clutter::Animation. This
 * enumeration can be expanded in later versions of Clutter.
 * 
 * <figure id="easing-modes">
 * <title>Easing modes provided by Clutter</title>
 * <graphic fileref="easing-modes.png" format="PNG"/>
 * </figure>
 * 
 * Every global alpha function registered using Clutter::Alpha::register_func()
 * or Clutter::Alpha::register_closure() will have a logical id greater than
 * Clutter::ANIMATION_LAST.
 * 
 * @newin{1,0}
 * @ingroup cluttermmEnums
 */
enum AnimationMode
{
  CUSTOM_MODE,
  LINEAR,
  EASE_IN_QUAD,
  EASE_OUT_QUAD,
  EASE_IN_OUT_QUAD,
  EASE_IN_CUBIC,
  EASE_OUT_CUBIC,
  EASE_IN_OUT_CUBIC,
  EASE_IN_QUART,
  EASE_OUT_QUART,
  EASE_IN_OUT_QUART,
  EASE_IN_QUINT,
  EASE_OUT_QUINT,
  EASE_IN_OUT_QUINT,
  EASE_IN_SINE,
  EASE_OUT_SINE,
  EASE_IN_OUT_SINE,
  EASE_IN_EXPO,
  EASE_OUT_EXPO,
  EASE_IN_OUT_EXPO,
  EASE_IN_CIRC,
  EASE_OUT_CIRC,
  EASE_IN_OUT_CIRC,
  EASE_IN_ELASTIC,
  EASE_OUT_ELASTIC,
  EASE_IN_OUT_ELASTIC,
  EASE_IN_BACK,
  EASE_OUT_BACK,
  EASE_IN_OUT_BACK,
  EASE_IN_BOUNCE,
  EASE_OUT_BOUNCE,
  EASE_IN_OUT_BOUNCE,
  STEPS,
  STEP_START,
  STEP_END,
  CUBIC_BEZIER,
  EASE,
  EASE_IN,
  EASE_OUT,
  EASE_IN_OUT,
  ANIMATION_LAST
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::AnimationMode> : public Glib::Value_Enum<Clutter::AnimationMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var RotateDirection ROTATE_CW
 *  Clockwise rotation.
 * 
 *  @var RotateDirection ROTATE_CCW
 *  Counter-clockwise rotation.
 * 
 *  @enum RotateDirection
 * 
 * Direction of a rotation.
 * 
 * @newin{0,4}
 * @ingroup cluttermmEnums
 */
enum RotateDirection
{
  ROTATE_CW,
  ROTATE_CCW
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::RotateDirection> : public Glib::Value_Enum<Clutter::RotateDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var RotateAxis X_AXIS
 *  Rotate around the X axis.
 * 
 *  @var RotateAxis Y_AXIS
 *  Rotate around the Y axis.
 * 
 *  @var RotateAxis Z_AXIS
 *  Rotate around the Z axis.
 * 
 *  @enum RotateAxis
 * 
 * Axis of a rotation.
 * 
 * @newin{0,4}
 * @ingroup cluttermmEnums
 */
enum RotateAxis
{
  X_AXIS,
  Y_AXIS,
  Z_AXIS
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::RotateAxis> : public Glib::Value_Enum<Clutter::RotateAxis>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var Gravity GRAVITY_NONE
 *  Do not apply any gravity.
 * 
 *  @var Gravity GRAVITY_NORTH
 *  Scale from topmost downwards.
 * 
 *  @var Gravity GRAVITY_NORTH_EAST
 *  Scale from the top right corner.
 * 
 *  @var Gravity GRAVITY_EAST
 *  Scale from the right side.
 * 
 *  @var Gravity GRAVITY_SOUTH_EAST
 *  Scale from the bottom right corner.
 * 
 *  @var Gravity GRAVITY_SOUTH
 *  Scale from the bottom upwards.
 * 
 *  @var Gravity GRAVITY_SOUTH_WEST
 *  Scale from the bottom left corner.
 * 
 *  @var Gravity GRAVITY_WEST
 *  Scale from the left side.
 * 
 *  @var Gravity GRAVITY_NORTH_WEST
 *  Scale from the top left corner.
 * 
 *  @var Gravity GRAVITY_CENTER
 *  Scale from the center.
 * 
 *  @enum Gravity
 * 
 * Gravity of the scaling operations. When a gravity different than
 * Clutter::GRAVITY_NONE is used, an actor is scaled keeping the position
 * of the specified portion at the same coordinates.
 * 
 * @newin{0,2}
 * @ingroup cluttermmEnums
 */
enum Gravity
{
  GRAVITY_NONE,
  GRAVITY_NORTH,
  GRAVITY_NORTH_EAST,
  GRAVITY_EAST,
  GRAVITY_SOUTH_EAST,
  GRAVITY_SOUTH,
  GRAVITY_SOUTH_WEST,
  GRAVITY_WEST,
  GRAVITY_NORTH_WEST,
  GRAVITY_CENTER
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::Gravity> : public Glib::Value_Enum<Clutter::Gravity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var RequestMode REQUEST_HEIGHT_FOR_WIDTH
 *  Height for width requests.
 * 
 *  @var RequestMode REQUEST_WIDTH_FOR_HEIGHT
 *  Width for height requests.
 * 
 *  @enum RequestMode
 * 
 * Specifies the type of requests for a Clutter::Actor.
 * 
 * @newin{0,8}
 * @ingroup cluttermmEnums
 */
enum RequestMode
{
  REQUEST_HEIGHT_FOR_WIDTH,
  REQUEST_WIDTH_FOR_HEIGHT
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::RequestMode> : public Glib::Value_Enum<Clutter::RequestMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var FontFlags FONT_MIPMAPPING
 *  Set to use mipmaps for the glyph cache textures.
 * 
 *  @var FontFlags FONT_HINTING
 *  Set to enable hinting on the glyphs.
 * 
 *  @enum FontFlags
 * 
 * Runtime flags to change the font quality. To be used with
 * clutter_set_font_flags().
 * 
 * @newin{1,0}
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%FontFlags operator|(FontFlags, FontFlags)</tt><br>
 * <tt>%FontFlags operator&(FontFlags, FontFlags)</tt><br>
 * <tt>%FontFlags operator^(FontFlags, FontFlags)</tt><br>
 * <tt>%FontFlags operator~(FontFlags)</tt><br>
 * <tt>%FontFlags& operator|=(FontFlags&, FontFlags)</tt><br>
 * <tt>%FontFlags& operator&=(FontFlags&, FontFlags)</tt><br>
 * <tt>%FontFlags& operator^=(FontFlags&, FontFlags)</tt><br>
 */
enum FontFlags
{
  FONT_MIPMAPPING = (1 << 0),
  FONT_HINTING = (1 << 1)
};

/** @ingroup cluttermmEnums */
inline FontFlags operator|(FontFlags lhs, FontFlags rhs)
  { return static_cast<FontFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline FontFlags operator&(FontFlags lhs, FontFlags rhs)
  { return static_cast<FontFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline FontFlags operator^(FontFlags lhs, FontFlags rhs)
  { return static_cast<FontFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline FontFlags operator~(FontFlags flags)
  { return static_cast<FontFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline FontFlags& operator|=(FontFlags& lhs, FontFlags rhs)
  { return (lhs = static_cast<FontFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline FontFlags& operator&=(FontFlags& lhs, FontFlags rhs)
  { return (lhs = static_cast<FontFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline FontFlags& operator^=(FontFlags& lhs, FontFlags rhs)
  { return (lhs = static_cast<FontFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::FontFlags> : public Glib::Value_Flags<Clutter::FontFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var ScalingFilter SCALING_FILTER_LINEAR
 *  Linear interpolation filter.
 * 
 *  @var ScalingFilter SCALING_FILTER_NEAREST
 *  Nearest neighbor interpolation filter.
 * 
 *  @var ScalingFilter SCALING_FILTER_TRILINEAR
 *  Trilinear minification filter, with mipmap generation; this filter linearly interpolates on every axis, as well as between mipmap levels.
 * 
 *  @enum ScalingFilter
 * 
 * The scaling filters to be used with the Clutter::Actor::property_minification_filter()
 * and Clutter::Actor::property_magnification_filter() properties.
 * 
 * @newin{1,10}
 * @ingroup cluttermmEnums
 */
enum ScalingFilter
{
  SCALING_FILTER_LINEAR,
  SCALING_FILTER_NEAREST,
  SCALING_FILTER_TRILINEAR
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ScalingFilter> : public Glib::Value_Enum<Clutter::ScalingFilter>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var TextDirection TEXT_DIRECTION_DEFAULT
 *  Use the default setting, as returned by clutter_get_default_text_direction().
 * 
 *  @var TextDirection TEXT_DIRECTION_LTR
 *  Use left-to-right text direction.
 * 
 *  @var TextDirection TEXT_DIRECTION_RTL
 *  Use right-to-left text direction.
 * 
 *  @enum TextDirection
 * 
 * The text direction to be used by Clutter::Actor<!-- -->s
 * 
 * @newin{1,2}
 * @ingroup cluttermmEnums
 */
enum TextDirection
{
  TEXT_DIRECTION_DEFAULT,
  TEXT_DIRECTION_LTR,
  TEXT_DIRECTION_RTL
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::TextDirection> : public Glib::Value_Enum<Clutter::TextDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Vertex
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Vertex CppObjectType;
  typedef ClutterVertex BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  Vertex();

  explicit Vertex(const ClutterVertex* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterVertex*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterVertex* gobj() const { return &gobject_; }

protected:
  ClutterVertex gobject_;

private:
  
public:
  Vertex(float x, float y, float z = 0);

   float get_x() const;
    void set_x(const float& value);
    float get_y() const;
    void set_y(const float& value);
    float get_z() const;
    void set_z(const float& value);
 

};

class Geometry
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Geometry CppObjectType;
  typedef ClutterGeometry BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  Geometry();

  explicit Geometry(const ClutterGeometry* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterGeometry*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterGeometry* gobj() const { return &gobject_; }

protected:
  ClutterGeometry gobject_;

private:
  
public:
  Geometry(int x, int y, guint width = 0, guint height = 0);

   int get_x() const;
   void set_x(int x);
   int get_y() const;
   void set_y(int y);
  void set_xy(int x, int y);

   guint get_width() const;
   void set_width(guint width);
   guint get_height() const;
   void set_height(guint height);
  void set_size(guint width, guint height);


};

/** A Clutter::Point is a 2D point in space.
 *
 * It is used to return points, either in absolute coordinates or relative,
 * depending on the method.
 */
class Point
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Point CppObjectType;
  typedef ClutterPoint BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit Point(ClutterPoint* gobject, bool make_a_copy = true);

  Point(const Point& other);
  Point& operator=(const Point& other);

  ~Point();

  void swap(Point& other);

  ///Provides access to the underlying C instance.
  ClutterPoint*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterPoint* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  ClutterPoint* gobj_copy() const;

protected:
  ClutterPoint* gobject_;

private:

  
public:

  //We do not want the normal generated constructor
  //because that creates an unusable object.
  

  /** Constructor.
   */
  explicit Point(float x = 0, float y = 0);

  // This constructor is just here to prevent calls to Point(int, int) being ambiguous 
  // between Point(float, float) and Point(ClutterPoint*, bool).
  Point(int x, int y);

  // This constructor is just here to prevent calls to Point(double, double) being ambiguous 
  // between Point(float, float) and Point(int, int).
  Point(double x, double y);

  
  /** Computes the distance between two Clutter::Point.
   * 
   * @newin{1,12}
   * @param b A Clutter::Point.
   * @param x_distance Return location for the horizontal
   * distance between the points.
   * @param y_distance Return location for the vertical
   * distance between the points.
   * @return The distance between the points.
   */
  float distance(const Point& b, float& x_distance, float& y_distance) const;

   float get_x() const;
    float get_y() const;
    void set_x(const float& value);
    void set_y(const float& value);
 

};

//This has replaced Clutter::Geometry in new code.
//Note: ClutterRect normalizes the rects in each call, even get_x(),
//and should not be accessed directly via its struct fields,
//so we consider several methods to be const even though they actually
//change the internal struct field values.
//TODO: Put this in its own file.
class Rect
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Rect CppObjectType;
  typedef ClutterRect BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit Rect(ClutterRect* gobject, bool make_a_copy = true);

  Rect(const Rect& other);
  Rect& operator=(const Rect& other);

  ~Rect();

  void swap(Rect& other);

  ///Provides access to the underlying C instance.
  ClutterRect*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterRect* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  ClutterRect* gobj_copy() const;

protected:
  ClutterRect* gobject_;

private:

  
public:
  

  /**
   * Create a new Rect object, optionally specifying its dimensions.
   */
  explicit Rect(float x = 0, float y = 0, float width = 0, float height = 0);

  
  //TODO: Is this useful? And should it be const?
  //All methods normalise the rect anyway.
  
  /** Normalizes a Clutter::Rect.
   * 
   * A Clutter::Rect is defined by the area covered by its size; this means
   * that a Clutter::Rect with Clutter::Rect.origin in [ 0, 0 ] and a
   * Clutter::Rect.size of [ 10, 10 ] is equivalent to a Clutter::Rect with
   * Clutter::Rect.origin in [ 10, 10 ] and a Clutter::Rect.size of [ -10, -10 ].
   * 
   * This function is useful to ensure that a rectangle has positive width
   * and height; it will modify the passed @a rect and normalize its size.
   * 
   * @newin{1,12}
   */
  Rect normalise();

  /** Retrieves the center of the rect and returns a rect with the correct coordinates.
   */
  Point get_centre() const;
  

  /** Checks whether @a point is contained by @a rect, after normalizing the
   * rectangle.
   * 
   * @newin{1,12}
   * @param point The point to check.
   * @return <tt>true</tt> if the @a point is contained by @a rect.
   */
  bool contains_point(const Point& point) const;
  
  /** Checks whether @a a contains @a b.
   * 
   * The first rectangle contains the second if the union of the
   * two Clutter::Rect is equal to the first rectangle.
   * 
   * @newin{1,12}
   * @param b A Clutter::Rect.
   * @return <tt>true</tt> if the first rectangle contains the second.
   */
  bool contains_rect(const Rect& b) const;

  //We can't call this union() because it's a reserved word. 
  /**
   * Computes the smallest possible rectangle capable of fully containing both this rect and @a b, and returns it.
   */
  Rect rect_union(const Rect& b) const;
  

  /** Computes the intersection of @a a and @a b, and places it in @a res, if @a res
   * is not <tt>0</tt>.
   * 
   * This function will normalize both @a a and @a b prior to computing their
   * intersection.
   * 
   * This function can be used to simply check if the intersection of @a a and @a b
   * is not empty, by using <tt>0</tt> for @a res.
   * 
   * @newin{1,12}
   * @param b A Clutter::Rect.
   * @param res A Clutter::Rect, or <tt>0</tt>.
   * @return <tt>true</tt> if the intersection of @a a and @a b is not empty.
   */
  bool intersection(const Rect& b, Rect& res) const;

  
  /** Offsets the origin of @a rect by the given values, after normalizing
   * the rectangle.
   * 
   * @newin{1,12}
   * @param d_x The horizontal offset value.
   * @param d_y The vertical offset value.
   */
  void offset(float d_x, float d_y);
  
  /** Normalizes the @a rect and offsets its origin by the @a d_x and @a d_y values;
   * the size is adjusted by (2 * @a d_x, 2 * @a d_y).
   * 
   * If @a d_x and @a d_y are positive the size of the rectangle is decreased; if
   * the values are negative, the size of the rectangle is increased.
   * 
   * If the resulting rectangle has a negative width or height, the size is
   * set to 0.
   * 
   * @newin{1,12}
   * @param d_x An horizontal value; a positive @a d_x will create an inset rectangle,
   * and a negative value will create a larger rectangle.
   * @param d_y A vertical value; a positive @a d_x will create an inset rectangle,
   * and a negative value will create a larger rectangle.
   */
  void inset(float d_x, float d_y);
  
  /** Rounds the origin of @a rect downwards to the nearest integer, and rounds
   * the size of @a rect upwards to the nearest integer, so that @a rect is
   * updated to the smallest rectangle capable of fully containing the
   * original, fractional rectangle.
   * 
   * @newin{1,12}
   */
  void clamp_to_pixel();
  
  /** Retrieves the X coordinate of the origin of @a rect.
   * 
   * @newin{1,12}
   * @return The X coordinate of the origin of the rectangle.
   */
  float get_x() const;
  
  /** Retrieves the Y coordinate of the origin of @a rect.
   * 
   * @newin{1,12}
   * @return The Y coordinate of the origin of the rectangle.
   */
  float get_y() const;
  
  /** Retrieves the width of @a rect.
   * 
   * @newin{1,12}
   * @return The width of the rectangle.
   */
  float get_width() const;
  
  /** Retrieves the height of @a rect.
   * 
   * @newin{1,12}
   * @return The height of the rectangle.
   */
  float get_height() const;


};


class Knot
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Knot CppObjectType;
  typedef ClutterKnot BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit Knot(ClutterKnot* gobject, bool make_a_copy = true);

  Knot(const Knot& other);
  Knot& operator=(const Knot& other);

  ~Knot();

  void swap(Knot& other);

  ///Provides access to the underlying C instance.
  ClutterKnot*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterKnot* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  ClutterKnot* gobj_copy() const;

protected:
  ClutterKnot* gobject_;

private:

  
public:

  // NOTE: _CUSTOM_DEFAULT_CTOR must be used on the last class definition
  // as it "falls through" to any following definitions in the same file.
  
  Knot();
  Knot(int x, int y);

   int get_x() const;
   void set_x(int x);
   int get_y() const;
   void set_y(int y);
  void set_xy(int x, int y);


};

} // namespace Clutter


namespace Glib
{

/** @relates Clutter::Vertex
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Vertex& wrap(ClutterVertex* object);

/** @relates Clutter::Vertex
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Vertex& wrap(const ClutterVertex* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Vertex> : public Glib::Value_Boxed<Clutter::Vertex>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{

/** @relates Clutter::Geometry
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Geometry& wrap(ClutterGeometry* object);

/** @relates Clutter::Geometry
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Geometry& wrap(const ClutterGeometry* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Geometry> : public Glib::Value_Boxed<Clutter::Geometry>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Clutter
{

/** @relates Clutter::Point
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const Point& lhs, const Point& rhs);

/** @relates Clutter::Point
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const Point& lhs, const Point& rhs);


} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::Point
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Point& lhs, Point& rhs)
  { lhs.swap(rhs); }

} // namespace Clutter

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Clutter::Point
 */
Clutter::Point wrap(ClutterPoint* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Point> : public Glib::Value_Boxed<Clutter::Point>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Clutter
{

/** @relates Clutter::Rect
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const Rect& lhs, const Rect& rhs);

/** @relates Clutter::Rect
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const Rect& lhs, const Rect& rhs);


} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::Rect
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Rect& lhs, Rect& rhs)
  { lhs.swap(rhs); }

} // namespace Clutter

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Clutter::Rect
 */
Clutter::Rect wrap(ClutterRect* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Rect> : public Glib::Value_Boxed<Clutter::Rect>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Clutter
{

/** @relates Clutter::Knot
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const Knot& lhs, const Knot& rhs);

/** @relates Clutter::Knot
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const Knot& lhs, const Knot& rhs);


} // namespace Clutter


namespace Clutter
{

/** @relates Clutter::Knot
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Knot& lhs, Knot& rhs)
  { lhs.swap(rhs); }

} // namespace Clutter

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Clutter::Knot
 */
Clutter::Knot wrap(ClutterKnot* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Knot> : public Glib::Value_Boxed<Clutter::Knot>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _CLUTTERMM_TYPES_H */

