// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_DEVICE_MANAGER_H
#define _CLUTTERMM_DEVICE_MANAGER_H


#include <glibmm.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/input-device.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterDeviceManager ClutterDeviceManager;
typedef struct _ClutterDeviceManagerClass ClutterDeviceManagerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class DeviceManager_Class; } // namespace Clutter
namespace Clutter
{

class Backend;


class DeviceManager : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DeviceManager CppObjectType;
  typedef DeviceManager_Class CppClassType;
  typedef ClutterDeviceManager BaseObjectType;
  typedef ClutterDeviceManagerClass BaseClassType;

private:  friend class DeviceManager_Class;
  static CppClassType devicemanager_class_;

private:
  // noncopyable
  DeviceManager(const DeviceManager&);
  DeviceManager& operator=(const DeviceManager&);

protected:
  explicit DeviceManager(const Glib::ConstructParams& construct_params);
  explicit DeviceManager(ClutterDeviceManager* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DeviceManager();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterDeviceManager*       gobj()       { return reinterpret_cast<ClutterDeviceManager*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterDeviceManager* gobj() const { return reinterpret_cast<ClutterDeviceManager*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterDeviceManager* gobj_copy();

private:


protected:
  DeviceManager();

public:

  Glib::RefPtr<DeviceManager> get_default();

  
  /** Lists all currently registered input devices
   * 
   * @newin{1,2}
   * @return A newly allocated list of Clutter::InputDevice objects. Use
   * Glib::slist_free() to deallocate it when done.
   */

  std::vector<Glib::RefPtr<InputDevice> >       list_devices();
  std::vector<Glib::RefPtr<const InputDevice> > list_devices() const;

  
  /** Retrieves the Clutter::InputDevice with the given @a device_id
   * 
   * @newin{1,2}
   * @param device_id The integer id of a device.
   * @return A Clutter::InputDevice or <tt>0</tt>. The
   * returned device is owned by the Clutter::DeviceManager and should
   * never be modified or freed.
   */
  Glib::RefPtr<InputDevice> get_device(int device_id);
  
  /** Retrieves the Clutter::InputDevice with the given @a device_id
   * 
   * @newin{1,2}
   * @param device_id The integer id of a device.
   * @return A Clutter::InputDevice or <tt>0</tt>. The
   * returned device is owned by the Clutter::DeviceManager and should
   * never be modified or freed.
   */
  Glib::RefPtr<const InputDevice> get_device(int device_id) const;
  
  /** Retrieves the core Clutter::InputDevice of type @a device_type
   * 
   * Core devices are devices created automatically by the default
   * Clutter backend
   * 
   * @newin{1,2}
   * @param device_type The type of the core device.
   * @return A Clutter::InputDevice or <tt>0</tt>. The
   * returned device is owned by the Clutter::DeviceManager and should
   * not be modified or freed.
   */
  Glib::RefPtr<InputDevice> get_core_device(InputDeviceType device_type);
  
  /** Retrieves the core Clutter::InputDevice of type @a device_type
   * 
   * Core devices are devices created automatically by the default
   * Clutter backend
   * 
   * @newin{1,2}
   * @param device_type The type of the core device.
   * @return A Clutter::InputDevice or <tt>0</tt>. The
   * returned device is owned by the Clutter::DeviceManager and should
   * not be modified or freed.
   */
  Glib::RefPtr<const InputDevice> get_core_device(InputDeviceType device_type) const;

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The ClutterBackend of the device manager.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Backend> > property_backend() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::DeviceManager
   */
  Glib::RefPtr<Clutter::DeviceManager> wrap(ClutterDeviceManager* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_DEVICE_MANAGER_H */

