// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BOX_LAYOUT_H
#define _CLUTTERMM_BOX_LAYOUT_H


#include <glibmm.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/layout-manager.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBoxLayout ClutterBoxLayout;
typedef struct _ClutterBoxLayoutClass ClutterBoxLayoutClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class BoxLayout_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/**
 * @ingroup cluttermmEnums
 */
enum BoxAlignment
{
  BOX_ALIGNMENT_START,
  BOX_ALIGNMENT_END,
  BOX_ALIGNMENT_CENTER
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::BoxAlignment> : public Glib::Value_Enum<Clutter::BoxAlignment>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class BoxLayout :
    public LayoutManager
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BoxLayout CppObjectType;
  typedef BoxLayout_Class CppClassType;
  typedef ClutterBoxLayout BaseObjectType;
  typedef ClutterBoxLayoutClass BaseClassType;

private:  friend class BoxLayout_Class;
  static CppClassType boxlayout_class_;

private:
  // noncopyable
  BoxLayout(const BoxLayout&);
  BoxLayout& operator=(const BoxLayout&);

protected:
  explicit BoxLayout(const Glib::ConstructParams& construct_params);
  explicit BoxLayout(ClutterBoxLayout* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BoxLayout();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBoxLayout*       gobj()       { return reinterpret_cast<ClutterBoxLayout*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBoxLayout* gobj() const { return reinterpret_cast<ClutterBoxLayout*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBoxLayout* gobj_copy();

private:


protected:
  BoxLayout();

public:
  
  static Glib::RefPtr<BoxLayout> create();


  /** Sets whether children of @a layout should be layed out by appending
   * them or by prepending them
   * 
   * @newin{1,2}
   * @param pack_start <tt>true</tt> if the @a layout should pack children at the
   * beginning of the layout.
   */
  void set_pack_start(bool pack_start);
  
  /** Retrieves the value set using set_pack_start()
   * 
   * @newin{1,2}
   * @return <tt>true</tt> if the Clutter::BoxLayout should pack children
   * at the beginning of the layout, and <tt>false</tt> otherwise.
   */
  bool get_pack_start() const;
  
  /** Sets the spacing between children of @a layout
   * 
   * @newin{1,2}
   * @param spacing The spacing between children of the layout, in pixels.
   */
  void set_spacing(guint spacing);
  
  /** Retrieves the spacing set using set_spacing()
   * 
   * @newin{1,2}
   * @return The spacing between children of the Clutter::BoxLayout.
   */
  guint get_spacing() const;
  
  /** Sets whether @a layout should arrange its children vertically alongside
   * the Y axis, instead of horizontally alongside the X axis
   * 
   * @newin{1,2}
   * @param vertical <tt>true</tt> if the layout should be vertical.
   */
  void set_vertical(bool vertical);
  
  /** Retrieves the orientation of the @a layout as set using the
   * set_vertical() function
   * 
   * @newin{1,2}
   * @return <tt>true</tt> if the Clutter::BoxLayout is arranging its children
   * vertically, and <tt>false</tt> otherwise.
   */
  bool get_vertical() const;
  
  void set_homogeneous(bool homogeneous);
  
  bool get_homogeneous() const;

  
  /** Packs @a actor inside the Clutter::Container associated to @a layout
   * and sets the layout properties
   * 
   * @newin{1,2}
   * @param actor A Clutter::Actor.
   * @param expand Whether the @a actor should expand.
   * @param x_fill Whether the @a actor should fill horizontally.
   * @param y_fill Whether the @a actor should fill vertically.
   * @param x_align The horizontal alignment policy for @a actor.
   * @param y_align The vertical alignment policy for @a actor.
   */
  void pack(const Glib::RefPtr<Actor>&, bool expand, bool x_fill, bool y_fill, BoxAlignment x_align, BoxAlignment y_align);

  
  /** Sets the horizontal and vertical alignment policies for @a actor
   * inside @a layout
   * 
   * @newin{1,2}
   * @param actor A Clutter::Actor child of @a layout.
   * @param x_align Horizontal alignment policy for @a actor.
   * @param y_align Vertical alignment policy for @a actor.
   */
  void set_alignment(const Glib::RefPtr<Actor>& child, BoxAlignment x_align, BoxAlignment y_align);
  
  /** Retrieves the horizontal and vertical alignment policies for @a actor
   * as set using pack() or set_alignment()
   * 
   * @newin{1,2}
   * @param actor A Clutter::Actor child of @a layout.
   * @param x_align Return location for the horizontal alignment policy.
   * @param y_align Return location for the vertical alignment policy.
   */
  void get_alignment(const Glib::RefPtr<Actor>& child, BoxAlignment &x_align, BoxAlignment &y_align) const;
  
  /** Sets whether @a actor should expand inside @a layout
   * 
   * @newin{1,2}
   * @param actor A Clutter::Actor child of @a layout.
   * @param expand Whether @a actor should expand.
   */
  void set_expand(const Glib::RefPtr<Actor>& child, bool expand);
  
  /** Retrieves whether @a actor should expand inside @a layout
   * 
   * @newin{1,2}
   * @param actor A Clutter::Actor child of @a layout.
   * @return <tt>true</tt> if the Clutter::Actor should expand, <tt>false</tt> otherwise.
   */
  bool get_expand(const Glib::RefPtr<Actor>& child) const;
  
  /** Sets the horizontal and vertical fill policies for @a actor
   * inside @a layout
   * 
   * @newin{1,2}
   * @param actor A Clutter::Actor child of @a layout.
   * @param x_fill Whether @a actor should fill horizontally the allocated space.
   * @param y_fill Whether @a actor should fill vertically the allocated space.
   */
  void set_fill(const Glib::RefPtr<Actor>& child, bool x_fill, bool y_fill);
   

  /** Retrieves the horizontal and vertical fill policies for @a actor
   * as set using pack() or set_fill()
   * 
   * @newin{1,2}
   * @param actor A Clutter::Actor child of @a layout.
   * @param x_fill Return location for the horizontal fill policy.
   * @param y_fill Return location for the vertical fill policy.
   */
  void get_fill(const Glib::RefPtr<Actor>& child, bool &x_fill, bool &y_fill) const;

  //gtkmmproc error: set_use_animations : method defs lookup failed (1)
  
  /** Retrieves whether @a layout should animate changes in the layout properties
   * 
   * Since set_use_animations()
   * 
   * @newin{1,2}
   * @return <tt>true</tt> if the animations should be used, <tt>false</tt> otherwise.
   */
  bool get_use_animations() const;
  
  /** Sets the duration of the animations used by @a layout when animating changes
   * in the layout properties
   * 
   * Use set_use_animations() to enable and disable the
   * animations
   * 
   * @newin{1,2}
   * @param msecs The duration of the animations, in milliseconds.
   */
  void set_easing_duration(guint msecs);
  
  /** Retrieves the duration set using set_easing_duration()
   * 
   * @newin{1,2}
   * @return The duration of the animations, in milliseconds.
   */
  guint get_easing_duration() const;
  
  /** Sets the easing mode to be used by @a layout when animating changes in layout
   * properties
   * 
   * Use set_use_animations() to enable and disable the
   * animations
   * 
   * @newin{1,2}
   * @param mode An easing mode, either from Clutter::AnimationMode or a logical id
   * from Clutter::Alpha::register_func().
   */
  void set_easing_mode(gulong mode);
  
  /** Retrieves the easing mode set using set_easing_mode()
   * 
   * @newin{1,2}
   * @return An easing mode.
   */
  gulong get_easing_mode() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The duration of the animations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_easing_duration() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The duration of the animations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_easing_duration() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The easing mode of the animations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<unsigned long> property_easing_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The easing mode of the animations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<unsigned long> property_easing_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the layout should be homogeneous, i.e. all children get the same size.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_homogeneous() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the layout should be homogeneous, i.e. all children get the same size.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_homogeneous() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to pack items at the start of the box.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_pack_start() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to pack items at the start of the box.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_pack_start() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Spacing between children.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_spacing() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Spacing between children.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_spacing() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether layout changes should be animated.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_animations() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether layout changes should be animated.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_animations() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the layout should be vertical, rather than horizontal.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_vertical() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the layout should be vertical, rather than horizontal.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_vertical() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::BoxLayout
   */
  Glib::RefPtr<Clutter::BoxLayout> wrap(ClutterBoxLayout* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BOX_LAYOUT_H */

