// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_FLOW_LAYOUT_H
#define _CLUTTERMM_FLOW_LAYOUT_H


#include <glibmm.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/layout-manager.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterFlowLayout ClutterFlowLayout;
typedef struct _ClutterFlowLayoutClass ClutterFlowLayoutClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class FlowLayout_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/**
 * @ingroup cluttermmEnums
 */
enum FlowOrientation
{
  FLOW_HORIZONTAL,
  FLOW_VERTICAL
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::FlowOrientation> : public Glib::Value_Enum<Clutter::FlowOrientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class FlowLayout :
    public LayoutManager
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef FlowLayout CppObjectType;
  typedef FlowLayout_Class CppClassType;
  typedef ClutterFlowLayout BaseObjectType;
  typedef ClutterFlowLayoutClass BaseClassType;

private:  friend class FlowLayout_Class;
  static CppClassType flowlayout_class_;

private:
  // noncopyable
  FlowLayout(const FlowLayout&);
  FlowLayout& operator=(const FlowLayout&);

protected:
  explicit FlowLayout(const Glib::ConstructParams& construct_params);
  explicit FlowLayout(ClutterFlowLayout* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~FlowLayout();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterFlowLayout*       gobj()       { return reinterpret_cast<ClutterFlowLayout*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterFlowLayout* gobj() const { return reinterpret_cast<ClutterFlowLayout*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterFlowLayout* gobj_copy();

private:


protected:
  explicit FlowLayout(FlowOrientation orientation);

public:
  
  static Glib::RefPtr<FlowLayout> create(FlowOrientation orientation);


  /** Sets whether the @a layout should allocate the same space for
   * each child
   * 
   * @newin{1,2}
   * @param homogeneous Whether the layout should be homogeneous or not.
   */
  void set_homogeneous(bool homogeneous);
  
  /** Retrieves whether the @a layout is homogeneous
   * 
   * @newin{1,2}
   * @return <tt>true</tt> if the Clutter::FlowLayout is homogeneous.
   */
  bool get_homogeneous();

  
  /** Sets the orientation of the flow layout
   * 
   * The orientation controls the direction used to allocate
   * the children: either horizontally or vertically. The
   * orientation also controls the direction of the overflowing
   * 
   * @newin{1,2}
   * @param orientation The orientation of the layout.
   */
  void set_orientation(FlowOrientation orientation);
  
  /** Retrieves the orientation of the @a layout
   * 
   * @newin{1,2}
   * @return The orientation of the Clutter::FlowLayout.
   */
  ClutterFlowOrientation get_orientation();

  
  /** Sets the space between columns, in pixels
   * 
   * @newin{1,2}
   * @param spacing The space between columns.
   */
  void set_column_spacing(float spacing);
  
  /** Retrieves the spacing between columns
   * 
   * @newin{1,2}
   * @return The spacing between columns of the Clutter::FlowLayout,
   * in pixels.
   */
  float get_column_spacing();
  
  /** Sets the spacing between rows, in pixels
   * 
   * @newin{1,2}
   * @param spacing The space between rows.
   */
  void set_row_spacing(float spacing);
  
  /** Retrieves the spacing between rows
   * 
   * @newin{1,2}
   * @return The spacing between rows of the Clutter::FlowLayout,
   * in pixels.
   */
  float get_row_spacing();
  
  /** Sets the minimum and maximum widths that a column can have
   * 
   * @newin{1,2}
   * @param min_width Minimum width of a column.
   * @param max_width Maximum width of a column.
   */
  void set_column_width(float min_width, float max_width);
  
  /** Retrieves the minimum and maximum column widths
   * 
   * @newin{1,2}
   * @param min_width Return location for the minimum column width, or <tt>0</tt>.
   * @param max_width Return location for the maximum column width, or <tt>0</tt>.
   */
  void get_column_width(float &min_width, float &max_width);
  
  /** Sets the minimum and maximum heights that a row can have
   * 
   * @newin{1,2}
   * @param min_height The minimum height of a row.
   * @param max_height The maximum height of a row.
   */
  void set_row_height(float min_height, float max_height);
  
  /** Retrieves the minimum and maximum row heights
   * 
   * @newin{1,2}
   * @param min_height Return location for the minimum row height, or <tt>0</tt>.
   * @param max_height Return location for the maximum row height, or <tt>0</tt>.
   */
  void get_row_height(float &min_height, float &max_height);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether each item should receive the same allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_homogeneous() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether each item should receive the same allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_homogeneous() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The orientation of the layout.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<FlowOrientation> property_orientation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The orientation of the layout.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<FlowOrientation> property_orientation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The spacing between columns.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_column_spacing() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The spacing between columns.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_column_spacing() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The spacing between rows.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_row_spacing() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The spacing between rows.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_row_spacing() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum width for each column.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_min_column_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum width for each column.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_min_column_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum width for each column.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_max_column_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum width for each column.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_max_column_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  //gtkmmproc error: min-row-width : property defs lookup failed.
  //gtkmmproc error: max-row-width : property defs lookup failed.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::FlowLayout
   */
  Glib::RefPtr<Clutter::FlowLayout> wrap(ClutterFlowLayout* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_FLOW_LAYOUT_H */

