/* bookmarks.c generated by valac 0.31.1.17-440e, the Vala compiler
 * generated from bookmarks.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_BOOKMARKS (bookmarks_get_type ())
#define BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS, Bookmarks))
#define BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS, BookmarksClass))
#define IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS))
#define IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS))
#define BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS, BookmarksClass))

typedef struct _Bookmarks Bookmarks;
typedef struct _BookmarksClass BookmarksClass;
typedef struct _BookmarksPrivate BookmarksPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BOOKMARK (bookmark_get_type ())
#define BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARK, Bookmark))
#define BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARK, BookmarkClass))
#define IS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARK))
#define IS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARK))
#define BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARK, BookmarkClass))

typedef struct _Bookmark Bookmark;
typedef struct _BookmarkClass BookmarkClass;
typedef struct _Block7Data Block7Data;
typedef struct _BookmarkPrivate BookmarkPrivate;

struct _Bookmarks {
	GtkMenuButton parent_instance;
	BookmarksPrivate * priv;
};

struct _BookmarksClass {
	GtkMenuButtonClass parent_class;
};

struct _BookmarksPrivate {
	GtkListBox* bookmarks_list_box;
	GtkPopover* bookmarks_popover;
	GtkImage* bookmarks_icon;
	GtkSwitch* bookmarked_switch;
	gchar* _current_path;
	gchar* _schema_id;
	GSettings* settings;
	GListStore* bookmarks_model;
};

struct _Block7Data {
	int _ref_count_;
	Bookmarks* self;
	gchar* bookmark;
};

struct _Bookmark {
	GtkGrid parent_instance;
	BookmarkPrivate * priv;
	GtkButton* destroy_button;
};

struct _BookmarkClass {
	GtkGridClass parent_class;
};

struct _BookmarkPrivate {
	gchar* _bookmark_name;
	GtkLabel* bookmark_label;
};


static gpointer bookmarks_parent_class = NULL;
static gpointer bookmark_parent_class = NULL;

GType bookmarks_get_type (void) G_GNUC_CONST;
#define BOOKMARKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOKMARKS, BookmarksPrivate))
enum  {
	BOOKMARKS_DUMMY_PROPERTY,
	BOOKMARKS_CURRENT_PATH,
	BOOKMARKS_SCHEMA_ID
};
static void bookmarks_update_icon_and_switch (Bookmarks* self);
const gchar* bookmarks_get_current_path (Bookmarks* self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void bookmarks_update_bookmarks (Bookmarks* self);
GType bookmark_get_type (void) G_GNUC_CONST;
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
Bookmark* bookmark_new (const gchar* name);
Bookmark* bookmark_construct (GType object_type, const gchar* name);
static void ____lambda9_ (Block7Data* _data7_);
static void bookmarks_remove_bookmark (Bookmarks* self, const gchar* bookmark_name);
static void _____lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GtkWidget* bookmarks_new_bookmark_row (Bookmarks* self, GObject* item);
static GtkWidget* _bookmarks_new_bookmark_row_gtk_list_box_create_widget_func (GObject* item, gpointer self);
static void bookmarks_switch_changed_cb (Bookmarks* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
void bookmarks_set_bookmarked (Bookmarks* self, gboolean new_state);
static void bookmarks_bookmark_activated_cb (Bookmarks* self, GtkListBoxRow* list_box_row);
const gchar* bookmark_get_bookmark_name (Bookmark* self);
static void _bookmarks_bookmark_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
Bookmarks* bookmarks_new (void);
Bookmarks* bookmarks_construct (GType object_type);
void bookmarks_set_current_path (Bookmarks* self, const gchar* value);
const gchar* bookmarks_get_schema_id (Bookmarks* self);
static void bookmarks_set_schema_id (Bookmarks* self, const gchar* value);
static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * bookmarks_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _bookmarks_update_bookmarks_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _bookmarks_update_icon_and_switch_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _bookmarks_update_icon_and_switch_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _bookmarks_switch_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void bookmarks_finalize (GObject* obj);
static void _vala_bookmarks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_bookmarks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define BOOKMARK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOKMARK, BookmarkPrivate))
enum  {
	BOOKMARK_DUMMY_PROPERTY,
	BOOKMARK_BOOKMARK_NAME
};
static void bookmark_set_bookmark_name (Bookmark* self, const gchar* value);
static void bookmark_finalize (GObject* obj);
static void _vala_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	for (i = 0; i < stack_length; i++) {
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			return TRUE;
#line 164 "bookmarks.c"
		}
	}
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return FALSE;
#line 169 "bookmarks.c"
}


static void bookmarks_update_icon_and_switch (Bookmarks* self) {
	gboolean is_bookmarked = FALSE;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GtkImage* _tmp8_ = NULL;
	GtkSwitch* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
#line 47 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (self != NULL);
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = self->priv->_current_path;
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = self->priv->settings;
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "bookmarks");
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp4_ = _tmp3_;
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp4__length1 = _vala_array_length (_tmp2_);
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp5_ = _vala_string_array_contains (_tmp4_, _vala_array_length (_tmp2_), _tmp0_);
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 49 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	is_bookmarked = _tmp5_;
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp7_ = is_bookmarked;
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	if (_tmp7_) {
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_tmp6_ = "starred-symbolic";
#line 211 "bookmarks.c"
	} else {
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_tmp6_ = "non-starred-symbolic";
#line 215 "bookmarks.c"
	}
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp8_ = self->priv->bookmarks_icon;
#line 50 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_object_set (_tmp8_, "icon-name", _tmp6_, NULL);
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp9_ = self->priv->bookmarked_switch;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp10_ = is_bookmarked;
#line 51 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_switch_set_active (_tmp9_, _tmp10_);
#line 227 "bookmarks.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return _data7_;
#line 236 "bookmarks.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 245 "bookmarks.c"
		Bookmarks* self;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		self = _data7_->self;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_g_free0 (_data7_->bookmark);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_g_object_unref0 (self);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		g_slice_free (Block7Data, _data7_);
#line 255 "bookmarks.c"
	}
}


static void ____lambda9_ (Block7Data* _data7_) {
	Bookmarks* self;
	const gchar* _tmp0_ = NULL;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self = _data7_->self;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = _data7_->bookmark;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_remove_bookmark (self, _tmp0_);
#line 269 "bookmarks.c"
}


static void _____lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	____lambda9_ (self);
#line 276 "bookmarks.c"
}


static GtkWidget* _bookmarks_new_bookmark_row_gtk_list_box_create_widget_func (GObject* item, gpointer self) {
	GtkWidget* result;
	result = bookmarks_new_bookmark_row ((Bookmarks*) self, item);
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return result;
#line 285 "bookmarks.c"
}


static void bookmarks_update_bookmarks (Bookmarks* self) {
	GListStore* _tmp0_ = NULL;
	gchar** bookmarks = NULL;
	GSettings* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint bookmarks_length1 = 0;
	gint _bookmarks_size_ = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GtkListBox* _tmp12_ = NULL;
	GListStore* _tmp13_ = NULL;
#line 54 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (self != NULL);
#line 56 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = g_list_store_new (TYPE_BOOKMARK);
#line 56 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->priv->bookmarks_model);
#line 56 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self->priv->bookmarks_model = _tmp0_;
#line 57 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = self->priv->settings;
#line 57 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "bookmarks");
#line 57 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks = _tmp3_;
#line 57 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_length1 = _vala_array_length (_tmp2_);
#line 57 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_bookmarks_size_ = bookmarks_length1;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp4_ = bookmarks;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp4__length1 = bookmarks_length1;
#line 323 "bookmarks.c"
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		bookmark_collection = _tmp4_;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		bookmark_collection_length1 = _tmp4__length1;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		for (bookmark_it = 0; bookmark_it < _tmp4__length1; bookmark_it = bookmark_it + 1) {
#line 335 "bookmarks.c"
			gchar* _tmp5_ = NULL;
			gchar* bookmark = NULL;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_tmp5_ = g_strdup (bookmark_collection[bookmark_it]);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			bookmark = _tmp5_;
#line 342 "bookmarks.c"
			{
				Block7Data* _data7_;
				Bookmark* bookmark_row = NULL;
				const gchar* _tmp6_ = NULL;
				Bookmark* _tmp7_ = NULL;
				Bookmark* _tmp8_ = NULL;
				GtkButton* _tmp9_ = NULL;
				GListStore* _tmp10_ = NULL;
				Bookmark* _tmp11_ = NULL;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_data7_ = g_slice_new0 (Block7Data);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_data7_->_ref_count_ = 1;
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_data7_->self = g_object_ref (self);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_data7_->bookmark = bookmark;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_tmp6_ = _data7_->bookmark;
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_tmp7_ = bookmark_new (_tmp6_);
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				g_object_ref_sink (_tmp7_);
#line 60 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				bookmark_row = _tmp7_;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_tmp8_ = bookmark_row;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_tmp9_ = _tmp8_->destroy_button;
#line 61 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				g_signal_connect_data (_tmp9_, "clicked", (GCallback) _____lambda9__gtk_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_tmp10_ = self->priv->bookmarks_model;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_tmp11_ = bookmark_row;
#line 62 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				g_list_store_append (_tmp10_, (GObject*) _tmp11_);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_g_object_unref0 (bookmark_row);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				block7_data_unref (_data7_);
#line 58 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_data7_ = NULL;
#line 386 "bookmarks.c"
			}
		}
	}
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp12_ = self->priv->bookmarks_list_box;
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp13_ = self->priv->bookmarks_model;
#line 64 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_list_box_bind_model (_tmp12_, (GListModel*) _tmp13_, _bookmarks_new_bookmark_row_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
#line 54 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks = (_vala_array_free (bookmarks, bookmarks_length1, (GDestroyNotify) g_free), NULL);
#line 398 "bookmarks.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	if ((*length) == (*size)) {
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 409 "bookmarks.c"
	}
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	(*array)[(*length)++] = value;
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	(*array)[*length] = NULL;
#line 415 "bookmarks.c"
}


static void bookmarks_switch_changed_cb (Bookmarks* self) {
	GtkPopover* _tmp0_ = NULL;
	gchar** bookmarks = NULL;
	GSettings* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint bookmarks_length1 = 0;
	gint _bookmarks_size_ = 0;
	GtkSwitch* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (self != NULL);
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = self->priv->bookmarks_popover;
#line 69 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_signal_emit_by_name (_tmp0_, "closed");
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = self->priv->settings;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "bookmarks");
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks = _tmp3_;
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_length1 = _vala_array_length (_tmp2_);
#line 71 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_bookmarks_size_ = bookmarks_length1;
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp4_ = self->priv->bookmarked_switch;
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp5_ = gtk_switch_get_active (_tmp4_);
#line 72 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	if (!_tmp5_) {
#line 451 "bookmarks.c"
		const gchar* _tmp6_ = NULL;
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_tmp6_ = self->priv->_current_path;
#line 73 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		bookmarks_remove_bookmark (self, _tmp6_);
#line 457 "bookmarks.c"
	} else {
		const gchar* _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_tmp7_ = self->priv->_current_path;
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_tmp8_ = bookmarks;
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_tmp8__length1 = bookmarks_length1;
#line 74 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		if (!_vala_string_array_contains (_tmp8_, _tmp8__length1, _tmp7_)) {
#line 470 "bookmarks.c"
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			GSettings* _tmp12_ = NULL;
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_tmp9_ = bookmarks;
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_tmp9__length1 = bookmarks_length1;
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_tmp10_ = self->priv->_current_path;
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 76 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_vala_array_add1 (&bookmarks, &bookmarks_length1, &_bookmarks_size_, _tmp11_);
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_tmp12_ = self->priv->settings;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_tmp13_ = bookmarks;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_tmp13__length1 = bookmarks_length1;
#line 77 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			g_settings_set_strv (_tmp12_, "bookmarks", _tmp13_);
#line 496 "bookmarks.c"
		}
	}
#line 67 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks = (_vala_array_free (bookmarks, bookmarks_length1, (GDestroyNotify) g_free), NULL);
#line 501 "bookmarks.c"
}


void bookmarks_set_bookmarked (Bookmarks* self, gboolean new_state) {
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 81 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (self != NULL);
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = self->priv->bookmarked_switch;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = gtk_switch_get_active (_tmp0_);
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp2_ = new_state;
#line 83 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	if (_tmp1_ != _tmp2_) {
#line 519 "bookmarks.c"
		GtkSwitch* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_tmp3_ = self->priv->bookmarked_switch;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_tmp4_ = new_state;
#line 84 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		gtk_switch_set_active (_tmp3_, _tmp4_);
#line 528 "bookmarks.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return self ? g_object_ref (self) : NULL;
#line 536 "bookmarks.c"
}


static GtkWidget* bookmarks_new_bookmark_row (Bookmarks* self, GObject* item) {
	GtkWidget* result = NULL;
	GObject* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = item;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = _g_object_ref0 ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_BOOKMARK, Bookmark));
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	result = _tmp1_;
#line 89 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return result;
#line 556 "bookmarks.c"
}


static void bookmarks_bookmark_activated_cb (Bookmarks* self, GtkListBoxRow* list_box_row) {
	GtkPopover* _tmp0_ = NULL;
	gchar* bookmark = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (self != NULL);
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (list_box_row != NULL);
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = self->priv->bookmarks_popover;
#line 95 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_signal_emit_by_name (_tmp0_, "closed");
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = list_box_row;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp2_ = gtk_bin_get_child ((GtkBin*) _tmp1_);
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp3_ = bookmark_get_bookmark_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_BOOKMARK, Bookmark));
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp4_ = _tmp3_;
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 96 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmark = _tmp5_;
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp6_ = bookmark;
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_signal_emit_by_name (self, "bookmark-activated", _tmp6_, &_tmp7_);
#line 97 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	if (!_tmp7_) {
#line 596 "bookmarks.c"
		const gchar* _tmp8_ = NULL;
#line 98 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		_tmp8_ = bookmark;
#line 98 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		g_warning ("bookmarks.vala:98: broken bookmark: %s", _tmp8_);
#line 602 "bookmarks.c"
	}
#line 93 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_free0 (bookmark);
#line 606 "bookmarks.c"
}


static void _bookmarks_bookmark_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_bookmark_activated_cb ((Bookmarks*) self, row);
#line 613 "bookmarks.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	if ((*length) == (*size)) {
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 624 "bookmarks.c"
	}
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	(*array)[(*length)++] = value;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	(*array)[*length] = NULL;
#line 630 "bookmarks.c"
}


static void bookmarks_remove_bookmark (Bookmarks* self, const gchar* bookmark_name) {
	GtkPopover* _tmp0_ = NULL;
	gchar** old_bookmarks = NULL;
	GSettings* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint old_bookmarks_length1 = 0;
	gint _old_bookmarks_size_ = 0;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** new_bookmarks = NULL;
	gchar** _tmp6_ = NULL;
	gint new_bookmarks_length1 = 0;
	gint _new_bookmarks_size_ = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GSettings* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (self != NULL);
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (bookmark_name != NULL);
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = self->priv->bookmarks_popover;
#line 103 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_signal_emit_by_name (_tmp0_, "closed");
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = self->priv->settings;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "bookmarks");
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	old_bookmarks = _tmp3_;
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	old_bookmarks_length1 = _vala_array_length (_tmp2_);
#line 104 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_old_bookmarks_size_ = old_bookmarks_length1;
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp4_ = bookmark_name;
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp5_ = old_bookmarks;
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp5__length1 = old_bookmarks_length1;
#line 105 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	if (!_vala_string_array_contains (_tmp5_, _tmp5__length1, _tmp4_)) {
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		old_bookmarks = (_vala_array_free (old_bookmarks, old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
#line 106 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		return;
#line 684 "bookmarks.c"
	}
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp6_ = g_new0 (gchar*, 0 + 1);
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	new_bookmarks = _tmp6_;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	new_bookmarks_length1 = 0;
#line 107 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_new_bookmarks_size_ = new_bookmarks_length1;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp7_ = old_bookmarks;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp7__length1 = old_bookmarks_length1;
#line 698 "bookmarks.c"
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		bookmark_collection = _tmp7_;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		bookmark_collection_length1 = _tmp7__length1;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		for (bookmark_it = 0; bookmark_it < _tmp7__length1; bookmark_it = bookmark_it + 1) {
#line 710 "bookmarks.c"
			gchar* _tmp8_ = NULL;
			gchar* bookmark = NULL;
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			_tmp8_ = g_strdup (bookmark_collection[bookmark_it]);
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
			bookmark = _tmp8_;
#line 717 "bookmarks.c"
			{
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_tmp9_ = bookmark;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_tmp10_ = bookmark_name;
#line 109 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				if (g_strcmp0 (_tmp9_, _tmp10_) != 0) {
#line 727 "bookmarks.c"
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
					_tmp11_ = new_bookmarks;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
					_tmp11__length1 = new_bookmarks_length1;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
					_tmp12_ = bookmark;
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
					_tmp13_ = g_strdup (_tmp12_);
#line 110 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
					_vala_array_add2 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp13_);
#line 742 "bookmarks.c"
				}
#line 108 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
				_g_free0 (bookmark);
#line 746 "bookmarks.c"
			}
		}
	}
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp14_ = self->priv->settings;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp15_ = new_bookmarks;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp15__length1 = new_bookmarks_length1;
#line 111 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_settings_set_strv (_tmp14_, "bookmarks", _tmp15_);
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	new_bookmarks = (_vala_array_free (new_bookmarks, new_bookmarks_length1, (GDestroyNotify) g_free), NULL);
#line 101 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	old_bookmarks = (_vala_array_free (old_bookmarks, old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
#line 762 "bookmarks.c"
}


Bookmarks* bookmarks_construct (GType object_type) {
	Bookmarks * self = NULL;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self = (Bookmarks*) g_object_new (object_type, NULL);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return self;
#line 772 "bookmarks.c"
}


Bookmarks* bookmarks_new (void) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return bookmarks_construct (TYPE_BOOKMARKS);
#line 779 "bookmarks.c"
}


const gchar* bookmarks_get_current_path (Bookmarks* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = self->priv->_current_path;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	result = _tmp0_;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return result;
#line 794 "bookmarks.c"
}


void bookmarks_set_current_path (Bookmarks* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (self != NULL);
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = value;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_free0 (self->priv->_current_path);
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self->priv->_current_path = _tmp1_;
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_object_notify ((GObject *) self, "current-path");
#line 813 "bookmarks.c"
}


const gchar* bookmarks_get_schema_id (Bookmarks* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = self->priv->_schema_id;
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	result = _tmp0_;
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return result;
#line 828 "bookmarks.c"
}


static void bookmarks_set_schema_id (Bookmarks* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (self != NULL);
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = value;
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_free0 (self->priv->_schema_id);
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self->priv->_schema_id = _tmp1_;
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_object_notify ((GObject *) self, "schema-id");
#line 847 "bookmarks.c"
}


static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING) (gpointer data1, const char* arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (return_value != NULL);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (n_param_values == 2);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		data1 = closure->data;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		data2 = param_values->data[0].v_pointer;
#line 869 "bookmarks.c"
	} else {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		data1 = param_values->data[0].v_pointer;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		data2 = closure->data;
#line 875 "bookmarks.c"
	}
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	callback = (GMarshalFunc_BOOLEAN__STRING) (marshal_data ? marshal_data : cc->callback);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	v_return = callback (data1, g_value_get_string (param_values + 1), data2);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_value_set_boolean (return_value, v_return);
#line 883 "bookmarks.c"
}


static void _bookmarks_update_bookmarks_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 39 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_update_bookmarks ((Bookmarks*) self);
#line 890 "bookmarks.c"
}


static void _bookmarks_update_icon_and_switch_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_update_icon_and_switch ((Bookmarks*) self);
#line 897 "bookmarks.c"
}


static void _bookmarks_update_icon_and_switch_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_update_icon_and_switch ((Bookmarks*) self);
#line 904 "bookmarks.c"
}


static void _bookmarks_switch_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_switch_changed_cb ((Bookmarks*) self);
#line 911 "bookmarks.c"
}


static GObject * bookmarks_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Bookmarks * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	GtkSwitch* _tmp4_ = NULL;
	GtkSwitch* _tmp5_ = NULL;
#line 36 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	parent_class = G_OBJECT_CLASS (bookmarks_parent_class);
#line 36 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 36 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS, Bookmarks);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = self->priv->_schema_id;
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = g_settings_new (_tmp0_);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->priv->settings);
#line 38 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self->priv->settings = _tmp1_;
#line 39 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp2_ = self->priv->settings;
#line 39 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_signal_connect_object (_tmp2_, "changed::bookmarks", (GCallback) _bookmarks_update_bookmarks_g_settings_changed, self, 0);
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp3_ = self->priv->settings;
#line 40 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_signal_connect_object (_tmp3_, "changed::bookmarks", (GCallback) _bookmarks_update_icon_and_switch_g_settings_changed, self, 0);
#line 41 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_signal_connect_object ((GObject*) self, "notify::current-path", (GCallback) _bookmarks_update_icon_and_switch_g_object_notify, self, 0);
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp4_ = self->priv->bookmarked_switch;
#line 42 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_signal_connect_object ((GObject*) _tmp4_, "notify::active", (GCallback) _bookmarks_switch_changed_cb_g_object_notify, self, 0);
#line 43 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_update_bookmarks (self);
#line 44 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp5_ = self->priv->bookmarked_switch;
#line 44 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
#line 36 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return obj;
#line 961 "bookmarks.c"
}


static void bookmarks_class_init (BookmarksClass * klass) {
	gint Bookmarks_private_offset;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmarks_parent_class = g_type_class_peek_parent (klass);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_type_class_add_private (klass, sizeof (BookmarksPrivate));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_bookmarks_get_property;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_bookmarks_set_property;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	G_OBJECT_CLASS (klass)->constructor = bookmarks_constructor;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	G_OBJECT_CLASS (klass)->finalize = bookmarks_finalize;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKMARKS_CURRENT_PATH, g_param_spec_string ("current-path", "current-path", "current-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKMARKS_SCHEMA_ID, g_param_spec_string ("schema-id", "schema-id", "schema-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	Bookmarks_private_offset = g_type_class_get_instance_private_offset (klass);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/bookmarks.ui");
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_signal_new ("bookmark_activated", TYPE_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING, G_TYPE_BOOLEAN, 1, G_TYPE_STRING);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_list_box", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, bookmarks_list_box));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_popover", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, bookmarks_popover));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_icon", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, bookmarks_icon));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarked_switch", FALSE, Bookmarks_private_offset + G_STRUCT_OFFSET (BookmarksPrivate, bookmarked_switch));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "bookmark_activated_cb", G_CALLBACK(_bookmarks_bookmark_activated_cb_gtk_list_box_row_activated));
#line 999 "bookmarks.c"
}


static void bookmarks_instance_init (Bookmarks * self) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self->priv = BOOKMARKS_GET_PRIVATE (self);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 1008 "bookmarks.c"
}


static void bookmarks_finalize (GObject* obj) {
	Bookmarks * self;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS, Bookmarks);
#line 23 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->priv->bookmarks_list_box);
#line 24 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->priv->bookmarks_popover);
#line 26 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->priv->bookmarks_icon);
#line 27 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->priv->bookmarked_switch);
#line 28 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_free0 (self->priv->_current_path);
#line 30 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_free0 (self->priv->_schema_id);
#line 31 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->priv->settings);
#line 32 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->priv->bookmarks_model);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	G_OBJECT_CLASS (bookmarks_parent_class)->finalize (obj);
#line 1034 "bookmarks.c"
}


GType bookmarks_get_type (void) {
	static volatile gsize bookmarks_type_id__volatile = 0;
	if (g_once_init_enter (&bookmarks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BookmarksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookmarks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Bookmarks), 0, (GInstanceInitFunc) bookmarks_instance_init, NULL };
		GType bookmarks_type_id;
		bookmarks_type_id = g_type_register_static (gtk_menu_button_get_type (), "Bookmarks", &g_define_type_info, 0);
		g_once_init_leave (&bookmarks_type_id__volatile, bookmarks_type_id);
	}
	return bookmarks_type_id__volatile;
}


static void _vala_bookmarks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Bookmarks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARKS, Bookmarks);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	switch (property_id) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		case BOOKMARKS_CURRENT_PATH:
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		g_value_set_string (value, bookmarks_get_current_path (self));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		case BOOKMARKS_SCHEMA_ID:
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		g_value_set_string (value, bookmarks_get_schema_id (self));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 1067 "bookmarks.c"
		default:
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 1073 "bookmarks.c"
	}
}


static void _vala_bookmarks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Bookmarks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARKS, Bookmarks);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	switch (property_id) {
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		case BOOKMARKS_CURRENT_PATH:
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		bookmarks_set_current_path (self, g_value_get_string (value));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		case BOOKMARKS_SCHEMA_ID:
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		bookmarks_set_schema_id (self, g_value_get_string (value));
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 1095 "bookmarks.c"
		default:
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 1101 "bookmarks.c"
	}
}


Bookmark* bookmark_construct (GType object_type, const gchar* name) {
	Bookmark * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 123 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 123 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self = (Bookmark*) g_object_new (object_type, NULL);
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = name;
#line 125 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmark_set_bookmark_name (self, _tmp0_);
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = self->priv->bookmark_label;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp2_ = name;
#line 126 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_label_set_label (_tmp1_, _tmp2_);
#line 123 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return self;
#line 1127 "bookmarks.c"
}


Bookmark* bookmark_new (const gchar* name) {
#line 123 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return bookmark_construct (TYPE_BOOKMARK, name);
#line 1134 "bookmarks.c"
}


const gchar* bookmark_get_bookmark_name (Bookmark* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = self->priv->_bookmark_name;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	result = _tmp0_;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	return result;
#line 1149 "bookmarks.c"
}


static void bookmark_set_bookmark_name (Bookmark* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_return_if_fail (self != NULL);
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp0_ = value;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_free0 (self->priv->_bookmark_name);
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self->priv->_bookmark_name = _tmp1_;
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_object_notify ((GObject *) self, "bookmark-name");
#line 1168 "bookmarks.c"
}


static void bookmark_class_init (BookmarkClass * klass) {
	gint Bookmark_private_offset;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	bookmark_parent_class = g_type_class_peek_parent (klass);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_type_class_add_private (klass, sizeof (BookmarkPrivate));
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_bookmark_get_property;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_bookmark_set_property;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	G_OBJECT_CLASS (klass)->finalize = bookmark_finalize;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKMARK_BOOKMARK_NAME, g_param_spec_string ("bookmark-name", "bookmark-name", "bookmark-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	Bookmark_private_offset = g_type_class_get_instance_private_offset (klass);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/bookmark.ui");
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmark_label", FALSE, Bookmark_private_offset + G_STRUCT_OFFSET (BookmarkPrivate, bookmark_label));
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "destroy_button", FALSE, G_STRUCT_OFFSET (Bookmark, destroy_button));
#line 1194 "bookmarks.c"
}


static void bookmark_instance_init (Bookmark * self) {
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self->priv = BOOKMARK_GET_PRIVATE (self);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 1203 "bookmarks.c"
}


static void bookmark_finalize (GObject* obj) {
	Bookmark * self;
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARK, Bookmark);
#line 118 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_free0 (self->priv->_bookmark_name);
#line 120 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->priv->bookmark_label);
#line 121 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	_g_object_unref0 (self->destroy_button);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	G_OBJECT_CLASS (bookmark_parent_class)->finalize (obj);
#line 1219 "bookmarks.c"
}


GType bookmark_get_type (void) {
	static volatile gsize bookmark_type_id__volatile = 0;
	if (g_once_init_enter (&bookmark_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BookmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Bookmark), 0, (GInstanceInitFunc) bookmark_instance_init, NULL };
		GType bookmark_type_id;
		bookmark_type_id = g_type_register_static (gtk_grid_get_type (), "Bookmark", &g_define_type_info, 0);
		g_once_init_leave (&bookmark_type_id__volatile, bookmark_type_id);
	}
	return bookmark_type_id__volatile;
}


static void _vala_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Bookmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARK, Bookmark);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	switch (property_id) {
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		case BOOKMARK_BOOKMARK_NAME:
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		g_value_set_string (value, bookmark_get_bookmark_name (self));
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 1246 "bookmarks.c"
		default:
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 1252 "bookmarks.c"
	}
}


static void _vala_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Bookmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARK, Bookmark);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
	switch (property_id) {
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		case BOOKMARK_BOOKMARK_NAME:
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		bookmark_set_bookmark_name (self, g_value_get_string (value));
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 1268 "bookmarks.c"
		default:
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 116 "/run/media/triton/Guerre/jhbuild/jhbuild/dconf-editor/editor/bookmarks.vala"
		break;
#line 1274 "bookmarks.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



