/* dconf-window.c generated by valac 0.34.11.5-fb636, the Vala compiler
 * generated from dconf-window.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define TYPE_BEHAVIOUR (behaviour_get_type ())

#define TYPE_DCONF_WINDOW (dconf_window_get_type ())
#define DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_WINDOW, DConfWindow))
#define DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_WINDOW, DConfWindowClass))
#define IS_DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_WINDOW))
#define IS_DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_WINDOW))
#define DCONF_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_WINDOW, DConfWindowClass))

typedef struct _DConfWindow DConfWindow;
typedef struct _DConfWindowClass DConfWindowClass;
typedef struct _DConfWindowPrivate DConfWindowPrivate;

#define TYPE_BOOKMARKS (bookmarks_get_type ())
#define BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS, Bookmarks))
#define BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS, BookmarksClass))
#define IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS))
#define IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS))
#define BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS, BookmarksClass))

typedef struct _Bookmarks Bookmarks;
typedef struct _BookmarksClass BookmarksClass;

#define TYPE_PATH_BAR (path_bar_get_type ())
#define PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_BAR, PathBar))
#define PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_BAR, PathBarClass))
#define IS_PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_BAR))
#define IS_PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_BAR))
#define PATH_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_BAR, PathBarClass))

typedef struct _PathBar PathBar;
typedef struct _PathBarClass PathBarClass;

#define TYPE_REGISTRY_VIEW (registry_view_get_type ())
#define REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VIEW, RegistryView))
#define REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VIEW, RegistryViewClass))
#define IS_REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VIEW))
#define IS_REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VIEW))
#define REGISTRY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VIEW, RegistryViewClass))

typedef struct _RegistryView RegistryView;
typedef struct _RegistryViewClass RegistryViewClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

#define TYPE_CONFIGURATION_EDITOR (configuration_editor_get_type ())
#define CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditor))
#define CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))
#define IS_CONFIGURATION_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_EDITOR))
#define IS_CONFIGURATION_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_EDITOR))
#define CONFIGURATION_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_EDITOR, ConfigurationEditorClass))

typedef struct _ConfigurationEditor ConfigurationEditor;
typedef struct _ConfigurationEditorClass ConfigurationEditorClass;

#define TYPE_PATH_ELEMENT (path_element_get_type ())
#define PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_ELEMENT, PathElement))
#define IS_PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_ELEMENT))
#define PATH_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATH_ELEMENT, PathElementIface))

typedef struct _PathElement PathElement;
typedef struct _PathElementIface PathElementIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	BEHAVIOUR_UNSAFE,
	BEHAVIOUR_SAFE,
	BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT,
	BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT,
	BEHAVIOUR_ALWAYS_DELAY
} Behaviour;

struct _DConfWindow {
	GtkApplicationWindow parent_instance;
	DConfWindowPrivate * priv;
};

struct _DConfWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _DConfWindowPrivate {
	gchar* _current_path;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_tiled;
	GSettings* settings;
	Bookmarks* bookmarks_button;
	GtkMenuButton* info_button;
	PathBar* pathbar;
	RegistryView* registry_view;
	GtkRevealer* notification_revealer;
	GtkLabel* notification_label;
	gulong behaviour_changed_handler;
	gulong small_keys_list_rows_handler;
	gulong small_bookmarks_rows_handler;
};

struct _Block1Data {
	int _ref_count_;
	DConfWindow* self;
	GtkStyleContext* context;
};

struct _Block2Data {
	int _ref_count_;
	DConfWindow* self;
	GtkCheckButton* checkbutton;
};

struct _PathElementIface {
	GTypeInterface parent_iface;
};


static gpointer dconf_window_parent_class = NULL;

GType behaviour_get_type (void) G_GNUC_CONST;
GType dconf_window_get_type (void) G_GNUC_CONST;
GType bookmarks_get_type (void) G_GNUC_CONST;
GType path_bar_get_type (void) G_GNUC_CONST;
GType registry_view_get_type (void) G_GNUC_CONST;
#define DCONF_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DCONF_WINDOW, DConfWindowPrivate))
enum  {
	DCONF_WINDOW_0_PROPERTY,
	DCONF_WINDOW_CURRENT_PATH_PROPERTY
};
static void dconf_window_open_path (DConfWindow* self, GSimpleAction* action, GVariant* path_variant);
static void _dconf_window_open_path_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_reset_recursively (DConfWindow* self);
static void _dconf_window_reset_recursively_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_reset (DConfWindow* self);
static void _dconf_window_reset_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void dconf_window_enter_delay_mode (DConfWindow* self);
static void _dconf_window_enter_delay_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
DConfWindow* dconf_window_new (void);
DConfWindow* dconf_window_construct (GType object_type);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void registry_view_invalidate_popovers (RegistryView* self);
static void _registry_view_invalidate_popovers_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda83_ (Block1Data* _data1_);
static void ___lambda83__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda84_ (Block1Data* _data1_);
static void ___lambda84__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void registry_view_init (RegistryView* self, const gchar* path, gboolean restore_view);
gchar* dconf_window_stripped_path (const gchar* path);
GtkWidget* _dconf_window_get_parent (GtkWidget* widget);
static void dconf_window_on_show (DConfWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda85_ (Block2Data* _data2_);
static void ___lambda85__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _dconf_window_on_show_gtk_widget_show (GtkWidget* _sender, gpointer self);
static gboolean dconf_window_on_window_state_event (DConfWindow* self, GtkWidget* widget, GdkEventWindowState* event);
static gboolean _dconf_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void dconf_window_on_size_allocate (DConfWindow* self, GtkAllocation* allocation);
static gint* _int_dup (gint* self);
static void _dconf_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static void dconf_window_on_destroy (DConfWindow* self);
GType configuration_editor_get_type (void) G_GNUC_CONST;
void configuration_editor_clean_copy_notification (ConfigurationEditor* self);
static const gchar* dconf_window_get_current_path (DConfWindow* self);
static void _dconf_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void dconf_window_request_path (DConfWindow* self, const gchar* full_name);
void registry_view_set_search_mode (RegistryView* self, gboolean* mode);
void registry_view_path_requested (RegistryView* self, const gchar* _full_name, const gchar* selected);
gchar* path_bar_get_selected_child (PathBar* self, const gchar* current_path);
GType path_element_get_type (void) G_GNUC_CONST;
static void _dconf_window_request_path_path_element_request_path (PathElement* _sender, const gchar* path, gpointer self);
void dconf_window_update_path_elements (DConfWindow* self);
void bookmarks_set_path (Bookmarks* self, const gchar* path);
void path_bar_set_path (PathBar* self, const gchar* path);
void dconf_window_update_hamburger_menu (DConfWindow* self);
gboolean registry_view_get_current_delay_mode (RegistryView* self);
void registry_view_reset (RegistryView* self, gboolean recursively);
void registry_view_enter_delay_mode (RegistryView* self);
static gboolean dconf_window_on_key_press_event (DConfWindow* self, GtkWidget* widget, GdkEventKey* event);
void registry_view_discard_row_popover (RegistryView* self);
void bookmarks_set_bookmarked (Bookmarks* self, gboolean new_state);
gchar* registry_view_get_copy_text (RegistryView* self);
void configuration_editor_copy (ConfigurationEditor* self, const gchar* text);
void configuration_editor_about_cb (ConfigurationEditor* self);
gboolean path_bar_open_child (PathBar* self, const gchar* current_path);
gboolean registry_view_show_row_popover (RegistryView* self);
gboolean registry_view_handle_search_event (RegistryView* self, GdkEventKey* event);
static gboolean _dconf_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void dconf_window_on_menu_button_clicked (DConfWindow* self);
static void _dconf_window_on_menu_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void dconf_window_show_notification (DConfWindow* self, const gchar* notification);
static void dconf_window_hide_notification (DConfWindow* self);
static void _dconf_window_hide_notification_gtk_button_clicked (GtkButton* _sender, gpointer self);
void dconf_window_set_current_path (DConfWindow* self, const gchar* value);
static void dconf_window_finalize (GObject* obj);
static void _vala_dconf_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dconf_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry DCONF_WINDOW_action_entries[4] = {{"open-path", _dconf_window_open_path_gsimple_action_activate_callback, "s"}, {"reset-recursive", _dconf_window_reset_recursively_gsimple_action_activate_callback}, {"reset-visible", _dconf_window_reset_gsimple_action_activate_callback}, {"enter-delay-mode", _dconf_window_enter_delay_mode_gsimple_action_activate_callback}};

GType behaviour_get_type (void) {
	static volatile gsize behaviour_type_id__volatile = 0;
	if (g_once_init_enter (&behaviour_type_id__volatile)) {
		static const GEnumValue values[] = {{BEHAVIOUR_UNSAFE, "BEHAVIOUR_UNSAFE", "unsafe"}, {BEHAVIOUR_SAFE, "BEHAVIOUR_SAFE", "safe"}, {BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT", "always-confirm-implicit"}, {BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT", "always-confirm-explicit"}, {BEHAVIOUR_ALWAYS_DELAY, "BEHAVIOUR_ALWAYS_DELAY", "always-delay"}, {0, NULL, NULL}};
		GType behaviour_type_id;
		behaviour_type_id = g_enum_register_static ("Behaviour", values);
		g_once_init_leave (&behaviour_type_id__volatile, behaviour_type_id);
	}
	return behaviour_type_id__volatile;
}


static void _dconf_window_open_path_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	dconf_window_open_path ((DConfWindow*) self, action, parameter);
}


static void _dconf_window_reset_recursively_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	dconf_window_reset_recursively ((DConfWindow*) self);
}


static void _dconf_window_reset_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	dconf_window_reset ((DConfWindow*) self);
}


static void _dconf_window_enter_delay_mode_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	dconf_window_enter_delay_mode ((DConfWindow*) self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DConfWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->context);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _registry_view_invalidate_popovers_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	registry_view_invalidate_popovers ((RegistryView*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda83_ (Block1Data* _data1_) {
	DConfWindow* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = _data1_->self;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "small-keys-list-rows");
	if (_tmp1_) {
		GtkStyleContext* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = _data1_->context;
		_tmp3_ = gtk_style_context_has_class (_tmp2_, "small-keys-list-rows");
		if (!_tmp3_) {
			GtkStyleContext* _tmp4_ = NULL;
			_tmp4_ = _data1_->context;
			gtk_style_context_add_class (_tmp4_, "small-keys-list-rows");
		}
	} else {
		GtkStyleContext* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = _data1_->context;
		_tmp6_ = gtk_style_context_has_class (_tmp5_, "small-keys-list-rows");
		if (_tmp6_) {
			GtkStyleContext* _tmp7_ = NULL;
			_tmp7_ = _data1_->context;
			gtk_style_context_remove_class (_tmp7_, "small-keys-list-rows");
		}
	}
}


static void ___lambda83__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda83_ (self);
}


static void __lambda84_ (Block1Data* _data1_) {
	DConfWindow* self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = _data1_->self;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "small-bookmarks-rows");
	if (_tmp1_) {
		GtkStyleContext* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = _data1_->context;
		_tmp3_ = gtk_style_context_has_class (_tmp2_, "small-bookmarks-rows");
		if (!_tmp3_) {
			GtkStyleContext* _tmp4_ = NULL;
			_tmp4_ = _data1_->context;
			gtk_style_context_add_class (_tmp4_, "small-bookmarks-rows");
		}
	} else {
		GtkStyleContext* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = _data1_->context;
		_tmp6_ = gtk_style_context_has_class (_tmp5_, "small-bookmarks-rows");
		if (_tmp6_) {
			GtkStyleContext* _tmp7_ = NULL;
			_tmp7_ = _data1_->context;
			gtk_style_context_remove_class (_tmp7_, "small-bookmarks-rows");
		}
	}
}


static void ___lambda84__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda84_ (self);
}


DConfWindow* dconf_window_construct (GType object_type) {
	DConfWindow * self = NULL;
	Block1Data* _data1_;
	GSettings* _tmp0_ = NULL;
	RegistryView* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkStyleContext* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	gulong _tmp12_ = 0UL;
	GSettings* _tmp13_ = NULL;
	gulong _tmp14_ = 0UL;
	GSettings* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GSettings* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	RegistryView* _tmp21_ = NULL;
	GSettings* _tmp22_ = NULL;
	RegistryView* _tmp23_ = NULL;
	RegistryView* _tmp24_ = NULL;
	GSettings* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GSettings* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (DConfWindow*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	g_action_map_add_action_entries ((GActionMap*) self, DCONF_WINDOW_action_entries, G_N_ELEMENTS (DCONF_WINDOW_action_entries), self);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->registry_view;
	_tmp2_ = g_signal_connect_object (_tmp0_, "changed::behaviour", (GCallback) _registry_view_invalidate_popovers_g_settings_changed, _tmp1_, 0);
	self->priv->behaviour_changed_handler = _tmp2_;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, "window-width");
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_get_int (_tmp5_, "window-height");
	gtk_window_set_default_size ((GtkWindow*) self, _tmp4_, _tmp6_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_boolean (_tmp7_, "window-is-maximized");
	if (_tmp8_) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_data1_->context = _tmp10_;
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_signal_connect_data (_tmp11_, "changed::small-keys-list-rows", (GCallback) ___lambda83__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	self->priv->small_keys_list_rows_handler = _tmp12_;
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_signal_connect_data (_tmp13_, "changed::small-bookmarks-rows", (GCallback) ___lambda84__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	self->priv->small_bookmarks_rows_handler = _tmp14_;
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_boolean (_tmp15_, "small-keys-list-rows");
	if (_tmp16_) {
		GtkStyleContext* _tmp17_ = NULL;
		_tmp17_ = _data1_->context;
		gtk_style_context_add_class (_tmp17_, "small-keys-list-rows");
	}
	_tmp18_ = self->priv->settings;
	_tmp19_ = g_settings_get_boolean (_tmp18_, "small-bookmarks-rows");
	if (_tmp19_) {
		GtkStyleContext* _tmp20_ = NULL;
		_tmp20_ = _data1_->context;
		gtk_style_context_add_class (_tmp20_, "small-bookmarks-rows");
	}
	_tmp21_ = self->priv->registry_view;
	g_object_bind_property_with_closures ((GObject*) _tmp21_, "current-path", (GObject*) self, "current-path", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp22_ = self->priv->settings;
	_tmp23_ = self->priv->registry_view;
	g_settings_bind (_tmp22_, "behaviour", (GObject*) _tmp23_, "behaviour", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_NO_SENSITIVITY);
	_tmp24_ = self->priv->registry_view;
	_tmp25_ = self->priv->settings;
	_tmp26_ = g_settings_get_string (_tmp25_, "saved-view");
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->settings;
	_tmp29_ = g_settings_get_boolean (_tmp28_, "restore-view");
	registry_view_init (_tmp24_, _tmp27_, _tmp29_);
	_g_free0 (_tmp27_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


DConfWindow* dconf_window_new (void) {
	return dconf_window_construct (TYPE_DCONF_WINDOW);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* dconf_window_stripped_path (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= 1) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("/");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = path;
	_tmp5_ = path;
	_tmp6_ = string_last_index_of_char (_tmp5_, (gunichar) '/', 0);
	_tmp7_ = string_slice (_tmp4_, (glong) 0, (glong) (_tmp6_ + 1));
	result = _tmp7_;
	return result;
}


GtkWidget* _dconf_window_get_parent (GtkWidget* widget) {
	GtkWidget* result = NULL;
	GtkWidget* parent = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = widget;
	_tmp1_ = (GtkContainer*) gtk_widget_get_parent (_tmp0_);
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
	parent = _tmp2_;
	if (parent == NULL) {
		g_assert_not_reached ();
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (parent, gtk_widget_get_type (), GtkWidget));
	result = _tmp3_;
	_g_object_unref0 (parent);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		DConfWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->checkbutton);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda85_ (Block2Data* _data2_) {
	DConfWindow* self;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = _data2_->self;
	_tmp0_ = _data2_->checkbutton;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GSettings* _tmp3_ = NULL;
		_tmp3_ = self->priv->settings;
		g_settings_set_boolean (_tmp3_, "show-warning", FALSE);
	}
}


static void ___lambda85__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda85_ (self);
}


static void dconf_window_on_show (DConfWindow* self) {
	Block2Data* _data2_;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkBox* box = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkCheckButton* _tmp12_ = NULL;
	GtkCheckButton* _tmp13_ = NULL;
	GtkCheckButton* _tmp14_ = NULL;
	GtkCheckButton* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkCheckButton* _tmp17_ = NULL;
	gulong dialog_response_handler = 0UL;
	GtkMessageDialog* _tmp18_ = NULL;
	gulong _tmp19_ = 0UL;
	GtkMessageDialog* _tmp20_ = NULL;
	GtkMessageDialog* _tmp21_ = NULL;
	gulong _tmp22_ = 0UL;
	GtkMessageDialog* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "show-warning");
	if (!_tmp1_) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp2_ = _ ("Thanks for using Dconf Editor for editing your settings!");
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = _ ("Don’t forget that some options may break applications, so be careful.");
	gtk_message_dialog_format_secondary_text (_tmp4_, "%s", _tmp5_);
	_tmp6_ = dialog;
	_tmp7_ = _ ("I’ll be careful.");
	gtk_dialog_add_buttons ((GtkDialog*) _tmp6_, _tmp7_, GTK_RESPONSE_ACCEPT, NULL);
	_tmp8_ = dialog;
	_tmp9_ = gtk_message_dialog_get_message_area (_tmp8_);
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_box_get_type (), GtkBox));
	box = _tmp10_;
	_tmp11_ = _ ("Show this dialog next time.");
	_tmp12_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_data2_->checkbutton = _tmp12_;
	_tmp13_ = _data2_->checkbutton;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
	_tmp14_ = _data2_->checkbutton;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, TRUE);
	_tmp15_ = _data2_->checkbutton;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 5);
	_tmp16_ = box;
	_tmp17_ = _data2_->checkbutton;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = dialog;
	_tmp19_ = g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ___lambda85__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	dialog_response_handler = _tmp19_;
	_tmp20_ = dialog;
	gtk_dialog_run ((GtkDialog*) _tmp20_);
	_tmp21_ = dialog;
	_tmp22_ = dialog_response_handler;
	g_signal_handler_disconnect ((GObject*) _tmp21_, _tmp22_);
	_tmp23_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp23_);
	_g_object_unref0 (box);
	_g_object_unref0 (dialog);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void _dconf_window_on_show_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	dconf_window_on_show ((DConfWindow*) self);
}


static gboolean dconf_window_on_window_state_event (DConfWindow* self, GtkWidget* widget, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->new_window_state;
		self->priv->window_is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean _dconf_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = dconf_window_on_window_state_event ((DConfWindow*) self, _sender, event);
	return result;
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static void dconf_window_on_size_allocate (DConfWindow* self, GtkAllocation* allocation) {
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gint* _window_width = NULL;
	gint* _window_height = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	gint* _tmp30_ = NULL;
	gint* _tmp32_ = NULL;
	gint* _tmp33_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = *allocation;
	_tmp3_ = _tmp2_.width;
	if (_tmp3_ > 1200) {
		GtkStyleContext* _tmp4_ = NULL;
		GtkStyleContext* _tmp5_ = NULL;
		GtkStyleContext* _tmp6_ = NULL;
		_tmp4_ = context;
		gtk_style_context_add_class (_tmp4_, "xxl");
		_tmp5_ = context;
		gtk_style_context_add_class (_tmp5_, "xl");
		_tmp6_ = context;
		gtk_style_context_add_class (_tmp6_, "large-window");
	} else {
		GtkAllocation _tmp7_ = {0};
		gint _tmp8_ = 0;
		_tmp7_ = *allocation;
		_tmp8_ = _tmp7_.width;
		if (_tmp8_ > 1100) {
			GtkStyleContext* _tmp9_ = NULL;
			GtkStyleContext* _tmp10_ = NULL;
			GtkStyleContext* _tmp11_ = NULL;
			_tmp9_ = context;
			gtk_style_context_remove_class (_tmp9_, "xxl");
			_tmp10_ = context;
			gtk_style_context_add_class (_tmp10_, "xl");
			_tmp11_ = context;
			gtk_style_context_add_class (_tmp11_, "large-window");
		} else {
			GtkAllocation _tmp12_ = {0};
			gint _tmp13_ = 0;
			_tmp12_ = *allocation;
			_tmp13_ = _tmp12_.width;
			if (_tmp13_ > 1000) {
				GtkStyleContext* _tmp14_ = NULL;
				GtkStyleContext* _tmp15_ = NULL;
				GtkStyleContext* _tmp16_ = NULL;
				_tmp14_ = context;
				gtk_style_context_remove_class (_tmp14_, "xxl");
				_tmp15_ = context;
				gtk_style_context_remove_class (_tmp15_, "xl");
				_tmp16_ = context;
				gtk_style_context_add_class (_tmp16_, "large-window");
			} else {
				GtkStyleContext* _tmp17_ = NULL;
				GtkStyleContext* _tmp18_ = NULL;
				GtkStyleContext* _tmp19_ = NULL;
				_tmp17_ = context;
				gtk_style_context_remove_class (_tmp17_, "xxl");
				_tmp18_ = context;
				gtk_style_context_remove_class (_tmp18_, "xl");
				_tmp19_ = context;
				gtk_style_context_remove_class (_tmp19_, "large-window");
			}
		}
	}
	_tmp21_ = self->priv->window_is_maximized;
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		gboolean _tmp22_ = FALSE;
		_tmp22_ = self->priv->window_is_tiled;
		_tmp20_ = _tmp22_;
	}
	if (_tmp20_) {
		_g_object_unref0 (context);
		return;
	}
	_window_width = NULL;
	_window_height = NULL;
	gtk_window_get_size ((GtkWindow*) self, &_tmp23_, &_tmp24_);
	_g_free0 (_window_width);
	_tmp25_ = _tmp23_;
	_tmp26_ = __int_dup0 (&_tmp25_);
	_window_width = _tmp26_;
	_g_free0 (_window_height);
	_tmp27_ = _tmp24_;
	_tmp28_ = __int_dup0 (&_tmp27_);
	_window_height = _tmp28_;
	_tmp30_ = _window_width;
	if (_tmp30_ == NULL) {
		_tmp29_ = TRUE;
	} else {
		gint* _tmp31_ = NULL;
		_tmp31_ = _window_height;
		_tmp29_ = _tmp31_ == NULL;
	}
	if (_tmp29_) {
		_g_free0 (_window_height);
		_g_free0 (_window_width);
		_g_object_unref0 (context);
		return;
	}
	_tmp32_ = _window_width;
	self->priv->window_width = (gint) (*_tmp32_);
	_tmp33_ = _window_height;
	self->priv->window_height = (gint) (*_tmp33_);
	_g_free0 (_window_height);
	_g_free0 (_window_width);
	_g_object_unref0 (context);
}


static void _dconf_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	dconf_window_on_size_allocate ((DConfWindow*) self, allocation);
}


static void dconf_window_on_destroy (DConfWindow* self) {
	GtkApplication* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GSettings* _tmp3_ = NULL;
	gulong _tmp4_ = 0UL;
	GSettings* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	GSettings* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GSettings* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GSettings* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	configuration_editor_clean_copy_notification (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
	_tmp1_ = self->priv->settings;
	_tmp2_ = self->priv->behaviour_changed_handler;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->small_keys_list_rows_handler;
	g_signal_handler_disconnect ((GObject*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->small_bookmarks_rows_handler;
	g_signal_handler_disconnect ((GObject*) _tmp5_, _tmp6_);
	_tmp7_ = self->priv->settings;
	g_settings_delay (_tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = self->priv->_current_path;
	g_settings_set_string (_tmp8_, "saved-view", _tmp9_);
	_tmp10_ = self->priv->settings;
	_tmp11_ = self->priv->window_width;
	g_settings_set_int (_tmp10_, "window-width", _tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = self->priv->window_height;
	g_settings_set_int (_tmp12_, "window-height", _tmp13_);
	_tmp14_ = self->priv->settings;
	_tmp15_ = self->priv->window_is_maximized;
	g_settings_set_boolean (_tmp14_, "window-is-maximized", _tmp15_);
	_tmp16_ = self->priv->settings;
	g_settings_apply (_tmp16_);
	GTK_WIDGET_CLASS (dconf_window_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
}


static void _dconf_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	dconf_window_on_destroy ((DConfWindow*) self);
}


static void dconf_window_request_path (DConfWindow* self, const gchar* full_name) {
	RegistryView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RegistryView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	PathBar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	_tmp0_ = self->priv->registry_view;
	_tmp1_ = FALSE;
	registry_view_set_search_mode (_tmp0_, &_tmp1_);
	_tmp2_ = self->priv->registry_view;
	_tmp3_ = full_name;
	_tmp4_ = self->priv->pathbar;
	_tmp5_ = full_name;
	_tmp6_ = path_bar_get_selected_child (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	registry_view_path_requested (_tmp2_, _tmp3_, _tmp7_);
	_g_free0 (_tmp7_);
}


static void _dconf_window_request_path_path_element_request_path (PathElement* _sender, const gchar* path, gpointer self) {
	dconf_window_request_path ((DConfWindow*) self, path);
}


void dconf_window_update_path_elements (DConfWindow* self) {
	Bookmarks* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PathBar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bookmarks_button;
	_tmp1_ = self->priv->_current_path;
	bookmarks_set_path (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->pathbar;
	_tmp3_ = self->priv->_current_path;
	path_bar_set_path (_tmp2_, _tmp3_);
}


void dconf_window_update_hamburger_menu (DConfWindow* self) {
	GMenu* section = NULL;
	GMenu* menu = NULL;
	GMenu* _tmp0_ = NULL;
	GMenu* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	RegistryView* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GMenu* _tmp28_ = NULL;
	GtkMenuButton* _tmp29_ = NULL;
	GMenu* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	_tmp1_ = menu;
	_tmp2_ = _ ("Copy current path");
	_tmp3_ = self->priv->_current_path;
	_tmp4_ = g_strescape (_tmp3_, "");
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("app.copy(\"", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "\")", NULL);
	_tmp9_ = _tmp8_;
	g_menu_append (_tmp1_, _tmp2_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp10_ = self->priv->_current_path;
	_tmp11_ = g_str_has_suffix (_tmp10_, "/");
	if (_tmp11_) {
		GMenu* _tmp12_ = NULL;
		GMenu* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GMenu* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GMenu* _tmp17_ = NULL;
		GMenu* _tmp18_ = NULL;
		GMenu* _tmp19_ = NULL;
		_tmp12_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp12_;
		_tmp13_ = section;
		_tmp14_ = _ ("Reset visible keys");
		g_menu_append (_tmp13_, _tmp14_, "win.reset-visible");
		_tmp15_ = section;
		_tmp16_ = _ ("Reset recursively");
		g_menu_append (_tmp15_, _tmp16_, "win.reset-recursive");
		_tmp17_ = section;
		g_menu_freeze (_tmp17_);
		_tmp18_ = menu;
		_tmp19_ = section;
		g_menu_append_section (_tmp18_, NULL, (GMenuModel*) _tmp19_);
	}
	_tmp20_ = self->priv->registry_view;
	_tmp21_ = registry_view_get_current_delay_mode (_tmp20_);
	if (!_tmp21_) {
		GMenu* _tmp22_ = NULL;
		GMenu* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		GMenu* _tmp25_ = NULL;
		GMenu* _tmp26_ = NULL;
		GMenu* _tmp27_ = NULL;
		_tmp22_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp22_;
		_tmp23_ = section;
		_tmp24_ = _ ("Enter delay mode");
		g_menu_append (_tmp23_, _tmp24_, "win.enter-delay-mode");
		_tmp25_ = section;
		g_menu_freeze (_tmp25_);
		_tmp26_ = menu;
		_tmp27_ = section;
		g_menu_append_section (_tmp26_, NULL, (GMenuModel*) _tmp27_);
	}
	_tmp28_ = menu;
	g_menu_freeze (_tmp28_);
	_tmp29_ = self->priv->info_button;
	_tmp30_ = menu;
	gtk_menu_button_set_menu_model (_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (menu);
	_g_object_unref0 (section);
}


static void dconf_window_open_path (DConfWindow* self, GSimpleAction* action, GVariant* path_variant) {
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = path_variant;
	_vala_return_if_fail (_tmp0_ != NULL, "path_variant != null");
	_tmp1_ = path_variant;
	_tmp2_ = g_variant_get_string ((GVariant*) _tmp1_, NULL);
	dconf_window_request_path (self, _tmp2_);
}


static void dconf_window_reset (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->registry_view;
	registry_view_reset (_tmp0_, FALSE);
}


static void dconf_window_reset_recursively (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->registry_view;
	registry_view_reset (_tmp0_, TRUE);
}


static void dconf_window_enter_delay_mode (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->registry_view;
	registry_view_enter_delay_mode (_tmp0_);
}


static gboolean dconf_window_on_key_press_event (DConfWindow* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* name = NULL;
	gchar* _tmp4_ = NULL;
	GdkEventKey* _tmp5_ = NULL;
	GdkModifierType _tmp6_ = 0;
	GdkEventKey* _tmp56_ = NULL;
	GdkModifierType _tmp57_ = 0;
	const gchar* _tmp87_ = NULL;
	gboolean _tmp113_ = FALSE;
	Bookmarks* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	gboolean _tmp116_ = FALSE;
	RegistryView* _tmp120_ = NULL;
	GdkEventKey* _tmp121_ = NULL;
	gboolean _tmp122_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->keyval;
	_tmp3_ = gdk_keyval_name (_tmp2_);
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp4_ = g_strdup ((const gchar*) _tmp0_);
	name = _tmp4_;
	_tmp5_ = event;
	_tmp6_ = _tmp5_->state;
	if ((_tmp6_ & GDK_CONTROL_MASK) != 0) {
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GQuark _tmp10_ = 0U;
		static GQuark _tmp9_label0 = 0;
		static GQuark _tmp9_label1 = 0;
		static GQuark _tmp9_label2 = 0;
		static GQuark _tmp9_label3 = 0;
		static GQuark _tmp9_label4 = 0;
		static GQuark _tmp9_label5 = 0;
		static GQuark _tmp9_label6 = 0;
		_tmp7_ = name;
		_tmp8_ = _tmp7_;
		_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
		if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("b")))) {
			switch (0) {
				default:
				{
					GtkMenuButton* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					RegistryView* _tmp15_ = NULL;
					Bookmarks* _tmp16_ = NULL;
					_tmp11_ = self->priv->info_button;
					_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp11_);
					_tmp13_ = _tmp12_;
					if (_tmp13_) {
						GtkMenuButton* _tmp14_ = NULL;
						_tmp14_ = self->priv->info_button;
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp14_, FALSE);
					}
					_tmp15_ = self->priv->registry_view;
					registry_view_discard_row_popover (_tmp15_);
					_tmp16_ = self->priv->bookmarks_button;
					gtk_button_clicked ((GtkButton*) _tmp16_);
					result = TRUE;
					_g_free0 (name);
					return result;
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("d")))) {
			switch (0) {
				default:
				{
					GtkMenuButton* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					RegistryView* _tmp21_ = NULL;
					Bookmarks* _tmp22_ = NULL;
					_tmp17_ = self->priv->info_button;
					_tmp18_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_) {
						GtkMenuButton* _tmp20_ = NULL;
						_tmp20_ = self->priv->info_button;
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp20_, FALSE);
					}
					_tmp21_ = self->priv->registry_view;
					registry_view_discard_row_popover (_tmp21_);
					_tmp22_ = self->priv->bookmarks_button;
					bookmarks_set_bookmarked (_tmp22_, TRUE);
					result = TRUE;
					_g_free0 (name);
					return result;
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("D")))) {
			switch (0) {
				default:
				{
					GtkMenuButton* _tmp23_ = NULL;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_ = FALSE;
					RegistryView* _tmp27_ = NULL;
					Bookmarks* _tmp28_ = NULL;
					_tmp23_ = self->priv->info_button;
					_tmp24_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp23_);
					_tmp25_ = _tmp24_;
					if (_tmp25_) {
						GtkMenuButton* _tmp26_ = NULL;
						_tmp26_ = self->priv->info_button;
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp26_, FALSE);
					}
					_tmp27_ = self->priv->registry_view;
					registry_view_discard_row_popover (_tmp27_);
					_tmp28_ = self->priv->bookmarks_button;
					bookmarks_set_bookmarked (_tmp28_, FALSE);
					result = TRUE;
					_g_free0 (name);
					return result;
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("f")))) {
			switch (0) {
				default:
				{
					Bookmarks* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					GtkMenuButton* _tmp33_ = NULL;
					gboolean _tmp34_ = FALSE;
					gboolean _tmp35_ = FALSE;
					RegistryView* _tmp37_ = NULL;
					RegistryView* _tmp38_ = NULL;
					_tmp29_ = self->priv->bookmarks_button;
					_tmp30_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp29_);
					_tmp31_ = _tmp30_;
					if (_tmp31_) {
						Bookmarks* _tmp32_ = NULL;
						_tmp32_ = self->priv->bookmarks_button;
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp32_, FALSE);
					}
					_tmp33_ = self->priv->info_button;
					_tmp34_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp33_);
					_tmp35_ = _tmp34_;
					if (_tmp35_) {
						GtkMenuButton* _tmp36_ = NULL;
						_tmp36_ = self->priv->info_button;
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp36_, FALSE);
					}
					_tmp37_ = self->priv->registry_view;
					registry_view_discard_row_popover (_tmp37_);
					_tmp38_ = self->priv->registry_view;
					registry_view_set_search_mode (_tmp38_, NULL);
					result = TRUE;
					_g_free0 (name);
					return result;
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label4) ? _tmp9_label4 : (_tmp9_label4 = g_quark_from_static_string ("c")))) {
			switch (0) {
				default:
				{
					RegistryView* _tmp39_ = NULL;
					gchar* selected_row_text = NULL;
					RegistryView* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					ConfigurationEditor* application = NULL;
					GtkApplication* _tmp42_ = NULL;
					ConfigurationEditor* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					ConfigurationEditor* _tmp48_ = NULL;
					_tmp39_ = self->priv->registry_view;
					registry_view_discard_row_popover (_tmp39_);
					_tmp40_ = self->priv->registry_view;
					_tmp41_ = registry_view_get_copy_text (_tmp40_);
					selected_row_text = _tmp41_;
					_tmp42_ = gtk_window_get_application ((GtkWindow*) self);
					_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
					application = _tmp43_;
					_tmp45_ = selected_row_text;
					if (_tmp45_ == NULL) {
						const gchar* _tmp46_ = NULL;
						_tmp46_ = self->priv->_current_path;
						_tmp44_ = _tmp46_;
					} else {
						const gchar* _tmp47_ = NULL;
						_tmp47_ = selected_row_text;
						_tmp44_ = (const gchar*) _tmp47_;
					}
					_tmp48_ = application;
					configuration_editor_copy (_tmp48_, _tmp44_);
					result = TRUE;
					_g_object_unref0 (application);
					_g_free0 (selected_row_text);
					_g_free0 (name);
					return result;
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label5) ? _tmp9_label5 : (_tmp9_label5 = g_quark_from_static_string ("C")))) {
			switch (0) {
				default:
				{
					RegistryView* _tmp49_ = NULL;
					GtkApplication* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					_tmp49_ = self->priv->registry_view;
					registry_view_discard_row_popover (_tmp49_);
					_tmp50_ = gtk_window_get_application ((GtkWindow*) self);
					_tmp51_ = self->priv->_current_path;
					configuration_editor_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor), _tmp51_);
					result = TRUE;
					_g_free0 (name);
					return result;
				}
			}
		} else if (_tmp10_ == ((0 != _tmp9_label6) ? _tmp9_label6 : (_tmp9_label6 = g_quark_from_static_string ("F1")))) {
			switch (0) {
				default:
				{
					RegistryView* _tmp52_ = NULL;
					GdkEventKey* _tmp53_ = NULL;
					GdkModifierType _tmp54_ = 0;
					GtkApplication* _tmp55_ = NULL;
					_tmp52_ = self->priv->registry_view;
					registry_view_discard_row_popover (_tmp52_);
					_tmp53_ = event;
					_tmp54_ = _tmp53_->state;
					if ((_tmp54_ & GDK_SHIFT_MASK) == 0) {
						result = FALSE;
						_g_free0 (name);
						return result;
					}
					_tmp55_ = gtk_window_get_application ((GtkWindow*) self);
					configuration_editor_about_cb (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, TYPE_CONFIGURATION_EDITOR, ConfigurationEditor));
					result = TRUE;
					_g_free0 (name);
					return result;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
	}
	_tmp56_ = event;
	_tmp57_ = _tmp56_->state;
	if ((_tmp57_ & GDK_MOD1_MASK) != 0) {
		const gchar* _tmp58_ = NULL;
		_tmp58_ = name;
		if (g_strcmp0 (_tmp58_, "Up") == 0) {
			const gchar* _tmp59_ = NULL;
			GdkEventKey* _tmp60_ = NULL;
			GdkModifierType _tmp61_ = 0;
			_tmp59_ = self->priv->_current_path;
			if (g_strcmp0 (_tmp59_, "/") == 0) {
				result = TRUE;
				_g_free0 (name);
				return result;
			}
			_tmp60_ = event;
			_tmp61_ = _tmp60_->state;
			if ((_tmp61_ & GDK_SHIFT_MASK) != 0) {
				dconf_window_request_path (self, "/");
			} else {
				const gchar* _tmp62_ = NULL;
				gboolean _tmp63_ = FALSE;
				_tmp62_ = self->priv->_current_path;
				_tmp63_ = g_str_has_suffix (_tmp62_, "/");
				if (_tmp63_) {
					const gchar* _tmp64_ = NULL;
					const gchar* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					gchar* _tmp69_ = NULL;
					gchar* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					gchar* _tmp72_ = NULL;
					gchar* _tmp73_ = NULL;
					_tmp64_ = self->priv->_current_path;
					_tmp65_ = self->priv->_current_path;
					_tmp66_ = self->priv->_current_path;
					_tmp67_ = strlen (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = string_slice (_tmp65_, (glong) 0, (glong) (_tmp68_ - 1));
					_tmp70_ = _tmp69_;
					_tmp71_ = string_last_index_of_char (_tmp70_, (gunichar) '/', 0);
					_tmp72_ = string_slice (_tmp64_, (glong) 0, (glong) (_tmp71_ + 1));
					_tmp73_ = _tmp72_;
					dconf_window_request_path (self, _tmp73_);
					_g_free0 (_tmp73_);
					_g_free0 (_tmp70_);
				} else {
					const gchar* _tmp74_ = NULL;
					const gchar* _tmp75_ = NULL;
					gint _tmp76_ = 0;
					gchar* _tmp77_ = NULL;
					gchar* _tmp78_ = NULL;
					_tmp74_ = self->priv->_current_path;
					_tmp75_ = self->priv->_current_path;
					_tmp76_ = string_last_index_of_char (_tmp75_, (gunichar) '/', 0);
					_tmp77_ = string_slice (_tmp74_, (glong) 0, (glong) (_tmp76_ + 1));
					_tmp78_ = _tmp77_;
					dconf_window_request_path (self, _tmp78_);
					_g_free0 (_tmp78_);
				}
			}
			result = TRUE;
			_g_free0 (name);
			return result;
		} else {
			const gchar* _tmp79_ = NULL;
			_tmp79_ = name;
			if (g_strcmp0 (_tmp79_, "Down") == 0) {
				GdkEventKey* _tmp80_ = NULL;
				GdkModifierType _tmp81_ = 0;
				_tmp80_ = event;
				_tmp81_ = _tmp80_->state;
				if ((_tmp81_ & GDK_SHIFT_MASK) != 0) {
					PathBar* _tmp82_ = NULL;
					gboolean _tmp83_ = FALSE;
					_tmp82_ = self->priv->pathbar;
					_tmp83_ = path_bar_open_child (_tmp82_, NULL);
					result = _tmp83_;
					_g_free0 (name);
					return result;
				} else {
					PathBar* _tmp84_ = NULL;
					const gchar* _tmp85_ = NULL;
					gboolean _tmp86_ = FALSE;
					_tmp84_ = self->priv->pathbar;
					_tmp85_ = self->priv->_current_path;
					_tmp86_ = path_bar_open_child (_tmp84_, _tmp85_);
					result = _tmp86_;
					_g_free0 (name);
					return result;
				}
			}
		}
	}
	_tmp87_ = name;
	if (g_strcmp0 (_tmp87_, "F10") == 0) {
		RegistryView* _tmp88_ = NULL;
		Bookmarks* _tmp89_ = NULL;
		gboolean _tmp90_ = FALSE;
		gboolean _tmp91_ = FALSE;
		_tmp88_ = self->priv->registry_view;
		registry_view_discard_row_popover (_tmp88_);
		_tmp89_ = self->priv->bookmarks_button;
		_tmp90_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp89_);
		_tmp91_ = _tmp90_;
		if (_tmp91_) {
			Bookmarks* _tmp92_ = NULL;
			_tmp92_ = self->priv->bookmarks_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp92_, FALSE);
		}
		result = FALSE;
		_g_free0 (name);
		return result;
	} else {
		const gchar* _tmp93_ = NULL;
		_tmp93_ = name;
		if (g_strcmp0 (_tmp93_, "Menu") == 0) {
			RegistryView* _tmp94_ = NULL;
			gboolean _tmp95_ = FALSE;
			_tmp94_ = self->priv->registry_view;
			_tmp95_ = registry_view_show_row_popover (_tmp94_);
			if (_tmp95_) {
				Bookmarks* _tmp96_ = NULL;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				GtkMenuButton* _tmp100_ = NULL;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_ = FALSE;
				_tmp96_ = self->priv->bookmarks_button;
				_tmp97_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp96_);
				_tmp98_ = _tmp97_;
				if (_tmp98_) {
					Bookmarks* _tmp99_ = NULL;
					_tmp99_ = self->priv->bookmarks_button;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp99_, FALSE);
				}
				_tmp100_ = self->priv->info_button;
				_tmp101_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp100_);
				_tmp102_ = _tmp101_;
				if (_tmp102_) {
					GtkMenuButton* _tmp103_ = NULL;
					_tmp103_ = self->priv->info_button;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp103_, FALSE);
				}
			} else {
				GtkMenuButton* _tmp104_ = NULL;
				gboolean _tmp105_ = FALSE;
				gboolean _tmp106_ = FALSE;
				_tmp104_ = self->priv->info_button;
				_tmp105_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp104_);
				_tmp106_ = _tmp105_;
				if (_tmp106_ == FALSE) {
					Bookmarks* _tmp107_ = NULL;
					gboolean _tmp108_ = FALSE;
					gboolean _tmp109_ = FALSE;
					GtkMenuButton* _tmp111_ = NULL;
					_tmp107_ = self->priv->bookmarks_button;
					_tmp108_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp107_);
					_tmp109_ = _tmp108_;
					if (_tmp109_) {
						Bookmarks* _tmp110_ = NULL;
						_tmp110_ = self->priv->bookmarks_button;
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp110_, FALSE);
					}
					_tmp111_ = self->priv->info_button;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp111_, TRUE);
				} else {
					GtkMenuButton* _tmp112_ = NULL;
					_tmp112_ = self->priv->info_button;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp112_, FALSE);
				}
			}
			result = TRUE;
			_g_free0 (name);
			return result;
		}
	}
	_tmp114_ = self->priv->bookmarks_button;
	_tmp115_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp114_);
	_tmp116_ = _tmp115_;
	if (_tmp116_) {
		_tmp113_ = TRUE;
	} else {
		GtkMenuButton* _tmp117_ = NULL;
		gboolean _tmp118_ = FALSE;
		gboolean _tmp119_ = FALSE;
		_tmp117_ = self->priv->info_button;
		_tmp118_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp117_);
		_tmp119_ = _tmp118_;
		_tmp113_ = _tmp119_;
	}
	if (_tmp113_) {
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	_tmp120_ = self->priv->registry_view;
	_tmp121_ = event;
	_tmp122_ = registry_view_handle_search_event (_tmp120_, _tmp121_);
	result = _tmp122_;
	_g_free0 (name);
	return result;
}


static gboolean _dconf_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = dconf_window_on_key_press_event ((DConfWindow*) self, _sender, event);
	return result;
}


static void dconf_window_on_menu_button_clicked (DConfWindow* self) {
	RegistryView* _tmp0_ = NULL;
	RegistryView* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->registry_view;
	registry_view_discard_row_popover (_tmp0_);
	_tmp1_ = self->priv->registry_view;
	_tmp2_ = FALSE;
	registry_view_set_search_mode (_tmp1_, &_tmp2_);
}


static void _dconf_window_on_menu_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	dconf_window_on_menu_button_clicked ((DConfWindow*) self);
}


void dconf_window_show_notification (DConfWindow* self, const gchar* notification) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkRevealer* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = self->priv->notification_label;
	_tmp1_ = notification;
	gtk_label_set_text (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->notification_revealer;
	gtk_revealer_set_reveal_child (_tmp2_, TRUE);
}


static void dconf_window_hide_notification (DConfWindow* self) {
	GtkRevealer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notification_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
}


static void _dconf_window_hide_notification_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	dconf_window_hide_notification ((DConfWindow*) self);
}


static const gchar* dconf_window_get_current_path (DConfWindow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_path;
	result = _tmp0_;
	return result;
}


void dconf_window_set_current_path (DConfWindow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_current_path);
	self->priv->_current_path = _tmp1_;
	g_object_notify ((GObject *) self, "current-path");
}


static void dconf_window_class_init (DConfWindowClass * klass) {
	gint DConfWindow_private_offset;
	dconf_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DConfWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dconf_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dconf_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = dconf_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DCONF_WINDOW_CURRENT_PATH_PROPERTY, g_param_spec_string ("current-path", "current-path", "current-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	DConfWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/dconf-editor.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmarks_button", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, bookmarks_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_button", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, info_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pathbar", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, pathbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "registry_view", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, registry_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notification_revealer", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, notification_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notification_label", FALSE, DConfWindow_private_offset + G_STRUCT_OFFSET (DConfWindowPrivate, notification_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_show", G_CALLBACK(_dconf_window_on_show_gtk_widget_show));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_dconf_window_on_window_state_event_gtk_widget_window_state_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_dconf_window_on_size_allocate_gtk_widget_size_allocate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_dconf_window_on_destroy_gtk_widget_destroy));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "request_path", G_CALLBACK(_dconf_window_request_path_path_element_request_path));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_press_event", G_CALLBACK(_dconf_window_on_key_press_event_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_menu_button_clicked", G_CALLBACK(_dconf_window_on_menu_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "hide_notification", G_CALLBACK(_dconf_window_hide_notification_gtk_button_clicked));
}


static void dconf_window_instance_init (DConfWindow * self) {
	gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	self->priv = DCONF_WINDOW_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("/");
	self->priv->_current_path = _tmp0_;
	self->priv->window_width = 0;
	self->priv->window_height = 0;
	self->priv->window_is_maximized = FALSE;
	self->priv->window_is_tiled = FALSE;
	_tmp1_ = g_settings_new ("ca.desrt.dconf-editor.Settings");
	self->priv->settings = _tmp1_;
	self->priv->behaviour_changed_handler = (gulong) 0;
	self->priv->small_keys_list_rows_handler = (gulong) 0;
	self->priv->small_bookmarks_rows_handler = (gulong) 0;
	g_type_ensure (TYPE_BOOKMARKS);
	g_type_ensure (TYPE_PATH_BAR);
	g_type_ensure (TYPE_REGISTRY_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void dconf_window_finalize (GObject* obj) {
	DConfWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DCONF_WINDOW, DConfWindow);
	_g_free0 (self->priv->_current_path);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->bookmarks_button);
	_g_object_unref0 (self->priv->info_button);
	_g_object_unref0 (self->priv->pathbar);
	_g_object_unref0 (self->priv->registry_view);
	_g_object_unref0 (self->priv->notification_revealer);
	_g_object_unref0 (self->priv->notification_label);
	G_OBJECT_CLASS (dconf_window_parent_class)->finalize (obj);
}


GType dconf_window_get_type (void) {
	static volatile gsize dconf_window_type_id__volatile = 0;
	if (g_once_init_enter (&dconf_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DConfWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dconf_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DConfWindow), 0, (GInstanceInitFunc) dconf_window_instance_init, NULL };
		GType dconf_window_type_id;
		dconf_window_type_id = g_type_register_static (gtk_application_window_get_type (), "DConfWindow", &g_define_type_info, 0);
		g_once_init_leave (&dconf_window_type_id__volatile, dconf_window_type_id);
	}
	return dconf_window_type_id__volatile;
}


static void _vala_dconf_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DConfWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_WINDOW, DConfWindow);
	switch (property_id) {
		case DCONF_WINDOW_CURRENT_PATH_PROPERTY:
		g_value_set_string (value, dconf_window_get_current_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dconf_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DConfWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_WINDOW, DConfWindow);
	switch (property_id) {
		case DCONF_WINDOW_CURRENT_PATH_PROPERTY:
		dconf_window_set_current_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void path_element_base_init (PathElementIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("request_path", TYPE_PATH_ELEMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


GType path_element_get_type (void) {
	static volatile gsize path_element_type_id__volatile = 0;
	if (g_once_init_enter (&path_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PathElementIface), (GBaseInitFunc) path_element_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType path_element_type_id;
		path_element_type_id = g_type_register_static (G_TYPE_INTERFACE, "PathElement", &g_define_type_info, 0);
		g_once_init_leave (&path_element_type_id__volatile, path_element_type_id);
	}
	return path_element_type_id__volatile;
}



