/* pathbar.c generated by valac 0.34.11.5-fb636, the Vala compiler
 * generated from pathbar.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PATH_ELEMENT (path_element_get_type ())
#define PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_ELEMENT, PathElement))
#define IS_PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_ELEMENT))
#define PATH_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATH_ELEMENT, PathElementIface))

typedef struct _PathElement PathElement;
typedef struct _PathElementIface PathElementIface;

#define TYPE_PATH_BAR (path_bar_get_type ())
#define PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_BAR, PathBar))
#define PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_BAR, PathBarClass))
#define IS_PATH_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_BAR))
#define IS_PATH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_BAR))
#define PATH_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_BAR, PathBarClass))

typedef struct _PathBar PathBar;
typedef struct _PathBarClass PathBarClass;
typedef struct _PathBarPrivate PathBarPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block18Data Block18Data;

#define TYPE_PATH_BAR_ITEM (path_bar_item_get_type ())
#define PATH_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_BAR_ITEM, PathBarItem))
#define PATH_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_BAR_ITEM, PathBarItemClass))
#define IS_PATH_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_BAR_ITEM))
#define IS_PATH_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_BAR_ITEM))
#define PATH_BAR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_BAR_ITEM, PathBarItemClass))

typedef struct _PathBarItem PathBarItem;
typedef struct _PathBarItemClass PathBarItemClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _PathBarItemPrivate PathBarItemPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PathElementIface {
	GTypeInterface parent_iface;
};

struct _PathBar {
	GtkBox parent_instance;
	PathBarPrivate * priv;
};

struct _PathBarClass {
	GtkBoxClass parent_class;
};

struct _PathBarPrivate {
	GtkButton* root_button;
	gchar* complete_path;
};

struct _Block18Data {
	int _ref_count_;
	PathBar* self;
	gchar** split;
	gint split_length1;
	gint _split_size_;
	gboolean is_key_path;
	gboolean destroy_all;
	gboolean maintain_all;
};

struct _PathBarItem {
	GtkButton parent_instance;
	PathBarItemPrivate * priv;
};

struct _PathBarItemClass {
	GtkButtonClass parent_class;
};

struct _PathBarItemPrivate {
	gchar* _text_string;
	GtkLabel* text_label;
};


static gpointer path_bar_parent_class = NULL;
static PathElementIface* path_bar_path_element_parent_iface = NULL;
static gpointer path_bar_item_parent_class = NULL;

GType path_element_get_type (void) G_GNUC_CONST;
GType path_bar_get_type (void) G_GNUC_CONST;
#define PATH_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PATH_BAR, PathBarPrivate))
enum  {
	PATH_BAR_0_PROPERTY
};
void path_bar_set_path (PathBar* self, const gchar* path);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void path_bar_activate_item (PathBar* self, GtkWidget* item, gboolean state);
static void __lambda11_ (Block18Data* _data18_, GtkWidget* child);
GType path_bar_item_get_type (void) G_GNUC_CONST;
const gchar* path_bar_item_get_text_string (PathBarItem* self);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void ___lambda11__gtk_callback (GtkWidget* widget, gpointer self);
static void path_bar_add_path_bar_item (PathBar* self, const gchar* label, const gchar* complete_path, gboolean block);
static void path_bar_add_slash_label (PathBar* self);
gboolean path_bar_open_child (PathBar* self, const gchar* current_path);
gchar* path_bar_get_selected_child (PathBar* self, const gchar* current_path);
PathBarItem* path_bar_item_new (const gchar* label);
PathBarItem* path_bar_item_construct (GType object_type, const gchar* label);
PathBar* path_bar_new (void);
PathBar* path_bar_construct (GType object_type);
static GObject * path_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void path_bar_finalize (GObject* obj);
#define PATH_BAR_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PATH_BAR_ITEM, PathBarItemPrivate))
enum  {
	PATH_BAR_ITEM_0_PROPERTY,
	PATH_BAR_ITEM_TEXT_STRING_PROPERTY
};
static void path_bar_item_set_text_string (PathBarItem* self, const gchar* value);
static void path_bar_item_finalize (GObject* obj);
static void _vala_path_bar_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_path_bar_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		PathBar* self;
		self = _data18_->self;
		_data18_->split = (_vala_array_free (_data18_->split, _data18_->split_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void __lambda11_ (Block18Data* _data18_, GtkWidget* child) {
	PathBar* self;
	GtkWidget* _tmp0_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GtkWidget* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	self = _data18_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = child;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_label_get_type ())) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = _data18_->destroy_all;
		if (_tmp1_) {
			GtkWidget* _tmp2_ = NULL;
			_tmp2_ = child;
			gtk_widget_destroy (_tmp2_);
		} else {
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			_tmp3_ = self->priv->complete_path;
			_tmp4_ = g_strconcat (_tmp3_, "/", NULL);
			_g_free0 (self->priv->complete_path);
			self->priv->complete_path = _tmp4_;
		}
		return;
	}
	_tmp5_ = _data18_->maintain_all;
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GtkWidget* _tmp11_ = NULL;
		_tmp6_ = self->priv->complete_path;
		_tmp7_ = child;
		_tmp8_ = path_bar_item_get_text_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PATH_BAR_ITEM, PathBarItem));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
		_g_free0 (self->priv->complete_path);
		self->priv->complete_path = _tmp10_;
		_tmp11_ = child;
		path_bar_activate_item (self, _tmp11_, FALSE);
		return;
	}
	_tmp13_ = child;
	_tmp14_ = self->priv->root_button;
	if (_tmp13_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget)) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		_tmp16_ = _data18_->destroy_all;
		if (!_tmp16_) {
			GtkWidget* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			const gchar* _tmp21_ = NULL;
			_tmp17_ = child;
			_tmp18_ = path_bar_item_get_text_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PATH_BAR_ITEM, PathBarItem));
			_tmp19_ = _tmp18_;
			_tmp20_ = _data18_->split;
			_tmp20__length1 = _data18_->split_length1;
			_tmp21_ = _tmp20_[0];
			_tmp15_ = g_strcmp0 (_tmp19_, _tmp21_) == 0;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp12_ = _tmp15_;
	}
	if (_tmp12_) {
		const gchar* _tmp22_ = NULL;
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gchar** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gboolean _tmp29_ = FALSE;
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		_tmp22_ = self->priv->complete_path;
		_tmp23_ = _data18_->split;
		_tmp23__length1 = _data18_->split_length1;
		_tmp24_ = _tmp23_[0];
		_tmp25_ = g_strconcat (_tmp22_, _tmp24_, NULL);
		_g_free0 (self->priv->complete_path);
		self->priv->complete_path = _tmp25_;
		_tmp26_ = _data18_->split;
		_tmp26__length1 = _data18_->split_length1;
		_tmp27_ = _data18_->split;
		_tmp27__length1 = _data18_->split_length1;
		_tmp28_ = ((_tmp26_ + 1) != NULL) ? _vala_array_dup3 (_tmp26_ + 1, _tmp27__length1 - 1) : ((gpointer) (_tmp26_ + 1));
		_tmp28__length1 = _tmp27__length1 - 1;
		_data18_->split = (_vala_array_free (_data18_->split, _data18_->split_length1, (GDestroyNotify) g_free), NULL);
		_data18_->split = _tmp28_;
		_data18_->split_length1 = _tmp28__length1;
		_data18_->_split_size_ = _data18_->split_length1;
		_tmp30_ = _data18_->split;
		_tmp30__length1 = _data18_->split_length1;
		if (_tmp30__length1 == 0) {
			_tmp29_ = TRUE;
		} else {
			gboolean _tmp31_ = FALSE;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			_tmp32_ = _data18_->split;
			_tmp32__length1 = _data18_->split_length1;
			if (_tmp32__length1 == 1) {
				gboolean _tmp33_ = FALSE;
				_tmp33_ = _data18_->is_key_path;
				_tmp31_ = !_tmp33_;
			} else {
				_tmp31_ = FALSE;
			}
			_tmp29_ = _tmp31_;
		}
		if (_tmp29_) {
			GtkWidget* _tmp34_ = NULL;
			_tmp34_ = child;
			path_bar_activate_item (self, _tmp34_, TRUE);
			_data18_->maintain_all = TRUE;
		} else {
			GtkWidget* _tmp35_ = NULL;
			_tmp35_ = child;
			path_bar_activate_item (self, _tmp35_, FALSE);
		}
		return;
	}
	_tmp36_ = child;
	gtk_widget_destroy (_tmp36_);
	_data18_->destroy_all = TRUE;
}


static void ___lambda11__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda11_ (self, widget);
}


void path_bar_set_path (PathBar* self, const gchar* path) {
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	Block18Data* _data18_;
	GtkButton* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar* last = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	_vala_return_if_fail (_tmp1_ == '/', "path [0] == '/'");
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp2_ = self->priv->root_button;
	_tmp3_ = path;
	path_bar_activate_item (self, (GtkWidget*) _tmp2_, g_strcmp0 (_tmp3_, "/") == 0);
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->complete_path);
	self->priv->complete_path = _tmp4_;
	_tmp5_ = path;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "/", 0);
	_data18_->split = _tmp7_;
	_data18_->split_length1 = _vala_array_length (_tmp6_);
	_data18_->_split_size_ = _data18_->split_length1;
	_tmp8_ = _data18_->split;
	_tmp8__length1 = _data18_->split_length1;
	_tmp9_ = _data18_->split;
	_tmp9__length1 = _data18_->split_length1;
	_tmp10_ = _tmp8_[_tmp9__length1 - 1];
	_tmp11_ = g_strdup (_tmp10_);
	last = _tmp11_;
	_tmp12_ = last;
	_data18_->is_key_path = g_strcmp0 (_tmp12_, "") != 0;
	_data18_->destroy_all = FALSE;
	_data18_->maintain_all = FALSE;
	gtk_container_foreach ((GtkContainer*) self, ___lambda11__gtk_callback, _data18_);
	_tmp13_ = _data18_->split;
	_tmp13__length1 = _data18_->split_length1;
	if (_tmp13__length1 > 0) {
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gboolean _tmp30_ = FALSE;
		_tmp14_ = _data18_->split;
		_tmp14__length1 = _data18_->split_length1;
		if (_tmp14__length1 > 1) {
			guint index = 0U;
			gchar** _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			gchar** _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			index = (guint) 0;
			_tmp15_ = _data18_->split;
			_tmp15__length1 = _data18_->split_length1;
			_tmp16_ = _data18_->split;
			_tmp16__length1 = _data18_->split_length1;
			{
				gchar** item_collection = NULL;
				gint item_collection_length1 = 0;
				gint _item_collection_size_ = 0;
				gint item_it = 0;
				item_collection = _tmp15_ + 0;
				item_collection_length1 = (_tmp16__length1 - 1) - 0;
				for (item_it = 0; item_it < ((_tmp16__length1 - 1) - 0); item_it = item_it + 1) {
					gchar* _tmp17_ = NULL;
					gchar* item = NULL;
					_tmp17_ = g_strdup (item_collection[item_it]);
					item = _tmp17_;
					{
						const gchar* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						gboolean _tmp23_ = FALSE;
						gboolean _tmp24_ = FALSE;
						const gchar* _tmp27_ = NULL;
						const gchar* _tmp28_ = NULL;
						guint _tmp29_ = 0U;
						_tmp18_ = self->priv->complete_path;
						_tmp19_ = item;
						_tmp20_ = g_strconcat (_tmp19_, "/", NULL);
						_tmp21_ = _tmp20_;
						_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
						_g_free0 (self->priv->complete_path);
						self->priv->complete_path = _tmp22_;
						_g_free0 (_tmp21_);
						_tmp24_ = _data18_->is_key_path;
						if (!_tmp24_) {
							guint _tmp25_ = 0U;
							gchar** _tmp26_ = NULL;
							gint _tmp26__length1 = 0;
							_tmp25_ = index;
							_tmp26_ = _data18_->split;
							_tmp26__length1 = _data18_->split_length1;
							_tmp23_ = _tmp25_ == ((guint) (_tmp26__length1 - 2));
						} else {
							_tmp23_ = FALSE;
						}
						_tmp27_ = item;
						_tmp28_ = self->priv->complete_path;
						path_bar_add_path_bar_item (self, _tmp27_, _tmp28_, _tmp23_);
						path_bar_add_slash_label (self);
						_tmp29_ = index;
						index = _tmp29_ + 1;
						_g_free0 (item);
					}
				}
			}
		}
		_tmp30_ = _data18_->is_key_path;
		if (_tmp30_) {
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			_tmp31_ = self->priv->complete_path;
			_tmp32_ = last;
			_tmp33_ = g_strconcat (_tmp31_, _tmp32_, NULL);
			_g_free0 (self->priv->complete_path);
			self->priv->complete_path = _tmp33_;
			_tmp34_ = last;
			_tmp35_ = self->priv->complete_path;
			path_bar_add_path_bar_item (self, _tmp34_, _tmp35_, TRUE);
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_g_free0 (last);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


gboolean path_bar_open_child (PathBar* self, const gchar* current_path) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint index_of_last_slash = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = current_path;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = self->priv->complete_path;
		g_signal_emit_by_name ((PathElement*) self, "request-path", _tmp1_);
		result = TRUE;
		return result;
	}
	_tmp2_ = current_path;
	_tmp3_ = self->priv->complete_path;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->complete_path;
	_tmp5_ = current_path;
	_tmp6_ = strlen ((const gchar*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_index_of (_tmp4_, "/", _tmp7_);
	index_of_last_slash = _tmp8_;
	_tmp10_ = index_of_last_slash;
	if (_tmp10_ == -1) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp11_ = self->priv->complete_path;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp9_);
		_tmp9_ = _tmp12_;
	} else {
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		_tmp13_ = self->priv->complete_path;
		_tmp14_ = index_of_last_slash;
		_tmp15_ = string_slice (_tmp13_, (glong) 0, (glong) (_tmp14_ + 1));
		_g_free0 (_tmp9_);
		_tmp9_ = _tmp15_;
	}
	g_signal_emit_by_name ((PathElement*) self, "request-path", _tmp9_);
	result = TRUE;
	_g_free0 (_tmp9_);
	return result;
}


gchar* path_bar_get_selected_child (PathBar* self, const gchar* current_path) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gint index_of_last_slash = 0;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (current_path != NULL, NULL);
	_tmp1_ = self->priv->complete_path;
	_tmp2_ = current_path;
	_tmp3_ = g_str_has_prefix (_tmp1_, _tmp2_);
	if (!_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->complete_path;
		_tmp5_ = current_path;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->complete_path;
	_tmp7_ = current_path;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_index_of (_tmp6_, "/", _tmp9_);
	index_of_last_slash = _tmp10_;
	_tmp12_ = index_of_last_slash;
	if (_tmp12_ == -1) {
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp13_ = self->priv->complete_path;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp14_;
	} else {
		const gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		_tmp15_ = self->priv->complete_path;
		_tmp16_ = index_of_last_slash;
		_tmp17_ = string_slice (_tmp15_, (glong) 0, (glong) (_tmp16_ + 1));
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp17_;
	}
	result = _tmp11_;
	return result;
}


static void path_bar_add_slash_label (PathBar* self) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("/");
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}


static void path_bar_add_path_bar_item (PathBar* self, const gchar* label, const gchar* complete_path, gboolean block) {
	PathBarItem* path_bar_item = NULL;
	const gchar* _tmp0_ = NULL;
	PathBarItem* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (complete_path != NULL);
	_tmp0_ = label;
	_tmp1_ = path_bar_item_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	path_bar_item = _tmp1_;
	_tmp2_ = complete_path;
	_tmp3_ = g_variant_new_string (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	g_object_set ((GtkActionable*) path_bar_item, "action-target", _tmp4_, NULL);
	_g_variant_unref0 (_tmp4_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) path_bar_item);
	_tmp5_ = block;
	path_bar_activate_item (self, (GtkWidget*) path_bar_item, _tmp5_);
	_g_object_unref0 (path_bar_item);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void path_bar_activate_item (PathBar* self, GtkWidget* item, gboolean state) {
	GtkStyleContext* context = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkStyleContext* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = gtk_widget_get_style_context (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = state;
	_tmp4_ = context;
	_tmp5_ = gtk_style_context_has_class (_tmp4_, "active");
	if (_tmp3_ == _tmp5_) {
		_g_object_unref0 (context);
		return;
	}
	_tmp6_ = state;
	if (_tmp6_) {
		GtkStyleContext* _tmp7_ = NULL;
		_tmp7_ = context;
		gtk_style_context_add_class (_tmp7_, "active");
	} else {
		GtkStyleContext* _tmp8_ = NULL;
		_tmp8_ = context;
		gtk_style_context_remove_class (_tmp8_, "active");
	}
	_g_object_unref0 (context);
}


PathBar* path_bar_construct (GType object_type) {
	PathBar * self = NULL;
	self = (PathBar*) g_object_new (object_type, NULL);
	return self;
}


PathBar* path_bar_new (void) {
	return path_bar_construct (TYPE_PATH_BAR);
}


static GObject * path_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	PathBar * self;
	parent_class = G_OBJECT_CLASS (path_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PATH_BAR, PathBar);
	path_bar_add_slash_label (self);
	return obj;
}


static void path_bar_class_init (PathBarClass * klass) {
	gint PathBar_private_offset;
	path_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PathBarPrivate));
	G_OBJECT_CLASS (klass)->constructor = path_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = path_bar_finalize;
	PathBar_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/pathbar.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "root_button", FALSE, PathBar_private_offset + G_STRUCT_OFFSET (PathBarPrivate, root_button));
}


static void path_bar_path_element_interface_init (PathElementIface * iface) {
	path_bar_path_element_parent_iface = g_type_interface_peek_parent (iface);
}


static void path_bar_instance_init (PathBar * self) {
	gchar* _tmp0_ = NULL;
	self->priv = PATH_BAR_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->complete_path = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void path_bar_finalize (GObject* obj) {
	PathBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PATH_BAR, PathBar);
	_g_object_unref0 (self->priv->root_button);
	_g_free0 (self->priv->complete_path);
	G_OBJECT_CLASS (path_bar_parent_class)->finalize (obj);
}


GType path_bar_get_type (void) {
	static volatile gsize path_bar_type_id__volatile = 0;
	if (g_once_init_enter (&path_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PathBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) path_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PathBar), 0, (GInstanceInitFunc) path_bar_instance_init, NULL };
		static const GInterfaceInfo path_element_info = { (GInterfaceInitFunc) path_bar_path_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType path_bar_type_id;
		path_bar_type_id = g_type_register_static (gtk_box_get_type (), "PathBar", &g_define_type_info, 0);
		g_type_add_interface_static (path_bar_type_id, TYPE_PATH_ELEMENT, &path_element_info);
		g_once_init_leave (&path_bar_type_id__volatile, path_bar_type_id);
	}
	return path_bar_type_id__volatile;
}


PathBarItem* path_bar_item_construct (GType object_type, const gchar* label) {
	PathBarItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = label;
	self = (PathBarItem*) g_object_new (object_type, "text-string", _tmp0_, NULL);
	_tmp1_ = self->priv->text_label;
	_tmp2_ = label;
	gtk_label_set_text (_tmp1_, _tmp2_);
	return self;
}


PathBarItem* path_bar_item_new (const gchar* label) {
	return path_bar_item_construct (TYPE_PATH_BAR_ITEM, label);
}


const gchar* path_bar_item_get_text_string (PathBarItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text_string;
	result = _tmp0_;
	return result;
}


static void path_bar_item_set_text_string (PathBarItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_text_string);
	self->priv->_text_string = _tmp1_;
	g_object_notify ((GObject *) self, "text-string");
}


static void path_bar_item_class_init (PathBarItemClass * klass) {
	gint PathBarItem_private_offset;
	path_bar_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PathBarItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_path_bar_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_path_bar_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = path_bar_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PATH_BAR_ITEM_TEXT_STRING_PROPERTY, g_param_spec_string ("text-string", "text-string", "text-string", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	PathBarItem_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/pathbar-item.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, PathBarItem_private_offset + G_STRUCT_OFFSET (PathBarItemPrivate, text_label));
}


static void path_bar_item_instance_init (PathBarItem * self) {
	self->priv = PATH_BAR_ITEM_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void path_bar_item_finalize (GObject* obj) {
	PathBarItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PATH_BAR_ITEM, PathBarItem);
	_g_free0 (self->priv->_text_string);
	_g_object_unref0 (self->priv->text_label);
	G_OBJECT_CLASS (path_bar_item_parent_class)->finalize (obj);
}


GType path_bar_item_get_type (void) {
	static volatile gsize path_bar_item_type_id__volatile = 0;
	if (g_once_init_enter (&path_bar_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PathBarItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) path_bar_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PathBarItem), 0, (GInstanceInitFunc) path_bar_item_instance_init, NULL };
		GType path_bar_item_type_id;
		path_bar_item_type_id = g_type_register_static (gtk_button_get_type (), "PathBarItem", &g_define_type_info, 0);
		g_once_init_leave (&path_bar_item_type_id__volatile, path_bar_item_type_id);
	}
	return path_bar_item_type_id__volatile;
}


static void _vala_path_bar_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PathBarItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PATH_BAR_ITEM, PathBarItem);
	switch (property_id) {
		case PATH_BAR_ITEM_TEXT_STRING_PROPERTY:
		g_value_set_string (value, path_bar_item_get_text_string (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_path_bar_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PathBarItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PATH_BAR_ITEM, PathBarItem);
	switch (property_id) {
		case PATH_BAR_ITEM_TEXT_STRING_PROPERTY:
		path_bar_item_set_text_string (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



