/* registry-view.c generated by valac 0.34.11.5-fb636, the Vala compiler
 * generated from registry-view.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_PATH_ELEMENT (path_element_get_type ())
#define PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_ELEMENT, PathElement))
#define IS_PATH_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_ELEMENT))
#define PATH_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATH_ELEMENT, PathElementIface))

typedef struct _PathElement PathElement;
typedef struct _PathElementIface PathElementIface;

#define TYPE_REGISTRY_VIEW (registry_view_get_type ())
#define REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VIEW, RegistryView))
#define REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VIEW, RegistryViewClass))
#define IS_REGISTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VIEW))
#define IS_REGISTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VIEW))
#define REGISTRY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VIEW, RegistryViewClass))

typedef struct _RegistryView RegistryView;
typedef struct _RegistryViewClass RegistryViewClass;
typedef struct _RegistryViewPrivate RegistryViewPrivate;

#define TYPE_BEHAVIOUR (behaviour_get_type ())

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;

#define TYPE_REGISTRY_INFO (registry_info_get_type ())
#define REGISTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_INFO, RegistryInfo))
#define REGISTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_INFO, RegistryInfoClass))
#define IS_REGISTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_INFO))
#define IS_REGISTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_INFO))
#define REGISTRY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_INFO, RegistryInfoClass))

typedef struct _RegistryInfo RegistryInfo;
typedef struct _RegistryInfoClass RegistryInfoClass;

#define TYPE_MODIFICATIONS_REVEALER (modifications_revealer_get_type ())
#define MODIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer))
#define MODIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealerClass))
#define IS_MODIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_REVEALER))
#define IS_MODIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_REVEALER))
#define MODIFICATIONS_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealerClass))

typedef struct _ModificationsRevealer ModificationsRevealer;
typedef struct _ModificationsRevealerClass ModificationsRevealerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CLICKABLE_LIST_BOX_ROW (clickable_list_box_row_get_type ())
#define CLICKABLE_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow))
#define CLICKABLE_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRowClass))
#define IS_CLICKABLE_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLICKABLE_LIST_BOX_ROW))
#define IS_CLICKABLE_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLICKABLE_LIST_BOX_ROW))
#define CLICKABLE_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRowClass))

typedef struct _ClickableListBoxRow ClickableListBoxRow;
typedef struct _ClickableListBoxRowClass ClickableListBoxRowClass;

#define TYPE_SETTING_OBJECT (setting_object_get_type ())
#define SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTING_OBJECT, SettingObject))
#define SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTING_OBJECT, SettingObjectClass))
#define IS_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTING_OBJECT))
#define IS_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTING_OBJECT))
#define SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTING_OBJECT, SettingObjectClass))

typedef struct _SettingObject SettingObject;
typedef struct _SettingObjectClass SettingObjectClass;

#define TYPE_DCONF_WINDOW (dconf_window_get_type ())
#define DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_WINDOW, DConfWindow))
#define DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_WINDOW, DConfWindowClass))
#define IS_DCONF_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_WINDOW))
#define IS_DCONF_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_WINDOW))
#define DCONF_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_WINDOW, DConfWindowClass))

typedef struct _DConfWindow DConfWindow;
typedef struct _DConfWindowClass DConfWindowClass;

#define TYPE_DIRECTORY (directory_get_type ())
#define DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY, Directory))
#define DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY, DirectoryClass))
#define IS_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY))
#define IS_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY))
#define DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY, DirectoryClass))

typedef struct _Directory Directory;
typedef struct _DirectoryClass DirectoryClass;

#define TYPE_KEY (key_get_type ())
#define KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY, Key))
#define KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY, KeyClass))
#define IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY))
#define IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY))
#define KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY, KeyClass))

typedef struct _Key Key;
typedef struct _KeyClass KeyClass;

#define TYPE_DCONF_KEY (dconf_key_get_type ())
#define DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_KEY, DConfKey))
#define DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_KEY, DConfKeyClass))
#define IS_DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_KEY))
#define IS_DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_KEY))
#define DCONF_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_KEY, DConfKeyClass))

typedef struct _DConfKey DConfKey;
typedef struct _DConfKeyClass DConfKeyClass;
typedef struct _Block22Data Block22Data;

#define TYPE_FOLDER_LIST_BOX_ROW (folder_list_box_row_get_type ())
#define FOLDER_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FOLDER_LIST_BOX_ROW, FolderListBoxRow))
#define FOLDER_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FOLDER_LIST_BOX_ROW, FolderListBoxRowClass))
#define IS_FOLDER_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FOLDER_LIST_BOX_ROW))
#define IS_FOLDER_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FOLDER_LIST_BOX_ROW))
#define FOLDER_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FOLDER_LIST_BOX_ROW, FolderListBoxRowClass))

typedef struct _FolderListBoxRow FolderListBoxRow;
typedef struct _FolderListBoxRowClass FolderListBoxRowClass;

#define TYPE_KEY_LIST_BOX_ROW (key_list_box_row_get_type ())
#define KEY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_LIST_BOX_ROW, KeyListBoxRow))
#define KEY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_LIST_BOX_ROW, KeyListBoxRowClass))
#define IS_KEY_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_LIST_BOX_ROW))
#define IS_KEY_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_LIST_BOX_ROW))
#define KEY_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_LIST_BOX_ROW, KeyListBoxRowClass))

typedef struct _KeyListBoxRow KeyListBoxRow;
typedef struct _KeyListBoxRowClass KeyListBoxRowClass;
typedef struct _Block23Data Block23Data;

#define TYPE_GSETTINGS_KEY (gsettings_key_get_type ())
#define GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GSETTINGS_KEY, GSettingsKey))
#define GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GSETTINGS_KEY, GSettingsKeyClass))
#define IS_GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GSETTINGS_KEY))
#define IS_GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GSETTINGS_KEY))
#define GSETTINGS_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GSETTINGS_KEY, GSettingsKeyClass))

typedef struct _GSettingsKey GSettingsKey;
typedef struct _GSettingsKeyClass GSettingsKeyClass;

#define TYPE_KEY_LIST_BOX_ROW_EDITABLE (key_list_box_row_editable_get_type ())
#define KEY_LIST_BOX_ROW_EDITABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE, KeyListBoxRowEditable))
#define KEY_LIST_BOX_ROW_EDITABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_LIST_BOX_ROW_EDITABLE, KeyListBoxRowEditableClass))
#define IS_KEY_LIST_BOX_ROW_EDITABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE))
#define IS_KEY_LIST_BOX_ROW_EDITABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_LIST_BOX_ROW_EDITABLE))
#define KEY_LIST_BOX_ROW_EDITABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE, KeyListBoxRowEditableClass))

typedef struct _KeyListBoxRowEditable KeyListBoxRowEditable;
typedef struct _KeyListBoxRowEditableClass KeyListBoxRowEditableClass;

#define TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA (key_list_box_row_editable_no_schema_get_type ())
#define KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA, KeyListBoxRowEditableNoSchema))
#define KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA, KeyListBoxRowEditableNoSchemaClass))
#define IS_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA))
#define IS_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA))
#define KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_LIST_BOX_ROW_EDITABLE_NO_SCHEMA, KeyListBoxRowEditableNoSchemaClass))

typedef struct _KeyListBoxRowEditableNoSchema KeyListBoxRowEditableNoSchema;
typedef struct _KeyListBoxRowEditableNoSchemaClass KeyListBoxRowEditableNoSchemaClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block24Data Block24Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PathElementIface {
	GTypeInterface parent_iface;
};

struct _RegistryView {
	GtkGrid parent_instance;
	RegistryViewPrivate * priv;
};

struct _RegistryViewClass {
	GtkGridClass parent_class;
};

typedef enum  {
	BEHAVIOUR_UNSAFE,
	BEHAVIOUR_SAFE,
	BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT,
	BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT,
	BEHAVIOUR_ALWAYS_DELAY
} Behaviour;

struct _RegistryViewPrivate {
	gchar* _current_path;
	gboolean _show_search_bar;
	Behaviour _behaviour;
	SettingsModel* model;
	GtkTreeView* dir_tree_view;
	GtkTreeSelection* dir_tree_selection;
	GtkStack* stack;
	RegistryInfo* properties_view;
	GtkListBox* key_list_box;
	GListStore* key_model;
	GListStore* rows_possibly_with_popover;
	ModificationsRevealer* revealer;
	GtkSearchBar* search_bar;
	GtkSearchEntry* search_entry;
	GtkButton* search_next_button;
};

struct _Block22Data {
	int _ref_count_;
	RegistryView* self;
	ClickableListBoxRow* row;
	SettingObject* setting_object;
	gulong on_row_clicked_handler;
	gulong button_press_event_handler;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
	Key* key;
	KeyListBoxRow* key_row;
	gulong set_key_value_handler;
	gulong change_dismissed_handler;
	gulong key_planned_change_handler;
	gulong key_planned_value_handler;
};

struct _Block24Data {
	int _ref_count_;
	RegistryView* self;
	gulong revealer_reload_handler;
	GtkEntryBuffer* buffer;
	gulong search_entry_buffer_deleted_text_handler;
};


static gpointer registry_view_parent_class = NULL;
static PathElementIface* registry_view_path_element_parent_iface = NULL;

GType path_element_get_type (void) G_GNUC_CONST;
GType registry_view_get_type (void) G_GNUC_CONST;
GType behaviour_get_type (void) G_GNUC_CONST;
GType settings_model_get_type (void) G_GNUC_CONST;
GType registry_info_get_type (void) G_GNUC_CONST;
GType modifications_revealer_get_type (void) G_GNUC_CONST;
#define REGISTRY_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_REGISTRY_VIEW, RegistryViewPrivate))
enum  {
	REGISTRY_VIEW_0_PROPERTY,
	REGISTRY_VIEW_CURRENT_PATH_PROPERTY,
	REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY,
	REGISTRY_VIEW_BEHAVIOUR_PROPERTY
};
SettingsModel* settings_model_new (void);
SettingsModel* settings_model_construct (GType object_type);
GType clickable_list_box_row_get_type (void) G_GNUC_CONST;
void registry_view_init (RegistryView* self, const gchar* path, gboolean restore_view);
static void registry_view_set_current_path (RegistryView* self, const gchar* value);
void registry_view_path_requested (RegistryView* self, const gchar* _full_name, const gchar* selected);
const gchar* registry_view_get_current_path (RegistryView* self);
static void registry_view_show_browse_view (RegistryView* self, const gchar* path, const gchar* selected, gboolean grab);
static void registry_view_update_current_path (RegistryView* self, const gchar* path);
static gint registry_view_get_row_position (RegistryView* self, const gchar* selected);
static void registry_view_scroll_to_row (RegistryView* self, GtkListBoxRow* row, gboolean grab);
void registry_info_clean (RegistryInfo* self);
GType setting_object_get_type (void) G_GNUC_CONST;
const gchar* setting_object_get_full_name (SettingObject* self);
static void registry_view_show_properties_view (RegistryView* self, const gchar* path);
void modifications_revealer_path_changed (ModificationsRevealer* self);
GType dconf_window_get_type (void) G_GNUC_CONST;
static DConfWindow* registry_view_get_dconf_window (RegistryView* self);
void dconf_window_update_path_elements (DConfWindow* self);
void registry_view_invalidate_popovers (RegistryView* self);
static void registry_view_dir_selected_cb (RegistryView* self);
GType directory_get_type (void) G_GNUC_CONST;
static Directory* registry_view_get_selected_directory (RegistryView* self);
GListStore* directory_get_key_model (Directory* self);
static GtkWidget* registry_view_new_list_box_row (RegistryView* self, GObject* item);
static GtkWidget* _registry_view_new_list_box_row_gtk_list_box_create_widget_func (GObject* item, gpointer self);
static void _registry_view_dir_selected_cb_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
Directory* settings_model_get_directory (SettingsModel* self, GtkTreeIter* iter);
Directory* settings_model_get_root_directory (SettingsModel* self);
gchar* dconf_window_stripped_path (const gchar* path);
static gboolean registry_view_select_folder (RegistryView* self, const gchar* full_name);
void dconf_window_show_notification (DConfWindow* self, const gchar* notification);
GType key_get_type (void) G_GNUC_CONST;
static Key* registry_view_get_key_from_name (RegistryView* self, const gchar* key_name);
GType dconf_key_get_type (void) G_GNUC_CONST;
gboolean dconf_key_get_is_ghost (DConfKey* self);
void registry_info_populate_properties_list_box (RegistryInfo* self, Key* key);
static gboolean registry_view_get_next_iter (RegistryView* self, GtkTreeIter* iter);
const gchar* setting_object_get_name (SettingObject* self);
GtkWidget* _dconf_window_get_parent (GtkWidget* widget);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
FolderListBoxRow* folder_list_box_row_new (const gchar* label, const gchar* path);
FolderListBoxRow* folder_list_box_row_construct (GType object_type, const gchar* label, const gchar* path);
GType folder_list_box_row_get_type (void) G_GNUC_CONST;
GType key_list_box_row_get_type (void) G_GNUC_CONST;
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
GType gsettings_key_get_type (void) G_GNUC_CONST;
KeyListBoxRowEditable* key_list_box_row_editable_new (GSettingsKey* _key);
KeyListBoxRowEditable* key_list_box_row_editable_construct (GType object_type, GSettingsKey* _key);
GType key_list_box_row_editable_get_type (void) G_GNUC_CONST;
KeyListBoxRowEditableNoSchema* key_list_box_row_editable_no_schema_new (DConfKey* _key);
KeyListBoxRowEditableNoSchema* key_list_box_row_editable_no_schema_construct (GType object_type, DConfKey* _key);
GType key_list_box_row_editable_no_schema_get_type (void) G_GNUC_CONST;
static void ___lambda74_ (Block23Data* _data23_, GVariant* variant);
static void registry_view_set_key_value (RegistryView* self, Key* key, GVariant* new_value);
static void registry_view_set_delayed_icon (RegistryView* self, ClickableListBoxRow* row, Key* key);
static void ____lambda74__key_list_box_row_set_key_value (KeyListBoxRow* _sender, GVariant* new_value, gpointer self);
static void ___lambda75_ (Block23Data* _data23_);
void modifications_revealer_dismiss_change (ModificationsRevealer* self, Key* key);
static void ____lambda75__key_list_box_row_change_dismissed (KeyListBoxRow* _sender, gpointer self);
static void ___lambda76_ (Block23Data* _data23_);
static void ____lambda76__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda77_ (Block23Data* _data23_);
static void ____lambda77__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda78_ (Block23Data* _data23_);
static void ____lambda78__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void __lambda79_ (Block22Data* _data22_);
static void ___lambda79__clickable_list_box_row_on_row_clicked (ClickableListBoxRow* _sender, gpointer self);
static gboolean registry_view_on_button_pressed (RegistryView* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _registry_view_on_button_pressed_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void __lambda80_ (Block22Data* _data22_);
static void ___lambda80__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
gboolean key_get_planned_change (Key* self);
GVariant* key_get_planned_value (Key* self);
void clickable_list_box_row_show_right_click_popover (ClickableListBoxRow* self, gboolean delayed_apply_menu, gint event_x);
gboolean registry_view_get_current_delay_mode (RegistryView* self);
static void registry_view_row_activated_cb (RegistryView* self, GtkListBoxRow* list_box_row);
static void _registry_view_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
void clickable_list_box_row_destroy_popover (ClickableListBoxRow* self);
void dconf_window_update_hamburger_menu (DConfWindow* self);
gboolean modifications_revealer_get_current_delay_mode (ModificationsRevealer* self);
void registry_view_enter_delay_mode (RegistryView* self);
void modifications_revealer_enter_delay_mode (ModificationsRevealer* self);
void modifications_revealer_add_delayed_setting (ModificationsRevealer* self, Key* key, GVariant* new_value);
void key_set_value (Key* self, GVariant* value);
void gsettings_key_set_to_default (GSettingsKey* self);
Behaviour registry_view_get_behaviour (RegistryView* self);
void dconf_key_erase (DConfKey* self);
void registry_view_reset (RegistryView* self, gboolean recursively);
static void registry_view_reset_generic (RegistryView* self, GListStore* objects, gboolean recursively);
void modifications_revealer_warn_if_no_planned_changes (ModificationsRevealer* self);
gboolean gsettings_key_get_is_default (GSettingsKey* self);
void registry_view_set_search_mode (RegistryView* self, gboolean* mode);
gboolean registry_view_handle_search_event (RegistryView* self, GdkEventKey* event);
gboolean registry_view_show_row_popover (RegistryView* self);
gchar* registry_view_get_copy_text (RegistryView* self);
gchar* registry_info_get_copy_text (RegistryInfo* self);
gchar* clickable_list_box_row_get_text (ClickableListBoxRow* self);
void registry_view_discard_row_popover (RegistryView* self);
void clickable_list_box_row_hide_right_click_popover (ClickableListBoxRow* self);
static void registry_view_find_next_cb (RegistryView* self);
static gboolean registry_view_key_matches (RegistryView* self, Key* key, const gchar* text);
static void _registry_view_find_next_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean gsettings_key_search_for (GSettingsKey* self, const gchar* text);
GVariant* key_get_value (Key* self);
RegistryView* registry_view_new (void);
RegistryView* registry_view_construct (GType object_type);
gboolean registry_view_get_show_search_bar (RegistryView* self);
void registry_view_set_show_search_bar (RegistryView* self, gboolean value);
void registry_view_set_behaviour (RegistryView* self, Behaviour value);
static GObject * registry_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void _registry_view_invalidate_popovers_modifications_revealer_reload (ModificationsRevealer* _sender, gpointer self);
static void _registry_view___lambda81_ (RegistryView* self);
static void __registry_view___lambda81__gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self);
static void _registry_view___lambda82_ (Block24Data* _data24_);
static void __registry_view___lambda82__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void registry_view_finalize (GObject* obj);
static void _vala_registry_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_registry_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


void registry_view_init (RegistryView* self, const gchar* path, gboolean restore_view) {
	GtkTreeView* _tmp0_ = NULL;
	SettingsModel* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->dir_tree_view;
	_tmp1_ = self->priv->model;
	gtk_tree_view_set_model (_tmp0_, (GtkTreeModel*) _tmp1_);
	_tmp2_ = self->priv->dir_tree_view;
	gtk_tree_view_expand_all (_tmp2_);
	_tmp6_ = restore_view;
	if (_tmp6_) {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_ = NULL;
		gchar _tmp9_ = '\0';
		_tmp8_ = path;
		_tmp9_ = string_get (_tmp8_, (glong) 0);
		_tmp4_ = _tmp9_ == '/';
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = path;
		_tmp3_ = _tmp10_;
	} else {
		_tmp3_ = "/";
	}
	registry_view_set_current_path (self, _tmp3_);
	_tmp11_ = self->priv->_current_path;
	registry_view_path_requested (self, _tmp11_, NULL);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void registry_view_show_browse_view (RegistryView* self, const gchar* path, const gchar* selected, gboolean grab) {
	GtkStackTransitionType _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkStack* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkStack* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RegistryInfo* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp1_ = self->priv->_current_path;
	_tmp2_ = path;
	_tmp3_ = g_str_has_prefix (_tmp1_, _tmp2_);
	if (_tmp3_) {
		_tmp0_ = GTK_STACK_TRANSITION_TYPE_CROSSFADE;
	} else {
		_tmp0_ = GTK_STACK_TRANSITION_TYPE_NONE;
	}
	_tmp4_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp4_, _tmp0_);
	_tmp5_ = path;
	registry_view_update_current_path (self, _tmp5_);
	_tmp6_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp6_, "browse-view");
	_tmp7_ = selected;
	if (_tmp7_ != NULL) {
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		GtkListBoxRow* _tmp11_ = NULL;
		GtkListBoxRow* _tmp12_ = NULL;
		GtkListBoxRow* _tmp13_ = NULL;
		GtkListBoxRow* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gtk_container_check_resize ((GtkContainer*) self);
		_tmp8_ = self->priv->key_list_box;
		_tmp9_ = selected;
		_tmp10_ = registry_view_get_row_position (self, (const gchar*) _tmp9_);
		_tmp11_ = gtk_list_box_get_row_at_index (_tmp8_, _tmp10_);
		_tmp12_ = _g_object_ref0 (_tmp11_);
		row = _tmp12_;
		_tmp13_ = row;
		if (_tmp13_ == NULL) {
			g_assert_not_reached ();
		}
		_tmp14_ = row;
		_tmp15_ = grab;
		registry_view_scroll_to_row (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_list_box_row_get_type (), GtkListBoxRow), _tmp15_);
		_g_object_unref0 (row);
	} else {
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp16_ = NULL;
		GtkListBoxRow* _tmp17_ = NULL;
		GtkListBoxRow* _tmp18_ = NULL;
		GtkListBoxRow* _tmp19_ = NULL;
		_tmp16_ = self->priv->key_list_box;
		_tmp17_ = gtk_list_box_get_row_at_index (_tmp16_, 0);
		_tmp18_ = _g_object_ref0 (_tmp17_);
		row = _tmp18_;
		_tmp19_ = row;
		if (_tmp19_ != NULL) {
			GtkListBoxRow* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = row;
			_tmp21_ = grab;
			registry_view_scroll_to_row (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_list_box_row_get_type (), GtkListBoxRow), _tmp21_);
		}
		_g_object_unref0 (row);
	}
	_tmp22_ = self->priv->properties_view;
	registry_info_clean (_tmp22_);
}


static gint registry_view_get_row_position (RegistryView* self, const gchar* selected) {
	gint result = 0;
	GListStore* _tmp0_ = NULL;
	guint position = 0U;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (selected != NULL, 0);
	_tmp0_ = self->priv->key_model;
	_vala_return_val_if_fail (_tmp0_ != NULL, "key_model != null", 0);
	position = (guint) 0;
	while (TRUE) {
		guint _tmp1_ = 0U;
		GListStore* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		SettingObject* object = NULL;
		GListStore* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		GObject* _tmp6_ = NULL;
		SettingObject* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		guint _tmp12_ = 0U;
		_tmp1_ = position;
		_tmp2_ = self->priv->key_model;
		_tmp3_ = g_list_model_get_n_items ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_store_get_type (), GListStore));
		if (!(_tmp1_ < _tmp3_)) {
			break;
		}
		_tmp4_ = self->priv->key_model;
		_tmp5_ = position;
		_tmp6_ = g_list_model_get_object ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_list_store_get_type (), GListStore), _tmp5_);
		object = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_SETTING_OBJECT, SettingObject);
		_tmp7_ = object;
		_tmp8_ = setting_object_get_full_name (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = selected;
		if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
			guint _tmp11_ = 0U;
			_tmp11_ = position;
			result = (gint) _tmp11_;
			_g_object_unref0 (object);
			return result;
		}
		_tmp12_ = position;
		position = _tmp12_ + 1;
		_g_object_unref0 (object);
	}
	g_assert_not_reached ();
}


static void registry_view_scroll_to_row (RegistryView* self, GtkListBoxRow* row, gboolean grab) {
	GtkListBox* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkAllocation list_allocation = {0};
	GtkAllocation row_allocation = {0};
	GtkStack* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	GtkListBoxRow* _tmp6_ = NULL;
	GtkAllocation _tmp7_ = {0};
	GtkListBox* _tmp8_ = NULL;
	GtkAdjustment* _tmp9_ = NULL;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	GtkAllocation _tmp12_ = {0};
	gint _tmp13_ = 0;
	GtkAllocation _tmp14_ = {0};
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->key_list_box;
	_tmp1_ = row;
	gtk_list_box_select_row (_tmp0_, _tmp1_);
	_tmp2_ = grab;
	if (_tmp2_) {
		GtkListBoxRow* _tmp3_ = NULL;
		_tmp3_ = row;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	}
	_tmp4_ = self->priv->stack;
	gtk_widget_get_allocation ((GtkWidget*) _tmp4_, &_tmp5_);
	list_allocation = _tmp5_;
	_tmp6_ = row;
	gtk_widget_get_allocation ((GtkWidget*) _tmp6_, &_tmp7_);
	row_allocation = _tmp7_;
	_tmp8_ = self->priv->key_list_box;
	_tmp9_ = gtk_list_box_get_adjustment (_tmp8_);
	_tmp10_ = row_allocation;
	_tmp11_ = _tmp10_.y;
	_tmp12_ = row_allocation;
	_tmp13_ = _tmp12_.height;
	_tmp14_ = list_allocation;
	_tmp15_ = _tmp14_.height;
	gtk_adjustment_set_value (_tmp9_, (gdouble) (_tmp11_ + ((gint) ((_tmp13_ - _tmp15_) / 2.0))));
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void registry_view_show_properties_view (RegistryView* self, const gchar* path) {
	GtkStackTransitionType _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkStack* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkStack* _tmp12_ = NULL;
	RegistryInfo* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp2_ = path;
	_tmp3_ = self->priv->_current_path;
	_tmp4_ = g_str_has_prefix (_tmp2_, _tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp5_ = self->priv->_current_path;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = path;
		_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '/', 0);
		_tmp1_ = _tmp7_ == (_tmp9_ + 1);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = GTK_STACK_TRANSITION_TYPE_CROSSFADE;
	} else {
		_tmp0_ = GTK_STACK_TRANSITION_TYPE_NONE;
	}
	_tmp10_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp10_, _tmp0_);
	_tmp11_ = path;
	registry_view_update_current_path (self, _tmp11_);
	_tmp12_ = self->priv->stack;
	_tmp13_ = self->priv->properties_view;
	gtk_stack_set_visible_child (_tmp12_, (GtkWidget*) _tmp13_);
}


static void registry_view_update_current_path (RegistryView* self, const gchar* path) {
	ModificationsRevealer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	DConfWindow* _tmp2_ = NULL;
	DConfWindow* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->revealer;
	modifications_revealer_path_changed (_tmp0_);
	_tmp1_ = path;
	registry_view_set_current_path (self, _tmp1_);
	_tmp2_ = registry_view_get_dconf_window (self);
	_tmp3_ = _tmp2_;
	dconf_window_update_path_elements (_tmp3_);
	_g_object_unref0 (_tmp3_);
	registry_view_invalidate_popovers (self);
}


static GtkWidget* _registry_view_new_list_box_row_gtk_list_box_create_widget_func (GObject* item, gpointer self) {
	GtkWidget* result;
	result = registry_view_new_list_box_row ((RegistryView*) self, item);
	return result;
}


static void registry_view_dir_selected_cb (RegistryView* self) {
	GtkButton* _tmp0_ = NULL;
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	GListStore* _tmp3_ = NULL;
	GListStore* _tmp4_ = NULL;
	GListStore* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	GListStore* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = registry_view_get_selected_directory (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = directory_get_key_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->key_model);
	self->priv->key_model = _tmp5_;
	_g_object_unref0 (_tmp2_);
	_tmp6_ = self->priv->key_list_box;
	_tmp7_ = self->priv->key_model;
	gtk_list_box_bind_model (_tmp6_, (GListModel*) _tmp7_, _registry_view_new_list_box_row_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
}


static void _registry_view_dir_selected_cb_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	registry_view_dir_selected_cb ((RegistryView*) self);
}


static Directory* registry_view_get_selected_directory (RegistryView* self) {
	Directory* result = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dir_tree_selection;
	_tmp2_ = gtk_tree_selection_get_selected (_tmp0_, NULL, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		SettingsModel* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
		Directory* _tmp5_ = NULL;
		_tmp3_ = self->priv->model;
		_tmp4_ = iter;
		_tmp5_ = settings_model_get_directory (_tmp3_, &_tmp4_);
		result = _tmp5_;
		return result;
	} else {
		SettingsModel* _tmp6_ = NULL;
		Directory* _tmp7_ = NULL;
		_tmp6_ = self->priv->model;
		_tmp7_ = settings_model_get_root_directory (_tmp6_);
		result = _tmp7_;
		return result;
	}
}


void registry_view_path_requested (RegistryView* self, const gchar* _full_name, const gchar* selected) {
	gchar* full_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* folder_name = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar** names = NULL;
	const gchar* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gint names_length1 = 0;
	gint _names_size_ = 0;
	gchar* key_name = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	Key* key = NULL;
	const gchar* _tmp27_ = NULL;
	Key* _tmp28_ = NULL;
	Key* _tmp29_ = NULL;
	gboolean _tmp37_ = FALSE;
	Key* _tmp38_ = NULL;
	RegistryInfo* _tmp53_ = NULL;
	Key* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_full_name != NULL);
	_tmp0_ = _full_name;
	_tmp1_ = g_strdup (_tmp0_);
	full_name = _tmp1_;
	_tmp2_ = full_name;
	_tmp3_ = g_str_has_suffix (_tmp2_, "/");
	if (_tmp3_) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = full_name;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (folder_name);
		folder_name = _tmp5_;
	} else {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = full_name;
		_tmp7_ = dconf_window_stripped_path (_tmp6_);
		_g_free0 (folder_name);
		folder_name = _tmp7_;
	}
	_tmp8_ = folder_name;
	_tmp9_ = registry_view_select_folder (self, _tmp8_);
	if (!_tmp9_) {
		DConfWindow* _tmp10_ = NULL;
		DConfWindow* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp10_ = registry_view_get_dconf_window (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = _ ("Cannot find folder \"%s\".");
		_tmp13_ = folder_name;
		_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
		_tmp15_ = _tmp14_;
		dconf_window_show_notification (_tmp11_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_object_unref0 (_tmp11_);
		registry_view_set_current_path (self, "/");
		registry_view_show_browse_view (self, "/", NULL, TRUE);
		_g_free0 (folder_name);
		_g_free0 (full_name);
		return;
	}
	_tmp16_ = full_name;
	_tmp17_ = folder_name;
	if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp18_ = full_name;
		_tmp19_ = selected;
		registry_view_show_browse_view (self, _tmp18_, _tmp19_, TRUE);
		_g_free0 (folder_name);
		_g_free0 (full_name);
		return;
	}
	_tmp20_ = full_name;
	_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, "/", 0);
	names = _tmp22_;
	names_length1 = _vala_array_length (_tmp21_);
	_names_size_ = names_length1;
	_tmp23_ = names;
	_tmp23__length1 = names_length1;
	_tmp24_ = names;
	_tmp24__length1 = names_length1;
	_tmp25_ = _tmp23_[_tmp24__length1 - 1];
	_tmp26_ = g_strdup (_tmp25_);
	key_name = _tmp26_;
	_tmp27_ = key_name;
	_tmp28_ = registry_view_get_key_from_name (self, _tmp27_);
	key = _tmp28_;
	_tmp29_ = key;
	if (_tmp29_ == NULL) {
		const gchar* _tmp30_ = NULL;
		DConfWindow* _tmp31_ = NULL;
		DConfWindow* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		_tmp30_ = folder_name;
		registry_view_show_browse_view (self, _tmp30_, NULL, TRUE);
		_tmp31_ = registry_view_get_dconf_window (self);
		_tmp32_ = _tmp31_;
		_tmp33_ = _ ("Cannot find key \"%s\" here.");
		_tmp34_ = key_name;
		_tmp35_ = g_strdup_printf (_tmp33_, _tmp34_);
		_tmp36_ = _tmp35_;
		dconf_window_show_notification (_tmp32_, _tmp36_);
		_g_free0 (_tmp36_);
		_g_object_unref0 (_tmp32_);
		_g_object_unref0 (key);
		_g_free0 (key_name);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (folder_name);
		_g_free0 (full_name);
		return;
	}
	_tmp38_ = key;
	if (G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_KEY, Key), TYPE_DCONF_KEY)) {
		Key* _tmp39_ = NULL;
		gboolean _tmp40_ = FALSE;
		gboolean _tmp41_ = FALSE;
		_tmp39_ = key;
		_tmp40_ = dconf_key_get_is_ghost (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_KEY, Key), TYPE_DCONF_KEY, DConfKey));
		_tmp41_ = _tmp40_;
		_tmp37_ = _tmp41_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		const gchar* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		DConfWindow* _tmp47_ = NULL;
		DConfWindow* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		_tmp42_ = folder_name;
		_tmp43_ = folder_name;
		_tmp44_ = key_name;
		_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
		_tmp46_ = _tmp45_;
		registry_view_show_browse_view (self, _tmp42_, _tmp46_, TRUE);
		_g_free0 (_tmp46_);
		_tmp47_ = registry_view_get_dconf_window (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = _ ("Key \"%s\" has been removed.");
		_tmp50_ = key_name;
		_tmp51_ = g_strdup_printf (_tmp49_, _tmp50_);
		_tmp52_ = _tmp51_;
		dconf_window_show_notification (_tmp48_, _tmp52_);
		_g_free0 (_tmp52_);
		_g_object_unref0 (_tmp48_);
		_g_object_unref0 (key);
		_g_free0 (key_name);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (folder_name);
		_g_free0 (full_name);
		return;
	}
	_tmp53_ = self->priv->properties_view;
	_tmp54_ = key;
	registry_info_populate_properties_list_box (_tmp53_, G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_KEY, Key));
	_tmp55_ = full_name;
	registry_view_show_properties_view (self, _tmp55_);
	_g_object_unref0 (key);
	_g_free0 (key_name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (folder_name);
	_g_free0 (full_name);
	return;
}


static gboolean registry_view_select_folder (RegistryView* self, const gchar* full_name) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GtkTreeIter iter = {0};
	Directory* dir = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	SettingsModel* _tmp12_ = NULL;
	GtkTreeIter _tmp13_ = {0};
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (full_name != NULL, FALSE);
	_tmp0_ = full_name;
	if (g_strcmp0 (_tmp0_, "/") == 0) {
		GtkTreeSelection* _tmp1_ = NULL;
		_tmp1_ = self->priv->dir_tree_selection;
		gtk_tree_selection_unselect_all (_tmp1_);
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->dir_tree_selection;
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		SettingsModel* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		Directory* _tmp7_ = NULL;
		Directory* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp5_ = self->priv->model;
		_tmp6_ = iter;
		_tmp7_ = settings_model_get_directory (_tmp5_, &_tmp6_);
		_g_object_unref0 (dir);
		dir = _tmp7_;
		_tmp8_ = dir;
		_tmp9_ = setting_object_get_full_name ((SettingObject*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = full_name;
		if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
			result = TRUE;
			_g_object_unref0 (dir);
			return result;
		}
	}
	_tmp12_ = self->priv->model;
	_tmp14_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp12_, &_tmp13_);
	iter = _tmp13_;
	if (_tmp14_) {
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				SettingsModel* _tmp17_ = NULL;
				GtkTreeIter _tmp18_ = {0};
				Directory* _tmp19_ = NULL;
				Directory* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				if (!_tmp15_) {
					gboolean _tmp16_ = FALSE;
					_tmp16_ = registry_view_get_next_iter (self, &iter);
					if (!_tmp16_) {
						break;
					}
				}
				_tmp15_ = FALSE;
				_tmp17_ = self->priv->model;
				_tmp18_ = iter;
				_tmp19_ = settings_model_get_directory (_tmp17_, &_tmp18_);
				_g_object_unref0 (dir);
				dir = _tmp19_;
				_tmp20_ = dir;
				_tmp21_ = setting_object_get_full_name ((SettingObject*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = full_name;
				if (g_strcmp0 (_tmp22_, _tmp23_) == 0) {
					GtkTreeSelection* _tmp24_ = NULL;
					GtkTreeIter _tmp25_ = {0};
					_tmp24_ = self->priv->dir_tree_selection;
					_tmp25_ = iter;
					gtk_tree_selection_select_iter (_tmp24_, &_tmp25_);
					result = TRUE;
					_g_object_unref0 (dir);
					return result;
				}
			}
		}
	} else {
		g_assert_not_reached ();
	}
	result = FALSE;
	_g_object_unref0 (dir);
	return result;
}


static Key* registry_view_get_key_from_name (RegistryView* self, const gchar* key_name) {
	Key* result = NULL;
	GListStore* _tmp0_ = NULL;
	guint position = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_name != NULL, NULL);
	_tmp0_ = self->priv->key_model;
	_vala_return_val_if_fail (_tmp0_ != NULL, "key_model != null", NULL);
	position = (guint) 0;
	while (TRUE) {
		guint _tmp1_ = 0U;
		GListStore* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		SettingObject* object = NULL;
		GListStore* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		GObject* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		SettingObject* _tmp8_ = NULL;
		guint _tmp15_ = 0U;
		_tmp1_ = position;
		_tmp2_ = self->priv->key_model;
		_tmp3_ = g_list_model_get_n_items ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_store_get_type (), GListStore));
		if (!(_tmp1_ < _tmp3_)) {
			break;
		}
		_tmp4_ = self->priv->key_model;
		_tmp5_ = position;
		_tmp6_ = g_list_model_get_object ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_list_store_get_type (), GListStore), _tmp5_);
		object = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_SETTING_OBJECT, SettingObject);
		_tmp8_ = object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_KEY)) {
			SettingObject* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp9_ = object;
			_tmp10_ = setting_object_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = key_name;
			_tmp7_ = g_strcmp0 (_tmp11_, _tmp12_) == 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			SettingObject* _tmp13_ = NULL;
			Key* _tmp14_ = NULL;
			_tmp13_ = object;
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_KEY, Key));
			result = _tmp14_;
			_g_object_unref0 (object);
			return result;
		}
		_tmp15_ = position;
		position = _tmp15_ + 1;
		_g_object_unref0 (object);
	}
	result = NULL;
	return result;
}


static DConfWindow* registry_view_get_dconf_window (RegistryView* self) {
	DConfWindow* result = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	DConfWindow* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _dconf_window_get_parent ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _dconf_window_get_parent (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DCONF_WINDOW, DConfWindow);
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		RegistryView* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->setting_object);
		_g_object_unref0 (_data22_->row);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}


static void block23_data_unref (void * _userdata_) {
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		RegistryView* self;
		self = _data23_->_data22_->self;
		_g_object_unref0 (_data23_->key_row);
		_g_object_unref0 (_data23_->key);
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}


static void ___lambda74_ (Block23Data* _data23_, GVariant* variant) {
	Block22Data* _data22_;
	RegistryView* self;
	Key* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	ClickableListBoxRow* _tmp2_ = NULL;
	Key* _tmp3_ = NULL;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data23_->key;
	_tmp1_ = variant;
	registry_view_set_key_value (self, _tmp0_, _tmp1_);
	_tmp2_ = _data22_->row;
	_tmp3_ = _data23_->key;
	registry_view_set_delayed_icon (self, _tmp2_, _tmp3_);
}


static void ____lambda74__key_list_box_row_set_key_value (KeyListBoxRow* _sender, GVariant* new_value, gpointer self) {
	___lambda74_ (self, new_value);
}


static void ___lambda75_ (Block23Data* _data23_) {
	Block22Data* _data22_;
	RegistryView* self;
	ModificationsRevealer* _tmp0_ = NULL;
	Key* _tmp1_ = NULL;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = self->priv->revealer;
	_tmp1_ = _data23_->key;
	modifications_revealer_dismiss_change (_tmp0_, _tmp1_);
}


static void ____lambda75__key_list_box_row_change_dismissed (KeyListBoxRow* _sender, gpointer self) {
	___lambda75_ (self);
}


static void ___lambda76_ (Block23Data* _data23_) {
	Block22Data* _data22_;
	RegistryView* self;
	ClickableListBoxRow* _tmp0_ = NULL;
	Key* _tmp1_ = NULL;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data22_->row;
	_tmp1_ = _data23_->key;
	registry_view_set_delayed_icon (self, _tmp0_, _tmp1_);
}


static void ____lambda76__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda76_ (self);
}


static void ___lambda77_ (Block23Data* _data23_) {
	Block22Data* _data22_;
	RegistryView* self;
	ClickableListBoxRow* _tmp0_ = NULL;
	Key* _tmp1_ = NULL;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data22_->row;
	_tmp1_ = _data23_->key;
	registry_view_set_delayed_icon (self, _tmp0_, _tmp1_);
}


static void ____lambda77__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda77_ (self);
}


static void ___lambda78_ (Block23Data* _data23_) {
	Block22Data* _data22_;
	RegistryView* self;
	KeyListBoxRow* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	KeyListBoxRow* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	Key* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
	Key* _tmp6_ = NULL;
	gulong _tmp7_ = 0UL;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	_tmp0_ = _data23_->key_row;
	_tmp1_ = _data23_->set_key_value_handler;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	_tmp2_ = _data23_->key_row;
	_tmp3_ = _data23_->change_dismissed_handler;
	g_signal_handler_disconnect ((GObject*) _tmp2_, _tmp3_);
	_tmp4_ = _data23_->key;
	_tmp5_ = _data23_->key_planned_change_handler;
	g_signal_handler_disconnect ((GObject*) _tmp4_, _tmp5_);
	_tmp6_ = _data23_->key;
	_tmp7_ = _data23_->key_planned_value_handler;
	g_signal_handler_disconnect ((GObject*) _tmp6_, _tmp7_);
}


static void ____lambda78__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	___lambda78_ (self);
}


static void __lambda79_ (Block22Data* _data22_) {
	RegistryView* self;
	SettingObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	self = _data22_->self;
	_tmp0_ = _data22_->setting_object;
	_tmp1_ = setting_object_get_full_name (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name ((PathElement*) self, "request-path", _tmp2_);
}


static void ___lambda79__clickable_list_box_row_on_row_clicked (ClickableListBoxRow* _sender, gpointer self) {
	__lambda79_ (self);
}


static gboolean _registry_view_on_button_pressed_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = registry_view_on_button_pressed ((RegistryView*) self, _sender, event);
	return result;
}


static void __lambda80_ (Block22Data* _data22_) {
	RegistryView* self;
	ClickableListBoxRow* _tmp0_ = NULL;
	ClickableListBoxRow* _tmp1_ = NULL;
	self = _data22_->self;
	_tmp0_ = _data22_->row;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data22_->on_row_clicked_handler);
	_tmp1_ = _data22_->row;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data22_->button_press_event_handler);
}


static void ___lambda80__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda80_ (self);
}


static GtkWidget* registry_view_new_list_box_row (RegistryView* self, GObject* item) {
	GtkWidget* result = NULL;
	Block22Data* _data22_;
	GObject* _tmp0_ = NULL;
	SettingObject* _tmp1_ = NULL;
	SettingObject* _tmp2_ = NULL;
	ClickableListBoxRow* _tmp30_ = NULL;
	gulong _tmp31_ = 0UL;
	ClickableListBoxRow* _tmp32_ = NULL;
	gulong _tmp33_ = 0UL;
	ClickableListBoxRow* _tmp34_ = NULL;
	ClickableListBoxRow* _tmp35_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = item;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SETTING_OBJECT, SettingObject));
	_data22_->setting_object = _tmp1_;
	_tmp2_ = _data22_->setting_object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DIRECTORY)) {
		SettingObject* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		SettingObject* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FolderListBoxRow* _tmp9_ = NULL;
		_tmp3_ = _data22_->setting_object;
		_tmp4_ = setting_object_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _data22_->setting_object;
		_tmp7_ = setting_object_get_full_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = folder_list_box_row_new (_tmp5_, _tmp8_);
		g_object_ref_sink (_tmp9_);
		_g_object_unref0 (_data22_->row);
		_data22_->row = (ClickableListBoxRow*) _tmp9_;
	} else {
		Block23Data* _data23_;
		SettingObject* _tmp10_ = NULL;
		SettingObject* _tmp15_ = NULL;
		Key* _tmp16_ = NULL;
		ClickableListBoxRow* _tmp17_ = NULL;
		KeyListBoxRow* _tmp18_ = NULL;
		KeyListBoxRow* _tmp19_ = NULL;
		gulong _tmp20_ = 0UL;
		KeyListBoxRow* _tmp21_ = NULL;
		gulong _tmp22_ = 0UL;
		Key* _tmp23_ = NULL;
		gulong _tmp24_ = 0UL;
		Key* _tmp25_ = NULL;
		gulong _tmp26_ = 0UL;
		ClickableListBoxRow* _tmp27_ = NULL;
		Key* _tmp28_ = NULL;
		ClickableListBoxRow* _tmp29_ = NULL;
		_data23_ = g_slice_new0 (Block23Data);
		_data23_->_ref_count_ = 1;
		_data23_->_data22_ = block22_data_ref (_data22_);
		_tmp10_ = _data22_->setting_object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, TYPE_GSETTINGS_KEY)) {
			SettingObject* _tmp11_ = NULL;
			KeyListBoxRowEditable* _tmp12_ = NULL;
			_tmp11_ = _data22_->setting_object;
			_tmp12_ = key_list_box_row_editable_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_GSETTINGS_KEY, GSettingsKey));
			g_object_ref_sink (_tmp12_);
			_g_object_unref0 (_data22_->row);
			_data22_->row = (ClickableListBoxRow*) _tmp12_;
		} else {
			SettingObject* _tmp13_ = NULL;
			KeyListBoxRowEditableNoSchema* _tmp14_ = NULL;
			_tmp13_ = _data22_->setting_object;
			_tmp14_ = key_list_box_row_editable_no_schema_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DCONF_KEY, DConfKey));
			g_object_ref_sink (_tmp14_);
			_g_object_unref0 (_data22_->row);
			_data22_->row = (ClickableListBoxRow*) _tmp14_;
		}
		_tmp15_ = _data22_->setting_object;
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_KEY, Key));
		_data23_->key = _tmp16_;
		_tmp17_ = _data22_->row;
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_KEY_LIST_BOX_ROW, KeyListBoxRow));
		_data23_->key_row = _tmp18_;
		_tmp19_ = _data23_->key_row;
		_tmp20_ = g_signal_connect_data (_tmp19_, "set-key-value", (GCallback) ____lambda74__key_list_box_row_set_key_value, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->set_key_value_handler = _tmp20_;
		_tmp21_ = _data23_->key_row;
		_tmp22_ = g_signal_connect_data (_tmp21_, "change-dismissed", (GCallback) ____lambda75__key_list_box_row_change_dismissed, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->change_dismissed_handler = _tmp22_;
		_tmp23_ = _data23_->key;
		_tmp24_ = g_signal_connect_data ((GObject*) _tmp23_, "notify::planned-change", (GCallback) ____lambda76__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->key_planned_change_handler = _tmp24_;
		_tmp25_ = _data23_->key;
		_tmp26_ = g_signal_connect_data ((GObject*) _tmp25_, "notify::planned-value", (GCallback) ____lambda77__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->key_planned_value_handler = _tmp26_;
		_tmp27_ = _data22_->row;
		_tmp28_ = _data23_->key;
		registry_view_set_delayed_icon (self, _tmp27_, _tmp28_);
		_tmp29_ = _data22_->row;
		g_signal_connect_data ((GtkWidget*) _tmp29_, "destroy", (GCallback) ____lambda78__gtk_widget_destroy, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		block23_data_unref (_data23_);
		_data23_ = NULL;
	}
	_tmp30_ = _data22_->row;
	_tmp31_ = g_signal_connect_data (_tmp30_, "on-row-clicked", (GCallback) ___lambda79__clickable_list_box_row_on_row_clicked, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_data22_->on_row_clicked_handler = _tmp31_;
	_tmp32_ = _data22_->row;
	_tmp33_ = g_signal_connect_object ((GtkWidget*) _tmp32_, "button-press-event", (GCallback) _registry_view_on_button_pressed_gtk_widget_button_press_event, self, 0);
	_data22_->button_press_event_handler = _tmp33_;
	_tmp34_ = _data22_->row;
	g_signal_connect_data ((GtkWidget*) _tmp34_, "destroy", (GCallback) ___lambda80__gtk_widget_destroy, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_tmp35_ = _data22_->row;
	_tmp36_ = _g_object_ref0 ((GtkWidget*) _tmp35_);
	result = _tmp36_;
	block22_data_unref (_data22_);
	_data22_ = NULL;
	return result;
}


static void registry_view_set_delayed_icon (RegistryView* self, ClickableListBoxRow* row, Key* key) {
	Key* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp1_ = key_get_planned_change (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStyleContext* context = NULL;
		ClickableListBoxRow* _tmp3_ = NULL;
		GtkStyleContext* _tmp4_ = NULL;
		GtkStyleContext* _tmp5_ = NULL;
		GtkStyleContext* _tmp6_ = NULL;
		Key* _tmp7_ = NULL;
		_tmp3_ = row;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		context = _tmp5_;
		_tmp6_ = context;
		gtk_style_context_add_class (_tmp6_, "delayed");
		_tmp7_ = key;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_DCONF_KEY)) {
			Key* _tmp8_ = NULL;
			GVariant* _tmp9_ = NULL;
			GVariant* _tmp10_ = NULL;
			_tmp8_ = key;
			_tmp9_ = key_get_planned_value (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == NULL) {
				GtkStyleContext* _tmp11_ = NULL;
				_tmp11_ = context;
				gtk_style_context_add_class (_tmp11_, "erase");
			} else {
				GtkStyleContext* _tmp12_ = NULL;
				_tmp12_ = context;
				gtk_style_context_remove_class (_tmp12_, "erase");
			}
		}
		_g_object_unref0 (context);
	} else {
		ClickableListBoxRow* _tmp13_ = NULL;
		GtkStyleContext* _tmp14_ = NULL;
		_tmp13_ = row;
		_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
		gtk_style_context_remove_class (_tmp14_, "delayed");
	}
}


static gboolean registry_view_on_button_pressed (RegistryView* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkListBoxRow* list_box_row = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkListBoxRow* _tmp4_ = NULL;
	GtkListBoxRow* _tmp5_ = NULL;
	GdkEventButton* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	_tmp1_ = (GtkContainer*) gtk_widget_get_parent (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_row_get_type (), GtkListBoxRow));
	list_box_row = _tmp2_;
	_tmp3_ = self->priv->key_list_box;
	_tmp4_ = list_box_row;
	gtk_list_box_select_row (_tmp3_, _tmp4_);
	_tmp5_ = list_box_row;
	gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	_tmp6_ = event;
	_tmp7_ = _tmp6_->button;
	if (_tmp7_ == ((guint) GDK_BUTTON_SECONDARY)) {
		ClickableListBoxRow* row = NULL;
		GtkWidget* _tmp8_ = NULL;
		ClickableListBoxRow* _tmp9_ = NULL;
		ClickableListBoxRow* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		GdkEventButton* _tmp12_ = NULL;
		gdouble _tmp13_ = 0.0;
		GListStore* _tmp14_ = NULL;
		ClickableListBoxRow* _tmp15_ = NULL;
		_tmp8_ = widget;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
		row = _tmp9_;
		_tmp10_ = row;
		_tmp11_ = registry_view_get_current_delay_mode (self);
		_tmp12_ = event;
		_tmp13_ = _tmp12_->x;
		clickable_list_box_row_show_right_click_popover (_tmp10_, _tmp11_, (gint) _tmp13_);
		_tmp14_ = self->priv->rows_possibly_with_popover;
		_tmp15_ = row;
		g_list_store_append (_tmp14_, (GObject*) _tmp15_);
		_g_object_unref0 (row);
	}
	result = FALSE;
	_g_object_unref0 (list_box_row);
	return result;
}


static void registry_view_row_activated_cb (RegistryView* self, GtkListBoxRow* list_box_row) {
	GtkButton* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list_box_row != NULL);
	_tmp0_ = self->priv->search_next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = list_box_row;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) _tmp1_);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow), "on-row-clicked");
}


static void _registry_view_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	registry_view_row_activated_cb ((RegistryView*) self, row);
}


void registry_view_invalidate_popovers (RegistryView* self) {
	guint position = 0U;
	ClickableListBoxRow* row = NULL;
	GListStore* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GListStore* _tmp8_ = NULL;
	DConfWindow* _tmp9_ = NULL;
	DConfWindow* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	position = (guint) 0;
	_tmp0_ = self->priv->rows_possibly_with_popover;
	_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) 0);
	row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow);
	while (TRUE) {
		ClickableListBoxRow* _tmp2_ = NULL;
		ClickableListBoxRow* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		GListStore* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		GObject* _tmp7_ = NULL;
		_tmp2_ = row;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = row;
		clickable_list_box_row_destroy_popover (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
		_tmp4_ = position;
		position = _tmp4_ + 1;
		_tmp5_ = self->priv->rows_possibly_with_popover;
		_tmp6_ = position;
		_tmp7_ = g_list_model_get_item ((GListModel*) _tmp5_, _tmp6_);
		_g_object_unref0 (row);
		row = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow);
	}
	_tmp8_ = self->priv->rows_possibly_with_popover;
	g_list_store_remove_all (_tmp8_);
	_tmp9_ = registry_view_get_dconf_window (self);
	_tmp10_ = _tmp9_;
	dconf_window_update_hamburger_menu (_tmp10_);
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (row);
}


gboolean registry_view_get_current_delay_mode (RegistryView* self) {
	gboolean result = FALSE;
	ModificationsRevealer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->revealer;
	_tmp1_ = modifications_revealer_get_current_delay_mode (_tmp0_);
	result = _tmp1_;
	return result;
}


void registry_view_enter_delay_mode (RegistryView* self) {
	ModificationsRevealer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->revealer;
	modifications_revealer_enter_delay_mode (_tmp0_);
	registry_view_invalidate_popovers (self);
}


static void registry_view_set_key_value (RegistryView* self, Key* key, GVariant* new_value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = registry_view_get_current_delay_mode (self);
	if (_tmp0_) {
		ModificationsRevealer* _tmp1_ = NULL;
		Key* _tmp2_ = NULL;
		GVariant* _tmp3_ = NULL;
		_tmp1_ = self->priv->revealer;
		_tmp2_ = key;
		_tmp3_ = new_value;
		modifications_revealer_add_delayed_setting (_tmp1_, _tmp2_, _tmp3_);
	} else {
		GVariant* _tmp4_ = NULL;
		_tmp4_ = new_value;
		if (_tmp4_ != NULL) {
			Key* _tmp5_ = NULL;
			GVariant* _tmp6_ = NULL;
			_tmp5_ = key;
			_tmp6_ = new_value;
			key_set_value (_tmp5_, (GVariant*) _tmp6_);
		} else {
			Key* _tmp7_ = NULL;
			_tmp7_ = key;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_GSETTINGS_KEY)) {
				Key* _tmp8_ = NULL;
				_tmp8_ = key;
				gsettings_key_set_to_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_GSETTINGS_KEY, GSettingsKey));
			} else {
				Behaviour _tmp9_ = 0;
				_tmp9_ = self->priv->_behaviour;
				if (_tmp9_ != BEHAVIOUR_UNSAFE) {
					ModificationsRevealer* _tmp10_ = NULL;
					Key* _tmp11_ = NULL;
					registry_view_enter_delay_mode (self);
					_tmp10_ = self->priv->revealer;
					_tmp11_ = key;
					modifications_revealer_add_delayed_setting (_tmp10_, _tmp11_, NULL);
				} else {
					Key* _tmp12_ = NULL;
					_tmp12_ = key;
					dconf_key_erase (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DCONF_KEY, DConfKey));
				}
			}
		}
	}
}


void registry_view_reset (RegistryView* self, gboolean recursively) {
	GListStore* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ModificationsRevealer* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	registry_view_enter_delay_mode (self);
	_tmp0_ = self->priv->key_model;
	_tmp1_ = recursively;
	registry_view_reset_generic (self, _tmp0_, _tmp1_);
	_tmp2_ = self->priv->revealer;
	modifications_revealer_warn_if_no_planned_changes (_tmp2_);
}


static void registry_view_reset_generic (RegistryView* self, GListStore* objects, gboolean recursively) {
	GListStore* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = objects;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		guint position = 0U;
		position = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GObject* object = NULL;
				GListStore* _tmp3_ = NULL;
				guint _tmp4_ = 0U;
				GObject* _tmp5_ = NULL;
				GObject* _tmp6_ = NULL;
				SettingObject* setting_object = NULL;
				GObject* _tmp7_ = NULL;
				SettingObject* _tmp8_ = NULL;
				SettingObject* _tmp9_ = NULL;
				SettingObject* _tmp14_ = NULL;
				if (!_tmp1_) {
					guint _tmp2_ = 0U;
					_tmp2_ = position;
					position = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = objects;
				_tmp4_ = position;
				_tmp5_ = g_list_model_get_object ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_list_store_get_type (), GListStore), _tmp4_);
				object = _tmp5_;
				_tmp6_ = object;
				if (_tmp6_ == NULL) {
					_g_object_unref0 (object);
					return;
				}
				_tmp7_ = object;
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, G_TYPE_OBJECT, GObject), TYPE_SETTING_OBJECT, SettingObject));
				setting_object = _tmp8_;
				_tmp9_ = setting_object;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_DIRECTORY)) {
					gboolean _tmp10_ = FALSE;
					_tmp10_ = recursively;
					if (_tmp10_) {
						SettingObject* _tmp11_ = NULL;
						GListStore* _tmp12_ = NULL;
						GListStore* _tmp13_ = NULL;
						_tmp11_ = setting_object;
						_tmp12_ = directory_get_key_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DIRECTORY, Directory));
						_tmp13_ = _tmp12_;
						registry_view_reset_generic (self, _tmp13_, TRUE);
					}
					_g_object_unref0 (setting_object);
					_g_object_unref0 (object);
					continue;
				}
				_tmp14_ = setting_object;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, TYPE_DCONF_KEY)) {
					SettingObject* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					_tmp15_ = setting_object;
					_tmp16_ = dconf_key_get_is_ghost (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DCONF_KEY, DConfKey));
					_tmp17_ = _tmp16_;
					if (!_tmp17_) {
						ModificationsRevealer* _tmp18_ = NULL;
						SettingObject* _tmp19_ = NULL;
						_tmp18_ = self->priv->revealer;
						_tmp19_ = setting_object;
						modifications_revealer_add_delayed_setting (_tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_KEY, Key), NULL);
					}
				} else {
					SettingObject* _tmp20_ = NULL;
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					_tmp20_ = setting_object;
					_tmp21_ = gsettings_key_get_is_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_GSETTINGS_KEY, GSettingsKey));
					_tmp22_ = _tmp21_;
					if (!_tmp22_) {
						ModificationsRevealer* _tmp23_ = NULL;
						SettingObject* _tmp24_ = NULL;
						_tmp23_ = self->priv->revealer;
						_tmp24_ = setting_object;
						modifications_revealer_add_delayed_setting (_tmp23_, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_KEY, Key), NULL);
					}
				}
				_g_object_unref0 (setting_object);
				_g_object_unref0 (object);
			}
		}
	}
}


void registry_view_set_search_mode (RegistryView* self, gboolean* mode) {
	gboolean* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	if (_tmp0_ == NULL) {
		GtkSearchBar* _tmp1_ = NULL;
		GtkSearchBar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->search_bar;
		_tmp2_ = self->priv->search_bar;
		_tmp3_ = gtk_search_bar_get_search_mode (_tmp2_);
		gtk_search_bar_set_search_mode (_tmp1_, !_tmp3_);
	} else {
		GtkSearchBar* _tmp4_ = NULL;
		gboolean* _tmp5_ = NULL;
		_tmp4_ = self->priv->search_bar;
		_tmp5_ = mode;
		gtk_search_bar_set_search_mode (_tmp4_, (gboolean) (*_tmp5_));
	}
}


gboolean registry_view_handle_search_event (RegistryView* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkSearchBar* _tmp2_ = NULL;
	GdkEventKey* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "browse-view") != 0) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->search_bar;
	_tmp3_ = event;
	_tmp4_ = gtk_search_bar_handle_event (_tmp2_, (GdkEvent*) _tmp3_);
	result = _tmp4_;
	return result;
}


gboolean registry_view_show_row_popover (RegistryView* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkListBoxRow* selected_row = NULL;
	GtkListBox* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GtkListBoxRow* _tmp4_ = NULL;
	GtkListBoxRow* _tmp5_ = NULL;
	ClickableListBoxRow* row = NULL;
	GtkListBoxRow* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	ClickableListBoxRow* _tmp8_ = NULL;
	ClickableListBoxRow* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	GListStore* _tmp12_ = NULL;
	ClickableListBoxRow* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "browse-view") != 0) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->key_list_box;
	_tmp3_ = gtk_list_box_get_selected_row (_tmp2_);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_box_row_get_type (), GtkListBoxRow));
	selected_row = _tmp4_;
	_tmp5_ = selected_row;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_g_object_unref0 (selected_row);
		return result;
	}
	_tmp6_ = selected_row;
	_tmp7_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_row_get_type (), GtkListBoxRow));
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
	row = _tmp8_;
	_tmp9_ = row;
	_tmp10_ = registry_view_get_current_delay_mode (self);
	_tmp11_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	clickable_list_box_row_show_right_click_popover (_tmp9_, _tmp10_, (gint) (_tmp11_ / 2.0));
	_tmp12_ = self->priv->rows_possibly_with_popover;
	_tmp13_ = row;
	g_list_store_append (_tmp12_, (GObject*) _tmp13_);
	result = TRUE;
	_g_object_unref0 (row);
	_g_object_unref0 (selected_row);
	return result;
}


gchar* registry_view_get_copy_text (RegistryView* self) {
	gchar* result = NULL;
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "browse-view") != 0) {
		RegistryInfo* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = self->priv->properties_view;
		_tmp3_ = registry_info_get_copy_text (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		GtkListBoxRow* selected_row = NULL;
		GtkListBox* _tmp4_ = NULL;
		GtkListBoxRow* _tmp5_ = NULL;
		GtkListBoxRow* _tmp6_ = NULL;
		GtkListBoxRow* _tmp7_ = NULL;
		_tmp4_ = self->priv->key_list_box;
		_tmp5_ = gtk_list_box_get_selected_row (_tmp4_);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		selected_row = _tmp6_;
		_tmp7_ = selected_row;
		if (_tmp7_ == NULL) {
			result = NULL;
			_g_object_unref0 (selected_row);
			return result;
		} else {
			GtkListBoxRow* _tmp8_ = NULL;
			GtkWidget* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp8_ = selected_row;
			_tmp9_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_box_row_get_type (), GtkListBoxRow));
			_tmp10_ = clickable_list_box_row_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
			result = _tmp10_;
			_g_object_unref0 (selected_row);
			return result;
		}
		_g_object_unref0 (selected_row);
	}
}


void registry_view_discard_row_popover (RegistryView* self) {
	GtkListBoxRow* selected_row = NULL;
	GtkListBox* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GtkListBoxRow* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_list_box;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_row_get_type (), GtkListBoxRow));
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (selected_row);
		return;
	}
	_tmp4_ = selected_row;
	_tmp5_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_box_row_get_type (), GtkListBoxRow));
	clickable_list_box_row_hide_right_click_popover (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CLICKABLE_LIST_BOX_ROW, ClickableListBoxRow));
	_g_object_unref0 (selected_row);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void registry_view_find_next_cb (RegistryView* self) {
	GtkSearchBar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkTreeIter iter = {0};
	gboolean on_first_directory = FALSE;
	gint position = 0;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	GtkButton* _tmp87_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_bar;
	_tmp1_ = gtk_search_bar_get_search_mode (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	position = 0;
	_tmp2_ = self->priv->dir_tree_selection;
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
	iter = _tmp3_;
	if (_tmp4_) {
		GtkListBoxRow* selected_row = NULL;
		GtkListBox* _tmp5_ = NULL;
		GtkListBoxRow* _tmp6_ = NULL;
		GtkListBoxRow* _tmp7_ = NULL;
		GtkListBoxRow* _tmp8_ = NULL;
		_tmp5_ = self->priv->key_list_box;
		_tmp6_ = gtk_list_box_get_selected_row (_tmp5_);
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_row_get_type (), GtkListBoxRow));
		selected_row = _tmp7_;
		_tmp8_ = selected_row;
		if (_tmp8_ != NULL) {
			GtkListBoxRow* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			_tmp9_ = selected_row;
			_tmp10_ = gtk_list_box_row_get_index (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_list_box_row_get_type (), GtkListBoxRow));
			position = _tmp10_ + 1;
		}
		on_first_directory = TRUE;
		_g_object_unref0 (selected_row);
	} else {
		SettingsModel* _tmp11_ = NULL;
		GtkTreeIter _tmp12_ = {0};
		gboolean _tmp13_ = FALSE;
		_tmp11_ = self->priv->model;
		_tmp13_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp11_, &_tmp12_);
		iter = _tmp12_;
		if (_tmp13_) {
			on_first_directory = FALSE;
		} else {
			return;
		}
	}
	{
		gboolean _tmp14_ = FALSE;
		_tmp14_ = TRUE;
		while (TRUE) {
			Directory* dir = NULL;
			SettingsModel* _tmp16_ = NULL;
			GtkTreeIter _tmp17_ = {0};
			Directory* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			GListStore* key_model = NULL;
			Directory* _tmp32_ = NULL;
			GListStore* _tmp33_ = NULL;
			GListStore* _tmp34_ = NULL;
			GListStore* _tmp35_ = NULL;
			if (!_tmp14_) {
				gboolean _tmp15_ = FALSE;
				_tmp15_ = registry_view_get_next_iter (self, &iter);
				if (!_tmp15_) {
					break;
				}
			}
			_tmp14_ = FALSE;
			_tmp16_ = self->priv->model;
			_tmp17_ = iter;
			_tmp18_ = settings_model_get_directory (_tmp16_, &_tmp17_);
			dir = _tmp18_;
			_tmp19_ = on_first_directory;
			if (!_tmp19_) {
				Directory* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				GtkSearchEntry* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				_tmp20_ = dir;
				_tmp21_ = setting_object_get_name ((SettingObject*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = self->priv->search_entry;
				_tmp24_ = gtk_entry_get_text ((GtkEntry*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = string_index_of (_tmp22_, _tmp25_, 0);
				if (_tmp26_ >= 0) {
					GtkTreeSelection* _tmp27_ = NULL;
					GtkTreeIter _tmp28_ = {0};
					Directory* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					_tmp27_ = self->priv->dir_tree_selection;
					_tmp28_ = iter;
					gtk_tree_selection_select_iter (_tmp27_, &_tmp28_);
					_tmp29_ = dir;
					_tmp30_ = setting_object_get_full_name ((SettingObject*) _tmp29_);
					_tmp31_ = _tmp30_;
					registry_view_show_browse_view (self, _tmp31_, NULL, FALSE);
					_g_object_unref0 (dir);
					return;
				}
			} else {
				on_first_directory = FALSE;
			}
			_tmp32_ = dir;
			_tmp33_ = directory_get_key_model (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _g_object_ref0 (_tmp34_);
			key_model = _tmp35_;
			while (TRUE) {
				gint _tmp36_ = 0;
				GListStore* _tmp37_ = NULL;
				guint _tmp38_ = 0U;
				SettingObject* object = NULL;
				GListStore* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				GObject* _tmp41_ = NULL;
				SettingObject* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				GtkSearchEntry* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				gint _tmp86_ = 0;
				_tmp36_ = position;
				_tmp37_ = key_model;
				_tmp38_ = g_list_model_get_n_items ((GListModel*) _tmp37_);
				if (!(((guint) _tmp36_) < _tmp38_)) {
					break;
				}
				_tmp39_ = key_model;
				_tmp40_ = position;
				_tmp41_ = g_list_model_get_object ((GListModel*) _tmp39_, (guint) _tmp40_);
				object = G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_SETTING_OBJECT, SettingObject);
				_tmp42_ = object;
				_tmp43_ = setting_object_get_name (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = self->priv->search_entry;
				_tmp46_ = gtk_entry_get_text ((GtkEntry*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = string_index_of (_tmp44_, _tmp47_, 0);
				if (_tmp48_ >= 0) {
					GtkTreeSelection* _tmp49_ = NULL;
					GtkTreeIter _tmp50_ = {0};
					GtkListBox* _tmp51_ = NULL;
					GtkListBox* _tmp52_ = NULL;
					gint _tmp53_ = 0;
					GtkListBoxRow* _tmp54_ = NULL;
					Directory* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
					const gchar* _tmp57_ = NULL;
					SettingObject* _tmp58_ = NULL;
					const gchar* _tmp59_ = NULL;
					const gchar* _tmp60_ = NULL;
					_tmp49_ = self->priv->dir_tree_selection;
					_tmp50_ = iter;
					gtk_tree_selection_select_iter (_tmp49_, &_tmp50_);
					_tmp51_ = self->priv->key_list_box;
					_tmp52_ = self->priv->key_list_box;
					_tmp53_ = position;
					_tmp54_ = gtk_list_box_get_row_at_index (_tmp52_, _tmp53_);
					gtk_list_box_select_row (_tmp51_, _tmp54_);
					_tmp55_ = dir;
					_tmp56_ = setting_object_get_full_name ((SettingObject*) _tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = object;
					_tmp59_ = setting_object_get_full_name (_tmp58_);
					_tmp60_ = _tmp59_;
					registry_view_show_browse_view (self, _tmp57_, _tmp60_, FALSE);
					_g_object_unref0 (object);
					_g_object_unref0 (key_model);
					_g_object_unref0 (dir);
					return;
				} else {
					SettingObject* _tmp61_ = NULL;
					_tmp61_ = object;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, TYPE_KEY)) {
						Key* key = NULL;
						SettingObject* _tmp62_ = NULL;
						Key* _tmp63_ = NULL;
						gboolean _tmp64_ = FALSE;
						gboolean _tmp65_ = FALSE;
						Key* _tmp66_ = NULL;
						_tmp62_ = object;
						_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, TYPE_KEY, Key));
						key = _tmp63_;
						_tmp66_ = key;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, TYPE_GSETTINGS_KEY)) {
							_tmp65_ = TRUE;
						} else {
							Key* _tmp67_ = NULL;
							gboolean _tmp68_ = FALSE;
							gboolean _tmp69_ = FALSE;
							_tmp67_ = key;
							_tmp68_ = dconf_key_get_is_ghost (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, TYPE_DCONF_KEY, DConfKey));
							_tmp69_ = _tmp68_;
							_tmp65_ = !_tmp69_;
						}
						if (_tmp65_) {
							Key* _tmp70_ = NULL;
							GtkSearchEntry* _tmp71_ = NULL;
							const gchar* _tmp72_ = NULL;
							const gchar* _tmp73_ = NULL;
							gboolean _tmp74_ = FALSE;
							_tmp70_ = key;
							_tmp71_ = self->priv->search_entry;
							_tmp72_ = gtk_entry_get_text ((GtkEntry*) _tmp71_);
							_tmp73_ = _tmp72_;
							_tmp74_ = registry_view_key_matches (self, _tmp70_, _tmp73_);
							_tmp64_ = _tmp74_;
						} else {
							_tmp64_ = FALSE;
						}
						if (_tmp64_) {
							RegistryInfo* _tmp75_ = NULL;
							Key* _tmp76_ = NULL;
							GtkTreeSelection* _tmp77_ = NULL;
							GtkTreeIter _tmp78_ = {0};
							GtkListBox* _tmp79_ = NULL;
							GtkListBox* _tmp80_ = NULL;
							gint _tmp81_ = 0;
							GtkListBoxRow* _tmp82_ = NULL;
							SettingObject* _tmp83_ = NULL;
							const gchar* _tmp84_ = NULL;
							const gchar* _tmp85_ = NULL;
							_tmp75_ = self->priv->properties_view;
							_tmp76_ = key;
							registry_info_populate_properties_list_box (_tmp75_, _tmp76_);
							_tmp77_ = self->priv->dir_tree_selection;
							_tmp78_ = iter;
							gtk_tree_selection_select_iter (_tmp77_, &_tmp78_);
							_tmp79_ = self->priv->key_list_box;
							_tmp80_ = self->priv->key_list_box;
							_tmp81_ = position;
							_tmp82_ = gtk_list_box_get_row_at_index (_tmp80_, _tmp81_);
							gtk_list_box_select_row (_tmp79_, _tmp82_);
							_tmp83_ = object;
							_tmp84_ = setting_object_get_full_name (_tmp83_);
							_tmp85_ = _tmp84_;
							registry_view_show_properties_view (self, _tmp85_);
							_g_object_unref0 (key);
							_g_object_unref0 (object);
							_g_object_unref0 (key_model);
							_g_object_unref0 (dir);
							return;
						}
						_g_object_unref0 (key);
					}
				}
				_tmp86_ = position;
				position = _tmp86_ + 1;
				_g_object_unref0 (object);
			}
			position = 0;
			_g_object_unref0 (key_model);
			_g_object_unref0 (dir);
		}
	}
	_tmp87_ = self->priv->search_next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp87_, FALSE);
}


static void _registry_view_find_next_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	registry_view_find_next_cb ((RegistryView*) self);
}


static gboolean registry_view_key_matches (RegistryView* self, Key* key, const gchar* text) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Key* _tmp1_ = NULL;
	gboolean _tmp5_ = FALSE;
	Key* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	const GVariantType* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp1_ = key;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_GSETTINGS_KEY)) {
		Key* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = key;
		_tmp3_ = text;
		_tmp4_ = gsettings_key_search_for (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_GSETTINGS_KEY, GSettingsKey), _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp6_ = key;
	_tmp7_ = key_get_value (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = G_VARIANT_TYPE_STRING;
	_tmp11_ = g_variant_is_of_type (_tmp9_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_variant_unref0 (_tmp9_);
	if (_tmp12_) {
		Key* _tmp13_ = NULL;
		GVariant* _tmp14_ = NULL;
		GVariant* _tmp15_ = NULL;
		GVariant* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp13_ = key;
		_tmp14_ = key_get_value (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = g_variant_get_string (_tmp16_, NULL);
		_tmp18_ = text;
		_tmp19_ = string_index_of (_tmp17_, _tmp18_, 0);
		_tmp5_ = _tmp19_ >= 0;
		_g_variant_unref0 (_tmp16_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean registry_view_get_next_iter (RegistryView* self, GtkTreeIter* iter) {
	gboolean result = FALSE;
	SettingsModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->model;
	_tmp1_ = *iter;
	_tmp2_ = gtk_tree_model_iter_has_child ((GtkTreeModel*) _tmp0_, &_tmp1_);
	if (_tmp2_) {
		SettingsModel* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
		GtkTreeIter _tmp5_ = {0};
		_tmp3_ = self->priv->model;
		_tmp4_ = *iter;
		gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp3_, &_tmp5_, &_tmp4_, 0);
		*iter = _tmp5_;
		result = TRUE;
		return result;
	}
	while (TRUE) {
		SettingsModel* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		SettingsModel* _tmp8_ = NULL;
		GtkTreeIter _tmp9_ = {0};
		GtkTreeIter _tmp10_ = {0};
		gboolean _tmp11_ = FALSE;
		_tmp6_ = self->priv->model;
		_tmp7_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp6_, iter);
		if (!(!_tmp7_)) {
			break;
		}
		_tmp8_ = self->priv->model;
		_tmp9_ = *iter;
		_tmp11_ = gtk_tree_model_iter_parent ((GtkTreeModel*) _tmp8_, &_tmp10_, &_tmp9_);
		*iter = _tmp10_;
		if (!_tmp11_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


RegistryView* registry_view_construct (GType object_type) {
	RegistryView * self = NULL;
	self = (RegistryView*) g_object_new (object_type, NULL);
	return self;
}


RegistryView* registry_view_new (void) {
	return registry_view_construct (TYPE_REGISTRY_VIEW);
}


const gchar* registry_view_get_current_path (RegistryView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_path;
	result = _tmp0_;
	return result;
}


static void registry_view_set_current_path (RegistryView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_current_path);
	self->priv->_current_path = _tmp1_;
	g_object_notify ((GObject *) self, "current-path");
}


gboolean registry_view_get_show_search_bar (RegistryView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_search_bar;
	result = _tmp0_;
	return result;
}


void registry_view_set_show_search_bar (RegistryView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_search_bar = _tmp0_;
	g_object_notify ((GObject *) self, "show-search-bar");
}


Behaviour registry_view_get_behaviour (RegistryView* self) {
	Behaviour result;
	Behaviour _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_behaviour;
	result = _tmp0_;
	return result;
}


void registry_view_set_behaviour (RegistryView* self, Behaviour value) {
	Behaviour _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_behaviour = _tmp0_;
	g_object_notify ((GObject *) self, "behaviour");
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}


static void block24_data_unref (void * _userdata_) {
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		RegistryView* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->buffer);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}


static void _registry_view_invalidate_popovers_modifications_revealer_reload (ModificationsRevealer* _sender, gpointer self) {
	registry_view_invalidate_popovers ((RegistryView*) self);
}


static void _registry_view___lambda81_ (RegistryView* self) {
	GtkButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->search_next_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
}


static void __registry_view___lambda81__gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self) {
	_registry_view___lambda81_ ((RegistryView*) self);
}


static void _registry_view___lambda82_ (Block24Data* _data24_) {
	RegistryView* self;
	ModificationsRevealer* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GtkEntryBuffer* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	self = _data24_->self;
	_tmp0_ = self->priv->revealer;
	_tmp1_ = _data24_->revealer_reload_handler;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	_tmp2_ = _data24_->buffer;
	_tmp3_ = _data24_->search_entry_buffer_deleted_text_handler;
	g_signal_handler_disconnect ((GObject*) _tmp2_, _tmp3_);
	GTK_WIDGET_CLASS (registry_view_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
}


static void __registry_view___lambda82__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	_registry_view___lambda82_ (self);
}


static GObject * registry_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RegistryView * self;
	Block24Data* _data24_;
	ModificationsRevealer* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GtkSearchEntry* _tmp2_ = NULL;
	GtkEntryBuffer* _tmp3_ = NULL;
	GtkEntryBuffer* _tmp4_ = NULL;
	GtkEntryBuffer* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	GtkSearchBar* _tmp7_ = NULL;
	GtkSearchEntry* _tmp8_ = NULL;
	GtkSearchBar* _tmp9_ = NULL;
	ModificationsRevealer* _tmp10_ = NULL;
	parent_class = G_OBJECT_CLASS (registry_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REGISTRY_VIEW, RegistryView);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = self->priv->revealer;
	_tmp1_ = g_signal_connect_object (_tmp0_, "reload", (GCallback) _registry_view_invalidate_popovers_modifications_revealer_reload, self, 0);
	_data24_->revealer_reload_handler = _tmp1_;
	_tmp2_ = self->priv->search_entry;
	_tmp3_ = gtk_entry_get_buffer ((GtkEntry*) _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data24_->buffer = _tmp4_;
	_tmp5_ = _data24_->buffer;
	_tmp6_ = g_signal_connect_object (_tmp5_, "deleted-text", (GCallback) __registry_view___lambda81__gtk_entry_buffer_deleted_text, self, 0);
	_data24_->search_entry_buffer_deleted_text_handler = _tmp6_;
	_tmp7_ = self->priv->search_bar;
	_tmp8_ = self->priv->search_entry;
	gtk_search_bar_connect_entry (_tmp7_, (GtkEntry*) _tmp8_);
	_tmp9_ = self->priv->search_bar;
	g_object_bind_property_with_closures ((GObject*) self, "show-search-bar", (GObject*) _tmp9_, "search-mode-enabled", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = self->priv->revealer;
	g_object_bind_property_with_closures ((GObject*) self, "behaviour", (GObject*) _tmp10_, "behaviour", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) __registry_view___lambda82__gtk_widget_destroy, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	block24_data_unref (_data24_);
	_data24_ = NULL;
	return obj;
}


static void registry_view_class_init (RegistryViewClass * klass) {
	gint RegistryView_private_offset;
	registry_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RegistryViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_registry_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_registry_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = registry_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = registry_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), REGISTRY_VIEW_CURRENT_PATH_PROPERTY, g_param_spec_string ("current-path", "current-path", "current-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY, g_param_spec_boolean ("show-search-bar", "show-search-bar", "show-search-bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), REGISTRY_VIEW_BEHAVIOUR_PROPERTY, g_param_spec_enum ("behaviour", "behaviour", "behaviour", TYPE_BEHAVIOUR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	RegistryView_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/registry-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_tree_view", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, dir_tree_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dir_tree_selection", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, dir_tree_selection));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "properties_view", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, properties_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "key_list_box", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, key_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_bar", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, search_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_next_button", FALSE, RegistryView_private_offset + G_STRUCT_OFFSET (RegistryViewPrivate, search_next_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "dir_selected_cb", G_CALLBACK(_registry_view_dir_selected_cb_gtk_tree_selection_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "row_activated_cb", G_CALLBACK(_registry_view_row_activated_cb_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "find_next_cb", G_CALLBACK(_registry_view_find_next_cb_gtk_button_clicked));
}


static void registry_view_path_element_interface_init (PathElementIface * iface) {
	registry_view_path_element_parent_iface = g_type_interface_peek_parent (iface);
}


static void registry_view_instance_init (RegistryView * self) {
	SettingsModel* _tmp0_ = NULL;
	GListStore* _tmp1_ = NULL;
	self->priv = REGISTRY_VIEW_GET_PRIVATE (self);
	_tmp0_ = settings_model_new ();
	self->priv->model = _tmp0_;
	self->priv->key_model = NULL;
	_tmp1_ = g_list_store_new (TYPE_CLICKABLE_LIST_BOX_ROW);
	self->priv->rows_possibly_with_popover = _tmp1_;
	g_type_ensure (TYPE_REGISTRY_INFO);
	g_type_ensure (TYPE_MODIFICATIONS_REVEALER);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void registry_view_finalize (GObject* obj) {
	RegistryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REGISTRY_VIEW, RegistryView);
	_g_free0 (self->priv->_current_path);
	_g_object_unref0 (self->priv->model);
	_g_object_unref0 (self->priv->dir_tree_view);
	_g_object_unref0 (self->priv->dir_tree_selection);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->properties_view);
	_g_object_unref0 (self->priv->key_list_box);
	_g_object_unref0 (self->priv->key_model);
	_g_object_unref0 (self->priv->rows_possibly_with_popover);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->search_bar);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->search_next_button);
	G_OBJECT_CLASS (registry_view_parent_class)->finalize (obj);
}


GType registry_view_get_type (void) {
	static volatile gsize registry_view_type_id__volatile = 0;
	if (g_once_init_enter (&registry_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RegistryViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) registry_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RegistryView), 0, (GInstanceInitFunc) registry_view_instance_init, NULL };
		static const GInterfaceInfo path_element_info = { (GInterfaceInitFunc) registry_view_path_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType registry_view_type_id;
		registry_view_type_id = g_type_register_static (gtk_grid_get_type (), "RegistryView", &g_define_type_info, 0);
		g_type_add_interface_static (registry_view_type_id, TYPE_PATH_ELEMENT, &path_element_info);
		g_once_init_leave (&registry_view_type_id__volatile, registry_view_type_id);
	}
	return registry_view_type_id__volatile;
}


static void _vala_registry_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RegistryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_REGISTRY_VIEW, RegistryView);
	switch (property_id) {
		case REGISTRY_VIEW_CURRENT_PATH_PROPERTY:
		g_value_set_string (value, registry_view_get_current_path (self));
		break;
		case REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY:
		g_value_set_boolean (value, registry_view_get_show_search_bar (self));
		break;
		case REGISTRY_VIEW_BEHAVIOUR_PROPERTY:
		g_value_set_enum (value, registry_view_get_behaviour (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_registry_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RegistryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_REGISTRY_VIEW, RegistryView);
	switch (property_id) {
		case REGISTRY_VIEW_CURRENT_PATH_PROPERTY:
		registry_view_set_current_path (self, g_value_get_string (value));
		break;
		case REGISTRY_VIEW_SHOW_SEARCH_BAR_PROPERTY:
		registry_view_set_show_search_bar (self, g_value_get_boolean (value));
		break;
		case REGISTRY_VIEW_BEHAVIOUR_PROPERTY:
		registry_view_set_behaviour (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



