/* dconf.c generated by valac 0.11.4.5-1352b, the Vala compiler
 * generated from dconf.vala, do not modify */

/*
 * Copyright © 2010 Codethink Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include <dconf.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



void do_read (DConfClient* client, const gchar* key, GError** error);
void do_list (DConfClient* client, const gchar* dir, GError** error);
void do_write (DConfClient* client, const gchar* key, const gchar* val, GError** error);
void do_lock (DConfClient* client, const gchar* key, gboolean locked, GError** error);
void do_watch (DConfClient* client, const gchar* name, GError** error);
void _vala_main (gchar** args, int args_length1);
void do_update (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void do_read (DConfClient* client, const gchar* key, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariant* _result_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (client != NULL);
	g_return_if_fail (key != NULL);
	dconf_is_key (key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = dconf_client_read (client, key);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_variant_print (_result_, TRUE);
		_tmp2_ = _tmp1_;
		fputs (_tmp2_, stdout);
		_g_free0 (_tmp2_);
		fputc ('\n', stdout);
	}
	_g_variant_unref0 (_result_);
}


void do_list (DConfClient* client, const gchar* dir, GError** error) {
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (client != NULL);
	g_return_if_fail (dir != NULL);
	dconf_is_dir (dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = dconf_client_list (client, dir, &_tmp0_);
	{
		gchar** item_collection;
		int item_collection_length1;
		int item_it;
		item_collection = _tmp1_;
		item_collection_length1 = _tmp0_;
		for (item_it = 0; item_it < _tmp0_; item_it = item_it + 1) {
			gchar* _tmp2_;
			gchar* item;
			_tmp2_ = g_strdup (item_collection[item_it]);
			item = _tmp2_;
			{
				fputs (item, stdout);
				fputc ('\n', stdout);
				_g_free0 (item);
			}
		}
		item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}


void do_write (DConfClient* client, const gchar* key, const gchar* val, GError** error) {
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (client != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	dconf_is_key (key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = g_variant_parse (NULL, val, NULL, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = _tmp1_;
	dconf_client_write (client, key, _tmp2_, NULL, NULL, &_inner_error_);
	_g_variant_unref0 (_tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void do_lock (DConfClient* client, const gchar* key, gboolean locked, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (client != NULL);
	g_return_if_fail (key != NULL);
	dconf_is_key (key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	dconf_client_set_locked (client, key, locked, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void do_watch (DConfClient* client, const gchar* name, GError** error) {
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (client != NULL);
	g_return_if_fail (name != NULL);
	dconf_is_path (name, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	dconf_client_watch (client, name, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_tmp1_ = _tmp0_;
	g_main_loop_run (_tmp1_);
	_g_main_loop_unref0 (_tmp1_);
}


void _vala_main (gchar** args, int args_length1) {
	DConfClient* _tmp0_ = NULL;
	DConfClient* client;
	const gchar* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	static GQuark _tmp2__label3 = 0;
	static GQuark _tmp2__label4 = 0;
	static GQuark _tmp2__label5 = 0;
	static GQuark _tmp2__label6 = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new (NULL, NULL, NULL, NULL);
	client = _tmp0_;
	g_set_prgname (args[0]);
	_tmp1_ = args[1];
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("read")))) {
		switch (0) {
			default:
			{
				do_read (client, args[2], &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (client);
					goto __catch0_g_error;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("list")))) {
		switch (0) {
			default:
			{
				do_list (client, args[2], &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (client);
					goto __catch0_g_error;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("write")))) {
		switch (0) {
			default:
			{
				do_write (client, args[2], args[3], &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (client);
					goto __catch0_g_error;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label3) ? _tmp2__label3 : (_tmp2__label3 = g_quark_from_static_string ("update")))) {
		switch (0) {
			default:
			{
				do_update ();
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label4) ? _tmp2__label4 : (_tmp2__label4 = g_quark_from_static_string ("lock")))) {
		switch (0) {
			default:
			{
				do_lock (client, args[2], TRUE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (client);
					goto __catch0_g_error;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label5) ? _tmp2__label5 : (_tmp2__label5 = g_quark_from_static_string ("unlock")))) {
		switch (0) {
			default:
			{
				do_lock (client, args[2], FALSE, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (client);
					goto __catch0_g_error;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label6) ? _tmp2__label6 : (_tmp2__label6 = g_quark_from_static_string ("watch")))) {
		switch (0) {
			default:
			{
				do_watch (client, args[2], &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (client);
					goto __catch0_g_error;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_error ("dconf.vala:96: unknown command");
			}
		}
	}
	_g_object_unref0 (client);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "error: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


int main (int argc, char ** argv) {
	g_type_init ();
	_vala_main (argv, argc);
	return 0;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



