# Dots - A braille translation program.
#
# Copyright (C) 2010 Consorcio Fernando de los Rios
#		Author: Fernando Herrera <fherrera@onirica.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import mimetypes
from document import Document
from odtdocument import OdtDocument
from xmldocument import XmlDocument
try:
	from pdfdocument_gi import PdfDocument
except:
	from pdfdocument_pypoppler import PdfDocument
	pass

def document_new(filename):
	mime_type, encoding = mimetypes.guess_type (filename)
	if mime_type == "application/pdf":
		doc = PdfDocument(filename)
	elif mime_type == "application/vnd.oasis.opendocument.text":
		doc = OdtDocument(filename)
	else:
		doc = XmlDocument(filename)
	return doc
	

if __name__ == "__main__":
	import sys
	from config_builder import ConfigBuilder

	if sys.argv[1] is None:
		print sys.argv[0] + " [file]"
	d = document_new (sys.argv[1])
	config_builder = ConfigBuilder()

	config_builder['xml']['semanticFiles'] = '*'
	config_builder['xml']['semanticFiles'] += ',nemeth.sem'
	config_builder['xml']['internetAccess'] = 'yes'
	config_builder['translation']['literaryTextTable'] = "Es-Es-g1.utb"
	config_builder['outputFormat']['cellsPerLine'] = 40
	config_builder['outputFormat']['braillePages'] = 'yes'
	config_builder['outputFormat']['formatFor'] = 'textDevice'
	config_builder['outputFormat']['LinesPerPage'] = 25
	config_builder['outputFormat']['braillePageNumberAt'] =  'bottom'

	d.translate (config_builder)
	print d.get_braille_text ()
	
