/* ease-editor-window.c generated by valac, the Vala compiler
 * generated from ease-editor-window.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ease-core.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <time.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>


#define EASE_TYPE_EDITOR_WINDOW (ease_editor_window_get_type ())
#define EASE_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindow))
#define EASE_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))
#define EASE_IS_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_WINDOW))
#define EASE_IS_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_WINDOW))
#define EASE_EDITOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))

typedef struct _EaseEditorWindow EaseEditorWindow;
typedef struct _EaseEditorWindowClass EaseEditorWindowClass;
typedef struct _EaseEditorWindowPrivate EaseEditorWindowPrivate;

#define EASE_TYPE_SCROLLABLE_EMBED (ease_scrollable_embed_get_type ())
#define EASE_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbed))
#define EASE_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))
#define EASE_IS_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_IS_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_SCROLLABLE_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))

typedef struct _EaseScrollableEmbed EaseScrollableEmbed;
typedef struct _EaseScrollableEmbedClass EaseScrollableEmbedClass;

#define EASE_TYPE_EDITOR_EMBED (ease_editor_embed_get_type ())
#define EASE_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbed))
#define EASE_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))
#define EASE_IS_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_EMBED))
#define EASE_IS_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_EMBED))
#define EASE_EDITOR_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))

typedef struct _EaseEditorEmbed EaseEditorEmbed;
typedef struct _EaseEditorEmbedClass EaseEditorEmbedClass;

#define EASE_TYPE_SLIDE_BUTTON_PANEL (ease_slide_button_panel_get_type ())
#define EASE_SLIDE_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanel))
#define EASE_SLIDE_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanelClass))
#define EASE_IS_SLIDE_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL))
#define EASE_IS_SLIDE_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_BUTTON_PANEL))
#define EASE_SLIDE_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanelClass))

typedef struct _EaseSlideButtonPanel EaseSlideButtonPanel;
typedef struct _EaseSlideButtonPanelClass EaseSlideButtonPanelClass;

#define EASE_TYPE_PLAYER (ease_player_get_type ())
#define EASE_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_PLAYER, EasePlayer))
#define EASE_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_PLAYER, EasePlayerClass))
#define EASE_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_PLAYER))
#define EASE_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_PLAYER))
#define EASE_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_PLAYER, EasePlayerClass))

typedef struct _EasePlayer EasePlayer;
typedef struct _EasePlayerClass EasePlayerClass;

#define EASE_TYPE_INSPECTOR (ease_inspector_get_type ())
#define EASE_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_INSPECTOR, EaseInspector))
#define EASE_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_INSPECTOR, EaseInspectorClass))
#define EASE_IS_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_INSPECTOR))
#define EASE_IS_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_INSPECTOR))
#define EASE_INSPECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_INSPECTOR, EaseInspectorClass))

typedef struct _EaseInspector EaseInspector;
typedef struct _EaseInspectorClass EaseInspectorClass;

#define EASE_TYPE_SLIDE_SORTER (ease_slide_sorter_get_type ())
#define EASE_SLIDE_SORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_SORTER, EaseSlideSorter))
#define EASE_SLIDE_SORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_SORTER, EaseSlideSorterClass))
#define EASE_IS_SLIDE_SORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_SORTER))
#define EASE_IS_SLIDE_SORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_SORTER))
#define EASE_SLIDE_SORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_SORTER, EaseSlideSorterClass))

typedef struct _EaseSlideSorter EaseSlideSorter;
typedef struct _EaseSlideSorterClass EaseSlideSorterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EaseInspectorPrivate EaseInspectorPrivate;

#define EASE_TYPE_INSPECTOR_PANE (ease_inspector_pane_get_type ())
#define EASE_INSPECTOR_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_INSPECTOR_PANE, EaseInspectorPane))
#define EASE_INSPECTOR_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_INSPECTOR_PANE, EaseInspectorPaneClass))
#define EASE_IS_INSPECTOR_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_INSPECTOR_PANE))
#define EASE_IS_INSPECTOR_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_INSPECTOR_PANE))
#define EASE_INSPECTOR_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_INSPECTOR_PANE, EaseInspectorPaneClass))

typedef struct _EaseInspectorPane EaseInspectorPane;
typedef struct _EaseInspectorPaneClass EaseInspectorPaneClass;

#define EASE_TYPE_INSPECTOR_ELEMENT_PANE (ease_inspector_element_pane_get_type ())
#define EASE_INSPECTOR_ELEMENT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_INSPECTOR_ELEMENT_PANE, EaseInspectorElementPane))
#define EASE_INSPECTOR_ELEMENT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_INSPECTOR_ELEMENT_PANE, EaseInspectorElementPaneClass))
#define EASE_IS_INSPECTOR_ELEMENT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_INSPECTOR_ELEMENT_PANE))
#define EASE_IS_INSPECTOR_ELEMENT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_INSPECTOR_ELEMENT_PANE))
#define EASE_INSPECTOR_ELEMENT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_INSPECTOR_ELEMENT_PANE, EaseInspectorElementPaneClass))

typedef struct _EaseInspectorElementPane EaseInspectorElementPane;
typedef struct _EaseInspectorElementPaneClass EaseInspectorElementPaneClass;

#define EASE_TYPE_CLOSE_CONFIRM_DIALOG (ease_close_confirm_dialog_get_type ())
#define EASE_CLOSE_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_CLOSE_CONFIRM_DIALOG, EaseCloseConfirmDialog))
#define EASE_CLOSE_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_CLOSE_CONFIRM_DIALOG, EaseCloseConfirmDialogClass))
#define EASE_IS_CLOSE_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_CLOSE_CONFIRM_DIALOG))
#define EASE_IS_CLOSE_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_CLOSE_CONFIRM_DIALOG))
#define EASE_CLOSE_CONFIRM_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_CLOSE_CONFIRM_DIALOG, EaseCloseConfirmDialogClass))

typedef struct _EaseCloseConfirmDialog EaseCloseConfirmDialog;
typedef struct _EaseCloseConfirmDialogClass EaseCloseConfirmDialogClass;
typedef struct _EaseScrollableEmbedPrivate EaseScrollableEmbedPrivate;
typedef struct _EaseEditorEmbedPrivate EaseEditorEmbedPrivate;

#define EASE_TYPE_SLIDE_ACTOR (ease_slide_actor_get_type ())
#define EASE_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActor))
#define EASE_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))
#define EASE_IS_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_ACTOR))
#define EASE_IS_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_ACTOR))
#define EASE_SLIDE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))

typedef struct _EaseSlideActor EaseSlideActor;
typedef struct _EaseSlideActorClass EaseSlideActorClass;
typedef struct _Block1Data Block1Data;
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

struct _EaseEditorWindow {
	GtkWindow parent_instance;
	EaseEditorWindowPrivate * priv;
	EaseEditorEmbed* embed;
	EaseSlideButtonPanel* slide_button_panel;
	EaseZoomSlider* zoom_slider;
	EaseDocument* document;
	EaseSlide* slide;
};

struct _EaseEditorWindowClass {
	GtkWindowClass parent_class;
};

struct _EaseEditorWindowPrivate {
	EasePlayer* player;
	EaseInspector* inspector;
	GtkWidget* editor;
	EaseSlideSorter* sorter;
	GtkBin* main_bin;
	EaseUndoController* undo;
	EaseUndoAction* undo_action;
	GtkToolButton* undo_button;
	GtkToolButton* redo_button;
	gboolean _slides_shown;
	GtkColorSelectionDialog* color_dialog;
	GtkColorSelection* color_selection;
	GtkRadioMenuItem* show_editor;
	GtkRadioMenuItem* show_sorter;
	GtkCheckMenuItem* zoom_fit;
	glong last_saved;
	gint* ZOOM_LEVELS;
	gint ZOOM_LEVELS_length1;
	gint _ZOOM_LEVELS_size_;
};

struct _EaseInspector {
	GtkNotebook parent_instance;
	EaseInspectorPrivate * priv;
	EaseInspectorElementPane* element_pane;
};

struct _EaseInspectorClass {
	GtkNotebookClass parent_class;
};

struct _EaseScrollableEmbed {
	GtkHBox parent_instance;
	EaseScrollableEmbedPrivate * priv;
};

struct _EaseScrollableEmbedClass {
	GtkHBoxClass parent_class;
};

struct _EaseEditorEmbed {
	EaseScrollableEmbed parent_instance;
	EaseEditorEmbedPrivate * priv;
	EaseSlideActor* slide_actor;
};

struct _EaseEditorEmbedClass {
	EaseScrollableEmbedClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	EaseEditorWindow * self;
	ClutterColor* original_color;
};


static gpointer ease_editor_window_parent_class = NULL;

GType ease_editor_window_get_type (void) G_GNUC_CONST;
GType ease_scrollable_embed_get_type (void) G_GNUC_CONST;
GType ease_editor_embed_get_type (void) G_GNUC_CONST;
GType ease_slide_button_panel_get_type (void) G_GNUC_CONST;
GType ease_player_get_type (void) G_GNUC_CONST;
GType ease_inspector_get_type (void) G_GNUC_CONST;
GType ease_slide_sorter_get_type (void) G_GNUC_CONST;
#define EASE_EDITOR_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowPrivate))
enum  {
	EASE_EDITOR_WINDOW_DUMMY_PROPERTY,
	EASE_EDITOR_WINDOW_SLIDES_SHOWN
};
#define EASE_EDITOR_WINDOW_UI_FILE_PATH "editor-window.ui"
#define EASE_EDITOR_WINDOW_FONT_TEXT _ ("The quick brown fox jumps over the lazy dog")
void ease_editor_window_add_undo_action (EaseEditorWindow* self, EaseUndoItem* action);
static void _ease_editor_window_add_undo_action_ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self);
EaseSlideButtonPanel* ease_slide_button_panel_new (EaseDocument* d, EaseEditorWindow* win);
EaseSlideButtonPanel* ease_slide_button_panel_construct (GType object_type, EaseDocument* d, EaseEditorWindow* win);
EaseEditorEmbed* ease_editor_embed_new (EaseDocument* d, EaseEditorWindow* w);
EaseEditorEmbed* ease_editor_embed_construct (GType object_type, EaseDocument* d, EaseEditorWindow* w);
EaseInspector* ease_inspector_new (EaseDocument* document);
EaseInspector* ease_inspector_construct (GType object_type, EaseDocument* document);
GType ease_inspector_pane_get_type (void) G_GNUC_CONST;
GType ease_inspector_element_pane_get_type (void) G_GNUC_CONST;
void ease_inspector_element_pane_on_element_selected (EaseInspectorElementPane* self, EaseElement* selected);
static void _ease_inspector_element_pane_on_element_selected_ease_editor_embed_element_selected (EaseEditorEmbed* _sender, EaseElement* selected, gpointer self);
void ease_inspector_element_pane_on_element_deselected (EaseInspectorElementPane* self, EaseElement* deselected);
static void _ease_inspector_element_pane_on_element_deselected_ease_editor_embed_element_deselected (EaseEditorEmbed* _sender, EaseElement* deselected, gpointer self);
static EaseZoomSlider* ease_editor_window_create_zoom_slider (EaseEditorWindow* self);
void ease_editor_window_on_new_slide_menu (GtkWidget* sender, EaseEditorWindow* self);
static void _ease_editor_window_on_new_slide_menu_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void ease_editor_window_set_slides_shown (EaseEditorWindow* self, gboolean value);
EaseCloseConfirmDialog* ease_close_confirm_dialog_new (const char* filename, gint seconds);
EaseCloseConfirmDialog* ease_close_confirm_dialog_construct (GType object_type, const char* filename, gint seconds);
GType ease_close_confirm_dialog_get_type (void) G_GNUC_CONST;
gboolean ease_editor_window_save_document (GtkWidget* sender, EaseEditorWindow* self);
static gboolean _lambda56_ (GtkWidget* sender, GdkEvent* event, EaseEditorWindow* self);
static gboolean __lambda56__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
void ease_slide_button_panel_select_slide (EaseSlideButtonPanel* self, EaseSlide* slide);
static void ease_editor_window_update_undo (EaseEditorWindow* self);
EaseEditorWindow* ease_editor_window_new (EaseDocument* doc);
EaseEditorWindow* ease_editor_window_construct (GType object_type, EaseDocument* doc);
void ease_inspector_set_slide (EaseInspector* self, EaseSlide* value);
void ease_editor_embed_set_slide (EaseEditorEmbed* self, EaseSlide* slide);
void ease_editor_window_set_slide (EaseEditorWindow* self, gint index);
void ease_main_open_file (const char* path);
void ease_editor_window_on_open (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_quit (GtkWidget* sender, EaseEditorWindow* self);
EaseActor* ease_editor_embed_get_selected (EaseEditorEmbed* self);
void ease_editor_window_on_delete (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_new_slide_handler (GtkWidget* sender, EaseEditorWindow* self);
EaseSlide* ease_slide_sorter_delete_slide (EaseSlideSorter* self);
void ease_editor_window_remove_slide (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_play_handler (GtkWidget* sender, EaseEditorWindow* self);
GType ease_slide_actor_get_type (void) G_GNUC_CONST;
void ease_slide_actor_relayout (EaseSlideActor* self);
void ease_editor_embed_reposition_group (EaseEditorEmbed* self);
void ease_editor_window_undo_handler (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_redo_handler (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_embed_select_element (EaseEditorEmbed* self, EaseElement* e);
void ease_editor_window_insert_text (GtkWidget* sender, EaseEditorWindow* self);
static void _lambda70_ (GtkFileChooserDialog* dialog, EaseEditorWindow* self);
static void __lambda70__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self);
void ease_editor_window_insert_image (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_insert_video (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_insert_rectangle (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_insert_oval (GtkWidget* sender, EaseEditorWindow* self);
EaseSlideSorter* ease_slide_sorter_new (EaseDocument* doc);
EaseSlideSorter* ease_slide_sorter_construct (GType object_type, EaseDocument* doc);
static void _lambda71_ (EaseSlide* s, EaseEditorWindow* self);
static void __lambda71__ease_slide_sorter_display_slide (EaseSlideSorter* _sender, EaseSlide* s, gpointer self);
void ease_editor_window_set_view (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_embed_set_zoom_fit (EaseEditorEmbed* self, gboolean value);
void ease_editor_window_zoom_in (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_zoom_out (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_zoom_fit (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_export_as_pdf (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_export_as_postscript (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_export_as_html (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_lower (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_raise (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_lower_bottom (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_raise_top (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_inspector_clicked_handler (GtkWidget* sender, EaseEditorWindow* self);
static void ease_editor_window_color_dialog_changed (EaseEditorWindow* self, GtkColorSelection* sender);
static void _ease_editor_window_color_dialog_changed_gtk_color_selection_color_changed (GtkColorSelection* _sender, gpointer self);
static void ease_editor_window_color_dialog_selection (EaseEditorWindow* self, GObject* sender, GParamSpec* spec);
static void _ease_editor_window_color_dialog_selection_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda72_ (EaseEditorWindow* self);
static void __lambda72__gtk_widget_hide (GtkWidget* _sender, gpointer self);
static gboolean _clutter_color_equal (const ClutterColor* s1, const ClutterColor* s2);
static void _lambda73_ (Block1Data* _data1_);
static void __lambda73__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda74_ (Block1Data* _data1_);
static void __lambda74__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda75_ (EaseEditorWindow* self);
static void __lambda75__gtk_dialog_close (GtkDialog* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
void ease_editor_window_show_color_dialog (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_embed_set_element_color (EaseEditorEmbed* self, ClutterColor* color);
void ease_editor_window_select_font (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_embed_set_zoom (EaseEditorEmbed* self, float value);
static void _lambda55_ (EaseEditorWindow* self);
static void __lambda55__ease_zoom_slider_value_changed (EaseZoomSlider* _sender, gpointer self);
gboolean ease_editor_window_get_slides_shown (EaseEditorWindow* self);
static void ease_editor_window_finalize (GObject* obj);
static void ease_editor_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_editor_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 296 "ease-editor-window.vala"
static void _ease_editor_window_add_undo_action_ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self) {
#line 350 "ease-editor-window.c"
	ease_editor_window_add_undo_action (self, action);
}


#line 42 "ease-inspector-element-pane.vala"
static void _ease_inspector_element_pane_on_element_selected_ease_editor_embed_element_selected (EaseEditorEmbed* _sender, EaseElement* selected, gpointer self) {
#line 357 "ease-editor-window.c"
	ease_inspector_element_pane_on_element_selected (self, selected);
}


#line 53 "ease-inspector-element-pane.vala"
static void _ease_inspector_element_pane_on_element_deselected_ease_editor_embed_element_deselected (EaseEditorEmbed* _sender, EaseElement* deselected, gpointer self) {
#line 364 "ease-editor-window.c"
	ease_inspector_element_pane_on_element_deselected (self, deselected);
}


#line 356 "ease-editor-window.vala"
static void _ease_editor_window_on_new_slide_menu_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 371 "ease-editor-window.c"
	ease_editor_window_on_new_slide_menu (_sender, self);
}


#line 240 "ease-editor-window.vala"
static gboolean _lambda56_ (GtkWidget* sender, GdkEvent* event, EaseEditorWindow* self) {
#line 378 "ease-editor-window.c"
	gboolean result = FALSE;
	const char* _tmp0_;
	char* name;
	gint time_diff;
	EaseCloseConfirmDialog* dialog;
	gint response;
#line 240 "ease-editor-window.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 240 "ease-editor-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 241 "ease-editor-window.vala"
	if (self->priv->last_saved == 0) {
#line 243 "ease-editor-window.vala"
		g_signal_emit_by_name (self, "close", self);
#line 393 "ease-editor-window.c"
		result = FALSE;
#line 244 "ease-editor-window.vala"
		return result;
#line 397 "ease-editor-window.c"
	}
	_tmp0_ = NULL;
#line 247 "ease-editor-window.vala"
	if (ease_document_get_filename (self->document) == NULL) {
#line 247 "ease-editor-window.vala"
		_tmp0_ = _ ("Untitled Document");
#line 404 "ease-editor-window.c"
	} else {
#line 248 "ease-editor-window.vala"
		_tmp0_ = ease_document_get_filename (self->document);
#line 408 "ease-editor-window.c"
	}
#line 247 "ease-editor-window.vala"
	name = g_strdup (_tmp0_);
#line 249 "ease-editor-window.vala"
	time_diff = (gint) (time (NULL) - self->priv->last_saved);
#line 251 "ease-editor-window.vala"
	dialog = g_object_ref_sink (ease_close_confirm_dialog_new (name, time_diff));
#line 252 "ease-editor-window.vala"
	response = gtk_dialog_run ((GtkDialog*) dialog);
#line 253 "ease-editor-window.vala"
	gtk_object_destroy ((GtkObject*) dialog);
#line 255 "ease-editor-window.vala"
	if (response == GTK_RESPONSE_CANCEL) {
#line 422 "ease-editor-window.c"
		result = TRUE;
		_g_object_unref0 (dialog);
		_g_free0 (name);
#line 255 "ease-editor-window.vala"
		return result;
#line 428 "ease-editor-window.c"
	}
#line 256 "ease-editor-window.vala"
	if (response == GTK_RESPONSE_NO) {
#line 258 "ease-editor-window.vala"
		g_signal_emit_by_name (self, "close", self);
#line 434 "ease-editor-window.c"
		result = FALSE;
		_g_object_unref0 (dialog);
		_g_free0 (name);
#line 259 "ease-editor-window.vala"
		return result;
#line 440 "ease-editor-window.c"
	}
#line 263 "ease-editor-window.vala"
	if (ease_editor_window_save_document (NULL, self)) {
#line 265 "ease-editor-window.vala"
		g_signal_emit_by_name (self, "close", self);
#line 446 "ease-editor-window.c"
		result = FALSE;
		_g_object_unref0 (dialog);
		_g_free0 (name);
#line 266 "ease-editor-window.vala"
		return result;
#line 452 "ease-editor-window.c"
	}
	result = TRUE;
	_g_object_unref0 (dialog);
	_g_free0 (name);
#line 270 "ease-editor-window.vala"
	return result;
#line 459 "ease-editor-window.c"
}


#line 240 "ease-editor-window.vala"
static gboolean __lambda56__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
#line 465 "ease-editor-window.c"
	gboolean result;
	result = _lambda56_ (_sender, event, self);
	return result;
}


#line 164 "ease-editor-window.vala"
EaseEditorWindow* ease_editor_window_construct (GType object_type, EaseDocument* doc) {
#line 474 "ease-editor-window.c"
	GError * _inner_error_;
	EaseEditorWindow * self;
	EaseDocument* _tmp0_;
	GtkBuilder* builder;
	GObject* _tmp3_;
	GtkBin* _tmp5_;
	GObject* _tmp4_;
	GtkWidget* _tmp7_;
	GObject* _tmp6_;
	GtkRadioMenuItem* _tmp9_;
	GObject* _tmp8_;
	GtkRadioMenuItem* _tmp11_;
	GObject* _tmp10_;
	GtkCheckMenuItem* _tmp13_;
	GObject* _tmp12_;
	EaseSlideButtonPanel* _tmp14_;
	GObject* _tmp15_;
	EaseUndoController* _tmp16_;
	GtkToolButton* _tmp18_;
	GObject* _tmp17_;
	GtkToolButton* _tmp20_;
	GObject* _tmp19_;
	EaseEditorEmbed* _tmp21_;
	GObject* _tmp22_;
	EaseInspector* _tmp23_;
	GObject* _tmp24_;
	EaseZoomSlider* _tmp26_;
	GObject* _tmp25_;
	GObject* _tmp27_;
	GtkMenuShell* menu;
	GObject* _tmp30_;
	EaseSlide* _tmp31_;
#line 164 "ease-editor-window.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 509 "ease-editor-window.c"
	_inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
#line 166 "ease-editor-window.vala"
	gtk_window_set_title ((GtkWindow*) self, "Ease");
#line 167 "ease-editor-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, 1024, 768);
#line 169 "ease-editor-window.vala"
	self->document = (_tmp0_ = _g_object_ref0 (doc), _g_object_unref0 (self->document), _tmp0_);
#line 170 "ease-editor-window.vala"
	g_signal_connect_object ((EaseUndoSource*) self->document, "undo", (GCallback) _ease_editor_window_add_undo_action_ease_undo_source_undo, self, 0);
#line 172 "ease-editor-window.vala"
	builder = gtk_builder_new ();
#line 522 "ease-editor-window.c"
	{
		char* _tmp2_;
		char* _tmp1_;
#line 175 "ease-editor-window.vala"
		gtk_builder_add_from_file (builder, _tmp2_ = ease_data_path (_tmp1_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_EDITOR_WINDOW_UI_FILE_PATH, NULL)), &_inner_error_);
#line 528 "ease-editor-window.c"
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 178 "ease-editor-window.vala"
			g_error ("ease-editor-window.vala:178: Error loading UI: %s", e->message);
#line 544 "ease-editor-window.c"
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 180 "ease-editor-window.vala"
	gtk_builder_connect_signals (builder, self);
#line 181 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) (_tmp3_ = gtk_builder_get_object (builder, "Editor Widget"), GTK_IS_VBOX (_tmp3_) ? ((GtkVBox*) _tmp3_) : NULL));
#line 182 "ease-editor-window.vala"
	self->priv->main_bin = (_tmp5_ = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (builder, "main-align"), GTK_IS_BIN (_tmp4_) ? ((GtkBin*) _tmp4_) : NULL)), _g_object_unref0 (self->priv->main_bin), _tmp5_);
#line 183 "ease-editor-window.vala"
	self->priv->editor = (_tmp7_ = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (builder, "editor"), GTK_IS_WIDGET (_tmp6_) ? ((GtkWidget*) _tmp6_) : NULL)), _g_object_unref0 (self->priv->editor), _tmp7_);
#line 184 "ease-editor-window.vala"
	self->priv->show_sorter = (_tmp9_ = _g_object_ref0 ((_tmp8_ = gtk_builder_get_object (builder, "slide-sorter-radio"), GTK_IS_RADIO_MENU_ITEM (_tmp8_) ? ((GtkRadioMenuItem*) _tmp8_) : NULL)), _g_object_unref0 (self->priv->show_sorter), _tmp9_);
#line 186 "ease-editor-window.vala"
	self->priv->show_editor = (_tmp11_ = _g_object_ref0 ((_tmp10_ = gtk_builder_get_object (builder, "editor-radio"), GTK_IS_RADIO_MENU_ITEM (_tmp10_) ? ((GtkRadioMenuItem*) _tmp10_) : NULL)), _g_object_unref0 (self->priv->show_editor), _tmp11_);
#line 187 "ease-editor-window.vala"
	self->priv->zoom_fit = (_tmp13_ = _g_object_ref0 ((_tmp12_ = gtk_builder_get_object (builder, "Zoom Fit"), GTK_IS_CHECK_MENU_ITEM (_tmp12_) ? ((GtkCheckMenuItem*) _tmp12_) : NULL)), _g_object_unref0 (self->priv->zoom_fit), _tmp13_);
#line 190 "ease-editor-window.vala"
	self->slide_button_panel = (_tmp14_ = g_object_ref_sink (ease_slide_button_panel_new (self->document, self)), _g_object_unref0 (self->slide_button_panel), _tmp14_);
#line 191 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) (_tmp15_ = gtk_builder_get_object (builder, "Slides Align"), GTK_IS_ALIGNMENT (_tmp15_) ? ((GtkAlignment*) _tmp15_) : NULL), (GtkWidget*) self->slide_button_panel);
#line 195 "ease-editor-window.vala"
	self->priv->undo = (_tmp16_ = ease_undo_controller_new (), _g_object_unref0 (self->priv->undo), _tmp16_);
#line 196 "ease-editor-window.vala"
	self->priv->undo_button = (_tmp18_ = _g_object_ref0 ((_tmp17_ = gtk_builder_get_object (builder, "Undo"), GTK_IS_TOOL_BUTTON (_tmp17_) ? ((GtkToolButton*) _tmp17_) : NULL)), _g_object_unref0 (self->priv->undo_button), _tmp18_);
#line 197 "ease-editor-window.vala"
	self->priv->redo_button = (_tmp20_ = _g_object_ref0 ((_tmp19_ = gtk_builder_get_object (builder, "Redo"), GTK_IS_TOOL_BUTTON (_tmp19_) ? ((GtkToolButton*) _tmp19_) : NULL)), _g_object_unref0 (self->priv->redo_button), _tmp20_);
#line 200 "ease-editor-window.vala"
	self->embed = (_tmp21_ = g_object_ref_sink (ease_editor_embed_new (self->document, self)), _g_object_unref0 (self->embed), _tmp21_);
#line 201 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) (_tmp22_ = gtk_builder_get_object (builder, "Embed Align"), GTK_IS_ALIGNMENT (_tmp22_) ? ((GtkAlignment*) _tmp22_) : NULL), (GtkWidget*) self->embed);
#line 202 "ease-editor-window.vala"
	g_signal_connect_object ((EaseUndoSource*) self->embed, "undo", (GCallback) _ease_editor_window_add_undo_action_ease_undo_source_undo, self, 0);
#line 205 "ease-editor-window.vala"
	self->priv->inspector = (_tmp23_ = g_object_ref_sink (ease_inspector_new (self->document)), _g_object_unref0 (self->priv->inspector), _tmp23_);
#line 206 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) (_tmp24_ = gtk_builder_get_object (builder, "Inspector Align"), GTK_IS_ALIGNMENT (_tmp24_) ? ((GtkAlignment*) _tmp24_) : NULL), (GtkWidget*) self->priv->inspector);
#line 207 "ease-editor-window.vala"
	g_signal_connect_object (self->embed, "element-selected", (GCallback) _ease_inspector_element_pane_on_element_selected_ease_editor_embed_element_selected, self->priv->inspector->element_pane, 0);
#line 209 "ease-editor-window.vala"
	g_signal_connect_object (self->embed, "element-deselected", (GCallback) _ease_inspector_element_pane_on_element_deselected_ease_editor_embed_element_deselected, self->priv->inspector->element_pane, 0);
#line 213 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) (_tmp25_ = gtk_builder_get_object (builder, "Zoom Slider Item"), GTK_IS_TOOL_ITEM (_tmp25_) ? ((GtkToolItem*) _tmp25_) : NULL), (GtkWidget*) (_tmp26_ = ease_editor_window_create_zoom_slider (self)));
#line 595 "ease-editor-window.c"
	_g_object_unref0 (_tmp26_);
#line 217 "ease-editor-window.vala"
	menu = _g_object_ref0 ((_tmp27_ = gtk_builder_get_object (builder, "add-slide-menu"), GTK_IS_MENU_SHELL (_tmp27_) ? ((GtkMenuShell*) _tmp27_) : NULL));
#line 599 "ease-editor-window.c"
	{
		const char** master_collection;
		int master_collection_length1;
		int master_it;
#line 219 "ease-editor-window.vala"
		master_collection = EASE_THEME_MASTER_SLIDES;
#line 606 "ease-editor-window.c"
		master_collection_length1 = G_N_ELEMENTS (EASE_THEME_MASTER_SLIDES);
		for (master_it = 0; master_it < G_N_ELEMENTS (EASE_THEME_MASTER_SLIDES); master_it = master_it + 1) {
			const char* master;
			master = master_collection[master_it];
			{
				char* _tmp28_;
				GtkMenuItem* _tmp29_;
				GtkMenuItem* item;
#line 221 "ease-editor-window.vala"
				item = (_tmp29_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp28_ = ease_theme_master_mnemonic_description (master))), _g_free0 (_tmp28_), _tmp29_);
#line 223 "ease-editor-window.vala"
				gtk_menu_shell_append (menu, (GtkWidget*) item);
#line 225 "ease-editor-window.vala"
				g_signal_connect_object (item, "activate", (GCallback) _ease_editor_window_on_new_slide_menu_gtk_menu_item_activate, self, 0);
#line 621 "ease-editor-window.c"
				_g_object_unref0 (item);
			}
		}
	}
#line 227 "ease-editor-window.vala"
	gtk_widget_show_all ((GtkWidget*) menu);
#line 230 "ease-editor-window.vala"
	gtk_widget_show_all ((GtkWidget*) self->slide_button_panel);
#line 231 "ease-editor-window.vala"
	gtk_widget_show_all ((GtkWidget*) self->embed);
#line 232 "ease-editor-window.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 233 "ease-editor-window.vala"
	gtk_widget_hide ((GtkWidget*) self->priv->inspector);
#line 234 "ease-editor-window.vala"
	ease_editor_window_set_slides_shown (self, TRUE);
#line 237 "ease-editor-window.vala"
	gtk_window_add_accel_group ((GtkWindow*) self, (_tmp30_ = gtk_builder_get_object (builder, "accel-group"), GTK_IS_ACCEL_GROUP (_tmp30_) ? ((GtkAccelGroup*) _tmp30_) : NULL));
#line 240 "ease-editor-window.vala"
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __lambda56__gtk_widget_delete_event, self, 0);
#line 273 "ease-editor-window.vala"
	ease_slide_button_panel_select_slide (self->slide_button_panel, _tmp31_ = ease_document_get_slide (self->document, 0));
#line 644 "ease-editor-window.c"
	_g_object_unref0 (_tmp31_);
#line 274 "ease-editor-window.vala"
	ease_editor_window_update_undo (self);
#line 648 "ease-editor-window.c"
	_g_object_unref0 (builder);
	_g_object_unref0 (menu);
	return self;
}


#line 164 "ease-editor-window.vala"
EaseEditorWindow* ease_editor_window_new (EaseDocument* doc) {
#line 164 "ease-editor-window.vala"
	return ease_editor_window_construct (EASE_TYPE_EDITOR_WINDOW, doc);
#line 659 "ease-editor-window.c"
}


#line 282 "ease-editor-window.vala"
void ease_editor_window_set_slide (EaseEditorWindow* self, gint index) {
#line 665 "ease-editor-window.c"
	EaseSlide* _tmp0_;
#line 282 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 284 "ease-editor-window.vala"
	self->slide = (_tmp0_ = ease_document_get_slide (self->document, index), _g_object_unref0 (self->slide), _tmp0_);
#line 287 "ease-editor-window.vala"
	ease_inspector_set_slide (self->priv->inspector, self->slide);
#line 288 "ease-editor-window.vala"
	ease_editor_embed_set_slide (self->embed, self->slide);
#line 675 "ease-editor-window.c"
}


#line 296 "ease-editor-window.vala"
void ease_editor_window_add_undo_action (EaseEditorWindow* self, EaseUndoItem* action) {
#line 296 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 296 "ease-editor-window.vala"
	g_return_if_fail (action != NULL);
#line 298 "ease-editor-window.vala"
	ease_undo_controller_add_action (self->priv->undo, action);
#line 299 "ease-editor-window.vala"
	ease_undo_controller_clear_redo (self->priv->undo);
#line 300 "ease-editor-window.vala"
	ease_editor_window_update_undo (self);
#line 303 "ease-editor-window.vala"
	if (self->priv->last_saved == 0) {
#line 305 "ease-editor-window.vala"
		self->priv->last_saved = (glong) time (NULL);
#line 695 "ease-editor-window.c"
	}
}


#line 313 "ease-editor-window.vala"
static void ease_editor_window_update_undo (EaseEditorWindow* self) {
#line 313 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 315 "ease-editor-window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->undo_button, ease_undo_controller_can_undo (self->priv->undo));
#line 316 "ease-editor-window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->redo_button, ease_undo_controller_can_redo (self->priv->undo));
#line 708 "ease-editor-window.c"
}


#line 321 "ease-editor-window.vala"
void ease_editor_window_on_open (GtkWidget* sender, EaseEditorWindow* self) {
#line 714 "ease-editor-window.c"
	char* filename;
#line 321 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 321 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 323 "ease-editor-window.vala"
	filename = ease_dialog_open_document ((GtkWindow*) self);
#line 324 "ease-editor-window.vala"
	if (filename != NULL) {
#line 324 "ease-editor-window.vala"
		ease_main_open_file (filename);
#line 726 "ease-editor-window.c"
	}
	_g_free0 (filename);
}


#line 329 "ease-editor-window.vala"
void ease_editor_window_on_quit (GtkWidget* sender, EaseEditorWindow* self) {
#line 329 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 329 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 331 "ease-editor-window.vala"
	gtk_main_quit ();
#line 740 "ease-editor-window.c"
}


#line 335 "ease-editor-window.vala"
void ease_editor_window_on_delete (GtkWidget* sender, EaseEditorWindow* self) {
#line 746 "ease-editor-window.c"
	gint i;
#line 335 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 335 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 337 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 337 "ease-editor-window.vala"
		return;
#line 756 "ease-editor-window.c"
	}
#line 339 "ease-editor-window.vala"
	i = ease_slide_index_of (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 340 "ease-editor-window.vala"
	ease_slide_remove_at (self->slide, i);
#line 762 "ease-editor-window.c"
}


#line 344 "ease-editor-window.vala"
void ease_editor_window_new_slide_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 768 "ease-editor-window.c"
	EaseSlide* s;
	gint index;
#line 344 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 346 "ease-editor-window.vala"
	s = ease_theme_create_slide (ease_document_get_theme (self->document), EASE_DOCUMENT_DEFAULT_SLIDE, ease_slide_get_width (self->slide), ease_slide_get_height (self->slide));
#line 350 "ease-editor-window.vala"
	index = ease_document_index_of (self->document, self->slide) + 1;
#line 352 "ease-editor-window.vala"
	ease_document_add_slide (self->document, index, s);
#line 779 "ease-editor-window.c"
	_g_object_unref0 (s);
}


#line 356 "ease-editor-window.vala"
void ease_editor_window_on_new_slide_menu (GtkWidget* sender, EaseEditorWindow* self) {
#line 786 "ease-editor-window.c"
	GtkWidget* _tmp0_;
	GtkMenuItem* item;
	char* _tmp1_;
	EaseSlide* _tmp2_;
	EaseSlide* s;
	gint index;
#line 356 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 358 "ease-editor-window.vala"
	item = _g_object_ref0 ((_tmp0_ = sender, GTK_IS_MENU_ITEM (_tmp0_) ? ((GtkMenuItem*) _tmp0_) : NULL));
#line 359 "ease-editor-window.vala"
	s = (_tmp2_ = ease_theme_create_slide (ease_document_get_theme (self->document), _tmp1_ = ease_theme_master_from_description (gtk_menu_item_get_label (item)), ease_slide_get_width (self->slide), ease_slide_get_height (self->slide)), _g_free0 (_tmp1_), _tmp2_);
#line 363 "ease-editor-window.vala"
	index = ease_document_index_of (self->document, self->slide) + 1;
#line 365 "ease-editor-window.vala"
	ease_document_add_slide (self->document, index, s);
#line 803 "ease-editor-window.c"
	_g_object_unref0 (s);
	_g_object_unref0 (item);
}


#line 369 "ease-editor-window.vala"
void ease_editor_window_remove_slide (GtkWidget* sender, EaseEditorWindow* self) {
#line 811 "ease-editor-window.c"
	EaseSlide* _tmp0_;
#line 369 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 372 "ease-editor-window.vala"
	if (ease_document_get_length (self->document) < 2) {
#line 372 "ease-editor-window.vala"
		return;
#line 819 "ease-editor-window.c"
	}
#line 375 "ease-editor-window.vala"
	if (self->priv->sorter != NULL) {
#line 823 "ease-editor-window.c"
		EaseSlide* s;
#line 377 "ease-editor-window.vala"
		s = ease_slide_sorter_delete_slide (self->priv->sorter);
#line 378 "ease-editor-window.vala"
		if (s != NULL) {
#line 378 "ease-editor-window.vala"
			ease_slide_button_panel_select_slide (self->slide_button_panel, s);
#line 831 "ease-editor-window.c"
		}
		_g_object_unref0 (s);
#line 379 "ease-editor-window.vala"
		return;
#line 836 "ease-editor-window.c"
	}
#line 383 "ease-editor-window.vala"
	ease_slide_button_panel_select_slide (self->slide_button_panel, _tmp0_ = ease_document_remove_slide (self->document, self->slide));
#line 840 "ease-editor-window.c"
	_g_object_unref0 (_tmp0_);
}


#line 387 "ease-editor-window.vala"
void ease_editor_window_play_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 387 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 387 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 389 "ease-editor-window.vala"
	g_signal_emit_by_name (self, "play", self->document);
#line 853 "ease-editor-window.c"
}


#line 393 "ease-editor-window.vala"
void ease_editor_window_undo_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 393 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 393 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 395 "ease-editor-window.vala"
	ease_undo_controller_undo (self->priv->undo);
#line 396 "ease-editor-window.vala"
	ease_editor_window_update_undo (self);
#line 397 "ease-editor-window.vala"
	ease_slide_actor_relayout (self->embed->slide_actor);
#line 398 "ease-editor-window.vala"
	ease_editor_embed_reposition_group (self->embed);
#line 871 "ease-editor-window.c"
}


#line 402 "ease-editor-window.vala"
void ease_editor_window_redo_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 402 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 402 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 404 "ease-editor-window.vala"
	ease_undo_controller_redo (self->priv->undo);
#line 405 "ease-editor-window.vala"
	ease_editor_window_update_undo (self);
#line 406 "ease-editor-window.vala"
	ease_slide_actor_relayout (self->embed->slide_actor);
#line 407 "ease-editor-window.vala"
	ease_editor_embed_reposition_group (self->embed);
#line 889 "ease-editor-window.c"
}


#line 411 "ease-editor-window.vala"
void ease_editor_window_insert_text (GtkWidget* sender, EaseEditorWindow* self) {
#line 895 "ease-editor-window.c"
	EaseTextElement* text;
#line 411 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 411 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 413 "ease-editor-window.vala"
	text = ease_theme_create_custom_text (ease_document_get_theme (self->document));
#line 414 "ease-editor-window.vala"
	ease_element_set_x ((EaseElement*) text, (ease_slide_get_width (self->slide) / 2) - (ease_element_get_width ((EaseElement*) text) / 2));
#line 415 "ease-editor-window.vala"
	ease_element_set_y ((EaseElement*) text, (ease_slide_get_height (self->slide) / 2) - (ease_element_get_height ((EaseElement*) text) / 2));
#line 416 "ease-editor-window.vala"
	ease_slide_append (self->slide, (EaseElement*) text);
#line 417 "ease-editor-window.vala"
	ease_editor_embed_select_element (self->embed, (EaseElement*) text);
#line 911 "ease-editor-window.c"
	_g_object_unref0 (text);
}


#line 423 "ease-editor-window.vala"
static void _lambda70_ (GtkFileChooserDialog* dialog, EaseEditorWindow* self) {
#line 918 "ease-editor-window.c"
	GtkFileFilter* filter;
	GtkFileFilter* _tmp0_;
#line 423 "ease-editor-window.vala"
	g_return_if_fail (dialog != NULL);
#line 425 "ease-editor-window.vala"
	filter = g_object_ref_sink (gtk_file_filter_new ());
#line 426 "ease-editor-window.vala"
	gtk_file_filter_add_pixbuf_formats (filter);
#line 427 "ease-editor-window.vala"
	gtk_file_filter_set_name (filter, _ ("Images"));
#line 428 "ease-editor-window.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 431 "ease-editor-window.vala"
	filter = (_tmp0_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (filter), _tmp0_);
#line 432 "ease-editor-window.vala"
	gtk_file_filter_set_name (filter, _ ("All Files"));
#line 433 "ease-editor-window.vala"
	gtk_file_filter_add_pattern (filter, "*");
#line 434 "ease-editor-window.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 939 "ease-editor-window.c"
	_g_object_unref0 (filter);
}


#line 423 "ease-editor-window.vala"
static void __lambda70__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self) {
#line 946 "ease-editor-window.c"
	_lambda70_ (d, self);
}


#line 421 "ease-editor-window.vala"
void ease_editor_window_insert_image (GtkWidget* sender, EaseEditorWindow* self) {
#line 953 "ease-editor-window.c"
	GError * _inner_error_;
	char* filename;
#line 421 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 421 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 960 "ease-editor-window.c"
	_inner_error_ = NULL;
#line 423 "ease-editor-window.vala"
	filename = ease_dialog_open_ext (_ ("Insert Image"), (GtkWindow*) self, __lambda70__ease_dialog_file_chooser_dialog_extension, self);
#line 437 "ease-editor-window.vala"
	if (filename != NULL) {
#line 966 "ease-editor-window.c"
		{
			ClutterTexture* img;
			EaseImageElement* e;
			gint width;
			gint height;
			char* _tmp0_;
			char* _tmp1_;
#line 441 "ease-editor-window.vala"
			img = g_object_ref_sink (clutter_texture_new_from_file (filename, &_inner_error_));
#line 976 "ease-editor-window.c"
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
#line 442 "ease-editor-window.vala"
			e = ease_image_element_new ();
#line 445 "ease-editor-window.vala"
			width = 0;
#line 445 "ease-editor-window.vala"
			height = 0;
#line 446 "ease-editor-window.vala"
			clutter_texture_get_base_size (img, &width, &height);
#line 448 "ease-editor-window.vala"
			ease_element_set_width ((EaseElement*) e, (float) width);
#line 449 "ease-editor-window.vala"
			ease_element_set_height ((EaseElement*) e, (float) height);
#line 450 "ease-editor-window.vala"
			ease_element_set_x ((EaseElement*) e, (float) ((ease_slide_get_width (self->slide) / 2) - (width / 2)));
#line 451 "ease-editor-window.vala"
			ease_element_set_y ((EaseElement*) e, (float) ((ease_slide_get_height (self->slide) / 2) - (height / 2)));
#line 453 "ease-editor-window.vala"
			ease_element_set_element_type ((EaseElement*) e, EASE_SLIDE_IMAGE_TYPE);
#line 454 "ease-editor-window.vala"
			ease_element_set_identifier ((EaseElement*) e, EASE_THEME_CUSTOM_MEDIA);
#line 455 "ease-editor-window.vala"
			_tmp0_ = ease_document_add_media_file (self->document, filename, &_inner_error_);
#line 1002 "ease-editor-window.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (e);
				_g_object_unref0 (img);
				goto __catch2_g_error;
			}
#line 455 "ease-editor-window.vala"
			ease_media_element_set_filename ((EaseMediaElement*) e, _tmp1_ = _tmp0_);
#line 1010 "ease-editor-window.c"
			_g_free0 (_tmp1_);
#line 456 "ease-editor-window.vala"
			ease_media_element_set_source_filename ((EaseMediaElement*) e, filename);
#line 459 "ease-editor-window.vala"
			ease_slide_append (self->slide, (EaseElement*) e);
#line 460 "ease-editor-window.vala"
			ease_editor_embed_select_element (self->embed, (EaseElement*) e);
#line 1018 "ease-editor-window.c"
			_g_object_unref0 (e);
			_g_object_unref0 (img);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
#line 464 "ease-editor-window.vala"
				ease_error_dialog (_ ("Error Inserting Image"), e->message);
#line 1031 "ease-editor-window.c"
				_g_error_free0 (e);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (filename);
}


#line 470 "ease-editor-window.vala"
void ease_editor_window_insert_video (GtkWidget* sender, EaseEditorWindow* self) {
#line 1049 "ease-editor-window.c"
	GError * _inner_error_;
	char* filename;
#line 470 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 470 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 1056 "ease-editor-window.c"
	_inner_error_ = NULL;
#line 472 "ease-editor-window.vala"
	filename = ease_dialog_open (_ ("Insert Video"), (GtkWindow*) self);
#line 474 "ease-editor-window.vala"
	if (filename != NULL) {
#line 1062 "ease-editor-window.c"
		{
			EaseVideoElement* e;
			char* _tmp0_;
			char* _tmp1_;
#line 478 "ease-editor-window.vala"
			e = ease_video_element_new ();
#line 481 "ease-editor-window.vala"
			ease_element_set_width ((EaseElement*) e, (float) 640);
#line 482 "ease-editor-window.vala"
			ease_element_set_height ((EaseElement*) e, (float) 480);
#line 483 "ease-editor-window.vala"
			ease_element_set_x ((EaseElement*) e, (ease_slide_get_width (self->slide) / 2) - (ease_element_get_width ((EaseElement*) e) / 2));
#line 484 "ease-editor-window.vala"
			ease_element_set_y ((EaseElement*) e, (ease_slide_get_height (self->slide) / 2) - (ease_element_get_height ((EaseElement*) e) / 2));
#line 486 "ease-editor-window.vala"
			ease_element_set_element_type ((EaseElement*) e, EASE_SLIDE_VIDEO_TYPE);
#line 487 "ease-editor-window.vala"
			ease_element_set_identifier ((EaseElement*) e, EASE_THEME_CUSTOM_MEDIA);
#line 488 "ease-editor-window.vala"
			_tmp0_ = ease_document_add_media_file (self->document, filename, &_inner_error_);
#line 1083 "ease-editor-window.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (e);
				goto __catch3_g_error;
			}
#line 488 "ease-editor-window.vala"
			ease_media_element_set_filename ((EaseMediaElement*) e, _tmp1_ = _tmp0_);
#line 1090 "ease-editor-window.c"
			_g_free0 (_tmp1_);
#line 489 "ease-editor-window.vala"
			ease_media_element_set_source_filename ((EaseMediaElement*) e, filename);
#line 492 "ease-editor-window.vala"
			ease_slide_append (self->slide, (EaseElement*) e);
#line 493 "ease-editor-window.vala"
			ease_editor_embed_select_element (self->embed, (EaseElement*) e);
#line 1098 "ease-editor-window.c"
			_g_object_unref0 (e);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
#line 497 "ease-editor-window.vala"
				ease_error_dialog (_ ("Error Inserting Video"), e->message);
#line 1110 "ease-editor-window.c"
				_g_error_free0 (e);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (filename);
}


#line 503 "ease-editor-window.vala"
void ease_editor_window_on_insert_rectangle (GtkWidget* sender, EaseEditorWindow* self) {
#line 1128 "ease-editor-window.c"
	EaseShapeElement* rect;
#line 503 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 503 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 505 "ease-editor-window.vala"
	rect = ease_shape_element_new (EASE_SHAPE_TYPE_RECTANGLE);
#line 506 "ease-editor-window.vala"
	ease_element_set_width ((EaseElement*) rect, (float) 400);
#line 507 "ease-editor-window.vala"
	ease_element_set_height ((EaseElement*) rect, (float) 300);
#line 508 "ease-editor-window.vala"
	ease_element_set_x ((EaseElement*) rect, (ease_document_get_width (self->document) / 2) - (ease_element_get_width ((EaseElement*) rect) / 2));
#line 509 "ease-editor-window.vala"
	ease_element_set_y ((EaseElement*) rect, (ease_document_get_height (self->document) / 2) - (ease_element_get_height ((EaseElement*) rect) / 2));
#line 510 "ease-editor-window.vala"
	ease_slide_append (self->slide, (EaseElement*) rect);
#line 511 "ease-editor-window.vala"
	ease_editor_embed_select_element (self->embed, (EaseElement*) rect);
#line 1148 "ease-editor-window.c"
	_g_object_unref0 (rect);
}


#line 515 "ease-editor-window.vala"
void ease_editor_window_on_insert_oval (GtkWidget* sender, EaseEditorWindow* self) {
#line 1155 "ease-editor-window.c"
	EaseShapeElement* oval;
#line 515 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 515 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 517 "ease-editor-window.vala"
	oval = ease_shape_element_new (EASE_SHAPE_TYPE_OVAL);
#line 518 "ease-editor-window.vala"
	ease_element_set_width ((EaseElement*) oval, (float) 300);
#line 519 "ease-editor-window.vala"
	ease_element_set_height ((EaseElement*) oval, (float) 300);
#line 520 "ease-editor-window.vala"
	ease_element_set_x ((EaseElement*) oval, (ease_document_get_width (self->document) / 2) - (ease_element_get_width ((EaseElement*) oval) / 2));
#line 521 "ease-editor-window.vala"
	ease_element_set_y ((EaseElement*) oval, (ease_document_get_height (self->document) / 2) - (ease_element_get_height ((EaseElement*) oval) / 2));
#line 522 "ease-editor-window.vala"
	ease_slide_append (self->slide, (EaseElement*) oval);
#line 523 "ease-editor-window.vala"
	ease_editor_embed_select_element (self->embed, (EaseElement*) oval);
#line 1175 "ease-editor-window.c"
	_g_object_unref0 (oval);
}


#line 545 "ease-editor-window.vala"
static void _lambda71_ (EaseSlide* s, EaseEditorWindow* self) {
#line 545 "ease-editor-window.vala"
	g_return_if_fail (s != NULL);
#line 546 "ease-editor-window.vala"
	ease_slide_button_panel_select_slide (self->slide_button_panel, s);
#line 547 "ease-editor-window.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) self->priv->show_editor, TRUE);
#line 1188 "ease-editor-window.c"
}


#line 545 "ease-editor-window.vala"
static void __lambda71__ease_slide_sorter_display_slide (EaseSlideSorter* _sender, EaseSlide* s, gpointer self) {
#line 1194 "ease-editor-window.c"
	_lambda71_ (s, self);
}


#line 527 "ease-editor-window.vala"
void ease_editor_window_set_view (GtkWidget* sender, EaseEditorWindow* self) {
#line 527 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 527 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 529 "ease-editor-window.vala"
	if (GTK_WIDGET (self->priv->show_editor) == sender) {
#line 1207 "ease-editor-window.c"
		EaseSlideSorter* _tmp0_;
#line 531 "ease-editor-window.vala"
		if (gtk_bin_get_child (self->priv->main_bin) == self->priv->editor) {
#line 531 "ease-editor-window.vala"
			return;
#line 1213 "ease-editor-window.c"
		}
#line 532 "ease-editor-window.vala"
		gtk_container_remove ((GtkContainer*) self->priv->main_bin, (GtkWidget*) self->priv->sorter);
#line 533 "ease-editor-window.vala"
		gtk_container_add ((GtkContainer*) self->priv->main_bin, self->priv->editor);
#line 534 "ease-editor-window.vala"
		self->priv->sorter = (_tmp0_ = NULL, _g_object_unref0 (self->priv->sorter), _tmp0_);
#line 1221 "ease-editor-window.c"
	} else {
#line 536 "ease-editor-window.vala"
		if (GTK_WIDGET (self->priv->show_sorter) == sender) {
#line 538 "ease-editor-window.vala"
			if (self->priv->sorter == NULL) {
#line 1227 "ease-editor-window.c"
				EaseSlideSorter* _tmp1_;
#line 538 "ease-editor-window.vala"
				self->priv->sorter = (_tmp1_ = g_object_ref_sink (ease_slide_sorter_new (self->document)), _g_object_unref0 (self->priv->sorter), _tmp1_);
#line 1231 "ease-editor-window.c"
			}
#line 539 "ease-editor-window.vala"
			if (gtk_bin_get_child (self->priv->main_bin) == GTK_WIDGET (self->priv->sorter)) {
#line 539 "ease-editor-window.vala"
				return;
#line 1237 "ease-editor-window.c"
			}
#line 540 "ease-editor-window.vala"
			gtk_container_remove ((GtkContainer*) self->priv->main_bin, self->priv->editor);
#line 541 "ease-editor-window.vala"
			gtk_container_add ((GtkContainer*) self->priv->main_bin, (GtkWidget*) self->priv->sorter);
#line 542 "ease-editor-window.vala"
			gtk_widget_show_all ((GtkWidget*) self->priv->sorter);
#line 545 "ease-editor-window.vala"
			g_signal_connect_object (self->priv->sorter, "display-slide", (GCallback) __lambda71__ease_slide_sorter_display_slide, self, 0);
#line 1247 "ease-editor-window.c"
		}
	}
}


#line 553 "ease-editor-window.vala"
void ease_editor_window_zoom_in (GtkWidget* sender, EaseEditorWindow* self) {
#line 553 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 553 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 555 "ease-editor-window.vala"
	ease_editor_embed_set_zoom_fit (self->embed, FALSE);
#line 556 "ease-editor-window.vala"
	gtk_check_menu_item_set_active (self->priv->zoom_fit, FALSE);
#line 557 "ease-editor-window.vala"
	ease_zoom_slider_zoom_in (self->zoom_slider);
#line 1265 "ease-editor-window.c"
}


#line 561 "ease-editor-window.vala"
void ease_editor_window_zoom_out (GtkWidget* sender, EaseEditorWindow* self) {
#line 561 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 561 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 563 "ease-editor-window.vala"
	ease_editor_embed_set_zoom_fit (self->embed, FALSE);
#line 564 "ease-editor-window.vala"
	gtk_check_menu_item_set_active (self->priv->zoom_fit, FALSE);
#line 565 "ease-editor-window.vala"
	ease_zoom_slider_zoom_out (self->zoom_slider);
#line 1281 "ease-editor-window.c"
}


#line 569 "ease-editor-window.vala"
void ease_editor_window_on_zoom_fit (GtkWidget* sender, EaseEditorWindow* self) {
#line 1287 "ease-editor-window.c"
	GtkWidget* _tmp0_;
#line 569 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 569 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 571 "ease-editor-window.vala"
	ease_editor_embed_set_zoom_fit (self->embed, gtk_check_menu_item_get_active ((_tmp0_ = sender, GTK_IS_CHECK_MENU_ITEM (_tmp0_) ? ((GtkCheckMenuItem*) _tmp0_) : NULL)));
#line 1295 "ease-editor-window.c"
}


#line 575 "ease-editor-window.vala"
gboolean ease_editor_window_save_document (GtkWidget* sender, EaseEditorWindow* self) {
#line 1301 "ease-editor-window.c"
	gboolean result = FALSE;
	GError * _inner_error_;
#line 575 "ease-editor-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1306 "ease-editor-window.c"
	_inner_error_ = NULL;
#line 577 "ease-editor-window.vala"
	if (ease_document_get_filename (self->document) == NULL) {
#line 1310 "ease-editor-window.c"
		char* filename;
#line 579 "ease-editor-window.vala"
		filename = ease_dialog_save_document (_ ("Save Document"), (GtkWindow*) self);
#line 581 "ease-editor-window.vala"
		if (filename != NULL) {
#line 583 "ease-editor-window.vala"
			ease_document_set_filename (self->document, filename);
#line 1318 "ease-editor-window.c"
		} else {
			result = FALSE;
			_g_free0 (filename);
#line 585 "ease-editor-window.vala"
			return result;
#line 1324 "ease-editor-window.c"
		}
		_g_free0 (filename);
	}
	{
#line 590 "ease-editor-window.vala"
		ease_document_to_json (self->document, (GtkWindow*) self, &_inner_error_);
#line 1331 "ease-editor-window.c"
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
#line 591 "ease-editor-window.vala"
		self->priv->last_saved = (glong) 0;
#line 1337 "ease-editor-window.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 595 "ease-editor-window.vala"
			ease_error_dialog (_ ("Error Saving Document"), e->message);
#line 1348 "ease-editor-window.c"
			result = FALSE;
			_g_error_free0 (e);
#line 596 "ease-editor-window.vala"
			return result;
#line 1353 "ease-editor-window.c"
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
#line 598 "ease-editor-window.vala"
	return result;
#line 1365 "ease-editor-window.c"
}


#line 603 "ease-editor-window.vala"
void ease_editor_window_export_as_pdf (GtkWidget* sender, EaseEditorWindow* self) {
#line 603 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 603 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 605 "ease-editor-window.vala"
	ease_document_export_as_pdf (self->document, (GtkWindow*) self);
#line 1377 "ease-editor-window.c"
}


#line 609 "ease-editor-window.vala"
void ease_editor_window_export_as_postscript (GtkWidget* sender, EaseEditorWindow* self) {
#line 609 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 609 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 611 "ease-editor-window.vala"
	ease_document_export_as_postscript (self->document, (GtkWindow*) self);
#line 1389 "ease-editor-window.c"
}


#line 615 "ease-editor-window.vala"
void ease_editor_window_export_as_html (GtkWidget* sender, EaseEditorWindow* self) {
#line 615 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 615 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 617 "ease-editor-window.vala"
	ease_document_export_as_html (self->document, (GtkWindow*) self);
#line 1401 "ease-editor-window.c"
}


#line 621 "ease-editor-window.vala"
void ease_editor_window_on_lower (GtkWidget* sender, EaseEditorWindow* self) {
#line 621 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 621 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 623 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 623 "ease-editor-window.vala"
		return;
#line 1415 "ease-editor-window.c"
	}
#line 624 "ease-editor-window.vala"
	ease_slide_lower (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 1419 "ease-editor-window.c"
}


#line 628 "ease-editor-window.vala"
void ease_editor_window_on_raise (GtkWidget* sender, EaseEditorWindow* self) {
#line 628 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 628 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 630 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 630 "ease-editor-window.vala"
		return;
#line 1433 "ease-editor-window.c"
	}
#line 631 "ease-editor-window.vala"
	ease_slide_raise (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 1437 "ease-editor-window.c"
}


#line 635 "ease-editor-window.vala"
void ease_editor_window_on_lower_bottom (GtkWidget* sender, EaseEditorWindow* self) {
#line 635 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 635 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 637 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 637 "ease-editor-window.vala"
		return;
#line 1451 "ease-editor-window.c"
	}
#line 638 "ease-editor-window.vala"
	ease_slide_lower_bottom (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 1455 "ease-editor-window.c"
}


#line 642 "ease-editor-window.vala"
void ease_editor_window_on_raise_top (GtkWidget* sender, EaseEditorWindow* self) {
#line 642 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 642 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 644 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 644 "ease-editor-window.vala"
		return;
#line 1469 "ease-editor-window.c"
	}
#line 645 "ease-editor-window.vala"
	ease_slide_raise_top (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 1473 "ease-editor-window.c"
}


#line 649 "ease-editor-window.vala"
void ease_editor_window_inspector_clicked_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 649 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 651 "ease-editor-window.vala"
	if (gtk_widget_get_visible ((GtkWidget*) self->priv->inspector)) {
#line 653 "ease-editor-window.vala"
		gtk_widget_hide ((GtkWidget*) self->priv->inspector);
#line 1485 "ease-editor-window.c"
	} else {
#line 657 "ease-editor-window.vala"
		gtk_widget_show ((GtkWidget*) self->priv->inspector);
#line 1489 "ease-editor-window.c"
	}
}


#line 728 "ease-editor-window.vala"
static void _ease_editor_window_color_dialog_changed_gtk_color_selection_color_changed (GtkColorSelection* _sender, gpointer self) {
#line 1496 "ease-editor-window.c"
	ease_editor_window_color_dialog_changed (self, _sender);
}


#line 735 "ease-editor-window.vala"
static void _ease_editor_window_color_dialog_selection_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 1503 "ease-editor-window.c"
	ease_editor_window_color_dialog_selection (self, _sender, pspec);
}


#line 691 "ease-editor-window.vala"
static void _lambda72_ (EaseEditorWindow* self) {
#line 1510 "ease-editor-window.c"
	GQuark _tmp1_;
	guint _tmp0_;
	guint _tmp2_;
	GtkColorSelectionDialog* _tmp3_;
#line 692 "ease-editor-window.vala"
	g_signal_parse_name ("notify::selected", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
#line 692 "ease-editor-window.vala"
	g_signal_handlers_disconnect_matched ((GObject*) self->embed, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _ease_editor_window_color_dialog_selection_g_object_notify, self);
#line 693 "ease-editor-window.vala"
	g_signal_parse_name ("color-changed", GTK_TYPE_COLOR_SELECTION, &_tmp2_, NULL, FALSE);
#line 693 "ease-editor-window.vala"
	g_signal_handlers_disconnect_matched (self->priv->color_selection, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _ease_editor_window_color_dialog_changed_gtk_color_selection_color_changed, self);
#line 694 "ease-editor-window.vala"
	gtk_object_destroy ((GtkObject*) self->priv->color_dialog);
#line 695 "ease-editor-window.vala"
	self->priv->color_dialog = (_tmp3_ = NULL, _g_object_unref0 (self->priv->color_dialog), _tmp3_);
#line 1527 "ease-editor-window.c"
}


#line 691 "ease-editor-window.vala"
static void __lambda72__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
#line 1533 "ease-editor-window.c"
	_lambda72_ (self);
}


static gboolean _clutter_color_equal (const ClutterColor* s1, const ClutterColor* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}


#line 699 "ease-editor-window.vala"
static void _lambda73_ (Block1Data* _data1_) {
#line 1566 "ease-editor-window.c"
	EaseEditorWindow * self;
	ClutterColor* _tmp0_;
	gboolean _tmp1_;
	self = _data1_->self;
#line 700 "ease-editor-window.vala"
	gtk_widget_hide ((GtkWidget*) self->priv->color_dialog);
#line 703 "ease-editor-window.vala"
	if ((_tmp1_ = _clutter_color_equal (_data1_->original_color, _tmp0_ = ease_element_get_color (ease_editor_embed_get_selected (self->embed)->element)) != TRUE, _g_free0 (_tmp0_), _tmp1_)) {
#line 705 "ease-editor-window.vala"
		ease_editor_window_add_undo_action (self, (EaseUndoItem*) self->priv->undo_action);
#line 1577 "ease-editor-window.c"
	}
}


#line 699 "ease-editor-window.vala"
static void __lambda73__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1584 "ease-editor-window.c"
	_lambda73_ (self);
}


#line 710 "ease-editor-window.vala"
static void _lambda74_ (Block1Data* _data1_) {
#line 1591 "ease-editor-window.c"
	EaseEditorWindow * self;
	self = _data1_->self;
#line 711 "ease-editor-window.vala"
	ease_element_set_color (ease_editor_embed_get_selected (self->embed)->element, _data1_->original_color);
#line 712 "ease-editor-window.vala"
	gtk_widget_hide ((GtkWidget*) self->priv->color_dialog);
#line 1598 "ease-editor-window.c"
}


#line 710 "ease-editor-window.vala"
static void __lambda74__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1604 "ease-editor-window.c"
	_lambda74_ (self);
}


#line 716 "ease-editor-window.vala"
static void _lambda75_ (EaseEditorWindow* self) {
#line 1611 "ease-editor-window.c"
	GtkWidget* _tmp1_;
	GtkWidget* _tmp0_ = NULL;
#line 717 "ease-editor-window.vala"
	gtk_widget_activate (_tmp1_ = (g_object_get (self->priv->color_dialog, "cancel-button", &_tmp0_, NULL), _tmp0_));
#line 1616 "ease-editor-window.c"
	_g_object_unref0 (_tmp1_);
}


#line 716 "ease-editor-window.vala"
static void __lambda75__gtk_dialog_close (GtkDialog* _sender, gpointer self) {
#line 1623 "ease-editor-window.c"
	_lambda75_ (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_free0 (_data1_->original_color);
		g_slice_free (Block1Data, _data1_);
	}
}


#line 662 "ease-editor-window.vala"
void ease_editor_window_show_color_dialog (GtkWidget* sender, EaseEditorWindow* self) {
#line 1645 "ease-editor-window.c"
	Block1Data* _data1_;
	EaseUndoAction* _tmp0_;
	GtkColorSelectionDialog* _tmp1_;
	GtkColorSelection* _tmp3_;
	GtkWidget* _tmp2_;
	GtkButton* _tmp6_;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_;
	GtkButton* _tmp9_;
	GtkWidget* _tmp7_ = NULL;
	GtkWidget* _tmp8_;
#line 662 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 662 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 1661 "ease-editor-window.c"
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
#line 665 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 1667 "ease-editor-window.c"
		block1_data_unref (_data1_);
#line 665 "ease-editor-window.vala"
		return;
#line 1671 "ease-editor-window.c"
	}
#line 668 "ease-editor-window.vala"
	if (self->priv->color_dialog != NULL) {
#line 670 "ease-editor-window.vala"
		gtk_window_present ((GtkWindow*) self->priv->color_dialog);
#line 1677 "ease-editor-window.c"
		block1_data_unref (_data1_);
#line 671 "ease-editor-window.vala"
		return;
#line 1681 "ease-editor-window.c"
	}
	_data1_->original_color = ease_element_get_color (ease_editor_embed_get_selected (self->embed)->element);
#line 678 "ease-editor-window.vala"
	self->priv->undo_action = (_tmp0_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self->embed)->element, "color"), _g_object_unref0 (self->priv->undo_action), _tmp0_);
#line 681 "ease-editor-window.vala"
	self->priv->color_dialog = (_tmp1_ = g_object_ref_sink ((GtkColorSelectionDialog*) gtk_color_selection_dialog_new (_ ("Select Color"))), _g_object_unref0 (self->priv->color_dialog), _tmp1_);
#line 682 "ease-editor-window.vala"
	self->priv->color_selection = (_tmp3_ = _g_object_ref0 ((_tmp2_ = gtk_color_selection_dialog_get_color_selection (self->priv->color_dialog), GTK_IS_COLOR_SELECTION (_tmp2_) ? ((GtkColorSelection*) _tmp2_) : NULL)), _g_object_unref0 (self->priv->color_selection), _tmp3_);
#line 685 "ease-editor-window.vala"
	g_signal_connect_object (self->priv->color_selection, "color-changed", (GCallback) _ease_editor_window_color_dialog_changed_gtk_color_selection_color_changed, self, 0);
#line 688 "ease-editor-window.vala"
	g_signal_connect_object ((GObject*) self->embed, "notify::selected", (GCallback) _ease_editor_window_color_dialog_selection_g_object_notify, self, 0);
#line 691 "ease-editor-window.vala"
	g_signal_connect_object ((GtkWidget*) self->priv->color_dialog, "hide", (GCallback) __lambda72__gtk_widget_hide, self, 0);
#line 699 "ease-editor-window.vala"
	g_signal_connect_data (_tmp6_ = (_tmp5_ = (g_object_get (self->priv->color_dialog, "ok-button", &_tmp4_, NULL), _tmp4_), GTK_IS_BUTTON (_tmp5_) ? ((GtkButton*) _tmp5_) : NULL), "clicked", (GCallback) __lambda73__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 1698 "ease-editor-window.c"
	_g_object_unref0 (_tmp6_);
#line 710 "ease-editor-window.vala"
	g_signal_connect_data (_tmp9_ = (_tmp8_ = (g_object_get (self->priv->color_dialog, "cancel-button", &_tmp7_, NULL), _tmp7_), GTK_IS_BUTTON (_tmp8_) ? ((GtkButton*) _tmp8_) : NULL), "clicked", (GCallback) __lambda74__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 1702 "ease-editor-window.c"
	_g_object_unref0 (_tmp9_);
#line 716 "ease-editor-window.vala"
	g_signal_connect_object ((GtkDialog*) self->priv->color_dialog, "close", (GCallback) __lambda75__gtk_dialog_close, self, 0);
#line 721 "ease-editor-window.vala"
	gtk_window_set_transient_for ((GtkWindow*) self->priv->color_dialog, (GtkWindow*) self);
#line 722 "ease-editor-window.vala"
	gtk_window_set_modal ((GtkWindow*) self->priv->color_dialog, TRUE);
#line 725 "ease-editor-window.vala"
	gtk_dialog_run ((GtkDialog*) self->priv->color_dialog);
#line 1712 "ease-editor-window.c"
	block1_data_unref (_data1_);
}


#line 728 "ease-editor-window.vala"
static void ease_editor_window_color_dialog_changed (EaseEditorWindow* self, GtkColorSelection* sender) {
#line 1719 "ease-editor-window.c"
	ClutterColor _tmp3_;
	ClutterColor _tmp2_ = {0};
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0};
#line 728 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 728 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 730 "ease-editor-window.vala"
	ease_editor_embed_set_element_color (self->embed, (_tmp3_ = (ease_transformations_gdk_color_to_clutter_color ((_tmp1_ = (gtk_color_selection_get_current_color (sender, &_tmp0_), _tmp0_), &_tmp1_), &_tmp2_), _tmp2_), &_tmp3_));
#line 732 "ease-editor-window.vala"
	g_signal_emit_by_name (self->slide, "changed", self->slide);
#line 1732 "ease-editor-window.c"
}


#line 735 "ease-editor-window.vala"
static void ease_editor_window_color_dialog_selection (EaseEditorWindow* self, GObject* sender, GParamSpec* spec) {
#line 1738 "ease-editor-window.c"
	GObject* _tmp0_;
	ClutterColor* color;
	GdkColor _tmp1_ = {0};
	GdkColor _tmp2_;
#line 735 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 735 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 735 "ease-editor-window.vala"
	g_return_if_fail (spec != NULL);
#line 737 "ease-editor-window.vala"
	color = ease_element_get_color (ease_editor_embed_get_selected ((_tmp0_ = sender, EASE_IS_EDITOR_EMBED (_tmp0_) ? ((EaseEditorEmbed*) _tmp0_) : NULL))->element);
#line 738 "ease-editor-window.vala"
	if (color == NULL) {
#line 1753 "ease-editor-window.c"
		_g_free0 (color);
#line 738 "ease-editor-window.vala"
		return;
#line 1757 "ease-editor-window.c"
	}
#line 740 "ease-editor-window.vala"
	gtk_color_selection_set_current_color (self->priv->color_selection, (_tmp2_ = (ease_transformations_clutter_color_to_gdk_color (color, &_tmp1_), _tmp1_), &_tmp2_));
#line 1761 "ease-editor-window.c"
	_g_free0 (color);
}


#line 745 "ease-editor-window.vala"
void ease_editor_window_select_font (GtkWidget* sender, EaseEditorWindow* self) {
#line 1768 "ease-editor-window.c"
	GtkFontSelectionDialog* font_selection;
	EaseElement* _tmp0_;
	EaseTextElement* text;
	const char* _tmp1_;
	PangoFontDescription* _tmp2_;
#line 745 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 748 "ease-editor-window.vala"
	font_selection = g_object_ref_sink ((GtkFontSelectionDialog*) gtk_font_selection_dialog_new (_ ("Select Font")));
#line 751 "ease-editor-window.vala"
	text = _g_object_ref0 ((_tmp0_ = ease_editor_embed_get_selected (self->embed)->element, EASE_IS_TEXT_ELEMENT (_tmp0_) ? ((EaseTextElement*) _tmp0_) : NULL));
#line 1780 "ease-editor-window.c"
	_tmp1_ = NULL;
#line 754 "ease-editor-window.vala"
	if (_vala_strcmp0 (ease_text_element_get_text (text), "") != 0) {
#line 755 "ease-editor-window.vala"
		_tmp1_ = ease_text_element_get_text (text);
#line 1786 "ease-editor-window.c"
	} else {
#line 755 "ease-editor-window.vala"
		_tmp1_ = EASE_EDITOR_WINDOW_FONT_TEXT;
#line 1790 "ease-editor-window.c"
	}
#line 754 "ease-editor-window.vala"
	gtk_font_selection_dialog_set_preview_text (font_selection, _tmp1_);
#line 758 "ease-editor-window.vala"
	gtk_font_selection_dialog_set_font_name (font_selection, pango_font_description_to_string (_tmp2_ = ease_text_element_get_font_description (text)));
#line 1796 "ease-editor-window.c"
	_pango_font_description_free0 (_tmp2_);
#line 761 "ease-editor-window.vala"
	switch (gtk_dialog_run ((GtkDialog*) font_selection)) {
#line 1800 "ease-editor-window.c"
		case GTK_RESPONSE_OK:
		{
			EaseUndoAction* _tmp3_;
			PangoFontDescription* _tmp4_;
#line 765 "ease-editor-window.vala"
			ease_editor_window_add_undo_action (self, (EaseUndoItem*) (_tmp3_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self->embed)->element, "font-description")));
#line 1807 "ease-editor-window.c"
			_g_object_unref0 (_tmp3_);
#line 769 "ease-editor-window.vala"
			ease_text_element_set_font_description (text, _tmp4_ = pango_font_description_from_string (gtk_font_selection_dialog_get_font_name (font_selection)));
#line 1811 "ease-editor-window.c"
			_pango_font_description_free0 (_tmp4_);
#line 774 "ease-editor-window.vala"
			g_signal_emit_by_name ((EaseElement*) text, "changed");
#line 775 "ease-editor-window.vala"
			break;
#line 1817 "ease-editor-window.c"
		}
	}
#line 778 "ease-editor-window.vala"
	gtk_object_destroy ((GtkObject*) font_selection);
#line 1822 "ease-editor-window.c"
	_g_object_unref0 (text);
	_g_object_unref0 (font_selection);
}


#line 790 "ease-editor-window.vala"
static void _lambda55_ (EaseEditorWindow* self) {
#line 791 "ease-editor-window.vala"
	ease_editor_embed_set_zoom_fit (self->embed, FALSE);
#line 792 "ease-editor-window.vala"
	gtk_check_menu_item_set_active (self->priv->zoom_fit, FALSE);
#line 793 "ease-editor-window.vala"
	ease_editor_embed_set_zoom (self->embed, ((float) ease_zoom_slider_get_value (self->zoom_slider)) / 100.f);
#line 1836 "ease-editor-window.c"
}


#line 790 "ease-editor-window.vala"
static void __lambda55__ease_zoom_slider_value_changed (EaseZoomSlider* _sender, gpointer self) {
#line 1842 "ease-editor-window.c"
	_lambda55_ (self);
}


#line 781 "ease-editor-window.vala"
static EaseZoomSlider* ease_editor_window_create_zoom_slider (EaseEditorWindow* self) {
#line 1849 "ease-editor-window.c"
	EaseZoomSlider* result = NULL;
	EaseZoomSlider* _tmp1_;
	GtkAdjustment* _tmp0_;
#line 781 "ease-editor-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 784 "ease-editor-window.vala"
	self->zoom_slider = (_tmp1_ = (EaseZoomSlider*) g_object_ref_sink (ease_animated_zoom_slider_new (_tmp0_ = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new ((double) 100, (double) 10, (double) 400, (double) 10, (double) 50, (double) 50)), self->priv->ZOOM_LEVELS, self->priv->ZOOM_LEVELS_length1)), _g_object_unref0 (self->zoom_slider), _tmp1_);
#line 1857 "ease-editor-window.c"
	_g_object_unref0 (_tmp0_);
#line 787 "ease-editor-window.vala"
	ease_zoom_slider_set_value_pos (self->zoom_slider, GTK_POS_RIGHT);
#line 788 "ease-editor-window.vala"
	ease_zoom_slider_set_digits (self->zoom_slider, 0);
#line 790 "ease-editor-window.vala"
	g_signal_connect_object (self->zoom_slider, "value-changed", (GCallback) __lambda55__ease_zoom_slider_value_changed, self, 0);
#line 796 "ease-editor-window.vala"
	gtk_widget_show_all ((GtkWidget*) self->zoom_slider);
#line 1867 "ease-editor-window.c"
	result = _g_object_ref0 (self->zoom_slider);
#line 798 "ease-editor-window.vala"
	return result;
#line 1871 "ease-editor-window.c"
}


gboolean ease_editor_window_get_slides_shown (EaseEditorWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_slides_shown;
#line 102 "ease-editor-window.vala"
	return result;
#line 1881 "ease-editor-window.c"
}


void ease_editor_window_set_slides_shown (EaseEditorWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_slides_shown = value;
	g_object_notify ((GObject *) self, "slides-shown");
}


static void ease_editor_window_class_init (EaseEditorWindowClass * klass) {
	ease_editor_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseEditorWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_editor_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_editor_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_editor_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_EDITOR_WINDOW_SLIDES_SHOWN, g_param_spec_boolean ("slides-shown", "slides-shown", "slides-shown", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("play", EASE_TYPE_EDITOR_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_DOCUMENT);
	g_signal_new ("close", EASE_TYPE_EDITOR_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_EDITOR_WINDOW);
}


static void ease_editor_window_instance_init (EaseEditorWindow * self) {
	gint* _tmp0_ = NULL;
	self->priv = EASE_EDITOR_WINDOW_GET_PRIVATE (self);
	self->priv->last_saved = (glong) 0;
	self->priv->ZOOM_LEVELS = (_tmp0_ = g_new0 (gint, 13), _tmp0_[0] = 10, _tmp0_[1] = 25, _tmp0_[2] = 33, _tmp0_[3] = 50, _tmp0_[4] = 66, _tmp0_[5] = 75, _tmp0_[6] = 100, _tmp0_[7] = 125, _tmp0_[8] = 150, _tmp0_[9] = 200, _tmp0_[10] = 250, _tmp0_[11] = 300, _tmp0_[12] = 400, _tmp0_);
	self->priv->ZOOM_LEVELS_length1 = 13;
	self->priv->_ZOOM_LEVELS_size_ = self->priv->ZOOM_LEVELS_length1;
}


static void ease_editor_window_finalize (GObject* obj) {
	EaseEditorWindow * self;
	self = EASE_EDITOR_WINDOW (obj);
	_g_object_unref0 (self->embed);
	_g_object_unref0 (self->slide_button_panel);
	_g_object_unref0 (self->zoom_slider);
	_g_object_unref0 (self->priv->player);
	_g_object_unref0 (self->document);
	_g_object_unref0 (self->slide);
	_g_object_unref0 (self->priv->inspector);
	_g_object_unref0 (self->priv->editor);
	_g_object_unref0 (self->priv->sorter);
	_g_object_unref0 (self->priv->main_bin);
	_g_object_unref0 (self->priv->undo);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->undo_button);
	_g_object_unref0 (self->priv->redo_button);
	_g_object_unref0 (self->priv->color_dialog);
	_g_object_unref0 (self->priv->color_selection);
	_g_object_unref0 (self->priv->show_editor);
	_g_object_unref0 (self->priv->show_sorter);
	_g_object_unref0 (self->priv->zoom_fit);
	self->priv->ZOOM_LEVELS = (g_free (self->priv->ZOOM_LEVELS), NULL);
	G_OBJECT_CLASS (ease_editor_window_parent_class)->finalize (obj);
}


GType ease_editor_window_get_type (void) {
	static volatile gsize ease_editor_window_type_id__volatile = 0;
	if (g_once_init_enter (&ease_editor_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseEditorWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_editor_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseEditorWindow), 0, (GInstanceInitFunc) ease_editor_window_instance_init, NULL };
		GType ease_editor_window_type_id;
		ease_editor_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "EaseEditorWindow", &g_define_type_info, 0);
		g_once_init_leave (&ease_editor_window_type_id__volatile, ease_editor_window_type_id);
	}
	return ease_editor_window_type_id__volatile;
}


static void ease_editor_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseEditorWindow * self;
	self = EASE_EDITOR_WINDOW (object);
	switch (property_id) {
		case EASE_EDITOR_WINDOW_SLIDES_SHOWN:
		g_value_set_boolean (value, ease_editor_window_get_slides_shown (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_editor_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseEditorWindow * self;
	self = EASE_EDITOR_WINDOW (object);
	switch (property_id) {
		case EASE_EDITOR_WINDOW_SLIDES_SHOWN:
		ease_editor_window_set_slides_shown (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




