/* ease-document.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-document.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <cairo-pdf.h>
#include <cairo-ps.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;
typedef struct _EaseDocumentPrivate EaseDocumentPrivate;

#define EASE_TYPE_THEME (ease_theme_get_type ())
#define EASE_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_THEME, EaseTheme))
#define EASE_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_THEME, EaseThemeClass))
#define EASE_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_THEME))
#define EASE_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_THEME))
#define EASE_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_THEME, EaseThemeClass))

typedef struct _EaseTheme EaseTheme;
typedef struct _EaseThemeClass EaseThemeClass;

#define EASE_TYPE_ITERABLE_LIST_STORE (ease_iterable_list_store_get_type ())
#define EASE_ITERABLE_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStore))
#define EASE_ITERABLE_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStoreClass))
#define EASE_IS_ITERABLE_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ITERABLE_LIST_STORE))
#define EASE_IS_ITERABLE_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ITERABLE_LIST_STORE))
#define EASE_ITERABLE_LIST_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStoreClass))

typedef struct _EaseIterableListStore EaseIterableListStore;
typedef struct _EaseIterableListStoreClass EaseIterableListStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define EASE_TYPE_ITERABLE_TREE_MODEL (ease_iterable_tree_model_get_type ())
#define EASE_ITERABLE_TREE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ITERABLE_TREE_MODEL, EaseIterableTreeModel))
#define EASE_IS_ITERABLE_TREE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ITERABLE_TREE_MODEL))
#define EASE_ITERABLE_TREE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_ITERABLE_TREE_MODEL, EaseIterableTreeModelIface))

typedef struct _EaseIterableTreeModel EaseIterableTreeModel;
typedef struct _EaseIterableTreeModelIface EaseIterableTreeModelIface;

#define EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR (ease_iterable_tree_model_iterator_get_type ())
#define EASE_ITERABLE_TREE_MODEL_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR, EaseIterableTreeModelIterator))
#define EASE_ITERABLE_TREE_MODEL_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR, EaseIterableTreeModelIteratorClass))
#define EASE_ITERABLE_TREE_MODEL_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR))
#define EASE_ITERABLE_TREE_MODEL_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR))
#define EASE_ITERABLE_TREE_MODEL_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_ITERABLE_TREE_MODEL_TYPE_ITERATOR, EaseIterableTreeModelIteratorClass))

typedef struct _EaseIterableTreeModelIterator EaseIterableTreeModelIterator;
typedef struct _EaseIterableTreeModelIteratorClass EaseIterableTreeModelIteratorClass;
#define _ease_iterable_tree_model_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_iterable_tree_model_iterator_unref (var), NULL)))
#define _json_node_free0(var) ((var == NULL) ? NULL : (var = (json_node_free (var), NULL)))

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;

#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;

#define EASE_SLIDE_TYPE_ITERATOR (ease_slide_iterator_get_type ())
#define EASE_SLIDE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIterator))
#define EASE_SLIDE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorClass))
#define EASE_SLIDE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_SLIDE_TYPE_ITERATOR))
#define EASE_SLIDE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_SLIDE_TYPE_ITERATOR))
#define EASE_SLIDE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorClass))

typedef struct _EaseSlideIterator EaseSlideIterator;
typedef struct _EaseSlideIteratorClass EaseSlideIteratorClass;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;
#define _ease_slide_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_slide_iterator_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_SLIDE_ADD_UNDO_ACTION (ease_slide_add_undo_action_get_type ())
#define EASE_SLIDE_ADD_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_ADD_UNDO_ACTION, EaseSlideAddUndoAction))
#define EASE_SLIDE_ADD_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_ADD_UNDO_ACTION, EaseSlideAddUndoActionClass))
#define EASE_IS_SLIDE_ADD_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_ADD_UNDO_ACTION))
#define EASE_IS_SLIDE_ADD_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_ADD_UNDO_ACTION))
#define EASE_SLIDE_ADD_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_ADD_UNDO_ACTION, EaseSlideAddUndoActionClass))

typedef struct _EaseSlideAddUndoAction EaseSlideAddUndoAction;
typedef struct _EaseSlideAddUndoActionClass EaseSlideAddUndoActionClass;

#define EASE_TYPE_SLIDE_REMOVE_UNDO_ACTION (ease_slide_remove_undo_action_get_type ())
#define EASE_SLIDE_REMOVE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_REMOVE_UNDO_ACTION, EaseSlideRemoveUndoAction))
#define EASE_SLIDE_REMOVE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_REMOVE_UNDO_ACTION, EaseSlideRemoveUndoActionClass))
#define EASE_IS_SLIDE_REMOVE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_REMOVE_UNDO_ACTION))
#define EASE_IS_SLIDE_REMOVE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_REMOVE_UNDO_ACTION))
#define EASE_SLIDE_REMOVE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_REMOVE_UNDO_ACTION, EaseSlideRemoveUndoActionClass))

typedef struct _EaseSlideRemoveUndoAction EaseSlideRemoveUndoAction;
typedef struct _EaseSlideRemoveUndoActionClass EaseSlideRemoveUndoActionClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

struct _EaseDocument {
	GObject parent_instance;
	EaseDocumentPrivate * priv;
};

struct _EaseDocumentClass {
	GObjectClass parent_class;
};

struct _EaseDocumentPrivate {
	EaseTheme* _theme;
	gint _width;
	gint _height;
	char* _filename;
	char* _path;
	EaseIterableListStore* slides_priv;
};

struct _EaseIterableTreeModelIface {
	GTypeInterface parent_iface;
};

typedef void (*EaseRecursiveDirAction) (const char* path, const char* full_path, void* user_data, GError** error);
struct _Block6Data {
	int _ref_count_;
	EaseDocument * self;
	GeeLinkedList* files;
};


static gpointer ease_document_parent_class = NULL;
static EaseUndoSourceIface* ease_document_ease_undo_source_parent_iface = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_document_get_type (void) G_GNUC_CONST;
GType ease_theme_get_type (void) G_GNUC_CONST;
GType ease_iterable_list_store_get_type (void) G_GNUC_CONST;
#define EASE_DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_DOCUMENT, EaseDocumentPrivate))
enum  {
	EASE_DOCUMENT_DUMMY_PROPERTY,
	EASE_DOCUMENT_THEME,
	EASE_DOCUMENT_WIDTH,
	EASE_DOCUMENT_HEIGHT,
	EASE_DOCUMENT_ASPECT,
	EASE_DOCUMENT_FILENAME,
	EASE_DOCUMENT_PATH,
	EASE_DOCUMENT_SLIDES,
	EASE_DOCUMENT_LENGTH
};
#define EASE_DOCUMENT_MEDIA_PATH "Media"
#define EASE_DOCUMENT_JSON_FILE "Document.json"
#define EASE_THEME_CONTENT_HEADER "content-header"
#define EASE_DOCUMENT_DEFAULT_SLIDE EASE_THEME_CONTENT_HEADER
#define EASE_THEME_TITLE "title"
#define EASE_DOCUMENT_DEFAULT_FIRST EASE_THEME_TITLE
#define EASE_DOCUMENT_THEME_PATH "Theme"
#define EASE_DOCUMENT_MODEL_COLS 3
#define EASE_DOCUMENT_COL_SLIDE 0
#define EASE_DOCUMENT_COL_PIXBUF 1
#define EASE_DOCUMENT_COL_TITLE 2
#define EASE_DOCUMENT_COL_PIXBUF_DYNAMIC 3
#define EASE_DOCUMENT_DEFAULT_TITLE _ ("Slide %i")
EaseDocument* ease_document_new_from_saved (const char* file_path, GError** error);
EaseDocument* ease_document_construct_from_saved (GType object_type, const char* file_path, GError** error);
EaseDocument* ease_document_new (void);
EaseDocument* ease_document_construct (GType object_type);
char* ease_absolute_path (const char* path);
void ease_document_set_filename (EaseDocument* self, const char* value);
char* ease_archiver_extract (const char* filename, GError** error);
const char* ease_document_get_filename (EaseDocument* self);
void ease_document_set_path (EaseDocument* self, const char* value);
const char* ease_document_get_path (EaseDocument* self);
void ease_document_set_width (EaseDocument* self, gint value);
void ease_document_set_height (EaseDocument* self, gint value);
GType ease_slide_get_type (void) G_GNUC_CONST;
void ease_document_append_slide (EaseDocument* self, EaseSlide* s);
EaseSlide* ease_slide_new_from_json (JsonObject* obj, EaseDocument* owner);
EaseSlide* ease_slide_construct_from_json (GType object_type, JsonObject* obj, EaseDocument* owner);
#define EASE_THEME_JSON_PATH "Theme.json"
EaseTheme* ease_theme_new_json (const char* json_path);
EaseTheme* ease_theme_construct_json (GType object_type, const char* json_path);
void ease_document_set_theme (EaseDocument* self, EaseTheme* value);
EaseTheme* ease_document_get_theme (EaseDocument* self);
void ease_theme_set_path (EaseTheme* self, const char* value);
EaseDocument* ease_document_new_from_theme (EaseTheme* doc_theme, gint w, gint h, GError** error);
EaseDocument* ease_document_construct_from_theme (GType object_type, EaseTheme* doc_theme, gint w, gint h, GError** error);
char* ease_temp_request (GError** error);
EaseTheme* ease_theme_copy_to_path (EaseTheme* self, const char* copy_to, GError** error);
void ease_theme_copy_media (EaseTheme* self, const char* target, GError** error);
EaseSlide* ease_theme_create_slide (EaseTheme* self, const char* master, gint width, gint height);
gint ease_document_get_width (EaseDocument* self);
gint ease_document_get_height (EaseDocument* self);
void ease_slide_set_parent (EaseSlide* self, EaseDocument* value);
void ease_document_to_json (EaseDocument* self, GtkWindow* window, GError** error);
EaseIterableListStore* ease_document_get_slides (EaseDocument* self);
GType ease_iterable_tree_model_get_type (void) G_GNUC_CONST;
gpointer ease_iterable_tree_model_iterator_ref (gpointer instance);
void ease_iterable_tree_model_iterator_unref (gpointer instance);
GParamSpec* ease_iterable_tree_model_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ease_iterable_tree_model_value_set_iterator (GValue* value, gpointer v_object);
void ease_iterable_tree_model_value_take_iterator (GValue* value, gpointer v_object);
gpointer ease_iterable_tree_model_value_get_iterator (const GValue* value);
GType ease_iterable_tree_model_iterator_get_type (void) G_GNUC_CONST;
EaseIterableTreeModelIterator* ease_iterable_tree_model_iterator (EaseIterableTreeModel* self);
gboolean ease_iterable_tree_model_iterator_next (EaseIterableTreeModelIterator* self);
void ease_iterable_tree_model_iterator_get (EaseIterableTreeModelIterator* self, GtkTreeIter* result);
JsonNode* ease_slide_to_json (EaseSlide* self);
void ease_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error);
static void _lambda61_ (const char* path, const char* full_path, Block6Data* _data6_, GError** error);
static void __lambda61__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
GType ease_background_get_type (void) G_GNUC_CONST;
EaseBackground* ease_slide_get_background (EaseSlide* self);
GType ease_image_get_type (void) G_GNUC_CONST;
EaseImage* ease_background_get_image (EaseBackground* self);
const char* ease_image_get_filename (EaseImage* self);
gpointer ease_slide_iterator_ref (gpointer instance);
void ease_slide_iterator_unref (gpointer instance);
GParamSpec* ease_slide_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ease_slide_value_set_iterator (GValue* value, gpointer v_object);
void ease_slide_value_take_iterator (GValue* value, gpointer v_object);
gpointer ease_slide_value_get_iterator (const GValue* value);
GType ease_slide_iterator_get_type (void) G_GNUC_CONST;
EaseSlideIterator* ease_slide_iterator (EaseSlide* self);
gboolean ease_slide_iterator_next (EaseSlideIterator* self);
GType ease_element_get_type (void) G_GNUC_CONST;
EaseElement* ease_slide_iterator_get (EaseSlideIterator* self);
char** ease_element_claim_media (EaseElement* self, int* result_length1);
void ease_archiver_create (const char* temp_path, const char* filename, const char* title, GeeLinkedList* files, GtkWindow* win, GError** error);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
void ease_document_add_slide (EaseDocument* self, gint index, EaseSlide* slide);
void ease_document_add_slide_actual (EaseDocument* self, gint index, EaseSlide* slide, gboolean emit_undo);
gint ease_document_index_of (EaseDocument* self, EaseSlide* slide);
void ease_undo_source_listen (EaseUndoSource* self, EaseUndoSource* source);
void ease_document_on_title_changed (EaseDocument* self, EaseSlide* slide, const char* title);
static void _ease_document_on_title_changed_ease_slide_title_changed (EaseSlide* _sender, EaseSlide* _self_, const char* title, gpointer self);
void ease_document_on_title_reset (EaseDocument* self, EaseSlide* slide);
static void _ease_document_on_title_reset_ease_slide_title_reset (EaseSlide* _sender, EaseSlide* _self_, gpointer self);
static void ease_document_set_slide_titles (EaseDocument* self);
EaseSlideAddUndoAction* ease_slide_add_undo_action_new (EaseSlide* s);
EaseSlideAddUndoAction* ease_slide_add_undo_action_construct (GType object_type, EaseSlide* s);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
GType ease_slide_add_undo_action_get_type (void) G_GNUC_CONST;
gint ease_document_get_length (EaseDocument* self);
EaseSlide* ease_document_remove_slide (EaseDocument* self, EaseSlide* slide);
EaseSlide* ease_document_remove_slide_actual (EaseDocument* self, EaseSlide* slide, gboolean emit_undo);
EaseSlideRemoveUndoAction* ease_slide_remove_undo_action_new (EaseSlide* s);
EaseSlideRemoveUndoAction* ease_slide_remove_undo_action_construct (GType object_type, EaseSlide* s);
GType ease_slide_remove_undo_action_get_type (void) G_GNUC_CONST;
void ease_undo_source_silence (EaseUndoSource* self, EaseUndoSource* source);
gboolean ease_document_has_next_slide (EaseDocument* self, EaseSlide* slide);
EaseSlide* ease_document_get_slide (EaseDocument* self, gint index);
char* ease_slide_get_title (EaseSlide* self);
void ease_document_cairo_render (EaseDocument* self, cairo_surface_t* surface, GError** error);
void ease_slide_cairo_render (EaseSlide* self, cairo_t* context, GError** error);
void ease_document_export_as_pdf (EaseDocument* self, GtkWindow* win);
char* ease_dialog_save (const char* title, GtkWindow* modal);
void ease_error_dialog (const char* title, const char* message);
void ease_document_export_as_postscript (EaseDocument* self, GtkWindow* win);
void ease_document_export_as_html (EaseDocument* self, GtkWindow* window);
EaseHTMLExporter* ease_html_exporter_new (void);
EaseHTMLExporter* ease_html_exporter_construct (GType object_type);
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
gboolean ease_html_exporter_request_path (EaseHTMLExporter* self, GtkWindow* win);
#define EASE_HTML_EXPORTER_HEADER "<!DOCTYPE html>\n" \
"<html>\n" \
"<head>\n" \
"\t<title>Presentation</title>\n" \
"\t\n" \
"\t<script type=\"text/javascript\">\n" \
"\t\tvar slide = -1;\n" \
"\n" \
"\t\tfunction load() {\n" \
"\t\t\tadvance();\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction keydown(e) {\n" \
"\t\t\tvar code = e.keyCode;\n" \
"\t\t\tif (code == 32 || code == 39 || code == 13 || code == 40 || code" \
" == 39) {\n" \
"\t\t\t\tadvance();\n" \
"\t\t\t}\n" \
"\t\n" \
"\t\t\telse if (code == 8 || code == 46 || code == 37 || code == 38) {\n" \
"\t\t\t\tretreat();\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction advance() {\n" \
"\t\t\tif (document.getElementById(\"slide\" + (slide + 1)) != null) {\n" \
"\t\t\t\tif (slide >= 0) {\n" \
"\t\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"" \
"none\";\n" \
"\t\t\t\t}\n" \
"\t\t\t\tslide++;\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"b" \
"lock\";\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tfunction retreat() {\n" \
"\t\t\tif (slide > 0) {\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"n" \
"one\";\n" \
"\t\t\t\tslide--;\n" \
"\t\t\t\tdocument.getElementById(\"slide\" + slide).style.display = \"b" \
"lock\";\n" \
"\t\t\t}\n" \
"\t\t}\n" \
"\n" \
"\t\tdocument.onkeydown = keydown;\n" \
"\t</script>\n" \
"\t\n" \
"\t<style>\n" \
"\t\t.slide {\n" \
"\t\t\twidth: %ipx;\n" \
"\t\t\theight: %ipx;\n" \
"\t\t\tdisplay: none;\n" \
"\t\t\toverflow: hidden;\n" \
"\t\t\tposition: relative;\n" \
"\t\t\tmargin: 20px auto 20px auto;\n" \
"\t\t}\n" \
"\t\thtml {\n" \
"\t\t\tpadding: 0px;\n" \
"\t\t\tmargin: 0px;\n" \
"\t\t\tbackground-color: black;\n" \
"\t\t}\n" \
"\t</style>\n" \
"</head>\n" \
"<body onload=load()>\n"
void ease_slide_to_html (EaseSlide* self, char** html, EaseHTMLExporter* exporter, double amount, gint index);
gint ease_iterable_list_store_get_size (EaseIterableListStore* self);
const char* ease_html_exporter_get_path (EaseHTMLExporter* self);
void ease_html_exporter_finish (EaseHTMLExporter* self);
char* ease_document_add_media_file (EaseDocument* self, const char* file, GError** error);
float ease_document_get_aspect (EaseDocument* self);
EaseIterableListStore* ease_iterable_list_store_new (GType* types, int types_length1);
EaseIterableListStore* ease_iterable_list_store_construct (GType object_type, GType* types, int types_length1);
static void ease_document_finalize (GObject* obj);
static void ease_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


#line 145 "ease-document.vala"
EaseDocument* ease_document_construct_from_saved (GType object_type, const char* file_path, GError** error) {
#line 395 "ease-document.c"
	EaseDocument * self;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	JsonParser* parser;
	char* _tmp3_;
	JsonObject* root;
	JsonArray* json_slides;
	char* theme_path;
	char* theme_full_path;
	GFile* _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
#line 145 "ease-document.vala"
	g_return_val_if_fail (file_path != NULL, NULL);
#line 147 "ease-document.vala"
	self = (EaseDocument*) ease_document_construct (object_type);
#line 149 "ease-document.vala"
	ease_document_set_filename (self, _tmp0_ = ease_absolute_path (file_path));
#line 415 "ease-document.c"
	_g_free0 (_tmp0_);
#line 150 "ease-document.vala"
	_tmp1_ = ease_archiver_extract (self->priv->_filename, &_inner_error_);
#line 419 "ease-document.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 150 "ease-document.vala"
	ease_document_set_path (self, _tmp2_ = _tmp1_);
#line 427 "ease-document.c"
	_g_free0 (_tmp2_);
#line 152 "ease-document.vala"
	parser = json_parser_new ();
#line 155 "ease-document.vala"
	json_parser_load_from_file (parser, _tmp3_ = g_build_filename (self->priv->_path, EASE_DOCUMENT_JSON_FILE, NULL), &_inner_error_);
#line 433 "ease-document.c"
	_g_free0 (_tmp3_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (parser);
		_g_object_unref0 (self);
		return NULL;
	}
#line 158 "ease-document.vala"
	root = _json_object_ref0 (json_node_get_object (json_parser_get_root (parser)));
#line 161 "ease-document.vala"
	ease_document_set_width (self, (gint) atoi (json_object_get_string_member (root, "width")));
#line 162 "ease-document.vala"
	ease_document_set_height (self, (gint) atoi (json_object_get_string_member (root, "height")));
#line 165 "ease-document.vala"
	json_slides = _json_array_ref0 (json_object_get_array_member (root, "slides"));
#line 449 "ease-document.c"
	{
		gint i;
#line 167 "ease-document.vala"
		i = 0;
#line 454 "ease-document.c"
		{
			gboolean _tmp4_;
#line 167 "ease-document.vala"
			_tmp4_ = TRUE;
#line 167 "ease-document.vala"
			while (TRUE) {
#line 461 "ease-document.c"
				JsonObject* node;
				EaseSlide* _tmp5_;
#line 167 "ease-document.vala"
				if (!_tmp4_) {
#line 167 "ease-document.vala"
					i++;
#line 468 "ease-document.c"
				}
#line 167 "ease-document.vala"
				_tmp4_ = FALSE;
#line 167 "ease-document.vala"
				if (!(i < json_array_get_length (json_slides))) {
#line 167 "ease-document.vala"
					break;
#line 476 "ease-document.c"
				}
#line 169 "ease-document.vala"
				node = _json_object_ref0 (json_array_get_object_element (json_slides, (guint) i));
#line 170 "ease-document.vala"
				ease_document_append_slide (self, _tmp5_ = ease_slide_new_from_json (node, self));
#line 482 "ease-document.c"
				_g_object_unref0 (_tmp5_);
				_json_object_unref0 (node);
			}
		}
	}
#line 174 "ease-document.vala"
	theme_path = g_build_filename (EASE_DOCUMENT_THEME_PATH, EASE_THEME_JSON_PATH, NULL);
#line 175 "ease-document.vala"
	theme_full_path = g_build_filename (self->priv->_path, theme_path, NULL);
#line 177 "ease-document.vala"
	if ((_tmp7_ = g_file_query_exists (_tmp6_ = g_file_new_for_path (theme_full_path), NULL), _g_object_unref0 (_tmp6_), _tmp7_)) {
#line 494 "ease-document.c"
		EaseTheme* _tmp8_;
#line 179 "ease-document.vala"
		ease_document_set_theme (self, _tmp8_ = ease_theme_new_json (theme_full_path));
#line 498 "ease-document.c"
		_g_object_unref0 (_tmp8_);
#line 180 "ease-document.vala"
		ease_theme_set_path (self->priv->_theme, theme_full_path);
#line 502 "ease-document.c"
	}
	_g_free0 (theme_full_path);
	_g_free0 (theme_path);
	_json_array_unref0 (json_slides);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
	return self;
}


#line 145 "ease-document.vala"
EaseDocument* ease_document_new_from_saved (const char* file_path, GError** error) {
#line 145 "ease-document.vala"
	return ease_document_construct_from_saved (EASE_TYPE_DOCUMENT, file_path, error);
#line 517 "ease-document.c"
}


/**
 * Theme constructor, used for new documents.
 *
 * @param doc_theme The {@link Theme} for this Document.
 * @param w The width of the new Document.
 * @param h The height of the new Document.
 */
#line 191 "ease-document.vala"
EaseDocument* ease_document_construct_from_theme (GType object_type, EaseTheme* doc_theme, gint w, gint h, GError** error) {
#line 530 "ease-document.c"
	EaseDocument * self;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	EaseTheme* _tmp3_;
	EaseTheme* _tmp4_;
	EaseTheme* _tmp5_;
	EaseSlide* slide;
	GError * _inner_error_ = NULL;
#line 191 "ease-document.vala"
	g_return_val_if_fail (doc_theme != NULL, NULL);
#line 191 "ease-document.vala"
	self = (EaseDocument*) g_object_new (object_type, NULL);
#line 194 "ease-document.vala"
	g_assert (doc_theme != NULL);
#line 197 "ease-document.vala"
	ease_document_set_width (self, w);
#line 198 "ease-document.vala"
	ease_document_set_height (self, h);
#line 201 "ease-document.vala"
	_tmp0_ = ease_temp_request (&_inner_error_);
#line 552 "ease-document.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 201 "ease-document.vala"
	ease_document_set_path (self, _tmp1_ = _tmp0_);
#line 560 "ease-document.c"
	_g_free0 (_tmp1_);
#line 204 "ease-document.vala"
	_tmp4_ = (_tmp3_ = ease_theme_copy_to_path (doc_theme, _tmp2_ = g_build_filename (self->priv->_path, EASE_DOCUMENT_THEME_PATH, NULL), &_inner_error_), _g_free0 (_tmp2_), _tmp3_);
#line 564 "ease-document.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 204 "ease-document.vala"
	ease_document_set_theme (self, _tmp5_ = _tmp4_);
#line 572 "ease-document.c"
	_g_object_unref0 (_tmp5_);
#line 207 "ease-document.vala"
	ease_theme_copy_media (self->priv->_theme, self->priv->_path, &_inner_error_);
#line 576 "ease-document.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 210 "ease-document.vala"
	slide = ease_theme_create_slide (self->priv->_theme, EASE_DOCUMENT_DEFAULT_FIRST, self->priv->_width, self->priv->_height);
#line 211 "ease-document.vala"
	ease_slide_set_parent (slide, self);
#line 212 "ease-document.vala"
	ease_document_append_slide (self, slide);
#line 588 "ease-document.c"
	_g_object_unref0 (slide);
	return self;
}


#line 191 "ease-document.vala"
EaseDocument* ease_document_new_from_theme (EaseTheme* doc_theme, gint w, gint h, GError** error) {
#line 191 "ease-document.vala"
	return ease_document_construct_from_theme (EASE_TYPE_DOCUMENT, doc_theme, w, h, error);
#line 598 "ease-document.c"
}


#line 252 "ease-document.vala"
static void _lambda61_ (const char* path, const char* full_path, Block6Data* _data6_, GError** error) {
#line 604 "ease-document.c"
	EaseDocument * self;
	char* _tmp0_;
	self = _data6_->self;
#line 252 "ease-document.vala"
	g_return_if_fail (path != NULL);
#line 252 "ease-document.vala"
	g_return_if_fail (full_path != NULL);
#line 253 "ease-document.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->files, _tmp0_ = g_build_filename (EASE_DOCUMENT_THEME_PATH, path, NULL));
#line 614 "ease-document.c"
	_g_free0 (_tmp0_);
}


#line 252 "ease-document.vala"
static void __lambda61__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 621 "ease-document.c"
	_lambda61_ (path, full_path, self, error);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->files);
		g_slice_free (Block6Data, _data6_);
	}
}


#line 215 "ease-document.vala"
void ease_document_to_json (EaseDocument* self, GtkWindow* window, GError** error) {
#line 643 "ease-document.c"
	Block6Data* _data6_;
	JsonNode* root;
	JsonObject* obj;
	char* _tmp0_;
	char* _tmp1_;
	JsonArray* slides_json;
	EaseSlide* s;
	JsonGenerator* generator;
	char* _tmp3_;
	char* _tmp4_;
	EaseSlide* slide;
	gint claimed_length1;
	gint _claimed_size_;
	char** claimed;
	GError * _inner_error_ = NULL;
#line 215 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 661 "ease-document.c"
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
#line 218 "ease-document.vala"
	root = json_node_new (JSON_NODE_OBJECT);
#line 219 "ease-document.vala"
	obj = json_object_new ();
#line 222 "ease-document.vala"
	json_object_set_string_member (obj, "width", _tmp0_ = g_strdup_printf ("%i", self->priv->_width));
#line 671 "ease-document.c"
	_g_free0 (_tmp0_);
#line 223 "ease-document.vala"
	json_object_set_string_member (obj, "height", _tmp1_ = g_strdup_printf ("%i", self->priv->_height));
#line 675 "ease-document.c"
	_g_free0 (_tmp1_);
#line 226 "ease-document.vala"
	slides_json = json_array_new ();
#line 679 "ease-document.c"
	s = NULL;
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 228 "ease-document.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self));
#line 228 "ease-document.vala"
		while (TRUE) {
#line 687 "ease-document.c"
			GtkTreeIter _tmp2_ = {0};
			GtkTreeIter itr;
#line 228 "ease-document.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 228 "ease-document.vala"
				break;
#line 694 "ease-document.c"
			}
#line 228 "ease-document.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp2_), _tmp2_);
#line 230 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 231 "ease-document.vala"
			json_array_add_element (slides_json, ease_slide_to_json (s));
#line 702 "ease-document.c"
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
#line 233 "ease-document.vala"
	json_object_set_array_member (obj, "slides", _json_array_ref0 (slides_json));
#line 236 "ease-document.vala"
	json_node_set_object (root, obj);
#line 239 "ease-document.vala"
	generator = json_generator_new ();
#line 240 "ease-document.vala"
	json_generator_set_root (generator, root);
#line 241 "ease-document.vala"
	g_object_set (generator, "pretty", TRUE, NULL);
#line 242 "ease-document.vala"
	json_generator_to_file (generator, _tmp3_ = g_build_filename (self->priv->_path, EASE_DOCUMENT_JSON_FILE, NULL), &_inner_error_);
#line 718 "ease-document.c"
	_g_free0 (_tmp3_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (generator);
		_g_object_unref0 (s);
		_json_array_unref0 (slides_json);
		_json_object_unref0 (obj);
		_json_node_free0 (root);
		block6_data_unref (_data6_);
		return;
	}
	_data6_->files = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 248 "ease-document.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->files, EASE_DOCUMENT_JSON_FILE);
#line 251 "ease-document.vala"
	ease_recursive_directory (_tmp4_ = g_build_filename (self->priv->_path, EASE_DOCUMENT_THEME_PATH, NULL), NULL, NULL, __lambda61__ease_recursive_dir_action, _data6_, &_inner_error_);
#line 735 "ease-document.c"
	_g_free0 (_tmp4_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (generator);
		_g_object_unref0 (s);
		_json_array_unref0 (slides_json);
		_json_object_unref0 (obj);
		_json_node_free0 (root);
		block6_data_unref (_data6_);
		return;
	}
	slide = NULL;
	claimed = (claimed_length1 = 0, NULL);
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 259 "ease-document.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self));
#line 259 "ease-document.vala"
		while (TRUE) {
#line 755 "ease-document.c"
			GtkTreeIter _tmp5_ = {0};
			GtkTreeIter itr;
#line 259 "ease-document.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 259 "ease-document.vala"
				break;
#line 762 "ease-document.c"
			}
#line 259 "ease-document.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp5_), _tmp5_);
#line 261 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &slide, -1);
#line 264 "ease-document.vala"
			if (ease_image_get_filename (ease_background_get_image (ease_slide_get_background (slide))) != NULL) {
#line 266 "ease-document.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->files, ease_image_get_filename (ease_background_get_image (ease_slide_get_background (slide))));
#line 772 "ease-document.c"
			}
			{
				EaseSlideIterator* _element_it;
#line 270 "ease-document.vala"
				_element_it = ease_slide_iterator (slide);
#line 270 "ease-document.vala"
				while (TRUE) {
#line 780 "ease-document.c"
					EaseElement* element;
					gint _tmp6_;
					char** _tmp7_;
#line 270 "ease-document.vala"
					if (!ease_slide_iterator_next (_element_it)) {
#line 270 "ease-document.vala"
						break;
#line 788 "ease-document.c"
					}
#line 270 "ease-document.vala"
					element = ease_slide_iterator_get (_element_it);
#line 272 "ease-document.vala"
					claimed = (_tmp7_ = ease_element_claim_media (element, &_tmp6_), claimed = (_vala_array_free (claimed, claimed_length1, (GDestroyNotify) g_free), NULL), claimed_length1 = _tmp6_, _claimed_size_ = claimed_length1, _tmp7_);
#line 794 "ease-document.c"
					{
						char** str_collection;
						int str_collection_length1;
						int str_it;
#line 273 "ease-document.vala"
						str_collection = claimed;
#line 801 "ease-document.c"
						str_collection_length1 = claimed_length1;
						for (str_it = 0; str_it < claimed_length1; str_it = str_it + 1) {
							char* str;
							str = g_strdup (str_collection[str_it]);
							{
#line 273 "ease-document.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->files, str);
#line 809 "ease-document.c"
								_g_free0 (str);
							}
						}
					}
					_g_object_unref0 (element);
				}
				_ease_slide_iterator_unref0 (_element_it);
			}
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
#line 278 "ease-document.vala"
	ease_archiver_create (self->priv->_path, self->priv->_filename, _ ("Saving Document"), _data6_->files, window, &_inner_error_);
#line 823 "ease-document.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		claimed = (_vala_array_free (claimed, claimed_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (slide);
		_g_object_unref0 (generator);
		_g_object_unref0 (s);
		_json_array_unref0 (slides_json);
		_json_object_unref0 (obj);
		_json_node_free0 (root);
		block6_data_unref (_data6_);
		return;
	}
	claimed = (_vala_array_free (claimed, claimed_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (slide);
	_g_object_unref0 (generator);
	_g_object_unref0 (s);
	_json_array_unref0 (slides_json);
	_json_object_unref0 (obj);
	_json_node_free0 (root);
	block6_data_unref (_data6_);
}


/**
 * Inserts a new {@link Slide} into the Document
 *
 * @param slide The {@link Slide} to insert.
 * @param index The position of the new {@link Slide} in the Document.
 */
#line 287 "ease-document.vala"
void ease_document_add_slide (EaseDocument* self, gint index, EaseSlide* slide) {
#line 287 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 287 "ease-document.vala"
	g_return_if_fail (slide != NULL);
#line 289 "ease-document.vala"
	ease_document_add_slide_actual (self, index, slide, TRUE);
#line 861 "ease-document.c"
}


/**
 * Does the actual addition of a new Slide.
 */
#line 434 "ease-document.vala"
static void _ease_document_on_title_changed_ease_slide_title_changed (EaseSlide* _sender, EaseSlide* _self_, const char* title, gpointer self) {
#line 870 "ease-document.c"
	ease_document_on_title_changed (self, _self_, title);
}


#line 451 "ease-document.vala"
static void _ease_document_on_title_reset_ease_slide_title_reset (EaseSlide* _sender, EaseSlide* _self_, gpointer self) {
#line 877 "ease-document.c"
	ease_document_on_title_reset (self, _self_);
}


#line 295 "ease-document.vala"
void ease_document_add_slide_actual (EaseDocument* self, gint index, EaseSlide* slide, gboolean emit_undo) {
#line 884 "ease-document.c"
	GtkTreeIter itr = {0};
	char* _tmp0_;
#line 295 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 295 "ease-document.vala"
	g_return_if_fail (slide != NULL);
#line 297 "ease-document.vala"
	ease_slide_set_parent (slide, self);
#line 299 "ease-document.vala"
	gtk_list_store_insert ((GtkListStore*) ease_document_get_slides (self), &itr, index);
#line 300 "ease-document.vala"
	gtk_list_store_set ((GtkListStore*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, slide, -1);
#line 301 "ease-document.vala"
	gtk_list_store_set ((GtkListStore*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_TITLE, _tmp0_ = g_strdup_printf (EASE_DOCUMENT_DEFAULT_TITLE, ease_document_index_of (self, slide) + 1), -1);
#line 899 "ease-document.c"
	_g_free0 (_tmp0_);
#line 302 "ease-document.vala"
	g_signal_emit_by_name (self, "slide-added", slide, index);
#line 303 "ease-document.vala"
	ease_undo_source_listen ((EaseUndoSource*) self, (EaseUndoSource*) slide);
#line 305 "ease-document.vala"
	g_signal_connect_object (slide, "title-changed", (GCallback) _ease_document_on_title_changed_ease_slide_title_changed, self, 0);
#line 306 "ease-document.vala"
	g_signal_connect_object (slide, "title-reset", (GCallback) _ease_document_on_title_reset_ease_slide_title_reset, self, 0);
#line 308 "ease-document.vala"
	ease_document_set_slide_titles (self);
#line 310 "ease-document.vala"
	if (emit_undo) {
#line 913 "ease-document.c"
		EaseSlideAddUndoAction* _tmp1_;
#line 310 "ease-document.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp1_ = ease_slide_add_undo_action_new (slide)));
#line 917 "ease-document.c"
		_g_object_unref0 (_tmp1_);
	}
}


/**
 * {@inheritDoc}
 */
#line 316 "ease-document.vala"
void ease_document_append_slide (EaseDocument* self, EaseSlide* s) {
#line 316 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 316 "ease-document.vala"
	g_return_if_fail (s != NULL);
#line 318 "ease-document.vala"
	ease_document_add_slide (self, ease_document_get_length (self), s);
#line 934 "ease-document.c"
}


/**
 * Removes the specified {@link Slide}, returning an Slide that the editor
 * can safely jump to.
 *
 * @param slide The slide to remove.
 */
#line 327 "ease-document.vala"
EaseSlide* ease_document_remove_slide (EaseDocument* self, EaseSlide* slide) {
#line 946 "ease-document.c"
	EaseSlide* result = NULL;
#line 327 "ease-document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 327 "ease-document.vala"
	g_return_val_if_fail (slide != NULL, NULL);
#line 952 "ease-document.c"
	result = ease_document_remove_slide_actual (self, slide, TRUE);
#line 329 "ease-document.vala"
	return result;
#line 956 "ease-document.c"
}


/**
 * Actually removes a Slide.
 */
#line 335 "ease-document.vala"
EaseSlide* ease_document_remove_slide_actual (EaseDocument* self, EaseSlide* slide, gboolean emit_undo) {
#line 965 "ease-document.c"
	EaseSlide* result = NULL;
	guint _tmp1_;
	guint _tmp2_;
	EaseSlide* s;
	gint index;
	EaseSlide* ret;
	GtkTreeIter itr = {0};
#line 335 "ease-document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 335 "ease-document.vala"
	g_return_val_if_fail (slide != NULL, NULL);
#line 338 "ease-document.vala"
	if (emit_undo) {
#line 979 "ease-document.c"
		EaseSlideRemoveUndoAction* _tmp0_;
#line 338 "ease-document.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp0_ = ease_slide_remove_undo_action_new (slide)));
#line 983 "ease-document.c"
		_g_object_unref0 (_tmp0_);
	}
#line 341 "ease-document.vala"
	g_signal_parse_name ("title-changed", EASE_TYPE_SLIDE, &_tmp1_, NULL, FALSE);
#line 341 "ease-document.vala"
	g_signal_handlers_disconnect_matched (slide, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_document_on_title_changed_ease_slide_title_changed, self);
#line 342 "ease-document.vala"
	g_signal_parse_name ("title-reset", EASE_TYPE_SLIDE, &_tmp2_, NULL, FALSE);
#line 342 "ease-document.vala"
	g_signal_handlers_disconnect_matched (slide, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _ease_document_on_title_reset_ease_slide_title_reset, self);
#line 994 "ease-document.c"
	s = NULL;
#line 345 "ease-document.vala"
	index = 0;
#line 998 "ease-document.c"
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 346 "ease-document.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self));
#line 346 "ease-document.vala"
		while (TRUE) {
#line 1005 "ease-document.c"
			GtkTreeIter _tmp3_ = {0};
			GtkTreeIter itr;
#line 346 "ease-document.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 346 "ease-document.vala"
				break;
#line 1012 "ease-document.c"
			}
#line 346 "ease-document.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp3_), _tmp3_);
#line 348 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 349 "ease-document.vala"
			if (slide == s) {
#line 351 "ease-document.vala"
				gtk_list_store_remove ((GtkListStore*) ease_document_get_slides (self), &itr);
#line 352 "ease-document.vala"
				g_signal_emit_by_name (self, "slide-deleted", s, index);
#line 353 "ease-document.vala"
				ease_undo_source_silence ((EaseUndoSource*) self, (EaseUndoSource*) s);
#line 354 "ease-document.vala"
				break;
#line 1028 "ease-document.c"
			}
#line 356 "ease-document.vala"
			index++;
#line 1032 "ease-document.c"
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
#line 359 "ease-document.vala"
	ease_document_set_slide_titles (self);
#line 1038 "ease-document.c"
	ret = NULL;
#line 363 "ease-document.vala"
	gtk_tree_model_get_iter_first ((GtkTreeModel*) ease_document_get_slides (self), &itr);
#line 1042 "ease-document.c"
	{
		gint i;
#line 366 "ease-document.vala"
		i = 1;
#line 1047 "ease-document.c"
		{
			gboolean _tmp4_;
#line 366 "ease-document.vala"
			_tmp4_ = TRUE;
#line 366 "ease-document.vala"
			while (TRUE) {
#line 366 "ease-document.vala"
				if (!_tmp4_) {
#line 366 "ease-document.vala"
					i++;
#line 1058 "ease-document.c"
				}
#line 366 "ease-document.vala"
				_tmp4_ = FALSE;
#line 366 "ease-document.vala"
				if (!(i < index)) {
#line 366 "ease-document.vala"
					break;
#line 1066 "ease-document.c"
				}
#line 366 "ease-document.vala"
				gtk_tree_model_iter_next ((GtkTreeModel*) ease_document_get_slides (self), &itr);
#line 1070 "ease-document.c"
			}
		}
	}
#line 369 "ease-document.vala"
	gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &ret, -1);
#line 1076 "ease-document.c"
	result = ret;
	_g_object_unref0 (s);
#line 371 "ease-document.vala"
	return result;
#line 1081 "ease-document.c"
}


/**
 * Returns whether or not the Document has a {@link Slide} after the
 * passed in {@link Slide}.
 */
#line 378 "ease-document.vala"
gboolean ease_document_has_next_slide (EaseDocument* self, EaseSlide* slide) {
#line 1091 "ease-document.c"
	gboolean result = FALSE;
	EaseSlide* s;
	GtkTreeIter itr = {0};
#line 378 "ease-document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 378 "ease-document.vala"
	g_return_val_if_fail (slide != NULL, FALSE);
#line 1099 "ease-document.c"
	s = NULL;
#line 382 "ease-document.vala"
	if (!gtk_tree_model_get_iter_first ((GtkTreeModel*) ease_document_get_slides (self), &itr)) {
#line 1103 "ease-document.c"
		result = FALSE;
		_g_object_unref0 (s);
#line 382 "ease-document.vala"
		return result;
#line 1108 "ease-document.c"
	}
	{
		gboolean _tmp0_;
#line 384 "ease-document.vala"
		_tmp0_ = TRUE;
#line 384 "ease-document.vala"
		while (TRUE) {
#line 384 "ease-document.vala"
			if (!_tmp0_) {
#line 388 "ease-document.vala"
				if (!gtk_tree_model_iter_next ((GtkTreeModel*) ease_document_get_slides (self), &itr)) {
#line 388 "ease-document.vala"
					break;
#line 1122 "ease-document.c"
				}
			}
#line 384 "ease-document.vala"
			_tmp0_ = FALSE;
#line 386 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 387 "ease-document.vala"
			if (s == slide) {
#line 1131 "ease-document.c"
				result = gtk_tree_model_iter_next ((GtkTreeModel*) ease_document_get_slides (self), &itr);
				_g_object_unref0 (s);
#line 387 "ease-document.vala"
				return result;
#line 1136 "ease-document.c"
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (s);
#line 390 "ease-document.vala"
	return result;
#line 1144 "ease-document.c"
}


/**
 * Finds the index of the given slide, or returns -1 if it is not found.
 *
 * @param slide The {@link Slide} to find the index of.
 */
#line 398 "ease-document.vala"
gint ease_document_index_of (EaseDocument* self, EaseSlide* slide) {
#line 1155 "ease-document.c"
	gint result = 0;
	EaseSlide* s;
	gint i;
#line 398 "ease-document.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 398 "ease-document.vala"
	g_return_val_if_fail (slide != NULL, 0);
#line 1163 "ease-document.c"
	s = NULL;
#line 401 "ease-document.vala"
	i = 0;
#line 1167 "ease-document.c"
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 402 "ease-document.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self));
#line 402 "ease-document.vala"
		while (TRUE) {
#line 1174 "ease-document.c"
			GtkTreeIter _tmp0_ = {0};
			GtkTreeIter itr;
#line 402 "ease-document.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 402 "ease-document.vala"
				break;
#line 1181 "ease-document.c"
			}
#line 402 "ease-document.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp0_), _tmp0_);
#line 404 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 405 "ease-document.vala"
			if (s == slide) {
#line 1189 "ease-document.c"
				result = i;
				_ease_iterable_tree_model_iterator_unref0 (_itr_it);
				_g_object_unref0 (s);
#line 407 "ease-document.vala"
				return result;
#line 1195 "ease-document.c"
			}
#line 409 "ease-document.vala"
			i++;
#line 1199 "ease-document.c"
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
	result = -1;
	_g_object_unref0 (s);
#line 411 "ease-document.vala"
	return result;
#line 1207 "ease-document.c"
}


/**
 * Returns the Slide at the specified index.
 */
#line 417 "ease-document.vala"
EaseSlide* ease_document_get_slide (EaseDocument* self, gint index) {
#line 1216 "ease-document.c"
	EaseSlide* result = NULL;
	EaseSlide* ret;
	GtkTreeIter itr = {0};
#line 417 "ease-document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1222 "ease-document.c"
	ret = NULL;
#line 421 "ease-document.vala"
	gtk_tree_model_get_iter_first ((GtkTreeModel*) ease_document_get_slides (self), &itr);
#line 1226 "ease-document.c"
	{
		gint i;
#line 424 "ease-document.vala"
		i = 0;
#line 1231 "ease-document.c"
		{
			gboolean _tmp0_;
#line 424 "ease-document.vala"
			_tmp0_ = TRUE;
#line 424 "ease-document.vala"
			while (TRUE) {
#line 424 "ease-document.vala"
				if (!_tmp0_) {
#line 424 "ease-document.vala"
					i++;
#line 1242 "ease-document.c"
				}
#line 424 "ease-document.vala"
				_tmp0_ = FALSE;
#line 424 "ease-document.vala"
				if (!(i < index)) {
#line 424 "ease-document.vala"
					break;
#line 1250 "ease-document.c"
				}
#line 424 "ease-document.vala"
				gtk_tree_model_iter_next ((GtkTreeModel*) ease_document_get_slides (self), &itr);
#line 1254 "ease-document.c"
			}
		}
	}
#line 427 "ease-document.vala"
	gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &ret, -1);
#line 1260 "ease-document.c"
	result = ret;
#line 428 "ease-document.vala"
	return result;
#line 1264 "ease-document.c"
}


/**
 * Updates a slide's title.
 */
#line 434 "ease-document.vala"
void ease_document_on_title_changed (EaseDocument* self, EaseSlide* slide, const char* title) {
#line 1273 "ease-document.c"
	EaseSlide* s;
#line 434 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 434 "ease-document.vala"
	g_return_if_fail (slide != NULL);
#line 434 "ease-document.vala"
	g_return_if_fail (title != NULL);
#line 1281 "ease-document.c"
	s = NULL;
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 437 "ease-document.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self));
#line 437 "ease-document.vala"
		while (TRUE) {
#line 1289 "ease-document.c"
			GtkTreeIter _tmp0_ = {0};
			GtkTreeIter itr;
#line 437 "ease-document.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 437 "ease-document.vala"
				break;
#line 1296 "ease-document.c"
			}
#line 437 "ease-document.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp0_), _tmp0_);
#line 439 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 440 "ease-document.vala"
			if (s == slide) {
#line 442 "ease-document.vala"
				gtk_list_store_set ((GtkListStore*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_TITLE, title, -1);
#line 1306 "ease-document.c"
				_ease_iterable_tree_model_iterator_unref0 (_itr_it);
				_g_object_unref0 (s);
#line 443 "ease-document.vala"
				return;
#line 1311 "ease-document.c"
			}
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
	_g_object_unref0 (s);
}


/**
 * Resets a slide's title to the default.
 */
#line 451 "ease-document.vala"
void ease_document_on_title_reset (EaseDocument* self, EaseSlide* slide) {
#line 1325 "ease-document.c"
	EaseSlide* s;
#line 451 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 451 "ease-document.vala"
	g_return_if_fail (slide != NULL);
#line 1331 "ease-document.c"
	s = NULL;
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 454 "ease-document.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self));
#line 454 "ease-document.vala"
		while (TRUE) {
#line 1339 "ease-document.c"
			GtkTreeIter _tmp0_ = {0};
			GtkTreeIter itr;
#line 454 "ease-document.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 454 "ease-document.vala"
				break;
#line 1346 "ease-document.c"
			}
#line 454 "ease-document.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp0_), _tmp0_);
#line 456 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 457 "ease-document.vala"
			if (s == slide) {
#line 1354 "ease-document.c"
				char* _tmp1_;
#line 459 "ease-document.vala"
				gtk_list_store_set ((GtkListStore*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_TITLE, _tmp1_ = g_strdup_printf (EASE_DOCUMENT_DEFAULT_TITLE, ease_document_index_of (self, slide) + 1), -1);
#line 1358 "ease-document.c"
				_g_free0 (_tmp1_);
				_ease_iterable_tree_model_iterator_unref0 (_itr_it);
				_g_object_unref0 (s);
#line 461 "ease-document.vala"
				return;
#line 1364 "ease-document.c"
			}
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
	_g_object_unref0 (s);
}


/**
 * Sets all slide titles. Used when the slides model is rearranged, a new
 * slide is added, or a slide is removed.
 */
#line 470 "ease-document.vala"
static void ease_document_set_slide_titles (EaseDocument* self) {
#line 1379 "ease-document.c"
	EaseSlide* s;
	gint i;
#line 470 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 1384 "ease-document.c"
	s = NULL;
#line 473 "ease-document.vala"
	i = 1;
#line 1388 "ease-document.c"
	{
		EaseIterableTreeModelIterator* _itr_slide_it;
#line 474 "ease-document.vala"
		_itr_slide_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self));
#line 474 "ease-document.vala"
		while (TRUE) {
#line 1395 "ease-document.c"
			GtkTreeIter _tmp0_ = {0};
			GtkTreeIter itr_slide;
			EaseSlide* _tmp1_;
#line 474 "ease-document.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_slide_it)) {
#line 474 "ease-document.vala"
				break;
#line 1403 "ease-document.c"
			}
#line 474 "ease-document.vala"
			itr_slide = (ease_iterable_tree_model_iterator_get (_itr_slide_it, &_tmp0_), _tmp0_);
#line 476 "ease-document.vala"
			s = (_tmp1_ = NULL, _g_object_unref0 (s), _tmp1_);
#line 477 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr_slide, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 478 "ease-document.vala"
			if (s != NULL) {
#line 1413 "ease-document.c"
				char* title;
				char* _tmp2_;
#line 480 "ease-document.vala"
				title = ease_slide_get_title (s);
#line 1418 "ease-document.c"
				_tmp2_ = NULL;
#line 481 "ease-document.vala"
				if (title != NULL) {
#line 1422 "ease-document.c"
					char* _tmp3_;
#line 481 "ease-document.vala"
					_tmp2_ = (_tmp3_ = g_strdup (title), _g_free0 (_tmp2_), _tmp3_);
#line 1426 "ease-document.c"
				} else {
					char* _tmp4_;
#line 482 "ease-document.vala"
					_tmp2_ = (_tmp4_ = g_strdup_printf (EASE_DOCUMENT_DEFAULT_TITLE, i), _g_free0 (_tmp2_), _tmp4_);
#line 1431 "ease-document.c"
				}
#line 481 "ease-document.vala"
				gtk_list_store_set ((GtkListStore*) ease_document_get_slides (self), &itr_slide, EASE_DOCUMENT_COL_TITLE, _tmp2_, -1);
#line 1435 "ease-document.c"
				_g_free0 (_tmp2_);
				_g_free0 (title);
			}
#line 484 "ease-document.vala"
			i++;
#line 1441 "ease-document.c"
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_slide_it);
	}
	_g_object_unref0 (s);
}


/**
 * Renders this Document to a CairoSurface. Obviously, this only really
 * works with multi-page surfaces.
 *
 * @param surface The surface to render to.
 */
#line 494 "ease-document.vala"
void ease_document_cairo_render (EaseDocument* self, cairo_surface_t* surface, GError** error) {
#line 1457 "ease-document.c"
	cairo_t* context;
	EaseSlide* s;
	GError * _inner_error_ = NULL;
#line 494 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 494 "ease-document.vala"
	g_return_if_fail (surface != NULL);
#line 496 "ease-document.vala"
	context = cairo_create (surface);
#line 1467 "ease-document.c"
	s = NULL;
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 499 "ease-document.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self));
#line 499 "ease-document.vala"
		while (TRUE) {
#line 1475 "ease-document.c"
			GtkTreeIter _tmp0_ = {0};
			GtkTreeIter itr;
#line 499 "ease-document.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 499 "ease-document.vala"
				break;
#line 1482 "ease-document.c"
			}
#line 499 "ease-document.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp0_), _tmp0_);
#line 501 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 502 "ease-document.vala"
			ease_slide_cairo_render (s, context, &_inner_error_);
#line 1490 "ease-document.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_ease_iterable_tree_model_iterator_unref0 (_itr_it);
				_g_object_unref0 (s);
				_cairo_destroy0 (context);
				return;
			}
#line 503 "ease-document.vala"
			cairo_show_page (context);
#line 1500 "ease-document.c"
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
#line 506 "ease-document.vala"
	cairo_surface_flush (surface);
#line 507 "ease-document.vala"
	cairo_surface_finish (surface);
#line 1508 "ease-document.c"
	_g_object_unref0 (s);
	_cairo_destroy0 (context);
}


/**
 * Exports this Document as a PDF file.
 *
 * @param win The window that dialogs should be modal for.
 */
#line 515 "ease-document.vala"
void ease_document_export_as_pdf (EaseDocument* self, GtkWindow* win) {
#line 1521 "ease-document.c"
	char* path;
	GError * _inner_error_ = NULL;
#line 515 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 517 "ease-document.vala"
	path = ease_dialog_save (_ ("Export as PDF"), win);
#line 518 "ease-document.vala"
	if (path == NULL) {
#line 1530 "ease-document.c"
		_g_free0 (path);
#line 518 "ease-document.vala"
		return;
#line 1534 "ease-document.c"
	}
	{
		cairo_surface_t* _tmp0_;
#line 523 "ease-document.vala"
		ease_document_cairo_render (self, _tmp0_ = cairo_pdf_surface_create (path, (double) self->priv->_width, (double) self->priv->_height), &_inner_error_);
#line 1540 "ease-document.c"
		_cairo_surface_destroy0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 527 "ease-document.vala"
			ease_error_dialog (_ ("Error Exporting to PDF"), e->message);
#line 1555 "ease-document.c"
			_g_error_free0 (e);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (path);
}


/**
 * Exports this Document as a PostScript file.
 *
 * @param win The window that dialogs should be modal for.
 */
#line 536 "ease-document.vala"
void ease_document_export_as_postscript (EaseDocument* self, GtkWindow* win) {
#line 1577 "ease-document.c"
	char* path;
	GError * _inner_error_ = NULL;
#line 536 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 538 "ease-document.vala"
	path = ease_dialog_save (_ ("Export as PostScript"), win);
#line 539 "ease-document.vala"
	if (path == NULL) {
#line 1586 "ease-document.c"
		_g_free0 (path);
#line 539 "ease-document.vala"
		return;
#line 1590 "ease-document.c"
	}
	{
		cairo_surface_t* _tmp0_;
#line 544 "ease-document.vala"
		ease_document_cairo_render (self, _tmp0_ = cairo_ps_surface_create (path, (double) self->priv->_width, (double) self->priv->_height), &_inner_error_);
#line 1596 "ease-document.c"
		_cairo_surface_destroy0 (_tmp0_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 548 "ease-document.vala"
			ease_error_dialog (_ ("Error Exporting to PostScript"), e->message);
#line 1611 "ease-document.c"
			_g_error_free0 (e);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (path);
}


/**
 * Exports this Document to an HTML file.
 *
 * @param window The window that the progress dialog should be modal for.
 */
#line 557 "ease-document.vala"
void ease_document_export_as_html (EaseDocument* self, GtkWindow* window) {
#line 1633 "ease-document.c"
	EaseHTMLExporter* exporter;
	char* html;
	EaseSlide* slide;
	gint index;
	char* _tmp1_;
	GError * _inner_error_ = NULL;
#line 557 "ease-document.vala"
	g_return_if_fail (self != NULL);
#line 557 "ease-document.vala"
	g_return_if_fail (window != NULL);
#line 560 "ease-document.vala"
	exporter = ease_html_exporter_new ();
#line 562 "ease-document.vala"
	if (!ease_html_exporter_request_path (exporter, window)) {
#line 1648 "ease-document.c"
		_g_object_unref0 (exporter);
#line 564 "ease-document.vala"
		return;
#line 1652 "ease-document.c"
	}
#line 568 "ease-document.vala"
	html = g_strdup_printf (EASE_HTML_EXPORTER_HEADER, self->priv->_width, self->priv->_height);
#line 1656 "ease-document.c"
	slide = NULL;
#line 574 "ease-document.vala"
	index = 0;
#line 1660 "ease-document.c"
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 575 "ease-document.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self));
#line 575 "ease-document.vala"
		while (TRUE) {
#line 1667 "ease-document.c"
			GtkTreeIter _tmp0_ = {0};
			GtkTreeIter itr;
#line 575 "ease-document.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 575 "ease-document.vala"
				break;
#line 1674 "ease-document.c"
			}
#line 575 "ease-document.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp0_), _tmp0_);
#line 577 "ease-document.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self), &itr, EASE_DOCUMENT_COL_SLIDE, &slide, -1);
#line 578 "ease-document.vala"
			ease_slide_to_html (slide, &html, exporter, 1.0 / ease_iterable_list_store_get_size (ease_document_get_slides (self)), index);
#line 579 "ease-document.vala"
			index++;
#line 1684 "ease-document.c"
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
#line 583 "ease-document.vala"
	html = (_tmp1_ = g_strconcat (html, "\n</body>\n</html>\n", NULL), _g_free0 (html), _tmp1_);
#line 1690 "ease-document.c"
	{
		GFile* file;
		GFileOutputStream* stream;
		GDataOutputStream* data_stream;
#line 588 "ease-document.vala"
		file = g_file_new_for_path (ease_html_exporter_get_path (exporter));
#line 589 "ease-document.vala"
		stream = g_file_replace (file, NULL, TRUE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 1699 "ease-document.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch11_g_error;
		}
#line 590 "ease-document.vala"
		data_stream = g_data_output_stream_new ((GOutputStream*) stream);
#line 591 "ease-document.vala"
		g_data_output_stream_put_string (data_stream, html, NULL, &_inner_error_);
#line 1708 "ease-document.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (data_stream);
			_g_object_unref0 (stream);
			_g_object_unref0 (file);
			goto __catch11_g_error;
		}
		_g_object_unref0 (data_stream);
		_g_object_unref0 (stream);
		_g_object_unref0 (file);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 595 "ease-document.vala"
			ease_error_dialog (_ ("Error exporting as HTML"), e->message);
#line 1728 "ease-document.c"
			_g_error_free0 (e);
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (slide);
		_g_free0 (html);
		_g_object_unref0 (exporter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 598 "ease-document.vala"
	ease_html_exporter_finish (exporter);
#line 1743 "ease-document.c"
	_g_object_unref0 (slide);
	_g_free0 (html);
	_g_object_unref0 (exporter);
}


/**
 * Copies a media file to the temporary directory.
 *
 * Returns the path to the new file, as it should be stored in the
 * document when saved.
 *
 * @param file The path to the file that will be copied.
 */
#line 609 "ease-document.vala"
char* ease_document_add_media_file (EaseDocument* self, const char* file, GError** error) {
#line 1760 "ease-document.c"
	char* result = NULL;
	char* _tmp0_;
	GFile* _tmp1_;
	GFile* media;
	GFile* orig;
	char* _tmp2_;
	char* _tmp3_;
	char* rel_path;
	char* _tmp4_;
	GFile* _tmp5_;
	GFile* dest;
	GError * _inner_error_ = NULL;
#line 609 "ease-document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 609 "ease-document.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 612 "ease-document.vala"
	media = (_tmp1_ = g_file_new_for_path (_tmp0_ = g_build_filename (self->priv->_path, EASE_DOCUMENT_MEDIA_PATH, NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 613 "ease-document.vala"
	if (!g_file_query_exists (media, NULL)) {
#line 613 "ease-document.vala"
		g_file_make_directory_with_parents (media, NULL, &_inner_error_);
#line 1783 "ease-document.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (media);
			return NULL;
		}
	}
#line 616 "ease-document.vala"
	orig = g_file_new_for_path (file);
#line 617 "ease-document.vala"
	rel_path = (_tmp3_ = g_build_filename (EASE_DOCUMENT_MEDIA_PATH, _tmp2_ = g_file_get_basename (orig), NULL), _g_free0 (_tmp2_), _tmp3_);
#line 618 "ease-document.vala"
	dest = (_tmp5_ = g_file_new_for_path (_tmp4_ = g_build_filename (self->priv->_path, rel_path, NULL)), _g_free0 (_tmp4_), _tmp5_);
#line 1796 "ease-document.c"
	{
		gint i;
#line 621 "ease-document.vala"
		i = 0;
#line 1801 "ease-document.c"
		{
			gboolean _tmp6_;
#line 621 "ease-document.vala"
			_tmp6_ = TRUE;
#line 621 "ease-document.vala"
			while (TRUE) {
#line 1808 "ease-document.c"
				char* _tmp7_;
				char* _tmp8_;
				char* _tmp9_;
				char* _tmp10_;
				char* _tmp11_;
				char* _tmp12_;
				GFile* _tmp13_;
#line 621 "ease-document.vala"
				if (!_tmp6_) {
#line 621 "ease-document.vala"
					i++;
#line 1820 "ease-document.c"
				}
#line 621 "ease-document.vala"
				_tmp6_ = FALSE;
#line 621 "ease-document.vala"
				if (!g_file_query_exists (dest, NULL)) {
#line 621 "ease-document.vala"
					break;
#line 1828 "ease-document.c"
				}
#line 623 "ease-document.vala"
				rel_path = (_tmp11_ = g_build_filename (EASE_DOCUMENT_MEDIA_PATH, _tmp10_ = g_strconcat (_tmp8_ = g_strconcat (_tmp7_ = g_strdup_printf ("%i", i), "-", NULL), _tmp9_ = g_file_get_basename (orig), NULL), NULL), _g_free0 (rel_path), _tmp11_);
#line 1832 "ease-document.c"
				_g_free0 (_tmp10_);
				_g_free0 (_tmp9_);
				_g_free0 (_tmp8_);
				_g_free0 (_tmp7_);
#line 625 "ease-document.vala"
				dest = (_tmp13_ = g_file_new_for_path (_tmp12_ = g_build_filename (self->priv->_path, rel_path, NULL)), _g_object_unref0 (dest), _tmp13_);
#line 1839 "ease-document.c"
				_g_free0 (_tmp12_);
			}
		}
	}
#line 629 "ease-document.vala"
	g_file_copy (orig, dest, 0, NULL, NULL, NULL, &_inner_error_);
#line 1846 "ease-document.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dest);
		_g_free0 (rel_path);
		_g_object_unref0 (orig);
		_g_object_unref0 (media);
		return NULL;
	}
	result = rel_path;
	_g_object_unref0 (dest);
	_g_object_unref0 (orig);
	_g_object_unref0 (media);
#line 630 "ease-document.vala"
	return result;
#line 1861 "ease-document.c"
}


#line 24 "ease-document.vala"
EaseDocument* ease_document_construct (GType object_type) {
#line 1867 "ease-document.c"
	EaseDocument * self;
#line 24 "ease-document.vala"
	self = (EaseDocument*) g_object_new (object_type, NULL);
#line 1871 "ease-document.c"
	return self;
}


#line 24 "ease-document.vala"
EaseDocument* ease_document_new (void) {
#line 24 "ease-document.vala"
	return ease_document_construct (EASE_TYPE_DOCUMENT);
#line 1880 "ease-document.c"
}


EaseTheme* ease_document_get_theme (EaseDocument* self) {
	EaseTheme* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_theme;
#line 85 "ease-document.vala"
	return result;
#line 1890 "ease-document.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void ease_document_set_theme (EaseDocument* self, EaseTheme* value) {
	EaseTheme* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_theme = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_theme), _tmp0_);
	g_object_notify ((GObject *) self, "theme");
}


gint ease_document_get_width (EaseDocument* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
#line 90 "ease-document.vala"
	return result;
#line 1913 "ease-document.c"
}


void ease_document_set_width (EaseDocument* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_width = value;
	g_object_notify ((GObject *) self, "width");
}


gint ease_document_get_height (EaseDocument* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_height;
#line 95 "ease-document.vala"
	return result;
#line 1930 "ease-document.c"
}


void ease_document_set_height (EaseDocument* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_height = value;
	g_object_notify ((GObject *) self, "height");
}


float ease_document_get_aspect (EaseDocument* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = ((float) self->priv->_width) / ((float) self->priv->_height);
#line 100 "ease-document.vala"
	return result;
#line 1947 "ease-document.c"
}


const char* ease_document_get_filename (EaseDocument* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
#line 106 "ease-document.vala"
	return result;
#line 1957 "ease-document.c"
}


void ease_document_set_filename (EaseDocument* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_filename), _tmp0_);
	g_object_notify ((GObject *) self, "filename");
}


const char* ease_document_get_path (EaseDocument* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_path;
#line 111 "ease-document.vala"
	return result;
#line 1975 "ease-document.c"
}


void ease_document_set_path (EaseDocument* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_path), _tmp0_);
	g_object_notify ((GObject *) self, "path");
}


EaseIterableListStore* ease_document_get_slides (EaseDocument* self) {
	EaseIterableListStore* result;
	GType* _tmp0_ = NULL;
	GType* _tmp1_;
	gint _tmp1__length1;
	EaseIterableListStore* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
#line 120 "ease-document.vala"
	if (self->priv->slides_priv != NULL) {
#line 1996 "ease-document.c"
		result = self->priv->slides_priv;
#line 120 "ease-document.vala"
		return result;
#line 2000 "ease-document.c"
	}
#line 121 "ease-document.vala"
	self->priv->slides_priv = (_tmp2_ = ease_iterable_list_store_new ((_tmp1_ = (_tmp0_ = g_new0 (GType, 4), _tmp0_[0] = EASE_TYPE_SLIDE, _tmp0_[1] = GDK_TYPE_PIXBUF, _tmp0_[2] = G_TYPE_STRING, _tmp0_[3] = GDK_TYPE_PIXBUF, _tmp0_), _tmp1__length1 = 4, _tmp1_), 4), _g_object_unref0 (self->priv->slides_priv), _tmp2_);
#line 2004 "ease-document.c"
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = self->priv->slides_priv;
#line 125 "ease-document.vala"
	return result;
#line 2009 "ease-document.c"
}


gint ease_document_get_length (EaseDocument* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ease_iterable_list_store_get_size (ease_document_get_slides (self));
#line 133 "ease-document.vala"
	return result;
#line 2019 "ease-document.c"
}


static void ease_document_class_init (EaseDocumentClass * klass) {
	ease_document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseDocumentPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_document_finalize;
	/**
	 * The {@link Theme} linked to this Document.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_DOCUMENT_THEME, g_param_spec_object ("theme", "theme", "theme", EASE_TYPE_THEME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The width of the Document, in pixels.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_DOCUMENT_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The height of the Document, in pixels.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_DOCUMENT_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The aspect ratio of the Document.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_DOCUMENT_ASPECT, g_param_spec_float ("aspect", "aspect", "aspect", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The filename of the of the Document when archived. Typically, this is a
	 * .ease or .easetheme file.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_DOCUMENT_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The file path of the Document (extracted).
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_DOCUMENT_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * All {@link Slide}s in this Document.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_DOCUMENT_SLIDES, g_param_spec_object ("slides", "slides", "slides", EASE_TYPE_ITERABLE_LIST_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The number of {@link Slide}s in the Document.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_DOCUMENT_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Emitted when a {@link Slide} is deleted from the Document.
	 */
	g_signal_new ("slide_deleted", EASE_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT, G_TYPE_NONE, 2, EASE_TYPE_SLIDE, G_TYPE_INT);
	/**
	 * Emitted when a {@link Slide} is added to the Document.
	 */
	g_signal_new ("slide_added", EASE_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT, G_TYPE_NONE, 2, EASE_TYPE_SLIDE, G_TYPE_INT);
}


static void ease_document_ease_undo_source_interface_init (EaseUndoSourceIface * iface) {
	ease_document_ease_undo_source_parent_iface = g_type_interface_peek_parent (iface);
}


static void ease_document_instance_init (EaseDocument * self) {
	self->priv = EASE_DOCUMENT_GET_PRIVATE (self);
}


static void ease_document_finalize (GObject* obj) {
	EaseDocument * self;
	self = EASE_DOCUMENT (obj);
	_g_object_unref0 (self->priv->_theme);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_path);
	_g_object_unref0 (self->priv->slides_priv);
	G_OBJECT_CLASS (ease_document_parent_class)->finalize (obj);
}


/**
 * The internal representation of Ease documents. Contains {@link Slide}s.
 *
 * The Ease Document class is generated from JSON and writes back to JSON
 * when saved.
 */
GType ease_document_get_type (void) {
	static volatile gsize ease_document_type_id__volatile = 0;
	if (g_once_init_enter (&ease_document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseDocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseDocument), 0, (GInstanceInitFunc) ease_document_instance_init, NULL };
		static const GInterfaceInfo ease_undo_source_info = { (GInterfaceInitFunc) ease_document_ease_undo_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType ease_document_type_id;
		ease_document_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseDocument", &g_define_type_info, 0);
		g_type_add_interface_static (ease_document_type_id, EASE_TYPE_UNDO_SOURCE, &ease_undo_source_info);
		g_once_init_leave (&ease_document_type_id__volatile, ease_document_type_id);
	}
	return ease_document_type_id__volatile;
}


static void ease_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseDocument * self;
	self = EASE_DOCUMENT (object);
	switch (property_id) {
		case EASE_DOCUMENT_THEME:
		g_value_set_object (value, ease_document_get_theme (self));
		break;
		case EASE_DOCUMENT_WIDTH:
		g_value_set_int (value, ease_document_get_width (self));
		break;
		case EASE_DOCUMENT_HEIGHT:
		g_value_set_int (value, ease_document_get_height (self));
		break;
		case EASE_DOCUMENT_ASPECT:
		g_value_set_float (value, ease_document_get_aspect (self));
		break;
		case EASE_DOCUMENT_FILENAME:
		g_value_set_string (value, ease_document_get_filename (self));
		break;
		case EASE_DOCUMENT_PATH:
		g_value_set_string (value, ease_document_get_path (self));
		break;
		case EASE_DOCUMENT_SLIDES:
		g_value_set_object (value, ease_document_get_slides (self));
		break;
		case EASE_DOCUMENT_LENGTH:
		g_value_set_int (value, ease_document_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseDocument * self;
	self = EASE_DOCUMENT (object);
	switch (property_id) {
		case EASE_DOCUMENT_THEME:
		ease_document_set_theme (self, g_value_get_object (value));
		break;
		case EASE_DOCUMENT_WIDTH:
		ease_document_set_width (self, g_value_get_int (value));
		break;
		case EASE_DOCUMENT_HEIGHT:
		ease_document_set_height (self, g_value_get_int (value));
		break;
		case EASE_DOCUMENT_FILENAME:
		ease_document_set_filename (self, g_value_get_string (value));
		break;
		case EASE_DOCUMENT_PATH:
		ease_document_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



static void g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_int (param_values + 2), data2);
}



