/* ease-gradient.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-gradient.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>


#define EASE_TYPE_GRADIENT (ease_gradient_get_type ())
#define EASE_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_GRADIENT, EaseGradient))
#define EASE_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_GRADIENT, EaseGradientClass))
#define EASE_IS_GRADIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_GRADIENT))
#define EASE_IS_GRADIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_GRADIENT))
#define EASE_GRADIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_GRADIENT, EaseGradientClass))

typedef struct _EaseGradient EaseGradient;
typedef struct _EaseGradientClass EaseGradientClass;
typedef struct _EaseGradientPrivate EaseGradientPrivate;

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;

#define EASE_TYPE_GRADIENT_TYPE (ease_gradient_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

struct _EaseGradient {
	GObject parent_instance;
	EaseGradientPrivate * priv;
};

struct _EaseGradientClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_GRADIENT_TYPE_LINEAR,
	EASE_GRADIENT_TYPE_LINEAR_MIRRORED,
	EASE_GRADIENT_TYPE_RADIAL
} EaseGradientType;

struct _EaseGradientPrivate {
	EaseColor* _start;
	EaseColor* _end;
	EaseGradientType _mode;
	double _angle;
};


static gpointer ease_gradient_parent_class = NULL;

GType ease_gradient_get_type (void) G_GNUC_CONST;
GType ease_color_get_type (void) G_GNUC_CONST;
GType ease_gradient_type_get_type (void) G_GNUC_CONST;
#define EASE_GRADIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_GRADIENT, EaseGradientPrivate))
enum  {
	EASE_GRADIENT_DUMMY_PROPERTY,
	EASE_GRADIENT_START,
	EASE_GRADIENT_END,
	EASE_GRADIENT_MODE,
	EASE_GRADIENT_ANGLE
};
EaseColor* ease_color_get_white (void);
EaseColor* ease_color_get_black (void);
#define EASE_GRADIENT_STR "%s|%s|%s|%f"
#define EASE_GRADIENT_SPLIT "|"
EaseGradient* ease_gradient_new (EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_construct (GType object_type, EaseColor* start_color, EaseColor* end_color);
void ease_gradient_set_start (EaseGradient* self, EaseColor* value);
void ease_gradient_set_end (EaseGradient* self, EaseColor* value);
void ease_gradient_set_mode (EaseGradient* self, EaseGradientType value);
void ease_gradient_set_angle (EaseGradient* self, double value);
EaseGradient* ease_gradient_new_mirrored (EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_construct_mirrored (GType object_type, EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_new_radial (EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_construct_radial (GType object_type, EaseColor* start_color, EaseColor* end_color);
EaseGradient* ease_gradient_new_from_string (const char* str);
EaseGradient* ease_gradient_construct_from_string (GType object_type, const char* str);
EaseColor* ease_color_new_from_string (const char* str);
EaseColor* ease_color_construct_from_string (GType object_type, const char* str);
EaseGradientType ease_gradient_type_from_string (const char* str);
char* ease_gradient_to_string (EaseGradient* self);
EaseColor* ease_gradient_get_start (EaseGradient* self);
char* ease_color_to_string (EaseColor* self);
EaseColor* ease_gradient_get_end (EaseGradient* self);
EaseGradientType ease_gradient_get_mode (EaseGradient* self);
char* ease_gradient_type_to_string (EaseGradientType self);
double ease_gradient_get_angle (EaseGradient* self);
EaseGradient* ease_gradient_copy (EaseGradient* self);
EaseColor* ease_color_copy (EaseColor* self);
void ease_gradient_flip (EaseGradient* self);
void ease_gradient_cairo_render_rect (EaseGradient* self, cairo_t* cr, gint width, gint height);
void ease_gradient_set_cairo (EaseGradient* self, cairo_t* cr, gint width, gint height);
double ease_color_get_red (EaseColor* self);
double ease_color_get_green (EaseColor* self);
double ease_color_get_blue (EaseColor* self);
double ease_color_get_alpha (EaseColor* self);
EaseGradient* ease_gradient_get_default_background (void);
static void ease_gradient_finalize (GObject* obj);
static void ease_gradient_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_gradient_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define EASE_THEME_GRAD_LINEAR "linear"
#define EASE_THEME_GRAD_LINEAR_MIRRORED "linear-mirrored"
#define EASE_THEME_GRAD_RADIAL "radial"
char* ease_gradient_type_description (EaseGradientType self);
GtkListStore* ease_gradient_type_list_store (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



/**
 * Creates a new linear gradient, with the specified colors.
 */
#line 64 "ease-gradient.vala"
EaseGradient* ease_gradient_construct (GType object_type, EaseColor* start_color, EaseColor* end_color) {
#line 152 "ease-gradient.c"
	EaseGradient * self;
#line 64 "ease-gradient.vala"
	g_return_val_if_fail (start_color != NULL, NULL);
#line 64 "ease-gradient.vala"
	g_return_val_if_fail (end_color != NULL, NULL);
#line 64 "ease-gradient.vala"
	self = (EaseGradient*) g_object_new (object_type, NULL);
#line 66 "ease-gradient.vala"
	ease_gradient_set_start (self, start_color);
#line 67 "ease-gradient.vala"
	ease_gradient_set_end (self, end_color);
#line 68 "ease-gradient.vala"
	ease_gradient_set_mode (self, EASE_GRADIENT_TYPE_LINEAR);
#line 69 "ease-gradient.vala"
	ease_gradient_set_angle (self, (double) 0);
#line 168 "ease-gradient.c"
	return self;
}


#line 64 "ease-gradient.vala"
EaseGradient* ease_gradient_new (EaseColor* start_color, EaseColor* end_color) {
#line 64 "ease-gradient.vala"
	return ease_gradient_construct (EASE_TYPE_GRADIENT, start_color, end_color);
#line 177 "ease-gradient.c"
}


/**
 * Creates a new mirrored linear gradient, with the specified colors.
 */
#line 75 "ease-gradient.vala"
EaseGradient* ease_gradient_construct_mirrored (GType object_type, EaseColor* start_color, EaseColor* end_color) {
#line 186 "ease-gradient.c"
	EaseGradient * self;
#line 75 "ease-gradient.vala"
	g_return_val_if_fail (start_color != NULL, NULL);
#line 75 "ease-gradient.vala"
	g_return_val_if_fail (end_color != NULL, NULL);
#line 77 "ease-gradient.vala"
	self = (EaseGradient*) ease_gradient_construct (object_type, start_color, end_color);
#line 78 "ease-gradient.vala"
	ease_gradient_set_mode (self, EASE_GRADIENT_TYPE_LINEAR_MIRRORED);
#line 79 "ease-gradient.vala"
	ease_gradient_set_angle (self, (double) 0);
#line 198 "ease-gradient.c"
	return self;
}


#line 75 "ease-gradient.vala"
EaseGradient* ease_gradient_new_mirrored (EaseColor* start_color, EaseColor* end_color) {
#line 75 "ease-gradient.vala"
	return ease_gradient_construct_mirrored (EASE_TYPE_GRADIENT, start_color, end_color);
#line 207 "ease-gradient.c"
}


/**
 * Creates a new linear gradient, with the specified colors.
 */
#line 85 "ease-gradient.vala"
EaseGradient* ease_gradient_construct_radial (GType object_type, EaseColor* start_color, EaseColor* end_color) {
#line 216 "ease-gradient.c"
	EaseGradient * self;
#line 85 "ease-gradient.vala"
	g_return_val_if_fail (start_color != NULL, NULL);
#line 85 "ease-gradient.vala"
	g_return_val_if_fail (end_color != NULL, NULL);
#line 87 "ease-gradient.vala"
	self = (EaseGradient*) ease_gradient_construct (object_type, start_color, end_color);
#line 88 "ease-gradient.vala"
	ease_gradient_set_mode (self, EASE_GRADIENT_TYPE_RADIAL);
#line 89 "ease-gradient.vala"
	ease_gradient_set_angle (self, (double) 0);
#line 228 "ease-gradient.c"
	return self;
}


#line 85 "ease-gradient.vala"
EaseGradient* ease_gradient_new_radial (EaseColor* start_color, EaseColor* end_color) {
#line 85 "ease-gradient.vala"
	return ease_gradient_construct_radial (EASE_TYPE_GRADIENT, start_color, end_color);
#line 237 "ease-gradient.c"
}


/**
 * Creates a Gradient from a string representation.
 */
#line 1157 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 246 "ease-gradient.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 255 "ease-gradient.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1159 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 263 "ease-gradient.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch12_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1160 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 274 "ease-gradient.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch12_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1160 "glib-2.0.vapi"
		return result;
#line 289 "ease-gradient.c"
	}
	goto __finally12;
	__catch12_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1162 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 300 "ease-gradient.c"
			_g_error_free0 (e);
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 95 "ease-gradient.vala"
EaseGradient* ease_gradient_construct_from_string (GType object_type, const char* str) {
#line 315 "ease-gradient.c"
	EaseGradient * self;
	gint split_length1;
	gint _split_size_;
	char** _tmp3_;
	char* _tmp0_;
	char** _tmp1_;
	char** _tmp2_;
	char** split;
	EaseColor* _tmp4_;
	EaseColor* _tmp5_;
#line 95 "ease-gradient.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 95 "ease-gradient.vala"
	self = (EaseGradient*) g_object_new (object_type, NULL);
#line 330 "ease-gradient.c"
	split = (_tmp3_ = (_tmp2_ = _tmp1_ = g_strsplit (_tmp0_ = string_replace (str, " ", ""), EASE_GRADIENT_SPLIT, 0), _g_free0 (_tmp0_), _tmp2_), split_length1 = _vala_array_length (_tmp1_), _split_size_ = split_length1, _tmp3_);
#line 98 "ease-gradient.vala"
	ease_gradient_set_start (self, _tmp4_ = ease_color_new_from_string (split[0]));
#line 334 "ease-gradient.c"
	_g_object_unref0 (_tmp4_);
#line 99 "ease-gradient.vala"
	ease_gradient_set_end (self, _tmp5_ = ease_color_new_from_string (split[1]));
#line 338 "ease-gradient.c"
	_g_object_unref0 (_tmp5_);
#line 100 "ease-gradient.vala"
	ease_gradient_set_mode (self, ease_gradient_type_from_string (split[2]));
#line 101 "ease-gradient.vala"
	ease_gradient_set_angle (self, g_ascii_strtod (split[3], NULL));
#line 344 "ease-gradient.c"
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


#line 95 "ease-gradient.vala"
EaseGradient* ease_gradient_new_from_string (const char* str) {
#line 95 "ease-gradient.vala"
	return ease_gradient_construct_from_string (EASE_TYPE_GRADIENT, str);
#line 354 "ease-gradient.c"
}


/**
 * Returns a string representation of this Gradient.
 */
#line 107 "ease-gradient.vala"
char* ease_gradient_to_string (EaseGradient* self) {
#line 363 "ease-gradient.c"
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
#line 107 "ease-gradient.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 371 "ease-gradient.c"
	result = (_tmp3_ = g_strdup_printf (EASE_GRADIENT_STR, _tmp0_ = ease_color_to_string (self->priv->_start), _tmp1_ = ease_color_to_string (self->priv->_end), _tmp2_ = ease_gradient_type_to_string (self->priv->_mode), self->priv->_angle), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp3_);
#line 109 "ease-gradient.vala"
	return result;
#line 375 "ease-gradient.c"
}


/**
 * Returns a copy of this Gradient.
 */
#line 116 "ease-gradient.vala"
EaseGradient* ease_gradient_copy (EaseGradient* self) {
#line 384 "ease-gradient.c"
	EaseGradient* result = NULL;
	EaseColor* _tmp0_;
	EaseColor* _tmp1_;
	EaseGradient* _tmp2_;
	EaseGradient* grad;
#line 116 "ease-gradient.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "ease-gradient.vala"
	grad = (_tmp2_ = ease_gradient_new (_tmp0_ = ease_color_copy (self->priv->_start), _tmp1_ = ease_color_copy (self->priv->_end)), _g_object_unref0 (_tmp1_), _g_object_unref0 (_tmp0_), _tmp2_);
#line 119 "ease-gradient.vala"
	ease_gradient_set_mode (grad, self->priv->_mode);
#line 120 "ease-gradient.vala"
	ease_gradient_set_angle (grad, self->priv->_angle);
#line 398 "ease-gradient.c"
	result = grad;
#line 121 "ease-gradient.vala"
	return result;
#line 402 "ease-gradient.c"
}


/**
 * Reverses the Gradient.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 127 "ease-gradient.vala"
void ease_gradient_flip (EaseGradient* self) {
#line 416 "ease-gradient.c"
	EaseColor* temp;
#line 127 "ease-gradient.vala"
	g_return_if_fail (self != NULL);
#line 129 "ease-gradient.vala"
	temp = _g_object_ref0 (self->priv->_end);
#line 130 "ease-gradient.vala"
	ease_gradient_set_end (self, self->priv->_start);
#line 131 "ease-gradient.vala"
	ease_gradient_set_start (self, temp);
#line 426 "ease-gradient.c"
	_g_object_unref0 (temp);
}


/**
 * Renders the gradient to the given Cairo context at the specified size.
 *
 * @param cr The Cairo context to render to.
 * @param width The width of the rendered rectangle.
 * @param height The height of the rendered rectangle.
 */
#line 141 "ease-gradient.vala"
void ease_gradient_cairo_render_rect (EaseGradient* self, cairo_t* cr, gint width, gint height) {
#line 141 "ease-gradient.vala"
	g_return_if_fail (self != NULL);
#line 141 "ease-gradient.vala"
	g_return_if_fail (cr != NULL);
#line 143 "ease-gradient.vala"
	cairo_save (cr);
#line 144 "ease-gradient.vala"
	cairo_rectangle (cr, (double) 0, (double) 0, (double) width, (double) height);
#line 145 "ease-gradient.vala"
	ease_gradient_set_cairo (self, cr, width, height);
#line 146 "ease-gradient.vala"
	cairo_fill (cr);
#line 147 "ease-gradient.vala"
	cairo_restore (cr);
#line 454 "ease-gradient.c"
}


/**
 * Sets a CairoContext's source to this gradient.
 */
#line 153 "ease-gradient.vala"
void ease_gradient_set_cairo (EaseGradient* self, cairo_t* cr, gint width, gint height) {
#line 463 "ease-gradient.c"
	gint x_orig;
	gint y_orig;
	gint dist_x;
	gint dist_y;
	cairo_pattern_t* pattern;
#line 153 "ease-gradient.vala"
	g_return_if_fail (self != NULL);
#line 153 "ease-gradient.vala"
	g_return_if_fail (cr != NULL);
#line 155 "ease-gradient.vala"
	x_orig = width / 2;
#line 156 "ease-gradient.vala"
	y_orig = height / 2;
#line 157 "ease-gradient.vala"
	dist_x = (gint) (cos (self->priv->_angle + (G_PI / 2)) * y_orig);
#line 158 "ease-gradient.vala"
	dist_y = (gint) (sin (self->priv->_angle + (G_PI / 2)) * y_orig);
#line 481 "ease-gradient.c"
	pattern = NULL;
#line 161 "ease-gradient.vala"
	switch (self->priv->_mode) {
#line 485 "ease-gradient.c"
		case EASE_GRADIENT_TYPE_LINEAR:
		{
			cairo_pattern_t* _tmp0_;
#line 164 "ease-gradient.vala"
			pattern = (_tmp0_ = cairo_pattern_create_linear ((double) (x_orig - dist_x), (double) (y_orig - dist_y), (double) (x_orig + dist_x), (double) (y_orig + dist_y)), _cairo_pattern_destroy0 (pattern), _tmp0_);
#line 168 "ease-gradient.vala"
			cairo_pattern_add_color_stop_rgba (pattern, (double) 0, ease_color_get_red (self->priv->_start), ease_color_get_green (self->priv->_start), ease_color_get_blue (self->priv->_start), ease_color_get_alpha (self->priv->_start));
#line 170 "ease-gradient.vala"
			cairo_pattern_add_color_stop_rgba (pattern, (double) 1, ease_color_get_red (self->priv->_end), ease_color_get_green (self->priv->_end), ease_color_get_blue (self->priv->_end), ease_color_get_alpha (self->priv->_end));
#line 172 "ease-gradient.vala"
			break;
#line 497 "ease-gradient.c"
		}
		case EASE_GRADIENT_TYPE_LINEAR_MIRRORED:
		{
			cairo_pattern_t* _tmp1_;
#line 174 "ease-gradient.vala"
			pattern = (_tmp1_ = cairo_pattern_create_linear ((double) (x_orig - dist_x), (double) (y_orig - dist_y), (double) (x_orig + dist_x), (double) (y_orig + dist_y)), _cairo_pattern_destroy0 (pattern), _tmp1_);
#line 178 "ease-gradient.vala"
			cairo_pattern_add_color_stop_rgba (pattern, (double) 0, ease_color_get_red (self->priv->_start), ease_color_get_green (self->priv->_start), ease_color_get_blue (self->priv->_start), ease_color_get_alpha (self->priv->_start));
#line 180 "ease-gradient.vala"
			cairo_pattern_add_color_stop_rgba (pattern, 0.5, ease_color_get_red (self->priv->_end), ease_color_get_green (self->priv->_end), ease_color_get_blue (self->priv->_end), ease_color_get_alpha (self->priv->_end));
#line 182 "ease-gradient.vala"
			cairo_pattern_add_color_stop_rgba (pattern, (double) 1, ease_color_get_red (self->priv->_start), ease_color_get_green (self->priv->_start), ease_color_get_blue (self->priv->_start), ease_color_get_alpha (self->priv->_start));
#line 184 "ease-gradient.vala"
			break;
#line 512 "ease-gradient.c"
		}
		default:
		{
			cairo_pattern_t* _tmp2_;
#line 186 "ease-gradient.vala"
			pattern = (_tmp2_ = cairo_pattern_create_radial ((double) (width / 2), (double) (height / 2), (double) 0, (double) (width / 2), (double) (height / 2), (double) (width / 2)), _cairo_pattern_destroy0 (pattern), _tmp2_);
#line 189 "ease-gradient.vala"
			cairo_pattern_add_color_stop_rgba (pattern, (double) 0, ease_color_get_red (self->priv->_start), ease_color_get_green (self->priv->_start), ease_color_get_blue (self->priv->_start), ease_color_get_alpha (self->priv->_start));
#line 191 "ease-gradient.vala"
			cairo_pattern_add_color_stop_rgba (pattern, (double) 1, ease_color_get_red (self->priv->_end), ease_color_get_green (self->priv->_end), ease_color_get_blue (self->priv->_end), ease_color_get_alpha (self->priv->_end));
#line 193 "ease-gradient.vala"
			break;
#line 525 "ease-gradient.c"
		}
	}
#line 196 "ease-gradient.vala"
	cairo_set_source (cr, pattern);
#line 530 "ease-gradient.c"
	_cairo_pattern_destroy0 (pattern);
}


EaseColor* ease_gradient_get_start (EaseGradient* self) {
	EaseColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_start;
#line 36 "ease-gradient.vala"
	return result;
#line 541 "ease-gradient.c"
}


void ease_gradient_set_start (EaseGradient* self, EaseColor* value) {
	EaseColor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_start = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_start), _tmp0_);
	g_object_notify ((GObject *) self, "start");
}


EaseColor* ease_gradient_get_end (EaseGradient* self) {
	EaseColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_end;
#line 41 "ease-gradient.vala"
	return result;
#line 559 "ease-gradient.c"
}


void ease_gradient_set_end (EaseGradient* self, EaseColor* value) {
	EaseColor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_end = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_end), _tmp0_);
	g_object_notify ((GObject *) self, "end");
}


EaseGradientType ease_gradient_get_mode (EaseGradient* self) {
	EaseGradientType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
#line 46 "ease-gradient.vala"
	return result;
#line 577 "ease-gradient.c"
}


void ease_gradient_set_mode (EaseGradient* self, EaseGradientType value) {
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
	g_object_notify ((GObject *) self, "mode");
}


double ease_gradient_get_angle (EaseGradient* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_angle;
#line 51 "ease-gradient.vala"
	return result;
#line 594 "ease-gradient.c"
}


void ease_gradient_set_angle (EaseGradient* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_angle = value;
	g_object_notify ((GObject *) self, "angle");
}


EaseGradient* ease_gradient_get_default_background (void) {
	EaseGradient* result;
	EaseColor* _tmp0_;
	EaseColor* _tmp1_;
	EaseGradient* _tmp2_;
	result = (_tmp2_ = ease_gradient_new (_tmp0_ = ease_color_get_black (), _tmp1_ = ease_color_get_white ()), _g_object_unref0 (_tmp1_), _g_object_unref0 (_tmp0_), _tmp2_);
#line 58 "ease-gradient.vala"
	return result;
#line 613 "ease-gradient.c"
}


static void ease_gradient_class_init (EaseGradientClass * klass) {
	ease_gradient_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseGradientPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_gradient_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_gradient_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_gradient_finalize;
	/**
	 * The starting {@link Color} of the gradient.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_GRADIENT_START, g_param_spec_object ("start", "start", "start", EASE_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The ending {@link Color} of the gradient.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_GRADIENT_END, g_param_spec_object ("end", "end", "end", EASE_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The {@link GradientType} of the gradient.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_GRADIENT_MODE, g_param_spec_enum ("mode", "mode", "mode", EASE_TYPE_GRADIENT_TYPE, EASE_GRADIENT_TYPE_LINEAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The angle, in radians, of the gradient, if it is linear.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_GRADIENT_ANGLE, g_param_spec_double ("angle", "angle", "angle", -G_MAXDOUBLE, G_MAXDOUBLE, (double) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ease_gradient_instance_init (EaseGradient * self) {
	self->priv = EASE_GRADIENT_GET_PRIVATE (self);
	self->priv->_start = ease_color_get_white ();
	self->priv->_end = ease_color_get_black ();
	self->priv->_mode = EASE_GRADIENT_TYPE_LINEAR;
	self->priv->_angle = (double) 0;
}


static void ease_gradient_finalize (GObject* obj) {
	EaseGradient * self;
	self = EASE_GRADIENT (obj);
	_g_object_unref0 (self->priv->_start);
	_g_object_unref0 (self->priv->_end);
	G_OBJECT_CLASS (ease_gradient_parent_class)->finalize (obj);
}


/**
 * Gradient representation, using {@link Color}.
 */
GType ease_gradient_get_type (void) {
	static volatile gsize ease_gradient_type_id__volatile = 0;
	if (g_once_init_enter (&ease_gradient_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseGradientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_gradient_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseGradient), 0, (GInstanceInitFunc) ease_gradient_instance_init, NULL };
		GType ease_gradient_type_id;
		ease_gradient_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseGradient", &g_define_type_info, 0);
		g_once_init_leave (&ease_gradient_type_id__volatile, ease_gradient_type_id);
	}
	return ease_gradient_type_id__volatile;
}


static void ease_gradient_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseGradient * self;
	self = EASE_GRADIENT (object);
	switch (property_id) {
		case EASE_GRADIENT_START:
		g_value_set_object (value, ease_gradient_get_start (self));
		break;
		case EASE_GRADIENT_END:
		g_value_set_object (value, ease_gradient_get_end (self));
		break;
		case EASE_GRADIENT_MODE:
		g_value_set_enum (value, ease_gradient_get_mode (self));
		break;
		case EASE_GRADIENT_ANGLE:
		g_value_set_double (value, ease_gradient_get_angle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_gradient_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseGradient * self;
	self = EASE_GRADIENT (object);
	switch (property_id) {
		case EASE_GRADIENT_START:
		ease_gradient_set_start (self, g_value_get_object (value));
		break;
		case EASE_GRADIENT_END:
		ease_gradient_set_end (self, g_value_get_object (value));
		break;
		case EASE_GRADIENT_MODE:
		ease_gradient_set_mode (self, g_value_get_enum (value));
		break;
		case EASE_GRADIENT_ANGLE:
		ease_gradient_set_angle (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
 * Returns a string representation of this GradientType.
 */
#line 225 "ease-gradient.vala"
char* ease_gradient_type_to_string (EaseGradientType self) {
#line 726 "ease-gradient.c"
	char* result = NULL;
#line 227 "ease-gradient.vala"
	switch (self) {
#line 730 "ease-gradient.c"
		case EASE_GRADIENT_TYPE_LINEAR:
		{
			result = g_strdup (EASE_THEME_GRAD_LINEAR);
#line 229 "ease-gradient.vala"
			return result;
#line 736 "ease-gradient.c"
		}
		case EASE_GRADIENT_TYPE_LINEAR_MIRRORED:
		{
			result = g_strdup (EASE_THEME_GRAD_LINEAR_MIRRORED);
#line 230 "ease-gradient.vala"
			return result;
#line 743 "ease-gradient.c"
		}
		case EASE_GRADIENT_TYPE_RADIAL:
		{
			result = g_strdup (EASE_THEME_GRAD_RADIAL);
#line 231 "ease-gradient.vala"
			return result;
#line 750 "ease-gradient.c"
		}
	}
	result = g_strdup ("undefined");
#line 233 "ease-gradient.vala"
	return result;
#line 756 "ease-gradient.c"
}


/**
 * Creates a GradientType from a string representation.
 */
#line 239 "ease-gradient.vala"
EaseGradientType ease_gradient_type_from_string (const char* str) {
#line 765 "ease-gradient.c"
	EaseGradientType result = 0;
	const char* _tmp0_;
	GQuark _tmp1_;
#line 239 "ease-gradient.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 771 "ease-gradient.c"
	_tmp0_ = str;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (EASE_THEME_GRAD_LINEAR))
	switch (0) {
		default:
		{
			result = EASE_GRADIENT_TYPE_LINEAR;
#line 243 "ease-gradient.vala"
			return result;
#line 781 "ease-gradient.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_GRAD_LINEAR_MIRRORED))
	switch (0) {
		default:
		{
			result = EASE_GRADIENT_TYPE_LINEAR_MIRRORED;
#line 244 "ease-gradient.vala"
			return result;
#line 790 "ease-gradient.c"
		}
	} else if (_tmp1_ == g_quark_from_string (EASE_THEME_GRAD_RADIAL))
	switch (0) {
		default:
		{
			result = EASE_GRADIENT_TYPE_RADIAL;
#line 245 "ease-gradient.vala"
			return result;
#line 799 "ease-gradient.c"
		}
	}
#line 248 "ease-gradient.vala"
	g_warning ("ease-gradient.vala:248: %s is not a gradient type", str);
#line 804 "ease-gradient.c"
	result = EASE_GRADIENT_TYPE_LINEAR;
#line 249 "ease-gradient.vala"
	return result;
#line 808 "ease-gradient.c"
}


/**
 * Returns a string description of the GradientType
 */
#line 255 "ease-gradient.vala"
char* ease_gradient_type_description (EaseGradientType self) {
#line 817 "ease-gradient.c"
	char* result = NULL;
#line 257 "ease-gradient.vala"
	switch (self) {
#line 821 "ease-gradient.c"
		case EASE_GRADIENT_TYPE_LINEAR:
		{
			result = g_strdup (_ ("Linear"));
#line 259 "ease-gradient.vala"
			return result;
#line 827 "ease-gradient.c"
		}
		case EASE_GRADIENT_TYPE_LINEAR_MIRRORED:
		{
			result = g_strdup (_ ("Mirrored Linear"));
#line 260 "ease-gradient.vala"
			return result;
#line 834 "ease-gradient.c"
		}
		case EASE_GRADIENT_TYPE_RADIAL:
		{
			result = g_strdup (_ ("Radial"));
#line 261 "ease-gradient.vala"
			return result;
#line 841 "ease-gradient.c"
		}
	}
	result = g_strdup ("undefined");
#line 263 "ease-gradient.vala"
	return result;
#line 847 "ease-gradient.c"
}


/**
 * Creates a ListStore with the first column set as the description
 * and the second column set as the GradientType.
 */
#line 270 "ease-gradient.vala"
GtkListStore* ease_gradient_type_list_store (void) {
#line 857 "ease-gradient.c"
	GtkListStore* result = NULL;
	GtkListStore* store;
	GtkTreeIter itr = {0};
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
#line 272 "ease-gradient.vala"
	store = gtk_list_store_new (2, G_TYPE_STRING, EASE_TYPE_GRADIENT_TYPE);
#line 275 "ease-gradient.vala"
	gtk_list_store_append (store, &itr);
#line 276 "ease-gradient.vala"
	gtk_list_store_set (store, &itr, 0, _tmp0_ = ease_gradient_type_description (EASE_GRADIENT_TYPE_LINEAR), 1, EASE_GRADIENT_TYPE_LINEAR, -1);
#line 870 "ease-gradient.c"
	_g_free0 (_tmp0_);
#line 277 "ease-gradient.vala"
	gtk_list_store_append (store, &itr);
#line 278 "ease-gradient.vala"
	gtk_list_store_set (store, &itr, 0, _tmp1_ = ease_gradient_type_description (EASE_GRADIENT_TYPE_LINEAR_MIRRORED), 1, EASE_GRADIENT_TYPE_LINEAR_MIRRORED, -1);
#line 876 "ease-gradient.c"
	_g_free0 (_tmp1_);
#line 279 "ease-gradient.vala"
	gtk_list_store_append (store, &itr);
#line 280 "ease-gradient.vala"
	gtk_list_store_set (store, &itr, 0, _tmp2_ = ease_gradient_type_description (EASE_GRADIENT_TYPE_RADIAL), 1, EASE_GRADIENT_TYPE_RADIAL, -1);
#line 882 "ease-gradient.c"
	_g_free0 (_tmp2_);
	result = store;
#line 282 "ease-gradient.vala"
	return result;
#line 887 "ease-gradient.c"
}


/**
 * The {@link Gradient} types provided by Ease.
 */
GType ease_gradient_type_get_type (void) {
	static volatile gsize ease_gradient_type_type_id__volatile = 0;
	if (g_once_init_enter (&ease_gradient_type_type_id__volatile)) {
		static const GEnumValue values[] = {{EASE_GRADIENT_TYPE_LINEAR, "EASE_GRADIENT_TYPE_LINEAR", "linear"}, {EASE_GRADIENT_TYPE_LINEAR_MIRRORED, "EASE_GRADIENT_TYPE_LINEAR_MIRRORED", "linear-mirrored"}, {EASE_GRADIENT_TYPE_RADIAL, "EASE_GRADIENT_TYPE_RADIAL", "radial"}, {0, NULL, NULL}};
		GType ease_gradient_type_type_id;
		ease_gradient_type_type_id = g_enum_register_static ("EaseGradientType", values);
		g_once_init_leave (&ease_gradient_type_type_id__volatile, ease_gradient_type_type_id);
	}
	return ease_gradient_type_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




