/* source-spinner-item.c generated by valac 0.10.0, the Vala compiler
 * generated from source-spinner-item.vala, do not modify */

/*
 * Copyright (c) 2010, Nate Stedman <natesm@gmail.com>
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define SOURCE_TYPE_ITEM (source_item_get_type ())
#define SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_TYPE_ITEM, SourceItem))
#define SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_TYPE_ITEM, SourceItemClass))
#define SOURCE_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_TYPE_ITEM))
#define SOURCE_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_TYPE_ITEM))
#define SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_TYPE_ITEM, SourceItemClass))

typedef struct _SourceItem SourceItem;
typedef struct _SourceItemClass SourceItemClass;
typedef struct _SourceItemPrivate SourceItemPrivate;

#define SOURCE_TYPE_SPINNER_ITEM (source_spinner_item_get_type ())
#define SOURCE_SPINNER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_TYPE_SPINNER_ITEM, SourceSpinnerItem))
#define SOURCE_SPINNER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_TYPE_SPINNER_ITEM, SourceSpinnerItemClass))
#define SOURCE_IS_SPINNER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_TYPE_SPINNER_ITEM))
#define SOURCE_IS_SPINNER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_TYPE_SPINNER_ITEM))
#define SOURCE_SPINNER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_TYPE_SPINNER_ITEM, SourceSpinnerItemClass))

typedef struct _SourceSpinnerItem SourceSpinnerItem;
typedef struct _SourceSpinnerItemClass SourceSpinnerItemClass;
typedef struct _SourceSpinnerItemPrivate SourceSpinnerItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SourceItem {
	GtkHBox parent_instance;
	SourceItemPrivate * priv;
	GtkAlignment* right_align;
	GtkWidget* widget;
};

struct _SourceItemClass {
	GtkHBoxClass parent_class;
};

struct _SourceSpinnerItem {
	SourceItem parent_instance;
	SourceSpinnerItemPrivate * priv;
};

struct _SourceSpinnerItemClass {
	SourceItemClass parent_class;
};

struct _SourceSpinnerItemPrivate {
	GtkSpinner* spinner;
};


static gpointer source_spinner_item_parent_class = NULL;

GType source_item_get_type (void) G_GNUC_CONST;
GType source_spinner_item_get_type (void) G_GNUC_CONST;
#define SOURCE_SPINNER_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SOURCE_TYPE_SPINNER_ITEM, SourceSpinnerItemPrivate))
enum  {
	SOURCE_SPINNER_ITEM_DUMMY_PROPERTY,
	SOURCE_SPINNER_ITEM_SPINNING
};
void source_spinner_item_stop (SourceSpinnerItem* self);
void source_spinner_item_start (SourceSpinnerItem* self);
SourceSpinnerItem* source_spinner_item_new (const char* text, GtkImage* img, GtkWidget* widg);
SourceSpinnerItem* source_spinner_item_construct (GType object_type, const char* text, GtkImage* img, GtkWidget* widg);
SourceItem* source_item_new (const char* text, GtkImage* img, GtkWidget* widg);
SourceItem* source_item_construct (GType object_type, const char* text, GtkImage* img, GtkWidget* widg);
SourceSpinnerItem* source_spinner_item_new_from_stock_icon (const char* text, const char* item, GtkWidget* widg);
SourceSpinnerItem* source_spinner_item_construct_from_stock_icon (GType object_type, const char* text, const char* item, GtkWidget* widg);
#define SOURCE_ITEM_ICON_SIZE GTK_ICON_SIZE_MENU
SourceSpinnerItem* source_spinner_item_new_from_stock_text (const char* item, GtkImage* img, GtkWidget* widg);
SourceSpinnerItem* source_spinner_item_construct_from_stock_text (GType object_type, const char* item, GtkImage* img, GtkWidget* widg);
SourceSpinnerItem* source_spinner_item_new_from_stock (const char* item, GtkWidget* widg);
SourceSpinnerItem* source_spinner_item_construct_from_stock (GType object_type, const char* item, GtkWidget* widg);
gboolean source_spinner_item_get_spinning (SourceSpinnerItem* self);
void source_spinner_item_set_spinning (SourceSpinnerItem* self, gboolean value);
static void source_spinner_item_finalize (GObject* obj);
static void source_spinner_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void source_spinner_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * Stops and hides the spinner.
 */
#line 30 "source-spinner-item.vala"
void source_spinner_item_stop (SourceSpinnerItem* self) {
#line 30 "source-spinner-item.vala"
	g_return_if_fail (self != NULL);
#line 32 "source-spinner-item.vala"
	gtk_spinner_stop (self->priv->spinner);
#line 33 "source-spinner-item.vala"
	if (gtk_widget_get_parent ((GtkWidget*) self->priv->spinner) == GTK_WIDGET (((SourceItem*) self)->right_align)) {
#line 33 "source-spinner-item.vala"
		gtk_container_remove ((GtkContainer*) ((SourceItem*) self)->right_align, (GtkWidget*) self->priv->spinner);
#line 122 "source-spinner-item.c"
	}
}


/** 
 * Starts and shows the spinner.
 */
#line 39 "source-spinner-item.vala"
void source_spinner_item_start (SourceSpinnerItem* self) {
#line 39 "source-spinner-item.vala"
	g_return_if_fail (self != NULL);
#line 41 "source-spinner-item.vala"
	gtk_spinner_start (self->priv->spinner);
#line 42 "source-spinner-item.vala"
	if (gtk_widget_get_parent ((GtkWidget*) self->priv->spinner) != GTK_WIDGET (((SourceItem*) self)->right_align)) {
#line 42 "source-spinner-item.vala"
		gtk_container_add ((GtkContainer*) ((SourceItem*) self)->right_align, (GtkWidget*) self->priv->spinner);
#line 140 "source-spinner-item.c"
	}
}


/**
 * Creates a Source.SpinnerItem with a customizable icon and text.
 *
 * @param text The text to display in the source item.
 * @param img The image widget to use (note that this icon should use
 * the Gtk.IconSize constant ICON_SIZE to fit in with other items).
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 69 "source-spinner-item.vala"
SourceSpinnerItem* source_spinner_item_construct (GType object_type, const char* text, GtkImage* img, GtkWidget* widg) {
#line 157 "source-spinner-item.c"
	SourceSpinnerItem * self;
#line 69 "source-spinner-item.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 69 "source-spinner-item.vala"
	g_return_val_if_fail (img != NULL, NULL);
#line 71 "source-spinner-item.vala"
	self = (SourceSpinnerItem*) source_item_construct (object_type, text, img, widg);
#line 72 "source-spinner-item.vala"
	gtk_widget_show ((GtkWidget*) self->priv->spinner);
#line 167 "source-spinner-item.c"
	return self;
}


#line 69 "source-spinner-item.vala"
SourceSpinnerItem* source_spinner_item_new (const char* text, GtkImage* img, GtkWidget* widg) {
#line 69 "source-spinner-item.vala"
	return source_spinner_item_construct (SOURCE_TYPE_SPINNER_ITEM, text, img, widg);
#line 176 "source-spinner-item.c"
}


/**
 * Creates a Source.SpinnerItem with a stock icon and customizable text.
 *
 * @param text The text to display in the source item.
 * @param item The stock item to take the icon from.
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 84 "source-spinner-item.vala"
SourceSpinnerItem* source_spinner_item_construct_from_stock_icon (GType object_type, const char* text, const char* item, GtkWidget* widg) {
#line 191 "source-spinner-item.c"
	SourceSpinnerItem * self;
	GtkImage* _tmp0_;
#line 84 "source-spinner-item.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 84 "source-spinner-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 87 "source-spinner-item.vala"
	self = (SourceSpinnerItem*) source_spinner_item_construct (object_type, text, _tmp0_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (item, SOURCE_ITEM_ICON_SIZE)), widg);
#line 200 "source-spinner-item.c"
	_g_object_unref0 (_tmp0_);
	return self;
}


#line 84 "source-spinner-item.vala"
SourceSpinnerItem* source_spinner_item_new_from_stock_icon (const char* text, const char* item, GtkWidget* widg) {
#line 84 "source-spinner-item.vala"
	return source_spinner_item_construct_from_stock_icon (SOURCE_TYPE_SPINNER_ITEM, text, item, widg);
#line 210 "source-spinner-item.c"
}


/**
 * Creates a Source.SpinnerItem with a stock icon and customizable text.
 *
 * @param text The text to display in the source item.
 * @param item The stock item to take the label from.
 * @param img The image widget to use (note that this icon should use
 * the Gtk.IconSize constant ICON_SIZE to fit in with other items).
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 1157 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 227 "source-spinner-item.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 236 "source-spinner-item.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1159 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 244 "source-spinner-item.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch41_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1160 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 255 "source-spinner-item.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch41_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1160 "glib-2.0.vapi"
		return result;
#line 270 "source-spinner-item.c"
	}
	goto __finally41;
	__catch41_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1162 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 281 "source-spinner-item.c"
			_g_error_free0 (e);
		}
	}
	__finally41:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 101 "source-spinner-item.vala"
SourceSpinnerItem* source_spinner_item_construct_from_stock_text (GType object_type, const char* item, GtkImage* img, GtkWidget* widg) {
#line 296 "source-spinner-item.c"
	SourceSpinnerItem * self;
	GtkStockItem stock = {0};
#line 101 "source-spinner-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 101 "source-spinner-item.vala"
	g_return_val_if_fail (img != NULL, NULL);
#line 303 "source-spinner-item.c"
	memset (&stock, 0, sizeof (GtkStockItem));
#line 105 "source-spinner-item.vala"
	if (gtk_stock_lookup (item, &stock)) {
#line 307 "source-spinner-item.c"
		char* _tmp0_;
#line 107 "source-spinner-item.vala"
		self = (SourceSpinnerItem*) source_spinner_item_construct (object_type, _tmp0_ = string_replace (stock.label, "_", ""), img, widg);
#line 311 "source-spinner-item.c"
		_g_free0 (_tmp0_);
	}
	return self;
}


#line 101 "source-spinner-item.vala"
SourceSpinnerItem* source_spinner_item_new_from_stock_text (const char* item, GtkImage* img, GtkWidget* widg) {
#line 101 "source-spinner-item.vala"
	return source_spinner_item_construct_from_stock_text (SOURCE_TYPE_SPINNER_ITEM, item, img, widg);
#line 322 "source-spinner-item.c"
}


/**
 * Creates a Source.SpinnerItem with a stock icon and text.
 *
 * @param item The stock item to take the icon and text from.
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 119 "source-spinner-item.vala"
SourceSpinnerItem* source_spinner_item_construct_from_stock (GType object_type, const char* item, GtkWidget* widg) {
#line 336 "source-spinner-item.c"
	SourceSpinnerItem * self;
	GtkStockItem stock = {0};
#line 119 "source-spinner-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 341 "source-spinner-item.c"
	memset (&stock, 0, sizeof (GtkStockItem));
#line 122 "source-spinner-item.vala"
	if (gtk_stock_lookup (item, &stock)) {
#line 345 "source-spinner-item.c"
		char* _tmp0_;
		GtkImage* _tmp1_;
#line 124 "source-spinner-item.vala"
		self = (SourceSpinnerItem*) source_spinner_item_construct (object_type, _tmp0_ = string_replace (stock.label, "_", ""), _tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (item, SOURCE_ITEM_ICON_SIZE)), widg);
#line 350 "source-spinner-item.c"
		_g_object_unref0 (_tmp1_);
		_g_free0 (_tmp0_);
	}
	return self;
}


#line 119 "source-spinner-item.vala"
SourceSpinnerItem* source_spinner_item_new_from_stock (const char* item, GtkWidget* widg) {
#line 119 "source-spinner-item.vala"
	return source_spinner_item_construct_from_stock (SOURCE_TYPE_SPINNER_ITEM, item, widg);
#line 362 "source-spinner-item.c"
}


gboolean source_spinner_item_get_spinning (SourceSpinnerItem* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_widget_get_parent ((GtkWidget*) self->priv->spinner) == GTK_WIDGET (((SourceItem*) self)->right_align);
#line 50 "source-spinner-item.vala"
	return result;
#line 372 "source-spinner-item.c"
}


void source_spinner_item_set_spinning (SourceSpinnerItem* self, gboolean value) {
	g_return_if_fail (self != NULL);
#line 53 "source-spinner-item.vala"
	gtk_widget_set_visible ((GtkWidget*) self->priv->spinner, value);
#line 54 "source-spinner-item.vala"
	if (value) {
#line 54 "source-spinner-item.vala"
		gtk_spinner_start (self->priv->spinner);
#line 384 "source-spinner-item.c"
	} else {
#line 55 "source-spinner-item.vala"
		gtk_spinner_stop (self->priv->spinner);
#line 388 "source-spinner-item.c"
	}
	g_object_notify ((GObject *) self, "spinning");
}


static void source_spinner_item_class_init (SourceSpinnerItemClass * klass) {
	source_spinner_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SourceSpinnerItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = source_spinner_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = source_spinner_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = source_spinner_item_finalize;
	/**
	 * Whether or not the spinner is currently visible and spinning.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOURCE_SPINNER_ITEM_SPINNING, g_param_spec_boolean ("spinning", "spinning", "spinning", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void source_spinner_item_instance_init (SourceSpinnerItem * self) {
	self->priv = SOURCE_SPINNER_ITEM_GET_PRIVATE (self);
	self->priv->spinner = g_object_ref_sink ((GtkSpinner*) gtk_spinner_new ());
}


static void source_spinner_item_finalize (GObject* obj) {
	SourceSpinnerItem * self;
	self = SOURCE_SPINNER_ITEM (obj);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (source_spinner_item_parent_class)->finalize (obj);
}


/**
 * A {@link Item} with a Gtk.Spinner on the right side.
 */
GType source_spinner_item_get_type (void) {
	static volatile gsize source_spinner_item_type_id__volatile = 0;
	if (g_once_init_enter (&source_spinner_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SourceSpinnerItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_spinner_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceSpinnerItem), 0, (GInstanceInitFunc) source_spinner_item_instance_init, NULL };
		GType source_spinner_item_type_id;
		source_spinner_item_type_id = g_type_register_static (SOURCE_TYPE_ITEM, "SourceSpinnerItem", &g_define_type_info, 0);
		g_once_init_leave (&source_spinner_item_type_id__volatile, source_spinner_item_type_id);
	}
	return source_spinner_item_type_id__volatile;
}


static void source_spinner_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SourceSpinnerItem * self;
	self = SOURCE_SPINNER_ITEM (object);
	switch (property_id) {
		case SOURCE_SPINNER_ITEM_SPINNING:
		g_value_set_boolean (value, source_spinner_item_get_spinning (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void source_spinner_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SourceSpinnerItem * self;
	self = SOURCE_SPINNER_ITEM (object);
	switch (property_id) {
		case SOURCE_SPINNER_ITEM_SPINNING:
		source_spinner_item_set_spinning (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




