/* ease-editor-window.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-editor-window.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ease-core.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <time.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <poppler.h>
#include <pango/pango.h>


#define EASE_TYPE_EDITOR_WINDOW (ease_editor_window_get_type ())
#define EASE_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindow))
#define EASE_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))
#define EASE_IS_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_WINDOW))
#define EASE_IS_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_WINDOW))
#define EASE_EDITOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))

typedef struct _EaseEditorWindow EaseEditorWindow;
typedef struct _EaseEditorWindowClass EaseEditorWindowClass;
typedef struct _EaseEditorWindowPrivate EaseEditorWindowPrivate;

#define EASE_TYPE_SCROLLABLE_EMBED (ease_scrollable_embed_get_type ())
#define EASE_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbed))
#define EASE_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))
#define EASE_IS_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_IS_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_SCROLLABLE_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))

typedef struct _EaseScrollableEmbed EaseScrollableEmbed;
typedef struct _EaseScrollableEmbedClass EaseScrollableEmbedClass;

#define EASE_TYPE_EDITOR_EMBED (ease_editor_embed_get_type ())
#define EASE_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbed))
#define EASE_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))
#define EASE_IS_EDITOR_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_EMBED))
#define EASE_IS_EDITOR_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_EMBED))
#define EASE_EDITOR_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_EMBED, EaseEditorEmbedClass))

typedef struct _EaseEditorEmbed EaseEditorEmbed;
typedef struct _EaseEditorEmbedClass EaseEditorEmbedClass;

#define EASE_TYPE_SLIDE_BUTTON_PANEL (ease_slide_button_panel_get_type ())
#define EASE_SLIDE_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanel))
#define EASE_SLIDE_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanelClass))
#define EASE_IS_SLIDE_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL))
#define EASE_IS_SLIDE_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_BUTTON_PANEL))
#define EASE_SLIDE_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanelClass))

typedef struct _EaseSlideButtonPanel EaseSlideButtonPanel;
typedef struct _EaseSlideButtonPanelClass EaseSlideButtonPanelClass;

#define EASE_TYPE_PLAYER (ease_player_get_type ())
#define EASE_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_PLAYER, EasePlayer))
#define EASE_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_PLAYER, EasePlayerClass))
#define EASE_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_PLAYER))
#define EASE_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_PLAYER))
#define EASE_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_PLAYER, EasePlayerClass))

typedef struct _EasePlayer EasePlayer;
typedef struct _EasePlayerClass EasePlayerClass;

#define EASE_TYPE_INSPECTOR (ease_inspector_get_type ())
#define EASE_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_INSPECTOR, EaseInspector))
#define EASE_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_INSPECTOR, EaseInspectorClass))
#define EASE_IS_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_INSPECTOR))
#define EASE_IS_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_INSPECTOR))
#define EASE_INSPECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_INSPECTOR, EaseInspectorClass))

typedef struct _EaseInspector EaseInspector;
typedef struct _EaseInspectorClass EaseInspectorClass;

#define EASE_TYPE_SLIDE_SORTER (ease_slide_sorter_get_type ())
#define EASE_SLIDE_SORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_SORTER, EaseSlideSorter))
#define EASE_SLIDE_SORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_SORTER, EaseSlideSorterClass))
#define EASE_IS_SLIDE_SORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_SORTER))
#define EASE_IS_SLIDE_SORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_SORTER))
#define EASE_SLIDE_SORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_SORTER, EaseSlideSorterClass))

typedef struct _EaseSlideSorter EaseSlideSorter;
typedef struct _EaseSlideSorterClass EaseSlideSorterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EaseInspectorPrivate EaseInspectorPrivate;

#define EASE_TYPE_INSPECTOR_PANE (ease_inspector_pane_get_type ())
#define EASE_INSPECTOR_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_INSPECTOR_PANE, EaseInspectorPane))
#define EASE_INSPECTOR_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_INSPECTOR_PANE, EaseInspectorPaneClass))
#define EASE_IS_INSPECTOR_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_INSPECTOR_PANE))
#define EASE_IS_INSPECTOR_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_INSPECTOR_PANE))
#define EASE_INSPECTOR_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_INSPECTOR_PANE, EaseInspectorPaneClass))

typedef struct _EaseInspectorPane EaseInspectorPane;
typedef struct _EaseInspectorPaneClass EaseInspectorPaneClass;

#define EASE_TYPE_INSPECTOR_ELEMENT_PANE (ease_inspector_element_pane_get_type ())
#define EASE_INSPECTOR_ELEMENT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_INSPECTOR_ELEMENT_PANE, EaseInspectorElementPane))
#define EASE_INSPECTOR_ELEMENT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_INSPECTOR_ELEMENT_PANE, EaseInspectorElementPaneClass))
#define EASE_IS_INSPECTOR_ELEMENT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_INSPECTOR_ELEMENT_PANE))
#define EASE_IS_INSPECTOR_ELEMENT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_INSPECTOR_ELEMENT_PANE))
#define EASE_INSPECTOR_ELEMENT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_INSPECTOR_ELEMENT_PANE, EaseInspectorElementPaneClass))

typedef struct _EaseInspectorElementPane EaseInspectorElementPane;
typedef struct _EaseInspectorElementPaneClass EaseInspectorElementPaneClass;

#define EASE_TYPE_CLOSE_CONFIRM_DIALOG (ease_close_confirm_dialog_get_type ())
#define EASE_CLOSE_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_CLOSE_CONFIRM_DIALOG, EaseCloseConfirmDialog))
#define EASE_CLOSE_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_CLOSE_CONFIRM_DIALOG, EaseCloseConfirmDialogClass))
#define EASE_IS_CLOSE_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_CLOSE_CONFIRM_DIALOG))
#define EASE_IS_CLOSE_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_CLOSE_CONFIRM_DIALOG))
#define EASE_CLOSE_CONFIRM_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_CLOSE_CONFIRM_DIALOG, EaseCloseConfirmDialogClass))

typedef struct _EaseCloseConfirmDialog EaseCloseConfirmDialog;
typedef struct _EaseCloseConfirmDialogClass EaseCloseConfirmDialogClass;
#define _ease_slide_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_slide_iterator_unref (var), NULL)))

#define EASE_TYPE_IMPORT_DIALOG (ease_import_dialog_get_type ())
#define EASE_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMPORT_DIALOG, EaseImportDialog))
#define EASE_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMPORT_DIALOG, EaseImportDialogClass))
#define EASE_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMPORT_DIALOG))
#define EASE_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMPORT_DIALOG))
#define EASE_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMPORT_DIALOG, EaseImportDialogClass))

typedef struct _EaseImportDialog EaseImportDialog;
typedef struct _EaseImportDialogClass EaseImportDialogClass;
#define _ease_iterable_tree_model_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_iterable_tree_model_iterator_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

struct _EaseEditorWindow {
	GtkWindow parent_instance;
	EaseEditorWindowPrivate * priv;
	EaseEditorEmbed* embed;
	EaseSlideButtonPanel* slide_button_panel;
	EaseAnimatedZoomSlider* zoom_slider;
	EaseDocument* document;
	EaseSlide* slide;
};

struct _EaseEditorWindowClass {
	GtkWindowClass parent_class;
};

struct _EaseEditorWindowPrivate {
	EasePlayer* player;
	EaseInspector* inspector;
	GtkWidget* editor;
	EaseSlideSorter* sorter;
	GtkBin* main_bin;
	EaseUndoController* undo;
	EaseUndoAction* undo_action;
	GtkToolButton* undo_button;
	GtkToolButton* redo_button;
	gboolean _slides_shown;
	GtkColorSelectionDialog* color_dialog;
	GtkColorSelection* color_selection;
	GtkRadioMenuItem* show_editor;
	GtkRadioMenuItem* show_sorter;
	GtkCheckMenuItem* zoom_fit;
	glong last_saved;
	gint* ZOOM_LEVELS;
	gint ZOOM_LEVELS_length1;
	gint _ZOOM_LEVELS_size_;
	gint* SORTER_ZOOM_LEVELS;
	gint SORTER_ZOOM_LEVELS_length1;
	gint _SORTER_ZOOM_LEVELS_size_;
	GtkAdjustment* zoom_adjustment;
	GtkAdjustment* sorter_zoom_adjustment;
};

struct _EaseInspector {
	GtkNotebook parent_instance;
	EaseInspectorPrivate * priv;
	EaseInspectorElementPane* element_pane;
};

struct _EaseInspectorClass {
	GtkNotebookClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	EaseEditorWindow * self;
	ClutterColor* original_color;
};


static gpointer ease_editor_window_parent_class = NULL;

GType ease_editor_window_get_type (void) G_GNUC_CONST;
GType ease_scrollable_embed_get_type (void) G_GNUC_CONST;
GType ease_editor_embed_get_type (void) G_GNUC_CONST;
GType ease_slide_button_panel_get_type (void) G_GNUC_CONST;
GType ease_player_get_type (void) G_GNUC_CONST;
GType ease_inspector_get_type (void) G_GNUC_CONST;
GType ease_slide_sorter_get_type (void) G_GNUC_CONST;
#define EASE_EDITOR_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowPrivate))
enum  {
	EASE_EDITOR_WINDOW_DUMMY_PROPERTY,
	EASE_EDITOR_WINDOW_SLIDES_SHOWN
};
#define EASE_EDITOR_WINDOW_UI_FILE_PATH "editor-window.ui"
#define EASE_EDITOR_WINDOW_FONT_TEXT _ ("The quick brown fox jumps over the lazy dog")
#define EASE_EDITOR_WINDOW_INSPECTOR_VISIBLE_DEFAULT TRUE
EaseEditorWindow* ease_editor_window_new (EaseDocument* doc);
EaseEditorWindow* ease_editor_window_construct (GType object_type, EaseDocument* doc);
void ease_editor_window_add_undo_action (EaseEditorWindow* self, EaseUndoItem* action);
static void _ease_editor_window_add_undo_action_ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self);
EaseSlideButtonPanel* ease_slide_button_panel_new (EaseDocument* d, EaseEditorWindow* win);
EaseSlideButtonPanel* ease_slide_button_panel_construct (GType object_type, EaseDocument* d, EaseEditorWindow* win);
EaseEditorEmbed* ease_editor_embed_new (EaseDocument* d, EaseEditorWindow* w);
EaseEditorEmbed* ease_editor_embed_construct (GType object_type, EaseDocument* d, EaseEditorWindow* w);
EaseInspector* ease_inspector_new (EaseDocument* document);
EaseInspector* ease_inspector_construct (GType object_type, EaseDocument* document);
GType ease_inspector_pane_get_type (void) G_GNUC_CONST;
GType ease_inspector_element_pane_get_type (void) G_GNUC_CONST;
void ease_inspector_element_pane_on_element_selected (EaseInspectorElementPane* self, EaseElement* selected);
static void _ease_inspector_element_pane_on_element_selected_ease_editor_embed_element_selected (EaseEditorEmbed* _sender, EaseElement* selected, gpointer self);
void ease_inspector_element_pane_on_element_deselected (EaseInspectorElementPane* self, EaseElement* deselected);
static void _ease_inspector_element_pane_on_element_deselected_ease_editor_embed_element_deselected (EaseEditorEmbed* _sender, EaseElement* deselected, gpointer self);
static EaseZoomSlider* ease_editor_window_create_zoom_slider (EaseEditorWindow* self);
void ease_editor_window_on_new_slide_menu (GtkWidget* sender, EaseEditorWindow* self);
static void _ease_editor_window_on_new_slide_menu_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void ease_editor_window_set_slides_shown (EaseEditorWindow* self, gboolean value);
static gboolean _lambda54_ (GtkWidget* sender, GdkEvent* event, EaseEditorWindow* self);
EaseCloseConfirmDialog* ease_close_confirm_dialog_new (const char* filename, gint seconds);
EaseCloseConfirmDialog* ease_close_confirm_dialog_construct (GType object_type, const char* filename, gint seconds);
GType ease_close_confirm_dialog_get_type (void) G_GNUC_CONST;
gboolean ease_editor_window_save_document (GtkWidget* sender, EaseEditorWindow* self);
static gboolean __lambda54__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
void ease_slide_button_panel_select_slide (EaseSlideButtonPanel* self, EaseSlide* slide);
static void ease_editor_window_update_undo (EaseEditorWindow* self);
void ease_editor_window_set_slide (EaseEditorWindow* self, gint index);
void ease_inspector_set_slide (EaseInspector* self, EaseSlide* value);
void ease_editor_embed_set_slide (EaseEditorEmbed* self, EaseSlide* slide);
void ease_editor_window_on_open (GtkWidget* sender, EaseEditorWindow* self);
void ease_main_open_file (const char* path);
void ease_editor_window_on_quit (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_delete (GtkWidget* sender, EaseEditorWindow* self);
EaseActor* ease_editor_embed_get_selected (EaseEditorEmbed* self);
void ease_editor_window_new_slide_handler (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_remove_slide (GtkWidget* sender, EaseEditorWindow* self);
EaseSlide* ease_slide_sorter_delete_slide (EaseSlideSorter* self);
void ease_editor_window_play_handler (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_undo_handler (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_redo_handler (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_insert_text (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_embed_select_element (EaseEditorEmbed* self, EaseElement* e);
void ease_editor_window_insert_image (GtkWidget* sender, EaseEditorWindow* self);
static void _lambda68_ (GtkFileChooserDialog* dialog, EaseEditorWindow* self);
static void __lambda68__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self);
void ease_editor_window_insert_image_actual (EaseEditorWindow* self, const char* filename);
void ease_editor_window_insert_video (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_insert_pdf (GtkWidget* sender, EaseEditorWindow* self);
static void _lambda69_ (GtkFileChooserDialog* dialog, EaseEditorWindow* self);
static void __lambda69__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self);
void ease_editor_window_on_insert_web_media (GtkWidget* sender, EaseEditorWindow* self);
EaseImportDialog* ease_import_dialog_new (void);
EaseImportDialog* ease_import_dialog_construct (GType object_type);
GType ease_import_dialog_get_type (void) G_GNUC_CONST;
static void _ease_editor_window_insert_image_actual_ease_import_dialog_add_image (EaseImportDialog* _sender, const char* filename, gpointer self);
void ease_import_dialog_run (EaseImportDialog* self);
void ease_editor_window_on_insert_rectangle (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_insert_oval (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_set_view (GtkWidget* sender, EaseEditorWindow* self);
void ease_slide_sorter_on_slide_added (EaseSlideSorter* self, EaseSlide* slide, gint index);
static void _ease_slide_sorter_on_slide_added_ease_document_slide_added (EaseDocument* _sender, EaseSlide* slide, gint index, gpointer self);
static gint* _vala_array_dup1 (gint* self, int length);
EaseSlideSorter* ease_slide_sorter_new (EaseDocument* doc, double zoom);
EaseSlideSorter* ease_slide_sorter_construct (GType object_type, EaseDocument* doc, double zoom);
static gint* _vala_array_dup2 (gint* self, int length);
static void _lambda90_ (EaseSlide* s, EaseEditorWindow* self);
static void __lambda90__ease_slide_sorter_display_slide (EaseSlideSorter* _sender, EaseSlide* s, gpointer self);
void ease_editor_window_zoom_in (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_embed_set_zoom_fit (EaseEditorEmbed* self, gboolean value);
void ease_editor_window_zoom_out (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_zoom_fit (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_export_as_pdf (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_export_as_postscript (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_export_as_html (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_lower (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_raise (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_lower_bottom (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_on_raise_top (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_inspector_clicked_handler (GtkWidget* sender, EaseEditorWindow* self);
void ease_editor_window_show_color_dialog (GtkWidget* sender, EaseEditorWindow* self);
static void ease_editor_window_color_dialog_changed (EaseEditorWindow* self, GtkColorSelection* sender);
static void _ease_editor_window_color_dialog_changed_gtk_color_selection_color_changed (GtkColorSelection* _sender, gpointer self);
static void ease_editor_window_color_dialog_selection (EaseEditorWindow* self, GObject* sender, GParamSpec* spec);
static void _ease_editor_window_color_dialog_selection_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda91_ (EaseEditorWindow* self);
static void __lambda91__gtk_widget_hide (GtkWidget* _sender, gpointer self);
static void _lambda92_ (Block1Data* _data1_);
static gboolean _clutter_color_equal (const ClutterColor* s1, const ClutterColor* s2);
static void __lambda92__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda93_ (Block1Data* _data1_);
static void __lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda94_ (EaseEditorWindow* self);
static void __lambda94__gtk_dialog_close (GtkDialog* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
void ease_editor_embed_set_element_color (EaseEditorEmbed* self, ClutterColor* color);
void ease_editor_window_select_font (GtkWidget* sender, EaseEditorWindow* self);
static void _lambda53_ (EaseEditorWindow* self);
void ease_editor_embed_set_zoom (EaseEditorEmbed* self, float value);
void ease_slide_sorter_set_zoom (EaseSlideSorter* self, double zoom);
static void __lambda53__ease_zoom_slider_value_changed (EaseZoomSlider* _sender, gpointer self);
gboolean ease_editor_window_get_slides_shown (EaseEditorWindow* self);
static void ease_editor_window_finalize (GObject* obj);
static void ease_editor_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_editor_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Creates a new EditorWindow.
 * 
 * An EditorWindow includes a toolbar, an
 * {@link EditorEmbed}, a {@link InspectorSlidePane}, a menu bar, and other
 * interface elements.
 *
 * @param node The initial XML node to begin with.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 322 "ease-editor-window.vala"
static void _ease_editor_window_add_undo_action_ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self) {
#line 359 "ease-editor-window.c"
	ease_editor_window_add_undo_action (self, action);
}


#line 42 "ease-inspector-element-pane.vala"
static void _ease_inspector_element_pane_on_element_selected_ease_editor_embed_element_selected (EaseEditorEmbed* _sender, EaseElement* selected, gpointer self) {
#line 366 "ease-editor-window.c"
	ease_inspector_element_pane_on_element_selected (self, selected);
}


#line 53 "ease-inspector-element-pane.vala"
static void _ease_inspector_element_pane_on_element_deselected_ease_editor_embed_element_deselected (EaseEditorEmbed* _sender, EaseElement* deselected, gpointer self) {
#line 373 "ease-editor-window.c"
	ease_inspector_element_pane_on_element_deselected (self, deselected);
}


#line 382 "ease-editor-window.vala"
static void _ease_editor_window_on_new_slide_menu_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 380 "ease-editor-window.c"
	ease_editor_window_on_new_slide_menu (_sender, self);
}


#line 259 "ease-editor-window.vala"
static gboolean _lambda54_ (GtkWidget* sender, GdkEvent* event, EaseEditorWindow* self) {
#line 387 "ease-editor-window.c"
	gboolean result = FALSE;
	const char* _tmp0_;
	char* name;
	gint time_diff;
	EaseCloseConfirmDialog* dialog;
	gint response;
#line 259 "ease-editor-window.vala"
	g_return_val_if_fail (sender != NULL, FALSE);
#line 259 "ease-editor-window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 260 "ease-editor-window.vala"
	if (self->priv->last_saved == 0) {
#line 262 "ease-editor-window.vala"
		g_signal_emit_by_name (self, "close", self);
#line 402 "ease-editor-window.c"
		result = FALSE;
#line 263 "ease-editor-window.vala"
		return result;
#line 406 "ease-editor-window.c"
	}
	_tmp0_ = NULL;
#line 266 "ease-editor-window.vala"
	if (ease_document_get_filename (self->document) == NULL) {
#line 266 "ease-editor-window.vala"
		_tmp0_ = _ ("Untitled Document");
#line 413 "ease-editor-window.c"
	} else {
#line 267 "ease-editor-window.vala"
		_tmp0_ = ease_document_get_filename (self->document);
#line 417 "ease-editor-window.c"
	}
#line 266 "ease-editor-window.vala"
	name = g_strdup (_tmp0_);
#line 268 "ease-editor-window.vala"
	time_diff = (gint) (time (NULL) - self->priv->last_saved);
#line 270 "ease-editor-window.vala"
	dialog = g_object_ref_sink (ease_close_confirm_dialog_new (name, time_diff));
#line 271 "ease-editor-window.vala"
	response = gtk_dialog_run ((GtkDialog*) dialog);
#line 272 "ease-editor-window.vala"
	gtk_object_destroy ((GtkObject*) dialog);
#line 274 "ease-editor-window.vala"
	if (response == GTK_RESPONSE_CANCEL) {
#line 431 "ease-editor-window.c"
		result = TRUE;
		_g_object_unref0 (dialog);
		_g_free0 (name);
#line 274 "ease-editor-window.vala"
		return result;
#line 437 "ease-editor-window.c"
	}
#line 275 "ease-editor-window.vala"
	if (response == GTK_RESPONSE_NO) {
#line 277 "ease-editor-window.vala"
		g_signal_emit_by_name (self, "close", self);
#line 443 "ease-editor-window.c"
		result = FALSE;
		_g_object_unref0 (dialog);
		_g_free0 (name);
#line 278 "ease-editor-window.vala"
		return result;
#line 449 "ease-editor-window.c"
	}
#line 282 "ease-editor-window.vala"
	if (ease_editor_window_save_document (NULL, self)) {
#line 284 "ease-editor-window.vala"
		g_signal_emit_by_name (self, "close", self);
#line 455 "ease-editor-window.c"
		result = FALSE;
		_g_object_unref0 (dialog);
		_g_free0 (name);
#line 285 "ease-editor-window.vala"
		return result;
#line 461 "ease-editor-window.c"
	}
	result = TRUE;
	_g_object_unref0 (dialog);
	_g_free0 (name);
#line 289 "ease-editor-window.vala"
	return result;
#line 468 "ease-editor-window.c"
}


#line 259 "ease-editor-window.vala"
static gboolean __lambda54__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
#line 474 "ease-editor-window.c"
	gboolean result;
	result = _lambda54_ (_sender, event, self);
	return result;
}


#line 181 "ease-editor-window.vala"
EaseEditorWindow* ease_editor_window_construct (GType object_type, EaseDocument* doc) {
#line 483 "ease-editor-window.c"
	EaseEditorWindow * self;
	EaseDocument* _tmp0_;
	GtkBuilder* builder;
	GObject* _tmp3_;
	GObject* _tmp4_;
	GtkBin* _tmp5_;
	GObject* _tmp6_;
	GtkWidget* _tmp7_;
	GObject* _tmp8_;
	GtkRadioMenuItem* _tmp9_;
	GObject* _tmp10_;
	GtkRadioMenuItem* _tmp11_;
	GObject* _tmp12_;
	GtkCheckMenuItem* _tmp13_;
	EaseSlideButtonPanel* _tmp14_;
	GObject* _tmp15_;
	EaseUndoController* _tmp16_;
	GObject* _tmp17_;
	GtkToolButton* _tmp18_;
	GObject* _tmp19_;
	GtkToolButton* _tmp20_;
	EaseEditorEmbed* _tmp21_;
	GObject* _tmp22_;
	EaseInspector* _tmp23_;
	GObject* _tmp24_;
	GObject* _tmp25_;
	GObject* _tmp26_;
	EaseZoomSlider* _tmp27_;
	GObject* _tmp28_;
	GtkMenuShell* menu;
	GObject* _tmp31_;
	EaseSlide* _tmp32_;
	GError * _inner_error_ = NULL;
#line 181 "ease-editor-window.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 519 "ease-editor-window.c"
	self = g_object_newv (object_type, 0, NULL);
#line 183 "ease-editor-window.vala"
	gtk_window_set_title ((GtkWindow*) self, "Ease");
#line 184 "ease-editor-window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, 1024, 768);
#line 186 "ease-editor-window.vala"
	self->document = (_tmp0_ = _g_object_ref0 (doc), _g_object_unref0 (self->document), _tmp0_);
#line 187 "ease-editor-window.vala"
	g_signal_connect_object ((EaseUndoSource*) self->document, "undo", (GCallback) _ease_editor_window_add_undo_action_ease_undo_source_undo, self, 0);
#line 189 "ease-editor-window.vala"
	builder = gtk_builder_new ();
#line 531 "ease-editor-window.c"
	{
		char* _tmp1_;
		char* _tmp2_;
#line 192 "ease-editor-window.vala"
		gtk_builder_add_from_file (builder, _tmp2_ = ease_data_path (_tmp1_ = g_build_filename (EASE_TEMP_UI_DIR, EASE_EDITOR_WINDOW_UI_FILE_PATH, NULL)), &_inner_error_);
#line 537 "ease-editor-window.c"
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 195 "ease-editor-window.vala"
			g_error ("ease-editor-window.vala:195: Error loading UI: %s", e->message);
#line 553 "ease-editor-window.c"
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 197 "ease-editor-window.vala"
	gtk_builder_connect_signals (builder, self);
#line 198 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) (_tmp3_ = gtk_builder_get_object (builder, "Editor Widget"), GTK_IS_VBOX (_tmp3_) ? ((GtkVBox*) _tmp3_) : NULL));
#line 199 "ease-editor-window.vala"
	self->priv->main_bin = (_tmp5_ = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (builder, "main-align"), GTK_IS_BIN (_tmp4_) ? ((GtkBin*) _tmp4_) : NULL)), _g_object_unref0 (self->priv->main_bin), _tmp5_);
#line 200 "ease-editor-window.vala"
	self->priv->editor = (_tmp7_ = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (builder, "editor"), GTK_IS_WIDGET (_tmp6_) ? ((GtkWidget*) _tmp6_) : NULL)), _g_object_unref0 (self->priv->editor), _tmp7_);
#line 201 "ease-editor-window.vala"
	self->priv->show_sorter = (_tmp9_ = _g_object_ref0 ((_tmp8_ = gtk_builder_get_object (builder, "slide-sorter-radio"), GTK_IS_RADIO_MENU_ITEM (_tmp8_) ? ((GtkRadioMenuItem*) _tmp8_) : NULL)), _g_object_unref0 (self->priv->show_sorter), _tmp9_);
#line 203 "ease-editor-window.vala"
	self->priv->show_editor = (_tmp11_ = _g_object_ref0 ((_tmp10_ = gtk_builder_get_object (builder, "editor-radio"), GTK_IS_RADIO_MENU_ITEM (_tmp10_) ? ((GtkRadioMenuItem*) _tmp10_) : NULL)), _g_object_unref0 (self->priv->show_editor), _tmp11_);
#line 204 "ease-editor-window.vala"
	self->priv->zoom_fit = (_tmp13_ = _g_object_ref0 ((_tmp12_ = gtk_builder_get_object (builder, "Zoom Fit"), GTK_IS_CHECK_MENU_ITEM (_tmp12_) ? ((GtkCheckMenuItem*) _tmp12_) : NULL)), _g_object_unref0 (self->priv->zoom_fit), _tmp13_);
#line 207 "ease-editor-window.vala"
	self->slide_button_panel = (_tmp14_ = g_object_ref_sink (ease_slide_button_panel_new (self->document, self)), _g_object_unref0 (self->slide_button_panel), _tmp14_);
#line 208 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) (_tmp15_ = gtk_builder_get_object (builder, "Slides Align"), GTK_IS_ALIGNMENT (_tmp15_) ? ((GtkAlignment*) _tmp15_) : NULL), (GtkWidget*) self->slide_button_panel);
#line 212 "ease-editor-window.vala"
	self->priv->undo = (_tmp16_ = ease_undo_controller_new (), _g_object_unref0 (self->priv->undo), _tmp16_);
#line 213 "ease-editor-window.vala"
	self->priv->undo_button = (_tmp18_ = _g_object_ref0 ((_tmp17_ = gtk_builder_get_object (builder, "Undo"), GTK_IS_TOOL_BUTTON (_tmp17_) ? ((GtkToolButton*) _tmp17_) : NULL)), _g_object_unref0 (self->priv->undo_button), _tmp18_);
#line 214 "ease-editor-window.vala"
	self->priv->redo_button = (_tmp20_ = _g_object_ref0 ((_tmp19_ = gtk_builder_get_object (builder, "Redo"), GTK_IS_TOOL_BUTTON (_tmp19_) ? ((GtkToolButton*) _tmp19_) : NULL)), _g_object_unref0 (self->priv->redo_button), _tmp20_);
#line 217 "ease-editor-window.vala"
	self->embed = (_tmp21_ = g_object_ref_sink (ease_editor_embed_new (self->document, self)), _g_object_unref0 (self->embed), _tmp21_);
#line 218 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) (_tmp22_ = gtk_builder_get_object (builder, "Embed Align"), GTK_IS_ALIGNMENT (_tmp22_) ? ((GtkAlignment*) _tmp22_) : NULL), (GtkWidget*) self->embed);
#line 219 "ease-editor-window.vala"
	g_signal_connect_object ((EaseUndoSource*) self->embed, "undo", (GCallback) _ease_editor_window_add_undo_action_ease_undo_source_undo, self, 0);
#line 222 "ease-editor-window.vala"
	self->priv->inspector = (_tmp23_ = g_object_ref_sink (ease_inspector_new (self->document)), _g_object_unref0 (self->priv->inspector), _tmp23_);
#line 223 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) (_tmp24_ = gtk_builder_get_object (builder, "Inspector Align"), GTK_IS_ALIGNMENT (_tmp24_) ? ((GtkAlignment*) _tmp24_) : NULL), (GtkWidget*) self->priv->inspector);
#line 224 "ease-editor-window.vala"
	gtk_widget_set_visible ((GtkWidget*) self->priv->inspector, EASE_EDITOR_WINDOW_INSPECTOR_VISIBLE_DEFAULT);
#line 225 "ease-editor-window.vala"
	gtk_toggle_tool_button_set_active ((_tmp25_ = gtk_builder_get_object (builder, "Show Inspector"), GTK_IS_TOGGLE_TOOL_BUTTON (_tmp25_) ? ((GtkToggleToolButton*) _tmp25_) : NULL), gtk_widget_get_visible ((GtkWidget*) self->priv->inspector));
#line 227 "ease-editor-window.vala"
	g_signal_connect_object (self->embed, "element-selected", (GCallback) _ease_inspector_element_pane_on_element_selected_ease_editor_embed_element_selected, self->priv->inspector->element_pane, 0);
#line 229 "ease-editor-window.vala"
	g_signal_connect_object (self->embed, "element-deselected", (GCallback) _ease_inspector_element_pane_on_element_deselected_ease_editor_embed_element_deselected, self->priv->inspector->element_pane, 0);
#line 233 "ease-editor-window.vala"
	gtk_container_add ((GtkContainer*) (_tmp26_ = gtk_builder_get_object (builder, "Zoom Slider Item"), GTK_IS_TOOL_ITEM (_tmp26_) ? ((GtkToolItem*) _tmp26_) : NULL), (GtkWidget*) (_tmp27_ = ease_editor_window_create_zoom_slider (self)));
#line 608 "ease-editor-window.c"
	_g_object_unref0 (_tmp27_);
#line 237 "ease-editor-window.vala"
	menu = _g_object_ref0 ((_tmp28_ = gtk_builder_get_object (builder, "add-slide-menu"), GTK_IS_MENU_SHELL (_tmp28_) ? ((GtkMenuShell*) _tmp28_) : NULL));
#line 612 "ease-editor-window.c"
	{
		const char** master_collection;
		int master_collection_length1;
		int master_it;
#line 239 "ease-editor-window.vala"
		master_collection = EASE_THEME_MASTER_SLIDES;
#line 619 "ease-editor-window.c"
		master_collection_length1 = G_N_ELEMENTS (EASE_THEME_MASTER_SLIDES);
		for (master_it = 0; master_it < G_N_ELEMENTS (EASE_THEME_MASTER_SLIDES); master_it = master_it + 1) {
			const char* master;
			master = master_collection[master_it];
			{
				char* _tmp29_;
				GtkMenuItem* _tmp30_;
				GtkMenuItem* item;
#line 241 "ease-editor-window.vala"
				item = (_tmp30_ = g_object_ref_sink ((GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp29_ = ease_theme_master_mnemonic_description (master))), _g_free0 (_tmp29_), _tmp30_);
#line 243 "ease-editor-window.vala"
				gtk_menu_shell_append (menu, (GtkWidget*) item);
#line 245 "ease-editor-window.vala"
				g_signal_connect_object (item, "activate", (GCallback) _ease_editor_window_on_new_slide_menu_gtk_menu_item_activate, self, 0);
#line 634 "ease-editor-window.c"
				_g_object_unref0 (item);
			}
		}
	}
#line 247 "ease-editor-window.vala"
	gtk_widget_show_all ((GtkWidget*) menu);
#line 250 "ease-editor-window.vala"
	gtk_widget_show_all ((GtkWidget*) self->slide_button_panel);
#line 251 "ease-editor-window.vala"
	gtk_widget_show_all ((GtkWidget*) self->embed);
#line 252 "ease-editor-window.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 253 "ease-editor-window.vala"
	ease_editor_window_set_slides_shown (self, TRUE);
#line 256 "ease-editor-window.vala"
	gtk_window_add_accel_group ((GtkWindow*) self, (_tmp31_ = gtk_builder_get_object (builder, "accel-group"), GTK_IS_ACCEL_GROUP (_tmp31_) ? ((GtkAccelGroup*) _tmp31_) : NULL));
#line 259 "ease-editor-window.vala"
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __lambda54__gtk_widget_delete_event, self, 0);
#line 292 "ease-editor-window.vala"
	ease_slide_button_panel_select_slide (self->slide_button_panel, _tmp32_ = ease_document_get_slide (self->document, 0));
#line 655 "ease-editor-window.c"
	_g_object_unref0 (_tmp32_);
#line 293 "ease-editor-window.vala"
	ease_editor_window_update_undo (self);
#line 659 "ease-editor-window.c"
	_g_object_unref0 (menu);
	_g_object_unref0 (builder);
	return self;
}


#line 181 "ease-editor-window.vala"
EaseEditorWindow* ease_editor_window_new (EaseDocument* doc) {
#line 181 "ease-editor-window.vala"
	return ease_editor_window_construct (EASE_TYPE_EDITOR_WINDOW, doc);
#line 670 "ease-editor-window.c"
}


/**
 * Load a slide into the main {@link EditorEmbed}.
 *
 * @param filename The index of the slide.
 */
#line 301 "ease-editor-window.vala"
void ease_editor_window_set_slide (EaseEditorWindow* self, gint index) {
#line 681 "ease-editor-window.c"
	EaseSlide* _tmp0_;
#line 301 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 685 "ease-editor-window.c"
	{
		EaseSlideIterator* _element_it;
#line 304 "ease-editor-window.vala"
		_element_it = ease_slide_iterator (self->slide);
#line 304 "ease-editor-window.vala"
		while (TRUE) {
#line 692 "ease-editor-window.c"
			EaseElement* element;
#line 304 "ease-editor-window.vala"
			if (!ease_slide_iterator_next (_element_it)) {
#line 304 "ease-editor-window.vala"
				break;
#line 698 "ease-editor-window.c"
			}
#line 304 "ease-editor-window.vala"
			element = ease_slide_iterator_get (_element_it);
#line 306 "ease-editor-window.vala"
			ease_element_cairo_free_cache (element);
#line 704 "ease-editor-window.c"
			_g_object_unref0 (element);
		}
		_ease_slide_iterator_unref0 (_element_it);
	}
#line 310 "ease-editor-window.vala"
	self->slide = (_tmp0_ = ease_document_get_slide (self->document, index), _g_object_unref0 (self->slide), _tmp0_);
#line 313 "ease-editor-window.vala"
	ease_inspector_set_slide (self->priv->inspector, self->slide);
#line 314 "ease-editor-window.vala"
	ease_editor_embed_set_slide (self->embed, self->slide);
#line 715 "ease-editor-window.c"
}


/**
 * Add the most recent action to the {@link UndoController}.
 *
 * @param action The new {@link UndoItem}.
 */
#line 322 "ease-editor-window.vala"
void ease_editor_window_add_undo_action (EaseEditorWindow* self, EaseUndoItem* action) {
#line 322 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 322 "ease-editor-window.vala"
	g_return_if_fail (action != NULL);
#line 324 "ease-editor-window.vala"
	ease_undo_controller_add_action (self->priv->undo, action);
#line 325 "ease-editor-window.vala"
	ease_undo_controller_clear_redo (self->priv->undo);
#line 326 "ease-editor-window.vala"
	ease_editor_window_update_undo (self);
#line 329 "ease-editor-window.vala"
	if (self->priv->last_saved == 0) {
#line 331 "ease-editor-window.vala"
		self->priv->last_saved = (glong) time (NULL);
#line 740 "ease-editor-window.c"
	}
}


/**
 * Updates the undo and redo items, enabling and disabling them as is
 * applicable.
 */
#line 339 "ease-editor-window.vala"
static void ease_editor_window_update_undo (EaseEditorWindow* self) {
#line 339 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 341 "ease-editor-window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->undo_button, ease_undo_controller_can_undo (self->priv->undo));
#line 342 "ease-editor-window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->redo_button, ease_undo_controller_can_redo (self->priv->undo));
#line 757 "ease-editor-window.c"
}


#line 347 "ease-editor-window.vala"
void ease_editor_window_on_open (GtkWidget* sender, EaseEditorWindow* self) {
#line 763 "ease-editor-window.c"
	char* filename;
#line 347 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 347 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 349 "ease-editor-window.vala"
	filename = ease_dialog_open_document ((GtkWindow*) self);
#line 350 "ease-editor-window.vala"
	if (filename != NULL) {
#line 350 "ease-editor-window.vala"
		ease_main_open_file (filename);
#line 775 "ease-editor-window.c"
	}
	_g_free0 (filename);
}


#line 355 "ease-editor-window.vala"
void ease_editor_window_on_quit (GtkWidget* sender, EaseEditorWindow* self) {
#line 355 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 355 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 357 "ease-editor-window.vala"
	gtk_main_quit ();
#line 789 "ease-editor-window.c"
}


#line 361 "ease-editor-window.vala"
void ease_editor_window_on_delete (GtkWidget* sender, EaseEditorWindow* self) {
#line 795 "ease-editor-window.c"
	gint i;
#line 361 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 361 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 363 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 363 "ease-editor-window.vala"
		return;
#line 805 "ease-editor-window.c"
	}
#line 365 "ease-editor-window.vala"
	i = ease_slide_index_of (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 366 "ease-editor-window.vala"
	ease_slide_remove_at (self->slide, i);
#line 811 "ease-editor-window.c"
}


#line 370 "ease-editor-window.vala"
void ease_editor_window_new_slide_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 817 "ease-editor-window.c"
	EaseSlide* s;
	gint index;
#line 370 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 372 "ease-editor-window.vala"
	s = ease_theme_create_slide (ease_document_get_theme (self->document), EASE_DOCUMENT_DEFAULT_SLIDE, ease_slide_get_width (self->slide), ease_slide_get_height (self->slide));
#line 376 "ease-editor-window.vala"
	index = ease_document_index_of (self->document, self->slide) + 1;
#line 378 "ease-editor-window.vala"
	ease_document_add_slide (self->document, index, s);
#line 828 "ease-editor-window.c"
	_g_object_unref0 (s);
}


#line 382 "ease-editor-window.vala"
void ease_editor_window_on_new_slide_menu (GtkWidget* sender, EaseEditorWindow* self) {
#line 835 "ease-editor-window.c"
	GtkWidget* _tmp0_;
	GtkMenuItem* item;
	char* _tmp1_;
	EaseSlide* _tmp2_;
	EaseSlide* s;
	gint index;
#line 382 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 384 "ease-editor-window.vala"
	item = _g_object_ref0 ((_tmp0_ = sender, GTK_IS_MENU_ITEM (_tmp0_) ? ((GtkMenuItem*) _tmp0_) : NULL));
#line 385 "ease-editor-window.vala"
	s = (_tmp2_ = ease_theme_create_slide (ease_document_get_theme (self->document), _tmp1_ = ease_theme_master_from_description (gtk_menu_item_get_label (item)), ease_slide_get_width (self->slide), ease_slide_get_height (self->slide)), _g_free0 (_tmp1_), _tmp2_);
#line 389 "ease-editor-window.vala"
	index = ease_document_index_of (self->document, self->slide) + 1;
#line 391 "ease-editor-window.vala"
	ease_document_add_slide (self->document, index, s);
#line 852 "ease-editor-window.c"
	_g_object_unref0 (s);
	_g_object_unref0 (item);
}


#line 395 "ease-editor-window.vala"
void ease_editor_window_remove_slide (GtkWidget* sender, EaseEditorWindow* self) {
#line 860 "ease-editor-window.c"
	EaseSlide* _tmp0_;
#line 395 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 398 "ease-editor-window.vala"
	if (ease_document_get_length (self->document) < 2) {
#line 398 "ease-editor-window.vala"
		return;
#line 868 "ease-editor-window.c"
	}
#line 401 "ease-editor-window.vala"
	if (self->priv->sorter != NULL) {
#line 872 "ease-editor-window.c"
		EaseSlide* s;
#line 403 "ease-editor-window.vala"
		s = ease_slide_sorter_delete_slide (self->priv->sorter);
#line 404 "ease-editor-window.vala"
		if (s != NULL) {
#line 404 "ease-editor-window.vala"
			ease_slide_button_panel_select_slide (self->slide_button_panel, s);
#line 880 "ease-editor-window.c"
		}
		_g_object_unref0 (s);
#line 405 "ease-editor-window.vala"
		return;
#line 885 "ease-editor-window.c"
	}
#line 409 "ease-editor-window.vala"
	ease_slide_button_panel_select_slide (self->slide_button_panel, _tmp0_ = ease_document_remove_slide (self->document, self->slide));
#line 889 "ease-editor-window.c"
	_g_object_unref0 (_tmp0_);
}


#line 413 "ease-editor-window.vala"
void ease_editor_window_play_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 413 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 413 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 415 "ease-editor-window.vala"
	g_signal_emit_by_name (self, "play", self->document);
#line 902 "ease-editor-window.c"
}


#line 419 "ease-editor-window.vala"
void ease_editor_window_undo_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 419 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 419 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 421 "ease-editor-window.vala"
	ease_undo_controller_undo (self->priv->undo);
#line 422 "ease-editor-window.vala"
	ease_editor_window_update_undo (self);
#line 427 "ease-editor-window.vala"
	g_signal_emit_by_name (self->slide, "changed", self->slide);
#line 918 "ease-editor-window.c"
}


#line 431 "ease-editor-window.vala"
void ease_editor_window_redo_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 431 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 431 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 433 "ease-editor-window.vala"
	ease_undo_controller_redo (self->priv->undo);
#line 434 "ease-editor-window.vala"
	ease_editor_window_update_undo (self);
#line 439 "ease-editor-window.vala"
	g_signal_emit_by_name (self->slide, "changed", self->slide);
#line 934 "ease-editor-window.c"
}


#line 443 "ease-editor-window.vala"
void ease_editor_window_insert_text (GtkWidget* sender, EaseEditorWindow* self) {
#line 940 "ease-editor-window.c"
	EaseTextElement* text;
#line 443 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 443 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 445 "ease-editor-window.vala"
	text = ease_theme_create_custom_text (ease_document_get_theme (self->document));
#line 446 "ease-editor-window.vala"
	ease_element_set_x ((EaseElement*) text, (ease_slide_get_width (self->slide) / 2) - (ease_element_get_width ((EaseElement*) text) / 2));
#line 447 "ease-editor-window.vala"
	ease_element_set_y ((EaseElement*) text, (ease_slide_get_height (self->slide) / 2) - (ease_element_get_height ((EaseElement*) text) / 2));
#line 448 "ease-editor-window.vala"
	ease_slide_append (self->slide, (EaseElement*) text);
#line 449 "ease-editor-window.vala"
	ease_editor_embed_select_element (self->embed, (EaseElement*) text);
#line 956 "ease-editor-window.c"
	_g_object_unref0 (text);
}


#line 455 "ease-editor-window.vala"
static void _lambda68_ (GtkFileChooserDialog* dialog, EaseEditorWindow* self) {
#line 963 "ease-editor-window.c"
	GtkFileFilter* filter;
	GtkFileFilter* _tmp0_;
#line 455 "ease-editor-window.vala"
	g_return_if_fail (dialog != NULL);
#line 457 "ease-editor-window.vala"
	filter = g_object_ref_sink (gtk_file_filter_new ());
#line 458 "ease-editor-window.vala"
	gtk_file_filter_add_pixbuf_formats (filter);
#line 459 "ease-editor-window.vala"
	gtk_file_filter_set_name (filter, _ ("Images"));
#line 460 "ease-editor-window.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 463 "ease-editor-window.vala"
	filter = (_tmp0_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (filter), _tmp0_);
#line 464 "ease-editor-window.vala"
	gtk_file_filter_set_name (filter, _ ("All Files"));
#line 465 "ease-editor-window.vala"
	gtk_file_filter_add_pattern (filter, "*");
#line 466 "ease-editor-window.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 984 "ease-editor-window.c"
	_g_object_unref0 (filter);
}


#line 455 "ease-editor-window.vala"
static void __lambda68__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self) {
#line 991 "ease-editor-window.c"
	_lambda68_ (d, self);
}


#line 453 "ease-editor-window.vala"
void ease_editor_window_insert_image (GtkWidget* sender, EaseEditorWindow* self) {
#line 998 "ease-editor-window.c"
	char* filename;
#line 453 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 453 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 455 "ease-editor-window.vala"
	filename = ease_dialog_open_ext (_ ("Insert Image"), (GtkWindow*) self, __lambda68__ease_dialog_file_chooser_dialog_extension, self);
#line 469 "ease-editor-window.vala"
	if (filename != NULL) {
#line 471 "ease-editor-window.vala"
		ease_editor_window_insert_image_actual (self, filename);
#line 1010 "ease-editor-window.c"
	}
	_g_free0 (filename);
}


#line 475 "ease-editor-window.vala"
void ease_editor_window_insert_image_actual (EaseEditorWindow* self, const char* filename) {
#line 1018 "ease-editor-window.c"
	GError * _inner_error_ = NULL;
#line 475 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 475 "ease-editor-window.vala"
	g_return_if_fail (filename != NULL);
#line 1024 "ease-editor-window.c"
	{
		ClutterTexture* img;
		EaseImageElement* e;
		gint width;
		gint height;
		char* _tmp0_;
		char* _tmp1_;
#line 479 "ease-editor-window.vala"
		img = g_object_ref_sink (clutter_texture_new_from_file (filename, &_inner_error_));
#line 1034 "ease-editor-window.c"
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
#line 480 "ease-editor-window.vala"
		e = ease_image_element_new ();
#line 483 "ease-editor-window.vala"
		width = 0;
#line 483 "ease-editor-window.vala"
		height = 0;
#line 484 "ease-editor-window.vala"
		clutter_texture_get_base_size (img, &width, &height);
#line 486 "ease-editor-window.vala"
		if (width > ease_document_get_width (self->document)) {
#line 1048 "ease-editor-window.c"
			float factor;
#line 488 "ease-editor-window.vala"
			factor = ease_document_get_width (self->document) / ((float) width);
#line 489 "ease-editor-window.vala"
			width = (gint) (factor * width);
#line 490 "ease-editor-window.vala"
			height = (gint) (factor * height);
#line 1056 "ease-editor-window.c"
		}
#line 493 "ease-editor-window.vala"
		if (height > ease_document_get_height (self->document)) {
#line 1060 "ease-editor-window.c"
			float factor;
#line 495 "ease-editor-window.vala"
			factor = ease_document_get_height (self->document) / ((float) height);
#line 496 "ease-editor-window.vala"
			width = (gint) (factor * width);
#line 497 "ease-editor-window.vala"
			height = (gint) (factor * height);
#line 1068 "ease-editor-window.c"
		}
#line 500 "ease-editor-window.vala"
		ease_element_set_width ((EaseElement*) e, (float) width);
#line 501 "ease-editor-window.vala"
		ease_element_set_height ((EaseElement*) e, (float) height);
#line 502 "ease-editor-window.vala"
		ease_element_set_x ((EaseElement*) e, (float) ((ease_slide_get_width (self->slide) / 2) - (width / 2)));
#line 503 "ease-editor-window.vala"
		ease_element_set_y ((EaseElement*) e, (float) ((ease_slide_get_height (self->slide) / 2) - (height / 2)));
#line 505 "ease-editor-window.vala"
		ease_element_set_element_type ((EaseElement*) e, EASE_SLIDE_IMAGE_TYPE);
#line 506 "ease-editor-window.vala"
		ease_element_set_identifier ((EaseElement*) e, EASE_THEME_CUSTOM_MEDIA);
#line 507 "ease-editor-window.vala"
		_tmp0_ = ease_document_add_media_file (self->document, filename, &_inner_error_);
#line 1084 "ease-editor-window.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (e);
			_g_object_unref0 (img);
			goto __catch2_g_error;
		}
#line 507 "ease-editor-window.vala"
		ease_media_element_set_filename ((EaseMediaElement*) e, _tmp1_ = _tmp0_);
#line 1092 "ease-editor-window.c"
		_g_free0 (_tmp1_);
#line 508 "ease-editor-window.vala"
		ease_media_element_set_source_filename ((EaseMediaElement*) e, filename);
#line 511 "ease-editor-window.vala"
		ease_slide_append (self->slide, (EaseElement*) e);
#line 512 "ease-editor-window.vala"
		ease_editor_embed_select_element (self->embed, (EaseElement*) e);
#line 1100 "ease-editor-window.c"
		_g_object_unref0 (e);
		_g_object_unref0 (img);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 516 "ease-editor-window.vala"
			ease_error_dialog (_ ("Error Inserting Image"), e->message);
#line 1113 "ease-editor-window.c"
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 521 "ease-editor-window.vala"
void ease_editor_window_insert_video (GtkWidget* sender, EaseEditorWindow* self) {
#line 1128 "ease-editor-window.c"
	char* filename;
	GError * _inner_error_ = NULL;
#line 521 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 521 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 523 "ease-editor-window.vala"
	filename = ease_dialog_open (_ ("Insert Video"), (GtkWindow*) self);
#line 525 "ease-editor-window.vala"
	if (filename != NULL) {
#line 1139 "ease-editor-window.c"
		{
			EaseVideoElement* e;
			char* _tmp0_;
			char* _tmp1_;
#line 529 "ease-editor-window.vala"
			e = ease_video_element_new ();
#line 532 "ease-editor-window.vala"
			ease_element_set_width ((EaseElement*) e, (float) 640);
#line 533 "ease-editor-window.vala"
			ease_element_set_height ((EaseElement*) e, (float) 480);
#line 534 "ease-editor-window.vala"
			ease_element_set_x ((EaseElement*) e, (ease_slide_get_width (self->slide) / 2) - (ease_element_get_width ((EaseElement*) e) / 2));
#line 535 "ease-editor-window.vala"
			ease_element_set_y ((EaseElement*) e, (ease_slide_get_height (self->slide) / 2) - (ease_element_get_height ((EaseElement*) e) / 2));
#line 537 "ease-editor-window.vala"
			ease_element_set_element_type ((EaseElement*) e, EASE_SLIDE_VIDEO_TYPE);
#line 538 "ease-editor-window.vala"
			ease_element_set_identifier ((EaseElement*) e, EASE_THEME_CUSTOM_MEDIA);
#line 539 "ease-editor-window.vala"
			_tmp0_ = ease_document_add_media_file (self->document, filename, &_inner_error_);
#line 1160 "ease-editor-window.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (e);
				goto __catch3_g_error;
			}
#line 539 "ease-editor-window.vala"
			ease_media_element_set_filename ((EaseMediaElement*) e, _tmp1_ = _tmp0_);
#line 1167 "ease-editor-window.c"
			_g_free0 (_tmp1_);
#line 540 "ease-editor-window.vala"
			ease_media_element_set_source_filename ((EaseMediaElement*) e, filename);
#line 543 "ease-editor-window.vala"
			ease_slide_append (self->slide, (EaseElement*) e);
#line 544 "ease-editor-window.vala"
			ease_editor_embed_select_element (self->embed, (EaseElement*) e);
#line 1175 "ease-editor-window.c"
			_g_object_unref0 (e);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
#line 548 "ease-editor-window.vala"
				ease_error_dialog (_ ("Error Inserting Video"), e->message);
#line 1187 "ease-editor-window.c"
				_g_error_free0 (e);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (filename);
}


#line 557 "ease-editor-window.vala"
static void _lambda69_ (GtkFileChooserDialog* dialog, EaseEditorWindow* self) {
#line 1205 "ease-editor-window.c"
	GtkFileFilter* filter;
	GtkFileFilter* _tmp0_;
#line 557 "ease-editor-window.vala"
	g_return_if_fail (dialog != NULL);
#line 559 "ease-editor-window.vala"
	filter = g_object_ref_sink (gtk_file_filter_new ());
#line 560 "ease-editor-window.vala"
	gtk_file_filter_add_pattern (filter, "*.pdf");
#line 561 "ease-editor-window.vala"
	gtk_file_filter_add_pattern (filter, "*.PDF");
#line 562 "ease-editor-window.vala"
	gtk_file_filter_set_name (filter, _ ("PDF Documents"));
#line 563 "ease-editor-window.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 566 "ease-editor-window.vala"
	filter = (_tmp0_ = g_object_ref_sink (gtk_file_filter_new ()), _g_object_unref0 (filter), _tmp0_);
#line 567 "ease-editor-window.vala"
	gtk_file_filter_set_name (filter, _ ("All Files"));
#line 568 "ease-editor-window.vala"
	gtk_file_filter_add_pattern (filter, "*");
#line 569 "ease-editor-window.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) dialog, filter);
#line 1228 "ease-editor-window.c"
	_g_object_unref0 (filter);
}


#line 557 "ease-editor-window.vala"
static void __lambda69__ease_dialog_file_chooser_dialog_extension (GtkFileChooserDialog* d, gpointer self) {
#line 1235 "ease-editor-window.c"
	_lambda69_ (d, self);
}


#line 554 "ease-editor-window.vala"
void ease_editor_window_insert_pdf (GtkWidget* sender, EaseEditorWindow* self) {
#line 1242 "ease-editor-window.c"
	char* filename;
	GError * _inner_error_ = NULL;
#line 554 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 554 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 556 "ease-editor-window.vala"
	filename = ease_dialog_open_ext (_ ("Insert PDF Document"), (GtkWindow*) self, __lambda69__ease_dialog_file_chooser_dialog_extension, self);
#line 572 "ease-editor-window.vala"
	if (filename != NULL) {
#line 1253 "ease-editor-window.c"
		{
			EasePdfElement* e;
			char* _tmp0_;
			char* _tmp1_;
			PopplerDocument* _tmp2_;
			PopplerDocument* doc;
			PopplerPage* page;
			double width;
			double height;
			char* _tmp3_;
			char* _tmp4_;
#line 576 "ease-editor-window.vala"
			e = ease_pdf_element_new (filename);
#line 578 "ease-editor-window.vala"
			_tmp0_ = g_filename_to_uri (filename, NULL, &_inner_error_);
#line 1269 "ease-editor-window.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (e);
				goto __catch4_g_error;
			}
#line 577 "ease-editor-window.vala"
			doc = (_tmp2_ = poppler_document_new_from_file (_tmp1_ = _tmp0_, NULL, &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
#line 1276 "ease-editor-window.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (e);
				goto __catch4_g_error;
			}
#line 579 "ease-editor-window.vala"
			page = _g_object_ref0 (poppler_document_get_page (doc, 0));
#line 582 "ease-editor-window.vala"
			width = (double) 0;
#line 582 "ease-editor-window.vala"
			height = (double) 0;
#line 583 "ease-editor-window.vala"
			poppler_page_get_size (page, &width, &height);
#line 585 "ease-editor-window.vala"
			ease_element_set_width ((EaseElement*) e, (float) width);
#line 586 "ease-editor-window.vala"
			ease_element_set_height ((EaseElement*) e, (float) height);
#line 587 "ease-editor-window.vala"
			ease_element_set_x ((EaseElement*) e, (ease_slide_get_width (self->slide) / 2) - (ease_element_get_width ((EaseElement*) e) / 2));
#line 588 "ease-editor-window.vala"
			ease_element_set_y ((EaseElement*) e, (ease_slide_get_height (self->slide) / 2) - (ease_element_get_height ((EaseElement*) e) / 2));
#line 590 "ease-editor-window.vala"
			ease_element_set_element_type ((EaseElement*) e, EASE_SLIDE_PDF_TYPE);
#line 591 "ease-editor-window.vala"
			ease_element_set_identifier ((EaseElement*) e, EASE_THEME_CUSTOM_MEDIA);
#line 592 "ease-editor-window.vala"
			_tmp3_ = ease_document_add_media_file (self->document, filename, &_inner_error_);
#line 1303 "ease-editor-window.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (page);
				_g_object_unref0 (doc);
				_g_object_unref0 (e);
				goto __catch4_g_error;
			}
#line 592 "ease-editor-window.vala"
			ease_media_element_set_filename ((EaseMediaElement*) e, _tmp4_ = _tmp3_);
#line 1312 "ease-editor-window.c"
			_g_free0 (_tmp4_);
#line 593 "ease-editor-window.vala"
			ease_media_element_set_source_filename ((EaseMediaElement*) e, filename);
#line 596 "ease-editor-window.vala"
			ease_slide_append (self->slide, (EaseElement*) e);
#line 597 "ease-editor-window.vala"
			ease_editor_embed_select_element (self->embed, (EaseElement*) e);
#line 1320 "ease-editor-window.c"
			_g_object_unref0 (page);
			_g_object_unref0 (doc);
			_g_object_unref0 (e);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
#line 601 "ease-editor-window.vala"
				ease_error_dialog (_ ("Error Inserting PDF"), e->message);
#line 1334 "ease-editor-window.c"
				_g_error_free0 (e);
			}
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (filename);
}


#line 475 "ease-editor-window.vala"
static void _ease_editor_window_insert_image_actual_ease_import_dialog_add_image (EaseImportDialog* _sender, const char* filename, gpointer self) {
#line 1352 "ease-editor-window.c"
	ease_editor_window_insert_image_actual (self, filename);
}


#line 607 "ease-editor-window.vala"
void ease_editor_window_on_insert_web_media (GtkWidget* sender, EaseEditorWindow* self) {
#line 1359 "ease-editor-window.c"
	EaseImportDialog* dialog;
#line 607 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 607 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 609 "ease-editor-window.vala"
	dialog = g_object_ref_sink (ease_import_dialog_new ());
#line 611 "ease-editor-window.vala"
	g_signal_connect_object (dialog, "add-image", (GCallback) _ease_editor_window_insert_image_actual_ease_import_dialog_add_image, self, 0);
#line 613 "ease-editor-window.vala"
	ease_import_dialog_run (dialog);
#line 1371 "ease-editor-window.c"
	_g_object_unref0 (dialog);
}


#line 617 "ease-editor-window.vala"
void ease_editor_window_on_insert_rectangle (GtkWidget* sender, EaseEditorWindow* self) {
#line 1378 "ease-editor-window.c"
	EaseShapeElement* rect;
#line 617 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 617 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 619 "ease-editor-window.vala"
	rect = ease_shape_element_new (EASE_SHAPE_TYPE_RECTANGLE);
#line 620 "ease-editor-window.vala"
	ease_element_set_width ((EaseElement*) rect, (float) 400);
#line 621 "ease-editor-window.vala"
	ease_element_set_height ((EaseElement*) rect, (float) 300);
#line 622 "ease-editor-window.vala"
	ease_element_set_x ((EaseElement*) rect, (ease_document_get_width (self->document) / 2) - (ease_element_get_width ((EaseElement*) rect) / 2));
#line 623 "ease-editor-window.vala"
	ease_element_set_y ((EaseElement*) rect, (ease_document_get_height (self->document) / 2) - (ease_element_get_height ((EaseElement*) rect) / 2));
#line 624 "ease-editor-window.vala"
	ease_slide_append (self->slide, (EaseElement*) rect);
#line 625 "ease-editor-window.vala"
	ease_editor_embed_select_element (self->embed, (EaseElement*) rect);
#line 1398 "ease-editor-window.c"
	_g_object_unref0 (rect);
}


#line 629 "ease-editor-window.vala"
void ease_editor_window_on_insert_oval (GtkWidget* sender, EaseEditorWindow* self) {
#line 1405 "ease-editor-window.c"
	EaseShapeElement* oval;
#line 629 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 629 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 631 "ease-editor-window.vala"
	oval = ease_shape_element_new (EASE_SHAPE_TYPE_OVAL);
#line 632 "ease-editor-window.vala"
	ease_element_set_width ((EaseElement*) oval, (float) 300);
#line 633 "ease-editor-window.vala"
	ease_element_set_height ((EaseElement*) oval, (float) 300);
#line 634 "ease-editor-window.vala"
	ease_element_set_x ((EaseElement*) oval, (ease_document_get_width (self->document) / 2) - (ease_element_get_width ((EaseElement*) oval) / 2));
#line 635 "ease-editor-window.vala"
	ease_element_set_y ((EaseElement*) oval, (ease_document_get_height (self->document) / 2) - (ease_element_get_height ((EaseElement*) oval) / 2));
#line 636 "ease-editor-window.vala"
	ease_slide_append (self->slide, (EaseElement*) oval);
#line 637 "ease-editor-window.vala"
	ease_editor_embed_select_element (self->embed, (EaseElement*) oval);
#line 1425 "ease-editor-window.c"
	_g_object_unref0 (oval);
}


#line 97 "ease-slide-sorter.vala"
static void _ease_slide_sorter_on_slide_added_ease_document_slide_added (EaseDocument* _sender, EaseSlide* slide, gint index, gpointer self) {
#line 1432 "ease-editor-window.c"
	ease_slide_sorter_on_slide_added (self, slide, index);
}


static gint* _vala_array_dup1 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static gint* _vala_array_dup2 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


#line 691 "ease-editor-window.vala"
static void _lambda90_ (EaseSlide* s, EaseEditorWindow* self) {
#line 691 "ease-editor-window.vala"
	g_return_if_fail (s != NULL);
#line 692 "ease-editor-window.vala"
	ease_slide_button_panel_select_slide (self->slide_button_panel, s);
#line 693 "ease-editor-window.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) self->priv->show_editor, TRUE);
#line 1455 "ease-editor-window.c"
}


#line 691 "ease-editor-window.vala"
static void __lambda90__ease_slide_sorter_display_slide (EaseSlideSorter* _sender, EaseSlide* s, gpointer self) {
#line 1461 "ease-editor-window.c"
	_lambda90_ (s, self);
}


#line 641 "ease-editor-window.vala"
void ease_editor_window_set_view (GtkWidget* sender, EaseEditorWindow* self) {
#line 641 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 641 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 643 "ease-editor-window.vala"
	if (GTK_WIDGET (self->priv->show_editor) == sender) {
#line 1474 "ease-editor-window.c"
		guint _tmp0_;
		EaseSlideSorter* _tmp1_;
		gint* _tmp2_;
		gint* _tmp3_;
		EaseSlide* s;
#line 645 "ease-editor-window.vala"
		if (gtk_bin_get_child (self->priv->main_bin) == self->priv->editor) {
#line 645 "ease-editor-window.vala"
			return;
#line 1484 "ease-editor-window.c"
		}
#line 648 "ease-editor-window.vala"
		g_signal_parse_name ("slide-added", EASE_TYPE_DOCUMENT, &_tmp0_, NULL, FALSE);
#line 648 "ease-editor-window.vala"
		g_signal_handlers_disconnect_matched (self->document, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_slide_sorter_on_slide_added_ease_document_slide_added, self->priv->sorter);
#line 651 "ease-editor-window.vala"
		gtk_container_remove ((GtkContainer*) self->priv->main_bin, (GtkWidget*) self->priv->sorter);
#line 652 "ease-editor-window.vala"
		gtk_container_add ((GtkContainer*) self->priv->main_bin, self->priv->editor);
#line 653 "ease-editor-window.vala"
		self->priv->sorter = (_tmp1_ = NULL, _g_object_unref0 (self->priv->sorter), _tmp1_);
#line 656 "ease-editor-window.vala"
		((EaseZoomSlider*) self->zoom_slider)->values = (_tmp3_ = (_tmp2_ = self->priv->ZOOM_LEVELS, (_tmp2_ == NULL) ? ((gpointer) _tmp2_) : _vala_array_dup1 (_tmp2_, self->priv->ZOOM_LEVELS_length1)), ((EaseZoomSlider*) self->zoom_slider)->values = (g_free (((EaseZoomSlider*) self->zoom_slider)->values), NULL), ((EaseZoomSlider*) self->zoom_slider)->values_length1 = self->priv->ZOOM_LEVELS_length1, _tmp3_);
#line 657 "ease-editor-window.vala"
		ease_zoom_slider_set_adjustment ((EaseZoomSlider*) self->zoom_slider, self->priv->zoom_adjustment);
#line 658 "ease-editor-window.vala"
		ease_zoom_slider_set_update_policy ((EaseZoomSlider*) self->zoom_slider, GTK_UPDATE_CONTINUOUS);
#line 659 "ease-editor-window.vala"
		ease_animated_zoom_slider_set_animate (self->zoom_slider, TRUE);
#line 1504 "ease-editor-window.c"
		s = NULL;
		{
			EaseIterableTreeModelIterator* _itr_it;
#line 663 "ease-editor-window.vala"
			_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self->document));
#line 663 "ease-editor-window.vala"
			while (TRUE) {
#line 1512 "ease-editor-window.c"
				GtkTreeIter _tmp4_ = {0};
				GtkTreeIter itr;
#line 663 "ease-editor-window.vala"
				if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 663 "ease-editor-window.vala"
					break;
#line 1519 "ease-editor-window.c"
				}
#line 663 "ease-editor-window.vala"
				itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp4_), _tmp4_);
#line 666 "ease-editor-window.vala"
				gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self->document), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 669 "ease-editor-window.vala"
				gtk_list_store_set ((GtkListStore*) ease_document_get_slides (self->document), &itr, EASE_DOCUMENT_COL_PIXBUF_DYNAMIC, NULL, -1);
#line 1527 "ease-editor-window.c"
			}
			_ease_iterable_tree_model_iterator_unref0 (_itr_it);
		}
		_g_object_unref0 (s);
	} else {
#line 672 "ease-editor-window.vala"
		if (GTK_WIDGET (self->priv->show_sorter) == sender) {
#line 1535 "ease-editor-window.c"
			gint* _tmp6_;
			gint* _tmp7_;
#line 674 "ease-editor-window.vala"
			if (self->priv->sorter == NULL) {
#line 1540 "ease-editor-window.c"
				EaseSlideSorter* _tmp5_;
#line 676 "ease-editor-window.vala"
				self->priv->sorter = (_tmp5_ = g_object_ref_sink (ease_slide_sorter_new (self->document, gtk_adjustment_get_value (self->priv->sorter_zoom_adjustment) / 100.f)), _g_object_unref0 (self->priv->sorter), _tmp5_);
#line 1544 "ease-editor-window.c"
			}
#line 679 "ease-editor-window.vala"
			if (gtk_bin_get_child (self->priv->main_bin) == GTK_WIDGET (self->priv->sorter)) {
#line 679 "ease-editor-window.vala"
				return;
#line 1550 "ease-editor-window.c"
			}
#line 680 "ease-editor-window.vala"
			gtk_container_remove ((GtkContainer*) self->priv->main_bin, self->priv->editor);
#line 681 "ease-editor-window.vala"
			gtk_container_add ((GtkContainer*) self->priv->main_bin, (GtkWidget*) self->priv->sorter);
#line 682 "ease-editor-window.vala"
			gtk_widget_show_all ((GtkWidget*) self->priv->sorter);
#line 685 "ease-editor-window.vala"
			((EaseZoomSlider*) self->zoom_slider)->values = (_tmp7_ = (_tmp6_ = self->priv->SORTER_ZOOM_LEVELS, (_tmp6_ == NULL) ? ((gpointer) _tmp6_) : _vala_array_dup2 (_tmp6_, self->priv->SORTER_ZOOM_LEVELS_length1)), ((EaseZoomSlider*) self->zoom_slider)->values = (g_free (((EaseZoomSlider*) self->zoom_slider)->values), NULL), ((EaseZoomSlider*) self->zoom_slider)->values_length1 = self->priv->SORTER_ZOOM_LEVELS_length1, _tmp7_);
#line 686 "ease-editor-window.vala"
			ease_zoom_slider_set_adjustment ((EaseZoomSlider*) self->zoom_slider, self->priv->sorter_zoom_adjustment);
#line 687 "ease-editor-window.vala"
			ease_zoom_slider_set_update_policy ((EaseZoomSlider*) self->zoom_slider, GTK_UPDATE_DELAYED);
#line 688 "ease-editor-window.vala"
			ease_animated_zoom_slider_set_animate (self->zoom_slider, FALSE);
#line 691 "ease-editor-window.vala"
			g_signal_connect_object (self->priv->sorter, "display-slide", (GCallback) __lambda90__ease_slide_sorter_display_slide, self, 0);
#line 1568 "ease-editor-window.c"
		}
	}
}


#line 699 "ease-editor-window.vala"
void ease_editor_window_zoom_in (GtkWidget* sender, EaseEditorWindow* self) {
#line 699 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 699 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 701 "ease-editor-window.vala"
	ease_editor_embed_set_zoom_fit (self->embed, FALSE);
#line 702 "ease-editor-window.vala"
	gtk_check_menu_item_set_active (self->priv->zoom_fit, FALSE);
#line 703 "ease-editor-window.vala"
	ease_zoom_slider_zoom_in ((EaseZoomSlider*) self->zoom_slider);
#line 1586 "ease-editor-window.c"
}


#line 707 "ease-editor-window.vala"
void ease_editor_window_zoom_out (GtkWidget* sender, EaseEditorWindow* self) {
#line 707 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 707 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 709 "ease-editor-window.vala"
	ease_editor_embed_set_zoom_fit (self->embed, FALSE);
#line 710 "ease-editor-window.vala"
	gtk_check_menu_item_set_active (self->priv->zoom_fit, FALSE);
#line 711 "ease-editor-window.vala"
	ease_zoom_slider_zoom_out ((EaseZoomSlider*) self->zoom_slider);
#line 1602 "ease-editor-window.c"
}


#line 715 "ease-editor-window.vala"
void ease_editor_window_on_zoom_fit (GtkWidget* sender, EaseEditorWindow* self) {
#line 1608 "ease-editor-window.c"
	GtkWidget* _tmp0_;
#line 715 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 715 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 717 "ease-editor-window.vala"
	ease_editor_embed_set_zoom_fit (self->embed, gtk_check_menu_item_get_active ((_tmp0_ = sender, GTK_IS_CHECK_MENU_ITEM (_tmp0_) ? ((GtkCheckMenuItem*) _tmp0_) : NULL)));
#line 1616 "ease-editor-window.c"
}


#line 721 "ease-editor-window.vala"
gboolean ease_editor_window_save_document (GtkWidget* sender, EaseEditorWindow* self) {
#line 1622 "ease-editor-window.c"
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 721 "ease-editor-window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 723 "ease-editor-window.vala"
	if (ease_document_get_filename (self->document) == NULL) {
#line 1629 "ease-editor-window.c"
		char* filename;
#line 725 "ease-editor-window.vala"
		filename = ease_dialog_save_document (_ ("Save Document"), (GtkWindow*) self);
#line 727 "ease-editor-window.vala"
		if (filename != NULL) {
#line 729 "ease-editor-window.vala"
			ease_document_set_filename (self->document, filename);
#line 1637 "ease-editor-window.c"
		} else {
			result = FALSE;
			_g_free0 (filename);
#line 731 "ease-editor-window.vala"
			return result;
#line 1643 "ease-editor-window.c"
		}
		_g_free0 (filename);
	}
	{
#line 736 "ease-editor-window.vala"
		ease_document_to_json (self->document, (GtkWindow*) self, &_inner_error_);
#line 1650 "ease-editor-window.c"
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
#line 737 "ease-editor-window.vala"
		self->priv->last_saved = (glong) 0;
#line 1656 "ease-editor-window.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 741 "ease-editor-window.vala"
			ease_error_dialog (_ ("Error Saving Document"), e->message);
#line 1667 "ease-editor-window.c"
			result = FALSE;
			_g_error_free0 (e);
#line 742 "ease-editor-window.vala"
			return result;
#line 1672 "ease-editor-window.c"
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
#line 744 "ease-editor-window.vala"
	return result;
#line 1684 "ease-editor-window.c"
}


#line 749 "ease-editor-window.vala"
void ease_editor_window_export_as_pdf (GtkWidget* sender, EaseEditorWindow* self) {
#line 749 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 749 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 751 "ease-editor-window.vala"
	ease_document_export_as_pdf (self->document, (GtkWindow*) self);
#line 1696 "ease-editor-window.c"
}


#line 755 "ease-editor-window.vala"
void ease_editor_window_export_as_postscript (GtkWidget* sender, EaseEditorWindow* self) {
#line 755 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 755 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 757 "ease-editor-window.vala"
	ease_document_export_as_postscript (self->document, (GtkWindow*) self);
#line 1708 "ease-editor-window.c"
}


#line 761 "ease-editor-window.vala"
void ease_editor_window_export_as_html (GtkWidget* sender, EaseEditorWindow* self) {
#line 761 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 761 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 763 "ease-editor-window.vala"
	ease_document_export_as_html (self->document, (GtkWindow*) self);
#line 1720 "ease-editor-window.c"
}


#line 767 "ease-editor-window.vala"
void ease_editor_window_on_lower (GtkWidget* sender, EaseEditorWindow* self) {
#line 767 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 767 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 769 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 769 "ease-editor-window.vala"
		return;
#line 1734 "ease-editor-window.c"
	}
#line 770 "ease-editor-window.vala"
	ease_slide_lower (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 1738 "ease-editor-window.c"
}


#line 774 "ease-editor-window.vala"
void ease_editor_window_on_raise (GtkWidget* sender, EaseEditorWindow* self) {
#line 774 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 774 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 776 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 776 "ease-editor-window.vala"
		return;
#line 1752 "ease-editor-window.c"
	}
#line 777 "ease-editor-window.vala"
	ease_slide_raise (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 1756 "ease-editor-window.c"
}


#line 781 "ease-editor-window.vala"
void ease_editor_window_on_lower_bottom (GtkWidget* sender, EaseEditorWindow* self) {
#line 781 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 781 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 783 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 783 "ease-editor-window.vala"
		return;
#line 1770 "ease-editor-window.c"
	}
#line 784 "ease-editor-window.vala"
	ease_slide_lower_bottom (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 1774 "ease-editor-window.c"
}


#line 788 "ease-editor-window.vala"
void ease_editor_window_on_raise_top (GtkWidget* sender, EaseEditorWindow* self) {
#line 788 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 788 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 790 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 790 "ease-editor-window.vala"
		return;
#line 1788 "ease-editor-window.c"
	}
#line 791 "ease-editor-window.vala"
	ease_slide_raise_top (self->slide, ease_editor_embed_get_selected (self->embed)->element);
#line 1792 "ease-editor-window.c"
}


#line 795 "ease-editor-window.vala"
void ease_editor_window_inspector_clicked_handler (GtkWidget* sender, EaseEditorWindow* self) {
#line 1798 "ease-editor-window.c"
	GtkWidget* _tmp0_;
#line 795 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 797 "ease-editor-window.vala"
	gtk_widget_set_visible ((GtkWidget*) self->priv->inspector, gtk_toggle_tool_button_get_active ((_tmp0_ = sender, GTK_IS_TOGGLE_TOOL_BUTTON (_tmp0_) ? ((GtkToggleToolButton*) _tmp0_) : NULL)));
#line 1804 "ease-editor-window.c"
}


#line 867 "ease-editor-window.vala"
static void _ease_editor_window_color_dialog_changed_gtk_color_selection_color_changed (GtkColorSelection* _sender, gpointer self) {
#line 1810 "ease-editor-window.c"
	ease_editor_window_color_dialog_changed (self, _sender);
}


#line 874 "ease-editor-window.vala"
static void _ease_editor_window_color_dialog_selection_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 1817 "ease-editor-window.c"
	ease_editor_window_color_dialog_selection (self, _sender, pspec);
}


#line 830 "ease-editor-window.vala"
static void _lambda91_ (EaseEditorWindow* self) {
#line 1824 "ease-editor-window.c"
	guint _tmp0_;
	GQuark _tmp1_;
	guint _tmp2_;
	GtkColorSelectionDialog* _tmp3_;
#line 831 "ease-editor-window.vala"
	g_signal_parse_name ("notify::selected", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
#line 831 "ease-editor-window.vala"
	g_signal_handlers_disconnect_matched ((GObject*) self->embed, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _ease_editor_window_color_dialog_selection_g_object_notify, self);
#line 832 "ease-editor-window.vala"
	g_signal_parse_name ("color-changed", GTK_TYPE_COLOR_SELECTION, &_tmp2_, NULL, FALSE);
#line 832 "ease-editor-window.vala"
	g_signal_handlers_disconnect_matched (self->priv->color_selection, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _ease_editor_window_color_dialog_changed_gtk_color_selection_color_changed, self);
#line 833 "ease-editor-window.vala"
	gtk_object_destroy ((GtkObject*) self->priv->color_dialog);
#line 834 "ease-editor-window.vala"
	self->priv->color_dialog = (_tmp3_ = NULL, _g_object_unref0 (self->priv->color_dialog), _tmp3_);
#line 1841 "ease-editor-window.c"
}


#line 830 "ease-editor-window.vala"
static void __lambda91__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
#line 1847 "ease-editor-window.c"
	_lambda91_ (self);
}


static gboolean _clutter_color_equal (const ClutterColor* s1, const ClutterColor* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}


#line 838 "ease-editor-window.vala"
static void _lambda92_ (Block1Data* _data1_) {
#line 1880 "ease-editor-window.c"
	EaseEditorWindow * self;
	ClutterColor* _tmp0_;
	gboolean _tmp1_;
	self = _data1_->self;
#line 839 "ease-editor-window.vala"
	gtk_widget_hide ((GtkWidget*) self->priv->color_dialog);
#line 842 "ease-editor-window.vala"
	if ((_tmp1_ = _clutter_color_equal (_data1_->original_color, _tmp0_ = ease_element_get_color (ease_editor_embed_get_selected (self->embed)->element)) != TRUE, _g_free0 (_tmp0_), _tmp1_)) {
#line 844 "ease-editor-window.vala"
		ease_editor_window_add_undo_action (self, (EaseUndoItem*) self->priv->undo_action);
#line 1891 "ease-editor-window.c"
	}
}


#line 838 "ease-editor-window.vala"
static void __lambda92__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1898 "ease-editor-window.c"
	_lambda92_ (self);
}


#line 849 "ease-editor-window.vala"
static void _lambda93_ (Block1Data* _data1_) {
#line 1905 "ease-editor-window.c"
	EaseEditorWindow * self;
	self = _data1_->self;
#line 850 "ease-editor-window.vala"
	ease_element_set_color (ease_editor_embed_get_selected (self->embed)->element, _data1_->original_color);
#line 851 "ease-editor-window.vala"
	gtk_widget_hide ((GtkWidget*) self->priv->color_dialog);
#line 1912 "ease-editor-window.c"
}


#line 849 "ease-editor-window.vala"
static void __lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1918 "ease-editor-window.c"
	_lambda93_ (self);
}


#line 855 "ease-editor-window.vala"
static void _lambda94_ (EaseEditorWindow* self) {
#line 1925 "ease-editor-window.c"
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
#line 856 "ease-editor-window.vala"
	gtk_widget_activate (_tmp1_ = (g_object_get (self->priv->color_dialog, "cancel-button", &_tmp0_, NULL), _tmp0_));
#line 1930 "ease-editor-window.c"
	_g_object_unref0 (_tmp1_);
}


#line 855 "ease-editor-window.vala"
static void __lambda94__gtk_dialog_close (GtkDialog* _sender, gpointer self) {
#line 1937 "ease-editor-window.c"
	_lambda94_ (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_free0 (_data1_->original_color);
		g_slice_free (Block1Data, _data1_);
	}
}


#line 801 "ease-editor-window.vala"
void ease_editor_window_show_color_dialog (GtkWidget* sender, EaseEditorWindow* self) {
#line 1959 "ease-editor-window.c"
	Block1Data* _data1_;
	EaseUndoAction* _tmp0_;
	GtkColorSelectionDialog* _tmp1_;
	GtkWidget* _tmp2_;
	GtkColorSelection* _tmp3_;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_;
	GtkButton* _tmp6_;
	GtkWidget* _tmp7_ = NULL;
	GtkWidget* _tmp8_;
	GtkButton* _tmp9_;
#line 801 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 801 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 1975 "ease-editor-window.c"
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
#line 804 "ease-editor-window.vala"
	if (ease_editor_embed_get_selected (self->embed) == NULL) {
#line 1981 "ease-editor-window.c"
		block1_data_unref (_data1_);
#line 804 "ease-editor-window.vala"
		return;
#line 1985 "ease-editor-window.c"
	}
#line 807 "ease-editor-window.vala"
	if (self->priv->color_dialog != NULL) {
#line 809 "ease-editor-window.vala"
		gtk_window_present ((GtkWindow*) self->priv->color_dialog);
#line 1991 "ease-editor-window.c"
		block1_data_unref (_data1_);
#line 810 "ease-editor-window.vala"
		return;
#line 1995 "ease-editor-window.c"
	}
	_data1_->original_color = ease_element_get_color (ease_editor_embed_get_selected (self->embed)->element);
#line 817 "ease-editor-window.vala"
	self->priv->undo_action = (_tmp0_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self->embed)->element, "color"), _g_object_unref0 (self->priv->undo_action), _tmp0_);
#line 820 "ease-editor-window.vala"
	self->priv->color_dialog = (_tmp1_ = g_object_ref_sink ((GtkColorSelectionDialog*) gtk_color_selection_dialog_new (_ ("Select Color"))), _g_object_unref0 (self->priv->color_dialog), _tmp1_);
#line 821 "ease-editor-window.vala"
	self->priv->color_selection = (_tmp3_ = _g_object_ref0 ((_tmp2_ = gtk_color_selection_dialog_get_color_selection (self->priv->color_dialog), GTK_IS_COLOR_SELECTION (_tmp2_) ? ((GtkColorSelection*) _tmp2_) : NULL)), _g_object_unref0 (self->priv->color_selection), _tmp3_);
#line 824 "ease-editor-window.vala"
	g_signal_connect_object (self->priv->color_selection, "color-changed", (GCallback) _ease_editor_window_color_dialog_changed_gtk_color_selection_color_changed, self, 0);
#line 827 "ease-editor-window.vala"
	g_signal_connect_object ((GObject*) self->embed, "notify::selected", (GCallback) _ease_editor_window_color_dialog_selection_g_object_notify, self, 0);
#line 830 "ease-editor-window.vala"
	g_signal_connect_object ((GtkWidget*) self->priv->color_dialog, "hide", (GCallback) __lambda91__gtk_widget_hide, self, 0);
#line 838 "ease-editor-window.vala"
	g_signal_connect_data (_tmp6_ = (_tmp5_ = (g_object_get (self->priv->color_dialog, "ok-button", &_tmp4_, NULL), _tmp4_), GTK_IS_BUTTON (_tmp5_) ? ((GtkButton*) _tmp5_) : NULL), "clicked", (GCallback) __lambda92__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 2012 "ease-editor-window.c"
	_g_object_unref0 (_tmp6_);
#line 849 "ease-editor-window.vala"
	g_signal_connect_data (_tmp9_ = (_tmp8_ = (g_object_get (self->priv->color_dialog, "cancel-button", &_tmp7_, NULL), _tmp7_), GTK_IS_BUTTON (_tmp8_) ? ((GtkButton*) _tmp8_) : NULL), "clicked", (GCallback) __lambda93__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 2016 "ease-editor-window.c"
	_g_object_unref0 (_tmp9_);
#line 855 "ease-editor-window.vala"
	g_signal_connect_object ((GtkDialog*) self->priv->color_dialog, "close", (GCallback) __lambda94__gtk_dialog_close, self, 0);
#line 860 "ease-editor-window.vala"
	gtk_window_set_transient_for ((GtkWindow*) self->priv->color_dialog, (GtkWindow*) self);
#line 861 "ease-editor-window.vala"
	gtk_window_set_modal ((GtkWindow*) self->priv->color_dialog, TRUE);
#line 864 "ease-editor-window.vala"
	gtk_dialog_run ((GtkDialog*) self->priv->color_dialog);
#line 2026 "ease-editor-window.c"
	block1_data_unref (_data1_);
}


#line 867 "ease-editor-window.vala"
static void ease_editor_window_color_dialog_changed (EaseEditorWindow* self, GtkColorSelection* sender) {
#line 2033 "ease-editor-window.c"
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_;
	ClutterColor _tmp2_ = {0};
	ClutterColor _tmp3_;
#line 867 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 867 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 869 "ease-editor-window.vala"
	ease_editor_embed_set_element_color (self->embed, (_tmp3_ = (ease_transformations_gdk_color_to_clutter_color ((_tmp1_ = (gtk_color_selection_get_current_color (sender, &_tmp0_), _tmp0_), &_tmp1_), &_tmp2_), _tmp2_), &_tmp3_));
#line 871 "ease-editor-window.vala"
	g_signal_emit_by_name (self->slide, "changed", self->slide);
#line 2046 "ease-editor-window.c"
}


#line 874 "ease-editor-window.vala"
static void ease_editor_window_color_dialog_selection (EaseEditorWindow* self, GObject* sender, GParamSpec* spec) {
#line 2052 "ease-editor-window.c"
	GObject* _tmp0_;
	ClutterColor* color;
	GdkColor _tmp1_ = {0};
	GdkColor _tmp2_;
#line 874 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 874 "ease-editor-window.vala"
	g_return_if_fail (sender != NULL);
#line 874 "ease-editor-window.vala"
	g_return_if_fail (spec != NULL);
#line 876 "ease-editor-window.vala"
	color = ease_element_get_color (ease_editor_embed_get_selected ((_tmp0_ = sender, EASE_IS_EDITOR_EMBED (_tmp0_) ? ((EaseEditorEmbed*) _tmp0_) : NULL))->element);
#line 877 "ease-editor-window.vala"
	if (color == NULL) {
#line 2067 "ease-editor-window.c"
		_g_free0 (color);
#line 877 "ease-editor-window.vala"
		return;
#line 2071 "ease-editor-window.c"
	}
#line 879 "ease-editor-window.vala"
	gtk_color_selection_set_current_color (self->priv->color_selection, (_tmp2_ = (ease_transformations_clutter_color_to_gdk_color (color, &_tmp1_), _tmp1_), &_tmp2_));
#line 2075 "ease-editor-window.c"
	_g_free0 (color);
}


#line 884 "ease-editor-window.vala"
void ease_editor_window_select_font (GtkWidget* sender, EaseEditorWindow* self) {
#line 2082 "ease-editor-window.c"
	GtkFontSelectionDialog* font_selection;
	EaseElement* _tmp0_;
	EaseTextElement* text;
	const char* _tmp1_;
	PangoFontDescription* _tmp2_;
#line 884 "ease-editor-window.vala"
	g_return_if_fail (self != NULL);
#line 887 "ease-editor-window.vala"
	font_selection = g_object_ref_sink ((GtkFontSelectionDialog*) gtk_font_selection_dialog_new (_ ("Select Font")));
#line 890 "ease-editor-window.vala"
	text = _g_object_ref0 ((_tmp0_ = ease_editor_embed_get_selected (self->embed)->element, EASE_IS_TEXT_ELEMENT (_tmp0_) ? ((EaseTextElement*) _tmp0_) : NULL));
#line 2094 "ease-editor-window.c"
	_tmp1_ = NULL;
#line 893 "ease-editor-window.vala"
	if (_vala_strcmp0 (ease_text_element_get_text (text), "") != 0) {
#line 894 "ease-editor-window.vala"
		_tmp1_ = ease_text_element_get_text (text);
#line 2100 "ease-editor-window.c"
	} else {
#line 894 "ease-editor-window.vala"
		_tmp1_ = EASE_EDITOR_WINDOW_FONT_TEXT;
#line 2104 "ease-editor-window.c"
	}
#line 893 "ease-editor-window.vala"
	gtk_font_selection_dialog_set_preview_text (font_selection, _tmp1_);
#line 897 "ease-editor-window.vala"
	gtk_font_selection_dialog_set_font_name (font_selection, pango_font_description_to_string (_tmp2_ = ease_text_element_get_font_description (text)));
#line 2110 "ease-editor-window.c"
	_pango_font_description_free0 (_tmp2_);
#line 900 "ease-editor-window.vala"
	switch (gtk_dialog_run ((GtkDialog*) font_selection)) {
#line 2114 "ease-editor-window.c"
		case GTK_RESPONSE_OK:
		{
			EaseUndoAction* _tmp3_;
			PangoFontDescription* _tmp4_;
#line 904 "ease-editor-window.vala"
			ease_editor_window_add_undo_action (self, (EaseUndoItem*) (_tmp3_ = ease_undo_action_new ((GObject*) ease_editor_embed_get_selected (self->embed)->element, "font-description")));
#line 2121 "ease-editor-window.c"
			_g_object_unref0 (_tmp3_);
#line 908 "ease-editor-window.vala"
			ease_text_element_set_font_description (text, _tmp4_ = pango_font_description_from_string (gtk_font_selection_dialog_get_font_name (font_selection)));
#line 2125 "ease-editor-window.c"
			_pango_font_description_free0 (_tmp4_);
#line 913 "ease-editor-window.vala"
			g_signal_emit_by_name ((EaseElement*) text, "changed");
#line 914 "ease-editor-window.vala"
			break;
#line 2131 "ease-editor-window.c"
		}
	}
#line 917 "ease-editor-window.vala"
	gtk_object_destroy ((GtkObject*) font_selection);
#line 2136 "ease-editor-window.c"
	_g_object_unref0 (text);
	_g_object_unref0 (font_selection);
}


#line 931 "ease-editor-window.vala"
static void _lambda53_ (EaseEditorWindow* self) {
#line 933 "ease-editor-window.vala"
	if (self->priv->sorter == NULL) {
#line 935 "ease-editor-window.vala"
		ease_editor_embed_set_zoom_fit (self->embed, FALSE);
#line 936 "ease-editor-window.vala"
		gtk_check_menu_item_set_active (self->priv->zoom_fit, FALSE);
#line 937 "ease-editor-window.vala"
		ease_editor_embed_set_zoom (self->embed, ((float) ease_zoom_slider_get_value ((EaseZoomSlider*) self->zoom_slider)) / 100.f);
#line 2152 "ease-editor-window.c"
	} else {
#line 941 "ease-editor-window.vala"
		ease_slide_sorter_set_zoom (self->priv->sorter, ease_zoom_slider_get_value ((EaseZoomSlider*) self->zoom_slider) / 100.f);
#line 2156 "ease-editor-window.c"
	}
}


#line 931 "ease-editor-window.vala"
static void __lambda53__ease_zoom_slider_value_changed (EaseZoomSlider* _sender, gpointer self) {
#line 2163 "ease-editor-window.c"
	_lambda53_ (self);
}


#line 920 "ease-editor-window.vala"
static EaseZoomSlider* ease_editor_window_create_zoom_slider (EaseEditorWindow* self) {
#line 2170 "ease-editor-window.c"
	EaseZoomSlider* result = NULL;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	EaseAnimatedZoomSlider* _tmp2_;
#line 920 "ease-editor-window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 923 "ease-editor-window.vala"
	self->priv->zoom_adjustment = (_tmp0_ = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new ((double) 100, (double) 10, (double) 400, (double) 10, (double) 50, (double) 50)), _g_object_unref0 (self->priv->zoom_adjustment), _tmp0_);
#line 924 "ease-editor-window.vala"
	self->priv->sorter_zoom_adjustment = (_tmp1_ = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new ((double) 50, (double) 0, (double) 100, (double) 10, (double) 25, (double) 25)), _g_object_unref0 (self->priv->sorter_zoom_adjustment), _tmp1_);
#line 927 "ease-editor-window.vala"
	self->zoom_slider = (_tmp2_ = g_object_ref_sink (ease_animated_zoom_slider_new (self->priv->zoom_adjustment, self->priv->ZOOM_LEVELS, self->priv->ZOOM_LEVELS_length1)), _g_object_unref0 (self->zoom_slider), _tmp2_);
#line 928 "ease-editor-window.vala"
	ease_zoom_slider_set_value_pos ((EaseZoomSlider*) self->zoom_slider, GTK_POS_RIGHT);
#line 929 "ease-editor-window.vala"
	ease_zoom_slider_set_digits ((EaseZoomSlider*) self->zoom_slider, 0);
#line 931 "ease-editor-window.vala"
	g_signal_connect_object ((EaseZoomSlider*) self->zoom_slider, "value-changed", (GCallback) __lambda53__ease_zoom_slider_value_changed, self, 0);
#line 945 "ease-editor-window.vala"
	gtk_widget_show_all ((GtkWidget*) self->zoom_slider);
#line 2191 "ease-editor-window.c"
	result = _g_object_ref0 ((EaseZoomSlider*) self->zoom_slider);
#line 947 "ease-editor-window.vala"
	return result;
#line 2195 "ease-editor-window.c"
}


gboolean ease_editor_window_get_slides_shown (EaseEditorWindow* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_slides_shown;
#line 102 "ease-editor-window.vala"
	return result;
#line 2205 "ease-editor-window.c"
}


void ease_editor_window_set_slides_shown (EaseEditorWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_slides_shown = value;
	g_object_notify ((GObject *) self, "slides-shown");
}


static void ease_editor_window_class_init (EaseEditorWindowClass * klass) {
	ease_editor_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseEditorWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_editor_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_editor_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_editor_window_finalize;
	/**
	 * If the {@link SlideButtonPanel} is visible.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_EDITOR_WINDOW_SLIDES_SHOWN, g_param_spec_boolean ("slides-shown", "slides-shown", "slides-shown", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Emitted when the window's Document should be presented.
	 */
	g_signal_new ("play", EASE_TYPE_EDITOR_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_DOCUMENT);
	/**
	 * Emitted when the window should be closed.
	 */
	g_signal_new ("close", EASE_TYPE_EDITOR_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_EDITOR_WINDOW);
}


static void ease_editor_window_instance_init (EaseEditorWindow * self) {
	gint* _tmp0_ = NULL;
	gint* _tmp1_ = NULL;
	self->priv = EASE_EDITOR_WINDOW_GET_PRIVATE (self);
	self->priv->last_saved = (glong) 0;
	self->priv->ZOOM_LEVELS = (_tmp0_ = g_new0 (gint, 13), _tmp0_[0] = 10, _tmp0_[1] = 25, _tmp0_[2] = 33, _tmp0_[3] = 50, _tmp0_[4] = 66, _tmp0_[5] = 75, _tmp0_[6] = 100, _tmp0_[7] = 125, _tmp0_[8] = 150, _tmp0_[9] = 200, _tmp0_[10] = 250, _tmp0_[11] = 300, _tmp0_[12] = 400, _tmp0_);
	self->priv->ZOOM_LEVELS_length1 = 13;
	self->priv->_ZOOM_LEVELS_size_ = self->priv->ZOOM_LEVELS_length1;
	self->priv->SORTER_ZOOM_LEVELS = (_tmp1_ = g_new0 (gint, 5), _tmp1_[0] = 0, _tmp1_[1] = 25, _tmp1_[2] = 50, _tmp1_[3] = 75, _tmp1_[4] = 100, _tmp1_);
	self->priv->SORTER_ZOOM_LEVELS_length1 = 5;
	self->priv->_SORTER_ZOOM_LEVELS_size_ = self->priv->SORTER_ZOOM_LEVELS_length1;
}


static void ease_editor_window_finalize (GObject* obj) {
	EaseEditorWindow * self;
	self = EASE_EDITOR_WINDOW (obj);
	_g_object_unref0 (self->embed);
	_g_object_unref0 (self->slide_button_panel);
	_g_object_unref0 (self->zoom_slider);
	_g_object_unref0 (self->priv->player);
	_g_object_unref0 (self->document);
	_g_object_unref0 (self->slide);
	_g_object_unref0 (self->priv->inspector);
	_g_object_unref0 (self->priv->editor);
	_g_object_unref0 (self->priv->sorter);
	_g_object_unref0 (self->priv->main_bin);
	_g_object_unref0 (self->priv->undo);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->undo_button);
	_g_object_unref0 (self->priv->redo_button);
	_g_object_unref0 (self->priv->color_dialog);
	_g_object_unref0 (self->priv->color_selection);
	_g_object_unref0 (self->priv->show_editor);
	_g_object_unref0 (self->priv->show_sorter);
	_g_object_unref0 (self->priv->zoom_fit);
	self->priv->ZOOM_LEVELS = (g_free (self->priv->ZOOM_LEVELS), NULL);
	self->priv->SORTER_ZOOM_LEVELS = (g_free (self->priv->SORTER_ZOOM_LEVELS), NULL);
	_g_object_unref0 (self->priv->zoom_adjustment);
	_g_object_unref0 (self->priv->sorter_zoom_adjustment);
	G_OBJECT_CLASS (ease_editor_window_parent_class)->finalize (obj);
}


/**
 * A window for editing an Ease {@link Document}
 *
 * An EditorWindow contains several widgets: a toolbar, an
 * {@link EditorEmbed}, a {@link SlideButtonPanel}, and assorted other
 * controls. The window is linked to a {@link Document}, and all changes
 * are made directly to that object.
 */
GType ease_editor_window_get_type (void) {
	static volatile gsize ease_editor_window_type_id__volatile = 0;
	if (g_once_init_enter (&ease_editor_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseEditorWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_editor_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseEditorWindow), 0, (GInstanceInitFunc) ease_editor_window_instance_init, NULL };
		GType ease_editor_window_type_id;
		ease_editor_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "EaseEditorWindow", &g_define_type_info, 0);
		g_once_init_leave (&ease_editor_window_type_id__volatile, ease_editor_window_type_id);
	}
	return ease_editor_window_type_id__volatile;
}


static void ease_editor_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseEditorWindow * self;
	self = EASE_EDITOR_WINDOW (object);
	switch (property_id) {
		case EASE_EDITOR_WINDOW_SLIDES_SHOWN:
		g_value_set_boolean (value, ease_editor_window_get_slides_shown (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_editor_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseEditorWindow * self;
	self = EASE_EDITOR_WINDOW (object);
	switch (property_id) {
		case EASE_EDITOR_WINDOW_SLIDES_SHOWN:
		ease_editor_window_set_slides_shown (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




