/* ease-import-oca-service.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-import-oca-service.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <ease-core.h>
#include <stdlib.h>
#include <string.h>
#include <rest/rest-proxy.h>
#include <rest/rest-proxy-call.h>
#include <libxml/parser.h>
#include <libxml/tree.h>


#define EASE_TYPE_OCA_SERVICE (ease_oca_service_get_type ())
#define EASE_OCA_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_OCA_SERVICE, EaseOCAService))
#define EASE_OCA_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_OCA_SERVICE, EaseOCAServiceClass))
#define EASE_IS_OCA_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_OCA_SERVICE))
#define EASE_IS_OCA_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_OCA_SERVICE))
#define EASE_OCA_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_OCA_SERVICE, EaseOCAServiceClass))

typedef struct _EaseOCAService EaseOCAService;
typedef struct _EaseOCAServiceClass EaseOCAServiceClass;
typedef struct _EaseOCAServicePrivate EaseOCAServicePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define EASE_TYPE_OCA_MEDIA (ease_oca_media_get_type ())
#define EASE_OCA_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_OCA_MEDIA, EaseOCAMedia))
#define EASE_OCA_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_OCA_MEDIA, EaseOCAMediaClass))
#define EASE_IS_OCA_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_OCA_MEDIA))
#define EASE_IS_OCA_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_OCA_MEDIA))
#define EASE_OCA_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_OCA_MEDIA, EaseOCAMediaClass))

typedef struct _EaseOCAMedia EaseOCAMedia;
typedef struct _EaseOCAMediaClass EaseOCAMediaClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _EaseOCAMediaPrivate EaseOCAMediaPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _EaseOCAService {
	EasePluginImportService parent_instance;
	EaseOCAServicePrivate * priv;
};

struct _EaseOCAServiceClass {
	EasePluginImportServiceClass parent_class;
};

struct _EaseOCAMedia {
	EasePluginImportMedia parent_instance;
	EaseOCAMediaPrivate * priv;
	char* link;
	char* creator;
	char* description;
	char* license;
};

struct _EaseOCAMediaClass {
	EasePluginImportMediaClass parent_class;
};


static gpointer ease_oca_service_parent_class = NULL;

GType ease_oca_service_get_type (void) G_GNUC_CONST;
enum  {
	EASE_OCA_SERVICE_DUMMY_PROPERTY
};
#define EASE_OCA_SERVICE_REST_URL "http://www.openclipart.org/media/feed/rss/"
static RestProxy* ease_oca_service_real_create_proxy (EasePluginImportService* base);
static RestProxyCall* ease_oca_service_real_create_call (EasePluginImportService* base, RestProxy* proxy, const char* search);
static void ease_oca_service_real_parse_data (EasePluginImportService* base, const char* data);
EaseOCAMedia* ease_oca_media_new (void);
EaseOCAMedia* ease_oca_media_construct (GType object_type);
GType ease_oca_media_get_type (void) G_GNUC_CONST;
EaseOCAService* ease_oca_service_new (void);
EaseOCAService* ease_oca_service_construct (GType object_type);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 23 "ease-import-oca-service.vala"
static RestProxy* ease_oca_service_real_create_proxy (EasePluginImportService* base) {
#line 103 "ease-import-oca-service.c"
	EaseOCAService * self;
	RestProxy* result = NULL;
	self = (EaseOCAService*) base;
	result = rest_proxy_new (EASE_OCA_SERVICE_REST_URL, FALSE);
#line 25 "ease-import-oca-service.vala"
	return result;
#line 110 "ease-import-oca-service.c"
}


#line 28 "ease-import-oca-service.vala"
static RestProxyCall* ease_oca_service_real_create_call (EasePluginImportService* base, RestProxy* proxy, const char* search) {
#line 116 "ease-import-oca-service.c"
	EaseOCAService * self;
	RestProxyCall* result = NULL;
	RestProxyCall* call;
	self = (EaseOCAService*) base;
#line 28 "ease-import-oca-service.vala"
	g_return_val_if_fail (proxy != NULL, NULL);
#line 28 "ease-import-oca-service.vala"
	g_return_val_if_fail (search != NULL, NULL);
#line 31 "ease-import-oca-service.vala"
	call = rest_proxy_new_call (proxy);
#line 32 "ease-import-oca-service.vala"
	rest_proxy_call_set_function (call, search);
#line 129 "ease-import-oca-service.c"
	result = call;
#line 33 "ease-import-oca-service.vala"
	return result;
#line 133 "ease-import-oca-service.c"
}


#line 1157 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 139 "ease-import-oca-service.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 148 "ease-import-oca-service.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1159 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 156 "ease-import-oca-service.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1160 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 167 "ease-import-oca-service.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1160 "glib-2.0.vapi"
		return result;
#line 182 "ease-import-oca-service.c"
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1162 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 193 "ease-import-oca-service.c"
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 36 "ease-import-oca-service.vala"
static void ease_oca_service_real_parse_data (EasePluginImportService* base, const char* data) {
#line 208 "ease-import-oca-service.c"
	EaseOCAService * self;
	xmlDoc* doc;
	xmlNode* root;
	xmlNode* channel;
	self = (EaseOCAService*) base;
#line 36 "ease-import-oca-service.vala"
	g_return_if_fail (data != NULL);
#line 38 "ease-import-oca-service.vala"
	xmlInitParser ();
#line 40 "ease-import-oca-service.vala"
	doc = xmlParseDoc (data);
#line 42 "ease-import-oca-service.vala"
	if (doc == NULL) {
#line 42 "ease-import-oca-service.vala"
		return;
#line 224 "ease-import-oca-service.c"
	}
#line 44 "ease-import-oca-service.vala"
	root = xmlDocGetRootElement (doc);
#line 47 "ease-import-oca-service.vala"
	channel = root->children;
#line 230 "ease-import-oca-service.c"
	{
		gboolean _tmp0_;
#line 48 "ease-import-oca-service.vala"
		_tmp0_ = TRUE;
#line 48 "ease-import-oca-service.vala"
		while (TRUE) {
#line 48 "ease-import-oca-service.vala"
			if (!_tmp0_) {
#line 48 "ease-import-oca-service.vala"
				channel = channel->next;
#line 241 "ease-import-oca-service.c"
			}
#line 48 "ease-import-oca-service.vala"
			_tmp0_ = FALSE;
#line 48 "ease-import-oca-service.vala"
			if (!(_vala_strcmp0 (channel->name, "channel") != 0)) {
#line 48 "ease-import-oca-service.vala"
				break;
#line 249 "ease-import-oca-service.c"
			}
			;
		}
	}
	{
		xmlNode* itr;
#line 51 "ease-import-oca-service.vala"
		itr = channel->children;
#line 258 "ease-import-oca-service.c"
		{
			gboolean _tmp1_;
#line 51 "ease-import-oca-service.vala"
			_tmp1_ = TRUE;
#line 51 "ease-import-oca-service.vala"
			while (TRUE) {
#line 51 "ease-import-oca-service.vala"
				if (!_tmp1_) {
#line 52 "ease-import-oca-service.vala"
					itr = itr->next;
#line 269 "ease-import-oca-service.c"
				}
#line 51 "ease-import-oca-service.vala"
				_tmp1_ = FALSE;
#line 52 "ease-import-oca-service.vala"
				if (!(itr != NULL)) {
#line 52 "ease-import-oca-service.vala"
					break;
#line 277 "ease-import-oca-service.c"
				}
#line 54 "ease-import-oca-service.vala"
				if (itr->type != XML_ELEMENT_NODE) {
#line 54 "ease-import-oca-service.vala"
					continue;
#line 283 "ease-import-oca-service.c"
				}
#line 57 "ease-import-oca-service.vala"
				if (_vala_strcmp0 (itr->name, "item") == 0) {
#line 287 "ease-import-oca-service.c"
					EaseOCAMedia* image;
#line 59 "ease-import-oca-service.vala"
					image = ease_oca_media_new ();
#line 291 "ease-import-oca-service.c"
					{
						xmlNode* tag;
#line 61 "ease-import-oca-service.vala"
						tag = itr->children;
#line 296 "ease-import-oca-service.c"
						{
							gboolean _tmp2_;
#line 61 "ease-import-oca-service.vala"
							_tmp2_ = TRUE;
#line 61 "ease-import-oca-service.vala"
							while (TRUE) {
#line 303 "ease-import-oca-service.c"
								const char* _tmp12_;
								GQuark _tmp13_;
								static GQuark _tmp13__label0 = 0;
								static GQuark _tmp13__label1 = 0;
								static GQuark _tmp13__label2 = 0;
								static GQuark _tmp13__label3 = 0;
								static GQuark _tmp13__label4 = 0;
								static GQuark _tmp13__label5 = 0;
								static GQuark _tmp13__label6 = 0;
#line 61 "ease-import-oca-service.vala"
								if (!_tmp2_) {
#line 62 "ease-import-oca-service.vala"
									tag = tag->next;
#line 317 "ease-import-oca-service.c"
								}
#line 61 "ease-import-oca-service.vala"
								_tmp2_ = FALSE;
#line 62 "ease-import-oca-service.vala"
								if (!(tag != NULL)) {
#line 62 "ease-import-oca-service.vala"
									break;
#line 325 "ease-import-oca-service.c"
								}
								_tmp12_ = tag->name;
								_tmp13_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
								if (_tmp13_ == ((0 != _tmp13__label0) ? _tmp13__label0 : (_tmp13__label0 = g_quark_from_static_string ("title"))))
								switch (0) {
									default:
									{
										char* _tmp3_;
#line 67 "ease-import-oca-service.vala"
										((EasePluginImportMedia*) image)->title = (_tmp3_ = g_strdup (tag->children->content), _g_free0 (((EasePluginImportMedia*) image)->title), _tmp3_);
#line 68 "ease-import-oca-service.vala"
										break;
#line 338 "ease-import-oca-service.c"
									}
								} else if (_tmp13_ == ((0 != _tmp13__label1) ? _tmp13__label1 : (_tmp13__label1 = g_quark_from_static_string ("link"))))
								switch (0) {
									default:
									{
										char* _tmp4_;
#line 70 "ease-import-oca-service.vala"
										image->link = (_tmp4_ = g_strdup (tag->children->content), _g_free0 (image->link), _tmp4_);
#line 71 "ease-import-oca-service.vala"
										break;
#line 349 "ease-import-oca-service.c"
									}
								} else if (_tmp13_ == ((0 != _tmp13__label2) ? _tmp13__label2 : (_tmp13__label2 = g_quark_from_static_string ("dc:creator"))))
								switch (0) {
									default:
									{
										char* _tmp5_;
#line 73 "ease-import-oca-service.vala"
										image->creator = (_tmp5_ = g_strdup (tag->children->content), _g_free0 (image->creator), _tmp5_);
#line 74 "ease-import-oca-service.vala"
										break;
#line 360 "ease-import-oca-service.c"
									}
								} else if (_tmp13_ == ((0 != _tmp13__label3) ? _tmp13__label3 : (_tmp13__label3 = g_quark_from_static_string ("license"))))
								switch (0) {
									default:
									{
										char* _tmp6_;
#line 76 "ease-import-oca-service.vala"
										image->license = (_tmp6_ = g_strdup (tag->children->content), _g_free0 (image->license), _tmp6_);
#line 77 "ease-import-oca-service.vala"
										break;
#line 371 "ease-import-oca-service.c"
									}
								} else if (_tmp13_ == ((0 != _tmp13__label4) ? _tmp13__label4 : (_tmp13__label4 = g_quark_from_static_string ("description"))))
								switch (0) {
									default:
									{
										char* _tmp7_;
#line 79 "ease-import-oca-service.vala"
										image->description = (_tmp7_ = g_strdup (tag->children->content), _g_free0 (image->description), _tmp7_);
#line 80 "ease-import-oca-service.vala"
										break;
#line 382 "ease-import-oca-service.c"
									}
								} else if (_tmp13_ == ((0 != _tmp13__label5) ? _tmp13__label5 : (_tmp13__label5 = g_quark_from_static_string ("enclosure"))))
								switch (0) {
									default:
									{
										{
											xmlAttr* prop;
#line 82 "ease-import-oca-service.vala"
											prop = tag->properties;
#line 392 "ease-import-oca-service.c"
											{
												gboolean _tmp8_;
#line 82 "ease-import-oca-service.vala"
												_tmp8_ = TRUE;
#line 82 "ease-import-oca-service.vala"
												while (TRUE) {
#line 82 "ease-import-oca-service.vala"
													if (!_tmp8_) {
#line 83 "ease-import-oca-service.vala"
														prop = prop->next;
#line 403 "ease-import-oca-service.c"
													}
#line 82 "ease-import-oca-service.vala"
													_tmp8_ = FALSE;
#line 83 "ease-import-oca-service.vala"
													if (!(prop != NULL)) {
#line 83 "ease-import-oca-service.vala"
														break;
#line 411 "ease-import-oca-service.c"
													}
#line 85 "ease-import-oca-service.vala"
													if (_vala_strcmp0 (prop->name, "url") == 0) {
#line 415 "ease-import-oca-service.c"
														char* _tmp9_;
#line 87 "ease-import-oca-service.vala"
														((EasePluginImportMedia*) image)->file_link = (_tmp9_ = g_strdup (prop->children->content), _g_free0 (((EasePluginImportMedia*) image)->file_link), _tmp9_);
#line 419 "ease-import-oca-service.c"
													}
												}
											}
										}
#line 90 "ease-import-oca-service.vala"
										break;
#line 426 "ease-import-oca-service.c"
									}
								} else if (_tmp13_ == ((0 != _tmp13__label6) ? _tmp13__label6 : (_tmp13__label6 = g_quark_from_static_string ("thumbnail"))))
								switch (0) {
									default:
									{
										{
											xmlAttr* prop;
#line 92 "ease-import-oca-service.vala"
											prop = tag->properties;
#line 436 "ease-import-oca-service.c"
											{
												gboolean _tmp10_;
#line 92 "ease-import-oca-service.vala"
												_tmp10_ = TRUE;
#line 92 "ease-import-oca-service.vala"
												while (TRUE) {
#line 92 "ease-import-oca-service.vala"
													if (!_tmp10_) {
#line 93 "ease-import-oca-service.vala"
														prop = prop->next;
#line 447 "ease-import-oca-service.c"
													}
#line 92 "ease-import-oca-service.vala"
													_tmp10_ = FALSE;
#line 93 "ease-import-oca-service.vala"
													if (!(prop != NULL)) {
#line 93 "ease-import-oca-service.vala"
														break;
#line 455 "ease-import-oca-service.c"
													}
#line 95 "ease-import-oca-service.vala"
													if (_vala_strcmp0 (prop->name, "url") == 0) {
#line 459 "ease-import-oca-service.c"
														char* thumb;
														char* _tmp11_;
#line 97 "ease-import-oca-service.vala"
														thumb = g_strdup (prop->children->content);
#line 98 "ease-import-oca-service.vala"
														((EasePluginImportMedia*) image)->thumb_link = (_tmp11_ = string_replace (thumb, "90px", "125px"), _g_free0 (((EasePluginImportMedia*) image)->thumb_link), _tmp11_);
#line 466 "ease-import-oca-service.c"
														_g_free0 (thumb);
													}
												}
											}
										}
#line 102 "ease-import-oca-service.vala"
										break;
#line 474 "ease-import-oca-service.c"
									}
								}
							}
						}
					}
#line 106 "ease-import-oca-service.vala"
					ease_plugin_import_service_add_media ((EasePluginImportService*) self, (EasePluginImportMedia*) image);
#line 482 "ease-import-oca-service.c"
					_g_object_unref0 (image);
				}
			}
		}
	}
}


#line 18 "ease-import-oca-service.vala"
EaseOCAService* ease_oca_service_construct (GType object_type) {
#line 493 "ease-import-oca-service.c"
	EaseOCAService * self;
#line 18 "ease-import-oca-service.vala"
	self = (EaseOCAService*) ease_plugin_import_service_construct (object_type);
#line 497 "ease-import-oca-service.c"
	return self;
}


#line 18 "ease-import-oca-service.vala"
EaseOCAService* ease_oca_service_new (void) {
#line 18 "ease-import-oca-service.vala"
	return ease_oca_service_construct (EASE_TYPE_OCA_SERVICE);
#line 506 "ease-import-oca-service.c"
}


static void ease_oca_service_class_init (EaseOCAServiceClass * klass) {
	ease_oca_service_parent_class = g_type_class_peek_parent (klass);
	EASE_PLUGIN_IMPORT_SERVICE_CLASS (klass)->create_proxy = ease_oca_service_real_create_proxy;
	EASE_PLUGIN_IMPORT_SERVICE_CLASS (klass)->create_call = ease_oca_service_real_create_call;
	EASE_PLUGIN_IMPORT_SERVICE_CLASS (klass)->parse_data = ease_oca_service_real_parse_data;
}


static void ease_oca_service_instance_init (EaseOCAService * self) {
}


GType ease_oca_service_get_type (void) {
	static volatile gsize ease_oca_service_type_id__volatile = 0;
	if (g_once_init_enter (&ease_oca_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseOCAServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_oca_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseOCAService), 0, (GInstanceInitFunc) ease_oca_service_instance_init, NULL };
		GType ease_oca_service_type_id;
		ease_oca_service_type_id = g_type_register_static (EASE_PLUGIN_TYPE_IMPORT_SERVICE, "EaseOCAService", &g_define_type_info, 0);
		g_once_init_leave (&ease_oca_service_type_id__volatile, ease_oca_service_type_id);
	}
	return ease_oca_service_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




