/* ease-slide.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-slide.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <cairo.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>


#define EASE_TYPE_UNDO_SOURCE (ease_undo_source_get_type ())
#define EASE_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSource))
#define EASE_IS_UNDO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_SOURCE))
#define EASE_UNDO_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), EASE_TYPE_UNDO_SOURCE, EaseUndoSourceIface))

typedef struct _EaseUndoSource EaseUndoSource;
typedef struct _EaseUndoSourceIface EaseUndoSourceIface;

#define EASE_TYPE_SLIDE (ease_slide_get_type ())
#define EASE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE, EaseSlide))
#define EASE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE, EaseSlideClass))
#define EASE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE))
#define EASE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE))
#define EASE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE, EaseSlideClass))

typedef struct _EaseSlide EaseSlide;
typedef struct _EaseSlideClass EaseSlideClass;
typedef struct _EaseSlidePrivate EaseSlidePrivate;

#define EASE_TYPE_ELEMENT (ease_element_get_type ())
#define EASE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT, EaseElement))
#define EASE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT, EaseElementClass))
#define EASE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT))
#define EASE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT))
#define EASE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT, EaseElementClass))

typedef struct _EaseElement EaseElement;
typedef struct _EaseElementClass EaseElementClass;

#define EASE_TYPE_TRANSITION (ease_transition_get_type ())

#define EASE_TYPE_TRANSITION_VARIANT (ease_transition_variant_get_type ())

#define EASE_TYPE_BACKGROUND (ease_background_get_type ())
#define EASE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_BACKGROUND, EaseBackground))
#define EASE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_BACKGROUND, EaseBackgroundClass))
#define EASE_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_BACKGROUND))
#define EASE_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_BACKGROUND))
#define EASE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_BACKGROUND, EaseBackgroundClass))

typedef struct _EaseBackground EaseBackground;
typedef struct _EaseBackgroundClass EaseBackgroundClass;

#define EASE_TYPE_DOCUMENT (ease_document_get_type ())
#define EASE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_DOCUMENT, EaseDocument))
#define EASE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_DOCUMENT, EaseDocumentClass))
#define EASE_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_DOCUMENT))
#define EASE_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_DOCUMENT))
#define EASE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_DOCUMENT, EaseDocumentClass))

typedef struct _EaseDocument EaseDocument;
typedef struct _EaseDocumentClass EaseDocumentClass;

#define EASE_TYPE_THEME (ease_theme_get_type ())
#define EASE_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_THEME, EaseTheme))
#define EASE_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_THEME, EaseThemeClass))
#define EASE_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_THEME))
#define EASE_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_THEME))
#define EASE_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_THEME, EaseThemeClass))

typedef struct _EaseTheme EaseTheme;
typedef struct _EaseThemeClass EaseThemeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define EASE_TYPE_UNDO_ITEM (ease_undo_item_get_type ())
#define EASE_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItem))
#define EASE_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))
#define EASE_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ITEM))
#define EASE_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ITEM))
#define EASE_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ITEM, EaseUndoItemClass))

typedef struct _EaseUndoItem EaseUndoItem;
typedef struct _EaseUndoItemClass EaseUndoItemClass;

#define EASE_TYPE_UNDO_ACTION (ease_undo_action_get_type ())
#define EASE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoAction))
#define EASE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))
#define EASE_IS_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_UNDO_ACTION))
#define EASE_IS_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_UNDO_ACTION))
#define EASE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_UNDO_ACTION, EaseUndoActionClass))

typedef struct _EaseUndoAction EaseUndoAction;
typedef struct _EaseUndoActionClass EaseUndoActionClass;
typedef struct _EaseUndoItemPrivate EaseUndoItemPrivate;
typedef struct _EaseUndoActionPrivate EaseUndoActionPrivate;

#define EASE_UNDO_ACTION_TYPE_UNDO_PAIR (ease_undo_action_undo_pair_get_type ())
#define EASE_UNDO_ACTION_UNDO_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_UNDO_ACTION_TYPE_UNDO_PAIR, EaseUndoActionUndoPair))
#define EASE_UNDO_ACTION_UNDO_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_UNDO_ACTION_TYPE_UNDO_PAIR, EaseUndoActionUndoPairClass))
#define EASE_UNDO_ACTION_IS_UNDO_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_UNDO_ACTION_TYPE_UNDO_PAIR))
#define EASE_UNDO_ACTION_IS_UNDO_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_UNDO_ACTION_TYPE_UNDO_PAIR))
#define EASE_UNDO_ACTION_UNDO_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_UNDO_ACTION_TYPE_UNDO_PAIR, EaseUndoActionUndoPairClass))

typedef struct _EaseUndoActionUndoPair EaseUndoActionUndoPair;
typedef struct _EaseUndoActionUndoPairClass EaseUndoActionUndoPairClass;
typedef struct _EaseUndoActionUndoPairPrivate EaseUndoActionUndoPairPrivate;
#define _ease_undo_action_undo_pair_unref0(var) ((var == NULL) ? NULL : (var = (ease_undo_action_undo_pair_unref (var), NULL)))

#define EASE_TYPE_MEDIA_ELEMENT (ease_media_element_get_type ())
#define EASE_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElement))
#define EASE_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))
#define EASE_IS_MEDIA_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_IS_MEDIA_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_MEDIA_ELEMENT))
#define EASE_MEDIA_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_MEDIA_ELEMENT, EaseMediaElementClass))

typedef struct _EaseMediaElement EaseMediaElement;
typedef struct _EaseMediaElementClass EaseMediaElementClass;

#define EASE_TYPE_IMAGE_ELEMENT (ease_image_element_get_type ())
#define EASE_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElement))
#define EASE_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))
#define EASE_IS_IMAGE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IS_IMAGE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE_ELEMENT))
#define EASE_IMAGE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE_ELEMENT, EaseImageElementClass))

typedef struct _EaseImageElement EaseImageElement;
typedef struct _EaseImageElementClass EaseImageElementClass;

#define EASE_TYPE_CAIRO_ELEMENT (ease_cairo_element_get_type ())
#define EASE_CAIRO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElement))
#define EASE_CAIRO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElementClass))
#define EASE_IS_CAIRO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_CAIRO_ELEMENT))
#define EASE_IS_CAIRO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_CAIRO_ELEMENT))
#define EASE_CAIRO_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_CAIRO_ELEMENT, EaseCairoElementClass))

typedef struct _EaseCairoElement EaseCairoElement;
typedef struct _EaseCairoElementClass EaseCairoElementClass;

#define EASE_TYPE_SHAPE_ELEMENT (ease_shape_element_get_type ())
#define EASE_SHAPE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElement))
#define EASE_SHAPE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElementClass))
#define EASE_IS_SHAPE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SHAPE_ELEMENT))
#define EASE_IS_SHAPE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SHAPE_ELEMENT))
#define EASE_SHAPE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SHAPE_ELEMENT, EaseShapeElementClass))

typedef struct _EaseShapeElement EaseShapeElement;
typedef struct _EaseShapeElementClass EaseShapeElementClass;

#define EASE_TYPE_VIDEO_ELEMENT (ease_video_element_get_type ())
#define EASE_VIDEO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElement))
#define EASE_VIDEO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElementClass))
#define EASE_IS_VIDEO_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_VIDEO_ELEMENT))
#define EASE_IS_VIDEO_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_VIDEO_ELEMENT))
#define EASE_VIDEO_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_VIDEO_ELEMENT, EaseVideoElementClass))

typedef struct _EaseVideoElement EaseVideoElement;
typedef struct _EaseVideoElementClass EaseVideoElementClass;

#define EASE_TYPE_PDF_ELEMENT (ease_pdf_element_get_type ())
#define EASE_PDF_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_PDF_ELEMENT, EasePdfElement))
#define EASE_PDF_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_PDF_ELEMENT, EasePdfElementClass))
#define EASE_IS_PDF_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_PDF_ELEMENT))
#define EASE_IS_PDF_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_PDF_ELEMENT))
#define EASE_PDF_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_PDF_ELEMENT, EasePdfElementClass))

typedef struct _EasePdfElement EasePdfElement;
typedef struct _EasePdfElementClass EasePdfElementClass;

#define EASE_TYPE_TEXT_ELEMENT (ease_text_element_get_type ())
#define EASE_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElement))
#define EASE_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))
#define EASE_IS_TEXT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_TEXT_ELEMENT))
#define EASE_IS_TEXT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_TEXT_ELEMENT))
#define EASE_TEXT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_TEXT_ELEMENT, EaseTextElementClass))

typedef struct _EaseTextElement EaseTextElement;
typedef struct _EaseTextElementClass EaseTextElementClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_node_free0(var) ((var == NULL) ? NULL : (var = (json_node_free (var), NULL)))

#define EASE_TYPE_ELEMENT_ADD_UNDO_ACTION (ease_element_add_undo_action_get_type ())
#define EASE_ELEMENT_ADD_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoAction))
#define EASE_ELEMENT_ADD_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoActionClass))
#define EASE_IS_ELEMENT_ADD_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION))
#define EASE_IS_ELEMENT_ADD_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION))
#define EASE_ELEMENT_ADD_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT_ADD_UNDO_ACTION, EaseElementAddUndoActionClass))

typedef struct _EaseElementAddUndoAction EaseElementAddUndoAction;
typedef struct _EaseElementAddUndoActionClass EaseElementAddUndoActionClass;

#define EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION (ease_element_remove_undo_action_get_type ())
#define EASE_ELEMENT_REMOVE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoAction))
#define EASE_ELEMENT_REMOVE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoActionClass))
#define EASE_IS_ELEMENT_REMOVE_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION))
#define EASE_IS_ELEMENT_REMOVE_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION))
#define EASE_ELEMENT_REMOVE_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT_REMOVE_UNDO_ACTION, EaseElementRemoveUndoActionClass))

typedef struct _EaseElementRemoveUndoAction EaseElementRemoveUndoAction;
typedef struct _EaseElementRemoveUndoActionClass EaseElementRemoveUndoActionClass;

#define EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION (ease_element_reorder_undo_action_get_type ())
#define EASE_ELEMENT_REORDER_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoAction))
#define EASE_ELEMENT_REORDER_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoActionClass))
#define EASE_IS_ELEMENT_REORDER_UNDO_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION))
#define EASE_IS_ELEMENT_REORDER_UNDO_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION))
#define EASE_ELEMENT_REORDER_UNDO_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ELEMENT_REORDER_UNDO_ACTION, EaseElementReorderUndoActionClass))

typedef struct _EaseElementReorderUndoAction EaseElementReorderUndoAction;
typedef struct _EaseElementReorderUndoActionClass EaseElementReorderUndoActionClass;

#define EASE_TYPE_HTML_EXPORTER (ease_html_exporter_get_type ())
#define EASE_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporter))
#define EASE_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))
#define EASE_IS_HTML_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_HTML_EXPORTER))
#define EASE_IS_HTML_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_HTML_EXPORTER))
#define EASE_HTML_EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_HTML_EXPORTER, EaseHTMLExporterClass))

typedef struct _EaseHTMLExporter EaseHTMLExporter;
typedef struct _EaseHTMLExporterClass EaseHTMLExporterClass;

#define EASE_TYPE_BACKGROUND_TYPE (ease_background_type_get_type ())

#define EASE_TYPE_COLOR (ease_color_get_type ())
#define EASE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_COLOR, EaseColor))
#define EASE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_COLOR, EaseColorClass))
#define EASE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_COLOR))
#define EASE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_COLOR))
#define EASE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_COLOR, EaseColorClass))

typedef struct _EaseColor EaseColor;
typedef struct _EaseColorClass EaseColorClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define EASE_TYPE_IMAGE (ease_image_get_type ())
#define EASE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_IMAGE, EaseImage))
#define EASE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_IMAGE, EaseImageClass))
#define EASE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_IMAGE))
#define EASE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_IMAGE))
#define EASE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_IMAGE, EaseImageClass))

typedef struct _EaseImage EaseImage;
typedef struct _EaseImageClass EaseImageClass;

#define EASE_SLIDE_TYPE_ITERATOR (ease_slide_iterator_get_type ())
#define EASE_SLIDE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIterator))
#define EASE_SLIDE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorClass))
#define EASE_SLIDE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_SLIDE_TYPE_ITERATOR))
#define EASE_SLIDE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_SLIDE_TYPE_ITERATOR))
#define EASE_SLIDE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorClass))

typedef struct _EaseSlideIterator EaseSlideIterator;
typedef struct _EaseSlideIteratorClass EaseSlideIteratorClass;
#define _ease_slide_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_slide_iterator_unref (var), NULL)))

#define EASE_TYPE_ITERABLE_LIST_STORE (ease_iterable_list_store_get_type ())
#define EASE_ITERABLE_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStore))
#define EASE_ITERABLE_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStoreClass))
#define EASE_IS_ITERABLE_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_ITERABLE_LIST_STORE))
#define EASE_IS_ITERABLE_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_ITERABLE_LIST_STORE))
#define EASE_ITERABLE_LIST_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_ITERABLE_LIST_STORE, EaseIterableListStoreClass))

typedef struct _EaseIterableListStore EaseIterableListStore;
typedef struct _EaseIterableListStoreClass EaseIterableListStoreClass;
typedef struct _EaseSlideIteratorPrivate EaseSlideIteratorPrivate;
typedef struct _EaseSlideParamSpecIterator EaseSlideParamSpecIterator;

struct _EaseUndoSourceIface {
	GTypeInterface parent_iface;
};

struct _EaseSlide {
	GObject parent_instance;
	EaseSlidePrivate * priv;
	GeeLinkedList* elements;
};

struct _EaseSlideClass {
	GObjectClass parent_class;
};

typedef enum  {
	EASE_TRANSITION_NONE,
	EASE_TRANSITION_FADE,
	EASE_TRANSITION_SLIDE,
	EASE_TRANSITION_DROP,
	EASE_TRANSITION_PIVOT,
	EASE_TRANSITION_FLIP,
	EASE_TRANSITION_REVOLVING_DOOR,
	EASE_TRANSITION_REVEAL,
	EASE_TRANSITION_FALL,
	EASE_TRANSITION_SLATS,
	EASE_TRANSITION_OPEN_DOOR,
	EASE_TRANSITION_EXPLODE,
	EASE_TRANSITION_ASSEMBLE,
	EASE_TRANSITION_ZOOM,
	EASE_TRANSITION_PANEL,
	EASE_TRANSITION_INTERSPERSE_CONTENTS,
	EASE_TRANSITION_SPIN_CONTENTS,
	EASE_TRANSITION_SPRING_CONTENTS,
	EASE_TRANSITION_SWING_CONTENTS,
	EASE_TRANSITION_SLIDE_CONTENTS,
	EASE_TRANSITION_ZOOM_CONTENTS
} EaseTransition;

typedef enum  {
	EASE_TRANSITION_VARIANT_LEFT,
	EASE_TRANSITION_VARIANT_RIGHT,
	EASE_TRANSITION_VARIANT_UP,
	EASE_TRANSITION_VARIANT_DOWN,
	EASE_TRANSITION_VARIANT_BOTTOM,
	EASE_TRANSITION_VARIANT_TOP,
	EASE_TRANSITION_VARIANT_CENTER,
	EASE_TRANSITION_VARIANT_TOP_LEFT,
	EASE_TRANSITION_VARIANT_TOP_RIGHT,
	EASE_TRANSITION_VARIANT_BOTTOM_LEFT,
	EASE_TRANSITION_VARIANT_BOTTOM_RIGHT,
	EASE_TRANSITION_VARIANT_TOP_TO_BOTTOM,
	EASE_TRANSITION_VARIANT_BOTTOM_TO_TOP,
	EASE_TRANSITION_VARIANT_LEFT_TO_RIGHT,
	EASE_TRANSITION_VARIANT_RIGHT_TO_LEFT,
	EASE_TRANSITION_VARIANT_IN,
	EASE_TRANSITION_VARIANT_OUT
} EaseTransitionVariant;

struct _EaseSlidePrivate {
	EaseTransition _transition;
	EaseTransitionVariant _variant;
	double _transition_time;
	gboolean _automatically_advance;
	double _advance_delay;
	EaseBackground* _background;
	EaseDocument* _parent;
	EaseTheme* _theme;
	char* _master;
};

struct _EaseUndoItem {
	GObject parent_instance;
	EaseUndoItemPrivate * priv;
};

struct _EaseUndoItemClass {
	GObjectClass parent_class;
	EaseUndoItem* (*apply) (EaseUndoItem* self);
	gboolean (*contains) (EaseUndoItem* self, GObject* obj);
};

struct _EaseUndoAction {
	EaseUndoItem parent_instance;
	EaseUndoActionPrivate * priv;
	GeeLinkedList* pairs;
};

struct _EaseUndoActionClass {
	EaseUndoItemClass parent_class;
};

struct _EaseUndoActionUndoPair {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EaseUndoActionUndoPairPrivate * priv;
	char* property;
	GObject* object;
	GValue val;
	GType type;
};

struct _EaseUndoActionUndoPairClass {
	GTypeClass parent_class;
	void (*finalize) (EaseUndoActionUndoPair *self);
};

typedef enum  {
	EASE_BACKGROUND_TYPE_COLOR,
	EASE_BACKGROUND_TYPE_GRADIENT,
	EASE_BACKGROUND_TYPE_IMAGE
} EaseBackgroundType;

struct _EaseSlideIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EaseSlideIteratorPrivate * priv;
};

struct _EaseSlideIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (EaseSlideIterator *self);
};

struct _EaseSlideIteratorPrivate {
	gint i;
	EaseSlide* self;
};

struct _EaseSlideParamSpecIterator {
	GParamSpec parent_instance;
};


static gpointer ease_slide_iterator_parent_class = NULL;
static gpointer ease_slide_parent_class = NULL;
static EaseUndoSourceIface* ease_slide_ease_undo_source_parent_iface = NULL;

GType ease_undo_source_get_type (void) G_GNUC_CONST;
GType ease_slide_get_type (void) G_GNUC_CONST;
GType ease_element_get_type (void) G_GNUC_CONST;
GType ease_transition_get_type (void) G_GNUC_CONST;
GType ease_transition_variant_get_type (void) G_GNUC_CONST;
GType ease_background_get_type (void) G_GNUC_CONST;
GType ease_document_get_type (void) G_GNUC_CONST;
GType ease_theme_get_type (void) G_GNUC_CONST;
#define EASE_SLIDE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_SLIDE, EaseSlidePrivate))
enum  {
	EASE_SLIDE_DUMMY_PROPERTY,
	EASE_SLIDE_TRANSITION,
	EASE_SLIDE_VARIANT,
	EASE_SLIDE_TRANSITION_TIME,
	EASE_SLIDE_TRANSITION_MSECS,
	EASE_SLIDE_AUTOMATICALLY_ADVANCE,
	EASE_SLIDE_ADVANCE_DELAY,
	EASE_SLIDE_BACKGROUND,
	EASE_SLIDE_BACKGROUND_ABS,
	EASE_SLIDE_PARENT,
	EASE_SLIDE_WIDTH,
	EASE_SLIDE_HEIGHT,
	EASE_SLIDE_ASPECT,
	EASE_SLIDE_THEME,
	EASE_SLIDE_MASTER,
	EASE_SLIDE_COUNT,
	EASE_SLIDE_NEXT,
	EASE_SLIDE_PREVIOUS
};
#define EASE_SLIDE_IMAGE_TYPE "EaseImageElement"
#define EASE_SLIDE_SHAPE_TYPE "EaseShapeElement"
#define EASE_SLIDE_VIDEO_TYPE "EaseVideoElement"
#define EASE_SLIDE_PDF_TYPE "EasePdfElement"
EaseSlide* ease_slide_new (void);
EaseSlide* ease_slide_construct (GType object_type);
EaseBackground* ease_background_new (void);
EaseBackground* ease_background_construct (GType object_type);
void ease_slide_set_background (EaseSlide* self, EaseBackground* value);
GType ease_undo_item_get_type (void) G_GNUC_CONST;
static void _lambda64_ (EaseUndoItem* item, EaseSlide* self);
EaseBackground* ease_slide_get_background (EaseSlide* self);
gboolean ease_background_owns_undoitem (EaseBackground* self, EaseUndoItem* item);
static void __lambda64__ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self);
static void _lambda65_ (EaseUndoItem* item, EaseSlide* self);
GType ease_undo_action_get_type (void) G_GNUC_CONST;
gpointer ease_undo_action_undo_pair_ref (gpointer instance);
void ease_undo_action_undo_pair_unref (gpointer instance);
GParamSpec* ease_undo_action_param_spec_undo_pair (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ease_undo_action_value_set_undo_pair (GValue* value, gpointer v_object);
void ease_undo_action_value_take_undo_pair (GValue* value, gpointer v_object);
gpointer ease_undo_action_value_get_undo_pair (const GValue* value);
GType ease_undo_action_undo_pair_get_type (void) G_GNUC_CONST;
static void ease_slide_update_title (EaseSlide* self, GObject* object);
static void __lambda65__ease_undo_source_forwarded (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self);
EaseSlide* ease_slide_new_with_owner (EaseDocument* owner);
EaseSlide* ease_slide_construct_with_owner (GType object_type, EaseDocument* owner);
void ease_slide_set_parent (EaseSlide* self, EaseDocument* value);
EaseSlide* ease_slide_new_from_json (JsonObject* obj, EaseDocument* owner);
EaseSlide* ease_slide_construct_from_json (GType object_type, JsonObject* obj, EaseDocument* owner);
void ease_slide_set_master (EaseSlide* self, const char* value);
EaseTransition ease_transition_from_string (const char* str);
void ease_slide_set_transition (EaseSlide* self, EaseTransition value);
EaseTransitionVariant ease_transition_variant_from_string (const char* str);
void ease_slide_set_variant (EaseSlide* self, EaseTransitionVariant value);
void ease_slide_set_transition_time (EaseSlide* self, double value);
void ease_slide_set_automatically_advance (EaseSlide* self, gboolean value);
void ease_slide_set_advance_delay (EaseSlide* self, double value);
#define EASE_THEME_BACKGROUND "background"
EaseBackground* ease_background_new_from_json (JsonObject* obj);
EaseBackground* ease_background_construct_from_json (GType object_type, JsonObject* obj);
#define EASE_THEME_ELEMENT_TYPE "element-type"
EaseImageElement* ease_image_element_new_from_json (JsonObject* obj);
EaseImageElement* ease_image_element_construct_from_json (GType object_type, JsonObject* obj);
GType ease_media_element_get_type (void) G_GNUC_CONST;
GType ease_image_element_get_type (void) G_GNUC_CONST;
EaseShapeElement* ease_shape_element_new_from_json (JsonObject* obj);
EaseShapeElement* ease_shape_element_construct_from_json (GType object_type, JsonObject* obj);
GType ease_cairo_element_get_type (void) G_GNUC_CONST;
GType ease_shape_element_get_type (void) G_GNUC_CONST;
EaseVideoElement* ease_video_element_new_from_json (JsonObject* obj);
EaseVideoElement* ease_video_element_construct_from_json (GType object_type, JsonObject* obj);
GType ease_video_element_get_type (void) G_GNUC_CONST;
EasePdfElement* ease_pdf_element_new_from_json (JsonObject* obj, EaseSlide* owner);
EasePdfElement* ease_pdf_element_construct_from_json (GType object_type, JsonObject* obj, EaseSlide* owner);
GType ease_pdf_element_get_type (void) G_GNUC_CONST;
EaseTextElement* ease_text_element_new_from_json (JsonObject* obj);
EaseTextElement* ease_text_element_construct_from_json (GType object_type, JsonObject* obj);
GType ease_text_element_get_type (void) G_GNUC_CONST;
void ease_element_set_element_type (EaseElement* self, const char* value);
void ease_slide_append (EaseSlide* self, EaseElement* e);
JsonNode* ease_slide_to_json (EaseSlide* self);
const char* ease_slide_get_master (EaseSlide* self);
EaseTransition ease_slide_get_transition (EaseSlide* self);
EaseTransitionVariant ease_slide_get_variant (EaseSlide* self);
double ease_slide_get_transition_time (EaseSlide* self);
gboolean ease_slide_get_automatically_advance (EaseSlide* self);
double ease_slide_get_advance_delay (EaseSlide* self);
JsonObject* ease_background_to_json (EaseBackground* self);
JsonObject* ease_element_to_json (EaseElement* self);
void ease_slide_add (EaseSlide* self, gint index, EaseElement* e);
void ease_slide_add_actual (EaseSlide* self, gint index, EaseElement* e, gboolean emit_undo);
void ease_element_set_parent (EaseElement* self, EaseSlide* value);
void ease_undo_source_listen (EaseUndoSource* self, EaseUndoSource* source);
EaseElementAddUndoAction* ease_element_add_undo_action_new (EaseElement* e);
EaseElementAddUndoAction* ease_element_add_undo_action_construct (GType object_type, EaseElement* e);
GType ease_element_add_undo_action_get_type (void) G_GNUC_CONST;
gint ease_slide_get_count (EaseSlide* self);
void ease_slide_remove (EaseSlide* self, EaseElement* e);
void ease_slide_remove_actual (EaseSlide* self, EaseElement* e, gboolean emit_undo);
EaseElementRemoveUndoAction* ease_element_remove_undo_action_new (EaseElement* e);
EaseElementRemoveUndoAction* ease_element_remove_undo_action_construct (GType object_type, EaseElement* e);
GType ease_element_remove_undo_action_get_type (void) G_GNUC_CONST;
gint ease_slide_index_of (EaseSlide* self, EaseElement* e);
void ease_undo_source_silence (EaseUndoSource* self, EaseUndoSource* source);
const char* ease_element_get_identifier (EaseElement* self);
#define EASE_THEME_TITLE_TEXT "title-text"
#define EASE_THEME_HEADER_TEXT "header-text"
void ease_slide_remove_at (EaseSlide* self, gint index);
EaseElement* ease_slide_element_at (EaseSlide* self, gint i);
void ease_slide_raise (EaseSlide* self, EaseElement* element);
EaseElementReorderUndoAction* ease_element_reorder_undo_action_new (EaseElement* e, gint orig, gint current);
EaseElementReorderUndoAction* ease_element_reorder_undo_action_construct (GType object_type, EaseElement* e, gint orig, gint current);
GType ease_element_reorder_undo_action_get_type (void) G_GNUC_CONST;
void ease_slide_lower (EaseSlide* self, EaseElement* element);
void ease_slide_raise_top (EaseSlide* self, EaseElement* element);
void ease_slide_lower_bottom (EaseSlide* self, EaseElement* element);
void ease_slide_reorder (EaseSlide* self, EaseElement* element, gint current, gint target);
void ease_slide_cairo_render (EaseSlide* self, cairo_t* context, GError** error);
EaseDocument* ease_slide_get_parent (EaseSlide* self);
void ease_slide_cairo_render_sized (EaseSlide* self, cairo_t* context, gint w, gint h, GError** error);
gint ease_document_get_width (EaseDocument* self);
gint ease_document_get_height (EaseDocument* self);
void ease_slide_cairo_render_small (EaseSlide* self, cairo_t* context);
void ease_slide_cairo_render_background (EaseSlide* self, cairo_t* cr, gint w, gint h, GError** error);
float ease_element_get_x (EaseElement* self);
float ease_element_get_y (EaseElement* self);
void ease_element_cairo_render_small (EaseElement* self, cairo_t* context, GError** error);
void ease_element_cairo_render (EaseElement* self, cairo_t* context, GError** error);
EaseTheme* ease_slide_get_theme (EaseSlide* self);
const char* ease_theme_get_path (EaseTheme* self);
const char* ease_document_get_path (EaseDocument* self);
void ease_background_cairo_render (EaseBackground* self, cairo_t* cr, gint width, gint height, const char* path, GError** error);
GType ease_html_exporter_get_type (void) G_GNUC_CONST;
void ease_slide_to_html (EaseSlide* self, char** html, EaseHTMLExporter* exporter, double amount, gint index);
GType ease_background_type_get_type (void) G_GNUC_CONST;
EaseBackgroundType ease_background_get_background_type (EaseBackground* self);
GType ease_color_get_type (void) G_GNUC_CONST;
EaseColor* ease_background_get_color (EaseBackground* self);
void ease_color_get_clutter (EaseColor* self, ClutterColor* result);
char* ease_temp_request (GError** error);
gint ease_slide_get_width (EaseSlide* self);
gint ease_slide_get_height (EaseSlide* self);
gint ease_html_exporter_get_render_index (EaseHTMLExporter* self);
char* ease_html_exporter_copy_rendered (EaseHTMLExporter* self, const char* rendered);
char* ease_html_exporter_get_basename (EaseHTMLExporter* self);
GType ease_image_get_type (void) G_GNUC_CONST;
EaseImage* ease_background_get_image (EaseBackground* self);
const char* ease_image_get_filename (EaseImage* self);
void ease_html_exporter_copy_file (EaseHTMLExporter* self, const char* end_path, const char* base_path);
void ease_element_to_html (EaseElement* self, char** html, EaseHTMLExporter* exporter, double amount);
const char* ease_text_element_get_text (EaseTextElement* self);
char* ease_slide_get_title (EaseSlide* self);
gpointer ease_slide_iterator_ref (gpointer instance);
void ease_slide_iterator_unref (gpointer instance);
GParamSpec* ease_slide_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ease_slide_value_set_iterator (GValue* value, gpointer v_object);
void ease_slide_value_take_iterator (GValue* value, gpointer v_object);
gpointer ease_slide_value_get_iterator (const GValue* value);
GType ease_slide_iterator_get_type (void) G_GNUC_CONST;
EaseSlideIterator* ease_slide_iterator (EaseSlide* self);
gboolean ease_slide_iterator_next (EaseSlideIterator* self);
EaseElement* ease_slide_iterator_get (EaseSlideIterator* self);
EaseSlideIterator* ease_slide_iterator_new (EaseSlide* slide);
EaseSlideIterator* ease_slide_iterator_construct (GType object_type, EaseSlide* slide);
guint ease_slide_get_transition_msecs (EaseSlide* self);
void ease_slide_set_transition_msecs (EaseSlide* self, guint value);
char* ease_slide_get_background_abs (EaseSlide* self);
float ease_slide_get_aspect (EaseSlide* self);
float ease_document_get_aspect (EaseDocument* self);
void ease_slide_set_theme (EaseSlide* self, EaseTheme* value);
EaseSlide* ease_slide_get_next (EaseSlide* self);
GType ease_iterable_list_store_get_type (void) G_GNUC_CONST;
EaseIterableListStore* ease_document_get_slides (EaseDocument* self);
gint ease_iterable_list_store_get_size (EaseIterableListStore* self);
EaseSlide* ease_document_get_slide (EaseDocument* self, gint index);
EaseSlide* ease_slide_get_previous (EaseSlide* self);
#define EASE_SLIDE_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_SLIDE_TYPE_ITERATOR, EaseSlideIteratorPrivate))
enum  {
	EASE_SLIDE_ITERATOR_DUMMY_PROPERTY
};
static void ease_slide_iterator_finalize (EaseSlideIterator* obj);
static void ease_slide_finalize (GObject* obj);
static void ease_slide_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_slide_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
 * Create a new Slide.
 */
#line 207 "ease-slide.vala"
static void _lambda64_ (EaseUndoItem* item, EaseSlide* self) {
#line 207 "ease-slide.vala"
	g_return_if_fail (item != NULL);
#line 208 "ease-slide.vala"
	if (ease_background_owns_undoitem (self->priv->_background, item)) {
#line 208 "ease-slide.vala"
		g_signal_emit_by_name (self, "background-changed", self);
#line 646 "ease-slide.c"
	}
}


#line 207 "ease-slide.vala"
static void __lambda64__ease_undo_source_undo (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self) {
#line 653 "ease-slide.c"
	_lambda64_ (action, self);
}


#line 212 "ease-slide.vala"
static void _lambda65_ (EaseUndoItem* item, EaseSlide* self) {
#line 212 "ease-slide.vala"
	g_return_if_fail (item != NULL);
#line 213 "ease-slide.vala"
	if (EASE_IS_UNDO_ACTION (item)) {
#line 664 "ease-slide.c"
		{
			EaseUndoItem* _tmp0_;
			GeeIterator* _pair_it;
#line 215 "ease-slide.vala"
			_pair_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) (_tmp0_ = item, EASE_IS_UNDO_ACTION (_tmp0_) ? ((EaseUndoAction*) _tmp0_) : NULL)->pairs);
#line 215 "ease-slide.vala"
			while (TRUE) {
#line 672 "ease-slide.c"
				EaseUndoActionUndoPair* pair;
#line 215 "ease-slide.vala"
				if (!gee_iterator_next (_pair_it)) {
#line 215 "ease-slide.vala"
					break;
#line 678 "ease-slide.c"
				}
#line 215 "ease-slide.vala"
				pair = (EaseUndoActionUndoPair*) gee_iterator_get (_pair_it);
#line 217 "ease-slide.vala"
				if (_vala_strcmp0 (pair->property, "text") == 0) {
#line 217 "ease-slide.vala"
					ease_slide_update_title (self, pair->object);
#line 686 "ease-slide.c"
				}
				_ease_undo_action_undo_pair_unref0 (pair);
			}
			_g_object_unref0 (_pair_it);
		}
	}
}


#line 212 "ease-slide.vala"
static void __lambda65__ease_undo_source_forwarded (EaseUndoSource* _sender, EaseUndoItem* action, gpointer self) {
#line 698 "ease-slide.c"
	_lambda65_ (action, self);
}


#line 202 "ease-slide.vala"
EaseSlide* ease_slide_construct (GType object_type) {
#line 705 "ease-slide.c"
	EaseSlide * self;
	EaseBackground* _tmp0_;
#line 202 "ease-slide.vala"
	self = (EaseSlide*) g_object_new (object_type, NULL);
#line 204 "ease-slide.vala"
	ease_slide_set_background (self, _tmp0_ = ease_background_new ());
#line 712 "ease-slide.c"
	_g_object_unref0 (_tmp0_);
#line 207 "ease-slide.vala"
	g_signal_connect_object ((EaseUndoSource*) self, "undo", (GCallback) __lambda64__ease_undo_source_undo, self, 0);
#line 212 "ease-slide.vala"
	g_signal_connect_object ((EaseUndoSource*) self, "forwarded", (GCallback) __lambda65__ease_undo_source_forwarded, self, 0);
#line 718 "ease-slide.c"
	return self;
}


#line 202 "ease-slide.vala"
EaseSlide* ease_slide_new (void) {
#line 202 "ease-slide.vala"
	return ease_slide_construct (EASE_TYPE_SLIDE);
#line 727 "ease-slide.c"
}


/**
 * Create a new Slide assigned to a {@link Document}.
 * 
 * Used for loading previously saved files. 
 *
 * @param owner The {@link Document} this slide is a part of.
 */
#line 230 "ease-slide.vala"
EaseSlide* ease_slide_construct_with_owner (GType object_type, EaseDocument* owner) {
#line 740 "ease-slide.c"
	EaseSlide * self;
#line 230 "ease-slide.vala"
	g_return_val_if_fail (owner != NULL, NULL);
#line 232 "ease-slide.vala"
	self = (EaseSlide*) ease_slide_construct (object_type);
#line 233 "ease-slide.vala"
	ease_slide_set_parent (self, owner);
#line 748 "ease-slide.c"
	return self;
}


#line 230 "ease-slide.vala"
EaseSlide* ease_slide_new_with_owner (EaseDocument* owner) {
#line 230 "ease-slide.vala"
	return ease_slide_construct_with_owner (EASE_TYPE_SLIDE, owner);
#line 757 "ease-slide.c"
}


/**
 * Constructs a Slide from a JsonObject.
 */
#line 1057 "glib-2.0.vapi"
static gboolean string_to_bool (const char* self) {
#line 766 "ease-slide.c"
	gboolean result = FALSE;
#line 1057 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1058 "glib-2.0.vapi"
	if (_vala_strcmp0 (self, "true") == 0) {
#line 772 "ease-slide.c"
		result = TRUE;
#line 1059 "glib-2.0.vapi"
		return result;
#line 776 "ease-slide.c"
	} else {
		result = FALSE;
#line 1061 "glib-2.0.vapi"
		return result;
#line 781 "ease-slide.c"
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


#line 239 "ease-slide.vala"
EaseSlide* ease_slide_construct_from_json (GType object_type, JsonObject* obj, EaseDocument* owner) {
#line 798 "ease-slide.c"
	EaseSlide * self;
	EaseSlide* slide;
	EaseBackground* _tmp0_;
	JsonArray* elements;
#line 239 "ease-slide.vala"
	g_return_val_if_fail (obj != NULL, NULL);
#line 239 "ease-slide.vala"
	g_return_val_if_fail (owner != NULL, NULL);
#line 241 "ease-slide.vala"
	self = (EaseSlide*) ease_slide_construct (object_type);
#line 243 "ease-slide.vala"
	ease_slide_set_parent (self, owner);
#line 245 "ease-slide.vala"
	slide = ease_slide_new ();
#line 248 "ease-slide.vala"
	ease_slide_set_master (self, json_object_get_string_member (obj, "master"));
#line 251 "ease-slide.vala"
	ease_slide_set_transition (self, ease_transition_from_string (json_object_get_string_member (obj, "transition")));
#line 254 "ease-slide.vala"
	ease_slide_set_variant (self, ease_transition_variant_from_string (json_object_get_string_member (obj, "variant")));
#line 257 "ease-slide.vala"
	ease_slide_set_transition_time (self, g_ascii_strtod (json_object_get_string_member (obj, "transition_time"), NULL));
#line 259 "ease-slide.vala"
	ease_slide_set_automatically_advance (self, string_to_bool (json_object_get_string_member (obj, "automatically_advance")));
#line 262 "ease-slide.vala"
	ease_slide_set_advance_delay (self, g_ascii_strtod (json_object_get_string_member (obj, "advance_delay"), NULL));
#line 266 "ease-slide.vala"
	ease_slide_set_background (self, _tmp0_ = ease_background_new_from_json (json_object_get_object_member (obj, EASE_THEME_BACKGROUND)));
#line 827 "ease-slide.c"
	_g_object_unref0 (_tmp0_);
#line 270 "ease-slide.vala"
	elements = _json_array_ref0 (json_object_get_array_member (obj, "elements"));
#line 831 "ease-slide.c"
	{
		gint i;
#line 272 "ease-slide.vala"
		i = 0;
#line 836 "ease-slide.c"
		{
			gboolean _tmp1_;
#line 272 "ease-slide.vala"
			_tmp1_ = TRUE;
#line 272 "ease-slide.vala"
			while (TRUE) {
#line 843 "ease-slide.c"
				JsonObject* node;
				char* type;
				EaseElement* e;
				const char* _tmp7_;
				GQuark _tmp8_;
#line 272 "ease-slide.vala"
				if (!_tmp1_) {
#line 272 "ease-slide.vala"
					i++;
#line 853 "ease-slide.c"
				}
#line 272 "ease-slide.vala"
				_tmp1_ = FALSE;
#line 272 "ease-slide.vala"
				if (!(i < json_array_get_length (elements))) {
#line 272 "ease-slide.vala"
					break;
#line 861 "ease-slide.c"
				}
#line 274 "ease-slide.vala"
				node = _json_object_ref0 (json_array_get_object_element (elements, (guint) i));
#line 277 "ease-slide.vala"
				type = g_strdup (json_object_get_string_member (node, EASE_THEME_ELEMENT_TYPE));
#line 867 "ease-slide.c"
				e = NULL;
				_tmp7_ = type;
				_tmp8_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp8_ == g_quark_from_string (EASE_SLIDE_IMAGE_TYPE))
				switch (0) {
					default:
					{
						EaseElement* _tmp2_;
#line 283 "ease-slide.vala"
						e = (_tmp2_ = (EaseElement*) ease_image_element_new_from_json (node), _g_object_unref0 (e), _tmp2_);
#line 284 "ease-slide.vala"
						break;
#line 880 "ease-slide.c"
					}
				} else if (_tmp8_ == g_quark_from_string (EASE_SLIDE_SHAPE_TYPE))
				switch (0) {
					default:
					{
						EaseElement* _tmp3_;
#line 286 "ease-slide.vala"
						e = (_tmp3_ = (EaseElement*) ease_shape_element_new_from_json (node), _g_object_unref0 (e), _tmp3_);
#line 287 "ease-slide.vala"
						break;
#line 891 "ease-slide.c"
					}
				} else if (_tmp8_ == g_quark_from_string (EASE_SLIDE_VIDEO_TYPE))
				switch (0) {
					default:
					{
						EaseElement* _tmp4_;
#line 289 "ease-slide.vala"
						e = (_tmp4_ = (EaseElement*) ease_video_element_new_from_json (node), _g_object_unref0 (e), _tmp4_);
#line 290 "ease-slide.vala"
						break;
#line 902 "ease-slide.c"
					}
				} else if (_tmp8_ == g_quark_from_string (EASE_SLIDE_PDF_TYPE))
				switch (0) {
					default:
					{
						EaseElement* _tmp5_;
#line 292 "ease-slide.vala"
						e = (_tmp5_ = (EaseElement*) ease_pdf_element_new_from_json (node, self), _g_object_unref0 (e), _tmp5_);
#line 293 "ease-slide.vala"
						break;
#line 913 "ease-slide.c"
					}
				} else
				switch (0) {
					default:
					{
						EaseElement* _tmp6_;
#line 295 "ease-slide.vala"
						e = (_tmp6_ = (EaseElement*) ease_text_element_new_from_json (node), _g_object_unref0 (e), _tmp6_);
#line 296 "ease-slide.vala"
						break;
#line 924 "ease-slide.c"
					}
				}
#line 299 "ease-slide.vala"
				ease_element_set_element_type (e, type);
#line 300 "ease-slide.vala"
				ease_slide_append (self, e);
#line 931 "ease-slide.c"
				_g_object_unref0 (e);
				_g_free0 (type);
				_json_object_unref0 (node);
			}
		}
	}
	_json_array_unref0 (elements);
	_g_object_unref0 (slide);
	return self;
}


#line 239 "ease-slide.vala"
EaseSlide* ease_slide_new_from_json (JsonObject* obj, EaseDocument* owner) {
#line 239 "ease-slide.vala"
	return ease_slide_construct_from_json (EASE_TYPE_SLIDE, obj, owner);
#line 948 "ease-slide.c"
}


#line 687 "glib-2.0.vapi"
static char* double_to_string (double self) {
#line 954 "ease-slide.c"
	char* result = NULL;
	gchar* _tmp0_;
	gint _tmp0__length1;
	char* _tmp1_;
	result = (_tmp1_ = g_strdup (g_ascii_dtostr ((_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE), _tmp0__length1 = G_ASCII_DTOSTR_BUF_SIZE, _tmp0_), G_ASCII_DTOSTR_BUF_SIZE, self)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
#line 688 "glib-2.0.vapi"
	return result;
#line 962 "ease-slide.c"
}


#line 35 "glib-2.0.vapi"
static char* bool_to_string (gboolean self) {
#line 968 "ease-slide.c"
	char* result = NULL;
#line 36 "glib-2.0.vapi"
	if (self) {
#line 972 "ease-slide.c"
		result = g_strdup ("true");
#line 37 "glib-2.0.vapi"
		return result;
#line 976 "ease-slide.c"
	} else {
		result = g_strdup ("false");
#line 39 "glib-2.0.vapi"
		return result;
#line 981 "ease-slide.c"
	}
}


#line 304 "ease-slide.vala"
JsonNode* ease_slide_to_json (EaseSlide* self) {
#line 988 "ease-slide.c"
	JsonNode* result = NULL;
	JsonNode* node;
	JsonObject* obj;
	GEnumValue* _tmp0_;
	GEnumValue* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	JsonArray* json_elements;
#line 304 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 306 "ease-slide.vala"
	node = json_node_new (JSON_NODE_OBJECT);
#line 307 "ease-slide.vala"
	obj = json_object_new ();
#line 310 "ease-slide.vala"
	json_object_set_string_member (obj, "master", self->priv->_master);
#line 313 "ease-slide.vala"
	json_object_set_string_member (obj, "transition", (_tmp0_ = g_enum_get_value (g_type_class_ref (EASE_TYPE_TRANSITION), (int) self->priv->_transition), (_tmp0_ != NULL) ? _tmp0_->value_name : NULL));
#line 314 "ease-slide.vala"
	json_object_set_string_member (obj, "variant", (_tmp1_ = g_enum_get_value (g_type_class_ref (EASE_TYPE_TRANSITION_VARIANT), (int) self->priv->_variant), (_tmp1_ != NULL) ? _tmp1_->value_name : NULL));
#line 315 "ease-slide.vala"
	json_object_set_string_member (obj, "transition_time", _tmp2_ = double_to_string (self->priv->_transition_time));
#line 1012 "ease-slide.c"
	_g_free0 (_tmp2_);
#line 316 "ease-slide.vala"
	json_object_set_string_member (obj, "automatically_advance", _tmp3_ = bool_to_string (self->priv->_automatically_advance));
#line 1016 "ease-slide.c"
	_g_free0 (_tmp3_);
#line 318 "ease-slide.vala"
	json_object_set_string_member (obj, "advance_delay", _tmp4_ = double_to_string (self->priv->_advance_delay));
#line 1020 "ease-slide.c"
	_g_free0 (_tmp4_);
#line 321 "ease-slide.vala"
	json_object_set_object_member (obj, EASE_THEME_BACKGROUND, ease_background_to_json (self->priv->_background));
#line 324 "ease-slide.vala"
	json_elements = json_array_new ();
#line 1026 "ease-slide.c"
	{
		GeeIterator* _e_it;
#line 325 "ease-slide.vala"
		_e_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->elements);
#line 325 "ease-slide.vala"
		while (TRUE) {
#line 1033 "ease-slide.c"
			EaseElement* e;
			JsonNode* e_node;
			JsonObject* _tmp5_;
#line 325 "ease-slide.vala"
			if (!gee_iterator_next (_e_it)) {
#line 325 "ease-slide.vala"
				break;
#line 1041 "ease-slide.c"
			}
#line 325 "ease-slide.vala"
			e = (EaseElement*) gee_iterator_get (_e_it);
#line 327 "ease-slide.vala"
			e_node = json_node_new (JSON_NODE_OBJECT);
#line 328 "ease-slide.vala"
			json_node_set_object (e_node, _tmp5_ = ease_element_to_json (e));
#line 1049 "ease-slide.c"
			_json_object_unref0 (_tmp5_);
#line 329 "ease-slide.vala"
			json_array_add_element (json_elements, json_node_copy (e_node));
#line 1053 "ease-slide.c"
			_json_node_free0 (e_node);
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
#line 332 "ease-slide.vala"
	json_object_set_array_member (obj, "elements", _json_array_ref0 (json_elements));
#line 334 "ease-slide.vala"
	json_node_set_object (node, obj);
#line 1063 "ease-slide.c"
	result = node;
	_json_array_unref0 (json_elements);
	_json_object_unref0 (obj);
#line 335 "ease-slide.vala"
	return result;
#line 1069 "ease-slide.c"
}


/**
 * Adds an {@link Element} to this slide at a specified index.
 *
 * @param index The index to add the {@link Element} at.
 * @param e The {@link Element} to add.
 */
#line 344 "ease-slide.vala"
void ease_slide_add (EaseSlide* self, gint index, EaseElement* e) {
#line 344 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 344 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 346 "ease-slide.vala"
	ease_slide_add_actual (self, index, e, TRUE);
#line 1087 "ease-slide.c"
}


/**
 * Actual adds an Element.
 */
#line 352 "ease-slide.vala"
void ease_slide_add_actual (EaseSlide* self, gint index, EaseElement* e, gboolean emit_undo) {
#line 352 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 352 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 354 "ease-slide.vala"
	ease_element_set_parent (e, self);
#line 355 "ease-slide.vala"
	gee_abstract_list_insert ((GeeAbstractList*) self->elements, index, e);
#line 356 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-added", self, e, index);
#line 357 "ease-slide.vala"
	ease_undo_source_listen ((EaseUndoSource*) self, (EaseUndoSource*) e);
#line 358 "ease-slide.vala"
	ease_slide_update_title (self, (GObject*) e);
#line 359 "ease-slide.vala"
	if (emit_undo) {
#line 1112 "ease-slide.c"
		EaseElementAddUndoAction* _tmp0_;
#line 359 "ease-slide.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp0_ = ease_element_add_undo_action_new (e)));
#line 1116 "ease-slide.c"
		_g_object_unref0 (_tmp0_);
	}
#line 360 "ease-slide.vala"
	g_signal_emit_by_name (self, "changed", self);
#line 1121 "ease-slide.c"
}


/**
 * Adds an {@link Element} to this slide at the end index.
 * 
 * @param e The element to add;.
 */
#line 368 "ease-slide.vala"
void ease_slide_append (EaseSlide* self, EaseElement* e) {
#line 368 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 368 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 370 "ease-slide.vala"
	ease_slide_add (self, ease_slide_get_count (self), e);
#line 1138 "ease-slide.c"
}


/**
 * Removes an {@link Element} from this slide.
 */
#line 376 "ease-slide.vala"
void ease_slide_remove (EaseSlide* self, EaseElement* e) {
#line 376 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 376 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 378 "ease-slide.vala"
	ease_slide_remove_actual (self, e, TRUE);
#line 1153 "ease-slide.c"
}


/**
 * Actually removes an Element.
 */
#line 384 "ease-slide.vala"
void ease_slide_remove_actual (EaseSlide* self, EaseElement* e, gboolean emit_undo) {
#line 1162 "ease-slide.c"
	gint index;
#line 384 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 384 "ease-slide.vala"
	g_return_if_fail (e != NULL);
#line 386 "ease-slide.vala"
	if (emit_undo) {
#line 1170 "ease-slide.c"
		EaseElementRemoveUndoAction* _tmp0_;
#line 386 "ease-slide.vala"
		g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp0_ = ease_element_remove_undo_action_new (e)));
#line 1174 "ease-slide.c"
		_g_object_unref0 (_tmp0_);
	}
#line 387 "ease-slide.vala"
	index = ease_slide_index_of (self, e);
#line 388 "ease-slide.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->elements, e);
#line 389 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-removed", self, e, index);
#line 390 "ease-slide.vala"
	ease_undo_source_silence ((EaseUndoSource*) self, (EaseUndoSource*) e);
#line 392 "ease-slide.vala"
	if (EASE_IS_TEXT_ELEMENT (e)) {
#line 1187 "ease-slide.c"
		gboolean _tmp1_ = FALSE;
		EaseElement* _tmp2_;
#line 394 "ease-slide.vala"
		if (_vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp2_ = e, EASE_IS_TEXT_ELEMENT (_tmp2_) ? ((EaseTextElement*) _tmp2_) : NULL)), EASE_THEME_TITLE_TEXT) == 0) {
#line 394 "ease-slide.vala"
			_tmp1_ = TRUE;
#line 1194 "ease-slide.c"
		} else {
			EaseElement* _tmp3_;
#line 395 "ease-slide.vala"
			_tmp1_ = _vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp3_ = e, EASE_IS_TEXT_ELEMENT (_tmp3_) ? ((EaseTextElement*) _tmp3_) : NULL)), EASE_THEME_HEADER_TEXT) == 0;
#line 1199 "ease-slide.c"
		}
#line 394 "ease-slide.vala"
		if (_tmp1_) {
#line 397 "ease-slide.vala"
			g_signal_emit_by_name (self, "title-reset", self);
#line 1205 "ease-slide.c"
		}
	}
#line 400 "ease-slide.vala"
	g_signal_emit_by_name (self, "changed", self);
#line 1210 "ease-slide.c"
}


/**
 * Removed an {@link Element} from this slide, by index.
 */
#line 406 "ease-slide.vala"
void ease_slide_remove_at (EaseSlide* self, gint index) {
#line 1219 "ease-slide.c"
	EaseElement* e;
#line 406 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 408 "ease-slide.vala"
	e = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->elements, index);
#line 409 "ease-slide.vala"
	ease_slide_remove (self, e);
#line 1227 "ease-slide.c"
	_g_object_unref0 (e);
}


/**
 * Returns the index of the specified {@link Element}
 */
#line 415 "ease-slide.vala"
gint ease_slide_index_of (EaseSlide* self, EaseElement* e) {
#line 1237 "ease-slide.c"
	gint result = 0;
#line 415 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 415 "ease-slide.vala"
	g_return_val_if_fail (e != NULL, 0);
#line 1243 "ease-slide.c"
	result = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, e);
#line 417 "ease-slide.vala"
	return result;
#line 1247 "ease-slide.c"
}


/**
 * Returns the {@link Element} at the specified index.
 */
#line 423 "ease-slide.vala"
EaseElement* ease_slide_element_at (EaseSlide* self, gint i) {
#line 1256 "ease-slide.c"
	EaseElement* result = NULL;
#line 423 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1260 "ease-slide.c"
	result = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->elements, i);
#line 425 "ease-slide.vala"
	return result;
#line 1264 "ease-slide.c"
}


/**
 * Raises the given element up one index. Automatically sends an
 * {@link UndoItem}.
 */
#line 432 "ease-slide.vala"
void ease_slide_raise (EaseSlide* self, EaseElement* element) {
#line 1274 "ease-slide.c"
	EaseElement* _tmp0_;
	gboolean _tmp1_;
	gint index;
	EaseElement* temp;
	EaseElementReorderUndoAction* _tmp2_;
#line 432 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 432 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 434 "ease-slide.vala"
	if ((_tmp1_ = element == (_tmp0_ = (EaseElement*) gee_abstract_list_last ((GeeAbstractList*) self->elements)), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 434 "ease-slide.vala"
		return;
#line 1288 "ease-slide.c"
	}
#line 436 "ease-slide.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element);
#line 437 "ease-slide.vala"
	temp = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->elements, index + 1);
#line 438 "ease-slide.vala"
	gee_abstract_list_set ((GeeAbstractList*) self->elements, index + 1, element);
#line 439 "ease-slide.vala"
	gee_abstract_list_set ((GeeAbstractList*) self->elements, index, temp);
#line 440 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 441 "ease-slide.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_element_reorder_undo_action_new (element, index, index + 1)));
#line 1302 "ease-slide.c"
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (temp);
}


/**
 * Lowers the given element down one index. Automatically sends an
 * {@link UndoItem}.
 */
#line 448 "ease-slide.vala"
void ease_slide_lower (EaseSlide* self, EaseElement* element) {
#line 1314 "ease-slide.c"
	EaseElement* _tmp0_;
	gboolean _tmp1_;
	gint index;
	EaseElement* temp;
	EaseElementReorderUndoAction* _tmp2_;
#line 448 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 448 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 450 "ease-slide.vala"
	if ((_tmp1_ = element == (_tmp0_ = (EaseElement*) gee_abstract_list_first ((GeeAbstractList*) self->elements)), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 450 "ease-slide.vala"
		return;
#line 1328 "ease-slide.c"
	}
#line 452 "ease-slide.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element);
#line 453 "ease-slide.vala"
	temp = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->elements, index - 1);
#line 454 "ease-slide.vala"
	gee_abstract_list_set ((GeeAbstractList*) self->elements, index - 1, element);
#line 455 "ease-slide.vala"
	gee_abstract_list_set ((GeeAbstractList*) self->elements, index, temp);
#line 456 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 457 "ease-slide.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_element_reorder_undo_action_new (element, index, index - 1)));
#line 1342 "ease-slide.c"
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (temp);
}


/**
 * Raises the element to the top. Automatically sends an
 * {@link UndoItem}.
 */
#line 464 "ease-slide.vala"
void ease_slide_raise_top (EaseSlide* self, EaseElement* element) {
#line 1354 "ease-slide.c"
	EaseElement* _tmp0_;
	gboolean _tmp1_;
	gint index;
	EaseElementReorderUndoAction* _tmp2_;
#line 464 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 464 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 466 "ease-slide.vala"
	if ((_tmp1_ = element == (_tmp0_ = (EaseElement*) gee_abstract_list_last ((GeeAbstractList*) self->elements)), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 466 "ease-slide.vala"
		return;
#line 1367 "ease-slide.c"
	}
#line 468 "ease-slide.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element);
#line 469 "ease-slide.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->elements, element);
#line 470 "ease-slide.vala"
	gee_deque_offer_tail ((GeeDeque*) self->elements, element);
#line 471 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 472 "ease-slide.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_element_reorder_undo_action_new (element, index, gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element))));
#line 1379 "ease-slide.c"
	_g_object_unref0 (_tmp2_);
}


/**
 * Lowers the element to the bottom. Automatically sends an
 * {@link UndoItem}.
 */
#line 480 "ease-slide.vala"
void ease_slide_lower_bottom (EaseSlide* self, EaseElement* element) {
#line 1390 "ease-slide.c"
	EaseElement* _tmp0_;
	gboolean _tmp1_;
	gint index;
	EaseElementReorderUndoAction* _tmp2_;
#line 480 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 480 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 482 "ease-slide.vala"
	if ((_tmp1_ = element == (_tmp0_ = (EaseElement*) gee_abstract_list_first ((GeeAbstractList*) self->elements)), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 482 "ease-slide.vala"
		return;
#line 1403 "ease-slide.c"
	}
#line 484 "ease-slide.vala"
	index = gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element);
#line 485 "ease-slide.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->elements, element);
#line 486 "ease-slide.vala"
	gee_deque_offer_head ((GeeDeque*) self->elements, element);
#line 487 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 488 "ease-slide.vala"
	g_signal_emit_by_name ((EaseUndoSource*) self, "undo", (EaseUndoItem*) (_tmp2_ = ease_element_reorder_undo_action_new (element, index, gee_abstract_list_index_of ((GeeAbstractList*) self->elements, element))));
#line 1415 "ease-slide.c"
	_g_object_unref0 (_tmp2_);
}


/**
 * Reorders an Element. Does not create an {@link UndoItem}.
 */
#line 495 "ease-slide.vala"
void ease_slide_reorder (EaseSlide* self, EaseElement* element, gint current, gint target) {
#line 495 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 495 "ease-slide.vala"
	g_return_if_fail (element != NULL);
#line 497 "ease-slide.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->elements, element);
#line 498 "ease-slide.vala"
	gee_abstract_list_insert ((GeeAbstractList*) self->elements, target, element);
#line 499 "ease-slide.vala"
	g_signal_emit_by_name (self, "element-reordered", self, element);
#line 1435 "ease-slide.c"
}


/** 
 * Draws the {@link Slide} to a Cairo.Context.
 *
 * @param context The Cairo.Context to draw to.
 */
#line 507 "ease-slide.vala"
void ease_slide_cairo_render (EaseSlide* self, cairo_t* context, GError** error) {
#line 1446 "ease-slide.c"
	GError * _inner_error_ = NULL;
#line 507 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 507 "ease-slide.vala"
	g_return_if_fail (context != NULL);
#line 509 "ease-slide.vala"
	if (self->priv->_parent == NULL) {
#line 1454 "ease-slide.c"
		_inner_error_ = g_error_new ((GQuark) 0, 0, "Slide must have a parent document");
		{
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
#line 512 "ease-slide.vala"
	ease_slide_cairo_render_sized (self, context, ease_document_get_width (self->priv->_parent), ease_document_get_height (self->priv->_parent), &_inner_error_);
#line 1463 "ease-slide.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
 * Draws the Slide to a thumbnail-sized Cairo.Context. Will call
 * {@link Element.cairo_render_small} instead of
 * {@link Element.cairo_render}.
 *
 * @param context The Cairo.Context to draw to.
 */
#line 522 "ease-slide.vala"
void ease_slide_cairo_render_small (EaseSlide* self, cairo_t* context) {
#line 1480 "ease-slide.c"
	GError * _inner_error_ = NULL;
#line 522 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 522 "ease-slide.vala"
	g_return_if_fail (context != NULL);
#line 524 "ease-slide.vala"
	cairo_save (context);
#line 525 "ease-slide.vala"
	ease_slide_cairo_render_background (self, context, ease_document_get_width (self->priv->_parent), ease_document_get_height (self->priv->_parent), &_inner_error_);
#line 1490 "ease-slide.c"
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 526 "ease-slide.vala"
	cairo_restore (context);
#line 1498 "ease-slide.c"
	{
		GeeIterator* _e_it;
#line 528 "ease-slide.vala"
		_e_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->elements);
#line 528 "ease-slide.vala"
		while (TRUE) {
#line 1505 "ease-slide.c"
			EaseElement* e;
#line 528 "ease-slide.vala"
			if (!gee_iterator_next (_e_it)) {
#line 528 "ease-slide.vala"
				break;
#line 1511 "ease-slide.c"
			}
#line 528 "ease-slide.vala"
			e = (EaseElement*) gee_iterator_get (_e_it);
#line 530 "ease-slide.vala"
			cairo_save (context);
#line 531 "ease-slide.vala"
			cairo_translate (context, (double) ease_element_get_x (e), (double) ease_element_get_y (e));
#line 532 "ease-slide.vala"
			ease_element_cairo_render_small (e, context, &_inner_error_);
#line 1521 "ease-slide.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (e);
				_g_object_unref0 (_e_it);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
#line 533 "ease-slide.vala"
			cairo_restore (context);
#line 1531 "ease-slide.c"
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
}


/** 
 * Draws the {@link Slide} to a Cairo.Context at a specified size.
 *
 * @param context The Cairo.Context to draw to.
 * @param w The width to render at.
 * @param h The height to render at.
 */
#line 544 "ease-slide.vala"
void ease_slide_cairo_render_sized (EaseSlide* self, cairo_t* context, gint w, gint h, GError** error) {
#line 1548 "ease-slide.c"
	GError * _inner_error_ = NULL;
#line 544 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 544 "ease-slide.vala"
	g_return_if_fail (context != NULL);
#line 547 "ease-slide.vala"
	cairo_save (context);
#line 548 "ease-slide.vala"
	ease_slide_cairo_render_background (self, context, w, h, &_inner_error_);
#line 1558 "ease-slide.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 549 "ease-slide.vala"
	cairo_restore (context);
#line 1565 "ease-slide.c"
	{
		GeeIterator* _e_it;
#line 551 "ease-slide.vala"
		_e_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->elements);
#line 551 "ease-slide.vala"
		while (TRUE) {
#line 1572 "ease-slide.c"
			EaseElement* e;
#line 551 "ease-slide.vala"
			if (!gee_iterator_next (_e_it)) {
#line 551 "ease-slide.vala"
				break;
#line 1578 "ease-slide.c"
			}
#line 551 "ease-slide.vala"
			e = (EaseElement*) gee_iterator_get (_e_it);
#line 553 "ease-slide.vala"
			cairo_save (context);
#line 554 "ease-slide.vala"
			cairo_translate (context, (double) ease_element_get_x (e), (double) ease_element_get_y (e));
#line 555 "ease-slide.vala"
			ease_element_cairo_render (e, context, &_inner_error_);
#line 1588 "ease-slide.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (e);
				_g_object_unref0 (_e_it);
				return;
			}
#line 556 "ease-slide.vala"
			cairo_restore (context);
#line 1597 "ease-slide.c"
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
}


/** 
 * Draws the slide's background to a Cairo.Context at a specified size.
 *
 * @param cr The Cairo.Context to draw to.
 * @param w The width to render at.
 * @param h The height to render at.
 */
#line 567 "ease-slide.vala"
void ease_slide_cairo_render_background (EaseSlide* self, cairo_t* cr, gint w, gint h, GError** error) {
#line 1614 "ease-slide.c"
	const char* _tmp0_;
	GError * _inner_error_ = NULL;
#line 567 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 567 "ease-slide.vala"
	g_return_if_fail (cr != NULL);
#line 1621 "ease-slide.c"
	_tmp0_ = NULL;
#line 571 "ease-slide.vala"
	if (self->priv->_parent == NULL) {
#line 571 "ease-slide.vala"
		_tmp0_ = ease_theme_get_path (self->priv->_theme);
#line 1627 "ease-slide.c"
	} else {
#line 571 "ease-slide.vala"
		_tmp0_ = ease_document_get_path (self->priv->_parent);
#line 1631 "ease-slide.c"
	}
#line 570 "ease-slide.vala"
	ease_background_cairo_render (self->priv->_background, cr, w, h, _tmp0_, &_inner_error_);
#line 1635 "ease-slide.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
 * Creates HTML markup for this Slide.
 * 
 * The <div> tag for this Slide is appended to the "HTML" parameter.
 *
 * @param html The HTML string in its current state.
 * @param exporter The {@link HTMLExporter}, for the path and progress.
 * @param amount The amount progress should increase by when done.
 * @param index The index of this slide.
 */
static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
#line 1170 "glib-2.0.vapi"
	return result;
#line 1659 "ease-slide.c"
}


#line 1086 "glib-2.0.vapi"
static char* string_substring (const char* self, glong offset, glong len) {
#line 1665 "ease-slide.c"
	char* result = NULL;
	glong string_length;
	const char* start;
#line 1086 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1087 "glib-2.0.vapi"
	string_length = string_get_length (self);
#line 1088 "glib-2.0.vapi"
	if (offset < 0) {
#line 1089 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1090 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= 0, NULL);
#line 1679 "ease-slide.c"
	} else {
#line 1092 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1683 "ease-slide.c"
	}
#line 1094 "glib-2.0.vapi"
	if (len < 0) {
#line 1095 "glib-2.0.vapi"
		len = string_length - offset;
#line 1689 "ease-slide.c"
	}
#line 1097 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1098 "glib-2.0.vapi"
	start = g_utf8_offset_to_pointer (self, offset);
#line 1695 "ease-slide.c"
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
#line 1099 "glib-2.0.vapi"
	return result;
#line 1699 "ease-slide.c"
}


#line 1157 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 1705 "ease-slide.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1714 "ease-slide.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1159 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 1722 "ease-slide.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1160 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 1733 "ease-slide.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1160 "glib-2.0.vapi"
		return result;
#line 1748 "ease-slide.c"
	}
	goto __finally31;
	__catch31_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1162 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 1759 "ease-slide.c"
			_g_error_free0 (e);
		}
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 584 "ease-slide.vala"
void ease_slide_to_html (EaseSlide* self, char** html, EaseHTMLExporter* exporter, double amount, gint index) {
#line 1774 "ease-slide.c"
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp48_;
	GError * _inner_error_ = NULL;
#line 584 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 584 "ease-slide.vala"
	g_return_if_fail (html != NULL);
#line 584 "ease-slide.vala"
	g_return_if_fail (exporter != NULL);
#line 590 "ease-slide.vala"
	*html = (_tmp3_ = g_strconcat (*html, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("<div class=\"slide\" id=\"slide", _tmp0_ = g_strdup_printf ("%i", index), NULL), "\" ", NULL), NULL), _g_free0 (*html), _tmp3_);
#line 1789 "ease-slide.c"
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
#line 593 "ease-slide.vala"
	switch (ease_background_get_background_type (self->priv->_background)) {
#line 1795 "ease-slide.c"
		case EASE_BACKGROUND_TYPE_COLOR:
		{
			ClutterColor _tmp4_ = {0};
			ClutterColor _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			char* _tmp8_;
			char* _tmp9_;
			char* _tmp10_;
#line 597 "ease-slide.vala"
			*html = (_tmp10_ = g_strconcat (*html, _tmp9_ = g_strconcat (_tmp8_ = g_strconcat ("style=\"background-color: ", _tmp7_ = string_substring (_tmp6_ = clutter_color_to_string ((_tmp5_ = (ease_color_get_clutter (ease_background_get_color (self->priv->_background), &_tmp4_), _tmp4_), &_tmp5_)), (glong) 0, (glong) 7), NULL), "\">", NULL), NULL), _g_free0 (*html), _tmp10_);
#line 1807 "ease-slide.c"
			_g_free0 (_tmp9_);
			_g_free0 (_tmp8_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp6_);
#line 600 "ease-slide.vala"
			break;
#line 1814 "ease-slide.c"
		}
		case EASE_BACKGROUND_TYPE_GRADIENT:
		{
			char* _tmp11_;
			char* dir;
			cairo_surface_t* surface;
			cairo_t* cr;
			char* _tmp12_;
			char* _tmp13_;
			char* path;
			char* output;
			char* _tmp14_;
			char* _tmp15_;
			char* _tmp16_;
			char* _tmp17_;
			char* _tmp18_;
			char* _tmp19_;
			char* _tmp20_;
			char* _tmp21_;
			char* _tmp22_;
			char* _tmp23_;
			char* _tmp24_;
			char* _tmp25_;
			char* _tmp26_;
			char* _tmp27_;
			char* _tmp28_;
			char* _tmp29_;
			char* _tmp30_;
			char* _tmp31_;
			char* _tmp32_;
			char* _tmp33_;
#line 604 "ease-slide.vala"
			*html = (_tmp11_ = g_strconcat (*html, ">", NULL), _g_free0 (*html), _tmp11_);
#line 606 "ease-slide.vala"
			dir = ease_temp_request (&_inner_error_);
#line 1850 "ease-slide.c"
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
#line 607 "ease-slide.vala"
			surface = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) ease_slide_get_width (self), (gint) ease_slide_get_height (self));
#line 609 "ease-slide.vala"
			cr = cairo_create (surface);
#line 610 "ease-slide.vala"
			ease_slide_cairo_render (self, cr, &_inner_error_);
#line 1862 "ease-slide.c"
			if (_inner_error_ != NULL) {
				_cairo_destroy0 (cr);
				_cairo_surface_destroy0 (surface);
				_g_free0 (dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
#line 612 "ease-slide.vala"
			path = (_tmp13_ = g_build_filename (dir, _tmp12_ = g_strdup_printf ("%i", ease_html_exporter_get_render_index (exporter)), NULL), _g_free0 (_tmp12_), _tmp13_);
#line 614 "ease-slide.vala"
			cairo_surface_write_to_png (surface, path);
#line 615 "ease-slide.vala"
			output = ease_html_exporter_copy_rendered (exporter, path);
#line 618 "ease-slide.vala"
			*html = (_tmp14_ = g_strconcat (*html, "<img ", NULL), _g_free0 (*html), _tmp14_);
#line 621 "ease-slide.vala"
			*html = (_tmp15_ = g_strconcat (*html, "style=\"", NULL), _g_free0 (*html), _tmp15_);
#line 622 "ease-slide.vala"
			*html = (_tmp16_ = g_strconcat (*html, "left: 0px;", NULL), _g_free0 (*html), _tmp16_);
#line 623 "ease-slide.vala"
			*html = (_tmp17_ = g_strconcat (*html, " top: 0px;", NULL), _g_free0 (*html), _tmp17_);
#line 624 "ease-slide.vala"
			*html = (_tmp21_ = g_strconcat (*html, _tmp20_ = g_strconcat (_tmp19_ = g_strconcat (" width:", _tmp18_ = g_strdup_printf ("%i", ease_document_get_width (self->priv->_parent)), NULL), "px;", NULL), NULL), _g_free0 (*html), _tmp21_);
#line 1887 "ease-slide.c"
			_g_free0 (_tmp20_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp18_);
#line 625 "ease-slide.vala"
			*html = (_tmp25_ = g_strconcat (*html, _tmp24_ = g_strconcat (_tmp23_ = g_strconcat (" height:", _tmp22_ = g_strdup_printf ("%i", ease_document_get_height (self->priv->_parent)), NULL), "px;", NULL), NULL), _g_free0 (*html), _tmp25_);
#line 1893 "ease-slide.c"
			_g_free0 (_tmp24_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp22_);
#line 626 "ease-slide.vala"
			*html = (_tmp26_ = g_strconcat (*html, " position: absolute;\" ", NULL), _g_free0 (*html), _tmp26_);
#line 629 "ease-slide.vala"
			*html = (_tmp33_ = g_strconcat (*html, _tmp32_ = g_strconcat (_tmp31_ = g_strconcat ("src=\"", _tmp30_ = string_replace (_tmp29_ = g_strconcat (_tmp28_ = g_strconcat (_tmp27_ = ease_html_exporter_get_basename (exporter), " Media/", NULL), output, NULL), " ", "%20"), NULL), "\" alt=\"PDF\" />", NULL), NULL), _g_free0 (*html), _tmp33_);
#line 1901 "ease-slide.c"
			_g_free0 (_tmp32_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp27_);
			_g_free0 (output);
			_g_free0 (path);
			_cairo_destroy0 (cr);
			_cairo_surface_destroy0 (surface);
			_g_free0 (dir);
#line 634 "ease-slide.vala"
			break;
#line 1915 "ease-slide.c"
		}
		case EASE_BACKGROUND_TYPE_IMAGE:
		{
			char* _tmp34_;
			char* _tmp35_;
			char* _tmp36_;
			char* _tmp37_;
			char* _tmp38_;
			char* _tmp39_;
			char* _tmp40_;
			char* _tmp41_;
			char* _tmp42_;
			char* _tmp43_;
			char* _tmp44_;
			char* _tmp45_;
			char* _tmp46_;
			char* _tmp47_;
#line 638 "ease-slide.vala"
			*html = (_tmp34_ = g_strconcat (*html, ">", NULL), _g_free0 (*html), _tmp34_);
#line 641 "ease-slide.vala"
			*html = (_tmp47_ = g_strconcat (*html, _tmp46_ = g_strconcat (_tmp45_ = g_strconcat (_tmp43_ = g_strconcat (_tmp42_ = g_strconcat (_tmp40_ = g_strconcat (_tmp39_ = g_strconcat ("<img src=\"", _tmp38_ = string_replace (_tmp37_ = g_strconcat (_tmp36_ = g_strconcat (_tmp35_ = ease_html_exporter_get_basename (exporter), " ", NULL), ease_image_get_filename (ease_background_get_image (self->priv->_background)), NULL), " ", "%20"), NULL), "\" alt=\"Background\" width=\"", NULL), _tmp41_ = g_strdup_printf ("%i", ease_document_get_width (self->priv->_parent)), NULL), "\" height=\"", NULL), _tmp44_ = g_strdup_printf ("%i", ease_document_get_height (self->priv->_parent)), NULL), "\"/>", NULL), NULL), _g_free0 (*html), _tmp47_);
#line 1937 "ease-slide.c"
			_g_free0 (_tmp46_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp35_);
#line 649 "ease-slide.vala"
			ease_html_exporter_copy_file (exporter, ease_image_get_filename (ease_background_get_image (self->priv->_background)), ease_document_get_path (self->priv->_parent));
#line 650 "ease-slide.vala"
			break;
#line 1954 "ease-slide.c"
		}
	}
	{
		GeeIterator* _e_it;
#line 654 "ease-slide.vala"
		_e_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->elements);
#line 654 "ease-slide.vala"
		while (TRUE) {
#line 1963 "ease-slide.c"
			EaseElement* e;
#line 654 "ease-slide.vala"
			if (!gee_iterator_next (_e_it)) {
#line 654 "ease-slide.vala"
				break;
#line 1969 "ease-slide.c"
			}
#line 654 "ease-slide.vala"
			e = (EaseElement*) gee_iterator_get (_e_it);
#line 656 "ease-slide.vala"
			ease_element_to_html (e, html, exporter, amount / gee_collection_get_size ((GeeCollection*) self->elements));
#line 1975 "ease-slide.c"
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
#line 659 "ease-slide.vala"
	*html = (_tmp48_ = g_strconcat (*html, "</div>\n", NULL), _g_free0 (*html), _tmp48_);
#line 1982 "ease-slide.c"
}


/**
 * Updates the slide's title if the given object is a TextElement with the
 * {@link Theme.TITLE_TEXT} or {@link Theme.HEADER_TEXT} identifier.
 */
#line 666 "ease-slide.vala"
static void ease_slide_update_title (EaseSlide* self, GObject* object) {
#line 666 "ease-slide.vala"
	g_return_if_fail (self != NULL);
#line 666 "ease-slide.vala"
	g_return_if_fail (object != NULL);
#line 668 "ease-slide.vala"
	if (EASE_IS_TEXT_ELEMENT (object)) {
#line 1998 "ease-slide.c"
		gboolean _tmp0_ = FALSE;
		GObject* _tmp1_;
#line 670 "ease-slide.vala"
		if (_vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp1_ = object, EASE_IS_TEXT_ELEMENT (_tmp1_) ? ((EaseTextElement*) _tmp1_) : NULL)), EASE_THEME_TITLE_TEXT) == 0) {
#line 670 "ease-slide.vala"
			_tmp0_ = TRUE;
#line 2005 "ease-slide.c"
		} else {
			GObject* _tmp2_;
#line 671 "ease-slide.vala"
			_tmp0_ = _vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp2_ = object, EASE_IS_TEXT_ELEMENT (_tmp2_) ? ((EaseTextElement*) _tmp2_) : NULL)), EASE_THEME_HEADER_TEXT) == 0;
#line 2010 "ease-slide.c"
		}
#line 670 "ease-slide.vala"
		if (_tmp0_) {
#line 2014 "ease-slide.c"
			GObject* _tmp3_;
#line 673 "ease-slide.vala"
			g_signal_emit_by_name (self, "title-changed", self, ease_text_element_get_text ((_tmp3_ = object, EASE_IS_TEXT_ELEMENT (_tmp3_) ? ((EaseTextElement*) _tmp3_) : NULL)));
#line 2018 "ease-slide.c"
		}
	}
}


/**
 * Return's the slide's title from an element, or null if it doesn't have
 * one.
 */
#line 682 "ease-slide.vala"
char* ease_slide_get_title (EaseSlide* self) {
#line 2030 "ease-slide.c"
	char* result = NULL;
#line 682 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2034 "ease-slide.c"
	{
		EaseSlideIterator* _element_it;
#line 684 "ease-slide.vala"
		_element_it = ease_slide_iterator (self);
#line 684 "ease-slide.vala"
		while (TRUE) {
#line 2041 "ease-slide.c"
			EaseElement* element;
#line 684 "ease-slide.vala"
			if (!ease_slide_iterator_next (_element_it)) {
#line 684 "ease-slide.vala"
				break;
#line 2047 "ease-slide.c"
			}
#line 684 "ease-slide.vala"
			element = ease_slide_iterator_get (_element_it);
#line 686 "ease-slide.vala"
			if (EASE_IS_TEXT_ELEMENT (element)) {
#line 2053 "ease-slide.c"
				gboolean _tmp0_ = FALSE;
				EaseElement* _tmp1_;
#line 688 "ease-slide.vala"
				if (_vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp1_ = element, EASE_IS_TEXT_ELEMENT (_tmp1_) ? ((EaseTextElement*) _tmp1_) : NULL)), EASE_THEME_TITLE_TEXT) == 0) {
#line 688 "ease-slide.vala"
					_tmp0_ = TRUE;
#line 2060 "ease-slide.c"
				} else {
					EaseElement* _tmp2_;
#line 689 "ease-slide.vala"
					_tmp0_ = _vala_strcmp0 (ease_element_get_identifier ((EaseElement*) (_tmp2_ = element, EASE_IS_TEXT_ELEMENT (_tmp2_) ? ((EaseTextElement*) _tmp2_) : NULL)), EASE_THEME_HEADER_TEXT) == 0;
#line 2065 "ease-slide.c"
				}
#line 688 "ease-slide.vala"
				if (_tmp0_) {
#line 2069 "ease-slide.c"
					EaseElement* _tmp3_;
					char* ret;
					const char* _tmp4_;
#line 691 "ease-slide.vala"
					ret = g_strdup (ease_text_element_get_text ((_tmp3_ = element, EASE_IS_TEXT_ELEMENT (_tmp3_) ? ((EaseTextElement*) _tmp3_) : NULL)));
#line 2075 "ease-slide.c"
					_tmp4_ = NULL;
#line 692 "ease-slide.vala"
					if (string_get_length (ret) > 0) {
#line 692 "ease-slide.vala"
						_tmp4_ = ret;
#line 2081 "ease-slide.c"
					} else {
#line 692 "ease-slide.vala"
						_tmp4_ = NULL;
#line 2085 "ease-slide.c"
					}
					result = g_strdup (_tmp4_);
					_g_free0 (ret);
					_g_object_unref0 (element);
					_ease_slide_iterator_unref0 (_element_it);
#line 692 "ease-slide.vala"
					return result;
#line 2093 "ease-slide.c"
				}
			}
			_g_object_unref0 (element);
		}
		_ease_slide_iterator_unref0 (_element_it);
	}
	result = NULL;
#line 696 "ease-slide.vala"
	return result;
#line 2103 "ease-slide.c"
}


/**
 * Returns an iterator that can be used with foreach.
 */
#line 704 "ease-slide.vala"
EaseSlideIterator* ease_slide_iterator (EaseSlide* self) {
#line 2112 "ease-slide.c"
	EaseSlideIterator* result = NULL;
#line 704 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2116 "ease-slide.c"
	result = ease_slide_iterator_new (self);
#line 706 "ease-slide.vala"
	return result;
#line 2120 "ease-slide.c"
}


EaseTransition ease_slide_get_transition (EaseSlide* self) {
	EaseTransition result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_transition;
#line 40 "ease-slide.vala"
	return result;
#line 2130 "ease-slide.c"
}


void ease_slide_set_transition (EaseSlide* self, EaseTransition value) {
	g_return_if_fail (self != NULL);
	self->priv->_transition = value;
	g_object_notify ((GObject *) self, "transition");
}


EaseTransitionVariant ease_slide_get_variant (EaseSlide* self) {
	EaseTransitionVariant result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_variant;
#line 45 "ease-slide.vala"
	return result;
#line 2147 "ease-slide.c"
}


void ease_slide_set_variant (EaseSlide* self, EaseTransitionVariant value) {
	g_return_if_fail (self != NULL);
	self->priv->_variant = value;
	g_object_notify ((GObject *) self, "variant");
}


double ease_slide_get_transition_time (EaseSlide* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_transition_time;
#line 50 "ease-slide.vala"
	return result;
#line 2164 "ease-slide.c"
}


void ease_slide_set_transition_time (EaseSlide* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_transition_time = value;
	g_object_notify ((GObject *) self, "transition-time");
}


guint ease_slide_get_transition_msecs (EaseSlide* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) (self->priv->_transition_time * 1000);
#line 57 "ease-slide.vala"
	return result;
#line 2181 "ease-slide.c"
}


void ease_slide_set_transition_msecs (EaseSlide* self, guint value) {
	g_return_if_fail (self != NULL);
#line 58 "ease-slide.vala"
	ease_slide_set_transition_time (self, (double) (value / 1000.f));
#line 2189 "ease-slide.c"
	g_object_notify ((GObject *) self, "transition-msecs");
}


gboolean ease_slide_get_automatically_advance (EaseSlide* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatically_advance;
#line 64 "ease-slide.vala"
	return result;
#line 2200 "ease-slide.c"
}


void ease_slide_set_automatically_advance (EaseSlide* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_automatically_advance = value;
	g_object_notify ((GObject *) self, "automatically-advance");
}


double ease_slide_get_advance_delay (EaseSlide* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_advance_delay;
#line 69 "ease-slide.vala"
	return result;
#line 2217 "ease-slide.c"
}


void ease_slide_set_advance_delay (EaseSlide* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_advance_delay = value;
	g_object_notify ((GObject *) self, "advance-delay");
}


EaseBackground* ease_slide_get_background (EaseSlide* self) {
	EaseBackground* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_background;
#line 74 "ease-slide.vala"
	return result;
#line 2234 "ease-slide.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void ease_slide_set_background (EaseSlide* self, EaseBackground* value) {
	EaseBackground* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_background = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_background), _tmp0_);
	g_object_notify ((GObject *) self, "background");
}


char* ease_slide_get_background_abs (EaseSlide* self) {
	char* result;
	const char* _tmp0_;
	char* p;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
#line 83 "ease-slide.vala"
	if (self->priv->_parent == NULL) {
#line 83 "ease-slide.vala"
		_tmp0_ = ease_theme_get_path (self->priv->_theme);
#line 2261 "ease-slide.c"
	} else {
#line 83 "ease-slide.vala"
		_tmp0_ = ease_document_get_path (self->priv->_parent);
#line 2265 "ease-slide.c"
	}
#line 83 "ease-slide.vala"
	p = g_strdup (_tmp0_);
#line 2269 "ease-slide.c"
	result = g_build_filename (p, ease_image_get_filename (ease_background_get_image (self->priv->_background)), NULL);
	_g_free0 (p);
#line 84 "ease-slide.vala"
	return result;
#line 2274 "ease-slide.c"
}


EaseDocument* ease_slide_get_parent (EaseSlide* self) {
	EaseDocument* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parent;
#line 91 "ease-slide.vala"
	return result;
#line 2284 "ease-slide.c"
}


void ease_slide_set_parent (EaseSlide* self, EaseDocument* value) {
	EaseDocument* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_parent = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_parent), _tmp0_);
	g_object_notify ((GObject *) self, "parent");
}


gint ease_slide_get_width (EaseSlide* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ease_document_get_width (self->priv->_parent);
#line 96 "ease-slide.vala"
	return result;
#line 2302 "ease-slide.c"
}


gint ease_slide_get_height (EaseSlide* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ease_document_get_height (self->priv->_parent);
#line 101 "ease-slide.vala"
	return result;
#line 2312 "ease-slide.c"
}


float ease_slide_get_aspect (EaseSlide* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = ease_document_get_aspect (self->priv->_parent);
#line 106 "ease-slide.vala"
	return result;
#line 2322 "ease-slide.c"
}


EaseTheme* ease_slide_get_theme (EaseSlide* self) {
	EaseTheme* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_theme;
#line 111 "ease-slide.vala"
	return result;
#line 2332 "ease-slide.c"
}


void ease_slide_set_theme (EaseSlide* self, EaseTheme* value) {
	EaseTheme* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_theme = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_theme), _tmp0_);
	g_object_notify ((GObject *) self, "theme");
}


const char* ease_slide_get_master (EaseSlide* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_master;
#line 116 "ease-slide.vala"
	return result;
#line 2350 "ease-slide.c"
}


void ease_slide_set_master (EaseSlide* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_master = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_master), _tmp0_);
	g_object_notify ((GObject *) self, "master");
}


gint ease_slide_get_count (EaseSlide* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = gee_collection_get_size ((GeeCollection*) self->elements);
#line 121 "ease-slide.vala"
	return result;
#line 2368 "ease-slide.c"
}


EaseSlide* ease_slide_get_next (EaseSlide* self) {
	EaseSlide* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i;
#line 135 "ease-slide.vala"
		i = 0;
#line 2379 "ease-slide.c"
		{
			gboolean _tmp0_;
#line 135 "ease-slide.vala"
			_tmp0_ = TRUE;
#line 135 "ease-slide.vala"
			while (TRUE) {
#line 2386 "ease-slide.c"
				EaseSlide* _tmp1_;
				gboolean _tmp2_;
#line 135 "ease-slide.vala"
				if (!_tmp0_) {
#line 135 "ease-slide.vala"
					i++;
#line 2393 "ease-slide.c"
				}
#line 135 "ease-slide.vala"
				_tmp0_ = FALSE;
#line 135 "ease-slide.vala"
				if (!(i < (ease_iterable_list_store_get_size (ease_document_get_slides (self->priv->_parent)) - 1))) {
#line 135 "ease-slide.vala"
					break;
#line 2401 "ease-slide.c"
				}
#line 137 "ease-slide.vala"
				if ((_tmp2_ = (_tmp1_ = ease_document_get_slide (self->priv->_parent, i)) == self, _g_object_unref0 (_tmp1_), _tmp2_)) {
#line 2405 "ease-slide.c"
					result = ease_document_get_slide (self->priv->_parent, i + 1);
#line 139 "ease-slide.vala"
					return result;
#line 2409 "ease-slide.c"
				}
			}
		}
	}
	result = NULL;
#line 142 "ease-slide.vala"
	return result;
#line 2417 "ease-slide.c"
}


EaseSlide* ease_slide_get_previous (EaseSlide* self) {
	EaseSlide* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i;
#line 153 "ease-slide.vala"
		i = 1;
#line 2428 "ease-slide.c"
		{
			gboolean _tmp0_;
#line 153 "ease-slide.vala"
			_tmp0_ = TRUE;
#line 153 "ease-slide.vala"
			while (TRUE) {
#line 2435 "ease-slide.c"
				EaseSlide* _tmp1_;
				gboolean _tmp2_;
#line 153 "ease-slide.vala"
				if (!_tmp0_) {
#line 153 "ease-slide.vala"
					i++;
#line 2442 "ease-slide.c"
				}
#line 153 "ease-slide.vala"
				_tmp0_ = FALSE;
#line 153 "ease-slide.vala"
				if (!(i < ease_iterable_list_store_get_size (ease_document_get_slides (self->priv->_parent)))) {
#line 153 "ease-slide.vala"
					break;
#line 2450 "ease-slide.c"
				}
#line 155 "ease-slide.vala"
				if ((_tmp2_ = (_tmp1_ = ease_document_get_slide (self->priv->_parent, i)) == self, _g_object_unref0 (_tmp1_), _tmp2_)) {
#line 2454 "ease-slide.c"
					result = ease_document_get_slide (self->priv->_parent, i - 1);
#line 157 "ease-slide.vala"
					return result;
#line 2458 "ease-slide.c"
				}
			}
		}
	}
	result = NULL;
#line 160 "ease-slide.vala"
	return result;
#line 2466 "ease-slide.c"
}


#line 717 "ease-slide.vala"
EaseSlideIterator* ease_slide_iterator_construct (GType object_type, EaseSlide* slide) {
#line 2472 "ease-slide.c"
	EaseSlideIterator* self;
	EaseSlide* _tmp0_;
#line 717 "ease-slide.vala"
	g_return_val_if_fail (slide != NULL, NULL);
#line 2477 "ease-slide.c"
	self = (EaseSlideIterator*) g_type_create_instance (object_type);
#line 719 "ease-slide.vala"
	self->priv->self = (_tmp0_ = _g_object_ref0 (slide), _g_object_unref0 (self->priv->self), _tmp0_);
#line 2481 "ease-slide.c"
	return self;
}


#line 717 "ease-slide.vala"
EaseSlideIterator* ease_slide_iterator_new (EaseSlide* slide) {
#line 717 "ease-slide.vala"
	return ease_slide_iterator_construct (EASE_SLIDE_TYPE_ITERATOR, slide);
#line 2490 "ease-slide.c"
}


#line 722 "ease-slide.vala"
gboolean ease_slide_iterator_next (EaseSlideIterator* self) {
#line 2496 "ease-slide.c"
	gboolean result = FALSE;
#line 722 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2500 "ease-slide.c"
	result = self->priv->i < gee_collection_get_size ((GeeCollection*) self->priv->self->elements);
#line 724 "ease-slide.vala"
	return result;
#line 2504 "ease-slide.c"
}


#line 727 "ease-slide.vala"
EaseElement* ease_slide_iterator_get (EaseSlideIterator* self) {
#line 2510 "ease-slide.c"
	EaseElement* result = NULL;
#line 727 "ease-slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 729 "ease-slide.vala"
	self->priv->i++;
#line 2516 "ease-slide.c"
	result = (EaseElement*) gee_abstract_list_get ((GeeAbstractList*) self->priv->self->elements, self->priv->i - 1);
#line 730 "ease-slide.vala"
	return result;
#line 2520 "ease-slide.c"
}


static void ease_slide_value_iterator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void ease_slide_value_iterator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ease_slide_iterator_unref (value->data[0].v_pointer);
	}
}


static void ease_slide_value_iterator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ease_slide_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer ease_slide_value_iterator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* ease_slide_value_iterator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		EaseSlideIterator* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ease_slide_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* ease_slide_value_iterator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EaseSlideIterator** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ease_slide_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* ease_slide_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EaseSlideParamSpecIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, EASE_SLIDE_TYPE_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer ease_slide_value_get_iterator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EASE_SLIDE_TYPE_ITERATOR), NULL);
	return value->data[0].v_pointer;
}


void ease_slide_value_set_iterator (GValue* value, gpointer v_object) {
	EaseSlideIterator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EASE_SLIDE_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EASE_SLIDE_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ease_slide_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ease_slide_iterator_unref (old);
	}
}


void ease_slide_value_take_iterator (GValue* value, gpointer v_object) {
	EaseSlideIterator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EASE_SLIDE_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EASE_SLIDE_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ease_slide_iterator_unref (old);
	}
}


static void ease_slide_iterator_class_init (EaseSlideIteratorClass * klass) {
	ease_slide_iterator_parent_class = g_type_class_peek_parent (klass);
	EASE_SLIDE_ITERATOR_CLASS (klass)->finalize = ease_slide_iterator_finalize;
	g_type_class_add_private (klass, sizeof (EaseSlideIteratorPrivate));
}


static void ease_slide_iterator_instance_init (EaseSlideIterator * self) {
	self->priv = EASE_SLIDE_ITERATOR_GET_PRIVATE (self);
	self->priv->i = 0;
	self->ref_count = 1;
}


static void ease_slide_iterator_finalize (EaseSlideIterator* obj) {
	EaseSlideIterator * self;
	self = EASE_SLIDE_ITERATOR (obj);
	_g_object_unref0 (self->priv->self);
}


/**
 * Iterates over this Slide's elements.
 */
GType ease_slide_iterator_get_type (void) {
	static volatile gsize ease_slide_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&ease_slide_iterator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { ease_slide_value_iterator_init, ease_slide_value_iterator_free_value, ease_slide_value_iterator_copy_value, ease_slide_value_iterator_peek_pointer, "p", ease_slide_value_iterator_collect_value, "p", ease_slide_value_iterator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EaseSlideIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_slide_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseSlideIterator), 0, (GInstanceInitFunc) ease_slide_iterator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ease_slide_iterator_type_id;
		ease_slide_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EaseSlideIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ease_slide_iterator_type_id__volatile, ease_slide_iterator_type_id);
	}
	return ease_slide_iterator_type_id__volatile;
}


gpointer ease_slide_iterator_ref (gpointer instance) {
	EaseSlideIterator* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ease_slide_iterator_unref (gpointer instance) {
	EaseSlideIterator* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EASE_SLIDE_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void ease_slide_class_init (EaseSlideClass * klass) {
	ease_slide_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseSlidePrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_slide_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_slide_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_slide_finalize;
	/**
	 * The Slide's transition
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_TRANSITION, g_param_spec_enum ("transition", "transition", "transition", EASE_TYPE_TRANSITION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The variant (if any) of the Slide's transition
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_VARIANT, g_param_spec_enum ("variant", "variant", "variant", EASE_TYPE_TRANSITION_VARIANT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The duration of this Slide's transition
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_TRANSITION_TIME, g_param_spec_double ("transition-time", "transition-time", "transition-time", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The duration of this Slide's transition, in milliseconds
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_TRANSITION_MSECS, g_param_spec_uint ("transition-msecs", "transition-msecs", "transition-msecs", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * If the slide advances automatically or on key press
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_AUTOMATICALLY_ADVANCE, g_param_spec_boolean ("automatically-advance", "automatically-advance", "automatically-advance", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * If the slide advances automatically, the amount of delay
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_ADVANCE_DELAY, g_param_spec_double ("advance-delay", "advance-delay", "advance-delay", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The background of this Slide.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_BACKGROUND, g_param_spec_object ("background", "background", "background", EASE_TYPE_BACKGROUND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The absolute path of the background image, if one is set.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_BACKGROUND_ABS, g_param_spec_string ("background-abs", "background-abs", "background-abs", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The {@link Document} that this Slide is part of
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_PARENT, g_param_spec_object ("parent", "parent", "parent", EASE_TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The width of the Slide's parent {@link Document}.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The height of the Slide's parent {@link Document}.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The aspect ratio of the Slide's parent {@link Document}.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_ASPECT, g_param_spec_float ("aspect", "aspect", "aspect", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The {@link Theme} that this Slide is based on.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_THEME, g_param_spec_object ("theme", "theme", "theme", EASE_TYPE_THEME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The master slide ID this slide is based on.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_MASTER, g_param_spec_string ("master", "master", "master", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The number of {@link Element}s on this Slide
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_COUNT, g_param_spec_int ("count", "count", "count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The next Slide in this Slide's {@link Document}.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_NEXT, g_param_spec_object ("next", "next", "next", EASE_TYPE_SLIDE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The previous Slide in this Slide's {@link Document}.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_PREVIOUS, g_param_spec_object ("previous", "previous", "previous", EASE_TYPE_SLIDE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Requests that the player advance past this Slide.
	 */
	g_signal_new ("request_advance", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ELEMENT);
	/**
	 * Emitted when an {@link Element} or property of this Slide is changed.
	 */
	g_signal_new ("changed", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_SLIDE);
	/**
	 * Emitted when the background of this Slide is altered in any way.
	 */
	g_signal_new ("background_changed", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_SLIDE);
	/**
	 * Emitted when an {@link Element} is added to this Slide.
	 */
	g_signal_new ("element_added", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT, G_TYPE_NONE, 3, EASE_TYPE_SLIDE, EASE_TYPE_ELEMENT, G_TYPE_INT);
	/**
	 * Emitted when an {@link Element} is added to this Slide.
	 */
	g_signal_new ("element_removed", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT, G_TYPE_NONE, 3, EASE_TYPE_SLIDE, EASE_TYPE_ELEMENT, G_TYPE_INT);
	/**
	 * Emitted when an {@link Element} is repositioned.
	 */
	g_signal_new ("element_reordered", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, EASE_TYPE_SLIDE, EASE_TYPE_ELEMENT);
	/**
	 * Updates this slide's title.
	 */
	g_signal_new ("title_changed", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, EASE_TYPE_SLIDE, G_TYPE_STRING);
	/**
	 * Resets this slide's title to its default.
	 */
	g_signal_new ("title_reset", EASE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_SLIDE);
}


static void ease_slide_ease_undo_source_interface_init (EaseUndoSourceIface * iface) {
	ease_slide_ease_undo_source_parent_iface = g_type_interface_peek_parent (iface);
}


static void ease_slide_instance_init (EaseSlide * self) {
	self->priv = EASE_SLIDE_GET_PRIVATE (self);
	self->elements = gee_linked_list_new (EASE_TYPE_ELEMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
}


static void ease_slide_finalize (GObject* obj) {
	EaseSlide * self;
	self = EASE_SLIDE (obj);
	_g_object_unref0 (self->elements);
	_g_object_unref0 (self->priv->_background);
	_g_object_unref0 (self->priv->_parent);
	_g_object_unref0 (self->priv->_theme);
	_g_free0 (self->priv->_master);
	G_OBJECT_CLASS (ease_slide_parent_class)->finalize (obj);
}


/**
 * The internal representation of a slide
 *
 * A Slide is owned by a {@link Document} and has {@link Element}
 * children. The currently selected Slide is often acted upon by an
 * EditorWindow (from main Ease, not core).
 */
GType ease_slide_get_type (void) {
	static volatile gsize ease_slide_type_id__volatile = 0;
	if (g_once_init_enter (&ease_slide_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseSlideClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_slide_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseSlide), 0, (GInstanceInitFunc) ease_slide_instance_init, NULL };
		static const GInterfaceInfo ease_undo_source_info = { (GInterfaceInitFunc) ease_slide_ease_undo_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType ease_slide_type_id;
		ease_slide_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseSlide", &g_define_type_info, 0);
		g_type_add_interface_static (ease_slide_type_id, EASE_TYPE_UNDO_SOURCE, &ease_undo_source_info);
		g_once_init_leave (&ease_slide_type_id__volatile, ease_slide_type_id);
	}
	return ease_slide_type_id__volatile;
}


static void ease_slide_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseSlide * self;
	self = EASE_SLIDE (object);
	switch (property_id) {
		case EASE_SLIDE_TRANSITION:
		g_value_set_enum (value, ease_slide_get_transition (self));
		break;
		case EASE_SLIDE_VARIANT:
		g_value_set_enum (value, ease_slide_get_variant (self));
		break;
		case EASE_SLIDE_TRANSITION_TIME:
		g_value_set_double (value, ease_slide_get_transition_time (self));
		break;
		case EASE_SLIDE_TRANSITION_MSECS:
		g_value_set_uint (value, ease_slide_get_transition_msecs (self));
		break;
		case EASE_SLIDE_AUTOMATICALLY_ADVANCE:
		g_value_set_boolean (value, ease_slide_get_automatically_advance (self));
		break;
		case EASE_SLIDE_ADVANCE_DELAY:
		g_value_set_double (value, ease_slide_get_advance_delay (self));
		break;
		case EASE_SLIDE_BACKGROUND:
		g_value_set_object (value, ease_slide_get_background (self));
		break;
		case EASE_SLIDE_BACKGROUND_ABS:
		g_value_take_string (value, ease_slide_get_background_abs (self));
		break;
		case EASE_SLIDE_PARENT:
		g_value_set_object (value, ease_slide_get_parent (self));
		break;
		case EASE_SLIDE_WIDTH:
		g_value_set_int (value, ease_slide_get_width (self));
		break;
		case EASE_SLIDE_HEIGHT:
		g_value_set_int (value, ease_slide_get_height (self));
		break;
		case EASE_SLIDE_ASPECT:
		g_value_set_float (value, ease_slide_get_aspect (self));
		break;
		case EASE_SLIDE_THEME:
		g_value_set_object (value, ease_slide_get_theme (self));
		break;
		case EASE_SLIDE_MASTER:
		g_value_set_string (value, ease_slide_get_master (self));
		break;
		case EASE_SLIDE_COUNT:
		g_value_set_int (value, ease_slide_get_count (self));
		break;
		case EASE_SLIDE_NEXT:
		g_value_take_object (value, ease_slide_get_next (self));
		break;
		case EASE_SLIDE_PREVIOUS:
		g_value_take_object (value, ease_slide_get_previous (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_slide_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseSlide * self;
	self = EASE_SLIDE (object);
	switch (property_id) {
		case EASE_SLIDE_TRANSITION:
		ease_slide_set_transition (self, g_value_get_enum (value));
		break;
		case EASE_SLIDE_VARIANT:
		ease_slide_set_variant (self, g_value_get_enum (value));
		break;
		case EASE_SLIDE_TRANSITION_TIME:
		ease_slide_set_transition_time (self, g_value_get_double (value));
		break;
		case EASE_SLIDE_TRANSITION_MSECS:
		ease_slide_set_transition_msecs (self, g_value_get_uint (value));
		break;
		case EASE_SLIDE_AUTOMATICALLY_ADVANCE:
		ease_slide_set_automatically_advance (self, g_value_get_boolean (value));
		break;
		case EASE_SLIDE_ADVANCE_DELAY:
		ease_slide_set_advance_delay (self, g_value_get_double (value));
		break;
		case EASE_SLIDE_BACKGROUND:
		ease_slide_set_background (self, g_value_get_object (value));
		break;
		case EASE_SLIDE_PARENT:
		ease_slide_set_parent (self, g_value_get_object (value));
		break;
		case EASE_SLIDE_THEME:
		ease_slide_set_theme (self, g_value_get_object (value));
		break;
		case EASE_SLIDE_MASTER:
		ease_slide_set_master (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_INT) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_int (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}



