/* ease-utilities.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-utilities.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _Block14Data Block14Data;

typedef void (*EaseRecursiveDirAction) (const char* path, const char* full_path, void* user_data, GError** error);
struct _Block14Data {
	int _ref_count_;
	char* to_dir;
};



#define EASE_LOCAL_DATA "data"
#define EASE_SYS_DATA "ease"
char** ease_get_data_dirs (int* result_length1);
void ease_error_dialog (const char* title, const char* message);
char* ease_data_path (const char* path);
char* ease_query_file (const char* dir, const char* path);
GeeLinkedList* ease_data_contents (void);
GeeLinkedList* ease_data_contents_folder (const char* folder);
void ease_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error);
void ease_do_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, const char* rel_path, gboolean dir_first, GError** error);
void ease_recursive_directory_after (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error);
void ease_recursive_delete (const char* path, GError** error);
static void _lambda13_ (const char* p, const char* full_path, GError** error);
static void __lambda13__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
static void _lambda14_ (const char* p, const char* full_path, GError** error);
static void __lambda14__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
void ease_recursive_copy (const char* from_dir, const char* to_dir, GError** error);
static void _lambda0_ (const char* path, const char* full_path, Block14Data* _data14_, GError** error);
static void __lambda0__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
static void _lambda1_ (const char* path, const char* full_path, Block14Data* _data14_, GError** error);
static void __lambda1__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
GdkColor* ease_theme_color (const char* color);
static GdkColor* _gdk_color_dup (GdkColor* self);
void ease_theme_clutter_color (const char* color, ClutterColor* result);
void ease_transformations_gdk_color_to_clutter_color (GdkColor* color, ClutterColor* result);
GtkWindow* ease_widget_window (GtkWidget* widg);
char* ease_absolute_path (const char* path);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 35 "ease-utilities.vala"
char** ease_get_data_dirs (int* result_length1) {
#line 85 "ease-utilities.c"
	char** result = NULL;
	char** _tmp0_ = NULL;
	char** _tmp1_;
	result = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup (EASE_LOCAL_DATA), _tmp0_[1] = g_build_filename (EASE_DATA_DIR, EASE_SYS_DATA, NULL), _tmp0_), *result_length1 = 2, _tmp1_);
#line 37 "ease-utilities.vala"
	return result;
#line 92 "ease-utilities.c"
}


/**
 * Display a simple error message.
 *
 * @param title The title of the dialog.
 * @param message The error message.
 */
#line 48 "ease-utilities.vala"
void ease_error_dialog (const char* title, const char* message) {
#line 104 "ease-utilities.c"
	GtkMessageDialog* dialog;
#line 48 "ease-utilities.vala"
	g_return_if_fail (title != NULL);
#line 48 "ease-utilities.vala"
	g_return_if_fail (message != NULL);
#line 50 "ease-utilities.vala"
	dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", message));
#line 54 "ease-utilities.vala"
	gtk_window_set_title ((GtkWindow*) dialog, title);
#line 55 "ease-utilities.vala"
	gtk_container_set_border_width ((GtkContainer*) dialog, (guint) 5);
#line 56 "ease-utilities.vala"
	gtk_dialog_run ((GtkDialog*) dialog);
#line 57 "ease-utilities.vala"
	gtk_object_destroy ((GtkObject*) dialog);
#line 120 "ease-utilities.c"
	_g_object_unref0 (dialog);
}


/**
 * Finds the given path in the data directories (ie /usr/share). Return null
 * if the path cannot be found.
 *
 * @param path The path to search for.
 */
#line 66 "ease-utilities.vala"
char* ease_data_path (const char* path) {
#line 133 "ease-utilities.c"
	char* result = NULL;
#line 66 "ease-utilities.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 137 "ease-utilities.c"
	{
		gint _tmp0_;
		char** dir_collection;
		int dir_collection_length1;
		int dir_it;
#line 68 "ease-utilities.vala"
		dir_collection = ease_get_data_dirs (&_tmp0_);
#line 145 "ease-utilities.c"
		dir_collection_length1 = _tmp0_;
		for (dir_it = 0; dir_it < _tmp0_; dir_it = dir_it + 1) {
			char* dir;
			dir = g_strdup (dir_collection[dir_it]);
			{
				char* sys_file;
#line 70 "ease-utilities.vala"
				sys_file = ease_query_file (dir, path);
#line 71 "ease-utilities.vala"
				if (sys_file != NULL) {
#line 156 "ease-utilities.c"
					result = sys_file;
					_g_free0 (dir);
					dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
#line 71 "ease-utilities.vala"
					return result;
#line 162 "ease-utilities.c"
				}
				_g_free0 (sys_file);
				_g_free0 (dir);
			}
		}
#line 68 "ease-utilities.vala"
		dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
#line 170 "ease-utilities.c"
	}
	result = NULL;
#line 74 "ease-utilities.vala"
	return result;
#line 175 "ease-utilities.c"
}


/**
 * Queries the given folder for the file, returning it if it is found.
 *
 * Otherwise, the function returns null.
 *
 * @param dir The base directory.
 * @param path The path to search for.
 */
#line 85 "ease-utilities.vala"
char* ease_query_file (const char* dir, const char* path) {
#line 189 "ease-utilities.c"
	char* result = NULL;
	char* filename;
	GFile* file;
	const char* _tmp0_;
#line 85 "ease-utilities.vala"
	g_return_val_if_fail (dir != NULL, NULL);
#line 85 "ease-utilities.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 87 "ease-utilities.vala"
	filename = g_build_filename (dir, path, NULL);
#line 88 "ease-utilities.vala"
	file = g_file_new_for_path (filename);
#line 202 "ease-utilities.c"
	_tmp0_ = NULL;
#line 90 "ease-utilities.vala"
	if (g_file_query_exists (file, NULL)) {
#line 90 "ease-utilities.vala"
		_tmp0_ = filename;
#line 208 "ease-utilities.c"
	} else {
#line 90 "ease-utilities.vala"
		_tmp0_ = NULL;
#line 212 "ease-utilities.c"
	}
	result = g_strdup (_tmp0_);
	_g_object_unref0 (file);
	_g_free0 (filename);
#line 90 "ease-utilities.vala"
	return result;
#line 219 "ease-utilities.c"
}


/**
 * Returns a list containing every directory in the data directories.
 */
#line 96 "ease-utilities.vala"
GeeLinkedList* ease_data_contents (void) {
#line 228 "ease-utilities.c"
	GeeLinkedList* result = NULL;
	GeeLinkedList* list;
	GError * _inner_error_ = NULL;
#line 98 "ease-utilities.vala"
	list = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 234 "ease-utilities.c"
	{
		gint _tmp0_;
		char** dir_collection;
		int dir_collection_length1;
		int dir_it;
#line 100 "ease-utilities.vala"
		dir_collection = ease_get_data_dirs (&_tmp0_);
#line 242 "ease-utilities.c"
		dir_collection_length1 = _tmp0_;
		for (dir_it = 0; dir_it < _tmp0_; dir_it = dir_it + 1) {
			char* dir;
			dir = g_strdup (dir_collection[dir_it]);
			{
				GFile* test;
				GDir* directory;
				char* name;
#line 103 "ease-utilities.vala"
				test = g_file_new_for_path (dir);
#line 104 "ease-utilities.vala"
				if (!g_file_query_exists (test, NULL)) {
#line 255 "ease-utilities.c"
					_g_object_unref0 (test);
					_g_free0 (dir);
#line 104 "ease-utilities.vala"
					continue;
#line 260 "ease-utilities.c"
				}
#line 106 "ease-utilities.vala"
				directory = g_dir_open (dir, (guint) 0, &_inner_error_);
#line 264 "ease-utilities.c"
				if (_inner_error_ != NULL) {
					_g_object_unref0 (test);
					_g_free0 (dir);
					dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
#line 107 "ease-utilities.vala"
				name = g_strdup (g_dir_read_name (directory));
#line 108 "ease-utilities.vala"
				while (TRUE) {
#line 278 "ease-utilities.c"
					char* _tmp1_;
					char* _tmp2_;
#line 108 "ease-utilities.vala"
					if (!(name != NULL)) {
#line 108 "ease-utilities.vala"
						break;
#line 285 "ease-utilities.c"
					}
#line 110 "ease-utilities.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) list, _tmp1_ = g_build_filename (dir, name, NULL));
#line 289 "ease-utilities.c"
					_g_free0 (_tmp1_);
#line 111 "ease-utilities.vala"
					name = (_tmp2_ = g_strdup (g_dir_read_name (directory)), _g_free0 (name), _tmp2_);
#line 293 "ease-utilities.c"
				}
				_g_free0 (name);
				_g_dir_close0 (directory);
				_g_object_unref0 (test);
				_g_free0 (dir);
			}
		}
#line 100 "ease-utilities.vala"
		dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
#line 303 "ease-utilities.c"
	}
	result = list;
#line 115 "ease-utilities.vala"
	return result;
#line 308 "ease-utilities.c"
}


/**
 * Returns a list containing all contents of folders in the data directory
 * with the specified name.
 */
#line 122 "ease-utilities.vala"
GeeLinkedList* ease_data_contents_folder (const char* folder) {
#line 318 "ease-utilities.c"
	GeeLinkedList* result = NULL;
	GeeLinkedList* list;
	GError * _inner_error_ = NULL;
#line 122 "ease-utilities.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 124 "ease-utilities.vala"
	list = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 326 "ease-utilities.c"
	{
		gint _tmp0_;
		char** dir_collection;
		int dir_collection_length1;
		int dir_it;
#line 126 "ease-utilities.vala"
		dir_collection = ease_get_data_dirs (&_tmp0_);
#line 334 "ease-utilities.c"
		dir_collection_length1 = _tmp0_;
		for (dir_it = 0; dir_it < _tmp0_; dir_it = dir_it + 1) {
			char* dir;
			dir = g_strdup (dir_collection[dir_it]);
			{
				GFile* test;
				GDir* directory;
				char* name;
#line 129 "ease-utilities.vala"
				test = g_file_new_for_path (dir);
#line 130 "ease-utilities.vala"
				if (!g_file_query_exists (test, NULL)) {
#line 347 "ease-utilities.c"
					_g_object_unref0 (test);
					_g_free0 (dir);
#line 130 "ease-utilities.vala"
					continue;
#line 352 "ease-utilities.c"
				}
#line 132 "ease-utilities.vala"
				directory = g_dir_open (dir, (guint) 0, &_inner_error_);
#line 356 "ease-utilities.c"
				if (_inner_error_ != NULL) {
					_g_object_unref0 (test);
					_g_free0 (dir);
					dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
#line 133 "ease-utilities.vala"
				name = g_strdup (g_dir_read_name (directory));
#line 134 "ease-utilities.vala"
				while (TRUE) {
#line 370 "ease-utilities.c"
					char* _tmp7_;
#line 134 "ease-utilities.vala"
					if (!(name != NULL)) {
#line 134 "ease-utilities.vala"
						break;
#line 376 "ease-utilities.c"
					}
#line 136 "ease-utilities.vala"
					if (_vala_strcmp0 (name, folder) == 0) {
#line 380 "ease-utilities.c"
						char* _tmp1_;
						GFile* _tmp2_;
						char* _tmp3_;
						GDir* _tmp4_;
						GDir* child;
						char* child_name;
#line 139 "ease-utilities.vala"
						test = (_tmp2_ = g_file_new_for_path (_tmp1_ = g_build_filename (dir, name, NULL)), _g_object_unref0 (test), _tmp2_);
#line 389 "ease-utilities.c"
						_g_free0 (_tmp1_);
#line 140 "ease-utilities.vala"
						if (!g_file_query_exists (test, NULL)) {
#line 140 "ease-utilities.vala"
							continue;
#line 395 "ease-utilities.c"
						}
#line 142 "ease-utilities.vala"
						child = (_tmp4_ = g_dir_open (_tmp3_ = g_build_filename (dir, name, NULL), (guint) 0, &_inner_error_), _g_free0 (_tmp3_), _tmp4_);
#line 399 "ease-utilities.c"
						if (_inner_error_ != NULL) {
							_g_free0 (name);
							_g_dir_close0 (directory);
							_g_object_unref0 (test);
							_g_free0 (dir);
							dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
#line 143 "ease-utilities.vala"
						child_name = g_strdup (g_dir_read_name (child));
#line 144 "ease-utilities.vala"
						while (TRUE) {
#line 415 "ease-utilities.c"
							char* _tmp5_;
							char* _tmp6_;
#line 144 "ease-utilities.vala"
							if (!(child_name != NULL)) {
#line 144 "ease-utilities.vala"
								break;
#line 422 "ease-utilities.c"
							}
#line 146 "ease-utilities.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) list, _tmp5_ = g_build_filename (dir, folder, child_name, NULL));
#line 426 "ease-utilities.c"
							_g_free0 (_tmp5_);
#line 147 "ease-utilities.vala"
							child_name = (_tmp6_ = g_strdup (g_dir_read_name (child)), _g_free0 (child_name), _tmp6_);
#line 430 "ease-utilities.c"
						}
						_g_free0 (child_name);
						_g_dir_close0 (child);
					}
#line 150 "ease-utilities.vala"
					name = (_tmp7_ = g_strdup (g_dir_read_name (directory)), _g_free0 (name), _tmp7_);
#line 437 "ease-utilities.c"
				}
				_g_free0 (name);
				_g_dir_close0 (directory);
				_g_object_unref0 (test);
				_g_free0 (dir);
			}
		}
#line 126 "ease-utilities.vala"
		dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
#line 447 "ease-utilities.c"
	}
	result = list;
#line 154 "ease-utilities.vala"
	return result;
#line 452 "ease-utilities.c"
}


/**
 * Performs a recursive iteration on a directory, with callbacks.
 *
 * The caller can provide two {@link RecursiveDirAction}s: one for files,
 * and another for directories. These callbacks can both be null
 * (although if they both were, the call would do nothing). The directory
 * callback is executed before the recursion continues.
 * recursive_directory_after does the opposite.
 *
 * The directory callback is not performed on the toplevel directory.
 *
 * @param directory The directory to iterate.
 * @param directory_action A {@link RecursiveDirAction} to perform on all
 * directories.
 * @param file_action A {@link RecursiveDirAction} to perform on all files.
 */
#line 173 "ease-utilities.vala"
void ease_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error) {
#line 474 "ease-utilities.c"
	GError * _inner_error_ = NULL;
#line 173 "ease-utilities.vala"
	g_return_if_fail (directory != NULL);
#line 178 "ease-utilities.vala"
	ease_do_recursive_directory (directory, directory_action, directory_action_target, file_action, file_action_target, "", TRUE, &_inner_error_);
#line 480 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
 * Performs a recursive iteration on a directory, with callbacks.
 *
 * The caller can provide two {@link RecursiveDirAction}s: one for files,
 * and another for directories. These callbacks can both be null
 * (although if they both were, the call would do nothing). The directory
 * callback is executed after the recursion continues. recursive_directory
 * does the opposite.
 *
 * The directory callback is not performed on the toplevel directory.
 *
 * @param directory The directory to iterate.
 * @param directory_action A {@link RecursiveDirAction} to perform on all
 * directories.
 * @param file_action A {@link RecursiveDirAction} to perform on all files.
 */
#line 201 "ease-utilities.vala"
void ease_recursive_directory_after (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error) {
#line 506 "ease-utilities.c"
	GError * _inner_error_ = NULL;
#line 201 "ease-utilities.vala"
	g_return_if_fail (directory != NULL);
#line 206 "ease-utilities.vala"
	ease_do_recursive_directory (directory, directory_action, directory_action_target, file_action, file_action_target, "", FALSE, &_inner_error_);
#line 512 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
 * Used for execution of recursive_directory(). Should never be called, 
 * except by that function.
 */
#line 217 "ease-utilities.vala"
void ease_do_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, const char* rel_path, gboolean dir_first, GError** error) {
#line 526 "ease-utilities.c"
	GDir* dir;
	char* child_path;
	GError * _inner_error_ = NULL;
#line 217 "ease-utilities.vala"
	g_return_if_fail (directory != NULL);
#line 217 "ease-utilities.vala"
	g_return_if_fail (rel_path != NULL);
#line 224 "ease-utilities.vala"
	dir = g_dir_open (directory, (guint) 0, &_inner_error_);
#line 536 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	child_path = NULL;
#line 227 "ease-utilities.vala"
	while (TRUE) {
#line 544 "ease-utilities.c"
		char* _tmp0_;
		char* child_full_path;
		char* child_rel_path;
#line 227 "ease-utilities.vala"
		if (!((child_path = (_tmp0_ = g_strdup (g_dir_read_name (dir)), _g_free0 (child_path), _tmp0_)) != NULL)) {
#line 227 "ease-utilities.vala"
			break;
#line 552 "ease-utilities.c"
		}
#line 229 "ease-utilities.vala"
		child_full_path = g_build_filename (directory, child_path, NULL);
#line 230 "ease-utilities.vala"
		child_rel_path = g_build_filename (rel_path, child_path, NULL);
#line 231 "ease-utilities.vala"
		if (g_file_test (child_full_path, G_FILE_TEST_IS_DIR)) {
#line 560 "ease-utilities.c"
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
#line 233 "ease-utilities.vala"
			if (directory_action != NULL) {
#line 233 "ease-utilities.vala"
				_tmp1_ = dir_first;
#line 567 "ease-utilities.c"
			} else {
#line 233 "ease-utilities.vala"
				_tmp1_ = FALSE;
#line 571 "ease-utilities.c"
			}
#line 233 "ease-utilities.vala"
			if (_tmp1_) {
#line 235 "ease-utilities.vala"
				directory_action (child_rel_path, child_full_path, directory_action_target, &_inner_error_);
#line 577 "ease-utilities.c"
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (child_rel_path);
					_g_free0 (child_full_path);
					_g_free0 (child_path);
					_g_dir_close0 (dir);
					return;
				}
			}
#line 239 "ease-utilities.vala"
			ease_do_recursive_directory (child_full_path, directory_action, directory_action_target, file_action, file_action_target, child_rel_path, dir_first, &_inner_error_);
#line 589 "ease-utilities.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (child_rel_path);
				_g_free0 (child_full_path);
				_g_free0 (child_path);
				_g_dir_close0 (dir);
				return;
			}
#line 244 "ease-utilities.vala"
			if (directory_action != NULL) {
#line 244 "ease-utilities.vala"
				_tmp2_ = !dir_first;
#line 602 "ease-utilities.c"
			} else {
#line 244 "ease-utilities.vala"
				_tmp2_ = FALSE;
#line 606 "ease-utilities.c"
			}
#line 244 "ease-utilities.vala"
			if (_tmp2_) {
#line 246 "ease-utilities.vala"
				directory_action (child_rel_path, child_full_path, directory_action_target, &_inner_error_);
#line 612 "ease-utilities.c"
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (child_rel_path);
					_g_free0 (child_full_path);
					_g_free0 (child_path);
					_g_dir_close0 (dir);
					return;
				}
			}
		} else {
#line 251 "ease-utilities.vala"
			if (file_action != NULL) {
#line 253 "ease-utilities.vala"
				file_action (child_rel_path, child_full_path, file_action_target, &_inner_error_);
#line 627 "ease-utilities.c"
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (child_rel_path);
					_g_free0 (child_full_path);
					_g_free0 (child_path);
					_g_dir_close0 (dir);
					return;
				}
			}
		}
		_g_free0 (child_rel_path);
		_g_free0 (child_full_path);
	}
	_g_free0 (child_path);
	_g_dir_close0 (dir);
}


/**
 * Recursively removes a directory.
 *
 * @param path The directory to be recursively deleted.
 */
#line 278 "ease-utilities.vala"
static void _lambda13_ (const char* p, const char* full_path, GError** error) {
#line 278 "ease-utilities.vala"
	g_return_if_fail (p != NULL);
#line 278 "ease-utilities.vala"
	g_return_if_fail (full_path != NULL);
#line 279 "ease-utilities.vala"
	g_rmdir (full_path);
#line 659 "ease-utilities.c"
}


#line 278 "ease-utilities.vala"
static void __lambda13__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 665 "ease-utilities.c"
	_lambda13_ (path, full_path, error);
}


#line 281 "ease-utilities.vala"
static void _lambda14_ (const char* p, const char* full_path, GError** error) {
#line 281 "ease-utilities.vala"
	g_return_if_fail (p != NULL);
#line 281 "ease-utilities.vala"
	g_return_if_fail (full_path != NULL);
#line 282 "ease-utilities.vala"
	g_unlink (full_path);
#line 678 "ease-utilities.c"
}


#line 281 "ease-utilities.vala"
static void __lambda14__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 684 "ease-utilities.c"
	_lambda14_ (path, full_path, error);
}


#line 267 "ease-utilities.vala"
void ease_recursive_delete (const char* path, GError** error) {
#line 691 "ease-utilities.c"
	GDir* dir;
	GError * _inner_error_ = NULL;
#line 267 "ease-utilities.vala"
	g_return_if_fail (path != NULL);
#line 269 "ease-utilities.vala"
	dir = g_dir_open (path, (guint) 0, &_inner_error_);
#line 698 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 271 "ease-utilities.vala"
	if (dir == NULL) {
#line 705 "ease-utilities.c"
		_inner_error_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_NOENT, _ ("Directory to remove doesn't exist: %s"), path);
		{
			g_propagate_error (error, _inner_error_);
			_g_dir_close0 (dir);
			return;
		}
	}
#line 277 "ease-utilities.vala"
	ease_recursive_directory_after (path, __lambda13__ease_recursive_dir_action, NULL, __lambda14__ease_recursive_dir_action, NULL, &_inner_error_);
#line 715 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_dir_close0 (dir);
		return;
	}
#line 285 "ease-utilities.vala"
	g_rmdir (path);
#line 723 "ease-utilities.c"
	_g_dir_close0 (dir);
}


/**
 * Recursive copies a directory.
 *
 * @param from_dir The directory to copy from.
 * @param to_dir The directory to copy to.
 */
#line 303 "ease-utilities.vala"
static void _lambda0_ (const char* path, const char* full_path, Block14Data* _data14_, GError** error) {
#line 736 "ease-utilities.c"
	char* _tmp0_;
	GFile* _tmp1_;
	GFile* dir;
	GError * _inner_error_ = NULL;
#line 303 "ease-utilities.vala"
	g_return_if_fail (path != NULL);
#line 303 "ease-utilities.vala"
	g_return_if_fail (full_path != NULL);
#line 304 "ease-utilities.vala"
	dir = (_tmp1_ = g_file_new_for_path (_tmp0_ = g_build_filename (_data14_->to_dir, path, NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 305 "ease-utilities.vala"
	if (!g_file_query_exists (dir, NULL)) {
#line 305 "ease-utilities.vala"
		g_file_make_directory (dir, NULL, &_inner_error_);
#line 751 "ease-utilities.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (dir);
			return;
		}
	}
	_g_object_unref0 (dir);
}


#line 303 "ease-utilities.vala"
static void __lambda0__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 764 "ease-utilities.c"
	_lambda0_ (path, full_path, self, error);
}


#line 307 "ease-utilities.vala"
static void _lambda1_ (const char* path, const char* full_path, Block14Data* _data14_, GError** error) {
#line 771 "ease-utilities.c"
	GFile* from;
	char* _tmp0_;
	GFile* _tmp1_;
	GFile* to;
	GError * _inner_error_ = NULL;
#line 307 "ease-utilities.vala"
	g_return_if_fail (path != NULL);
#line 307 "ease-utilities.vala"
	g_return_if_fail (full_path != NULL);
#line 308 "ease-utilities.vala"
	from = g_file_new_for_path (full_path);
#line 309 "ease-utilities.vala"
	to = (_tmp1_ = g_file_new_for_path (_tmp0_ = g_build_filename (_data14_->to_dir, path, NULL)), _g_free0 (_tmp0_), _tmp1_);
#line 310 "ease-utilities.vala"
	g_file_copy (from, to, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
#line 787 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (to);
		_g_object_unref0 (from);
		return;
	}
	_g_object_unref0 (to);
	_g_object_unref0 (from);
}


#line 307 "ease-utilities.vala"
static void __lambda1__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 801 "ease-utilities.c"
	_lambda1_ (path, full_path, self, error);
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_free0 (_data14_->to_dir);
		g_slice_free (Block14Data, _data14_);
	}
}


#line 294 "ease-utilities.vala"
void ease_recursive_copy (const char* from_dir, const char* to_dir, GError** error) {
#line 822 "ease-utilities.c"
	Block14Data* _data14_;
	GFile* top;
	GError * _inner_error_ = NULL;
#line 294 "ease-utilities.vala"
	g_return_if_fail (from_dir != NULL);
#line 294 "ease-utilities.vala"
	g_return_if_fail (to_dir != NULL);
#line 830 "ease-utilities.c"
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->to_dir = g_strdup (to_dir);
#line 296 "ease-utilities.vala"
	top = g_file_new_for_path (_data14_->to_dir);
#line 297 "ease-utilities.vala"
	if (!g_file_query_exists (top, NULL)) {
#line 299 "ease-utilities.vala"
		g_file_make_directory_with_parents (top, NULL, &_inner_error_);
#line 840 "ease-utilities.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (top);
			block14_data_unref (_data14_);
			return;
		}
	}
#line 302 "ease-utilities.vala"
	ease_recursive_directory (from_dir, __lambda0__ease_recursive_dir_action, _data14_, __lambda1__ease_recursive_dir_action, _data14_, &_inner_error_);
#line 850 "ease-utilities.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (top);
		block14_data_unref (_data14_);
		return;
	}
	_g_object_unref0 (top);
	block14_data_unref (_data14_);
}


/**
 * Locates a color in the current GTK theme.
 *
 * @param color The color to find.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 1027 "glib-2.0.vapi"
static char* string_strip (const char* self) {
#line 874 "ease-utilities.c"
	char* result = NULL;
	char* _result_;
#line 1027 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1028 "glib-2.0.vapi"
	_result_ = g_strdup (self);
#line 1029 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 883 "ease-utilities.c"
	result = _result_;
#line 1030 "glib-2.0.vapi"
	return result;
#line 887 "ease-utilities.c"
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
#line 1170 "glib-2.0.vapi"
	return result;
#line 897 "ease-utilities.c"
}


#line 1086 "glib-2.0.vapi"
static char* string_substring (const char* self, glong offset, glong len) {
#line 903 "ease-utilities.c"
	char* result = NULL;
	glong string_length;
	const char* start;
#line 1086 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1087 "glib-2.0.vapi"
	string_length = string_get_length (self);
#line 1088 "glib-2.0.vapi"
	if (offset < 0) {
#line 1089 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1090 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= 0, NULL);
#line 917 "ease-utilities.c"
	} else {
#line 1092 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 921 "ease-utilities.c"
	}
#line 1094 "glib-2.0.vapi"
	if (len < 0) {
#line 1095 "glib-2.0.vapi"
		len = string_length - offset;
#line 927 "ease-utilities.c"
	}
#line 1097 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1098 "glib-2.0.vapi"
	start = g_utf8_offset_to_pointer (self, offset);
#line 933 "ease-utilities.c"
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
#line 1099 "glib-2.0.vapi"
	return result;
#line 937 "ease-utilities.c"
}


static GdkColor* _gdk_color_dup (GdkColor* self) {
	GdkColor* dup;
	dup = g_new0 (GdkColor, 1);
	memcpy (dup, self, sizeof (GdkColor));
	return dup;
}


static gpointer __gdk_color_dup0 (gpointer self) {
	return self ? _gdk_color_dup (self) : NULL;
}


#line 319 "ease-utilities.vala"
GdkColor* ease_theme_color (const char* color) {
#line 956 "ease-utilities.c"
	GdkColor* result = NULL;
	GtkSettings* settings;
	gint colors_length1;
	gint _colors_size_;
	char** _tmp4_;
	char* _tmp0_ = NULL;
	char* _tmp1_;
	char** _tmp2_;
	char** _tmp3_;
	char** colors;
#line 319 "ease-utilities.vala"
	g_return_val_if_fail (color != NULL, NULL);
#line 322 "ease-utilities.vala"
	settings = _g_object_ref0 (gtk_settings_get_default ());
#line 971 "ease-utilities.c"
	colors = (_tmp4_ = (_tmp3_ = _tmp2_ = g_strsplit_set (_tmp1_ = (g_object_get (settings, "gtk-color-scheme", &_tmp0_, NULL), _tmp0_), "\n;", 0), _g_free0 (_tmp1_), _tmp3_), colors_length1 = _vala_array_length (_tmp2_), _colors_size_ = colors_length1, _tmp4_);
	{
		gint i;
#line 324 "ease-utilities.vala"
		i = 0;
#line 977 "ease-utilities.c"
		{
			gboolean _tmp5_;
#line 324 "ease-utilities.vala"
			_tmp5_ = TRUE;
#line 324 "ease-utilities.vala"
			while (TRUE) {
#line 984 "ease-utilities.c"
				char* _tmp6_;
#line 324 "ease-utilities.vala"
				if (!_tmp5_) {
#line 324 "ease-utilities.vala"
					i++;
#line 990 "ease-utilities.c"
				}
#line 324 "ease-utilities.vala"
				_tmp5_ = FALSE;
#line 324 "ease-utilities.vala"
				if (!(i < colors_length1)) {
#line 324 "ease-utilities.vala"
					break;
#line 998 "ease-utilities.c"
				}
#line 326 "ease-utilities.vala"
				colors[i] = (_tmp6_ = string_strip (colors[i]), _g_free0 (colors[i]), _tmp6_);
#line 328 "ease-utilities.vala"
				if (g_str_has_prefix (colors[i], color)) {
#line 1004 "ease-utilities.c"
					GdkColor gdk_color = {0};
					{
						gboolean _tmp7_;
#line 330 "ease-utilities.vala"
						_tmp7_ = TRUE;
#line 330 "ease-utilities.vala"
						while (TRUE) {
#line 1012 "ease-utilities.c"
							gboolean _tmp9_ = FALSE;
#line 330 "ease-utilities.vala"
							if (!_tmp7_) {
#line 1016 "ease-utilities.c"
								char* _tmp8_;
#line 331 "ease-utilities.vala"
								colors[i] = (_tmp8_ = string_substring (colors[i], (glong) 1, string_get_length (colors[i]) - 1), _g_free0 (colors[i]), _tmp8_);
#line 1020 "ease-utilities.c"
							}
#line 330 "ease-utilities.vala"
							_tmp7_ = FALSE;
#line 330 "ease-utilities.vala"
							if (!g_str_has_prefix (colors[i], "#")) {
#line 330 "ease-utilities.vala"
								_tmp9_ = string_get_length (colors[i]) > 3;
#line 1028 "ease-utilities.c"
							} else {
#line 330 "ease-utilities.vala"
								_tmp9_ = FALSE;
#line 1032 "ease-utilities.c"
							}
#line 330 "ease-utilities.vala"
							if (!_tmp9_) {
#line 330 "ease-utilities.vala"
								break;
#line 1038 "ease-utilities.c"
							}
							;
						}
					}
#line 334 "ease-utilities.vala"
					gdk_color_parse (colors[i], &gdk_color);
#line 1045 "ease-utilities.c"
					result = __gdk_color_dup0 (&gdk_color);
					colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (settings);
#line 335 "ease-utilities.vala"
					return result;
#line 1051 "ease-utilities.c"
				}
			}
		}
	}
#line 339 "ease-utilities.vala"
	g_warning ("ease-utilities.vala:339: Could not find color: %s", color);
#line 1058 "ease-utilities.c"
	result = NULL;
	colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
#line 340 "ease-utilities.vala"
	return result;
#line 1064 "ease-utilities.c"
}


/**
 * Locates a color in the current GTK theme, as a Clutter.Color.
 *
 * @param color The color to find.
 */
#line 348 "ease-utilities.vala"
void ease_theme_clutter_color (const char* color, ClutterColor* result) {
#line 1075 "ease-utilities.c"
	GdkColor* _tmp0_;
	ClutterColor _tmp1_ = {0};
	ClutterColor _tmp2_;
#line 348 "ease-utilities.vala"
	g_return_if_fail (color != NULL);
#line 1081 "ease-utilities.c"
	*result = (_tmp2_ = (ease_transformations_gdk_color_to_clutter_color (_tmp0_ = ease_theme_color (color), &_tmp1_), _tmp1_), _g_free0 (_tmp0_), _tmp2_);
#line 350 "ease-utilities.vala"
	return;
#line 1085 "ease-utilities.c"
}


/**
 * Returns the parent window of the specified widget.
 */
#line 356 "ease-utilities.vala"
GtkWindow* ease_widget_window (GtkWidget* widg) {
#line 1094 "ease-utilities.c"
	GtkWindow* result = NULL;
	GtkWidget* _tmp0_;
#line 356 "ease-utilities.vala"
	g_return_val_if_fail (widg != NULL, NULL);
#line 358 "ease-utilities.vala"
	while (TRUE) {
#line 358 "ease-utilities.vala"
		if (!(gtk_widget_get_parent (widg) != NULL)) {
#line 358 "ease-utilities.vala"
			break;
#line 1105 "ease-utilities.c"
		}
#line 358 "ease-utilities.vala"
		widg = gtk_widget_get_parent (widg);
#line 1109 "ease-utilities.c"
	}
	result = _g_object_ref0 ((_tmp0_ = widg, GTK_IS_WINDOW (_tmp0_) ? ((GtkWindow*) _tmp0_) : NULL));
#line 359 "ease-utilities.vala"
	return result;
#line 1114 "ease-utilities.c"
}


/**
 * Returns an absolute path for the given path.
 */
#line 365 "ease-utilities.vala"
char* ease_absolute_path (const char* path) {
#line 1123 "ease-utilities.c"
	char* result = NULL;
	GFile* file;
	GFile* _tmp0_;
	char* _tmp1_;
#line 365 "ease-utilities.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 367 "ease-utilities.vala"
	file = g_file_new_for_path (path);
#line 1132 "ease-utilities.c"
	result = (_tmp1_ = g_file_get_path (_tmp0_ = g_file_resolve_relative_path (file, ".")), _g_object_unref0 (_tmp0_), _tmp1_);
	_g_object_unref0 (file);
#line 368 "ease-utilities.vala"
	return result;
#line 1137 "ease-utilities.c"
	_g_object_unref0 (file);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




