/* ease-inspector-transition-pane.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-inspector-transition-pane.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutter/clutter.h>
#include <ease-core.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <string.h>


#define EASE_TYPE_INSPECTOR_PANE (ease_inspector_pane_get_type ())
#define EASE_INSPECTOR_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_INSPECTOR_PANE, EaseInspectorPane))
#define EASE_INSPECTOR_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_INSPECTOR_PANE, EaseInspectorPaneClass))
#define EASE_IS_INSPECTOR_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_INSPECTOR_PANE))
#define EASE_IS_INSPECTOR_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_INSPECTOR_PANE))
#define EASE_INSPECTOR_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_INSPECTOR_PANE, EaseInspectorPaneClass))

typedef struct _EaseInspectorPane EaseInspectorPane;
typedef struct _EaseInspectorPaneClass EaseInspectorPaneClass;
typedef struct _EaseInspectorPanePrivate EaseInspectorPanePrivate;

#define EASE_TYPE_INSPECTOR_TRANSITION_PANE (ease_inspector_transition_pane_get_type ())
#define EASE_INSPECTOR_TRANSITION_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_INSPECTOR_TRANSITION_PANE, EaseInspectorTransitionPane))
#define EASE_INSPECTOR_TRANSITION_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_INSPECTOR_TRANSITION_PANE, EaseInspectorTransitionPaneClass))
#define EASE_IS_INSPECTOR_TRANSITION_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_INSPECTOR_TRANSITION_PANE))
#define EASE_IS_INSPECTOR_TRANSITION_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_INSPECTOR_TRANSITION_PANE))
#define EASE_INSPECTOR_TRANSITION_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_INSPECTOR_TRANSITION_PANE, EaseInspectorTransitionPaneClass))

typedef struct _EaseInspectorTransitionPane EaseInspectorTransitionPane;
typedef struct _EaseInspectorTransitionPaneClass EaseInspectorTransitionPaneClass;
typedef struct _EaseInspectorTransitionPanePrivate EaseInspectorTransitionPanePrivate;

#define EASE_TYPE_SLIDE_ACTOR (ease_slide_actor_get_type ())
#define EASE_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActor))
#define EASE_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))
#define EASE_IS_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_ACTOR))
#define EASE_IS_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_ACTOR))
#define EASE_SLIDE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))

typedef struct _EaseSlideActor EaseSlideActor;
typedef struct _EaseSlideActorClass EaseSlideActorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _EaseInspectorPane {
	GtkVBox parent_instance;
	EaseInspectorPanePrivate * priv;
};

struct _EaseInspectorPaneClass {
	GtkVBoxClass parent_class;
	void (*slide_updated) (EaseInspectorPane* self);
};

struct _EaseInspectorTransitionPane {
	EaseInspectorPane parent_instance;
	EaseInspectorTransitionPanePrivate * priv;
	GtkComboBox* effect;
	GtkComboBox* variant;
};

struct _EaseInspectorTransitionPaneClass {
	EaseInspectorPaneClass parent_class;
};

struct _EaseInspectorTransitionPanePrivate {
	GtkSpinButton* transition_time;
	GtkAlignment* variant_align;
	GtkComboBox* start_transition;
	GtkSpinButton* delay;
	GtkClutterEmbed* preview;
	ClutterGroup* preview_group;
	GtkAlignment* preview_align;
	EaseSlideActor* current_slide;
	EaseSlideActor* new_slide;
	ClutterTimeline* preview_alarm;
	EaseSlide* old_slide;
	gboolean silence_undo;
};


static gpointer ease_inspector_transition_pane_parent_class = NULL;

GType ease_inspector_pane_get_type (void) G_GNUC_CONST;
GType ease_inspector_transition_pane_get_type (void) G_GNUC_CONST;
GType ease_slide_actor_get_type (void) G_GNUC_CONST;
#define EASE_INSPECTOR_TRANSITION_PANE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_INSPECTOR_TRANSITION_PANE, EaseInspectorTransitionPanePrivate))
enum  {
	EASE_INSPECTOR_TRANSITION_PANE_DUMMY_PROPERTY
};
#define EASE_INSPECTOR_TRANSITION_PANE_PREVIEW_HEIGHT 150
#define EASE_INSPECTOR_TRANSITION_PANE_PREVIEW_DELAY ((guint) 500)
#define EASE_INSPECTOR_TRANSITION_PANE_DEFAULT_TRANSITION_TIME 1
#define EASE_INSPECTOR_TRANSITION_PANE_DEFAULT_ADVANCE_DELAY 5
EaseInspectorTransitionPane* ease_inspector_transition_pane_new (EaseDocument* d);
EaseInspectorTransitionPane* ease_inspector_transition_pane_construct (GType object_type, EaseDocument* d);
EaseInspectorPane* ease_inspector_pane_construct (GType object_type, EaseDocument* d);
static void _lambda35_ (GtkComboBox* sender, EaseInspectorTransitionPane* self);
EaseSlide* ease_inspector_pane_get_slide (EaseInspectorPane* self);
static void __lambda35__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _lambda36_ (GtkComboBox* sender, EaseInspectorTransitionPane* self);
static void __lambda36__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _lambda37_ (EaseInspectorTransitionPane* self);
static void __lambda37__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _lambda38_ (EaseInspectorTransitionPane* self);
static void __lambda38__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void _lambda39_ (EaseInspectorTransitionPane* self);
static void __lambda39__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void _lambda40_ (ClutterActorBox* box, ClutterAllocationFlags flags, EaseInspectorTransitionPane* self);
static void __lambda40__clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* p0, ClutterAllocationFlags p1, gpointer self);
static void _lambda41_ (GtkWidget* widget, GdkRectangle* allocation, EaseInspectorTransitionPane* self);
EaseDocument* ease_inspector_pane_get_document (EaseInspectorPane* self);
static void __lambda41__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void ease_inspector_transition_pane_animate_preview (EaseInspectorTransitionPane* self);
void ease_slide_actor_reset (EaseSlideActor* self, ClutterGroup* container);
static void _lambda42_ (EaseInspectorTransitionPane* self);
static void ease_inspector_transition_pane_animate_preview_start (EaseInspectorTransitionPane* self);
static void __lambda42__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
void ease_slide_actor_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container);
static void _lambda43_ (EaseInspectorTransitionPane* self);
static void ease_inspector_transition_pane_animate_preview_delay (EaseInspectorTransitionPane* self);
static void __lambda43__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void _lambda44_ (EaseInspectorTransitionPane* self);
static void __lambda44__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void ease_inspector_transition_pane_on_slide_notify (EaseInspectorTransitionPane* self, GObject* obj, GParamSpec* spec);
static void ease_inspector_transition_pane_real_slide_updated (EaseInspectorPane* base);
static void _ease_inspector_transition_pane_on_slide_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
EaseSlideActor* ease_slide_actor_new_from_slide (EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_construct_from_slide (GType object_type, EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_new_blank (EaseDocument* document, ClutterColor* color);
EaseSlideActor* ease_slide_actor_construct_blank (GType object_type, EaseDocument* document, ClutterColor* color);
static void ease_inspector_transition_pane_finalize (GObject* obj);



#line 142 "ease-inspector-transition-pane.vala"
static void _lambda35_ (GtkComboBox* sender, EaseInspectorTransitionPane* self) {
#line 161 "ease-inspector-transition-pane.c"
	EaseUndoAction* action;
	gboolean already_silenced;
	GtkTreeIter itr = {0};
	GtkListStore* _tmp1_;
#line 142 "ease-inspector-transition-pane.vala"
	g_return_if_fail (sender != NULL);
#line 144 "ease-inspector-transition-pane.vala"
	action = ease_undo_action_new ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "transition");
#line 145 "ease-inspector-transition-pane.vala"
	ease_undo_action_add (action, (GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "variant");
#line 147 "ease-inspector-transition-pane.vala"
	already_silenced = self->priv->silence_undo;
#line 148 "ease-inspector-transition-pane.vala"
	self->priv->silence_undo = TRUE;
#line 152 "ease-inspector-transition-pane.vala"
	if (gtk_combo_box_get_active_iter (sender, &itr)) {
#line 178 "ease-inspector-transition-pane.c"
		EaseTransition transition = 0;
#line 155 "ease-inspector-transition-pane.vala"
		gtk_tree_model_get (gtk_combo_box_get_model (sender), &itr, 1, &transition, -1);
#line 158 "ease-inspector-transition-pane.vala"
		if (transition == EASE_TRANSITION_NONE) {
#line 160 "ease-inspector-transition-pane.vala"
			gtk_spin_button_set_value (self->priv->transition_time, ease_slide_get_transition_time (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)));
#line 161 "ease-inspector-transition-pane.vala"
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->transition_time, FALSE);
#line 162 "ease-inspector-transition-pane.vala"
			ease_undo_action_add (action, (GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "transition-time");
#line 190 "ease-inspector-transition-pane.c"
		} else {
#line 164 "ease-inspector-transition-pane.vala"
			if (ease_slide_get_transition (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)) == EASE_TRANSITION_NONE) {
#line 166 "ease-inspector-transition-pane.vala"
				if (ease_slide_get_transition_time (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)) == 0) {
#line 168 "ease-inspector-transition-pane.vala"
					ease_slide_set_transition_time (ease_inspector_pane_get_slide ((EaseInspectorPane*) self), (double) EASE_INSPECTOR_TRANSITION_PANE_DEFAULT_TRANSITION_TIME);
#line 198 "ease-inspector-transition-pane.c"
				}
#line 170 "ease-inspector-transition-pane.vala"
				gtk_spin_button_set_value (self->priv->transition_time, ease_slide_get_transition_time (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)));
#line 171 "ease-inspector-transition-pane.vala"
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->transition_time, TRUE);
#line 172 "ease-inspector-transition-pane.vala"
				ease_undo_action_add (action, (GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "transition-time");
#line 206 "ease-inspector-transition-pane.c"
			}
		}
#line 176 "ease-inspector-transition-pane.vala"
		ease_slide_set_transition (ease_inspector_pane_get_slide ((EaseInspectorPane*) self), transition);
#line 179 "ease-inspector-transition-pane.vala"
		if (!already_silenced) {
#line 179 "ease-inspector-transition-pane.vala"
			g_signal_emit_by_name ((EaseUndoSource*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "undo", (EaseUndoItem*) action);
#line 215 "ease-inspector-transition-pane.c"
		}
	} else {
		EaseUndoItem* _tmp0_;
#line 183 "ease-inspector-transition-pane.vala"
		g_critical ("ease-inspector-transition-pane.vala:183: Transition not found in model");
#line 184 "ease-inspector-transition-pane.vala"
		_tmp0_ = ease_undo_item_apply ((EaseUndoItem*) action);
#line 223 "ease-inspector-transition-pane.c"
		_g_object_unref0 (_tmp0_);
	}
#line 188 "ease-inspector-transition-pane.vala"
	gtk_combo_box_set_model (self->variant, (GtkTreeModel*) (_tmp1_ = ease_transition_variant_model (ease_slide_get_transition (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)))));
#line 228 "ease-inspector-transition-pane.c"
	_g_object_unref0 (_tmp1_);
#line 191 "ease-inspector-transition-pane.vala"
	if (gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->variant), &itr)) {
#line 232 "ease-inspector-transition-pane.c"
		EaseTransitionVariant v = 0;
		{
			gboolean _tmp2_;
#line 194 "ease-inspector-transition-pane.vala"
			_tmp2_ = TRUE;
#line 194 "ease-inspector-transition-pane.vala"
			while (TRUE) {
#line 194 "ease-inspector-transition-pane.vala"
				if (!_tmp2_) {
#line 204 "ease-inspector-transition-pane.vala"
					if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (self->variant), &itr)) {
#line 204 "ease-inspector-transition-pane.vala"
						break;
#line 246 "ease-inspector-transition-pane.c"
					}
				}
#line 194 "ease-inspector-transition-pane.vala"
				_tmp2_ = FALSE;
#line 196 "ease-inspector-transition-pane.vala"
				gtk_tree_model_get (gtk_combo_box_get_model (self->variant), &itr, 1, &v, -1);
#line 197 "ease-inspector-transition-pane.vala"
				if (v == ease_slide_get_variant (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))) {
#line 199 "ease-inspector-transition-pane.vala"
					gtk_combo_box_set_active_iter (self->variant, &itr);
#line 200 "ease-inspector-transition-pane.vala"
					self->priv->silence_undo = already_silenced;
#line 259 "ease-inspector-transition-pane.c"
					_g_object_unref0 (action);
#line 201 "ease-inspector-transition-pane.vala"
					return;
#line 263 "ease-inspector-transition-pane.c"
				}
			}
		}
#line 207 "ease-inspector-transition-pane.vala"
		gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->variant), &itr);
#line 208 "ease-inspector-transition-pane.vala"
		gtk_combo_box_set_active_iter (self->variant, &itr);
#line 271 "ease-inspector-transition-pane.c"
	}
#line 211 "ease-inspector-transition-pane.vala"
	self->priv->silence_undo = already_silenced;
#line 275 "ease-inspector-transition-pane.c"
	_g_object_unref0 (action);
}


#line 142 "ease-inspector-transition-pane.vala"
static void __lambda35__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 282 "ease-inspector-transition-pane.c"
	_lambda35_ (_sender, self);
}


#line 215 "ease-inspector-transition-pane.vala"
static void _lambda36_ (GtkComboBox* sender, EaseInspectorTransitionPane* self) {
#line 289 "ease-inspector-transition-pane.c"
	GtkTreeIter itr = {0};
#line 215 "ease-inspector-transition-pane.vala"
	g_return_if_fail (sender != NULL);
#line 216 "ease-inspector-transition-pane.vala"
	if (!self->priv->silence_undo) {
#line 295 "ease-inspector-transition-pane.c"
		EaseUndoAction* _tmp0_;
#line 216 "ease-inspector-transition-pane.vala"
		g_signal_emit_by_name ((EaseUndoSource*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "undo", (EaseUndoItem*) (_tmp0_ = ease_undo_action_new ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "variant")));
#line 299 "ease-inspector-transition-pane.c"
		_g_object_unref0 (_tmp0_);
	}
#line 219 "ease-inspector-transition-pane.vala"
	if (gtk_combo_box_get_active_iter (sender, &itr)) {
#line 304 "ease-inspector-transition-pane.c"
		EaseTransitionVariant variant = 0;
#line 222 "ease-inspector-transition-pane.vala"
		gtk_tree_model_get (gtk_combo_box_get_model (sender), &itr, 1, &variant, -1);
#line 223 "ease-inspector-transition-pane.vala"
		ease_slide_set_variant (ease_inspector_pane_get_slide ((EaseInspectorPane*) self), variant);
#line 310 "ease-inspector-transition-pane.c"
	} else {
#line 227 "ease-inspector-transition-pane.vala"
		g_critical ("ease-inspector-transition-pane.vala:227: Variant not found in model");
#line 314 "ease-inspector-transition-pane.c"
	}
}


#line 215 "ease-inspector-transition-pane.vala"
static void __lambda36__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 321 "ease-inspector-transition-pane.c"
	_lambda36_ (_sender, self);
}


#line 231 "ease-inspector-transition-pane.vala"
static void _lambda37_ (EaseInspectorTransitionPane* self) {
#line 232 "ease-inspector-transition-pane.vala"
	if (!self->priv->silence_undo) {
#line 330 "ease-inspector-transition-pane.c"
		EaseUndoAction* _tmp0_;
#line 232 "ease-inspector-transition-pane.vala"
		g_signal_emit_by_name ((EaseUndoSource*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "undo", (EaseUndoItem*) (_tmp0_ = ease_undo_action_new ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "automatically-advance")));
#line 334 "ease-inspector-transition-pane.c"
		_g_object_unref0 (_tmp0_);
	}
#line 234 "ease-inspector-transition-pane.vala"
	if (gtk_combo_box_get_active (self->priv->start_transition) == 0) {
#line 236 "ease-inspector-transition-pane.vala"
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->delay, FALSE);
#line 237 "ease-inspector-transition-pane.vala"
		ease_slide_set_automatically_advance (ease_inspector_pane_get_slide ((EaseInspectorPane*) self), FALSE);
#line 343 "ease-inspector-transition-pane.c"
	} else {
#line 241 "ease-inspector-transition-pane.vala"
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->delay, TRUE);
#line 242 "ease-inspector-transition-pane.vala"
		ease_slide_set_automatically_advance (ease_inspector_pane_get_slide ((EaseInspectorPane*) self), TRUE);
#line 243 "ease-inspector-transition-pane.vala"
		if (ease_slide_get_advance_delay (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)) == 0) {
#line 245 "ease-inspector-transition-pane.vala"
			ease_slide_set_advance_delay (ease_inspector_pane_get_slide ((EaseInspectorPane*) self), (double) EASE_INSPECTOR_TRANSITION_PANE_DEFAULT_ADVANCE_DELAY);
#line 353 "ease-inspector-transition-pane.c"
		}
	}
}


#line 231 "ease-inspector-transition-pane.vala"
static void __lambda37__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 361 "ease-inspector-transition-pane.c"
	_lambda37_ (self);
}


#line 250 "ease-inspector-transition-pane.vala"
static void _lambda38_ (EaseInspectorTransitionPane* self) {
#line 251 "ease-inspector-transition-pane.vala"
	if (!self->priv->silence_undo) {
#line 370 "ease-inspector-transition-pane.c"
		EaseUndoAction* _tmp0_;
#line 252 "ease-inspector-transition-pane.vala"
		g_signal_emit_by_name ((EaseUndoSource*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "undo", (EaseUndoItem*) (_tmp0_ = ease_undo_action_new ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "transition-time")));
#line 374 "ease-inspector-transition-pane.c"
		_g_object_unref0 (_tmp0_);
	}
#line 253 "ease-inspector-transition-pane.vala"
	ease_slide_set_transition_time (ease_inspector_pane_get_slide ((EaseInspectorPane*) self), gtk_spin_button_get_value (self->priv->transition_time));
#line 379 "ease-inspector-transition-pane.c"
}


#line 250 "ease-inspector-transition-pane.vala"
static void __lambda38__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
#line 385 "ease-inspector-transition-pane.c"
	_lambda38_ (self);
}


#line 256 "ease-inspector-transition-pane.vala"
static void _lambda39_ (EaseInspectorTransitionPane* self) {
#line 257 "ease-inspector-transition-pane.vala"
	if (!self->priv->silence_undo) {
#line 394 "ease-inspector-transition-pane.c"
		EaseUndoAction* _tmp0_;
#line 258 "ease-inspector-transition-pane.vala"
		g_signal_emit_by_name ((EaseUndoSource*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "undo", (EaseUndoItem*) (_tmp0_ = ease_undo_action_new ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "advance-delay")));
#line 398 "ease-inspector-transition-pane.c"
		_g_object_unref0 (_tmp0_);
	}
#line 259 "ease-inspector-transition-pane.vala"
	ease_slide_set_advance_delay (ease_inspector_pane_get_slide ((EaseInspectorPane*) self), gtk_spin_button_get_value (self->priv->delay));
#line 403 "ease-inspector-transition-pane.c"
}


#line 256 "ease-inspector-transition-pane.vala"
static void __lambda39__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
#line 409 "ease-inspector-transition-pane.c"
	_lambda39_ (self);
}


#line 263 "ease-inspector-transition-pane.vala"
static void _lambda40_ (ClutterActorBox* box, ClutterAllocationFlags flags, EaseInspectorTransitionPane* self) {
#line 264 "ease-inspector-transition-pane.vala"
	g_object_set ((ClutterActor*) self->priv->preview_group, "scale-x", (double) (((*box).x2 - (*box).x1) / ease_slide_get_width (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))), NULL);
#line 265 "ease-inspector-transition-pane.vala"
	g_object_set ((ClutterActor*) self->priv->preview_group, "scale-y", (double) (((*box).y2 - (*box).y1) / ease_slide_get_height (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))), NULL);
#line 420 "ease-inspector-transition-pane.c"
}


#line 263 "ease-inspector-transition-pane.vala"
static void __lambda40__clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* p0, ClutterAllocationFlags p1, gpointer self) {
#line 426 "ease-inspector-transition-pane.c"
	_lambda40_ (p0, p1, self);
}


#line 269 "ease-inspector-transition-pane.vala"
static void _lambda41_ (GtkWidget* widget, GdkRectangle* allocation, EaseInspectorTransitionPane* self) {
#line 269 "ease-inspector-transition-pane.vala"
	g_return_if_fail (widget != NULL);
#line 270 "ease-inspector-transition-pane.vala"
	if (ease_inspector_pane_get_slide ((EaseInspectorPane*) self) == NULL) {
#line 270 "ease-inspector-transition-pane.vala"
		return;
#line 439 "ease-inspector-transition-pane.c"
	}
#line 272 "ease-inspector-transition-pane.vala"
	g_object_set ((GtkWidget*) self->priv->preview_align, "height-request", (gint) ((*allocation).width / ease_document_get_aspect (ease_inspector_pane_get_document ((EaseInspectorPane*) self))), NULL);
#line 443 "ease-inspector-transition-pane.c"
}


#line 269 "ease-inspector-transition-pane.vala"
static void __lambda41__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
#line 449 "ease-inspector-transition-pane.c"
	_lambda41_ (_sender, allocation, self);
}


#line 51 "ease-inspector-transition-pane.vala"
EaseInspectorTransitionPane* ease_inspector_transition_pane_construct (GType object_type, EaseDocument* d) {
#line 456 "ease-inspector-transition-pane.c"
	EaseInspectorTransitionPane * self;
	GtkClutterEmbed* _tmp0_;
	ClutterColor _tmp1_ = {0};
	ClutterColor _tmp2_;
	GtkAlignment* _tmp3_;
	GtkFrame* frame;
	ClutterGroup* _tmp4_;
	GtkVBox* vbox;
	GtkHBox* hbox;
	GtkAlignment* align;
	GtkLabel* _tmp5_;
	GtkListStore* _tmp6_;
	GtkComboBox* _tmp7_;
	GtkCellRendererText* render;
	GtkAlignment* _tmp8_;
	GtkVBox* _tmp9_;
	GtkAlignment* _tmp10_;
	GtkLabel* _tmp11_;
	GtkSpinButton* _tmp12_;
	GtkAlignment* _tmp13_;
	GtkHBox* _tmp14_;
	GtkVBox* _tmp15_;
	GtkAlignment* _tmp16_;
	GtkLabel* _tmp17_;
	GtkComboBox* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkAlignment* _tmp20_;
	GtkVBox* _tmp21_;
	GtkHBox* _tmp22_;
	GtkAlignment* _tmp23_;
	GtkLabel* _tmp24_;
	GtkComboBox* _tmp25_;
	GtkAlignment* _tmp26_;
	GtkVBox* _tmp27_;
	GtkAlignment* _tmp28_;
	GtkLabel* _tmp29_;
	GtkSpinButton* _tmp30_;
	GtkAlignment* _tmp31_;
#line 51 "ease-inspector-transition-pane.vala"
	g_return_val_if_fail (d != NULL, NULL);
#line 53 "ease-inspector-transition-pane.vala"
	self = (EaseInspectorTransitionPane*) ease_inspector_pane_construct (object_type, d);
#line 56 "ease-inspector-transition-pane.vala"
	self->priv->preview = (_tmp0_ = g_object_ref_sink ((GtkClutterEmbed*) gtk_clutter_embed_new ()), _g_object_unref0 (self->priv->preview), _tmp0_);
#line 57 "ease-inspector-transition-pane.vala"
	clutter_stage_set_color (CLUTTER_STAGE (gtk_clutter_embed_get_stage (self->priv->preview)), (_tmp2_ = (_tmp1_.red = (guchar) 0, _tmp1_.green = (guchar) 0, _tmp1_.blue = (guchar) 0, _tmp1_.alpha = (guchar) 255, _tmp1_), &_tmp2_));
#line 59 "ease-inspector-transition-pane.vala"
	self->priv->preview_align = (_tmp3_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, (float) 1, (float) 1)), _g_object_unref0 (self->priv->preview_align), _tmp3_);
#line 60 "ease-inspector-transition-pane.vala"
	frame = g_object_ref_sink ((GtkFrame*) gtk_frame_new (NULL));
#line 61 "ease-inspector-transition-pane.vala"
	gtk_frame_set_shadow_type (frame, GTK_SHADOW_IN);
#line 62 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) self->priv->preview_align, (GtkWidget*) self->priv->preview);
#line 63 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) self->priv->preview_align);
#line 65 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) frame, FALSE, FALSE, (guint) 5);
#line 66 "ease-inspector-transition-pane.vala"
	self->priv->preview_group = (_tmp4_ = g_object_ref_sink ((ClutterGroup*) clutter_group_new ()), _g_object_unref0 (self->priv->preview_group), _tmp4_);
#line 67 "ease-inspector-transition-pane.vala"
	clutter_container_add_actor ((ClutterContainer*) CLUTTER_STAGE (gtk_clutter_embed_get_stage (self->priv->preview)), (ClutterActor*) self->priv->preview_group);
#line 70 "ease-inspector-transition-pane.vala"
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
#line 71 "ease-inspector-transition-pane.vala"
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
#line 72 "ease-inspector-transition-pane.vala"
	align = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 0, (float) 0));
#line 73 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) (_tmp5_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Effect")))));
#line 527 "ease-inspector-transition-pane.c"
	_g_object_unref0 (_tmp5_);
#line 74 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
#line 75 "ease-inspector-transition-pane.vala"
	self->effect = (_tmp7_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) (_tmp6_ = ease_transition_model ()))), _g_object_unref0 (self->effect), _tmp7_);
#line 533 "ease-inspector-transition-pane.c"
	_g_object_unref0 (_tmp6_);
#line 76 "ease-inspector-transition-pane.vala"
	render = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
#line 77 "ease-inspector-transition-pane.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->effect, (GtkCellRenderer*) render, TRUE);
#line 78 "ease-inspector-transition-pane.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->effect, (GtkCellRenderer*) render, "text", 0, NULL);
#line 79 "ease-inspector-transition-pane.vala"
	align = (_tmp8_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 1, (float) 1)), _g_object_unref0 (align), _tmp8_);
#line 80 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) self->effect);
#line 81 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
#line 82 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 5);
#line 85 "ease-inspector-transition-pane.vala"
	vbox = (_tmp9_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (vbox), _tmp9_);
#line 86 "ease-inspector-transition-pane.vala"
	align = (_tmp10_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 0, (float) 0)), _g_object_unref0 (align), _tmp10_);
#line 87 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) (_tmp11_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Duration")))));
#line 555 "ease-inspector-transition-pane.c"
	_g_object_unref0 (_tmp11_);
#line 88 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
#line 89 "ease-inspector-transition-pane.vala"
	self->priv->transition_time = (_tmp12_ = g_object_ref_sink ((GtkSpinButton*) gtk_spin_button_new_with_range ((double) 0, (double) 10, 0.25)), _g_object_unref0 (self->priv->transition_time), _tmp12_);
#line 90 "ease-inspector-transition-pane.vala"
	gtk_spin_button_set_digits (self->priv->transition_time, (guint) 2);
#line 91 "ease-inspector-transition-pane.vala"
	align = (_tmp13_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, 0.5f, (float) 1, (float) 1)), _g_object_unref0 (align), _tmp13_);
#line 92 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) self->priv->transition_time);
#line 93 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, TRUE, TRUE, (guint) 0);
#line 94 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, FALSE, FALSE, (guint) 5);
#line 95 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) hbox, FALSE, FALSE, (guint) 5);
#line 98 "ease-inspector-transition-pane.vala"
	hbox = (_tmp14_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (hbox), _tmp14_);
#line 99 "ease-inspector-transition-pane.vala"
	vbox = (_tmp15_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (vbox), _tmp15_);
#line 100 "ease-inspector-transition-pane.vala"
	align = (_tmp16_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 0, (float) 0)), _g_object_unref0 (align), _tmp16_);
#line 101 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) (_tmp17_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Direction")))));
#line 581 "ease-inspector-transition-pane.c"
	_g_object_unref0 (_tmp17_);
#line 102 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
#line 103 "ease-inspector-transition-pane.vala"
	self->variant = (_tmp18_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new ()), _g_object_unref0 (self->variant), _tmp18_);
#line 104 "ease-inspector-transition-pane.vala"
	render = (_tmp19_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (render), _tmp19_);
#line 105 "ease-inspector-transition-pane.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->variant, (GtkCellRenderer*) render, TRUE);
#line 106 "ease-inspector-transition-pane.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->variant, (GtkCellRenderer*) render, "text", 0, NULL);
#line 107 "ease-inspector-transition-pane.vala"
	self->priv->variant_align = (_tmp20_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 1, (float) 1)), _g_object_unref0 (self->priv->variant_align), _tmp20_);
#line 108 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) self->priv->variant_align, (GtkWidget*) self->variant);
#line 109 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->variant_align, FALSE, FALSE, (guint) 0);
#line 110 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 5);
#line 111 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) hbox, FALSE, FALSE, (guint) 5);
#line 114 "ease-inspector-transition-pane.vala"
	vbox = (_tmp21_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (vbox), _tmp21_);
#line 115 "ease-inspector-transition-pane.vala"
	hbox = (_tmp22_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (hbox), _tmp22_);
#line 116 "ease-inspector-transition-pane.vala"
	align = (_tmp23_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 0, (float) 0)), _g_object_unref0 (align), _tmp23_);
#line 117 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) (_tmp24_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Start Transition")))));
#line 611 "ease-inspector-transition-pane.c"
	_g_object_unref0 (_tmp24_);
#line 118 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
#line 119 "ease-inspector-transition-pane.vala"
	self->priv->start_transition = (_tmp25_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), _g_object_unref0 (self->priv->start_transition), _tmp25_);
#line 120 "ease-inspector-transition-pane.vala"
	gtk_combo_box_append_text (self->priv->start_transition, _ ("Manually"));
#line 121 "ease-inspector-transition-pane.vala"
	gtk_combo_box_append_text (self->priv->start_transition, _ ("Automatically"));
#line 122 "ease-inspector-transition-pane.vala"
	gtk_combo_box_set_active (self->priv->start_transition, 0);
#line 123 "ease-inspector-transition-pane.vala"
	align = (_tmp26_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 1, (float) 1)), _g_object_unref0 (align), _tmp26_);
#line 124 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) self->priv->start_transition);
#line 125 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
#line 126 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 5);
#line 129 "ease-inspector-transition-pane.vala"
	vbox = (_tmp27_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (vbox), _tmp27_);
#line 130 "ease-inspector-transition-pane.vala"
	align = (_tmp28_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 0, (float) 0)), _g_object_unref0 (align), _tmp28_);
#line 131 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) (_tmp29_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Delay")))));
#line 637 "ease-inspector-transition-pane.c"
	_g_object_unref0 (_tmp29_);
#line 132 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
#line 133 "ease-inspector-transition-pane.vala"
	self->priv->delay = (_tmp30_ = g_object_ref_sink ((GtkSpinButton*) gtk_spin_button_new_with_range ((double) 0, (double) 10, 0.25)), _g_object_unref0 (self->priv->delay), _tmp30_);
#line 134 "ease-inspector-transition-pane.vala"
	gtk_spin_button_set_digits (self->priv->delay, (guint) 2);
#line 135 "ease-inspector-transition-pane.vala"
	align = (_tmp31_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, 0.5f, (float) 1, (float) 1)), _g_object_unref0 (align), _tmp31_);
#line 136 "ease-inspector-transition-pane.vala"
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) self->priv->delay);
#line 137 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, TRUE, TRUE, (guint) 0);
#line 138 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, FALSE, FALSE, (guint) 5);
#line 139 "ease-inspector-transition-pane.vala"
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) hbox, FALSE, FALSE, (guint) 5);
#line 142 "ease-inspector-transition-pane.vala"
	g_signal_connect_object (self->effect, "changed", (GCallback) __lambda35__gtk_combo_box_changed, self, 0);
#line 215 "ease-inspector-transition-pane.vala"
	g_signal_connect_object (self->variant, "changed", (GCallback) __lambda36__gtk_combo_box_changed, self, 0);
#line 231 "ease-inspector-transition-pane.vala"
	g_signal_connect_object (self->priv->start_transition, "changed", (GCallback) __lambda37__gtk_combo_box_changed, self, 0);
#line 250 "ease-inspector-transition-pane.vala"
	g_signal_connect_object (self->priv->transition_time, "value-changed", (GCallback) __lambda38__gtk_spin_button_value_changed, self, 0);
#line 256 "ease-inspector-transition-pane.vala"
	g_signal_connect_object (self->priv->delay, "value-changed", (GCallback) __lambda39__gtk_spin_button_value_changed, self, 0);
#line 263 "ease-inspector-transition-pane.vala"
	g_signal_connect_object (gtk_clutter_embed_get_stage (self->priv->preview), "allocation-changed", (GCallback) __lambda40__clutter_actor_allocation_changed, self, 0);
#line 269 "ease-inspector-transition-pane.vala"
	g_signal_connect_object ((GtkWidget*) self->priv->preview_align, "size-allocate", (GCallback) __lambda41__gtk_widget_size_allocate, self, 0);
#line 669 "ease-inspector-transition-pane.c"
	_g_object_unref0 (render);
	_g_object_unref0 (align);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	_g_object_unref0 (frame);
	return self;
}


#line 51 "ease-inspector-transition-pane.vala"
EaseInspectorTransitionPane* ease_inspector_transition_pane_new (EaseDocument* d) {
#line 51 "ease-inspector-transition-pane.vala"
	return ease_inspector_transition_pane_construct (EASE_TYPE_INSPECTOR_TRANSITION_PANE, d);
#line 683 "ease-inspector-transition-pane.c"
}


#line 284 "ease-inspector-transition-pane.vala"
static void _lambda42_ (EaseInspectorTransitionPane* self) {
#line 285 "ease-inspector-transition-pane.vala"
	ease_inspector_transition_pane_animate_preview_start (self);
#line 691 "ease-inspector-transition-pane.c"
}


#line 284 "ease-inspector-transition-pane.vala"
static void __lambda42__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 697 "ease-inspector-transition-pane.c"
	_lambda42_ (self);
}


#line 277 "ease-inspector-transition-pane.vala"
static void ease_inspector_transition_pane_animate_preview (EaseInspectorTransitionPane* self) {
#line 704 "ease-inspector-transition-pane.c"
	ClutterTimeline* _tmp0_;
#line 277 "ease-inspector-transition-pane.vala"
	g_return_if_fail (self != NULL);
#line 279 "ease-inspector-transition-pane.vala"
	ease_slide_actor_reset (self->priv->current_slide, self->priv->preview_group);
#line 280 "ease-inspector-transition-pane.vala"
	ease_slide_actor_reset (self->priv->new_slide, self->priv->preview_group);
#line 281 "ease-inspector-transition-pane.vala"
	clutter_actor_set_opacity ((ClutterActor*) self->priv->new_slide, (guint) 0);
#line 283 "ease-inspector-transition-pane.vala"
	self->priv->preview_alarm = (_tmp0_ = clutter_timeline_new (EASE_INSPECTOR_TRANSITION_PANE_PREVIEW_DELAY), _g_object_unref0 (self->priv->preview_alarm), _tmp0_);
#line 284 "ease-inspector-transition-pane.vala"
	g_signal_connect_object (self->priv->preview_alarm, "completed", (GCallback) __lambda42__clutter_timeline_completed, self, 0);
#line 287 "ease-inspector-transition-pane.vala"
	clutter_timeline_start (self->priv->preview_alarm);
#line 720 "ease-inspector-transition-pane.c"
}


#line 303 "ease-inspector-transition-pane.vala"
static void _lambda43_ (EaseInspectorTransitionPane* self) {
#line 304 "ease-inspector-transition-pane.vala"
	ease_inspector_transition_pane_animate_preview_delay (self);
#line 728 "ease-inspector-transition-pane.c"
}


#line 303 "ease-inspector-transition-pane.vala"
static void __lambda43__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 734 "ease-inspector-transition-pane.c"
	_lambda43_ (self);
}


#line 290 "ease-inspector-transition-pane.vala"
static void ease_inspector_transition_pane_animate_preview_start (EaseInspectorTransitionPane* self) {
#line 741 "ease-inspector-transition-pane.c"
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_;
#line 290 "ease-inspector-transition-pane.vala"
	g_return_if_fail (self != NULL);
#line 292 "ease-inspector-transition-pane.vala"
	if (ease_slide_get_transition_msecs (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)) == 0) {
#line 292 "ease-inspector-transition-pane.vala"
		_tmp0_ = TRUE;
#line 750 "ease-inspector-transition-pane.c"
	} else {
#line 292 "ease-inspector-transition-pane.vala"
		_tmp0_ = ease_slide_get_transition (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)) == EASE_TRANSITION_NONE;
#line 754 "ease-inspector-transition-pane.c"
	}
#line 292 "ease-inspector-transition-pane.vala"
	if (_tmp0_) {
#line 294 "ease-inspector-transition-pane.vala"
		ease_inspector_transition_pane_animate_preview (self);
#line 295 "ease-inspector-transition-pane.vala"
		return;
#line 762 "ease-inspector-transition-pane.c"
	}
#line 298 "ease-inspector-transition-pane.vala"
	clutter_actor_set_opacity ((ClutterActor*) self->priv->new_slide, (guint) 255);
#line 300 "ease-inspector-transition-pane.vala"
	ease_slide_actor_transition (self->priv->current_slide, self->priv->new_slide, self->priv->preview_group);
#line 302 "ease-inspector-transition-pane.vala"
	self->priv->preview_alarm = (_tmp1_ = clutter_timeline_new (ease_slide_get_transition_msecs (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))), _g_object_unref0 (self->priv->preview_alarm), _tmp1_);
#line 303 "ease-inspector-transition-pane.vala"
	g_signal_connect_object (self->priv->preview_alarm, "completed", (GCallback) __lambda43__clutter_timeline_completed, self, 0);
#line 306 "ease-inspector-transition-pane.vala"
	clutter_timeline_start (self->priv->preview_alarm);
#line 774 "ease-inspector-transition-pane.c"
}


#line 312 "ease-inspector-transition-pane.vala"
static void _lambda44_ (EaseInspectorTransitionPane* self) {
#line 313 "ease-inspector-transition-pane.vala"
	ease_inspector_transition_pane_animate_preview (self);
#line 782 "ease-inspector-transition-pane.c"
}


#line 312 "ease-inspector-transition-pane.vala"
static void __lambda44__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 788 "ease-inspector-transition-pane.c"
	_lambda44_ (self);
}


#line 309 "ease-inspector-transition-pane.vala"
static void ease_inspector_transition_pane_animate_preview_delay (EaseInspectorTransitionPane* self) {
#line 795 "ease-inspector-transition-pane.c"
	ClutterTimeline* _tmp0_;
#line 309 "ease-inspector-transition-pane.vala"
	g_return_if_fail (self != NULL);
#line 311 "ease-inspector-transition-pane.vala"
	self->priv->preview_alarm = (_tmp0_ = clutter_timeline_new (EASE_INSPECTOR_TRANSITION_PANE_PREVIEW_DELAY), _g_object_unref0 (self->priv->preview_alarm), _tmp0_);
#line 312 "ease-inspector-transition-pane.vala"
	g_signal_connect_object (self->priv->preview_alarm, "completed", (GCallback) __lambda44__clutter_timeline_completed, self, 0);
#line 315 "ease-inspector-transition-pane.vala"
	clutter_timeline_start (self->priv->preview_alarm);
#line 805 "ease-inspector-transition-pane.c"
}


#line 318 "ease-inspector-transition-pane.vala"
static void ease_inspector_transition_pane_on_slide_notify (EaseInspectorTransitionPane* self, GObject* obj, GParamSpec* spec) {
#line 811 "ease-inspector-transition-pane.c"
	gboolean already_silenced;
	GtkTreeIter itr = {0};
	const char* _tmp3_;
	GQuark _tmp4_;
	static GQuark _tmp4__label0 = 0;
	static GQuark _tmp4__label1 = 0;
	static GQuark _tmp4__label2 = 0;
	static GQuark _tmp4__label3 = 0;
	static GQuark _tmp4__label4 = 0;
#line 318 "ease-inspector-transition-pane.vala"
	g_return_if_fail (self != NULL);
#line 318 "ease-inspector-transition-pane.vala"
	g_return_if_fail (obj != NULL);
#line 318 "ease-inspector-transition-pane.vala"
	g_return_if_fail (spec != NULL);
#line 320 "ease-inspector-transition-pane.vala"
	already_silenced = self->priv->silence_undo;
#line 321 "ease-inspector-transition-pane.vala"
	self->priv->silence_undo = TRUE;
#line 831 "ease-inspector-transition-pane.c"
	_tmp3_ = spec->name;
	_tmp4_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp4_ == ((0 != _tmp4__label0) ? _tmp4__label0 : (_tmp4__label0 = g_quark_from_static_string ("transition"))))
	switch (0) {
		default:
		{
#line 326 "ease-inspector-transition-pane.vala"
			if (gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->effect), &itr)) {
#line 840 "ease-inspector-transition-pane.c"
				gboolean set;
				EaseTransition t = 0;
#line 328 "ease-inspector-transition-pane.vala"
				set = FALSE;
#line 845 "ease-inspector-transition-pane.c"
				{
					gboolean _tmp0_;
#line 330 "ease-inspector-transition-pane.vala"
					_tmp0_ = TRUE;
#line 330 "ease-inspector-transition-pane.vala"
					while (TRUE) {
#line 330 "ease-inspector-transition-pane.vala"
						if (!_tmp0_) {
#line 340 "ease-inspector-transition-pane.vala"
							if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (self->effect), &itr)) {
#line 340 "ease-inspector-transition-pane.vala"
								break;
#line 858 "ease-inspector-transition-pane.c"
							}
						}
#line 330 "ease-inspector-transition-pane.vala"
						_tmp0_ = FALSE;
#line 332 "ease-inspector-transition-pane.vala"
						gtk_tree_model_get (gtk_combo_box_get_model (self->effect), &itr, 1, &t, -1);
#line 333 "ease-inspector-transition-pane.vala"
						if (t == ease_slide_get_transition (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))) {
#line 335 "ease-inspector-transition-pane.vala"
							gtk_combo_box_set_active_iter (self->effect, &itr);
#line 336 "ease-inspector-transition-pane.vala"
							set = TRUE;
#line 337 "ease-inspector-transition-pane.vala"
							break;
#line 873 "ease-inspector-transition-pane.c"
						}
					}
				}
#line 343 "ease-inspector-transition-pane.vala"
				if (!set) {
#line 345 "ease-inspector-transition-pane.vala"
					gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->effect), &itr);
#line 346 "ease-inspector-transition-pane.vala"
					gtk_combo_box_set_active_iter (self->effect, &itr);
#line 883 "ease-inspector-transition-pane.c"
				}
			}
#line 349 "ease-inspector-transition-pane.vala"
			break;
#line 888 "ease-inspector-transition-pane.c"
		}
	} else if (_tmp4_ == ((0 != _tmp4__label1) ? _tmp4__label1 : (_tmp4__label1 = g_quark_from_static_string ("variant"))))
	switch (0) {
		default:
		{
#line 351 "ease-inspector-transition-pane.vala"
			if (gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->variant), &itr)) {
#line 896 "ease-inspector-transition-pane.c"
				EaseTransitionVariant v = 0;
				{
					gboolean _tmp1_;
#line 354 "ease-inspector-transition-pane.vala"
					_tmp1_ = TRUE;
#line 354 "ease-inspector-transition-pane.vala"
					while (TRUE) {
#line 354 "ease-inspector-transition-pane.vala"
						if (!_tmp1_) {
#line 364 "ease-inspector-transition-pane.vala"
							if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (self->variant), &itr)) {
#line 364 "ease-inspector-transition-pane.vala"
								break;
#line 910 "ease-inspector-transition-pane.c"
							}
						}
#line 354 "ease-inspector-transition-pane.vala"
						_tmp1_ = FALSE;
#line 356 "ease-inspector-transition-pane.vala"
						gtk_tree_model_get (gtk_combo_box_get_model (self->variant), &itr, 1, &v, -1);
#line 357 "ease-inspector-transition-pane.vala"
						if (v == ease_slide_get_variant (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))) {
#line 359 "ease-inspector-transition-pane.vala"
							gtk_combo_box_set_active_iter (self->variant, &itr);
#line 360 "ease-inspector-transition-pane.vala"
							self->priv->silence_undo = already_silenced;
#line 361 "ease-inspector-transition-pane.vala"
							return;
#line 925 "ease-inspector-transition-pane.c"
						}
					}
				}
#line 367 "ease-inspector-transition-pane.vala"
				gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->variant), &itr);
#line 368 "ease-inspector-transition-pane.vala"
				gtk_combo_box_set_active_iter (self->variant, &itr);
#line 933 "ease-inspector-transition-pane.c"
			}
#line 370 "ease-inspector-transition-pane.vala"
			break;
#line 937 "ease-inspector-transition-pane.c"
		}
	} else if (_tmp4_ == ((0 != _tmp4__label2) ? _tmp4__label2 : (_tmp4__label2 = g_quark_from_static_string ("transition-time"))))
	switch (0) {
		default:
		{
#line 372 "ease-inspector-transition-pane.vala"
			gtk_spin_button_set_value (self->priv->transition_time, ease_slide_get_transition_time (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)));
#line 373 "ease-inspector-transition-pane.vala"
			break;
#line 947 "ease-inspector-transition-pane.c"
		}
	} else if (_tmp4_ == ((0 != _tmp4__label3) ? _tmp4__label3 : (_tmp4__label3 = g_quark_from_static_string ("advance-delay"))))
	switch (0) {
		default:
		{
#line 375 "ease-inspector-transition-pane.vala"
			gtk_spin_button_set_value (self->priv->delay, ease_slide_get_advance_delay (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)));
#line 376 "ease-inspector-transition-pane.vala"
			break;
#line 957 "ease-inspector-transition-pane.c"
		}
	} else if (_tmp4_ == ((0 != _tmp4__label4) ? _tmp4__label4 : (_tmp4__label4 = g_quark_from_static_string ("start-transition"))))
	switch (0) {
		default:
		{
			gint _tmp2_ = 0;
#line 378 "ease-inspector-transition-pane.vala"
			if (ease_slide_get_automatically_advance (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))) {
#line 379 "ease-inspector-transition-pane.vala"
				_tmp2_ = 1;
#line 968 "ease-inspector-transition-pane.c"
			} else {
#line 379 "ease-inspector-transition-pane.vala"
				_tmp2_ = 0;
#line 972 "ease-inspector-transition-pane.c"
			}
#line 378 "ease-inspector-transition-pane.vala"
			gtk_combo_box_set_active (self->priv->start_transition, _tmp2_);
#line 380 "ease-inspector-transition-pane.vala"
			gtk_spin_button_set_value (self->priv->delay, ease_slide_get_advance_delay (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)));
#line 381 "ease-inspector-transition-pane.vala"
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->delay, ease_slide_get_automatically_advance (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)));
#line 382 "ease-inspector-transition-pane.vala"
			break;
#line 982 "ease-inspector-transition-pane.c"
		}
	}
#line 384 "ease-inspector-transition-pane.vala"
	self->priv->silence_undo = already_silenced;
#line 987 "ease-inspector-transition-pane.c"
}


#line 318 "ease-inspector-transition-pane.vala"
static void _ease_inspector_transition_pane_on_slide_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 993 "ease-inspector-transition-pane.c"
	ease_inspector_transition_pane_on_slide_notify (self, _sender, pspec);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 387 "ease-inspector-transition-pane.vala"
static void ease_inspector_transition_pane_real_slide_updated (EaseInspectorPane* base) {
#line 1005 "ease-inspector-transition-pane.c"
	EaseInspectorTransitionPane * self;
	EaseSlide* _tmp10_;
	GtkTreeIter itr = {0};
	gint _tmp13_ = 0;
	GtkAllocation alloc = {0};
	EaseSlideActor* _tmp14_;
	EaseSlideActor* _tmp15_;
	EaseSlideActor* _tmp21_;
	self = (EaseInspectorTransitionPane*) base;
#line 389 "ease-inspector-transition-pane.vala"
	self->priv->silence_undo = TRUE;
#line 392 "ease-inspector-transition-pane.vala"
	if (self->priv->old_slide != NULL) {
#line 1019 "ease-inspector-transition-pane.c"
		guint _tmp0_;
		GQuark _tmp1_;
		guint _tmp2_;
		GQuark _tmp3_;
		guint _tmp4_;
		GQuark _tmp5_;
		guint _tmp6_;
		GQuark _tmp7_;
		guint _tmp8_;
		GQuark _tmp9_;
#line 394 "ease-inspector-transition-pane.vala"
		g_signal_parse_name ("notify::transition-time", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
#line 394 "ease-inspector-transition-pane.vala"
		g_signal_handlers_disconnect_matched ((GObject*) self->priv->old_slide, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self);
#line 395 "ease-inspector-transition-pane.vala"
		g_signal_parse_name ("notify::variant", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
#line 395 "ease-inspector-transition-pane.vala"
		g_signal_handlers_disconnect_matched ((GObject*) self->priv->old_slide, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self);
#line 396 "ease-inspector-transition-pane.vala"
		g_signal_parse_name ("notify::transition", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
#line 396 "ease-inspector-transition-pane.vala"
		g_signal_handlers_disconnect_matched ((GObject*) self->priv->old_slide, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self);
#line 397 "ease-inspector-transition-pane.vala"
		g_signal_parse_name ("notify::advance-delay", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
#line 397 "ease-inspector-transition-pane.vala"
		g_signal_handlers_disconnect_matched ((GObject*) self->priv->old_slide, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self);
#line 398 "ease-inspector-transition-pane.vala"
		g_signal_parse_name ("notify::start-transition", G_TYPE_OBJECT, &_tmp8_, &_tmp9_, TRUE);
#line 398 "ease-inspector-transition-pane.vala"
		g_signal_handlers_disconnect_matched ((GObject*) self->priv->old_slide, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, _tmp9_, NULL, (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self);
#line 1050 "ease-inspector-transition-pane.c"
	}
#line 400 "ease-inspector-transition-pane.vala"
	self->priv->old_slide = (_tmp10_ = _g_object_ref0 (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)), _g_object_unref0 (self->priv->old_slide), _tmp10_);
#line 403 "ease-inspector-transition-pane.vala"
	g_signal_connect_object ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "notify::transition-time", (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self, 0);
#line 404 "ease-inspector-transition-pane.vala"
	g_signal_connect_object ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "notify::variant", (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self, 0);
#line 405 "ease-inspector-transition-pane.vala"
	g_signal_connect_object ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "notify::transition", (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self, 0);
#line 406 "ease-inspector-transition-pane.vala"
	g_signal_connect_object ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "notify::advance-delay", (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self, 0);
#line 407 "ease-inspector-transition-pane.vala"
	g_signal_connect_object ((GObject*) ease_inspector_pane_get_slide ((EaseInspectorPane*) self), "notify::start-transition", (GCallback) _ease_inspector_transition_pane_on_slide_notify_g_object_notify, self, 0);
#line 410 "ease-inspector-transition-pane.vala"
	gtk_spin_button_set_value (self->priv->transition_time, ease_slide_get_transition_time (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)));
#line 411 "ease-inspector-transition-pane.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->transition_time, ease_slide_get_transition (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)) != EASE_TRANSITION_NONE);
#line 415 "ease-inspector-transition-pane.vala"
	if (gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->effect), &itr)) {
#line 1070 "ease-inspector-transition-pane.c"
		gboolean set;
		EaseTransition t = 0;
#line 417 "ease-inspector-transition-pane.vala"
		set = FALSE;
#line 1075 "ease-inspector-transition-pane.c"
		{
			gboolean _tmp11_;
#line 419 "ease-inspector-transition-pane.vala"
			_tmp11_ = TRUE;
#line 419 "ease-inspector-transition-pane.vala"
			while (TRUE) {
#line 419 "ease-inspector-transition-pane.vala"
				if (!_tmp11_) {
#line 429 "ease-inspector-transition-pane.vala"
					if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (self->effect), &itr)) {
#line 429 "ease-inspector-transition-pane.vala"
						break;
#line 1088 "ease-inspector-transition-pane.c"
					}
				}
#line 419 "ease-inspector-transition-pane.vala"
				_tmp11_ = FALSE;
#line 421 "ease-inspector-transition-pane.vala"
				gtk_tree_model_get (gtk_combo_box_get_model (self->effect), &itr, 1, &t, -1);
#line 422 "ease-inspector-transition-pane.vala"
				if (t == ease_slide_get_transition (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))) {
#line 424 "ease-inspector-transition-pane.vala"
					gtk_combo_box_set_active_iter (self->effect, &itr);
#line 425 "ease-inspector-transition-pane.vala"
					set = TRUE;
#line 426 "ease-inspector-transition-pane.vala"
					break;
#line 1103 "ease-inspector-transition-pane.c"
				}
			}
		}
#line 431 "ease-inspector-transition-pane.vala"
		if (gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->variant), &itr)) {
#line 1109 "ease-inspector-transition-pane.c"
			EaseTransitionVariant v = 0;
			{
				gboolean _tmp12_;
#line 434 "ease-inspector-transition-pane.vala"
				_tmp12_ = TRUE;
#line 434 "ease-inspector-transition-pane.vala"
				while (TRUE) {
#line 434 "ease-inspector-transition-pane.vala"
					if (!_tmp12_) {
#line 443 "ease-inspector-transition-pane.vala"
						if (!gtk_tree_model_iter_next (gtk_combo_box_get_model (self->variant), &itr)) {
#line 443 "ease-inspector-transition-pane.vala"
							break;
#line 1123 "ease-inspector-transition-pane.c"
						}
					}
#line 434 "ease-inspector-transition-pane.vala"
					_tmp12_ = FALSE;
#line 436 "ease-inspector-transition-pane.vala"
					gtk_tree_model_get (gtk_combo_box_get_model (self->variant), &itr, 1, &v, -1);
#line 437 "ease-inspector-transition-pane.vala"
					if (v == ease_slide_get_variant (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))) {
#line 439 "ease-inspector-transition-pane.vala"
						gtk_combo_box_set_active_iter (self->variant, &itr);
#line 440 "ease-inspector-transition-pane.vala"
						break;
#line 1136 "ease-inspector-transition-pane.c"
					}
				}
			}
		}
#line 447 "ease-inspector-transition-pane.vala"
		if (!set) {
#line 449 "ease-inspector-transition-pane.vala"
			gtk_tree_model_get_iter_first (gtk_combo_box_get_model (self->effect), &itr);
#line 450 "ease-inspector-transition-pane.vala"
			gtk_combo_box_set_active_iter (self->effect, &itr);
#line 1147 "ease-inspector-transition-pane.c"
		}
	}
#line 455 "ease-inspector-transition-pane.vala"
	if (ease_slide_get_automatically_advance (ease_inspector_pane_get_slide ((EaseInspectorPane*) self))) {
#line 455 "ease-inspector-transition-pane.vala"
		_tmp13_ = 1;
#line 1154 "ease-inspector-transition-pane.c"
	} else {
#line 455 "ease-inspector-transition-pane.vala"
		_tmp13_ = 0;
#line 1158 "ease-inspector-transition-pane.c"
	}
#line 455 "ease-inspector-transition-pane.vala"
	gtk_combo_box_set_active (self->priv->start_transition, _tmp13_);
#line 456 "ease-inspector-transition-pane.vala"
	gtk_spin_button_set_value (self->priv->delay, ease_slide_get_advance_delay (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)));
#line 457 "ease-inspector-transition-pane.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->delay, ease_slide_get_automatically_advance (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)));
#line 1166 "ease-inspector-transition-pane.c"
	memset (&alloc, 0, sizeof (GtkAllocation));
#line 461 "ease-inspector-transition-pane.vala"
	gtk_widget_get_allocation ((GtkWidget*) self->priv->preview_align, &alloc);
#line 462 "ease-inspector-transition-pane.vala"
	g_object_set ((GtkWidget*) self->priv->preview_align, "height-request", (gint) (alloc.width / ease_document_get_aspect (ease_inspector_pane_get_document ((EaseInspectorPane*) self))), NULL);
#line 465 "ease-inspector-transition-pane.vala"
	clutter_group_remove_all (self->priv->preview_group);
#line 468 "ease-inspector-transition-pane.vala"
	self->priv->current_slide = (_tmp14_ = g_object_ref_sink (ease_slide_actor_new_from_slide (ease_inspector_pane_get_document ((EaseInspectorPane*) self), ease_inspector_pane_get_slide ((EaseInspectorPane*) self), TRUE, EASE_ACTOR_CONTEXT_INSPECTOR)), _g_object_unref0 (self->priv->current_slide), _tmp14_);
#line 1176 "ease-inspector-transition-pane.c"
	_tmp15_ = NULL;
#line 471 "ease-inspector-transition-pane.vala"
	if (ease_document_has_next_slide (ease_inspector_pane_get_document ((EaseInspectorPane*) self), ease_inspector_pane_get_slide ((EaseInspectorPane*) self))) {
#line 1180 "ease-inspector-transition-pane.c"
		EaseSlide* _tmp16_;
		EaseSlideActor* _tmp17_;
#line 472 "ease-inspector-transition-pane.vala"
		_tmp15_ = (_tmp17_ = g_object_ref_sink (ease_slide_actor_new_from_slide (ease_inspector_pane_get_document ((EaseInspectorPane*) self), _tmp16_ = ease_slide_get_next (ease_inspector_pane_get_slide ((EaseInspectorPane*) self)), TRUE, EASE_ACTOR_CONTEXT_INSPECTOR)), _g_object_unref0 (_tmp15_), _tmp17_);
#line 1185 "ease-inspector-transition-pane.c"
		_g_object_unref0 (_tmp16_);
	} else {
		ClutterColor _tmp18_ = {0};
		ClutterColor _tmp19_;
		EaseSlideActor* _tmp20_;
#line 474 "ease-inspector-transition-pane.vala"
		_tmp15_ = (_tmp20_ = g_object_ref_sink (ease_slide_actor_new_blank (ease_inspector_pane_get_document ((EaseInspectorPane*) self), (_tmp19_ = (_tmp18_.red = (guchar) 0, _tmp18_.green = (guchar) 0, _tmp18_.blue = (guchar) 0, _tmp18_.alpha = (guchar) 255, _tmp18_), &_tmp19_))), _g_object_unref0 (_tmp15_), _tmp20_);
#line 1193 "ease-inspector-transition-pane.c"
	}
#line 471 "ease-inspector-transition-pane.vala"
	self->priv->new_slide = (_tmp21_ = _g_object_ref0 (_tmp15_), _g_object_unref0 (self->priv->new_slide), _tmp21_);
#line 476 "ease-inspector-transition-pane.vala"
	clutter_container_add_actor ((ClutterContainer*) self->priv->preview_group, (ClutterActor*) self->priv->current_slide);
#line 477 "ease-inspector-transition-pane.vala"
	clutter_container_add_actor ((ClutterContainer*) self->priv->preview_group, (ClutterActor*) self->priv->new_slide);
#line 480 "ease-inspector-transition-pane.vala"
	if (self->priv->preview_alarm != NULL) {
#line 482 "ease-inspector-transition-pane.vala"
		clutter_timeline_stop (self->priv->preview_alarm);
#line 1205 "ease-inspector-transition-pane.c"
	}
#line 484 "ease-inspector-transition-pane.vala"
	ease_inspector_transition_pane_animate_preview (self);
#line 486 "ease-inspector-transition-pane.vala"
	self->priv->silence_undo = FALSE;
#line 1211 "ease-inspector-transition-pane.c"
	_g_object_unref0 (_tmp15_);
}


static void ease_inspector_transition_pane_class_init (EaseInspectorTransitionPaneClass * klass) {
	ease_inspector_transition_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseInspectorTransitionPanePrivate));
	EASE_INSPECTOR_PANE_CLASS (klass)->slide_updated = ease_inspector_transition_pane_real_slide_updated;
	G_OBJECT_CLASS (klass)->finalize = ease_inspector_transition_pane_finalize;
}


static void ease_inspector_transition_pane_instance_init (EaseInspectorTransitionPane * self) {
	self->priv = EASE_INSPECTOR_TRANSITION_PANE_GET_PRIVATE (self);
}


static void ease_inspector_transition_pane_finalize (GObject* obj) {
	EaseInspectorTransitionPane * self;
	self = EASE_INSPECTOR_TRANSITION_PANE (obj);
	_g_object_unref0 (self->effect);
	_g_object_unref0 (self->priv->transition_time);
	_g_object_unref0 (self->variant);
	_g_object_unref0 (self->priv->variant_align);
	_g_object_unref0 (self->priv->start_transition);
	_g_object_unref0 (self->priv->delay);
	_g_object_unref0 (self->priv->preview);
	_g_object_unref0 (self->priv->preview_group);
	_g_object_unref0 (self->priv->preview_align);
	_g_object_unref0 (self->priv->current_slide);
	_g_object_unref0 (self->priv->new_slide);
	_g_object_unref0 (self->priv->preview_alarm);
	_g_object_unref0 (self->priv->old_slide);
	G_OBJECT_CLASS (ease_inspector_transition_pane_parent_class)->finalize (obj);
}


/**
 * The inspector pane for changing transitions
 */
GType ease_inspector_transition_pane_get_type (void) {
	static volatile gsize ease_inspector_transition_pane_type_id__volatile = 0;
	if (g_once_init_enter (&ease_inspector_transition_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseInspectorTransitionPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_inspector_transition_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseInspectorTransitionPane), 0, (GInstanceInitFunc) ease_inspector_transition_pane_instance_init, NULL };
		GType ease_inspector_transition_pane_type_id;
		ease_inspector_transition_pane_type_id = g_type_register_static (EASE_TYPE_INSPECTOR_PANE, "EaseInspectorTransitionPane", &g_define_type_info, 0);
		g_once_init_leave (&ease_inspector_transition_pane_type_id__volatile, ease_inspector_transition_pane_type_id);
	}
	return ease_inspector_transition_pane_type_id__volatile;
}




