/* ease-scrollable-embed.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-scrollable-embed.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define EASE_TYPE_SCROLLABLE_EMBED (ease_scrollable_embed_get_type ())
#define EASE_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbed))
#define EASE_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))
#define EASE_IS_SCROLLABLE_EMBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_IS_SCROLLABLE_EMBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SCROLLABLE_EMBED))
#define EASE_SCROLLABLE_EMBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedClass))

typedef struct _EaseScrollableEmbed EaseScrollableEmbed;
typedef struct _EaseScrollableEmbedClass EaseScrollableEmbedClass;
typedef struct _EaseScrollableEmbedPrivate EaseScrollableEmbedPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _EaseScrollableEmbed {
	GtkHBox parent_instance;
	EaseScrollableEmbedPrivate * priv;
};

struct _EaseScrollableEmbedClass {
	GtkHBoxClass parent_class;
};

struct _EaseScrollableEmbedPrivate {
	GtkClutterEmbed* embed;
	GtkClutterViewport* viewport;
	ClutterStage* stage;
	ClutterGroup* _contents;
	GtkHScrollbar* h_scrollbar;
	GtkVScrollbar* v_scrollbar;
	GtkAlignment* h_padder;
	GtkAlignment* v_padder;
	GtkAdjustment* h_adjust;
	GtkAdjustment* v_adjust;
	GtkAdjustment* z_adjust;
	gboolean _has_horizontal;
};


static gpointer ease_scrollable_embed_parent_class = NULL;

GType ease_scrollable_embed_get_type (void) G_GNUC_CONST;
#define EASE_SCROLLABLE_EMBED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_SCROLLABLE_EMBED, EaseScrollableEmbedPrivate))
enum  {
	EASE_SCROLLABLE_EMBED_DUMMY_PROPERTY,
	EASE_SCROLLABLE_EMBED_CONTENTS,
	EASE_SCROLLABLE_EMBED_HAS_HORIZONTAL,
	EASE_SCROLLABLE_EMBED_WIDTH,
	EASE_SCROLLABLE_EMBED_HEIGHT
};
#define EASE_SCROLLABLE_EMBED_FRAME_PADDING 2
EaseScrollableEmbed* ease_scrollable_embed_new (gboolean horizontal, gboolean has_frame);
EaseScrollableEmbed* ease_scrollable_embed_construct (GType object_type, gboolean horizontal, gboolean has_frame);
static void ease_scrollable_embed_set_has_horizontal (EaseScrollableEmbed* self, gboolean value);
static void ease_scrollable_embed_set_contents (EaseScrollableEmbed* self, ClutterGroup* value);
ClutterGroup* ease_scrollable_embed_get_contents (EaseScrollableEmbed* self);
gboolean ease_scrollable_embed_get_has_horizontal (EaseScrollableEmbed* self);
static void _lambda0_ (GtkWidget* sender, GdkRectangle* rect, EaseScrollableEmbed* self);
static void __lambda0__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void _lambda1_ (EaseScrollableEmbed* self);
static void __lambda1__gtk_widget_realize (GtkWidget* _sender, gpointer self);
static gboolean _lambda2_ (GdkEventButton* event, EaseScrollableEmbed* self);
static gboolean __lambda2__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _lambda3_ (GdkEventScroll* event, EaseScrollableEmbed* self);
static gboolean __lambda3__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void ease_scrollable_embed_embed_allocate (EaseScrollableEmbed* self, GtkWidget* sender, GdkRectangle* rect);
static void _ease_scrollable_embed_embed_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
ClutterStage* ease_scrollable_embed_get_stage (EaseScrollableEmbed* self);
static void ease_scrollable_embed_real_grab_focus (GtkWidget* base);
float ease_scrollable_embed_get_width (EaseScrollableEmbed* self);
float ease_scrollable_embed_get_height (EaseScrollableEmbed* self);
static void ease_scrollable_embed_finalize (GObject* obj);
static void ease_scrollable_embed_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_scrollable_embed_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * Instantiate a ScollableEmbed with an optional vertical sidebar.
 * 
 * A ScollableEmbed contains a {@link GtkClutter.Viewport} within a
 * {@link GtkClutter.Embed}.
 *
 * @param horizontal If true, the ScrollableEmbed has a horizontal
 * scrollbar in addition to the vertical scrollbar.
 * @param has_frame If the EditorEmbed should have a frame around its stage.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 128 "ease-scrollable-embed.vala"
static void _lambda0_ (GtkWidget* sender, GdkRectangle* rect, EaseScrollableEmbed* self) {
#line 128 "ease-scrollable-embed.vala"
	g_return_if_fail (sender != NULL);
#line 129 "ease-scrollable-embed.vala"
	g_object_set ((GtkWidget*) self->priv->h_padder, "width-request", EASE_SCROLLABLE_EMBED_FRAME_PADDING, NULL);
#line 130 "ease-scrollable-embed.vala"
	g_object_set ((GtkWidget*) self->priv->v_padder, "height-request", (*rect).height + EASE_SCROLLABLE_EMBED_FRAME_PADDING, NULL);
#line 130 "ease-scrollable-embed.c"
}


#line 128 "ease-scrollable-embed.vala"
static void __lambda0__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
#line 136 "ease-scrollable-embed.c"
	_lambda0_ (_sender, allocation, self);
}


#line 143 "ease-scrollable-embed.vala"
static void _lambda1_ (EaseScrollableEmbed* self) {
#line 144 "ease-scrollable-embed.vala"
	gdk_window_set_events (gtk_widget_get_window ((GtkWidget*) self), GDK_ALL_EVENTS_MASK);
#line 145 "ease-scrollable-embed.c"
}


#line 143 "ease-scrollable-embed.vala"
static void __lambda1__gtk_widget_realize (GtkWidget* _sender, gpointer self) {
#line 151 "ease-scrollable-embed.c"
	_lambda1_ (self);
}


#line 147 "ease-scrollable-embed.vala"
static gboolean _lambda2_ (GdkEventButton* event, EaseScrollableEmbed* self) {
#line 158 "ease-scrollable-embed.c"
	gboolean result = FALSE;
	result = FALSE;
#line 148 "ease-scrollable-embed.vala"
	return result;
#line 163 "ease-scrollable-embed.c"
}


#line 147 "ease-scrollable-embed.vala"
static gboolean __lambda2__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
#line 169 "ease-scrollable-embed.c"
	gboolean result;
	result = _lambda2_ (event, self);
	return result;
}


#line 151 "ease-scrollable-embed.vala"
static gboolean _lambda3_ (GdkEventScroll* event, EaseScrollableEmbed* self) {
#line 178 "ease-scrollable-embed.c"
	gboolean result = FALSE;
#line 152 "ease-scrollable-embed.vala"
	switch ((*event).direction) {
#line 182 "ease-scrollable-embed.c"
		case GDK_SCROLL_UP:
		{
#line 155 "ease-scrollable-embed.vala"
			gtk_adjustment_set_value (self->priv->v_adjust, fmin (gtk_adjustment_get_upper (self->priv->v_adjust), fmax (gtk_adjustment_get_lower (self->priv->v_adjust), gtk_adjustment_get_value (self->priv->v_adjust) - gtk_adjustment_get_step_increment (self->priv->v_adjust))));
#line 159 "ease-scrollable-embed.vala"
			break;
#line 189 "ease-scrollable-embed.c"
		}
		case GDK_SCROLL_DOWN:
		{
#line 161 "ease-scrollable-embed.vala"
			gtk_adjustment_set_value (self->priv->v_adjust, fmin (gtk_adjustment_get_upper (self->priv->v_adjust), fmax (gtk_adjustment_get_lower (self->priv->v_adjust), gtk_adjustment_get_value (self->priv->v_adjust) + gtk_adjustment_get_step_increment (self->priv->v_adjust))));
#line 165 "ease-scrollable-embed.vala"
			break;
#line 197 "ease-scrollable-embed.c"
		}
	}
	result = FALSE;
#line 167 "ease-scrollable-embed.vala"
	return result;
#line 203 "ease-scrollable-embed.c"
}


#line 151 "ease-scrollable-embed.vala"
static gboolean __lambda3__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
#line 209 "ease-scrollable-embed.c"
	gboolean result;
	result = _lambda3_ (event, self);
	return result;
}


#line 186 "ease-scrollable-embed.vala"
static void _ease_scrollable_embed_embed_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
#line 218 "ease-scrollable-embed.c"
	ease_scrollable_embed_embed_allocate (self, _sender, allocation);
}


#line 66 "ease-scrollable-embed.vala"
EaseScrollableEmbed* ease_scrollable_embed_construct (GType object_type, gboolean horizontal, gboolean has_frame) {
#line 225 "ease-scrollable-embed.c"
	EaseScrollableEmbed * self;
	GtkClutterEmbed* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkHScrollbar* _tmp2_;
	GtkAdjustment* _tmp3_;
	GtkVScrollbar* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkClutterViewport* _tmp6_;
	ClutterGroup* _tmp7_;
	ClutterStage* _tmp8_;
	GtkVBox* vbox;
	self = g_object_newv (object_type, 0, NULL);
#line 68 "ease-scrollable-embed.vala"
	ease_scrollable_embed_set_has_horizontal (self, horizontal);
#line 70 "ease-scrollable-embed.vala"
	self->priv->embed = (_tmp0_ = g_object_ref_sink ((GtkClutterEmbed*) gtk_clutter_embed_new ()), _g_object_unref0 (self->priv->embed), _tmp0_);
#line 71 "ease-scrollable-embed.vala"
	self->priv->h_adjust = (_tmp1_ = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new ((double) 0, (double) 0, (double) 1, 0.1, 0.1, 0.1)), _g_object_unref0 (self->priv->h_adjust), _tmp1_);
#line 72 "ease-scrollable-embed.vala"
	self->priv->h_scrollbar = (_tmp2_ = g_object_ref_sink ((GtkHScrollbar*) gtk_hscrollbar_new (self->priv->h_adjust)), _g_object_unref0 (self->priv->h_scrollbar), _tmp2_);
#line 73 "ease-scrollable-embed.vala"
	self->priv->v_adjust = (_tmp3_ = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new ((double) 0, (double) 0, (double) 1, 0.1, 0.1, 0.1)), _g_object_unref0 (self->priv->v_adjust), _tmp3_);
#line 74 "ease-scrollable-embed.vala"
	self->priv->v_scrollbar = (_tmp4_ = g_object_ref_sink ((GtkVScrollbar*) gtk_vscrollbar_new (self->priv->v_adjust)), _g_object_unref0 (self->priv->v_scrollbar), _tmp4_);
#line 75 "ease-scrollable-embed.vala"
	self->priv->z_adjust = (_tmp5_ = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new ((double) 0, (double) 0, (double) 1, 0.1, 0.1, 0.1)), _g_object_unref0 (self->priv->z_adjust), _tmp5_);
#line 77 "ease-scrollable-embed.vala"
	g_debug ("ease-scrollable-embed.vala:77: %f %f", gtk_adjustment_get_value (self->priv->v_adjust), gtk_adjustment_get_upper (self->priv->v_adjust));
#line 80 "ease-scrollable-embed.vala"
	self->priv->viewport = (_tmp6_ = g_object_ref_sink ((GtkClutterViewport*) gtk_clutter_viewport_new (self->priv->h_adjust, self->priv->v_adjust, self->priv->z_adjust)), _g_object_unref0 (self->priv->viewport), _tmp6_);
#line 81 "ease-scrollable-embed.vala"
	ease_scrollable_embed_set_contents (self, _tmp7_ = g_object_ref_sink ((ClutterGroup*) clutter_group_new ()));
#line 258 "ease-scrollable-embed.c"
	_g_object_unref0 (_tmp7_);
#line 83 "ease-scrollable-embed.vala"
	self->priv->stage = (_tmp8_ = _g_object_ref0 (CLUTTER_STAGE (gtk_clutter_embed_get_stage (self->priv->embed))), _g_object_unref0 (self->priv->stage), _tmp8_);
#line 84 "ease-scrollable-embed.vala"
	clutter_container_add_actor ((ClutterContainer*) self->priv->stage, (ClutterActor*) self->priv->viewport);
#line 85 "ease-scrollable-embed.vala"
	g_object_set (self->priv->viewport, "child", (ClutterActor*) self->priv->_contents, NULL);
#line 88 "ease-scrollable-embed.vala"
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
#line 89 "ease-scrollable-embed.vala"
	if (has_frame) {
#line 270 "ease-scrollable-embed.c"
		GtkFrame* frame;
		GtkAlignment* align;
		gint _tmp9_ = 0;
#line 92 "ease-scrollable-embed.vala"
		frame = g_object_ref_sink ((GtkFrame*) gtk_frame_new (NULL));
#line 93 "ease-scrollable-embed.vala"
		gtk_frame_set_shadow_type (frame, GTK_SHADOW_IN);
#line 94 "ease-scrollable-embed.vala"
		gtk_container_add ((GtkContainer*) frame, (GtkWidget*) self->priv->embed);
#line 97 "ease-scrollable-embed.vala"
		align = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 1, (float) 1));
#line 98 "ease-scrollable-embed.vala"
		if (horizontal) {
#line 98 "ease-scrollable-embed.vala"
			_tmp9_ = EASE_SCROLLABLE_EMBED_FRAME_PADDING;
#line 286 "ease-scrollable-embed.c"
		} else {
#line 98 "ease-scrollable-embed.vala"
			_tmp9_ = 0;
#line 290 "ease-scrollable-embed.c"
		}
#line 98 "ease-scrollable-embed.vala"
		gtk_alignment_set_padding (align, (guint) 0, (guint) _tmp9_, (guint) 0, (guint) EASE_SCROLLABLE_EMBED_FRAME_PADDING);
#line 100 "ease-scrollable-embed.vala"
		gtk_container_add ((GtkContainer*) align, (GtkWidget*) frame);
#line 102 "ease-scrollable-embed.vala"
		gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) align, TRUE, TRUE, (guint) 0);
#line 298 "ease-scrollable-embed.c"
		_g_object_unref0 (align);
		_g_object_unref0 (frame);
	} else {
#line 106 "ease-scrollable-embed.vala"
		gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->embed, TRUE, TRUE, (guint) 0);
#line 304 "ease-scrollable-embed.c"
	}
#line 109 "ease-scrollable-embed.vala"
	if (self->priv->_has_horizontal) {
#line 308 "ease-scrollable-embed.c"
		GtkAlignment* _tmp10_;
		GtkHBox* hscroll_box;
		GtkAlignment* _tmp11_;
		GtkVBox* vscroll_box;
#line 112 "ease-scrollable-embed.vala"
		self->priv->h_padder = (_tmp10_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 0, (float) 0)), _g_object_unref0 (self->priv->h_padder), _tmp10_);
#line 114 "ease-scrollable-embed.vala"
		hscroll_box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
#line 115 "ease-scrollable-embed.vala"
		gtk_box_pack_start ((GtkBox*) hscroll_box, (GtkWidget*) self->priv->h_scrollbar, TRUE, TRUE, (guint) 0);
#line 116 "ease-scrollable-embed.vala"
		gtk_box_pack_start ((GtkBox*) hscroll_box, (GtkWidget*) self->priv->h_padder, FALSE, FALSE, (guint) 0);
#line 117 "ease-scrollable-embed.vala"
		gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) hscroll_box, FALSE, FALSE, (guint) 0);
#line 121 "ease-scrollable-embed.vala"
		self->priv->v_padder = (_tmp11_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 0, (float) 0)), _g_object_unref0 (self->priv->v_padder), _tmp11_);
#line 123 "ease-scrollable-embed.vala"
		vscroll_box = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
#line 124 "ease-scrollable-embed.vala"
		gtk_box_pack_start ((GtkBox*) vscroll_box, (GtkWidget*) self->priv->v_scrollbar, TRUE, TRUE, (guint) 0);
#line 125 "ease-scrollable-embed.vala"
		gtk_box_pack_start ((GtkBox*) vscroll_box, (GtkWidget*) self->priv->v_padder, FALSE, FALSE, (guint) 0);
#line 126 "ease-scrollable-embed.vala"
		gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) vscroll_box, FALSE, FALSE, (guint) 0);
#line 128 "ease-scrollable-embed.vala"
		g_signal_connect_object ((GtkWidget*) self->priv->h_scrollbar, "size-allocate", (GCallback) __lambda0__gtk_widget_size_allocate, self, 0);
#line 335 "ease-scrollable-embed.c"
		_g_object_unref0 (vscroll_box);
		_g_object_unref0 (hscroll_box);
	} else {
#line 135 "ease-scrollable-embed.vala"
		gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) self->priv->v_scrollbar, FALSE, FALSE, (guint) 0);
#line 341 "ease-scrollable-embed.c"
	}
#line 138 "ease-scrollable-embed.vala"
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
#line 140 "ease-scrollable-embed.vala"
	clutter_actor_show_all ((ClutterActor*) self->priv->stage);
#line 143 "ease-scrollable-embed.vala"
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) __lambda1__gtk_widget_realize, self, 0);
#line 147 "ease-scrollable-embed.vala"
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) __lambda2__gtk_widget_button_press_event, self, 0);
#line 151 "ease-scrollable-embed.vala"
	g_signal_connect_object ((GtkWidget*) self, "scroll-event", (GCallback) __lambda3__gtk_widget_scroll_event, self, 0);
#line 171 "ease-scrollable-embed.vala"
	g_signal_connect_object ((GtkWidget*) self->priv->embed, "size-allocate", (GCallback) _ease_scrollable_embed_embed_allocate_gtk_widget_size_allocate, self, 0);
#line 355 "ease-scrollable-embed.c"
	_g_object_unref0 (vbox);
	return self;
}


#line 66 "ease-scrollable-embed.vala"
EaseScrollableEmbed* ease_scrollable_embed_new (gboolean horizontal, gboolean has_frame) {
#line 66 "ease-scrollable-embed.vala"
	return ease_scrollable_embed_construct (EASE_TYPE_SCROLLABLE_EMBED, horizontal, has_frame);
#line 365 "ease-scrollable-embed.c"
}


/**
 * Returns the stage of this ScrollableEmbed. Use with caution. Most
 * actors should be placed onto the "contents" ClutterGroup.
 */
#line 178 "ease-scrollable-embed.vala"
ClutterStage* ease_scrollable_embed_get_stage (EaseScrollableEmbed* self) {
#line 375 "ease-scrollable-embed.c"
	ClutterStage* result = NULL;
#line 178 "ease-scrollable-embed.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 379 "ease-scrollable-embed.c"
	result = _g_object_ref0 (CLUTTER_STAGE (gtk_clutter_embed_get_stage (self->priv->embed)));
#line 180 "ease-scrollable-embed.vala"
	return result;
#line 383 "ease-scrollable-embed.c"
}


/**
 * Signal handler for size allocation.
 */
#line 186 "ease-scrollable-embed.vala"
static void ease_scrollable_embed_embed_allocate (EaseScrollableEmbed* self, GtkWidget* sender, GdkRectangle* rect) {
#line 186 "ease-scrollable-embed.vala"
	g_return_if_fail (self != NULL);
#line 186 "ease-scrollable-embed.vala"
	g_return_if_fail (sender != NULL);
#line 189 "ease-scrollable-embed.vala"
	clutter_actor_set_width ((ClutterActor*) self->priv->stage, (float) ((GtkWidget*) self)->allocation.width);
#line 190 "ease-scrollable-embed.vala"
	clutter_actor_set_height ((ClutterActor*) self->priv->stage, (float) ((GtkWidget*) self)->allocation.height);
#line 191 "ease-scrollable-embed.vala"
	clutter_actor_set_width ((ClutterActor*) self->priv->viewport, (float) ((GtkWidget*) self)->allocation.width);
#line 192 "ease-scrollable-embed.vala"
	clutter_actor_set_height ((ClutterActor*) self->priv->viewport, (float) ((GtkWidget*) self)->allocation.height);
#line 404 "ease-scrollable-embed.c"
}


/**
 * When grabbing focus, grab it on the embed.
 */
#line 198 "ease-scrollable-embed.vala"
static void ease_scrollable_embed_real_grab_focus (GtkWidget* base) {
#line 413 "ease-scrollable-embed.c"
	EaseScrollableEmbed * self;
	self = (EaseScrollableEmbed*) base;
#line 200 "ease-scrollable-embed.vala"
	gtk_widget_grab_focus ((GtkWidget*) self->priv->embed);
#line 418 "ease-scrollable-embed.c"
}


ClutterGroup* ease_scrollable_embed_get_contents (EaseScrollableEmbed* self) {
	ClutterGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_contents;
#line 30 "ease-scrollable-embed.vala"
	return result;
#line 428 "ease-scrollable-embed.c"
}


static void ease_scrollable_embed_set_contents (EaseScrollableEmbed* self, ClutterGroup* value) {
	ClutterGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_contents = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_contents), _tmp0_);
	g_object_notify ((GObject *) self, "contents");
}


gboolean ease_scrollable_embed_get_has_horizontal (EaseScrollableEmbed* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_horizontal;
#line 44 "ease-scrollable-embed.vala"
	return result;
#line 446 "ease-scrollable-embed.c"
}


static void ease_scrollable_embed_set_has_horizontal (EaseScrollableEmbed* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_horizontal = value;
	g_object_notify ((GObject *) self, "has-horizontal");
}


float ease_scrollable_embed_get_width (EaseScrollableEmbed* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = clutter_actor_get_width ((ClutterActor*) self->priv->stage);
#line 49 "ease-scrollable-embed.vala"
	return result;
#line 463 "ease-scrollable-embed.c"
}


float ease_scrollable_embed_get_height (EaseScrollableEmbed* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = clutter_actor_get_height ((ClutterActor*) self->priv->stage);
#line 54 "ease-scrollable-embed.vala"
	return result;
#line 473 "ease-scrollable-embed.c"
}


static void ease_scrollable_embed_class_init (EaseScrollableEmbedClass * klass) {
	ease_scrollable_embed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseScrollableEmbedPrivate));
	GTK_WIDGET_CLASS (klass)->grab_focus = ease_scrollable_embed_real_grab_focus;
	G_OBJECT_CLASS (klass)->get_property = ease_scrollable_embed_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_scrollable_embed_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_scrollable_embed_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SCROLLABLE_EMBED_CONTENTS, g_param_spec_object ("contents", "contents", "contents", CLUTTER_TYPE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SCROLLABLE_EMBED_HAS_HORIZONTAL, g_param_spec_boolean ("has-horizontal", "has-horizontal", "has-horizontal", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The width of this ScrollableEmbed's Stage.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SCROLLABLE_EMBED_WIDTH, g_param_spec_float ("width", "width", "width", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The height of this ScrollableEmbed's Stage.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SCROLLABLE_EMBED_HEIGHT, g_param_spec_float ("height", "height", "height", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void ease_scrollable_embed_instance_init (EaseScrollableEmbed * self) {
	self->priv = EASE_SCROLLABLE_EMBED_GET_PRIVATE (self);
}


static void ease_scrollable_embed_finalize (GObject* obj) {
	EaseScrollableEmbed * self;
	self = EASE_SCROLLABLE_EMBED (obj);
	_g_object_unref0 (self->priv->embed);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->stage);
	_g_object_unref0 (self->priv->_contents);
	_g_object_unref0 (self->priv->h_scrollbar);
	_g_object_unref0 (self->priv->v_scrollbar);
	_g_object_unref0 (self->priv->h_padder);
	_g_object_unref0 (self->priv->v_padder);
	_g_object_unref0 (self->priv->h_adjust);
	_g_object_unref0 (self->priv->v_adjust);
	_g_object_unref0 (self->priv->z_adjust);
	G_OBJECT_CLASS (ease_scrollable_embed_parent_class)->finalize (obj);
}


/**
 * A GtkClutter.Embed with scrollbars 
 *
 * A ScollableEmbed contains a {@link GtkClutter.Viewport} within a
 * {@link GtkClutter.Embed}. The horizontal scrollbar is optional.
 */
GType ease_scrollable_embed_get_type (void) {
	static volatile gsize ease_scrollable_embed_type_id__volatile = 0;
	if (g_once_init_enter (&ease_scrollable_embed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseScrollableEmbedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_scrollable_embed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseScrollableEmbed), 0, (GInstanceInitFunc) ease_scrollable_embed_instance_init, NULL };
		GType ease_scrollable_embed_type_id;
		ease_scrollable_embed_type_id = g_type_register_static (GTK_TYPE_HBOX, "EaseScrollableEmbed", &g_define_type_info, 0);
		g_once_init_leave (&ease_scrollable_embed_type_id__volatile, ease_scrollable_embed_type_id);
	}
	return ease_scrollable_embed_type_id__volatile;
}


static void ease_scrollable_embed_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseScrollableEmbed * self;
	self = EASE_SCROLLABLE_EMBED (object);
	switch (property_id) {
		case EASE_SCROLLABLE_EMBED_CONTENTS:
		g_value_set_object (value, ease_scrollable_embed_get_contents (self));
		break;
		case EASE_SCROLLABLE_EMBED_HAS_HORIZONTAL:
		g_value_set_boolean (value, ease_scrollable_embed_get_has_horizontal (self));
		break;
		case EASE_SCROLLABLE_EMBED_WIDTH:
		g_value_set_float (value, ease_scrollable_embed_get_width (self));
		break;
		case EASE_SCROLLABLE_EMBED_HEIGHT:
		g_value_set_float (value, ease_scrollable_embed_get_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_scrollable_embed_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseScrollableEmbed * self;
	self = EASE_SCROLLABLE_EMBED (object);
	switch (property_id) {
		case EASE_SCROLLABLE_EMBED_CONTENTS:
		ease_scrollable_embed_set_contents (self, g_value_get_object (value));
		break;
		case EASE_SCROLLABLE_EMBED_HAS_HORIZONTAL:
		ease_scrollable_embed_set_has_horizontal (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




