
/* Ekiga -- A VoIP and Video-Conferencing application
 * Copyright (C) 2000-2006 Damien Sandras
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 * Ekiga is licensed under the GPL license and as a special exception,
 * you have permission to link or otherwise combine this program with the
 * programs OPAL, OpenH323 and PWLIB, and distribute the combination,
 * without applying the requirements of the GNU GPL to the OPAL, OpenH323
 * and PWLIB programs, as long as you do follow the requirements of the
 * GNU GPL for all the rest of the software thus combined.
 */


/*
 *                         main_window.h  -  description
 *                         -----------------------------
 *   begin                : Mon Mar 26 2001
 *   copyright            : (C) 2000-2006 by Damien Sandras
 *   description          : This file contains all the functions needed to
 *                          build the main window.
 */


#ifndef _MAIN_INTERFACE_H
#define _MAIN_INTERFACE_H

#include "common.h"


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Press the given dialpad key.
 * PRE          :  The main window GMObject, the key to press (0 - 9, *, #).
 */
void gm_main_window_press_dialpad (GtkWidget *,
				   const char);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Updates the video area in the main window/local or remote
 * 		   popup with the given RGB buffer and the given destination
 * 		   size. The correct video area is udpated given the current
 * 		   display mode and if the given buffer is a buffer for local
 * 		   or remote video.
 * PRE          :  The main window GMObject, a valid RGB32 buffer, its width
 * 		   and height, the zoomed width and height, the display mode
 * 		   (see gdkvideoio.cpp), and if the given buffer is a remote
 * 		   or local video image. The last parameter indicates if
 * 		   there should be bilinear filtering or not.
 */
void gm_main_window_update_video (GtkWidget *,
				  const guchar *,
				  int,
				  int,
				  double,
				  const guchar *,
				  int,
				  int,
				  double,
				  int,
				  gboolean);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Displays the gnomemeeting logo in the video window.
 * PRE          :  The main window GMObject.
 */
void gm_main_window_update_logo (GtkWidget *);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the main window hold call menu and toolbar items
 * 		   following the call is on hold (TRUE) or not (FALSE).
 * PRE          :  The main window GMObject.
 */
void gm_main_window_set_call_hold (GtkWidget *,
				   gboolean);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the main window pause channel menu and toolbar items
 * 		   following the channel is paused (TRUE) or not (FALSE). The
 * 		   last argument is true if we are modifying a video channel
 * 		   item.
 * PRE          :  The main window GMObject.
 */
void gm_main_window_set_channel_pause (GtkWidget *,
				       gboolean,
				       gboolean);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the main window sensitivity and state following 
 * 		   the given calling state.
 * 		   The state of widgets that depend on the calling state only
 * 		   is updated: 
 * 		   - the sensitivity of menu and toolbar items,
 * 		   - the stay on top state of windows depending of the main 
 * 		   window, 
 * 		   - the state of the calling button,
 * 		   - the transfer call window,
 * 		   - the incoming call window can be destroyed or not.
 * 		   Widgets for which the state depends on other parameters
 * 		   are udpated in separate functions.
 * PRE          :  The main window GMObject.
 * 		   A valid GMH323Endpoint calling state.
 */
void gm_main_window_update_calling_state (GtkWidget *,
					  unsigned);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the main window sensitivity following the opened
 *                 and closed audio and video channels. It also updates
 *                 the state of the video preview button.
 * PRE          :  The main window GMObject.
 * 		   The first parameter is TRUE if we are updating video
 *                 channels related items, FALSE if we are updating audio
 *                 channels related items. The second parameter is TRUE
 *                 if we are transmitting audio (or video), the third is TRUE
 *                 if we are receiving audio (or video).
 */
void gm_main_window_update_sensitivity (GtkWidget *,
					BOOL,
					BOOL,
					BOOL);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the main window busy state. When the window is busy,
 *                 a busy cursor is displayed and you can not exit.
 * PRE          :  The main window GMObject.
 * 		   The first parameter is TRUE if we are busy.
 */
void gm_main_window_set_busy (GtkWidget *,
			      BOOL);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the main window video sliders to the given values,
 * 		   notice it only updates the GUI.
 * PRE          :  A valid pointer to the main window GMObject, followed
 * 		   by the whiteness, brightness, colourness and contrast.
 * 		   Their values must be comprised between -1 (no change) and 
 * 		   255.
 */
void gm_main_window_set_video_sliders_values (GtkWidget *,
					      int,
					      int,
					      int, 
					      int);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Gets the values for the main window video sliders and
 * 		   updates the parameters accordingly.
 * 		   Notice it only reads the values from the GUI, not from
 * 		   the video grabber.
 * PRE          :  A valid pointer to the main window GMObject, followed
 * 		   by the whiteness, brightness, colourness and contrast.
 * 		   Their values will be comprised between 0 and 255 when
 * 		   the function returns.
 */
void gm_main_window_get_video_sliders_values (GtkWidget *,
					      int &,
					      int &,
					      int &, 
					      int &);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the main window audio sliders to the given values,
 * 		   notice it only updates the GUI.
 * PRE          :  A valid pointer to the main window GMObject, followed
 * 		   by the output and input volumes.
 * 		   Their values must be comprised between -1 (no change) and 
 * 		   255.
 */
void gm_main_window_set_volume_sliders_values (GtkWidget *,
					       int, 
					       int);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the main window signal level meters.
 * PRE          :  A valid pointer to the main window GMObject, followed
 * 		   by the output and input signals.
 */
void gm_main_window_set_signal_levels (GtkWidget *,
				       float, 
				       float);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Clear the main window signal level meters.
 * PRE          :  /
 */
void gm_main_window_clear_signal_levels (GtkWidget *);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Gets the values of the main window audio sliders.
 * PRE          :  A valid pointer to the main window GMObject, followed
 * 		   by the output and input volumes.
 * 		   Their values will be comprised between 0 and 255 when 
 * 		   the function returns.
 */
void gm_main_window_get_volume_sliders_values (GtkWidget *,
					       int &, 
					       int &);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Change the view mode and update the menu.
 * PRE          :  The main window GMObject and a valid mode.
 */
void gm_main_window_set_view_mode (GtkWidget *,
				   ViewMode);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Select the correct control panel section in the menus
 * 		   and in the main window.
 * PRE          :  The main window GMObject and a valid section.
 */
void gm_main_window_set_control_panel_section (GtkWidget *,
					       int);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Select the incoming call mode for the main window.
 * PRE          :  The main window GMObject and a valid incoming call mode.
 */
void gm_main_window_set_incoming_call_mode (GtkWidget *,
					    IncomingCallMode);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Updates the information displayed in the info label
 * 		   of the main window.
 * PRE          :  The main window GMObject, 
 * 		   the transmitted audio codec, 
 * 		   the received audio codec (if any), 
 * 		   the transmitted video codec,
 * 		   the received video codec(if any).
 */
void gm_main_window_set_call_info (GtkWidget *,
				   const char *,
				   const char *,
				   const char *,
				   const char *);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Updates the information displayed in the info label
 * 		   of the main window.
 * PRE          :  The main window GMObject, 
 * 		   the number of "online" accounts.
 */
void gm_main_window_set_account_info (GtkWidget *,
				      int);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Sets the current status in the GUI.
 * PRE           : The main window GMObject.
 */
void gm_main_window_set_status (GtkWidget *,
				const char *);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the speed dials menu in the call menu given the
 *                 main window GMObject and using the address book.
 * PRE          :  The main window GMObject and the GSList of GmContacts.
 */
void gm_main_window_speed_dials_menu_update (GtkWidget *,
					     GSList *);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Update the urls in the cache of the url entry. It is done
 * 		   using the list of the last 100 given/received/missed calls,
 * 		   but also using the address book contacts.
 * PRE          :  The main window GMObject.
 */
void gm_main_window_urls_history_update (GtkWidget *);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Runs a dialog to transfer a call. 
 * 		   Returns TRUE if the user chose to transfer.
 * PRE          :  The main window GMObject, the parent window, the URL
 * 		   to put in the dialog as default.
 */
gboolean gm_main_window_transfer_dialog_run (GtkWidget *,
					     GtkWidget *,
					     const char *);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Creates a new incoming call popup and show it 
 * 		   as modal dialog.
 * PRE           : The main window GMObject.
 * 		   The name and the app in UTF-8 char * and the remote URL
 */
void gm_main_window_incoming_call_dialog_show (GtkWidget *,
					       gchar *,
					       gchar *,
					       gchar *);


/* DESCRIPTION  :  /
 * BEHAVIOR     :  Builds the main window and adds the popup to the image.
 * PRE          :  Accels.
 **/
GtkWidget *gm_main_window_new ();


/* DESCRIPTION   :  /
 * BEHAVIOR      : Flashes a message on the statusbar during a few seconds.
 *                 Removes the previous message.
 * PRE           : The main window GMObject, followed by printf syntax format.
 */
void gm_main_window_flash_message (GtkWidget *, 
				   const char *, 
				   ...);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Displays a message on the statusbar indicating the number
 * 		   of missed calls and voice mails.
 * PRE           : The main window GMObject, followed by the number of missed
 * 		   calls and the number of voice mails.
 */
void gm_main_window_push_message (GtkWidget *, 
				  int,
				  const char *);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Displays a message on the statusbar or clears it if msg = 0.
 *                 Removes the previous message.
 * PRE           : The main window GMObject, followed by printf syntax format.
 */
void gm_main_window_push_message (GtkWidget *, 
				  const char *, 
				  ...);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Displays an info message on the statusbar. An info message
 * 		   is only cleared when the user clicks on it.
 * PRE           : The main window GMObject, followed by printf syntax format.
 */
void gm_main_window_push_info_message (GtkWidget *, 
				       const char *, 
				       ...);

/* DESCRIPTION   :  /
 * BEHAVIOR      : Sets the given URL as called URL.
 * PRE           : The main window GMObject.
 */
void gm_main_window_set_call_url (GtkWidget *, 
				  const char *);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Appends the given string to the current URL. Replaces the 
 * 		   current selection if any.
 * PRE           : The main window GMObject.
 */
void gm_main_window_append_call_url (GtkWidget *, 
				     const char *);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Returns the currently called URL in the URL bar.
 * PRE           : The main window GMObject.
 */
const char *gm_main_window_get_call_url (GtkWidget *);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Clears the stats area in the control panel. 
 * PRE           : The main window GMObject.
 */
void gm_main_window_clear_stats (GtkWidget *);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Updates the stats area in the control panel. 
 * PRE           : The main window GMObject, lost, late packets, rtt, jitter,
 * 		   video bytes received, transmitted, audio bytes received,
 * 		   transmitted. All >= 0.
 */
void gm_main_window_update_stats (GtkWidget *,
				  float,
				  float,
				  float,
				  int,
				  float,
				  float,
				  float,
				  float);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Returns the currently displayed picture as a pixbuf.
 * PRE           : The main window GMObject.
 */
GdkPixbuf *gm_main_window_get_current_picture (GtkWidget *);


/* DESCRIPTION   :  /
 * BEHAVIOR      : Returns the currently displayed picture as a pixbuf.
 * PRE           : The main window GMObject.
 */
void gm_main_window_set_stay_on_top (GtkWidget *,
				     gboolean);
 

#endif

