/*
 *  Copyright (C) 2003 Marco Pesenti Gritti
 *  Copyright (C) 2004 Christian Persch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: mozilla-sample.h,v 1.1 2004/01/15 16:54:41 chpe Exp $
 */

#ifndef MOZILLA_IMAGES_H
#define MOZILLA_IMAGES_H

#include <glib.h>

#include <epiphany/ephy-embed.h>
#include <epiphany/ephy-embed-event.h>

G_BEGIN_DECLS

typedef enum
{
	EMBED_CAP_JAVASCRIPT,
	EMBED_CAP_PLUGINS,
	EMBED_CAP_IMAGES,
	EMBED_CAP_HISTORY
} EphyEmbedCapability;

void	 ephy_embed_set_capability	(EphyEmbed *embed,
					 EphyEmbedCapability cap,
					 gboolean enable);

gboolean ephy_embed_get_capability	(EphyEmbed *embed,
					 EphyEmbedCapability cap);

void	 ephy_embed_load_images		(EphyEmbed *embed);

G_END_DECLS

#endif
