/*
 *  Copyright (C) 2003 Marco Pesenti Gritti
 *  Copyright (C) 2004 Christian Persch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: mozilla-sample.cpp,v 1.1 2004/01/15 16:54:41 chpe Exp $
 */

#include "mozilla-config.h"

#include "config.h"

#include "mozilla-helpers.h"

#include <nsCOMPtr.h>
#include <nsIWebBrowser.h>
#include <nsIWebBrowserSetup.h>
#include <gtkmozembed.h>
#include <gtkmozembed_internal.h>
#include <nsIInterfaceRequestorUtils.h>
#include <nsIDOMDocument.h>
#include <nsIDOMNodeList.h>
#include <nsIDOMNode.h>
#include <nsIDOMHTMLImageElement.h>
#include <nsISimpleEnumerator.h>
#undef MOZILLA_INTERNAL_API
#include <nsEmbedString.h>
#define MOZILLA_INTERNAL_API 1

#define ALLOW_PRIVATE_API

#ifdef ALLOW_PRIVATE_API
#include <nsIDocShell.h>
#include <nsIDocShellHistory.h>
#include <nsIDocShellTreeItem.h>
#endif

typedef nsresult (* ForallCallback) (nsIDocShell *, void *);

static nsresult
ForallDocShells (nsIDocShell *aRootDocShell,
	         ForallCallback aCallback,
		 void *aData)
{
	NS_ENSURE_ARG (aRootDocShell);

        nsCOMPtr<nsISimpleEnumerator> enumerator;
        aRootDocShell->GetDocShellEnumerator(nsIDocShellTreeItem::typeContent,
                                             nsIDocShell::ENUMERATE_FORWARDS,
                                             getter_AddRefs (enumerator));
        NS_ENSURE_TRUE (enumerator, NS_ERROR_FAILURE);

	PRBool hasMore;
	while (NS_SUCCEEDED(enumerator->HasMoreElements (&hasMore)) && hasMore)
	{
		nsCOMPtr<nsISupports> element;
		enumerator->GetNext (getter_AddRefs (element));
		if (!element) continue;

		nsCOMPtr<nsIDocShell> docShell (do_QueryInterface (element));
		if (!docShell) continue;

		aCallback (docShell, aData);
	}

	return NS_OK;
}

static PRUnichar kImgLiteral[] = { 'i', 'm', 'g', '\0' };

static nsresult
LoadImagesInDocShell (nsIDocShell *aDocShell,
		      void *aData)
{
	nsCOMPtr<nsIDOMDocument> domDoc (do_GetInterface (aDocShell));
	if (!domDoc) return NS_OK;

	nsCOMPtr<nsIDOMNodeList> images;
	domDoc->GetElementsByTagName (nsEmbedString(kImgLiteral), getter_AddRefs (images));
	if (!images) return NS_OK;

	PRBool isEnabled = PR_TRUE;
	aDocShell->GetAllowImages (&isEnabled);
	aDocShell->SetAllowImages (PR_TRUE);

	nsCOMPtr<nsIDOMNode> node;
	nsCOMPtr<nsIDOMHTMLImageElement> image;
	nsEmbedString src, emptyString;
	nsresult rv;
	PRUint32 num = 0, i;
	images->GetLength (&num);
	for (i = 0; i < num; i++)
	{
		images->Item (i, getter_AddRefs (node));

		image = do_QueryInterface (node);
		if (image)
		{
			rv = image->GetSrc (src);
			if (NS_SUCCEEDED (rv) && src.Length())
			{
				image->SetSrc (emptyString);
				image->SetSrc (src);
			}
		}

		node = nsnull;
	}

	aDocShell->SetAllowImages (isEnabled);

	return NS_OK;
}

extern "C" void
ephy_embed_set_capability (EphyEmbed *embed,
			   EphyEmbedCapability cap,
			   gboolean enable)
{
	g_return_if_fail (EPHY_IS_EMBED (embed));

	nsCOMPtr<nsIWebBrowser> browser;
	gtk_moz_embed_get_nsIWebBrowser (GTK_MOZ_EMBED (embed), getter_AddRefs (browser));

	nsCOMPtr<nsIWebBrowserSetup> setup (do_QueryInterface (browser));
	NS_ENSURE_TRUE (setup, );

	PRUint32 mcap = 0;

	switch (cap)
	{
		case EMBED_CAP_JAVASCRIPT:
			mcap = nsIWebBrowserSetup::SETUP_ALLOW_JAVASCRIPT;
			break;
		case EMBED_CAP_PLUGINS:
			mcap = nsIWebBrowserSetup::SETUP_ALLOW_PLUGINS;
			break;
		case EMBED_CAP_IMAGES:
			mcap = nsIWebBrowserSetup::SETUP_ALLOW_IMAGES;
			break;
		case EMBED_CAP_HISTORY:
			mcap = nsIWebBrowserSetup::SETUP_USE_GLOBAL_HISTORY;
			break;
		default:
			g_assert_not_reached ();
			break;
	}

	PRUint32 value = enable ? PR_TRUE : PR_FALSE;
	nsresult rv;
	rv = setup->SetProperty (mcap, value);
	NS_ENSURE_SUCCESS (rv, );
}

extern "C" gboolean
ephy_embed_get_capability (EphyEmbed *embed,
			   EphyEmbedCapability cap)
{
	/* NOTE: the dumb nsIWebBrowserSetup interface doesn't support
	 * GETTING the current value, so I have to implement it myself.
	 */

	g_return_val_if_fail (EPHY_IS_EMBED (embed), TRUE);

	nsCOMPtr<nsIWebBrowser> browser;
	gtk_moz_embed_get_nsIWebBrowser (GTK_MOZ_EMBED (embed), getter_AddRefs (browser));
	NS_ENSURE_TRUE (browser, TRUE);

	nsCOMPtr<nsIDocShell> docshell = do_GetInterface (browser);
	NS_ENSURE_TRUE (docshell, TRUE);

	PRBool value;
	nsresult rv;
	switch (cap)
	{
		case EMBED_CAP_JAVASCRIPT:
			rv = docshell->GetAllowJavascript (&value);
			break;
		case EMBED_CAP_PLUGINS:
			rv = docshell->GetAllowPlugins (&value);
			break;
		case EMBED_CAP_IMAGES:
			rv = docshell->GetAllowImages (&value);
			break;
		case EMBED_CAP_HISTORY:
		{
			nsCOMPtr<nsIDocShellHistory> dsh = do_QueryInterface (docshell);
			g_return_val_if_fail (dsh, TRUE);
			NS_ENSURE_TRUE (dsh, TRUE);
			rv = dsh->GetUseGlobalHistory (&value);
			break;
		}
		default:
			g_return_val_if_reached (TRUE);
			break;
	}
	g_return_val_if_fail (NS_SUCCEEDED (rv), TRUE);
	NS_ENSURE_SUCCESS (rv, TRUE);

	return value != PR_FALSE;
}			  

extern "C" void
ephy_embed_load_images (EphyEmbed *embed)
{
	g_return_if_fail (EPHY_IS_EMBED (embed));

	nsCOMPtr<nsIWebBrowser> browser;
	gtk_moz_embed_get_nsIWebBrowser (GTK_MOZ_EMBED (embed), getter_AddRefs (browser));
	NS_ENSURE_TRUE (browser, );

	nsCOMPtr<nsIDocShell> rootDocShell (do_GetInterface (browser));
	NS_ENSURE_TRUE (rootDocShell, );

	ForallDocShells (rootDocShell, LoadImagesInDocShell, nsnull);
}
