/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Terry Hayes <thayes@netscape.com>
 *   Javier Delgadillo <javi@netscape.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK *****
 *
 *  Copyright (C) 2005 Christian Persch
 *
 *  $Id: GtkNSSSecurityWarningDialogs.h,v 1.3 2006/05/10 18:07:00 chpe Exp $
 */

#ifndef GTK_NSSSECURITYDIALOGS_H
#define GTK_NSSSECURITYDIALOGS_H

#include <gtk/gtkmessagedialog.h>

#include <nsISecurityWarningDialogs.h>

#define GTK_NSSSECURITYWARNINGDIALOGS_CLASSNAME	"Epiphany Security Warning Dialogs Class"
#define GTK_NSSSECURITYWARNINGDIALOGS_CID \
{								\
	/* 1f5eac0a-d7e3-4f8e-b4d5-7240f7cba269 */		\
	0x1f5eac0a,						\
	0xd7e3,							\
	0x4f8e,							\
	{ 0xb4, 0xd5, 0x72, 0x40, 0xf7, 0xcb, 0xa2, 0x69 }	\
}

class GtkNSSSecurityWarningDialogs : public nsISecurityWarningDialogs
{
public:
	NS_DECL_ISUPPORTS
	NS_DECL_NSISECURITYWARNINGDIALOGS
	
	GtkNSSSecurityWarningDialogs();
	virtual ~GtkNSSSecurityWarningDialogs();
	
protected:
	void DoDialog (nsIInterfaceRequestor *aContext,
		       const char *aPrefName,
		       GtkMessageType aType,
		       GtkButtonsType aButtons,
		       int aDefaultResponse,
		       const char *aTitle,
		       const char *aPrimary,
		       const char *aSecondary,
		       const char *aButtonText,
		       PRBool *_retval);
};

#endif /* !GTK_NSSSECURITYDIALOGS_H */
