/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 *  Copyright © 2019 Jan-Michael Brummer <jan.brummer@tabos.org>
 *
 *  This file is part of Epiphany.
 *
 *  Epiphany is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Epiphany is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Epiphany.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "config.h"
#include "ephy-desktop-utils.h"

#include <gtk/gtk.h>

gboolean
is_desktop_pantheon (void)
{
  const gchar *xdg_current_desktop = g_getenv ("XDG_CURRENT_DESKTOP");

  if (!xdg_current_desktop)
    return FALSE;

  return strstr (xdg_current_desktop, "Pantheon") != NULL;
}

GtkIconSize
get_icon_size (void)
{
  if (is_desktop_pantheon ())
    return GTK_ICON_SIZE_LARGE_TOOLBAR;

  return GTK_ICON_SIZE_BUTTON;
}
